[%%shared
(* This file was generated by Ocsigen Start.
   Feel free to use it, modify it, and redistribute it as you wish. *)
(* Tongue demo *)

open Eliom_content.Html.F]

(* Service for this demo *)
let%server service =
  Eliom_service.create
    ~path:(Eliom_service.Path ["demo-tongue"])
    ~meth:(Eliom_service.Get Eliom_parameter.unit) ()

(* Make service available on the client *)
let%client service = ~%service
(* Name for demo menu *)
let%shared name () = [%i18n Demo.S.tongue_1]
(* Class for the page containing this demo (for internal use) *)
let%shared page_class = "os-page-demo-tongue"

(* Page for this demo *)
let%shared page () =
  let content =
    [ div ~a:[a_class ["demo-tongue-1"]] []
    ; div ~a:[a_class ["demo-tongue-2"]] []
    ; div ~a:[a_class ["demo-tongue-3"]] []
    ; div ~a:[a_class ["demo-tongue-4"]] []
    ; div ~a:[a_class ["demo-tongue-5"]] []
    ; div ~a:[a_class ["demo-tongue-6"]] [] ]
  in
  let tongue =
    Ot_tongue.tongue ~side:`Bottom
      ~stops:[`Px 70; `Interval (`Percent 100, `Full_content)]
      ~init:(`Px 70) content
  in
  Lwt.return
    [ h1 [%i18n Demo.tongue_1]
    ; p [%i18n Demo.ot_tongue_1]
    ; div ~a:[a_class ["demo-tongue"]] [tongue.Ot_tongue.elt] ]
