/* $Id: stats.c,v 1.4 1999/09/18 07:45:26 proff Exp $
 * $Copyright$
 */

#include "nglobal.h"
#include "article.h"

#include "stats.h"
#include "http.h"

EXPORT struct stats *Stats = NULL;

EXPORT void loadStats (char *f)
{
	int fd;
	struct stats st;
	Stats = XMmalloc (sizeof(*Stats));
	fd = open (f, O_RDONLY);
	if (fd >= 0)
	{
		if (read (fd, &st, sizeof st) != sizeof st)
		{
			loge (("statistics file '%s' corrupted...unlinking", f));
			close (fd);
			unlink (f);
		}  else
		if (st.version != STATS_VERSION)
		{
			char buf[MAX_PATH];
			sprintf (buf, "%s.%d", f, st.version);
			loge (("statistics file '%s' version %d, require version %d...renaming old file to '%s'", f, st.version, STATS_VERSION, buf));
			link(f, buf);
			unlink(f);
		} else
		{
			memcpy (Stats, &st, sizeof st);
			close (fd);
			goto good;
		}
		close (fd);
	}
	memset (Stats, 0, sizeof(*Stats));
	Stats->statsStarted = time (NULL);
	Stats->version = STATS_VERSION;
good:
	if (f_cleanSlate)
		memset(Stats->list_stats, 0, sizeof Stats->list_stats);
	Stats->invocations++;
	Stats->clientsActive = 0;
	Stats->task_high = 0;
	Stats->masterStarted = time (NULL);
	CS = &Stats->cache_stats[c_none];
}

EXPORT bool saveStats (char *f)
{
	int fd;
	statsUpdateMaster ();
	fd = open (f, O_WRONLY | O_CREAT, 0664);
	if (write (fd, Stats, sizeof *Stats) != sizeof *Stats)
	{
		loge (("error during write of '%s'", f));
		close (fd);
		unlink (f);
		return FALSE;
	}
	close (fd);
	return TRUE;
}

EXPORT void statsUpdateMaster ()
{
	static unsigned long U, S;
	static time_t T;
	unsigned long u, s;
	time_t t;
	assert(Task);
	if (Task->ti_state != nc_master)
	    return;
	time(&t);
	if (T != t)
	    {
		struct tms tms;
		times(&tms);
		u = tms.tms_utime;
		Stats->task_stats[Task->ti_state].cpu_user += u-U;
		U = u;
		s = tms.tms_stime;
		Stats->task_stats[Task->ti_state].cpu_system += s-S;
		S = s;
	    }
	if (T == 0)
	    {
		T = t;
	    }
	else
	    {
		if (t>T)
		    {
			Stats->task_stats[Task->ti_state].elapsed += t-T;
			T = t;
		    }
	    }
}

