/* $Id: authinfo_passwd.c,v 1.2 2000/02/19 16:20:55 proff Exp $
 * $Copyright$
 */

#include "nglobal.h"
#include "password.h"

#ifdef AUTHINFO_PASSWD

#include "acc.h"
#include "reg.h"

#include "authinfo.h"
#include "authinfo_passwd.h"

/*
 * passwd authenticator.
 */

EXPORT authenticator passwd_authenticator = {
	authinfo_got_user,
	passwd_got_pass,
#ifdef notyet
	passwd_got_sasl,
#endif
};

/*
 * here are the "user", "pass" and (unsupported) "sasl" routines for an passwd
 * authenticator; note that these are EXPORT so we get prototypes for the
 * "passwd_authenticator" above, which hooks us into authinfo.c ...
 */

/* we use authinfo_got_user() */

EXPORT int passwd_got_pass(char *pass)
{
	int rv = 0;
	struct passwd *pw;

	if (authinfo_user == NULL) {
		emitf("%d USER required\r\n", NNTP_AUTH_REJECT_VAL);
		return FALSE;
	}
	if (pass && *pass) {
		pw = getpwnam(authinfo_user);
		if (pw != NULL)
			rv = strcmp(crypt(pass, pw->pw_passwd), pw->pw_passwd) == 0;
	}
	
	if (rv != 0) {
		emitf("%d Authentication accepted\r\n", NNTP_AUTH_OK_VAL);
		return TRUE;
	}
	emitf("%d Authentication rejected\r\n", NNTP_AUTH_REJECT_VAL);
	return FALSE;
}

#ifdef notyet
EXPORT int passwd_got_sasl(char *val)
{

}
#endif

#endif /* AUTHINFO_PASSWD */
