/* $Id: authinfo_ldap.c,v 1.1 1999/12/18 18:08:30 proff Exp $
 * $Copyright$
 */

#include "nglobal.h"

#ifdef AUTHINFO_LDAP

#include "acc.h"
#include "reg.h"

#include "authinfo.h"
#include "authinfo_ldap.h"

#ifdef HAVE_LIBLBER
#include "lber.h"
#define GET_LDERROR(ld)      (ld)->ld_errno
#else
#define GET_LDERROR(ld)      ldap_get_lderrno ( (ld), NULL, NULL)
#endif

#include "ldap.h"

/*
 * ldap authenticator.
 */

EXPORT authenticator ldap_authenticator = {
	authinfo_got_user,
	ldap_got_pass,
#ifdef notyet
	ldap_got_sasl,
#endif
};

/*
 * here are the "user", "pass" and (unsupported) "sasl" routines for an ldap
 * authenticator; note that these are EXPORT so we get prototypes for the
 * "ldap_authenticator" above, which hooks us into authinfo.c ...
 */

/* we use authinfo_got_user() */

EXPORT int ldap_got_pass(char *pass)
{
	LDAP *ld;
	char dnbuf[580], *dom, *usr;
	int lderr;

	if (authinfo_user == NULL) {
		emitf("%d USER required\r\n", NNTP_AUTH_REJECT_VAL);
		return FALSE;
	}

	if (!pass || strlen(pass) <= 0)
		return FALSE;

	usr = strtok(authinfo_user, "+@");
	sprintf(dnbuf, "cn=%s, %s", usr, con->ldapBase);
#if 0
	dom = strtok(NULL, "+@");
	if (dom == NULL)
		dom = con->ldapDomain;
	sprintf(dnbuf, "uniqueidentifier=%s_%s,ou=%s,%s", usr, dom, dom, con->ldapBase);
#endif

	/* get a handle to an LDAP connection */
#ifdef HAVE_LDAP_OPEN
	if ((ld = ldap_open(con->ldapServer, con->ldapPort)) == NULL)
#else    
#ifdef HAVE_LDAP_INIT
	if ((ld = ldap_init(con->ldapServer, con->ldapPort)) == NULL)
#else
#error "need ldap_open or ldap_init"
#endif
#endif
		logen(("LDAP ERROR: unable to init communication with ldap server %s for passwd check", con->ldapServer));
	
	lderr = ldap_bind_s(ld, dnbuf, pass, LDAP_AUTH_SIMPLE);
	if (lderr != LDAP_SUCCESS && lderr != LDAP_INVALID_CREDENTIALS && lderr != LDAP_INAPPROPRIATE_AUTH)
		logen(("LDAP ERROR: ldap user bind failed (%d): %s", lderr, ldap_err2string(GET_LDERROR(ld))));
	ldap_unbind(ld);
	memset(pass, strlen(pass), 0);
	if (lderr == LDAP_SUCCESS) {
		emitf("%d Authentication accepted\r\n", NNTP_AUTH_OK_VAL);
		return TRUE;
	}
	emitf("%d Authentication rejected\r\n", NNTP_AUTH_REJECT_VAL);
	return FALSE;
}

#ifdef notyet
EXPORT int ldap_got_sasl(char *val)
{

}
#endif

#endif /* AUTHINFO_LDAP */
