/*
 * Copyright (c) 1983, 1995, 1996 Eric P. Allman
 * Copyright (c) 1988, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* static char sccsid[] = "@(#)conf.c	8.333 (Berkeley) 1/21/97"; */

/*
 * fairly hacked about code originally from sendmail 8.8.4
 */

#include "../config.h"
#include "libproff.h"

#include "setproctitle.h"

#ifdef HAVE_SETPROCTITLE
EXPORT void initsetproctitle(int argc, char **argv, char **envp)
{
	return;
}
#else /* !HAVE_SETPROCTITLE */

/*
**  HP-UX -- tested for 8.07, 9.00, and 9.01.
**
**	If V4FS is defined, compile for HP-UX 10.0.
*/

#ifdef __hpux
# define SPT_TYPE	SPT_PSTAT
#endif

/*
** Linux
*/
#ifdef __linux__
# define SPT_PADCHAR	'\0'
#endif

/*
**  IBM AIX 3.x -- actually tested for 3.2.3
*/

#ifdef _AIX3
# define SPT_PADCHAR	'\0'	/* pad process title with nulls */
#endif

/*
**  IBM AIX 2.2.1 -- actually tested for osupdate level 2706+1773
**
**	From Mark Whetzel <markw@wg.waii.com>.
*/

#ifdef AIX			/* AIX/RT compiler pre-defines this */
# define SPT_PADCHAR	'\0'		/* pad process title with nulls */
#endif

#ifdef	DGUX
# define SPT_TYPE	SPT_NONE	/* don't use setproctitle */
#endif

/*
**  4.4 BSD
**
**	See also BSD defines.
*/

#if defined(BSD4_4) && !defined(__bsdi__)
# define SPT_TYPE	SPT_PSSTRINGS	/* use PS_STRINGS pointer */
#endif

/*
**  BSD/OS (was BSD/386) (all versions)
**	From Tony Sanders, BSDI
*/

#ifdef __bsdi__
#  define SPT_PADCHAR	'\0'	/* pad process title with nulls */
#endif

/*
**  FreeBSD / NetBSD / OpenBSD (all architectures, all versions)
**
**  4.3BSD clone, closer to 4.4BSD	for FreeBSD 1.x and NetBSD 0.9x
**  4.4BSD-Lite based			for FreeBSD 2.x and NetBSD 1.x
**
**	See also BSD defines.
*/

#if defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__)
#   undef SPT_TYPE
#   define SPT_TYPE	SPT_REUSEARGV
#   define SPT_PADCHAR	'\0'		/* pad process title with nulls */
#endif

/*
**  SCO Unix
**
**	This includes three parts:
**
**	The first is for SCO OpenServer 5.
**	(Contributed by Keith Reynolds <keithr@sco.COM>).
**
**		SCO OpenServer 5 has a compiler version number macro,
**		which we can use to figure out what version we're on.
**		This may have to change in future releases.
**
**	The second is for SCO UNIX 3.2v4.2/Open Desktop 3.0.
**	(Contributed by Philippe Brand <phb@colombo.telesys-innov.fr>).
**
**	The third is for SCO UNIX 3.2v4.0/Open Desktop 2.0 and earlier.
*/


/* SCO UNIX 3.2v4.0 Open Desktop 2.0 and earlier */
#ifdef _SCO_unix_
# define SPT_TYPE	SPT_SCO		/* write kernel u. area */
#endif

/*
**  Sequent DYNIX/ptx v2.0 (and higher)
**
**	For DYNIX/ptx v1.x, undefine HASSETREUID.
**
**	From Tim Wright <timw@sequent.com>.
**	Update from Jack Woolley <jwoolley@sctcorp.com>, 26 Dec 1995,
**		for DYNIX/ptx 4.0.2.
*/

#ifdef _SEQUENT_
# define SPT_TYPE	SPT_NONE	/* don't use setproctitle */
#endif

/*
**  Apollo DomainOS
**
**  From Todd Martin <tmartint@tus.ssi1.com> & Don Lewis <gdonl@gv.ssi1.com>
**
**  15 Jan 1994; updated 2 Aug 1995
**
*/

#ifdef apollo
# define SPT_TYPE	SPT_NONE	/* don't use setproctitle */
#endif

/*
**  NCR MP-RAS 2.x (SysVr4) with Wollongong TCP/IP
**
**	From Kevin Darcy <kevin@tech.mis.cfc.com>.
*/

#ifdef NCR_MP_RAS2
# define SPT_TYPE  SPT_NONE
#endif

/*
**  NCR MP-RAS 3.x (SysVr4) with STREAMware TCP/IP
**
**	From Tom Moore <Tom.Moore@DaytonOH.NCR.COM>
*/

#ifdef NCR_MP_RAS3
# define SPT_TYPE  SPT_NONE
#endif

#ifdef sony_news
# ifndef __svr4
# else
#   define SPT_TYPE	SPT_SYSMIPS	/* use sysmips() (OS 6.0.2 or later) */
# endif
#endif

/* make a copy of a string */
#define SPACELEFT(buf, ptr)  (sizeof buf - ((ptr) - buf))
#define MAXLINE        2048            /* max line length */

/*
**  SETPROCTITLE -- set process title for ps
**
**	Parameters:
**		fmt -- a printf style format string.
**		a, b, c -- possible parameters to fmt.
**
**	Returns:
**		none.
**
**	Side Effects:
**		Clobbers argv of our main procedure so ps(1) will
**		display the title.
*/

#define SPT_NONE	0	/* don't use it at all */
#define SPT_REUSEARGV	1	/* cover argv with title information */
#define SPT_BUILTIN	2	/* use libc builtin */
#define SPT_PSTAT	3	/* use pstat(PSTAT_SETCMD, ...) */
#define SPT_PSSTRINGS	4	/* use PS_STRINGS->... */
#define SPT_SYSMIPS	5	/* use sysmips() supported by NEWS-OS 6 */
#define SPT_SCO		6	/* write kernel u. area */

#ifndef SPT_TYPE
# define SPT_TYPE	SPT_REUSEARGV
#endif

#if SPT_TYPE != SPT_NONE && SPT_TYPE != SPT_BUILTIN

# if SPT_TYPE == SPT_PSTAT
#  include <sys/pstat.h>
# endif
# if SPT_TYPE == SPT_PSSTRINGS
#  include <machine/vmparam.h>
#  include <sys/exec.h>
#  ifndef PS_STRINGS	/* hmmmm....  apparently not available after all */
#   undef SPT_TYPE
#   define SPT_TYPE	SPT_REUSEARGV
#  else
#   ifndef NKPDE			/* FreeBSD 2.0 */
#    define NKPDE 63
typedef unsigned int	*pt_entry_t;
#   endif
#  endif
# endif

# if SPT_TYPE == SPT_PSSTRINGS
#  define SETPROC_STATIC	static
# else
#  define SETPROC_STATIC
# endif

# if SPT_TYPE == SPT_SYSMIPS
#  include <sys/sysmips.h>
#  include <sys/sysnews.h>
# endif

# if SPT_TYPE == SPT_SCO
#  include <sys/immu.h>
#  include <sys/dir.h>
#  include <sys/user.h>
#  include <sys/fs/s5param.h>
#  if PSARGSZ > MAXLINE
#   define SPT_BUFSIZE	PSARGSZ
#  endif
# endif

# ifndef SPT_PADCHAR
#  define SPT_PADCHAR	' '
# endif

# ifndef SPT_BUFSIZE
#  define SPT_BUFSIZE	MAXLINE
# endif

#endif /* SPT_TYPE != SPT_NONE && SPT_TYPE != SPT_BUILTIN */

/*
**  Pointers for setproctitle.
**	This allows "ps" listings to give more useful information.
*/

char		**Argv = NULL;		/* pointer to argument vector */
char		*LastArgv = NULL;	/* end of argv */

EXPORT void initsetproctitle(int argc, char **argv, char **envp)
{
	register int i;
	extern char **environ;

	/*
        **  Move the environment so setproctitle can use the space at
	**  the top of memory.
	*/

	for (i = 0; envp[i] != NULL; i++)
		continue;
	environ = (char **) Smalloc(sizeof (char *) * (i + 1));
	for (i = 0; envp[i] != NULL; i++)
		environ[i] = Sstrdup(envp[i]);
	environ[i] = NULL;

	/*
	**  Save start and extent of argv for setproctitle.
	*/

	Argv = argv;
	if (i > 0)
		LastArgv = envp[i - 1] + strlen(envp[i - 1]);
	else
		LastArgv = argv[argc - 1] + strlen(argv[argc - 1]);
}

EXPORT void setproctitle(const char *fmt, ...)
{
# if SPT_TYPE != SPT_NONE
	register char *p;
	register int i;
	SETPROC_STATIC char buf[SPT_BUFSIZE];
	va_list ap;
#  if SPT_TYPE == SPT_PSTAT
	union pstun pst;
#  endif
#  if SPT_TYPE == SPT_SCO
	off_t seek_off;
	static int kmem = -1;
	static int kmempid = -1;
	struct user u;
#  endif

	p = buf;

	/* print nntpcache: heading for grep */
	(void) strcpy(p, "nntpcache: ");
	p += strlen(p);

	/* print the argument string */
	va_start(ap, fmt);
	(void) vsnprintf(p, SPACELEFT(buf, p), fmt, ap);
	va_end(ap);

	i = strlen(buf);

#  if SPT_TYPE == SPT_PSTAT
	pst.pst_command = buf;
	pstat(PSTAT_SETCMD, pst, i, 0, 0);
#  endif
#  if SPT_TYPE == SPT_PSSTRINGS
	PS_STRINGS->ps_nargvstr = 1;
	PS_STRINGS->ps_argvstr = buf;
#  endif
#  if SPT_TYPE == SPT_SYSMIPS
	sysmips(SONY_SYSNEWS, NEWS_SETPSARGS, buf);
#  endif
#  if SPT_TYPE == SPT_SCO
	if (kmem < 0 || kmempid != getpid())
	{
		if (kmem >= 0)
			close(kmem);
		kmem = open(_PATH_KMEM, O_RDWR, 0);
		if (kmem < 0)
			return;
		(void) fcntl(kmem, F_SETFD, 1);
		kmempid = getpid();
	}
	buf[PSARGSZ - 1] = '\0';
	seek_off = UVUBLK + (off_t) u.u_psargs - (off_t) &u;
	if (lseek(kmem, (off_t) seek_off, SEEK_SET) == seek_off)
		(void) write(kmem, buf, PSARGSZ);
#  endif
#  if SPT_TYPE == SPT_REUSEARGV
	if (i > LastArgv - Argv[0] - 2)
	{
		i = LastArgv - Argv[0] - 2;
		buf[i] = '\0';
	}
	(void) strcpy(Argv[0], buf);
	p = &Argv[0][i];
	while (p < LastArgv)
		*p++ = SPT_PADCHAR;
	Argv[1] = NULL;
#  endif
# endif /* SPT_TYPE != SPT_NONE */
}

#endif /* !HAVE_SETPROCTITLE */
