
/*
 * $Header: /cvsroot/mpdist/mpdist/mptool/text.c,v 1.1.1.1 2002/04/12 16:47:25 richbastard Exp $
 * 
 * Copyright (c) 1987-2002 Rich Burridge, Sun Microsystems Inc.
 * All rights reserved.
 *
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include "text.h"

/* Main frame help strings. */

gchar *wi_main_frame_help;
gchar *wi_filename_help;
gchar *wi_preferences_help;
gchar *wi_headers_help;
gchar *wi_file_type_help;
gchar *wi_org_type_help;
gchar *wi_output_help;
gchar *wi_paper_size_help;
gchar *wi_subject_help;
gchar *wi_copies_help;
gchar *wi_no_sides_help;
gchar *wi_print_help;
gchar *wi_reset_help;
gchar *wi_menu_bar_help;
gchar *wi_exit_help;
gchar *wi_help_help;

/* Printing popup help strings. */

gchar *wi_props_frame_help;
gchar *wi_props_col_help;
gchar *wi_props_tab_help;
gchar *wi_props_margin_help;
gchar *wi_props_wrap_help;
gchar *wi_props_flip_help;
gchar *wi_props_forcepage_help;
gchar *wi_props_number_help;
gchar *wi_props_reverse_help;
gchar *wi_props_apply_help;
gchar *wi_props_defs_help;
gchar *wi_props_reset_help;
gchar *wi_props_dismiss_help;
gchar *wi_opt_header_help;
 
/* Username popup help strings. */
 
gchar *wi_un_form_help;
gchar *wi_un_apply_help;
gchar *wi_un_reset_help;
gchar *wi_un_dismiss_help;
gchar *wi_aliasname_help;
gchar *wi_props_passc_help;
gchar *wi_props_passw_help;
 
/* Output popup help strings. */
 
gchar *wi_output_frame_help;
gchar *wi_output_apply_help;
gchar *wi_output_reset_help;
gchar *wi_output_dismiss_help;
gchar *wi_output_bsd_help;
gchar *wi_line_length_help;
gchar *wi_page_length_help;
gchar *wi_printer_name_help;
 
/* Input popup help strings. */
 
gchar *wi_input_frame_help;
gchar *wi_prologue_help;
gchar *wi_opt_folder_help;
gchar *wi_opt_digest_help;
gchar *wi_props_elm_help;
gchar *wi_props_from_help;
gchar *wi_props_content_help;
gchar *wi_props_modtime_help;
gchar *wi_input_apply_help;
gchar *wi_input_reset_help;
gchar *wi_input_dismiss_help;

/* Header popup help strings. */
 
gchar *wi_header_frame_help;
gchar *wi_headers_all_help;
gchar *wi_hdr_list_help;
gchar *wi_hdr_add_help;
gchar *wi_hdr_apply_help;
gchar *wi_hdr_dismiss_help;
gchar *wi_hdr_remove_help;
gchar *wi_hdr_reset_help;
 
/* Help popup help strings. */
 
gchar *wi_help_text_help;
gchar *wi_help_dismiss_help;
 
/* Various miscellaneous strings. */
 
gchar *mptool_strs[MPTOOL_STRS_LEN];

 
void
init_text()
{
	char **s;

	wi_main_frame_help = g_strjoin("\n",
	  "General.",
	  "--------",
	  "The mp program is used to pretty print mail, news articles or ordinary",
	  "text files. There are now lots of command line options to mp which can",
	  "be used to setup various options to change the way the text is output.",
	  "These are not always easy to remember. The mptool program is provided",
	  "as a simpler means of setting these options and thereby making it",
	  "easier to print your files in the desired format.",
	  "",
	  "It is also possible to select text in another Motif application, and",
	  "drag and drop that text over the mptool open window, and it will be",
	  "automatically printed out using the current settings.",
	  NULL);

	wi_filename_help = g_strjoin("\n",
	  "Filenames.",
	  "----------",
	  "The file(s) to be printed. Note that this field can contain multiple",
	  "filenames. These should be separated by spaces. If any of the filenames",
	  "contain a space character, then that filename needs to be quoted.",
	  NULL);

	wi_preferences_help = g_strjoin("\n",
	  "Display a separate preferences window containing more options that",
	  "can be set to adjust how the files are printed.",
	  NULL);

	wi_headers_help = g_strjoin("\n",
	  "Display a separate window allowing you to set which mail or news",
	  "header lines you'd like printed.",
	  NULL);

	wi_file_type_help = g_strjoin("\n",
	  "Input type.",
	  "-----------",
	  "Determines the type of file(s) to be printed, and how they should be",
	  "printed. These fall into four types. All the file(s) are assumed to be",
	  "of the type specified.",
	  "",
	  "Mail       - File(s) are mail messages.",
	  "",
	  "News       - File(s) are USENET news articles.",
	  "",
	  "PostScript - File(s) are pure PostScript.",
	  "",
	  "Text       - File(s) are ordinary ASCII text files.",
	  "",
	  "Select the type you require.",
	  NULL);

	wi_org_type_help = g_strjoin("\n",
	  "Organiser.",
	  "----------",
	  "File(s) can be printed in various personal organiser formats. Mptool",
	  "supports the following types:",
	  "",
	  "Filofax, Franklin, Proplan, Time Manager, Time/System (International)",
	  "and Time/System (Partner).",
	  "",
	  "Select the one you require.",
	  NULL);

	wi_output_help = g_strjoin("\n",
	  "Output type.",
	  "------------",
	  "Output will be printed in either portrait, landscape or a personal",
	  "organiser mode depending upon how you set this option.",
	  NULL);

	wi_paper_size_help = g_strjoin("\n",
	  "Paper Size.",
	  "-----------",
	  "Specifies the paper size to assume when output text. There are three",
	  "choices:",
	  "",
	  "None - Will use the full size of the paper.",
	  "A4   - Use A4 paper size (8.5 x 11.4 inches).",
	  "US   - Use US paper size (8.5 x 11   inches).",
	  NULL);

	wi_subject_help = g_strjoin("\n",
	  "Subject.",
	  "--------",
	  "What you type into this textfield will be used as the subject for the",
	  "printout. If you are printing ordinary ASCII files the subject will",
	  "default to the name of each of these files.",
	  NULL);

	wi_line_length_help = g_strjoin("\n",
	  "Line Length.",
	  "------------",
	  "This will be the maximum number of characters on each line of output.",
	  "This value will override the default value in the prologue file.",
	  NULL);

	wi_page_length_help = g_strjoin("\n",
	  "Page Length.",
	  "------------",
	  "This will be the maximum number of lines on each page of output. This",
	  "value will override the default value in the prologue file.",
	  NULL);

	wi_copies_help = g_strjoin("\n",
	  "Copies.",
	  "-------",
	  "The number of copies of each file, that should be printed.",
	  NULL);

	wi_printer_name_help = g_strjoin("\n",
	  "Printer Name.",
	  "-------------",
	  "The name of the printer that the output should be sent to. If this",
	  "textfield is empty, than output will be sent to the default printer",
	  "(which is given by the PRINTER environment variable on BSD systems, or",
	  "by the LPDEST environment variable on System V systems).",
	  NULL);

	wi_no_sides_help = g_strjoin("\n",
	  "Number of Sides.",
	  "----------------",
	  "The number of sides to use when printing. Obviously two-sided printing",
	  "only works if the printer supports it.",
	  NULL);

	wi_print_help = g_strjoin("\n",
	  "Print.",
	  "------",
	  "When this button is pressed, the file(s) given, are printed, using the",
	  "current option settings.",
	  NULL);

	wi_reset_help = g_strjoin("\n",
	  "Reset.",
	  "------",
	  "Reset all the options in the main mptool window back to their default",
	  "values.",
	  NULL);

	wi_props_frame_help = g_strjoin("\n",
	  "Print Layout Options.",
	  "---------------------",
	  "This popup window contains printing options that are not so commonly",
	  "used. These options can just be applied to the current print run, or",
	  "they can be made the default.",
	  NULL);

	wi_aliasname_help = g_strjoin("\n",
	  "Alias Name.",
	  "-----------",
	  "The user name alias that should be printed out in the mp banner",
	  "heading, to show who the output is for. This will override the",
	  "NAME environment variable and the users entry in the password file.",
	  NULL);

	wi_prologue_help = g_strjoin("\n",
	  "Prologue Name.",
	  "--------------",
	  "The name of the POSTSCRIPT prologue file that should be used to",
	  "determine how the file(s) should be printed. This overrides any",
	  "any previously defined prologue file names.",
	  NULL);

	wi_props_col_help = g_strjoin("\n",
	  "Columns per page.",
	  "-----------------",
	  "The number of columns of output per page. This value will override",
	  "the default value in the prologue file.",
	  NULL);

	wi_props_tab_help = g_strjoin("\n",
	  "Spaces per Tab character.",
	  "-------------------------",
	  "The number of spaces to output when encountering a tab character.",
	  NULL);

	wi_props_margin_help = g_strjoin("\n",
	  "Margin sizes.",
	  "-------------",
	  "The size (in points) to set this margin to. There are approximately",
	  "72 points in an inch.",
	  NULL);

	wi_props_passc_help = g_strjoin("\n",
	  "Characters in User Name.",
	  "------------------------",
	  "The maximum number of characters to extract from the gecos field of",
	  "the users /etc/passwd entry.",
	  NULL);

	wi_props_passw_help = g_strjoin("\n",
	  "Words in User Name.",
	  "-------------------",
	  "The maximum number of words to extract from the gecos field of the",
	  "users /etc/passwd entry.",
	  NULL);

	wi_opt_header_help = g_strjoin("\n",
	  "Print header page.",
	  "------------------",
	  "If this option is checked, than the initial banner page is not printed.",
	  "Most of the information that typically appears on the banner sheet is",
	  "output in the mp banners.",
	  NULL);

	wi_opt_folder_help = g_strjoin("\n",
	  "Folders.",
	  "--------",
	  "If this option is checked, then the input file(s) are assumed to be",
	  "mail folders, and mp will search for multiple mail messages in each",
	  "file.",
	  NULL);

	wi_opt_digest_help = g_strjoin("\n",
	  "Digests.",
	  "--------",
	  "If this option is checked, then the output is formatted as a mail",
	  "digest.",
	  NULL);

	wi_props_wrap_help = g_strjoin("\n",
	  "Wrap words.",
	  "-----------",
	  "If this option is checked, then words will be wrapped onto the next",
	  "line of output.",
	  NULL);

	wi_props_flip_help = g_strjoin("\n",
	  "Flip banners.",
	  "-------------",
	  "If this option is checked, then the top and bottom banners of the",
	  "output on each page will be flipped.",
	  NULL);

	wi_props_forcepage_help = g_strjoin("\n",
	  "Force new page.",
	  "---------------",
	  "If this option is checked, then mptool will always start a new page",
	  "(rather than a new column) when in landscape or multi-page personal",
	  "organiser mode.",
	  NULL);

	wi_props_elm_help = g_strjoin("\n",
	  "Elm mail format.",
	  "----------------",
	  "If this option is checked, then mptool assumes the ELM mail frontend",
	  "intermediate file format. Used when printing messages from within ELM",
	  "(using the \"p\" command), especially for printing tagged messages.",
	  "This option must be specified in your ELM option setup.",
	  NULL);

	wi_props_number_help = g_strjoin("\n",
	  "Number each line.",
	  "-----------------",
	  "If this option is checked, then each line output will be numbered.",
	  NULL);

	wi_props_from_help = g_strjoin("\n",
	  "From header.",
	  "------------",
	  "If this option is checked, instead of printing who the mail article",
	  "is for, the header will contain who the mail article is from. A",
	  "useful option for people with their own personal printer.",
	  NULL);

	wi_props_content_help = g_strjoin("\n",
	  "Content-Length.",
	  "---------------",
	  "If this option is checked, instead of using \"From\" to denote the",
	  "start of new mail messages, mp will look for (and use) the value of",
	  "the Content-Length: mail header. If the Content-Length doesn't take",
	  "you to the next \"From\", then it's wrong, and mp falls back to",
	  "looking for the next \"From\" in the mail folder.",
	  NULL);

	wi_props_modtime_help = g_strjoin("\n",
	  "File modification time.",
	  "-----------------------",
	  "If this option is checked, then mptool uses the files last modification",
	  "time (rather than the current time) in each page banner.",
	  NULL);

	wi_props_reverse_help = g_strjoin("\n",
	  "Adjust reverse page.",
	  "--------------------",
	  "If this option is checked, and if we are printing two sides per page,",
	  "then adjust the alignment of the reverse page.",
	  NULL);

	wi_props_apply_help = g_strjoin("\n",
	  "Apply.",
	  "------",
	  "You must select the Apply button before the printing options currently",
	  "set in this popup window are applied.",
	  NULL);

	wi_props_defs_help = g_strjoin("\n",
	  "Save as defaults.",
	  "-----------------",
	  "Selecting the Save as Defaults option saves the current mp option",
	  "setting to the defaults the next time mptool is started.",
	  NULL);

	wi_props_reset_help = g_strjoin("\n",
	  "Reset.",
	  "------",
	  "Clicking on the Reset button on the printing popup, resets these",
	  "option values back to their default values.",
	  NULL);

	wi_props_dismiss_help = g_strjoin("\n",
	  "Dismiss.",
	  "--------",
	  "Clicking on the Dismiss button dismisses the print layout popup.",
	  NULL);

	wi_header_frame_help = g_strjoin("\n",
	  "Header Options.",
	  "---------------",
	  "This popup window contains header options that are not so commonly",
	  "used. These options can just be applied to the current print run, or",
	  "they can be made the default.",
	  NULL);

	wi_headers_all_help = g_strjoin("\n",
	  "Print all headers.",
	  "------------------",
	  "If you want all the headers in your mail and news messages to",
	  "be printed, check this option. This will over-ride any header",
	  "settings in the scrolling list.",
      NULL);

	wi_hdr_list_help = g_strjoin("\n",
	  "Header list.",
	  "------------",
	  "Initially this scrolling list contains all the mail headers that will",
	  "be printed, assuming they exist in the input file(s). You can add",
	  "extra headers to be printed, to this list, or remove some of the",
	  "existing list.",
	  NULL);

	wi_hdr_add_help = g_strjoin("\n",
	  "Add.",
	  "----",
	  "By default mp will print out a standard set of mail and news headers.",
	  "These headers are initially placed in the scrolling list. To add more",
	  "headers to this list, type the name of the new headers into the text",
	  "field below the list, and then press the Add button at the top of the",
	  "panel. If the new header isn't terminated with a ':' character, then",
	  "one is automatically added.",
	  NULL);

	wi_hdr_apply_help = g_strjoin("\n",
	  "Apply.",
	  "------",
	  "You must select the Apply button before the header options currently",
	  "set in this popup window are applied.",
	  NULL);

	wi_hdr_dismiss_help = g_strjoin("\n",
	  "Dismiss.",
	  "--------",
	  "Clicking on the Dismiss button dismisses the header popup.",
	  NULL);

	wi_hdr_remove_help = g_strjoin("\n",
	  "Remove.",
	  "-------",
	  "By default mp will print out a standard set of mail and news headers.",
	  "These headers are initially placed in the scrolling list. To remove a",
	  "header from this list, simply select it, then press the Remove button",
	  "at the top of the popup.",
	  NULL);

	wi_hdr_reset_help = g_strjoin("\n",
	  "Reset.",
	  "------",
	  "Clicking on the Reset button on the header popup, resets these",
	  "option values back to their default values.",
	  NULL);

	wi_input_frame_help = g_strjoin("\n",
	  "Input Options.",
	  "--------------",
	  "This popup window contains input options that are not so commonly",
	  "used. These options can just be applied to the current print run, or",
	  "they can be made the default.",
	  NULL);

	wi_input_apply_help = g_strjoin("\n",
	  "Apply.",
	  "------",
	  "You must select the Apply button before the input options currently",
	  "set in this popup window are applied.",
	  NULL);

	wi_input_reset_help = g_strjoin("\n",
	  "Reset.",
	  "------",
	  "Clicking on the Reset button on the input popup, resets these",
	  "option values back to their default values.",
	  NULL);

	wi_input_dismiss_help = g_strjoin("\n",
	  "Dismiss.",
	  "--------",
	  "Clicking on the Dismiss button dismisses the input popup.",
	  NULL);

	wi_output_frame_help = g_strjoin("\n",
	  "Output Options.",
	  "---------------",
	  "This popup window contains output options that are not so commonly",
	  "used. These options can just be applied to the current print run, or",
	  "they can be made the default.",
	  NULL);

	wi_output_apply_help = g_strjoin("\n",
	  "Apply.",
	  "------",
	  "You must select the Apply button before the output options currently",
	  "set in this popup window are applied.",
	  NULL);

	wi_output_reset_help = g_strjoin("\n",
	  "Reset.",
	  "------",
	  "Clicking on the Reset button on the output popup, resets these",
	  "option values back to their default values.",
	  NULL);

	wi_output_dismiss_help = g_strjoin("\n",
	  "Dismiss.",
	  "--------",
	  "Clicking on the Dismiss button dismisses the output popup.",
	  NULL);

	wi_un_form_help = g_strjoin("\n",
	  "User Name Options.",
	  "------------------",
	  "This popup window contains username options that are not so commonly",
	  "used. These options can just be applied to the current print run, or",
	  "they can be made the default.",
	  NULL);

	wi_un_apply_help = g_strjoin("\n",
	  "Apply.",
	  "------",
	  "You must select the Apply button before the username options",
	  "currently set in this popup window are applied.",
	  NULL);

	wi_un_reset_help = g_strjoin("\n",
	  "Reset.",
	  "------",
	  "Clicking on the Reset button on the username popup, resets these",
	  "option values back to their default values.",
	  NULL);

	wi_un_dismiss_help = g_strjoin("\n",
	  "Dismiss.",
	  "--------",
	  "Clicking on the Dismiss button dismisses the username popup.",
	  NULL);

	wi_menu_bar_help = g_strjoin("\n",
	  "The main mptool window contains the options and settings that you",
	  "would normally need to change to printout your files. There are",
	  "many more options to mp as well, most of them are not normally",
	  "changed. These are available on various configuration popups,",
	  "which are accessable through the Option setting on this menu bar.",
	  NULL);

	wi_exit_help = g_strjoin("\n",
	  "Selecting this option will terminate the mptool program.",
	  NULL);

	wi_help_help = g_strjoin("\n",
	  "Selecting an entry from this menu will bring up a popup window",
	  "giving more help information on this option.",
	  NULL);

	wi_output_bsd_help = g_strjoin("\n",
	  "BSD printer system.",
	  "-------------------",
	  "If the system you will be printing on is a BSD system (as opposed",
	  "to a System V system), then this option should be checked. A",
	  "different print command is needed in this case.",
	  NULL);

	wi_help_text_help = g_strjoin("\n",
	  "This popup window shows the help text associated with the option",
	  "you have selected.",
	  NULL);

	wi_help_dismiss_help = g_strjoin("\n",
	  "Clicking on the Dismiss button dismisses the help popup.",
	  NULL);


	/* The miscellaneous array. */

	s = mptool_strs;
	s[(int) S_USAGE] = "Mptool  -  Version %s";
	s[(int) S_NOTHING] = "Nothing to add.";
	s[(int) S_NONE] = "No items selected.";
	s[(int) S_INVCOL] = "Invalid number of columns per page. Resetting to %d\n";
	s[(int) S_INVTAB] = "Invalid number of space per tab. Resetting to %d\n";
	s[(int) S_INVLINE] = "Invalid line length. Resetting to %d\n";
	s[(int) S_INVPAGE] = "Invalid page length. Resetting to %d\n";
	s[(int) S_INVCOPIES] = "Invalid number of copies. Resetting to %d\n";
	s[(int) S_NOFILES] = "No files to print.";
	s[(int) S_START] = "Unable to start print job";
	s[(int) S_EXECUTE] = "Unable to execute print job";
	s[(int) S_INVCHARS] = "Invalid number of characters in user name. Resetting to %d\n";
	s[(int) S_INVWORDS] = "Invalid number of words in user name. Resetting to %d\n";
	s[(int) S_DRAGDROP] = "Couldn't write drag & drop text to %s\n";
	s[(int) S_BMARGIN] = "Invalid bottom margin size. Resetting to %d\n";
	s[(int) S_LMARGIN] = "Invalid left margin size. Resetting to %d\n";
	s[(int) S_RMARGIN] = "Invalid right margin size. Resetting to %d\n";
	s[(int) S_TMARGIN] = "Invalid top margin size. Resetting to %d\n";
}
