/* $NetBSD$ */

/*
 * Copyright (c) 1994,1995 Mark Brinicombe.
 * Copyright (c) 1994 Brini.
 * All rights reserved.
 *
 * This code is derived from software written for Brini by Mark Brinicombe
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Brini.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY BRINI ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL BRINI OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * RiscBSD kernel project
 *
 * setkbd.c
 *
 * Sets and reports the keyboard autorepeat rate
 *
 *    $Id$
 */

#include <sys/ioctl.h>
#include <sys/time.h>
#include <machine/kbd.h>
#include <stdio.h>
#include <fcntl.h>

#define KEYBOARD_DEVICE	"/dev/kbdctl"

int
main(argc, argv)
	int argc;
	char *argv[];
{
	int fd, param;
	int err;
	struct kbd_autorepeat kbdar; 

	if (argc > 3 || (argc > 1 && strstr (argv[1], "-h") != 0)) {
		fprintf(stderr, "usage: setkbd <delay> <rate>\n");
		exit(0);
	}
		
	fd = open(KEYBOARD_DEVICE, O_RDWR);
	if (fd == -1) {
		perror("Failed to open " KEYBOARD_DEVICE);
		exit(10);
	}

	err = ioctl(fd, KBD_GETAUTOREPEAT, &kbdar);
	if (err != 0) {
		perror("IOCTL failed\n");
		close(fd);
		exit(10);
	}

	printf("Current kbd autorepeat settings:\n");
	printf("\tDelay = %d\n", kbdar.ka_delay);
	printf("\tRate = %d chars / sec\n", kbdar.ka_rate);

	if (argc == 1) {
		close(fd);
		exit(0);
	}

	if (argc > 1)
		kbdar.ka_delay = atoi(argv[1]);

	if (argc > 2)
		kbdar.ka_rate = atoi(argv[2]);

	err = ioctl(fd, KBD_SETAUTOREPEAT, &kbdar);
	if (err != 0) {
		perror("IOCTL failed");
		close(fd);
		exit(10);
	}

	err = ioctl(fd, KBD_GETAUTOREPEAT, &kbdar);
	if (err != 0) {
		perror("IOCTL failed\n");
		close(fd);
		exit(10);
	}

	printf("New kbd autorepeat settings:\n");
	printf("\tDelay = %d\n", kbdar.ka_delay);
	printf("\tRate = %d chars / sec\n", kbdar.ka_rate);

	close(fd);
}

/* End of setkbd.c */
