/*
	  Manual Page Editor: Undo/Redo Management and Operation
 */
#ifndef EDITORUNDO_H
#define EDITORUNDO_H

#include <gtk/gtk.h>
#include "editor.h"


/*
 *	Undo Types:
 */
typedef enum {
	EDITOR_UNDO_REMOVE_CHARS,
	EDITOR_UNDO_INSERT_CHARS
} editor_undo_type;


/*
 *	Initial members for all undo structures:
 */
#define EDITOR_UNDO_COMMON_MEMBERS		\
	editor_undo_type	type;		\
	gchar		*comment;		\
	gpointer	editor_ptr;

/*
 *	Undo Common:
 */
typedef struct {

	EDITOR_UNDO_COMMON_MEMBERS

} editor_undo_common_struct;
#define EDITOR_UNDO_COMMON(p)	((editor_undo_common_struct *)(p))

/*
 *	Undo Remove Characters:
 */
typedef struct {

	EDITOR_UNDO_COMMON_MEMBERS

	GtkWidget	*w;		/* GtkText */

	gint		position,	/* Remove starting index */
			length;		/* Remove this many characters */

} editor_undo_remove_chars_struct;
#define EDITOR_UNDO_REMOVE_CHARS(p)	((editor_undo_remove_chars_struct *)(p))

/*
 *	Undo Insert Characters:
 */
typedef struct {

	EDITOR_UNDO_COMMON_MEMBERS

	GtkWidget	*w;		/* GtkText */

	gint		position,	/* Insert starting index */
			length;		/* Insert this many characters */

	gchar		*characters;	/* String to be inserted */

} editor_undo_insert_chars_struct;
#define EDITOR_UNDO_INSERT_CHARS(p)	((editor_undo_insert_chars_struct *)(p))


extern gpointer EditorUndoNew(
	editor_struct *editor, editor_undo_type type,
	const gchar *comment
);
extern void EditorUndoDelete(editor_struct *editor, gpointer u);

extern gint EditorUndoDoApply(
	editor_struct *editor,
	gpointer **in_list, gint *in_total,
	gpointer **out_list, gint *out_total,
	gint max
);


#endif	/* EDITORUNDO_H */
