/*
 * Definitions.cpp
 *
 *  Created on: 2 ���� 2014
 *      Author: hamilis
 */

#include "Definitions.h"
//#include "Chunk.cuh"
#ifdef __GPU
#include "GPU_FFT.cuh"
#endif
// MSVC does not know 0b prefix, better use 0x for masking
// undef this to go back to binary
#ifdef __GNUC__
//#define USE_HEX_REPRESENTATION
#else	// #ifdef GNUGC
#define USE_HEX_REPRESENTATION
#endif	// #ifdef GNUGC

namespace FFF {

	const unsigned int max_threads_machine = omp_get_max_threads();
#ifdef __PARALLEL__
	unsigned int omp_max_threads = omp_get_max_threads();
#else
	unsigned int omp_max_threads = 1;
#endif
	unsigned int log_omp_max_threads = log[omp_max_threads];

	void set_omp_state(int omt)
	{
#ifdef __PARALLEL__
		omp_max_threads = omt;
		log_omp_max_threads = log[omp_max_threads];
#else
		omp_max_threads = 1;
		log_omp_max_threads = 0;
#endif
	}

#ifdef __GPU
	chunk_cell_t taylorExp_masks[Chunk::log_elements_in_chunk+2]=
	{
			0,
			0,
			0x11111111,
			0x03030303,
			0x000f000f,
			0x000000ff,
			0x0000ffff
	};
	chunk_cell_t alter_masks[Chunk::log_elements_in_chunk+1]=
	{
			0,
			0x55555555,
			0x33333333,
			0x0f0f0f0f,
			0x00ff00ff,
			0x0000ffff
	};
	chunk_cell_t partition_byte[256] = {
#ifdef USE_HEX_REPRESENTATION
		0x0,  0x1,  0x10, 0x11, 0x2,  0x3,  0x12, 0x13,
		0x20, 0x21, 0x30, 0x31, 0x22, 0x23, 0x32, 0x33,
		0x4,  0x5,  0x14, 0x15, 0x6,  0x7,  0x16, 0x17,
		0x24, 0x25, 0x34, 0x35, 0x26, 0x27, 0x36, 0x37,
		0x40, 0x41, 0x50, 0x51, 0x42, 0x43, 0x52, 0x53,
		0x60, 0x61, 0x70, 0x71, 0x62, 0x63, 0x72, 0x73,
		0x44, 0x45, 0x54, 0x55, 0x46, 0x47, 0x56, 0x57,
		0x64, 0x65, 0x74, 0x75, 0x66, 0x67, 0x76, 0x77,
		0x8,  0x9,  0x18, 0x19, 0xa,  0xb,  0x1a, 0x1b,
		0x28, 0x29, 0x38, 0x39, 0x2a, 0x2b, 0x3a, 0x3b,
		0xc,  0xd,  0x1c, 0x1d, 0xe,  0xf,  0x1e, 0x1f,
		0x2c, 0x2d, 0x3c, 0x3d, 0x2e, 0x2f, 0x3e, 0x3f,
		0x48, 0x49, 0x58, 0x59, 0x4a, 0x4b, 0x5a, 0x5b,
		0x68, 0x69, 0x78, 0x79, 0x6a, 0x6b, 0x7a, 0x7b,
		0x4c, 0x4d, 0x5c, 0x5d, 0x4e, 0x4f, 0x5e, 0x5f,
		0x6c, 0x6d, 0x7c, 0x7d, 0x6e, 0x6f, 0x7e, 0x7f,
		0x80, 0x81, 0x90, 0x91, 0x82, 0x83, 0x92, 0x93,
		0xa0, 0xa1, 0xb0, 0xb1, 0xa2, 0xa3, 0xb2, 0xb3,
		0x84, 0x85, 0x94, 0x95, 0x86, 0x87, 0x96, 0x97,
		0xa4, 0xa5, 0xb4, 0xb5, 0xa6, 0xa7, 0xb6, 0xb7,
		0xc0, 0xc1, 0xd0, 0xd1, 0xc2, 0xc3, 0xd2, 0xd3,
		0xe0, 0xe1, 0xf0, 0xf1, 0xe2, 0xe3, 0xf2, 0xf3,
		0xc4, 0xc5, 0xd4, 0xd5, 0xc6, 0xc7, 0xd6, 0xd7,
		0xe4, 0xe5, 0xf4, 0xf5, 0xe6, 0xe7, 0xf6, 0xf7,
		0x88, 0x89, 0x98, 0x99, 0x8a, 0x8b, 0x9a, 0x9b,
		0xa8, 0xa9, 0xb8, 0xb9, 0xaa, 0xab, 0xba, 0xbb,
		0x8c, 0x8d, 0x9c, 0x9d, 0x8e, 0x8f, 0x9e, 0x9f,
		0xac, 0xad, 0xbc, 0xbd, 0xae, 0xaf, 0xbe, 0xbf,
		0xc8, 0xc9, 0xd8, 0xd9, 0xca, 0xcb, 0xda, 0xdb,
		0xe8, 0xe9, 0xf8, 0xf9, 0xea, 0xeb, 0xfa, 0xfb,
		0xcc, 0xcd, 0xdc, 0xdd, 0xce, 0xcf, 0xde, 0xdf,
		0xec, 0xed, 0xfc, 0xfd, 0xee, 0xef, 0xfe, 0xff
#else	// #ifdef USE_HEX_REPRESENTATION
		0b00000000, 0b00000001, 0b00010000, 0b00010001, 0b00000010, 0b00000011, 0b00010010, 0b00010011,
		0b00100000, 0b00100001, 0b00110000, 0b00110001, 0b00100010, 0b00100011, 0b00110010, 0b00110011,
		0b00000100, 0b00000101, 0b00010100, 0b00010101, 0b00000110, 0b00000111, 0b00010110, 0b00010111,
		0b00100100, 0b00100101, 0b00110100, 0b00110101, 0b00100110, 0b00100111, 0b00110110, 0b00110111,
		0b01000000, 0b01000001, 0b01010000, 0b01010001, 0b01000010, 0b01000011, 0b01010010, 0b01010011,
		0b01100000, 0b01100001, 0b01110000, 0b01110001, 0b01100010, 0b01100011, 0b01110010, 0b01110011,
		0b01000100, 0b01000101, 0b01010100, 0b01010101, 0b01000110, 0b01000111, 0b01010110, 0b01010111,
		0b01100100, 0b01100101, 0b01110100, 0b01110101, 0b01100110, 0b01100111, 0b01110110, 0b01110111,
		0b00001000, 0b00001001, 0b00011000, 0b00011001, 0b00001010, 0b00001011, 0b00011010, 0b00011011,
		0b00101000, 0b00101001, 0b00111000, 0b00111001, 0b00101010, 0b00101011, 0b00111010, 0b00111011,
		0b00001100, 0b00001101, 0b00011100, 0b00011101, 0b00001110, 0b00001111, 0b00011110, 0b00011111,
		0b00101100, 0b00101101, 0b00111100, 0b00111101, 0b00101110, 0b00101111, 0b00111110, 0b00111111,
		0b01001000, 0b01001001, 0b01011000, 0b01011001, 0b01001010, 0b01001011, 0b01011010, 0b01011011,
		0b01101000, 0b01101001, 0b01111000, 0b01111001, 0b01101010, 0b01101011, 0b01111010, 0b01111011,
		0b01001100, 0b01001101, 0b01011100, 0b01011101, 0b01001110, 0b01001111, 0b01011110, 0b01011111,
		0b01101100, 0b01101101, 0b01111100, 0b01111101, 0b01101110, 0b01101111, 0b01111110, 0b01111111,
		0b10000000, 0b10000001, 0b10010000, 0b10010001, 0b10000010, 0b10000011, 0b10010010, 0b10010011,
		0b10100000, 0b10100001, 0b10110000, 0b10110001, 0b10100010, 0b10100011, 0b10110010, 0b10110011,
		0b10000100, 0b10000101, 0b10010100, 0b10010101, 0b10000110, 0b10000111, 0b10010110, 0b10010111,
		0b10100100, 0b10100101, 0b10110100, 0b10110101, 0b10100110, 0b10100111, 0b10110110, 0b10110111,
		0b11000000, 0b11000001, 0b11010000, 0b11010001, 0b11000010, 0b11000011, 0b11010010, 0b11010011,
		0b11100000, 0b11100001, 0b11110000, 0b11110001, 0b11100010, 0b11100011, 0b11110010, 0b11110011,
		0b11000100, 0b11000101, 0b11010100, 0b11010101, 0b11000110, 0b11000111, 0b11010110, 0b11010111,
		0b11100100, 0b11100101, 0b11110100, 0b11110101, 0b11100110, 0b11100111, 0b11110110, 0b11110111,
		0b10001000, 0b10001001, 0b10011000, 0b10011001, 0b10001010, 0b10001011, 0b10011010, 0b10011011,
		0b10101000, 0b10101001, 0b10111000, 0b10111001, 0b10101010, 0b10101011, 0b10111010, 0b10111011,
		0b10001100, 0b10001101, 0b10011100, 0b10011101, 0b10001110, 0b10001111, 0b10011110, 0b10011111,
		0b10101100, 0b10101101, 0b10111100, 0b10111101, 0b10101110, 0b10101111, 0b10111110, 0b10111111,
		0b11001000, 0b11001001, 0b11011000, 0b11011001, 0b11001010, 0b11001011, 0b11011010, 0b11011011,
		0b11101000, 0b11101001, 0b11111000, 0b11111001, 0b11101010, 0b11101011, 0b11111010, 0b11111011,
		0b11001100, 0b11001101, 0b11011100, 0b11011101, 0b11001110, 0b11001111, 0b11011110, 0b11011111,
		0b11101100, 0b11101101, 0b11111100, 0b11111101, 0b11101110, 0b11101111, 0b11111110, 0b11111111
#endif	// #ifdef USE_HEX_REPRESENTATION
	};
#endif	// #ifdef __GPU
	const len_t log[] {
		0,
		0, //log(1)
		1, //log(2)
		1,
		2,
		2,2,2,
		3,
		3,3,3,3,3,3,3,
		4,
		4,4,4,4,4,4,4,4,4,4,
		4,4,4,4,4,
		5,
		5,5,5,5,5,5,5,5,5,5,
		5,5,5,5,5,5,5,5,5,5,
		5,5,5,5,5,5,5,5,5,5,
		5,
		6,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,
		7,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,
		8,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,
	};
	len_t sizeCiel(len_t a, len_t b){
		return (a+b-1)/b;
	}
}

