/**
 * @file	sdwasapi.h
 * @brief	WASAPI I[fBI NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include <vector>
#include <MMDeviceAPI.h>
#include <AudioClient.h>
#include <AudioPolicy.h>
#include "sdbase.h"
#include "misc\threadbase.h"

/**
 * @brief foCX
 */
struct WasapiDevice
{
	LPWSTR id;							//!< ID
	TCHAR szDevice[MAX_PATH];			//!< foCX
};

/**
 * @brief WASAPI NX
 */
class CSoundDeviceWasapi : public CSoundDeviceBase, protected CThreadBase
{
public:
	static void Initialize();
	static void Deinitialize();
	static void EnumerateDevices(std::vector<LPCTSTR>& devices);

	CSoundDeviceWasapi();
	virtual ~CSoundDeviceWasapi();
	virtual bool Open(LPCTSTR lpDevice = NULL, HWND hWnd = NULL);
	virtual void Close();
	virtual UINT CreateStream(UINT nSamplingRate, UINT nChannels, UINT nBufferSize = 0);
	virtual void DestroyStream();
	virtual bool PlayStream();
	virtual void StopStream();
	virtual void SetMasterVolume(int nVolume);

protected:
	virtual bool Task();

private:
	static std::vector<WasapiDevice> sm_devices;	//!< foCX Xg
	int m_mastervolume;								//!< }X^{[

	IMMDeviceEnumerator* m_pEnumerator;			//!< foCX񋓃CX^X
	IMMDevice* m_pDevice;						//!< foCX CX^X
	IAudioClient* m_pAudioClient;				//!< I[fBI NCAg CX^X
	WAVEFORMATEX* m_pwfx;						//!< tH[}bg
	IAudioRenderClient* m_pRenderClient;		//!< I[fBI _[ NCAg CX^X
	UINT32 m_nBufferSize;						//!< obt@ TCY
	HANDLE m_hEvents[2];						//!< Cxg
	void ResetStream();
	void FillStream();
};
