#include	"compiler.h"
#include	"np2.h"
#include	"mousemng.h"
#include    "scrnmng.h"

#define DIRECTINPUT_VERSION 0x0800
#include	<dinput.h>
#pragma comment(lib, "dinput8.lib")

#define	MOUSEMNG_RANGE		128


typedef struct {
	SINT16	x;
	SINT16	y;
	UINT8	btn;
	UINT	flag;
} MOUSEMNG;

static	MOUSEMNG	mousemng;
static  int mousecaptureflg = 0;

static  int mouseMul = 1; // }EXXs[h{iqj
static  int mouseDiv = 1; // }EXXs[h{ij

static  int mousebufX = 0; // }EXړobt@(X)
static  int mousebufY = 0; // }EXړobt@(Y)

// RAW}EX͑Ή np21w ver0.86 rev13
static  LPDIRECTINPUT8 dinput = NULL; 
static  LPDIRECTINPUTDEVICE8 diRawMouse = NULL; 
static  int mouseRawDeltaX = 0;
static  int mouseRawDeltaY = 0;

static  int dinput8available = 0;
typedef HRESULT (WINAPI *TEST_DIRECTINPUT8CREATE)(HINSTANCE hinst, DWORD dwVersion, REFIID riidltf, LPVOID *ppvOut, LPUNKNOWN punkOuter);

BRESULT mousemng_checkdinput8(){
	// DirectInput8gpł邩`FbN
	HMODULE hModule;
	TEST_DIRECTINPUT8CREATE fndi8create;
	LPDIRECTINPUT8 test_dinput = NULL; 
	LPDIRECTINPUTDEVICE8 test_didevice = NULL;

	if(dinput8available) return(SUCCESS);

	hModule = LoadLibrary(_T("dinput8.dll"));
	if(!hModule){
		goto scre_err;
	}
	
	fndi8create = (TEST_DIRECTINPUT8CREATE)GetProcAddress(hModule, "DirectInput8Create");
	if(!fndi8create){
		goto scre_err2;
	}
	if(FAILED(fndi8create(GetModuleHandle(NULL), DIRECTINPUT_VERSION, IID_IDirectInput8, (LPVOID*)&test_dinput, NULL))){
		goto scre_err2;
	}
	if(FAILED(test_dinput->CreateDevice(GUID_SysMouse, &test_didevice, NULL))){
		goto scre_err3;
	}

	// foCX쐬܂ŏoȂOKƂ
	test_didevice->Release();
	test_dinput->Release();
	FreeLibrary(hModule);

	dinput8available = 1;

	return(SUCCESS);
scre_err3:
	test_dinput->Release();
scre_err2:
	FreeLibrary(hModule);
scre_err:
	return(FAILURE);
}

UINT8 mousemng_getstat(SINT16 *x, SINT16 *y, int clear) {
	*x = mousemng.x;
	*y = mousemng.y;
	if (clear) {
		mousemng.x = 0;
		mousemng.y = 0;
	}
	return(mousemng.btn);
}
void mousemng_setstat(SINT16 x, SINT16 y, UINT8 btn) {
	if (mousemng.flag){
		mousemng.x = x;
		mousemng.y = y;
		mousemng.btn = btn;
	}
}

UINT8 mousemng_supportrawinput() {
	return(dinput && diRawMouse);
}

void mousemng_updatespeed() {
	mouseMul = np2oscfg.mousemul != 0 ? np2oscfg.mousemul : 1;
	mouseDiv = np2oscfg.mousediv != 0 ? np2oscfg.mousediv : 1;
}

// ----

static void getmaincenter(POINT *cp) {

	RECT	rct;

	GetWindowRect(g_hWndMain, &rct);
	cp->x = (rct.right + rct.left) / 2;
	cp->y = (rct.bottom + rct.top) / 2;
}

static void initDirectInput(){
	
	HRESULT		hr;

	if(!dinput){
		//hr = DirectInputCreateEx(GetModuleHandle(NULL), DIRECTINPUT_VERSION, IID_IDirectInput7, (void**)&dinput, NULL);
		hr = DirectInput8Create(GetModuleHandle(NULL), DIRECTINPUT_VERSION, IID_IDirectInput8, (LPVOID*)&dinput, NULL); // ֐ςĂ₪( ߄t)
		if (!FAILED(hr)){
			hr = dinput->CreateDevice(GUID_SysMouse, &diRawMouse, NULL);
			if (!FAILED(hr)){
				// f[^tH[}bgݒ
				hr = diRawMouse->SetDataFormat(&c_dfDIMouse);
				if (!FAILED(hr)){
					// xݒ
					hr = diRawMouse->SetCooperativeLevel(g_hWndMain, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);
				}
				if (!FAILED(hr)){
					// foCXݒ
					DIPROPDWORD		diprop;
					diprop.diph.dwSize = sizeof(diprop);
					diprop.diph.dwHeaderSize = sizeof(diprop.diph);
					diprop.diph.dwObj = 0;
					diprop.diph.dwHow = DIPH_DEVICE;
					diprop.dwData = DIPROPAXISMODE_REL;	// Βl[h
					hr = diRawMouse->SetProperty(DIPROP_AXISMODE, &diprop.diph);
				}
				if (!FAILED(hr)) {
					// ͊Jn
					hr = diRawMouse->Acquire();
				}else{
					// s
					diRawMouse->Release();
					diRawMouse = NULL;
					dinput->Release();
					dinput = NULL;
				}
			}else{
				// s
				diRawMouse = NULL;
				dinput->Release();
				dinput = NULL;
			}
		}else{
			// s
			diRawMouse = NULL;
			dinput = NULL;
		}
	}else{
		hr = diRawMouse->Acquire();
	}
}
static void destroyDirectInput(){
	if(diRawMouse){
		diRawMouse->Release();
		diRawMouse = NULL;
	}
	if(dinput){
		dinput->Release();
		dinput = NULL;
	}
}

static void mousecapture(BOOL capture) {

	LONG	style;
	POINT	cp;
	RECT	rct;

	if(np2oscfg.rawmouse){
		if(mousemng_checkdinput8()!=SUCCESS){
			np2oscfg.rawmouse = 0;
			MessageBox(g_hWndMain, _T("Failed to initialize DirectInput8."), _T("DirectInput Error"), MB_OK|MB_ICONEXCLAMATION);
		}
	}

	mousemng_updatespeed();

	style = GetClassLong(g_hWndMain, GCL_STYLE);
	if (capture) {
		ShowCursor(FALSE);
		getmaincenter(&cp);
		rct.left = cp.x - MOUSEMNG_RANGE;
		rct.right = cp.x + MOUSEMNG_RANGE;
		rct.top = cp.y - MOUSEMNG_RANGE;
		rct.bottom = cp.y + MOUSEMNG_RANGE;
		SetCursorPos(cp.x, cp.y);
		ClipCursor(&rct);
		style &= ~(CS_DBLCLKS);
		mousecaptureflg = 1;
		if(np2oscfg.rawmouse && dinput8available){
			initDirectInput();
		}
	}
	else {
		ShowCursor(TRUE);
		ClipCursor(NULL);
		style |= CS_DBLCLKS;
		mousecaptureflg = 0;
		if(np2oscfg.rawmouse && dinput8available){
			diRawMouse->Unacquire();
			//destroyDirectInput();
		}
	}
	SetClassLong(g_hWndMain, GCL_STYLE, style);
}

void mousemng_initialize(void) {

	ZeroMemory(&mousemng, sizeof(mousemng));
	mousemng.btn = uPD8255A_LEFTBIT | uPD8255A_RIGHTBIT;
	mousemng.flag = (1 << MOUSEPROC_SYSTEM);
	
	mousemng_updatespeed();
}

void mousemng_destroy(void) {
	destroyDirectInput();
}

void mousemng_sync(void) {

	POINT	p;
	POINT	cp;

	if ((!mousemng.flag) && (GetCursorPos(&p))) {
		getmaincenter(&cp);
		if(np2oscfg.rawmouse && dinput8available && dinput==NULL)
			initDirectInput();
		if(np2oscfg.rawmouse && dinput8available && mousemng_supportrawinput()){
			DIMOUSESTATE diMouseState = {0};
			HRESULT hr;
			hr = diRawMouse->GetDeviceState(sizeof(DIMOUSESTATE), &diMouseState);
			if (hr != DI_OK){
				switch(hr){
				case E_PENDING:
					break;
				case DIERR_INPUTLOST:
				case DIERR_NOTACQUIRED:
					diRawMouse->Acquire();
					break;
				case DIERR_NOTINITIALIZED:
				case DIERR_INVALIDPARAM:
				default:
					destroyDirectInput(); 
					initDirectInput();
					break;
				}
			}else{
				mousebufX += (diMouseState.lX*mouseMul);
				mousebufY += (diMouseState.lY*mouseMul);
			}
		}else{
			mousebufX += (p.x - cp.x)*mouseMul;
			mousebufY += (p.y - cp.y)*mouseMul;
		}
		if(mousebufX >= mouseDiv || mousebufX <= -mouseDiv){
			mousemng.x += (SINT16)(mousebufX / mouseDiv);
			mousebufX   = mousebufX % mouseDiv;
		}
		if(mousebufY >= mouseDiv || mousebufY <= -mouseDiv){
			mousemng.y += (SINT16)(mousebufY / mouseDiv);
			mousebufY   = mousebufY % mouseDiv;
		}
		//mousemng.x += (SINT16)((p.x - cp.x));// / 2);
		//mousemng.y += (SINT16)((p.y - cp.y));// / 2);
		SetCursorPos(cp.x, cp.y);
	}
}

BOOL mousemng_buttonevent(UINT event) {

	if (!mousemng.flag || (np2oscfg.mouse_nc/* && !scrnmng_isfullscreen()*/ && mousemng.flag)) {
		switch(event) {
			case MOUSEMNG_LEFTDOWN:
				mousemng.btn &= ~(uPD8255A_LEFTBIT);
				break;

			case MOUSEMNG_LEFTUP:
				mousemng.btn |= uPD8255A_LEFTBIT;
				break;

			case MOUSEMNG_RIGHTDOWN:
				mousemng.btn &= ~(uPD8255A_RIGHTBIT);
				break;

			case MOUSEMNG_RIGHTUP:
				mousemng.btn |= uPD8255A_RIGHTBIT;
				break;
		}
		return(TRUE);
	}
	else {
		return(FALSE);
	}
}

void mousemng_enable(UINT proc) {

	UINT	bit;

	bit = 1 << proc;
	if (mousemng.flag & bit) {
		mousemng.flag &= ~bit;
		if (!mousemng.flag) {
			mousecapture(TRUE);
		}
	}
}

void mousemng_disable(UINT proc) {

	if (!mousemng.flag) {
		mousecapture(FALSE);
	}
	mousemng.flag |= (1 << proc);
}

void mousemng_toggle(UINT proc) {

	if (!mousemng.flag) {
		mousecapture(FALSE);
	}
	mousemng.flag ^= (1 << proc);
	if (!mousemng.flag) {
		mousecapture(TRUE);
	}
}

void mousemng_updateclip(){
	if(mousecaptureflg){
		mousecapture(FALSE);
		mousecapture(TRUE); // Lv`
	}
}