/**
 * @file	WndBase.h
 * @brief	EBhENX̐錾уC^[tFCX̒`܂
 */

#pragma once

/**
 * @brief EBhENX
 */
class CWndBase
{
public:
	HWND m_hWnd;            /*!< must be first data member */

	CWndBase(HWND hWnd = NULL);
	CWndBase& operator=(HWND hWnd);
	void Attach(HWND hWnd);
	HWND Detach();
//	BOOL Create(LPCTSTR lpszWindowName, DWORD dwStyle, int x, int y, int nWidth, int nHeight, HWND hwndParent, HMENU nIDorHMenu);
//	BOOL DestroyWindow();

	// Attributes
	operator HWND() const;
	DWORD GetStyle() const;
	BOOL ModifyStyle(DWORD dwRemove, DWORD dwAdd, UINT nFlags = 0);

	// Message Functions
	LRESULT SendMessage(UINT message, WPARAM wParam = 0, LPARAM lParam = 0);
	BOOL PostMessage(UINT message, WPARAM wParam = 0, LPARAM lParam = 0);

	// Window Text Functions
	BOOL SetWindowText(LPCTSTR lpString);
	int GetWindowText(LPTSTR lpszStringBuf, int nMaxCount) const;
	int GetWindowTextLength() const;

	// Font Functions
	void SetFont(HFONT hFont, BOOL bRedraw = TRUE);

	// Menu Functions (non-child windows only)
	HMENU GetMenu() const;
	BOOL DrawMenuBar();
	HMENU GetSystemMenu(BOOL bRevert) const;

	// Window Size and Position Functions
	void MoveWindow(int x, int y, int nWidth, int nHeight, BOOL bRepaint = TRUE);

	// Window Size and Position Functions
	BOOL GetWindowRect(LPRECT lpRect) const;
	BOOL GetClientRect(LPRECT lpRect) const;

	// Coordinate Mapping Functions
	BOOL ClientToScreen(LPPOINT lpPoint) const;
	int MapWindowPoints(HWND hWndTo, LPPOINT lpPoint, UINT nCount) const;

	// Update and Painting Functions
	HDC BeginPaint(LPPAINTSTRUCT lpPaint);
	void EndPaint(LPPAINTSTRUCT lpPaint);
	BOOL UpdateWindow();
	BOOL Invalidate(BOOL bErase = TRUE);
	BOOL InvalidateRect(LPCRECT lpRect, BOOL bErase = TRUE);
	BOOL ShowWindow(int nCmdShow);

	// Window State Functions
	BOOL EnableWindow(BOOL bEnable = TRUE);
	HWND SetFocus();

	// Dialog-Box Item Functions
	BOOL CheckDlgButton(int nIDButton, UINT nCheck);
	UINT GetDlgItemInt(int nID, BOOL* lpTrans = NULL, BOOL bSigned = TRUE) const;
	UINT GetDlgItemText(int nID, LPTSTR lpStr, int nMaxCount) const;
	UINT IsDlgButtonChecked(int nIDButton) const;
	LRESULT SendDlgItemMessage(int nID, UINT message, WPARAM wParam = 0, LPARAM lParam = 0);
	BOOL SetDlgItemInt(int nID, UINT nValue, BOOL bSigned = TRUE);
	BOOL SetDlgItemText(int nID, LPCTSTR lpszString);

	// Window Access Functions
	CWndBase GetParent() const;

	// Window Tree Access
	CWndBase GetDlgItem(int nID) const;

	// Misc. Operations
	int SetScrollInfo(int nBar, LPSCROLLINFO lpScrollInfo, BOOL bRedraw = TRUE);
	BOOL IsWindow() const;
};

/**
 * RXgN^
 * @param[in] hWnd EBhE nh
 */
inline CWndBase::CWndBase(HWND hWnd)
	: m_hWnd(hWnd)
{
}

/**
 * Iy[^
 * @param[in] hWnd EBhE nh
 * @return CX^X
 */
inline CWndBase& CWndBase::operator=(HWND hWnd)
{
	m_hWnd = hWnd;
	return *this;
}

/**
 * A^b`
 * @param[in] hWnd EBhE nh
 */
inline void CWndBase::Attach(HWND hWnd)
{
	m_hWnd = hWnd;
}

/**
 * f^b`
 * @return ȑÕCX^X
 */
inline HWND CWndBase::Detach()
{
	HWND hWnd = m_hWnd;
	m_hWnd = NULL;
	return hWnd;
}

/**
 * HWND Iy[^
 * @return HWND
 */
inline CWndBase::operator HWND() const
{
	return m_hWnd;
}

/**
 * ݂̃EBhE X^CԂ܂
 * @return EBhẼX^C
 */
inline DWORD CWndBase::GetStyle() const
{
	return static_cast<DWORD>(::GetWindowLong(m_hWnd, GWL_STYLE));
}

/**
 * EBhE X^CύX܂
 * @param[in] dwRemove X^C̃rWɍ폜EBhE X^Cw肵܂
 * @param[in] dwAdd X^C̃rWɒǉEBhE X^Cw肵܂
 * @param[in] nFlags SetWindowPosɓntO
 * @retval TRUE ύXꂽ
 * @retval FALSE ύXȂ
 */
inline BOOL CWndBase::ModifyStyle(DWORD dwRemove, DWORD dwAdd, UINT nFlags)
{
	const DWORD dwStyle = ::GetWindowLong(m_hWnd, GWL_STYLE);
	const DWORD dwNewStyle = (dwStyle & ~dwRemove) | dwAdd;
	if (dwStyle == dwNewStyle)
	{
		return FALSE;
	}
	::SetWindowLong(m_hWnd, GWL_STYLE, dwNewStyle);
	if (nFlags != 0)
	{
		::SetWindowPos(m_hWnd, NULL, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE | nFlags);
	}
	return TRUE;
}

/**
 * ̃EBhEɎw肳ꂽbZ[W𑗐M܂
 * @param[in] message M郁bZ[Ww肵܂
 * @param[in] wParam ǉ̃bZ[Wˑw肵܂
 * @param[in] lParam ǉ̃bZ[Wˑw肵܂
 * @return bZ[W̏̌
 */
inline LRESULT CWndBase::SendMessage(UINT message, WPARAM wParam, LPARAM lParam)
{
	return ::SendMessage(m_hWnd, message, wParam, lParam);
}

/**
 * bZ[WEBhẼbZ[W L[ɒuAΉEBhEbZ[Ŵ҂ɕԂ܂
 * @param[in] message |Xg郁bZ[Ww肵܂
 * @param[in] wParam bZ[W̕tw肵܂
 * @param[in] lParam bZ[W̕tw肵܂
 * @retval TRUE 
 * @retval FALSE s
 */
inline BOOL CWndBase::PostMessage(UINT message, WPARAM wParam, LPARAM lParam)
{
	return ::PostMessage(m_hWnd, message, wParam, lParam);
}

/**
 * w肳ꂽEBhẼ^Cgo[̃eLXgύX܂
 * @param[in] lpString VEBhE^Cg܂̓Rg[̃eLXgƂĎgANULL ŏI镶ւ̃|C^w肵܂
 * @retval TRUE 
 * @retval FALSE s
 */
inline BOOL CWndBase::SetWindowText(LPCTSTR lpString)
{
	return ::SetWindowText(m_hWnd, lpString);
}

/**
 * w肳ꂽEBhẼ^Cgo[̃eLXgobt@փRs[܂
 * @param[in] lpszStringBuf obt@ւ̃|C^w肵܂B̃obt@ɃeLXgi[܂
 * @param[in] nMaxCount obt@ɃRs[镶̍ő吔w肵܂BeLXĝ̃TCY𒴂镔́A؂̂Ă܂BNULL Ɋ܂߂܂
 * @return Rs[ꂽ̕Ԃ܂ (I[ NULL ͊܂߂܂)
 */
inline int CWndBase::GetWindowText(LPTSTR lpszStringBuf, int nMaxCount) const
{
	return ::GetWindowText(m_hWnd, lpszStringBuf, nMaxCount);
}

/**
 * w肳ꂽEBhẼ^Cgo[eLXg̕Ԃ܂
 * @return ֐ƁAeLXg̕Ԃ܂
 */
inline int CWndBase::GetWindowTextLength() const
{
	return ::GetWindowTextLength(m_hWnd);
}

/**
 * w肵tHggp܂
 * @param[in] hFont tHg nh
 * @param[in] bRedraw bZ[WɃEBhEĕ`悷ꍇ TRUE
 */
inline void CWndBase::SetFont(HFONT hFont, BOOL bRedraw)
{
	::SendMessage(m_hWnd, WM_SETFONT, reinterpret_cast<WPARAM>(hFont), bRedraw);
}

/**
 * w肳ꂽEBhEɊ蓖ĂĂ郁j[̃nh擾܂
 * @return j[̃nhԂ܂
 */
inline HMENU CWndBase::GetMenu() const
{
	return ::GetMenu(m_hWnd);
}

/**
 * w肳ꂽEBhẼj[o[ĕ`悵܂
 * @retval TRUE 
 * @retval FALSE s
 */
inline BOOL CWndBase::DrawMenuBar()
{
	return ::DrawMenuBar(m_hWnd);
}

/**
 * w肳ꂽEBhEɊ蓖ĂĂVXe j[̃nh擾܂
 * @param[in] bRevert sANVw肵܂
 * @return j[̃nhԂ܂
 */
inline HMENU CWndBase::GetSystemMenu(BOOL bRevert) const
{
	return ::GetSystemMenu(m_hWnd, bRevert);
}

/**
 * ʒuƃTCYύX܂
 * @param[in] x ̐Vʒuw肵܂
 * @param[in] y 㑤̐Vʒuw肵܂
 * @param[in] nWidth Vw肵܂
 * @param[in] nHeight Vw肵܂
 * @param[in] bRepaint ĕ`悷Kv邩ǂw肵܂
 * @
 */
inline void CWndBase::MoveWindow(int x, int y, int nWidth, int nHeight, BOOL bRepaint)
{
	::MoveWindow(m_hWnd, x, y, nWidth, nHeight, bRepaint);
}

/**
 * w肳ꂽEBhE̍[ƉE[̍WXN[WŎ擾܂
 * @param[out] lpRect \̂ւ̃|C^w肵܂
 * @retval TRUE 
 * @retval FALSE s
 */
inline BOOL CWndBase::GetWindowRect(LPRECT lpRect) const
{
	return ::GetWindowRect(m_hWnd, lpRect);
}

/**
 * lpRectw\ CWnd ̃NCAg̈̃NCAgWRs[܂
 * @param[out] lpRect \̂ւ̃|C^w肵܂
 * @retval TRUE 
 * @retval FALSE s
 */
inline BOOL CWndBase::GetClientRect(LPRECT lpRect) const
{
	return ::GetClientRect(m_hWnd, lpRect);
}

/**
 * w肳ꂽ_ANCAgWXN[W֕ϊ܂
 * @param[in,out] lpPoint ϊΏۂ̃NCAgWێĂA1  \̂ւ̃|C^w肵܂
 * @retval TRUE 
 * @retval FALSE s
 */
inline BOOL CWndBase::ClientToScreen(LPPOINT lpPoint) const
{
	return ::ClientToScreen(m_hWnd, lpPoint);
}

/**
 * ̓_AEBhEƂWԂÃEBhEƂWԂ֕ϊi}bvj܂
 * @param[in] hWndTo ϊ̓_ێiϊjEBhẼnhw肵܂
 * @param[in,out] lpPoint ϊΏۂ̓_̍WێĂ \̂Ȃ 1 ̔zւ̃|C^w肵܂
 * @param[in] nCount lpPoint p[^ŁA POINT \̂Ȃ 1 ̔zւ̃|C^w肵ꍇAz POINT \̂̐w肵܂
 * @return ֐ƁAe_̈ړ 32 rbglԂ܂
 */
inline int CWndBase::MapWindowPoints(HWND hWndTo, LPPOINT lpPoint, UINT nCount) const
{
	return ::MapWindowPoints(m_hWnd, hWndTo, lpPoint, nCount);
}

/**
 * `Jn܂
 * @param[out] lpPaint `ւ̃|C^w肵܂
 * @return foCX ReLXg
 */
inline HDC CWndBase::BeginPaint(LPPAINTSTRUCT lpPaint)
{
	return ::BeginPaint(m_hWnd, lpPaint);
}

/**
 * `̏I܂
 * @param[in] lpPaint `ւ̃|C^w肵܂
 */
inline void CWndBase::EndPaint(LPPAINTSTRUCT lpPaint)
{
	::EndPaint(m_hWnd, lpPaint);
}

/**
 * w肳ꂽEBhE̍XV[Wł͂ȂꍇAEBhE bZ[W𑗐MÃEBhẼNCAg̈XV܂
 * @retval TRUE 
 * @retval FALSE s
 */
inline BOOL CWndBase::UpdateWindow()
{
	return ::UpdateWindow(m_hWnd);
}

/**
 * w肳ꂽEBhÊׂĂXV[Wɂ܂
 * @param[in] bErase XV[WƂɁAXV[W̔wi邩ǂw肵܂
 * @retval TRUE 
 * @retval FALSE s
 */
inline BOOL CWndBase::Invalidate(BOOL bErase)
{
	return ::InvalidateRect(m_hWnd, NULL, bErase);
}

/**
 * w肳ꂽEBhE̍XV[W1̒`ǉ܂
 * @param[in] lpRect XV[W֒ǉ`̃NCAgWێ1̍\̂ւ̃|C^w肵܂
 * @param[in] bErase XV[WƂɁAXV[W̔wi邩ǂw肵܂
 * @retval TRUE 
 * @retval FALSE s
 */
inline BOOL CWndBase::InvalidateRect(LPCRECT lpRect, BOOL bErase)
{
	return ::InvalidateRect(m_hWnd, lpRect, bErase);
}

/**
 * w肳ꂽEBhE̕\Ԃݒ肵܂
 * @param[in] nCmdShow EBhE̕\@w肵܂
 * @retval TRUE 
 * @retval FALSE s
 */
inline BOOL CWndBase::ShowWindow(int nCmdShow)
{
	return ::ShowWindow(m_hWnd, nCmdShow);
}

/**
 * w肳ꂽEBhE܂̓Rg[ŁA}EX͂ƃL[{[h͂L܂͖ɂ܂
 * @param[in] bEnable EBhELɂ邩ɂ邩w肵܂
 * @retval TRUE EBhEɖɂȂĂ
 * @retval FALSE EBhEɂȂĂȂ
 */
inline BOOL CWndBase::EnableWindow(BOOL bEnable)
{
	return ::EnableWindow(m_hWnd, bEnable);
}

/**
 * ̓tH[JXv܂
 * @return Oɓ̓tH[JXĂEBhE nh
 */
inline HWND CWndBase::SetFocus()
{
	return ::SetFocus(m_hWnd);
}

/**
 * {^Rg[̃`FbNԂύX܂
 * @param[in] nIDButton ԂύX{^̎ʎqw肵܂
 * @param[in] nCheck {^̃`FbNԂw肵܂
 * @retval TRUE 
 * @retval FALSE s
 */
inline BOOL CWndBase::CheckDlgButton(int nIDButton, UINT nCheck)
{
	return ::CheckDlgButton(m_hWnd, nIDButton, nCheck);
}

/**
 * _CAO{bNX̎w肳ꂽRg[̃eLXgAl֕ϊ܂
 * @param[in] nID ϊeLXgRg[̎ʎqw肵܂
 * @param[in] lpTrans s̒l󂯎ϐւ̃|C^w肵܂
 * @param[in] bSigned eLXg𕄍tƂĈĕt̒lԂǂw肵܂
 * @return Rg[eLXgɑ鐮lԂ܂
 */
inline UINT CWndBase::GetDlgItemInt(int nID, BOOL* lpTrans, BOOL bSigned) const
{
	return ::GetDlgItemInt(m_hWnd, nID, lpTrans, bSigned);
}

/**
 * _CAO{bNX̎w肳ꂽRg[Ɋ֘AtĂ^Cg܂̓eLXg擾܂
 * @param[in] nID 擾^Cg܂̓eLXgێĂRg[̎ʎqw肵܂
 * @param[out] lpStr ^Cg܂̓eLXg󂯎obt@ւ̃|C^w肵܂
 * @param[in] nMaxCount lpStr p[^wobt@փRs[镶̍ő̒ TCHAR PʂŎw肵܂
 * @return obt@փRs[ꂽ̒i I[ NULL ܂܂Ȃj TCHAR PʂŕԂ܂
 */
inline UINT CWndBase::GetDlgItemText(int nID, LPTSTR lpStr, int nMaxCount) const
{
	return ::GetDlgItemText(m_hWnd, nID, lpStr, nMaxCount);
}

/**
 * {^Rg[̃`FbNԂ擾܂
 * @param[in] nIDButton {^Rg[̎ʎqw肵܂
 * @return `FbN
 */
inline UINT CWndBase::IsDlgButtonChecked(int nIDButton) const
{
	return ::IsDlgButtonChecked(m_hWnd, nIDButton);
}

/**
 * _CAO{bNX̎w肳ꂽRg[փbZ[W𑗐M܂B
 * @param[in] nID bZ[W󂯎Rg[̎ʎqw肵܂
 * @param[in] message MbZ[Ww肵܂
 * @param[in] wParam bZ[W̒ǉw肵܂
 * @param[in] lParam bZ[W̒ǉw肵܂
 * @return bZ[W̌ʂԂ܂
 */
inline LRESULT CWndBase::SendDlgItemMessage(int nID, UINT message, WPARAM wParam, LPARAM lParam)
{
	return ::SendDlgItemMessage(m_hWnd, nID, message, wParam, lParam);
}

/**
 * w肳ꂽl𕶎֕ϊA_CAO{bNX̃Rg[ɃeLXgƂĐݒ肵܂
 * @param[in] nID ύXRg[̎ʎqw肵܂
 * @param[in] nValue lw肵܂
 * @param[in] bSigned nValue p[^̒ltǂw肵܂
 * @retval TRUE 
 * @retval FALSE s
 */
inline BOOL CWndBase::SetDlgItemInt(int nID, UINT nValue, BOOL bSigned)
{
	return ::SetDlgItemInt(m_hWnd, nID, nValue, bSigned);
}

/**
 * _CAO{bNX̃Rg[̃^Cg܂̓eLXgݒ肵܂
 * @param[in] nID eLXgݒ肵Rg[̎ʎqw肵܂
 * @param[in] lpszString Rg[փRs[eLXgێANULL ŏI镶ւ̃|C^w肵܂
 * @retval TRUE 
 * @retval FALSE s
 */
inline BOOL CWndBase::SetDlgItemText(int nID, LPCTSTR lpszString)
{
	return ::SetDlgItemText(m_hWnd, nID, lpszString);
}

/**
 * w肳ꂽqEBhE̐eEBhE܂̓I[i[EBhẼnhԂ܂
 * @return eEBhẼnh
 */
inline CWndBase CWndBase::GetParent() const
{
	return CWndBase(::GetParent(m_hWnd));
}

/**
 * w肳ꂽ_CAO{bNX̃Rg[̃nh擾܂
 * @param[in] nID nh擾Rg[̎ʎqw肵܂
 * @return EBhE
 */
inline CWndBase CWndBase::GetDlgItem(int nID) const
{
	return CWndBase(::GetDlgItem(m_hWnd, nID));
}

/**
 * XN[o[̂܂܂ȃp[^ݒ肵܂
 * @param[in] nBar p[^ݒ肷ׂXN[o[̃^Cvw肵܂
 * @param[in] lpScrollInfo ݒ肷ׂێĂA1̍\̂ւ̃|C^w肵܂
 * @param[in] bRedraw XN[o[ĕ`悷邩ǂw肵܂
 * @return XN[o[݂̌̃XN[ʒuԂ܂
 */
inline int CWndBase::SetScrollInfo(int nBar, LPSCROLLINFO lpScrollInfo, BOOL bRedraw)
{
	return ::SetScrollInfo(m_hWnd, nBar, lpScrollInfo, bRedraw);
}

/**
 * EBhE݂Ă邩ǂ𒲂ׂ܂
 * @return w肵EBhEnhEBhE݂Ăꍇ́A0 ȊO̒lԂ܂
 */
inline BOOL CWndBase::IsWindow() const
{
	return ::IsWindow(m_hWnd);
}
