/**
 * @file	scciif.cpp
 * @brief	SCCI ANZX NX̓̒`s܂
 */

#include "compiler.h"
#include "scciif.h"
#include "scci.h"
#include "SCCIDefines.h"

/**
 * RXgN^
 */
CScciIf::CScciIf()
	: m_hModule(NULL)
	, m_pManager(NULL)
{
}

/**
 * fXgN^
 */
CScciIf::~CScciIf()
{
	Deinitialize();
}

/**
 * 
 * @retval true 
 * @retval false s
 */
bool CScciIf::Initialize()
{
	if (m_hModule)
	{
		return false;
	}

	do
	{
		m_hModule = ::LoadLibrary(TEXT("SCCI.DLL"));
		if (m_hModule == NULL)
		{
			break;
		}

		/* TEhC^[tF[X}l[W[擾p֐AhX擾 */
		SCCIFUNC fnGetSoundInterfaceManager = reinterpret_cast<SCCIFUNC>(::GetProcAddress(m_hModule, "getSoundInterfaceManager"));
		if (fnGetSoundInterfaceManager == NULL)
		{
			break;
		}

		/* TEhC^[tF[X}l[W[擾 */
		m_pManager = (*fnGetSoundInterfaceManager)();
		if (m_pManager == NULL)
		{
			break;
		}

		/* TEhC^[tF[X}l[W[CX^X */
		/* KŏɎsĂ */
		if (!m_pManager->initializeInstance())
		{
			break;
		}

		/* Zbgs */
		Reset();
		return true;
	} while (false /*CONSTCOND*/);

	Deinitialize();
	return false;
}

/**
 * 
 */
void CScciIf::Deinitialize()
{
	if (m_pManager)
	{
		/* ꊇJꍇi`bvꊇJ̏ꍇj */
		m_pManager->releaseAllSoundChip();

		/* TEhC^[tF[X}l[W[CX^XJ */
		/* FreeLibrarysOɕKĂяoĂ */
		m_pManager->releaseInstance();

		m_pManager = NULL;
	}

	if (m_hModule)
	{
		::FreeLibrary(m_hModule);
		m_hModule = NULL;
	}
}

/**
 * Zbg
 */
void CScciIf::Reset()
{
	if (m_pManager)
	{
		/* Zbgs */
		m_pManager->reset();
	}
}

/**
 * C^[tFCX擾
 * @param[in] nChipType ^Cv
 * @param[in] nClock NbN
 * @return CX^X
 */
IExternalChip* CScciIf::GetInterface(IExternalChip::ChipType nChipType, UINT nClock)
{
	const bool bInitialized = Initialize();

	do
	{
		if (m_pManager == NULL)
		{
			break;
		}

		SC_CHIP_TYPE iSoundChipType = SC_TYPE_NONE;
		switch (nChipType)
		{
			case IExternalChip::kAY8910:
				iSoundChipType = SC_TYPE_AY8910;
				break;

			case IExternalChip::kYM2203:
				iSoundChipType = SC_TYPE_YM2203;
				break;

			case IExternalChip::kYM2608:
				iSoundChipType = SC_TYPE_YM2608;
				break;

			case IExternalChip::kYM3438:
				iSoundChipType = SC_TYPE_YM2612;
				break;

			case IExternalChip::kYMF288:
				iSoundChipType = SC_TYPE_YMF288;
				break;

			case IExternalChip::kYM3812:
				iSoundChipType = SC_TYPE_YM3812;
				break;

			case IExternalChip::kYMF262:
				iSoundChipType = SC_TYPE_YMF262;
				break;

			case IExternalChip::kY8950:
				iSoundChipType = SC_TYPE_Y8950;
				break;

			case IExternalChip::kYM2151:
				iSoundChipType = SC_TYPE_YM2151;
				break;

			default:
				break;
		}

		SoundChip* pSoundChip = m_pManager->getSoundChip(iSoundChipType, nClock);
		if (pSoundChip != NULL)
		{
			/* TEh`bv擾ł */
			return new Chip(this, pSoundChip);
		}
	} while (false /*CONSTCOND*/);

	if (bInitialized)
	{
//		Deinitialize();
	}
	return NULL;
}

/**
 * 
 * @param[in] pChip `bv
 */
void CScciIf::Detach(CScciIf::Chip* pChip)
{
	/* `bv̊Ji`bvPʂŊJ̏ꍇj */
	if (m_pManager)
	{
		m_pManager->releaseSoundChip(*pChip);
	}
}

/* ---- `bv */

/**
 * RXgN^
 * @param[in] pScciIf eCX^X
 * @param[in] pSoundChip `bv CX^X
 */
CScciIf::Chip::Chip(CScciIf* pScciIf, SoundChip* pSoundChip)
	: m_pScciIf(pScciIf)
	, m_pSoundChip(pSoundChip)
{
}

/**
 * fXgN^
 */
CScciIf::Chip::~Chip()
{
	m_pScciIf->Detach(this);
}

/**
 * Iy[^
 */
CScciIf::Chip::operator SoundChip*()
{
	return m_pSoundChip;
}

/**
 * Get chip type
 * @return The type of the chip
 */
IExternalChip::ChipType CScciIf::Chip::GetChipType()
{
	int iSoundChip = m_pSoundChip->getSoundChipType();

	const SCCI_SOUND_CHIP_INFO* pInfo = m_pSoundChip->getSoundChipInfo();
	if (pInfo)
	{
		iSoundChip = pInfo->iSoundChip;
	}

	switch (iSoundChip)
	{
		case SC_TYPE_AY8910:
			return IExternalChip::kAY8910;

		case SC_TYPE_YM2203:
			return IExternalChip::kYM2203;

		case SC_TYPE_YM2608:
			return IExternalChip::kYM2608;

		case SC_TYPE_YM2612:
			return IExternalChip::kYM3438;

		case SC_TYPE_YM3812:
			return IExternalChip::kYM3812;

		case SC_TYPE_YMF262:
			return IExternalChip::kYMF262;

		case SC_TYPE_YMF288:
			return IExternalChip::kYMF288;

		case SC_TYPE_Y8950:
			return IExternalChip::kY8950;

		case SC_TYPE_YM2151:
			return IExternalChip::kYM2151;

		default:
			break;
	}
	return IExternalChip::kNone;
}

/**
 * Zbg
 */
void CScciIf::Chip::Reset()
{
}

/**
 * WX^
 * @param[in] nAddr AhX
 * @param[in] cData f[^
 */
void CScciIf::Chip::WriteRegister(UINT nAddr, UINT8 cData)
{
	m_pSoundChip->setRegister(nAddr, cData);
}

/**
 * bZ[W
 * @param[in] nMessage bZ[W
 * @param[in] nParameter p[^
 * @return Ug
 */
INTPTR CScciIf::Chip::Message(UINT nMessage, INTPTR nParameter)
{
	return 0;
}
