// ---------------------------------------------------------------------------
//	OPM-like Sound Generator
//	Copyright (C) cisc 1998, 2003.
// ---------------------------------------------------------------------------
//	$Id: opm.h,v 1.14 2003/06/07 08:25:53 cisc Exp $

#ifndef FM_OPM_H
#define FM_OPM_H

#include "fmgen_fmgen.h"
#include "fmgen_fmtimer.h"
#include "fmgen_psg.h"

// ---------------------------------------------------------------------------
//	class OPM
//	OPM ɗǂ(?)𐶐鉹jbg
//	
//	interface:
//	bool Init(uint clock, uint rate, bool);
//		D̃NXgpOɂȂ炸ĂłƁD
//		: `⊮[h͔p~܂
//
//		clock:	OPM ̃NbNg(Hz)
//
//		rate:	 PCM ̕W{g(Hz)
//
//				
//		Ԓl	ɐ true
//
//	bool SetRate(uint clock, uint rate, bool)
//		NbN PCM [gύX
//		 Init ƓlD
//	
//	void Mix(Sample* dest, int nsamples)
//		Stereo PCM f[^ nsamples C dest Ŏn܂z
//		(Z)
//		Edest ɂ sample*2 ̗̈悪Kv
//		Ei[` L, R, L, R... ƂȂD
//		E܂ŉZȂ̂ŁC炩ߔz[NAKv
//		EFM_SAMPLETYPE  short ^̏ꍇNbsOs.
//		E̊֐͉̃^C}[Ƃ͓ƗĂD
//		  Timer  Count  GetNextEvent ő삷KvD
//	
//	void Reset()
//		Zbg()
//
//	void SetReg(uint reg, uint data)
//		̃WX^ reg  data 
//	
//	uint ReadStatus()
//		̃Xe[^XWX^ǂݏo
//		busy tO͏ 0
//	
//	bool Count(uint32 t)
//		̃^C}[ t [10^(-6) b] i߂D
//		̓Ԃɕω(timer I[o[t[)
//		true Ԃ
//
//	uint32 GetNextEvent()
//		̃^C}[̂ǂ炩I[o[t[܂łɕKv
//		[ʕb]Ԃ
//		^C}[~Ăꍇ 0 ԂD
//	
//	void SetVolume(int db)
//		ẻʂ{|ɒ߂DWl 0.
//		Pʂ͖ 1/2 dBCL͈͂̏ 20 (10dB)
//
//	z֐:
//	virtual void Intr(bool irq)
//		IRQ o͂ɕωꍇĂ΂D
//		irq = true:  IRQ v
//		irq = false: IRQ v
//
namespace FM
{
	//	YM2151(OPM) ----------------------------------------------------
	struct OPMData {
		struct TimerData timer;
		int		fmvolume;

		uint	clock;
		uint	rate;
		uint	pcmrate;

		uint	pmd;
		uint	amd;
		uint	lfocount;
		uint	lfodcount;

		uint	lfo_count_;
		uint	lfo_count_diff_;
		uint	lfo_step_;
		uint	lfo_count_prev_;

		uint	lfowaveform;
		uint	rateratio;
		uint	noise;
		int32	noisecount;
		uint32	noisedelta;
		
		bool	interpolation;
		uint8	lfofreq;
		uint8	status;
		uint8	reg01;

		uint8	kc[8];
		uint8	kf[8];
		uint8	pan[8];

		struct Channel4Data ch[8];
		struct ChipData	chip;
	};

	class OPM : public Timer
	{
	public:
		OPM();
		~OPM() {}

		bool	Init(uint c, uint r, bool=false);
		bool	SetRate(uint c, uint r, bool);
		void	SetLPFCutoff(uint freq);
		void	Reset();
		
		void 	SetReg(uint addr, uint data);
		uint	GetReg(uint addr);
		uint	ReadStatus() { return status & 0x03; }
		
		void 	Mix(Sample* buffer, int nsamples);
		
		void	SetVolume(int db);
		void	SetChannelMask(uint mask);
		
		void	DataSave(struct OPMData* data);
		void	DataLoad(struct OPMData* data);

	private:
		virtual void Intr(bool) {}
	
	private:
		enum
		{
			OPM_LFOENTS = 512,
		};
		
		void	SetStatus(uint bit);
		void	ResetStatus(uint bit);
		void	SetParameter(uint addr, uint data);
		void	TimerA();
		void	RebuildTimeTable();
		void	MixSub(int activech, ISample**);
		void	MixSubL(int activech, ISample**);
		void	LFO();
		uint	Noise();
		
		int		fmvolume;

		uint	clock;
		uint	rate;
		uint	pcmrate;

		uint	pmd;
		uint	amd;
		uint	lfocount;
		uint	lfodcount;

		uint	lfo_count_;
		uint	lfo_count_diff_;
		uint	lfo_step_;
		uint	lfo_count_prev_;

		uint	lfowaveform;
		uint	rateratio;
		uint	noise;
		int32	noisecount;
		uint32	noisedelta;
		
		bool	interpolation;
		uint8	lfofreq;
		uint8	status;
		uint8	reg01;

		uint8	kc[8];
		uint8	kf[8];
		uint8	pan[8];

		Channel4 ch[8];
		Chip	chip;

		static void	BuildLFOTable();
		static int amtable[4][OPM_LFOENTS];
		static int pmtable[4][OPM_LFOENTS];

	public:
		int		dbgGetOpOut(int c, int s) { return ch[c].op[s].dbgopout_; }
		Channel4* dbgGetCh(int c) { return &ch[c]; }

	};
}

#endif // FM_OPM_H
