/**
 * @file	tty.h
 * @brief	VAʐMNX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include <termios.h>

/**
 * @brief VAʐM
 */
class CTty
{
public:
	CTty();
	~CTty();
	bool Open(const char* dev, unsigned int speed = 0, const char* param = NULL);
	void Close();
	ssize_t Read(void* data_ptr, ssize_t data_size);
	ssize_t Write(const void* data_ptr, ssize_t data_size);
	bool IsOpened() const;

private:
	int m_fd;		//!< t@C fBXNv^
	static bool SetParam(const char* param, tcflag_t* cflag_ptr);
};

/**
 * I[v?
 * @retval true I[v
 * @retval false I[v
 */
inline bool CTty::IsOpened() const
{
	return (m_fd >= 0);
}
