---
name: Bug report
about: Create a report to help us improve
title: ''
labels: bug
assignees: ''

---

### Look for similar bugs
Please check if there's [already an issue](https://github.com/librespot-org/librespot/issues) for your problem.
If you've only a "me too" comment to make, consider if a :+1: [reaction](https://github.blog/news-insights/product-news/add-reactions-to-pull-requests-issues-and-comments/)
will suffice. 

### Description
A clear and concise description of what the problem is.

### Version
What version(s) of *librespot* does this problem exist in?

### How to reproduce
Steps to reproduce the behavior in *librespot* e.g.
1. Launch `librespot` with '...'
2. Connect with '...'
3. In the client click on '...'
4. See some error/problem

### Log
* A *full* **debug** log so we may trace your problem (launch `librespot` with `--verbose`).
* Ideally contains your above steps to reproduce.
* Format the log as code ([help](https://docs.github.com/en/get-started/writing-on-github/working-with-advanced-formatting/creating-and-highlighting-code-blocks)) or use a *non-expiring* [pastebin](https://pastebin.com/).
* Redact data you consider personal but do not remove/trim anything else.

### Host (what you are running `librespot` on):
- OS: [e.g. Linux]
- Platform: [e.g. RPi 3B+]

### Additional context
Add any other context about the problem here. If your issue is related to sound playback, at a minimum specify the type and make of your output device.
