#!/usr/bin/perl
# wap_test2.cgi - This will test the HTMLObject::WAP object.

use HTMLObject::WAP;
use HTMLObject::ReadCookie;
use strict;

my $doc = HTMLObject::WAP->new(type => "HDML", version => "3.0", language => "en", charsetEncoding => "");

$doc->setCookie(name=>'testing', value => "HDML 3.0");

my $cookies = HTMLObject::ReadCookie->new;
my %cresult = $cookies->getCookies;

$doc->createDeck(id => "hello", version => "3.0", ttl => "0");
$doc->createCard(id => "hello", cardType => "display", title => "Hello World");
$doc->print("Hello World!<line>\n");

if (exists $cresult{testing})
{
  $doc->print("Cookie Testing exists!<line>\n");
  $doc->print("Value = $cresult{testing}<line>\n");
}

$doc->display(deck => "hello");
