#include "buffer.h"
#include "dns.h"
#include "exit.h"
#include "fmt.h"
#include "sgetopt.h"
#include "stralloc.h"
#include "strerr.h"

#define FATAL "leapsunpack: fatal: "

void die_nomem() {strerr_die2x(111, FATAL, "out of memory");}
void die_badinput() {strerr_die2x(111, FATAL, "bad input");}

static stralloc strin = {0};
static stralloc strout = {0};
static stralloc fqdn = {0};

void main(int argc, char **argv) {

  register int r;
  register char *c;
  char d;
  char e[FMT_ULONG];
  const int year = 1972;

  int opt;
  int flag_autofetch_dns = 0;

  while ((opt = getopt(argc,argv,"a")) != opteof)
    switch(opt) {
      case 'a': flag_autofetch_dns = 1; break;
      default: flag_autofetch_dns = 0;
    }

  if (flag_autofetch_dns) {
    if (!stralloc_copys(&fqdn, "leap.bze.ro")) die_nomem();
    if (dns_txt(&strin, &fqdn) == -1) die_badinput();
  }

  else {

    for(;;) {
      r = buffer_feed(buffer_0);
      if (r < 0) _exit(111);
      if (!r) break;

      c = buffer_peek(buffer_0);
      buffer_seek(buffer_0, r);

      if (r > 1024) die_badinput();

      while (r > 0) {
        d = *c++; r--;

        if (d == '\n') break;

        if ((d != '0') &&
            (d != '2') &&
            (d != '6') &&
            (d != '8') &&
            (d != '.')) die_badinput();

        if (!stralloc_append(&strin, &d)) die_nomem();
      }
    }
  }

  if (!stralloc_starts(&strin, "822222220666060202206662062000000200200060062")) die_badinput();

  for(r = 0; r < strin.len; r++) {
    e[fmt_ulong(e, (unsigned long)(year + r))] = 0;

    if (!stralloc_copys(&strout,"")) die_nomem();

    if (strin.s[r] == '8') {
      if (!stralloc_cats(&strout, "+")) die_nomem();
      if (!stralloc_cats(&strout, e)) die_nomem();
      if (!stralloc_cats(&strout, "-06-30\n")) die_nomem();

      if (!stralloc_cats(&strout, "+")) die_nomem();
      if (!stralloc_cats(&strout, e)) die_nomem();
      if (!stralloc_cats(&strout, "-12-31\n")) die_nomem();
    }

    else if (strin.s[r] == '6') {
      if (!stralloc_cats(&strout, "+")) die_nomem();
      if (!stralloc_cats(&strout, e)) die_nomem();
      if (!stralloc_cats(&strout, "-06-30\n")) die_nomem();
    }

    else if (strin.s[r] == '2') {
      if (!stralloc_cats(&strout, "+")) die_nomem();
      if (!stralloc_cats(&strout, e)) die_nomem();
      if (!stralloc_cats(&strout, "-12-31\n")) die_nomem();
    }
    buffer_putflush(buffer_1, strout.s, strout.len);
  }

  _exit(0);
}
