#include "buffer.h"
#include "byte.h"
#include "exit.h"
#include "fmt.h"
#include "getln.h"
#include "open.h"
#include "scan.h"
#include "stralloc.h"
#include "strerr.h"

#define FATAL "leaps2zic: fatal: "

static char *montab[12] = {
  "Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"
};

char *fn;
buffer b;
char bspace[1024];
static stralloc line = {0};
int match = 1;

void nomem(void) {
  strerr_die2x(111,FATAL,"out of memory");
}

void usage(void) {
  strerr_die1x(100,"leaps2zic: usage: leaps2zic leapsecs.txt");
}

void die_bad(void) {
  if (!stralloc_0(&line)) nomem();
  strerr_die3x(100,FATAL,"unable to parse this line: ",line.s);
}

char strnum[FMT_ULONG];

void main(int argc,char **argv) {
  char *x;
  int len;
  int fd;
  char ch;
  int nlen;
  unsigned long n;

  fn = argv[1];
  if (!fn) usage();

  fd = open_read(fn);
  if (fd == -1)
    strerr_die4sys(111,FATAL,"unable to open ",fn,": ");

  buffer_init(&b,buffer_unixread,fd,bspace,sizeof bspace);

  while (match) {
    if (getln(&b,&line,&match,'\n') == -1)
      strerr_die2sys(111,FATAL,"unable to read input: ");

    x = line.s; len = line.len;

    if (!len) break;
    if (x[0] == '#') continue;
    if (x[0] == '\n') continue;

    while (len) {
      ch = x[len - 1];
      if (ch != '\n') if (ch != ' ') if (ch != '\t') break;
      --len;
    }
    line.len = len; /* for die_bad() */

    if (len < 11) die_bad();

    ch = x[0];
    nlen = scan_ulong(++x,&n);
    if (!nlen) die_bad();
    buffer_puts(buffer_1,"Leap\t");
    buffer_put(buffer_1,strnum,fmt_ulong(strnum,n));

    x += nlen;
    nlen = scan_ulong(++x,&n);
    if (!nlen) die_bad();
    if (1 > n) die_bad();
    buffer_PUTC(buffer_1,"\t"[0]);
    buffer_put(buffer_1,montab[n-1],3);

    x += nlen;
    nlen = scan_ulong(++x,&n);
    if (!nlen) die_bad();
    buffer_PUTC(buffer_1,"\t"[0]);
    buffer_put(buffer_1,strnum,fmt_ulong(strnum,n));
    buffer_puts(buffer_1,"\t23:59:60\t");
    buffer_PUTC(buffer_1,ch);
    buffer_putsflush(buffer_1,"\tS\n");
  }

  _exit(0);
}
