
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSqlDriver.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QSqlDriver>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QSqlError>
#include <QSqlField>
#include <QSqlIndex>
#include <QSqlRecord>
#include <QSqlResult>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtSqlCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSqlDriver

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSqlDriver::staticMetaObject);
}


// bool QSqlDriver::beginTransaction()


static void _init_f_beginTransaction_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_beginTransaction_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlDriver *)cls)->beginTransaction ());
}


// bool QSqlDriver::cancelQuery()


static void _init_f_cancelQuery_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_cancelQuery_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlDriver *)cls)->cancelQuery ());
}


// void QSqlDriver::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlDriver *)cls)->close ();
}


// bool QSqlDriver::commitTransaction()


static void _init_f_commitTransaction_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_commitTransaction_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlDriver *)cls)->commitTransaction ());
}


// QSqlResult *QSqlDriver::createResult()


static void _init_f_createResult_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlResult * > ();
}

static void _call_f_createResult_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSqlResult * > ((QSqlResult *)((QSqlDriver *)cls)->createResult ());
}


// QSqlDriver::DbmsType QSqlDriver::dbmsType()


static void _init_f_dbmsType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSqlDriver::DbmsType>::target_type > ();
}

static void _call_f_dbmsType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSqlDriver::DbmsType>::target_type > ((qt_gsi::Converter<QSqlDriver::DbmsType>::target_type)qt_gsi::CppToQtAdaptor<QSqlDriver::DbmsType>(((QSqlDriver *)cls)->dbmsType ()));
}


// QString QSqlDriver::escapeIdentifier(const QString &identifier, QSqlDriver::IdentifierType type)


static void _init_f_escapeIdentifier_c4919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("identifier");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_escapeIdentifier_c4919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & >() (args, heap);
  ret.write<QString > ((QString)((QSqlDriver *)cls)->escapeIdentifier (arg1, qt_gsi::QtToCppAdaptor<QSqlDriver::IdentifierType>(arg2).cref()));
}


// QString QSqlDriver::formatValue(const QSqlField &field, bool trimStrings)


static void _init_f_formatValue_c2938 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("field");
  decl->add_arg<const QSqlField & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("trimStrings", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_formatValue_c2938 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSqlField &arg1 = gsi::arg_reader<const QSqlField & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (false, heap);
  ret.write<QString > ((QString)((QSqlDriver *)cls)->formatValue (arg1, arg2));
}


// QVariant QSqlDriver::handle()


static void _init_f_handle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVariant > ();
}

static void _call_f_handle_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVariant > ((QVariant)((QSqlDriver *)cls)->handle ());
}


// bool QSqlDriver::hasFeature(QSqlDriver::DriverFeature f)


static void _init_f_hasFeature_c2893 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::DriverFeature>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasFeature_c2893 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSqlDriver::DriverFeature>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSqlDriver::DriverFeature>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QSqlDriver *)cls)->hasFeature (qt_gsi::QtToCppAdaptor<QSqlDriver::DriverFeature>(arg1).cref()));
}


// bool QSqlDriver::isIdentifierEscaped(const QString &identifier, QSqlDriver::IdentifierType type)


static void _init_f_isIdentifierEscaped_c4919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("identifier");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isIdentifierEscaped_c4919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QSqlDriver *)cls)->isIdentifierEscaped (arg1, qt_gsi::QtToCppAdaptor<QSqlDriver::IdentifierType>(arg2).cref()));
}


// bool QSqlDriver::isOpen()


static void _init_f_isOpen_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isOpen_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlDriver *)cls)->isOpen ());
}


// bool QSqlDriver::isOpenError()


static void _init_f_isOpenError_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isOpenError_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlDriver *)cls)->isOpenError ());
}


// QSqlError QSqlDriver::lastError()


static void _init_f_lastError_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlError > ();
}

static void _call_f_lastError_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSqlError > ((QSqlError)((QSqlDriver *)cls)->lastError ());
}


// QSql::NumericalPrecisionPolicy QSqlDriver::numericalPrecisionPolicy()


static void _init_f_numericalPrecisionPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type > ();
}

static void _call_f_numericalPrecisionPolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type > ((qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type)qt_gsi::CppToQtAdaptor<QSql::NumericalPrecisionPolicy>(((QSqlDriver *)cls)->numericalPrecisionPolicy ()));
}


// bool QSqlDriver::open(const QString &db, const QString &user, const QString &password, const QString &host, int port, const QString &connOpts)


static void _init_f_open_10352 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("db");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("user", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("password", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("host", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("port", true, "-1");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("connOpts", true, "QString()");
  decl->add_arg<const QString & > (argspec_5);
  decl->set_return<bool > ();
}

static void _call_f_open_10352 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg4 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  int arg5 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  const QString &arg6 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<bool > ((bool)((QSqlDriver *)cls)->open (arg1, arg2, arg3, arg4, arg5, arg6));
}


// QSqlIndex QSqlDriver::primaryIndex(const QString &tableName)


static void _init_f_primaryIndex_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QSqlIndex > ();
}

static void _call_f_primaryIndex_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QSqlIndex > ((QSqlIndex)((QSqlDriver *)cls)->primaryIndex (arg1));
}


// QSqlRecord QSqlDriver::record(const QString &tableName)


static void _init_f_record_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QSqlRecord > ();
}

static void _call_f_record_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QSqlRecord > ((QSqlRecord)((QSqlDriver *)cls)->record (arg1));
}


// bool QSqlDriver::rollbackTransaction()


static void _init_f_rollbackTransaction_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_rollbackTransaction_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlDriver *)cls)->rollbackTransaction ());
}


// void QSqlDriver::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy precisionPolicy)


static void _init_f_setNumericalPrecisionPolicy_3429 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("precisionPolicy");
  decl->add_arg<const qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNumericalPrecisionPolicy_3429 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlDriver *)cls)->setNumericalPrecisionPolicy (qt_gsi::QtToCppAdaptor<QSql::NumericalPrecisionPolicy>(arg1).cref());
}


// QString QSqlDriver::sqlStatement(QSqlDriver::StatementType type, const QString &tableName, const QSqlRecord &rec, bool preparedStatement)


static void _init_f_sqlStatement_c7794 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::StatementType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("tableName");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rec");
  decl->add_arg<const QSqlRecord & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("preparedStatement");
  decl->add_arg<bool > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_f_sqlStatement_c7794 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSqlDriver::StatementType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSqlDriver::StatementType>::target_type & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QSqlRecord &arg3 = gsi::arg_reader<const QSqlRecord & >() (args, heap);
  bool arg4 = gsi::arg_reader<bool >() (args, heap);
  ret.write<QString > ((QString)((QSqlDriver *)cls)->sqlStatement (qt_gsi::QtToCppAdaptor<QSqlDriver::StatementType>(arg1).cref(), arg2, arg3, arg4));
}


// QString QSqlDriver::stripDelimiters(const QString &identifier, QSqlDriver::IdentifierType type)


static void _init_f_stripDelimiters_c4919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("identifier");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_stripDelimiters_c4919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & >() (args, heap);
  ret.write<QString > ((QString)((QSqlDriver *)cls)->stripDelimiters (arg1, qt_gsi::QtToCppAdaptor<QSqlDriver::IdentifierType>(arg2).cref()));
}


// bool QSqlDriver::subscribeToNotification(const QString &name)


static void _init_f_subscribeToNotification_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_subscribeToNotification_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QSqlDriver *)cls)->subscribeToNotification (arg1));
}


// QStringList QSqlDriver::subscribedToNotifications()


static void _init_f_subscribedToNotifications_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_subscribedToNotifications_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QSqlDriver *)cls)->subscribedToNotifications ());
}


// QStringList QSqlDriver::tables(QSql::TableType tableType)


static void _init_f_tables_c1843 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableType");
  decl->add_arg<const qt_gsi::Converter<QSql::TableType>::target_type & > (argspec_0);
  decl->set_return<QStringList > ();
}

static void _call_f_tables_c1843 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSql::TableType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSql::TableType>::target_type & >() (args, heap);
  ret.write<QStringList > ((QStringList)((QSqlDriver *)cls)->tables (qt_gsi::QtToCppAdaptor<QSql::TableType>(arg1).cref()));
}


// bool QSqlDriver::unsubscribeFromNotification(const QString &name)


static void _init_f_unsubscribeFromNotification_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_unsubscribeFromNotification_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QSqlDriver *)cls)->unsubscribeFromNotification (arg1));
}


// static QString QSqlDriver::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QSqlDriver::tr (arg1, arg2, arg3));
}


// static QString QSqlDriver::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QSqlDriver::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QSqlDriver () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("beginTransaction", "@brief Method bool QSqlDriver::beginTransaction()\n", false, &_init_f_beginTransaction_0, &_call_f_beginTransaction_0);
  methods += new qt_gsi::GenericMethod ("cancelQuery", "@brief Method bool QSqlDriver::cancelQuery()\n", false, &_init_f_cancelQuery_0, &_call_f_cancelQuery_0);
  methods += new qt_gsi::GenericMethod ("close", "@brief Method void QSqlDriver::close()\n", false, &_init_f_close_0, &_call_f_close_0);
  methods += new qt_gsi::GenericMethod ("commitTransaction", "@brief Method bool QSqlDriver::commitTransaction()\n", false, &_init_f_commitTransaction_0, &_call_f_commitTransaction_0);
  methods += new qt_gsi::GenericMethod ("createResult", "@brief Method QSqlResult *QSqlDriver::createResult()\n", true, &_init_f_createResult_c0, &_call_f_createResult_c0);
  methods += new qt_gsi::GenericMethod ("dbmsType", "@brief Method QSqlDriver::DbmsType QSqlDriver::dbmsType()\n", true, &_init_f_dbmsType_c0, &_call_f_dbmsType_c0);
  methods += new qt_gsi::GenericMethod ("escapeIdentifier", "@brief Method QString QSqlDriver::escapeIdentifier(const QString &identifier, QSqlDriver::IdentifierType type)\n", true, &_init_f_escapeIdentifier_c4919, &_call_f_escapeIdentifier_c4919);
  methods += new qt_gsi::GenericMethod ("formatValue", "@brief Method QString QSqlDriver::formatValue(const QSqlField &field, bool trimStrings)\n", true, &_init_f_formatValue_c2938, &_call_f_formatValue_c2938);
  methods += new qt_gsi::GenericMethod ("handle", "@brief Method QVariant QSqlDriver::handle()\n", true, &_init_f_handle_c0, &_call_f_handle_c0);
  methods += new qt_gsi::GenericMethod ("hasFeature", "@brief Method bool QSqlDriver::hasFeature(QSqlDriver::DriverFeature f)\n", true, &_init_f_hasFeature_c2893, &_call_f_hasFeature_c2893);
  methods += new qt_gsi::GenericMethod ("isIdentifierEscaped?", "@brief Method bool QSqlDriver::isIdentifierEscaped(const QString &identifier, QSqlDriver::IdentifierType type)\n", true, &_init_f_isIdentifierEscaped_c4919, &_call_f_isIdentifierEscaped_c4919);
  methods += new qt_gsi::GenericMethod ("isOpen?", "@brief Method bool QSqlDriver::isOpen()\n", true, &_init_f_isOpen_c0, &_call_f_isOpen_c0);
  methods += new qt_gsi::GenericMethod ("isOpenError?", "@brief Method bool QSqlDriver::isOpenError()\n", true, &_init_f_isOpenError_c0, &_call_f_isOpenError_c0);
  methods += new qt_gsi::GenericMethod ("lastError", "@brief Method QSqlError QSqlDriver::lastError()\n", true, &_init_f_lastError_c0, &_call_f_lastError_c0);
  methods += new qt_gsi::GenericMethod (":numericalPrecisionPolicy", "@brief Method QSql::NumericalPrecisionPolicy QSqlDriver::numericalPrecisionPolicy()\n", true, &_init_f_numericalPrecisionPolicy_c0, &_call_f_numericalPrecisionPolicy_c0);
  methods += new qt_gsi::GenericMethod ("open", "@brief Method bool QSqlDriver::open(const QString &db, const QString &user, const QString &password, const QString &host, int port, const QString &connOpts)\n", false, &_init_f_open_10352, &_call_f_open_10352);
  methods += new qt_gsi::GenericMethod ("primaryIndex", "@brief Method QSqlIndex QSqlDriver::primaryIndex(const QString &tableName)\n", true, &_init_f_primaryIndex_c2025, &_call_f_primaryIndex_c2025);
  methods += new qt_gsi::GenericMethod ("record", "@brief Method QSqlRecord QSqlDriver::record(const QString &tableName)\n", true, &_init_f_record_c2025, &_call_f_record_c2025);
  methods += new qt_gsi::GenericMethod ("rollbackTransaction", "@brief Method bool QSqlDriver::rollbackTransaction()\n", false, &_init_f_rollbackTransaction_0, &_call_f_rollbackTransaction_0);
  methods += new qt_gsi::GenericMethod ("setNumericalPrecisionPolicy|numericalPrecisionPolicy=", "@brief Method void QSqlDriver::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy precisionPolicy)\n", false, &_init_f_setNumericalPrecisionPolicy_3429, &_call_f_setNumericalPrecisionPolicy_3429);
  methods += new qt_gsi::GenericMethod ("sqlStatement", "@brief Method QString QSqlDriver::sqlStatement(QSqlDriver::StatementType type, const QString &tableName, const QSqlRecord &rec, bool preparedStatement)\n", true, &_init_f_sqlStatement_c7794, &_call_f_sqlStatement_c7794);
  methods += new qt_gsi::GenericMethod ("stripDelimiters", "@brief Method QString QSqlDriver::stripDelimiters(const QString &identifier, QSqlDriver::IdentifierType type)\n", true, &_init_f_stripDelimiters_c4919, &_call_f_stripDelimiters_c4919);
  methods += new qt_gsi::GenericMethod ("subscribeToNotification", "@brief Method bool QSqlDriver::subscribeToNotification(const QString &name)\n", false, &_init_f_subscribeToNotification_2025, &_call_f_subscribeToNotification_2025);
  methods += new qt_gsi::GenericMethod ("subscribedToNotifications", "@brief Method QStringList QSqlDriver::subscribedToNotifications()\n", true, &_init_f_subscribedToNotifications_c0, &_call_f_subscribedToNotifications_c0);
  methods += new qt_gsi::GenericMethod ("tables", "@brief Method QStringList QSqlDriver::tables(QSql::TableType tableType)\n", true, &_init_f_tables_c1843, &_call_f_tables_c1843);
  methods += new qt_gsi::GenericMethod ("unsubscribeFromNotification", "@brief Method bool QSqlDriver::unsubscribeFromNotification(const QString &name)\n", false, &_init_f_unsubscribeFromNotification_2025, &_call_f_unsubscribeFromNotification_2025);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QSqlDriver::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("notification(const QString &)", "notification", gsi::arg("name"), "@brief Signal declaration for QSqlDriver::notification(const QString &name)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString &, const qt_gsi::Converter<QSqlDriver::NotificationSource>::target_type &, const QVariant & > ("notification(const QString &, QSqlDriver::NotificationSource, const QVariant &)", "notification_withData", gsi::arg("name"), gsi::arg("source"), gsi::arg("payload"), "@brief Signal declaration for QSqlDriver::notification(const QString &name, QSqlDriver::NotificationSource source, const QVariant &payload)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QSqlDriver::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSqlDriver::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSqlDriver::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QSqlDriver> decl_QSqlDriver (qtdecl_QObject (), "QtSql", "QSqlDriver_Native",
  methods_QSqlDriver (),
  "@hide\n@alias QSqlDriver");

GSI_QTSQL_PUBLIC gsi::Class<QSqlDriver> &qtdecl_QSqlDriver () { return decl_QSqlDriver; }

}


class QSqlDriver_Adaptor : public QSqlDriver, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSqlDriver_Adaptor();

  //  [adaptor ctor] QSqlDriver::QSqlDriver(QObject *parent)
  QSqlDriver_Adaptor() : QSqlDriver()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSqlDriver::QSqlDriver(QObject *parent)
  QSqlDriver_Adaptor(QObject *parent) : QSqlDriver(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QSqlDriver::isSignalConnected(const QMetaMethod &signal)
  bool fp_QSqlDriver_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QSqlDriver::isSignalConnected(signal);
  }

  //  [expose] int QSqlDriver::receivers(const char *signal)
  int fp_QSqlDriver_receivers_c1731 (const char *signal) const {
    return QSqlDriver::receivers(signal);
  }

  //  [expose] QObject *QSqlDriver::sender()
  QObject * fp_QSqlDriver_sender_c0 () const {
    return QSqlDriver::sender();
  }

  //  [expose] int QSqlDriver::senderSignalIndex()
  int fp_QSqlDriver_senderSignalIndex_c0 () const {
    return QSqlDriver::senderSignalIndex();
  }

  //  [adaptor impl] bool QSqlDriver::beginTransaction()
  bool cbs_beginTransaction_0_0()
  {
    return QSqlDriver::beginTransaction();
  }

  virtual bool beginTransaction()
  {
    if (cb_beginTransaction_0_0.can_issue()) {
      return cb_beginTransaction_0_0.issue<QSqlDriver_Adaptor, bool>(&QSqlDriver_Adaptor::cbs_beginTransaction_0_0);
    } else {
      return QSqlDriver::beginTransaction();
    }
  }

  //  [adaptor impl] bool QSqlDriver::cancelQuery()
  bool cbs_cancelQuery_0_0()
  {
    return QSqlDriver::cancelQuery();
  }

  virtual bool cancelQuery()
  {
    if (cb_cancelQuery_0_0.can_issue()) {
      return cb_cancelQuery_0_0.issue<QSqlDriver_Adaptor, bool>(&QSqlDriver_Adaptor::cbs_cancelQuery_0_0);
    } else {
      return QSqlDriver::cancelQuery();
    }
  }

  //  [adaptor impl] void QSqlDriver::close()
  void cbs_close_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("close");
  }

  virtual void close()
  {
    if (cb_close_0_0.can_issue()) {
      cb_close_0_0.issue<QSqlDriver_Adaptor>(&QSqlDriver_Adaptor::cbs_close_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("close");
    }
  }

  //  [adaptor impl] bool QSqlDriver::commitTransaction()
  bool cbs_commitTransaction_0_0()
  {
    return QSqlDriver::commitTransaction();
  }

  virtual bool commitTransaction()
  {
    if (cb_commitTransaction_0_0.can_issue()) {
      return cb_commitTransaction_0_0.issue<QSqlDriver_Adaptor, bool>(&QSqlDriver_Adaptor::cbs_commitTransaction_0_0);
    } else {
      return QSqlDriver::commitTransaction();
    }
  }

  //  [adaptor impl] QSqlResult *QSqlDriver::createResult()
  QSqlResult * cbs_createResult_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("createResult");
  }

  virtual QSqlResult * createResult() const
  {
    if (cb_createResult_c0_0.can_issue()) {
      return cb_createResult_c0_0.issue<QSqlDriver_Adaptor, QSqlResult *>(&QSqlDriver_Adaptor::cbs_createResult_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("createResult");
    }
  }

  //  [emitter impl] void QSqlDriver::destroyed(QObject *)
  void emitter_QSqlDriver_destroyed_1302(QObject *arg1)
  {
    emit QSqlDriver::destroyed(arg1);
  }

  //  [adaptor impl] QString QSqlDriver::escapeIdentifier(const QString &identifier, QSqlDriver::IdentifierType type)
  QString cbs_escapeIdentifier_c4919_0(const QString &identifier, const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & type) const
  {
    return QSqlDriver::escapeIdentifier(identifier, qt_gsi::QtToCppAdaptor<QSqlDriver::IdentifierType>(type).cref());
  }

  virtual QString escapeIdentifier(const QString &identifier, QSqlDriver::IdentifierType type) const
  {
    if (cb_escapeIdentifier_c4919_0.can_issue()) {
      return cb_escapeIdentifier_c4919_0.issue<QSqlDriver_Adaptor, QString, const QString &, const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type &>(&QSqlDriver_Adaptor::cbs_escapeIdentifier_c4919_0, identifier, qt_gsi::CppToQtAdaptor<QSqlDriver::IdentifierType>(type));
    } else {
      return QSqlDriver::escapeIdentifier(identifier, type);
    }
  }

  //  [adaptor impl] bool QSqlDriver::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QSqlDriver::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSqlDriver_Adaptor, bool, QEvent *>(&QSqlDriver_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QSqlDriver::event(_event);
    }
  }

  //  [adaptor impl] bool QSqlDriver::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QSqlDriver::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSqlDriver_Adaptor, bool, QObject *, QEvent *>(&QSqlDriver_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QSqlDriver::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] QString QSqlDriver::formatValue(const QSqlField &field, bool trimStrings)
  QString cbs_formatValue_c2938_1(const QSqlField &field, bool trimStrings) const
  {
    return QSqlDriver::formatValue(field, trimStrings);
  }

  virtual QString formatValue(const QSqlField &field, bool trimStrings) const
  {
    if (cb_formatValue_c2938_1.can_issue()) {
      return cb_formatValue_c2938_1.issue<QSqlDriver_Adaptor, QString, const QSqlField &, bool>(&QSqlDriver_Adaptor::cbs_formatValue_c2938_1, field, trimStrings);
    } else {
      return QSqlDriver::formatValue(field, trimStrings);
    }
  }

  //  [adaptor impl] QVariant QSqlDriver::handle()
  QVariant cbs_handle_c0_0() const
  {
    return QSqlDriver::handle();
  }

  virtual QVariant handle() const
  {
    if (cb_handle_c0_0.can_issue()) {
      return cb_handle_c0_0.issue<QSqlDriver_Adaptor, QVariant>(&QSqlDriver_Adaptor::cbs_handle_c0_0);
    } else {
      return QSqlDriver::handle();
    }
  }

  //  [adaptor impl] bool QSqlDriver::hasFeature(QSqlDriver::DriverFeature f)
  bool cbs_hasFeature_c2893_0(const qt_gsi::Converter<QSqlDriver::DriverFeature>::target_type & f) const
  {
    __SUPPRESS_UNUSED_WARNING (f);
    throw qt_gsi::AbstractMethodCalledException("hasFeature");
  }

  virtual bool hasFeature(QSqlDriver::DriverFeature f) const
  {
    if (cb_hasFeature_c2893_0.can_issue()) {
      return cb_hasFeature_c2893_0.issue<QSqlDriver_Adaptor, bool, const qt_gsi::Converter<QSqlDriver::DriverFeature>::target_type &>(&QSqlDriver_Adaptor::cbs_hasFeature_c2893_0, qt_gsi::CppToQtAdaptor<QSqlDriver::DriverFeature>(f));
    } else {
      throw qt_gsi::AbstractMethodCalledException("hasFeature");
    }
  }

  //  [adaptor impl] bool QSqlDriver::isIdentifierEscaped(const QString &identifier, QSqlDriver::IdentifierType type)
  bool cbs_isIdentifierEscaped_c4919_0(const QString &identifier, const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & type) const
  {
    return QSqlDriver::isIdentifierEscaped(identifier, qt_gsi::QtToCppAdaptor<QSqlDriver::IdentifierType>(type).cref());
  }

  virtual bool isIdentifierEscaped(const QString &identifier, QSqlDriver::IdentifierType type) const
  {
    if (cb_isIdentifierEscaped_c4919_0.can_issue()) {
      return cb_isIdentifierEscaped_c4919_0.issue<QSqlDriver_Adaptor, bool, const QString &, const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type &>(&QSqlDriver_Adaptor::cbs_isIdentifierEscaped_c4919_0, identifier, qt_gsi::CppToQtAdaptor<QSqlDriver::IdentifierType>(type));
    } else {
      return QSqlDriver::isIdentifierEscaped(identifier, type);
    }
  }

  //  [adaptor impl] bool QSqlDriver::isOpen()
  bool cbs_isOpen_c0_0() const
  {
    return QSqlDriver::isOpen();
  }

  virtual bool isOpen() const
  {
    if (cb_isOpen_c0_0.can_issue()) {
      return cb_isOpen_c0_0.issue<QSqlDriver_Adaptor, bool>(&QSqlDriver_Adaptor::cbs_isOpen_c0_0);
    } else {
      return QSqlDriver::isOpen();
    }
  }

  //  [emitter impl] void QSqlDriver::notification(const QString &name)
  void emitter_QSqlDriver_notification_2025(const QString &name)
  {
    emit QSqlDriver::notification(name);
  }

  //  [emitter impl] void QSqlDriver::notification(const QString &name, QSqlDriver::NotificationSource source, const QVariant &payload)
  void emitter_QSqlDriver_notification_7365(const QString &name, QSqlDriver::NotificationSource source, const QVariant &payload)
  {
    emit QSqlDriver::notification(name, source, payload);
  }

  //  [emitter impl] void QSqlDriver::objectNameChanged(const QString &objectName)
  void emitter_QSqlDriver_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QSqlDriver::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] bool QSqlDriver::open(const QString &db, const QString &user, const QString &password, const QString &host, int port, const QString &connOpts)
  bool cbs_open_10352_5(const QString &db, const QString &user, const QString &password, const QString &host, int port, const QString &connOpts)
  {
    __SUPPRESS_UNUSED_WARNING (db);
    __SUPPRESS_UNUSED_WARNING (user);
    __SUPPRESS_UNUSED_WARNING (password);
    __SUPPRESS_UNUSED_WARNING (host);
    __SUPPRESS_UNUSED_WARNING (port);
    __SUPPRESS_UNUSED_WARNING (connOpts);
    throw qt_gsi::AbstractMethodCalledException("open");
  }

  virtual bool open(const QString &db, const QString &user, const QString &password, const QString &host, int port, const QString &connOpts)
  {
    if (cb_open_10352_5.can_issue()) {
      return cb_open_10352_5.issue<QSqlDriver_Adaptor, bool, const QString &, const QString &, const QString &, const QString &, int, const QString &>(&QSqlDriver_Adaptor::cbs_open_10352_5, db, user, password, host, port, connOpts);
    } else {
      throw qt_gsi::AbstractMethodCalledException("open");
    }
  }

  //  [adaptor impl] QSqlIndex QSqlDriver::primaryIndex(const QString &tableName)
  QSqlIndex cbs_primaryIndex_c2025_0(const QString &tableName) const
  {
    return QSqlDriver::primaryIndex(tableName);
  }

  virtual QSqlIndex primaryIndex(const QString &tableName) const
  {
    if (cb_primaryIndex_c2025_0.can_issue()) {
      return cb_primaryIndex_c2025_0.issue<QSqlDriver_Adaptor, QSqlIndex, const QString &>(&QSqlDriver_Adaptor::cbs_primaryIndex_c2025_0, tableName);
    } else {
      return QSqlDriver::primaryIndex(tableName);
    }
  }

  //  [adaptor impl] QSqlRecord QSqlDriver::record(const QString &tableName)
  QSqlRecord cbs_record_c2025_0(const QString &tableName) const
  {
    return QSqlDriver::record(tableName);
  }

  virtual QSqlRecord record(const QString &tableName) const
  {
    if (cb_record_c2025_0.can_issue()) {
      return cb_record_c2025_0.issue<QSqlDriver_Adaptor, QSqlRecord, const QString &>(&QSqlDriver_Adaptor::cbs_record_c2025_0, tableName);
    } else {
      return QSqlDriver::record(tableName);
    }
  }

  //  [adaptor impl] bool QSqlDriver::rollbackTransaction()
  bool cbs_rollbackTransaction_0_0()
  {
    return QSqlDriver::rollbackTransaction();
  }

  virtual bool rollbackTransaction()
  {
    if (cb_rollbackTransaction_0_0.can_issue()) {
      return cb_rollbackTransaction_0_0.issue<QSqlDriver_Adaptor, bool>(&QSqlDriver_Adaptor::cbs_rollbackTransaction_0_0);
    } else {
      return QSqlDriver::rollbackTransaction();
    }
  }

  //  [adaptor impl] QString QSqlDriver::sqlStatement(QSqlDriver::StatementType type, const QString &tableName, const QSqlRecord &rec, bool preparedStatement)
  QString cbs_sqlStatement_c7794_0(const qt_gsi::Converter<QSqlDriver::StatementType>::target_type & type, const QString &tableName, const QSqlRecord &rec, bool preparedStatement) const
  {
    return QSqlDriver::sqlStatement(qt_gsi::QtToCppAdaptor<QSqlDriver::StatementType>(type).cref(), tableName, rec, preparedStatement);
  }

  virtual QString sqlStatement(QSqlDriver::StatementType type, const QString &tableName, const QSqlRecord &rec, bool preparedStatement) const
  {
    if (cb_sqlStatement_c7794_0.can_issue()) {
      return cb_sqlStatement_c7794_0.issue<QSqlDriver_Adaptor, QString, const qt_gsi::Converter<QSqlDriver::StatementType>::target_type &, const QString &, const QSqlRecord &, bool>(&QSqlDriver_Adaptor::cbs_sqlStatement_c7794_0, qt_gsi::CppToQtAdaptor<QSqlDriver::StatementType>(type), tableName, rec, preparedStatement);
    } else {
      return QSqlDriver::sqlStatement(type, tableName, rec, preparedStatement);
    }
  }

  //  [adaptor impl] QString QSqlDriver::stripDelimiters(const QString &identifier, QSqlDriver::IdentifierType type)
  QString cbs_stripDelimiters_c4919_0(const QString &identifier, const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & type) const
  {
    return QSqlDriver::stripDelimiters(identifier, qt_gsi::QtToCppAdaptor<QSqlDriver::IdentifierType>(type).cref());
  }

  virtual QString stripDelimiters(const QString &identifier, QSqlDriver::IdentifierType type) const
  {
    if (cb_stripDelimiters_c4919_0.can_issue()) {
      return cb_stripDelimiters_c4919_0.issue<QSqlDriver_Adaptor, QString, const QString &, const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type &>(&QSqlDriver_Adaptor::cbs_stripDelimiters_c4919_0, identifier, qt_gsi::CppToQtAdaptor<QSqlDriver::IdentifierType>(type));
    } else {
      return QSqlDriver::stripDelimiters(identifier, type);
    }
  }

  //  [adaptor impl] bool QSqlDriver::subscribeToNotification(const QString &name)
  bool cbs_subscribeToNotification_2025_0(const QString &name)
  {
    return QSqlDriver::subscribeToNotification(name);
  }

  virtual bool subscribeToNotification(const QString &name)
  {
    if (cb_subscribeToNotification_2025_0.can_issue()) {
      return cb_subscribeToNotification_2025_0.issue<QSqlDriver_Adaptor, bool, const QString &>(&QSqlDriver_Adaptor::cbs_subscribeToNotification_2025_0, name);
    } else {
      return QSqlDriver::subscribeToNotification(name);
    }
  }

  //  [adaptor impl] QStringList QSqlDriver::subscribedToNotifications()
  QStringList cbs_subscribedToNotifications_c0_0() const
  {
    return QSqlDriver::subscribedToNotifications();
  }

  virtual QStringList subscribedToNotifications() const
  {
    if (cb_subscribedToNotifications_c0_0.can_issue()) {
      return cb_subscribedToNotifications_c0_0.issue<QSqlDriver_Adaptor, QStringList>(&QSqlDriver_Adaptor::cbs_subscribedToNotifications_c0_0);
    } else {
      return QSqlDriver::subscribedToNotifications();
    }
  }

  //  [adaptor impl] QStringList QSqlDriver::tables(QSql::TableType tableType)
  QStringList cbs_tables_c1843_0(const qt_gsi::Converter<QSql::TableType>::target_type & tableType) const
  {
    return QSqlDriver::tables(qt_gsi::QtToCppAdaptor<QSql::TableType>(tableType).cref());
  }

  virtual QStringList tables(QSql::TableType tableType) const
  {
    if (cb_tables_c1843_0.can_issue()) {
      return cb_tables_c1843_0.issue<QSqlDriver_Adaptor, QStringList, const qt_gsi::Converter<QSql::TableType>::target_type &>(&QSqlDriver_Adaptor::cbs_tables_c1843_0, qt_gsi::CppToQtAdaptor<QSql::TableType>(tableType));
    } else {
      return QSqlDriver::tables(tableType);
    }
  }

  //  [adaptor impl] bool QSqlDriver::unsubscribeFromNotification(const QString &name)
  bool cbs_unsubscribeFromNotification_2025_0(const QString &name)
  {
    return QSqlDriver::unsubscribeFromNotification(name);
  }

  virtual bool unsubscribeFromNotification(const QString &name)
  {
    if (cb_unsubscribeFromNotification_2025_0.can_issue()) {
      return cb_unsubscribeFromNotification_2025_0.issue<QSqlDriver_Adaptor, bool, const QString &>(&QSqlDriver_Adaptor::cbs_unsubscribeFromNotification_2025_0, name);
    } else {
      return QSqlDriver::unsubscribeFromNotification(name);
    }
  }

  //  [adaptor impl] void QSqlDriver::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QSqlDriver::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSqlDriver_Adaptor, QChildEvent *>(&QSqlDriver_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QSqlDriver::childEvent(event);
    }
  }

  //  [adaptor impl] void QSqlDriver::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QSqlDriver::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSqlDriver_Adaptor, QEvent *>(&QSqlDriver_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QSqlDriver::customEvent(event);
    }
  }

  //  [adaptor impl] void QSqlDriver::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QSqlDriver::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QSqlDriver_Adaptor, const QMetaMethod &>(&QSqlDriver_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QSqlDriver::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QSqlDriver::setLastError(const QSqlError &e)
  void cbs_setLastError_2220_0(const QSqlError &e)
  {
    QSqlDriver::setLastError(e);
  }

  virtual void setLastError(const QSqlError &e)
  {
    if (cb_setLastError_2220_0.can_issue()) {
      cb_setLastError_2220_0.issue<QSqlDriver_Adaptor, const QSqlError &>(&QSqlDriver_Adaptor::cbs_setLastError_2220_0, e);
    } else {
      QSqlDriver::setLastError(e);
    }
  }

  //  [adaptor impl] void QSqlDriver::setOpen(bool o)
  void cbs_setOpen_864_0(bool o)
  {
    QSqlDriver::setOpen(o);
  }

  virtual void setOpen(bool o)
  {
    if (cb_setOpen_864_0.can_issue()) {
      cb_setOpen_864_0.issue<QSqlDriver_Adaptor, bool>(&QSqlDriver_Adaptor::cbs_setOpen_864_0, o);
    } else {
      QSqlDriver::setOpen(o);
    }
  }

  //  [adaptor impl] void QSqlDriver::setOpenError(bool e)
  void cbs_setOpenError_864_0(bool e)
  {
    QSqlDriver::setOpenError(e);
  }

  virtual void setOpenError(bool e)
  {
    if (cb_setOpenError_864_0.can_issue()) {
      cb_setOpenError_864_0.issue<QSqlDriver_Adaptor, bool>(&QSqlDriver_Adaptor::cbs_setOpenError_864_0, e);
    } else {
      QSqlDriver::setOpenError(e);
    }
  }

  //  [adaptor impl] void QSqlDriver::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QSqlDriver::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSqlDriver_Adaptor, QTimerEvent *>(&QSqlDriver_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QSqlDriver::timerEvent(event);
    }
  }

  gsi::Callback cb_beginTransaction_0_0;
  gsi::Callback cb_cancelQuery_0_0;
  gsi::Callback cb_close_0_0;
  gsi::Callback cb_commitTransaction_0_0;
  gsi::Callback cb_createResult_c0_0;
  gsi::Callback cb_escapeIdentifier_c4919_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_formatValue_c2938_1;
  gsi::Callback cb_handle_c0_0;
  gsi::Callback cb_hasFeature_c2893_0;
  gsi::Callback cb_isIdentifierEscaped_c4919_0;
  gsi::Callback cb_isOpen_c0_0;
  gsi::Callback cb_open_10352_5;
  gsi::Callback cb_primaryIndex_c2025_0;
  gsi::Callback cb_record_c2025_0;
  gsi::Callback cb_rollbackTransaction_0_0;
  gsi::Callback cb_sqlStatement_c7794_0;
  gsi::Callback cb_stripDelimiters_c4919_0;
  gsi::Callback cb_subscribeToNotification_2025_0;
  gsi::Callback cb_subscribedToNotifications_c0_0;
  gsi::Callback cb_tables_c1843_0;
  gsi::Callback cb_unsubscribeFromNotification_2025_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_setLastError_2220_0;
  gsi::Callback cb_setOpen_864_0;
  gsi::Callback cb_setOpenError_864_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QSqlDriver_Adaptor::~QSqlDriver_Adaptor() { }

//  Constructor QSqlDriver::QSqlDriver(QObject *parent) (adaptor class)

static void _init_ctor_QSqlDriver_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QSqlDriver_Adaptor> ();
}

static void _call_ctor_QSqlDriver_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QSqlDriver_Adaptor *> (new QSqlDriver_Adaptor (arg1));
}


// bool QSqlDriver::beginTransaction()

static void _init_cbs_beginTransaction_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_beginTransaction_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_beginTransaction_0_0 ());
}

static void _set_callback_cbs_beginTransaction_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_beginTransaction_0_0 = cb;
}


// bool QSqlDriver::cancelQuery()

static void _init_cbs_cancelQuery_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_cancelQuery_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_cancelQuery_0_0 ());
}

static void _set_callback_cbs_cancelQuery_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_cancelQuery_0_0 = cb;
}


// void QSqlDriver::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlDriver_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QSqlDriver::close()

static void _init_cbs_close_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_close_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlDriver_Adaptor *)cls)->cbs_close_0_0 ();
}

static void _set_callback_cbs_close_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_close_0_0 = cb;
}


// bool QSqlDriver::commitTransaction()

static void _init_cbs_commitTransaction_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_commitTransaction_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_commitTransaction_0_0 ());
}

static void _set_callback_cbs_commitTransaction_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_commitTransaction_0_0 = cb;
}


// QSqlResult *QSqlDriver::createResult()

static void _init_cbs_createResult_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlResult * > ();
}

static void _call_cbs_createResult_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSqlResult * > ((QSqlResult *)((QSqlDriver_Adaptor *)cls)->cbs_createResult_c0_0 ());
}

static void _set_callback_cbs_createResult_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_createResult_c0_0 = cb;
}


// void QSqlDriver::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlDriver_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QSqlDriver::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QSqlDriver_Adaptor *)cls)->emitter_QSqlDriver_destroyed_1302 (arg1);
}


// void QSqlDriver::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlDriver_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// QString QSqlDriver::escapeIdentifier(const QString &identifier, QSqlDriver::IdentifierType type)

static void _init_cbs_escapeIdentifier_c4919_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("identifier");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_cbs_escapeIdentifier_c4919_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & arg2 = args.read<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > (heap);
  ret.write<QString > ((QString)((QSqlDriver_Adaptor *)cls)->cbs_escapeIdentifier_c4919_0 (arg1, arg2));
}

static void _set_callback_cbs_escapeIdentifier_c4919_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_escapeIdentifier_c4919_0 = cb;
}


// bool QSqlDriver::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QSqlDriver::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QString QSqlDriver::formatValue(const QSqlField &field, bool trimStrings)

static void _init_cbs_formatValue_c2938_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("field");
  decl->add_arg<const QSqlField & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("trimStrings");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_cbs_formatValue_c2938_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSqlField &arg1 = args.read<const QSqlField & > (heap);
  bool arg2 = args.read<bool > (heap);
  ret.write<QString > ((QString)((QSqlDriver_Adaptor *)cls)->cbs_formatValue_c2938_1 (arg1, arg2));
}

static void _set_callback_cbs_formatValue_c2938_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_formatValue_c2938_1 = cb;
}


// QVariant QSqlDriver::handle()

static void _init_cbs_handle_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVariant > ();
}

static void _call_cbs_handle_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVariant > ((QVariant)((QSqlDriver_Adaptor *)cls)->cbs_handle_c0_0 ());
}

static void _set_callback_cbs_handle_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_handle_c0_0 = cb;
}


// bool QSqlDriver::hasFeature(QSqlDriver::DriverFeature f)

static void _init_cbs_hasFeature_c2893_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::DriverFeature>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_hasFeature_c2893_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSqlDriver::DriverFeature>::target_type & arg1 = args.read<const qt_gsi::Converter<QSqlDriver::DriverFeature>::target_type & > (heap);
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_hasFeature_c2893_0 (arg1));
}

static void _set_callback_cbs_hasFeature_c2893_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_hasFeature_c2893_0 = cb;
}


// bool QSqlDriver::isIdentifierEscaped(const QString &identifier, QSqlDriver::IdentifierType type)

static void _init_cbs_isIdentifierEscaped_c4919_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("identifier");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_isIdentifierEscaped_c4919_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & arg2 = args.read<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > (heap);
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_isIdentifierEscaped_c4919_0 (arg1, arg2));
}

static void _set_callback_cbs_isIdentifierEscaped_c4919_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_isIdentifierEscaped_c4919_0 = cb;
}


// bool QSqlDriver::isOpen()

static void _init_cbs_isOpen_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isOpen_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_isOpen_c0_0 ());
}

static void _set_callback_cbs_isOpen_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_isOpen_c0_0 = cb;
}


// exposed bool QSqlDriver::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->fp_QSqlDriver_isSignalConnected_c2394 (arg1));
}


// emitter void QSqlDriver::notification(const QString &name)

static void _init_emitter_notification_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_notification_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QSqlDriver_Adaptor *)cls)->emitter_QSqlDriver_notification_2025 (arg1);
}


// emitter void QSqlDriver::notification(const QString &name, QSqlDriver::NotificationSource source, const QVariant &payload)

static void _init_emitter_notification_7365 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("source");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::NotificationSource>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("payload");
  decl->add_arg<const QVariant & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_notification_7365 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QSqlDriver::NotificationSource>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QSqlDriver::NotificationSource>::target_type & >() (args, heap);
  const QVariant &arg3 = gsi::arg_reader<const QVariant & >() (args, heap);
  ((QSqlDriver_Adaptor *)cls)->emitter_QSqlDriver_notification_7365 (arg1, arg2, arg3);
}


// emitter void QSqlDriver::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QSqlDriver_Adaptor *)cls)->emitter_QSqlDriver_objectNameChanged_4567 (arg1);
}


// bool QSqlDriver::open(const QString &db, const QString &user, const QString &password, const QString &host, int port, const QString &connOpts)

static void _init_cbs_open_10352_5 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("db");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("user");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("password");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("host");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("port");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("connOpts");
  decl->add_arg<const QString & > (argspec_5);
  decl->set_return<bool > ();
}

static void _call_cbs_open_10352_5 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  const QString &arg2 = args.read<const QString & > (heap);
  const QString &arg3 = args.read<const QString & > (heap);
  const QString &arg4 = args.read<const QString & > (heap);
  int arg5 = args.read<int > (heap);
  const QString &arg6 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_open_10352_5 (arg1, arg2, arg3, arg4, arg5, arg6));
}

static void _set_callback_cbs_open_10352_5 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_open_10352_5 = cb;
}


// QSqlIndex QSqlDriver::primaryIndex(const QString &tableName)

static void _init_cbs_primaryIndex_c2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QSqlIndex > ();
}

static void _call_cbs_primaryIndex_c2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QSqlIndex > ((QSqlIndex)((QSqlDriver_Adaptor *)cls)->cbs_primaryIndex_c2025_0 (arg1));
}

static void _set_callback_cbs_primaryIndex_c2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_primaryIndex_c2025_0 = cb;
}


// exposed int QSqlDriver::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QSqlDriver_Adaptor *)cls)->fp_QSqlDriver_receivers_c1731 (arg1));
}


// QSqlRecord QSqlDriver::record(const QString &tableName)

static void _init_cbs_record_c2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QSqlRecord > ();
}

static void _call_cbs_record_c2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QSqlRecord > ((QSqlRecord)((QSqlDriver_Adaptor *)cls)->cbs_record_c2025_0 (arg1));
}

static void _set_callback_cbs_record_c2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_record_c2025_0 = cb;
}


// bool QSqlDriver::rollbackTransaction()

static void _init_cbs_rollbackTransaction_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_rollbackTransaction_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_rollbackTransaction_0_0 ());
}

static void _set_callback_cbs_rollbackTransaction_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_rollbackTransaction_0_0 = cb;
}


// exposed QObject *QSqlDriver::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QSqlDriver_Adaptor *)cls)->fp_QSqlDriver_sender_c0 ());
}


// exposed int QSqlDriver::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSqlDriver_Adaptor *)cls)->fp_QSqlDriver_senderSignalIndex_c0 ());
}


// void QSqlDriver::setLastError(const QSqlError &e)

static void _init_cbs_setLastError_2220_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<const QSqlError & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setLastError_2220_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSqlError &arg1 = args.read<const QSqlError & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlDriver_Adaptor *)cls)->cbs_setLastError_2220_0 (arg1);
}

static void _set_callback_cbs_setLastError_2220_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_setLastError_2220_0 = cb;
}


// void QSqlDriver::setOpen(bool o)

static void _init_cbs_setOpen_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("o");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setOpen_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlDriver_Adaptor *)cls)->cbs_setOpen_864_0 (arg1);
}

static void _set_callback_cbs_setOpen_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_setOpen_864_0 = cb;
}


// void QSqlDriver::setOpenError(bool e)

static void _init_cbs_setOpenError_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setOpenError_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlDriver_Adaptor *)cls)->cbs_setOpenError_864_0 (arg1);
}

static void _set_callback_cbs_setOpenError_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_setOpenError_864_0 = cb;
}


// QString QSqlDriver::sqlStatement(QSqlDriver::StatementType type, const QString &tableName, const QSqlRecord &rec, bool preparedStatement)

static void _init_cbs_sqlStatement_c7794_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::StatementType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("tableName");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rec");
  decl->add_arg<const QSqlRecord & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("preparedStatement");
  decl->add_arg<bool > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_cbs_sqlStatement_c7794_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSqlDriver::StatementType>::target_type & arg1 = args.read<const qt_gsi::Converter<QSqlDriver::StatementType>::target_type & > (heap);
  const QString &arg2 = args.read<const QString & > (heap);
  const QSqlRecord &arg3 = args.read<const QSqlRecord & > (heap);
  bool arg4 = args.read<bool > (heap);
  ret.write<QString > ((QString)((QSqlDriver_Adaptor *)cls)->cbs_sqlStatement_c7794_0 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_sqlStatement_c7794_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_sqlStatement_c7794_0 = cb;
}


// QString QSqlDriver::stripDelimiters(const QString &identifier, QSqlDriver::IdentifierType type)

static void _init_cbs_stripDelimiters_c4919_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("identifier");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_cbs_stripDelimiters_c4919_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & arg2 = args.read<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > (heap);
  ret.write<QString > ((QString)((QSqlDriver_Adaptor *)cls)->cbs_stripDelimiters_c4919_0 (arg1, arg2));
}

static void _set_callback_cbs_stripDelimiters_c4919_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_stripDelimiters_c4919_0 = cb;
}


// bool QSqlDriver::subscribeToNotification(const QString &name)

static void _init_cbs_subscribeToNotification_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_subscribeToNotification_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_subscribeToNotification_2025_0 (arg1));
}

static void _set_callback_cbs_subscribeToNotification_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_subscribeToNotification_2025_0 = cb;
}


// QStringList QSqlDriver::subscribedToNotifications()

static void _init_cbs_subscribedToNotifications_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_cbs_subscribedToNotifications_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QSqlDriver_Adaptor *)cls)->cbs_subscribedToNotifications_c0_0 ());
}

static void _set_callback_cbs_subscribedToNotifications_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_subscribedToNotifications_c0_0 = cb;
}


// QStringList QSqlDriver::tables(QSql::TableType tableType)

static void _init_cbs_tables_c1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableType");
  decl->add_arg<const qt_gsi::Converter<QSql::TableType>::target_type & > (argspec_0);
  decl->set_return<QStringList > ();
}

static void _call_cbs_tables_c1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSql::TableType>::target_type & arg1 = args.read<const qt_gsi::Converter<QSql::TableType>::target_type & > (heap);
  ret.write<QStringList > ((QStringList)((QSqlDriver_Adaptor *)cls)->cbs_tables_c1843_0 (arg1));
}

static void _set_callback_cbs_tables_c1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_tables_c1843_0 = cb;
}


// void QSqlDriver::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlDriver_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// bool QSqlDriver::unsubscribeFromNotification(const QString &name)

static void _init_cbs_unsubscribeFromNotification_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_unsubscribeFromNotification_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_unsubscribeFromNotification_2025_0 (arg1));
}

static void _set_callback_cbs_unsubscribeFromNotification_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_unsubscribeFromNotification_2025_0 = cb;
}


namespace gsi
{

gsi::Class<QSqlDriver> &qtdecl_QSqlDriver ();

static gsi::Methods methods_QSqlDriver_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSqlDriver::QSqlDriver(QObject *parent)\nThis method creates an object of class QSqlDriver.", &_init_ctor_QSqlDriver_Adaptor_1302, &_call_ctor_QSqlDriver_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("beginTransaction", "@brief Virtual method bool QSqlDriver::beginTransaction()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_beginTransaction_0_0, &_call_cbs_beginTransaction_0_0);
  methods += new qt_gsi::GenericMethod ("beginTransaction", "@hide", false, &_init_cbs_beginTransaction_0_0, &_call_cbs_beginTransaction_0_0, &_set_callback_cbs_beginTransaction_0_0);
  methods += new qt_gsi::GenericMethod ("cancelQuery", "@brief Virtual method bool QSqlDriver::cancelQuery()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_cancelQuery_0_0, &_call_cbs_cancelQuery_0_0);
  methods += new qt_gsi::GenericMethod ("cancelQuery", "@hide", false, &_init_cbs_cancelQuery_0_0, &_call_cbs_cancelQuery_0_0, &_set_callback_cbs_cancelQuery_0_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSqlDriver::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("close", "@brief Virtual method void QSqlDriver::close()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_close_0_0, &_call_cbs_close_0_0);
  methods += new qt_gsi::GenericMethod ("close", "@hide", false, &_init_cbs_close_0_0, &_call_cbs_close_0_0, &_set_callback_cbs_close_0_0);
  methods += new qt_gsi::GenericMethod ("commitTransaction", "@brief Virtual method bool QSqlDriver::commitTransaction()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_commitTransaction_0_0, &_call_cbs_commitTransaction_0_0);
  methods += new qt_gsi::GenericMethod ("commitTransaction", "@hide", false, &_init_cbs_commitTransaction_0_0, &_call_cbs_commitTransaction_0_0, &_set_callback_cbs_commitTransaction_0_0);
  methods += new qt_gsi::GenericMethod ("createResult", "@brief Virtual method QSqlResult *QSqlDriver::createResult()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_createResult_c0_0, &_call_cbs_createResult_c0_0);
  methods += new qt_gsi::GenericMethod ("createResult", "@hide", true, &_init_cbs_createResult_c0_0, &_call_cbs_createResult_c0_0, &_set_callback_cbs_createResult_c0_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSqlDriver::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QSqlDriver::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSqlDriver::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("escapeIdentifier", "@brief Virtual method QString QSqlDriver::escapeIdentifier(const QString &identifier, QSqlDriver::IdentifierType type)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_escapeIdentifier_c4919_0, &_call_cbs_escapeIdentifier_c4919_0);
  methods += new qt_gsi::GenericMethod ("escapeIdentifier", "@hide", true, &_init_cbs_escapeIdentifier_c4919_0, &_call_cbs_escapeIdentifier_c4919_0, &_set_callback_cbs_escapeIdentifier_c4919_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QSqlDriver::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSqlDriver::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("formatValue", "@brief Virtual method QString QSqlDriver::formatValue(const QSqlField &field, bool trimStrings)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_formatValue_c2938_1, &_call_cbs_formatValue_c2938_1);
  methods += new qt_gsi::GenericMethod ("formatValue", "@hide", true, &_init_cbs_formatValue_c2938_1, &_call_cbs_formatValue_c2938_1, &_set_callback_cbs_formatValue_c2938_1);
  methods += new qt_gsi::GenericMethod ("handle", "@brief Virtual method QVariant QSqlDriver::handle()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_handle_c0_0, &_call_cbs_handle_c0_0);
  methods += new qt_gsi::GenericMethod ("handle", "@hide", true, &_init_cbs_handle_c0_0, &_call_cbs_handle_c0_0, &_set_callback_cbs_handle_c0_0);
  methods += new qt_gsi::GenericMethod ("hasFeature", "@brief Virtual method bool QSqlDriver::hasFeature(QSqlDriver::DriverFeature f)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasFeature_c2893_0, &_call_cbs_hasFeature_c2893_0);
  methods += new qt_gsi::GenericMethod ("hasFeature", "@hide", true, &_init_cbs_hasFeature_c2893_0, &_call_cbs_hasFeature_c2893_0, &_set_callback_cbs_hasFeature_c2893_0);
  methods += new qt_gsi::GenericMethod ("isIdentifierEscaped", "@brief Virtual method bool QSqlDriver::isIdentifierEscaped(const QString &identifier, QSqlDriver::IdentifierType type)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isIdentifierEscaped_c4919_0, &_call_cbs_isIdentifierEscaped_c4919_0);
  methods += new qt_gsi::GenericMethod ("isIdentifierEscaped", "@hide", true, &_init_cbs_isIdentifierEscaped_c4919_0, &_call_cbs_isIdentifierEscaped_c4919_0, &_set_callback_cbs_isIdentifierEscaped_c4919_0);
  methods += new qt_gsi::GenericMethod ("isOpen", "@brief Virtual method bool QSqlDriver::isOpen()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isOpen_c0_0, &_call_cbs_isOpen_c0_0);
  methods += new qt_gsi::GenericMethod ("isOpen", "@hide", true, &_init_cbs_isOpen_c0_0, &_call_cbs_isOpen_c0_0, &_set_callback_cbs_isOpen_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QSqlDriver::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_notification", "@brief Emitter for signal void QSqlDriver::notification(const QString &name)\nCall this method to emit this signal.", false, &_init_emitter_notification_2025, &_call_emitter_notification_2025);
  methods += new qt_gsi::GenericMethod ("emit_notification_withData", "@brief Emitter for signal void QSqlDriver::notification(const QString &name, QSqlDriver::NotificationSource source, const QVariant &payload)\nCall this method to emit this signal.", false, &_init_emitter_notification_7365, &_call_emitter_notification_7365);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QSqlDriver::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("open", "@brief Virtual method bool QSqlDriver::open(const QString &db, const QString &user, const QString &password, const QString &host, int port, const QString &connOpts)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_open_10352_5, &_call_cbs_open_10352_5);
  methods += new qt_gsi::GenericMethod ("open", "@hide", false, &_init_cbs_open_10352_5, &_call_cbs_open_10352_5, &_set_callback_cbs_open_10352_5);
  methods += new qt_gsi::GenericMethod ("primaryIndex", "@brief Virtual method QSqlIndex QSqlDriver::primaryIndex(const QString &tableName)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_primaryIndex_c2025_0, &_call_cbs_primaryIndex_c2025_0);
  methods += new qt_gsi::GenericMethod ("primaryIndex", "@hide", true, &_init_cbs_primaryIndex_c2025_0, &_call_cbs_primaryIndex_c2025_0, &_set_callback_cbs_primaryIndex_c2025_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QSqlDriver::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("record", "@brief Virtual method QSqlRecord QSqlDriver::record(const QString &tableName)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_record_c2025_0, &_call_cbs_record_c2025_0);
  methods += new qt_gsi::GenericMethod ("record", "@hide", true, &_init_cbs_record_c2025_0, &_call_cbs_record_c2025_0, &_set_callback_cbs_record_c2025_0);
  methods += new qt_gsi::GenericMethod ("rollbackTransaction", "@brief Virtual method bool QSqlDriver::rollbackTransaction()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rollbackTransaction_0_0, &_call_cbs_rollbackTransaction_0_0);
  methods += new qt_gsi::GenericMethod ("rollbackTransaction", "@hide", false, &_init_cbs_rollbackTransaction_0_0, &_call_cbs_rollbackTransaction_0_0, &_set_callback_cbs_rollbackTransaction_0_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QSqlDriver::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QSqlDriver::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setLastError", "@brief Virtual method void QSqlDriver::setLastError(const QSqlError &e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setLastError_2220_0, &_call_cbs_setLastError_2220_0);
  methods += new qt_gsi::GenericMethod ("*setLastError", "@hide", false, &_init_cbs_setLastError_2220_0, &_call_cbs_setLastError_2220_0, &_set_callback_cbs_setLastError_2220_0);
  methods += new qt_gsi::GenericMethod ("*setOpen", "@brief Virtual method void QSqlDriver::setOpen(bool o)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setOpen_864_0, &_call_cbs_setOpen_864_0);
  methods += new qt_gsi::GenericMethod ("*setOpen", "@hide", false, &_init_cbs_setOpen_864_0, &_call_cbs_setOpen_864_0, &_set_callback_cbs_setOpen_864_0);
  methods += new qt_gsi::GenericMethod ("*setOpenError", "@brief Virtual method void QSqlDriver::setOpenError(bool e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setOpenError_864_0, &_call_cbs_setOpenError_864_0);
  methods += new qt_gsi::GenericMethod ("*setOpenError", "@hide", false, &_init_cbs_setOpenError_864_0, &_call_cbs_setOpenError_864_0, &_set_callback_cbs_setOpenError_864_0);
  methods += new qt_gsi::GenericMethod ("sqlStatement", "@brief Virtual method QString QSqlDriver::sqlStatement(QSqlDriver::StatementType type, const QString &tableName, const QSqlRecord &rec, bool preparedStatement)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sqlStatement_c7794_0, &_call_cbs_sqlStatement_c7794_0);
  methods += new qt_gsi::GenericMethod ("sqlStatement", "@hide", true, &_init_cbs_sqlStatement_c7794_0, &_call_cbs_sqlStatement_c7794_0, &_set_callback_cbs_sqlStatement_c7794_0);
  methods += new qt_gsi::GenericMethod ("stripDelimiters", "@brief Virtual method QString QSqlDriver::stripDelimiters(const QString &identifier, QSqlDriver::IdentifierType type)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_stripDelimiters_c4919_0, &_call_cbs_stripDelimiters_c4919_0);
  methods += new qt_gsi::GenericMethod ("stripDelimiters", "@hide", true, &_init_cbs_stripDelimiters_c4919_0, &_call_cbs_stripDelimiters_c4919_0, &_set_callback_cbs_stripDelimiters_c4919_0);
  methods += new qt_gsi::GenericMethod ("subscribeToNotification", "@brief Virtual method bool QSqlDriver::subscribeToNotification(const QString &name)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_subscribeToNotification_2025_0, &_call_cbs_subscribeToNotification_2025_0);
  methods += new qt_gsi::GenericMethod ("subscribeToNotification", "@hide", false, &_init_cbs_subscribeToNotification_2025_0, &_call_cbs_subscribeToNotification_2025_0, &_set_callback_cbs_subscribeToNotification_2025_0);
  methods += new qt_gsi::GenericMethod ("subscribedToNotifications", "@brief Virtual method QStringList QSqlDriver::subscribedToNotifications()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_subscribedToNotifications_c0_0, &_call_cbs_subscribedToNotifications_c0_0);
  methods += new qt_gsi::GenericMethod ("subscribedToNotifications", "@hide", true, &_init_cbs_subscribedToNotifications_c0_0, &_call_cbs_subscribedToNotifications_c0_0, &_set_callback_cbs_subscribedToNotifications_c0_0);
  methods += new qt_gsi::GenericMethod ("tables", "@brief Virtual method QStringList QSqlDriver::tables(QSql::TableType tableType)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_tables_c1843_0, &_call_cbs_tables_c1843_0);
  methods += new qt_gsi::GenericMethod ("tables", "@hide", true, &_init_cbs_tables_c1843_0, &_call_cbs_tables_c1843_0, &_set_callback_cbs_tables_c1843_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSqlDriver::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("unsubscribeFromNotification", "@brief Virtual method bool QSqlDriver::unsubscribeFromNotification(const QString &name)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unsubscribeFromNotification_2025_0, &_call_cbs_unsubscribeFromNotification_2025_0);
  methods += new qt_gsi::GenericMethod ("unsubscribeFromNotification", "@hide", false, &_init_cbs_unsubscribeFromNotification_2025_0, &_call_cbs_unsubscribeFromNotification_2025_0, &_set_callback_cbs_unsubscribeFromNotification_2025_0);
  return methods;
}

gsi::Class<QSqlDriver_Adaptor> decl_QSqlDriver_Adaptor (qtdecl_QSqlDriver (), "QtSql", "QSqlDriver",
  methods_QSqlDriver_Adaptor (),
  "@qt\n@brief Binding of QSqlDriver");

}


//  Implementation of the enum wrapper class for QSqlDriver::DbmsType
namespace qt_gsi
{

static gsi::Enum<QSqlDriver::DbmsType> decl_QSqlDriver_DbmsType_Enum ("QtSql", "QSqlDriver_DbmsType",
    gsi::enum_const ("UnknownDbms", QSqlDriver::UnknownDbms, "@brief Enum constant QSqlDriver::UnknownDbms") +
    gsi::enum_const ("MSSqlServer", QSqlDriver::MSSqlServer, "@brief Enum constant QSqlDriver::MSSqlServer") +
    gsi::enum_const ("MySqlServer", QSqlDriver::MySqlServer, "@brief Enum constant QSqlDriver::MySqlServer") +
    gsi::enum_const ("PostgreSQL", QSqlDriver::PostgreSQL, "@brief Enum constant QSqlDriver::PostgreSQL") +
    gsi::enum_const ("Oracle", QSqlDriver::Oracle, "@brief Enum constant QSqlDriver::Oracle") +
    gsi::enum_const ("Sybase", QSqlDriver::Sybase, "@brief Enum constant QSqlDriver::Sybase") +
    gsi::enum_const ("SQLite", QSqlDriver::SQLite, "@brief Enum constant QSqlDriver::SQLite") +
    gsi::enum_const ("Interbase", QSqlDriver::Interbase, "@brief Enum constant QSqlDriver::Interbase") +
    gsi::enum_const ("DB2", QSqlDriver::DB2, "@brief Enum constant QSqlDriver::DB2"),
  "@qt\n@brief This class represents the QSqlDriver::DbmsType enum");

static gsi::QFlagsClass<QSqlDriver::DbmsType > decl_QSqlDriver_DbmsType_Enums ("QtSql", "QSqlDriver_QFlags_DbmsType",
  "@qt\n@brief This class represents the QFlags<QSqlDriver::DbmsType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSqlDriver> inject_QSqlDriver_DbmsType_Enum_in_parent (decl_QSqlDriver_DbmsType_Enum.defs ());
static gsi::ClassExt<QSqlDriver> decl_QSqlDriver_DbmsType_Enum_as_child (decl_QSqlDriver_DbmsType_Enum, "DbmsType");
static gsi::ClassExt<QSqlDriver> decl_QSqlDriver_DbmsType_Enums_as_child (decl_QSqlDriver_DbmsType_Enums, "QFlags_DbmsType");

}


//  Implementation of the enum wrapper class for QSqlDriver::DriverFeature
namespace qt_gsi
{

static gsi::Enum<QSqlDriver::DriverFeature> decl_QSqlDriver_DriverFeature_Enum ("QtSql", "QSqlDriver_DriverFeature",
    gsi::enum_const ("Transactions", QSqlDriver::Transactions, "@brief Enum constant QSqlDriver::Transactions") +
    gsi::enum_const ("QuerySize", QSqlDriver::QuerySize, "@brief Enum constant QSqlDriver::QuerySize") +
    gsi::enum_const ("BLOB", QSqlDriver::BLOB, "@brief Enum constant QSqlDriver::BLOB") +
    gsi::enum_const ("Unicode", QSqlDriver::Unicode, "@brief Enum constant QSqlDriver::Unicode") +
    gsi::enum_const ("PreparedQueries", QSqlDriver::PreparedQueries, "@brief Enum constant QSqlDriver::PreparedQueries") +
    gsi::enum_const ("NamedPlaceholders", QSqlDriver::NamedPlaceholders, "@brief Enum constant QSqlDriver::NamedPlaceholders") +
    gsi::enum_const ("PositionalPlaceholders", QSqlDriver::PositionalPlaceholders, "@brief Enum constant QSqlDriver::PositionalPlaceholders") +
    gsi::enum_const ("LastInsertId", QSqlDriver::LastInsertId, "@brief Enum constant QSqlDriver::LastInsertId") +
    gsi::enum_const ("BatchOperations", QSqlDriver::BatchOperations, "@brief Enum constant QSqlDriver::BatchOperations") +
    gsi::enum_const ("SimpleLocking", QSqlDriver::SimpleLocking, "@brief Enum constant QSqlDriver::SimpleLocking") +
    gsi::enum_const ("LowPrecisionNumbers", QSqlDriver::LowPrecisionNumbers, "@brief Enum constant QSqlDriver::LowPrecisionNumbers") +
    gsi::enum_const ("EventNotifications", QSqlDriver::EventNotifications, "@brief Enum constant QSqlDriver::EventNotifications") +
    gsi::enum_const ("FinishQuery", QSqlDriver::FinishQuery, "@brief Enum constant QSqlDriver::FinishQuery") +
    gsi::enum_const ("MultipleResultSets", QSqlDriver::MultipleResultSets, "@brief Enum constant QSqlDriver::MultipleResultSets") +
    gsi::enum_const ("CancelQuery", QSqlDriver::CancelQuery, "@brief Enum constant QSqlDriver::CancelQuery"),
  "@qt\n@brief This class represents the QSqlDriver::DriverFeature enum");

static gsi::QFlagsClass<QSqlDriver::DriverFeature > decl_QSqlDriver_DriverFeature_Enums ("QtSql", "QSqlDriver_QFlags_DriverFeature",
  "@qt\n@brief This class represents the QFlags<QSqlDriver::DriverFeature> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSqlDriver> inject_QSqlDriver_DriverFeature_Enum_in_parent (decl_QSqlDriver_DriverFeature_Enum.defs ());
static gsi::ClassExt<QSqlDriver> decl_QSqlDriver_DriverFeature_Enum_as_child (decl_QSqlDriver_DriverFeature_Enum, "DriverFeature");
static gsi::ClassExt<QSqlDriver> decl_QSqlDriver_DriverFeature_Enums_as_child (decl_QSqlDriver_DriverFeature_Enums, "QFlags_DriverFeature");

}


//  Implementation of the enum wrapper class for QSqlDriver::IdentifierType
namespace qt_gsi
{

static gsi::Enum<QSqlDriver::IdentifierType> decl_QSqlDriver_IdentifierType_Enum ("QtSql", "QSqlDriver_IdentifierType",
    gsi::enum_const ("FieldName", QSqlDriver::FieldName, "@brief Enum constant QSqlDriver::FieldName") +
    gsi::enum_const ("TableName", QSqlDriver::TableName, "@brief Enum constant QSqlDriver::TableName"),
  "@qt\n@brief This class represents the QSqlDriver::IdentifierType enum");

static gsi::QFlagsClass<QSqlDriver::IdentifierType > decl_QSqlDriver_IdentifierType_Enums ("QtSql", "QSqlDriver_QFlags_IdentifierType",
  "@qt\n@brief This class represents the QFlags<QSqlDriver::IdentifierType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSqlDriver> inject_QSqlDriver_IdentifierType_Enum_in_parent (decl_QSqlDriver_IdentifierType_Enum.defs ());
static gsi::ClassExt<QSqlDriver> decl_QSqlDriver_IdentifierType_Enum_as_child (decl_QSqlDriver_IdentifierType_Enum, "IdentifierType");
static gsi::ClassExt<QSqlDriver> decl_QSqlDriver_IdentifierType_Enums_as_child (decl_QSqlDriver_IdentifierType_Enums, "QFlags_IdentifierType");

}


//  Implementation of the enum wrapper class for QSqlDriver::NotificationSource
namespace qt_gsi
{

static gsi::Enum<QSqlDriver::NotificationSource> decl_QSqlDriver_NotificationSource_Enum ("QtSql", "QSqlDriver_NotificationSource",
    gsi::enum_const ("UnknownSource", QSqlDriver::UnknownSource, "@brief Enum constant QSqlDriver::UnknownSource") +
    gsi::enum_const ("SelfSource", QSqlDriver::SelfSource, "@brief Enum constant QSqlDriver::SelfSource") +
    gsi::enum_const ("OtherSource", QSqlDriver::OtherSource, "@brief Enum constant QSqlDriver::OtherSource"),
  "@qt\n@brief This class represents the QSqlDriver::NotificationSource enum");

static gsi::QFlagsClass<QSqlDriver::NotificationSource > decl_QSqlDriver_NotificationSource_Enums ("QtSql", "QSqlDriver_QFlags_NotificationSource",
  "@qt\n@brief This class represents the QFlags<QSqlDriver::NotificationSource> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSqlDriver> inject_QSqlDriver_NotificationSource_Enum_in_parent (decl_QSqlDriver_NotificationSource_Enum.defs ());
static gsi::ClassExt<QSqlDriver> decl_QSqlDriver_NotificationSource_Enum_as_child (decl_QSqlDriver_NotificationSource_Enum, "NotificationSource");
static gsi::ClassExt<QSqlDriver> decl_QSqlDriver_NotificationSource_Enums_as_child (decl_QSqlDriver_NotificationSource_Enums, "QFlags_NotificationSource");

}


//  Implementation of the enum wrapper class for QSqlDriver::StatementType
namespace qt_gsi
{

static gsi::Enum<QSqlDriver::StatementType> decl_QSqlDriver_StatementType_Enum ("QtSql", "QSqlDriver_StatementType",
    gsi::enum_const ("WhereStatement", QSqlDriver::WhereStatement, "@brief Enum constant QSqlDriver::WhereStatement") +
    gsi::enum_const ("SelectStatement", QSqlDriver::SelectStatement, "@brief Enum constant QSqlDriver::SelectStatement") +
    gsi::enum_const ("UpdateStatement", QSqlDriver::UpdateStatement, "@brief Enum constant QSqlDriver::UpdateStatement") +
    gsi::enum_const ("InsertStatement", QSqlDriver::InsertStatement, "@brief Enum constant QSqlDriver::InsertStatement") +
    gsi::enum_const ("DeleteStatement", QSqlDriver::DeleteStatement, "@brief Enum constant QSqlDriver::DeleteStatement"),
  "@qt\n@brief This class represents the QSqlDriver::StatementType enum");

static gsi::QFlagsClass<QSqlDriver::StatementType > decl_QSqlDriver_StatementType_Enums ("QtSql", "QSqlDriver_QFlags_StatementType",
  "@qt\n@brief This class represents the QFlags<QSqlDriver::StatementType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSqlDriver> inject_QSqlDriver_StatementType_Enum_in_parent (decl_QSqlDriver_StatementType_Enum.defs ());
static gsi::ClassExt<QSqlDriver> decl_QSqlDriver_StatementType_Enum_as_child (decl_QSqlDriver_StatementType_Enum, "StatementType");
static gsi::ClassExt<QSqlDriver> decl_QSqlDriver_StatementType_Enums_as_child (decl_QSqlDriver_StatementType_Enums, "QFlags_StatementType");

}

