#include <stdlib.h>
#include <gciua.hf>
#include <isdio.h>

void gemIsdLogout(OopType ooSocket)
{
	int socket;

	socket = GCI_OOP_TO_LONG(ooSocket);
	isdLogout(socket);
}

OopType gemIsdSend(
	OopType ooSocket,
	OopType ooMessage,
	OopType ooMessageSize,
	OopType ooMore
)
{
	char *message;
	long bytesSent, socket, messageSize, size;

	isdHeader header;

	socket = GCI_OOP_TO_LONG(ooSocket);

	size = GciFetchSize(ooMessage);
	message = (char *) alloca(size + 1);
	GciFetchBytes(ooMessage, 1L, message, size);

	messageSize = GCI_OOP_TO_LONG(ooMessageSize);

	memset((char *) &header, 0, sizeof header);

	header.more = GCI_OOP_TO_BOOL(ooMore);
	header.reply = 1;

	bytesSent = isdSend(socket, message, messageSize, &header);
/*
	fprintf(stderr, "socket=%d, messageSize=%d, bytesSent=%d\n", 
					socket, 
					messageSize,
					bytesSent);
*/
	return GCI_LONG_TO_OOP(bytesSent);
}
	
OopType gemIsdConnect(
	OopType ooHostname,
	OopType ooService,
	OopType ooWID
)
{
	long socket, size;
	char *hostname, *service, *wid;
	char *isdArgv[ISDARGMAX + 1];

	size = GciFetchSize(ooHostname);
	hostname = (char *) alloca(size + 1);
	GciFetchBytes(ooHostname, 1L, hostname, size);
	hostname[size] = 0;

	size = GciFetchSize(ooService);
	service = (char *) alloca(size + 1);
	GciFetchBytes(ooService, 1L, service, size);
	service[size] = 0;

	size = GciFetchSize(ooWID);
	wid = (char *) alloca(size + 1);
	GciFetchBytes(ooWID, 1L, wid, size);
	wid[size] = 0;

	isdArgv[ISDARGHOST] = hostname;
	isdArgv[ISDARGSERVICE] = service;
	isdArgv[ISDARGWID] = wid;

	socket = isdConnect(isdArgv);

	return GCI_LONG_TO_OOP(socket);
}

OopType gemIsdLogin(
	OopType ooHostname,
	OopType ooService,
	OopType ooPriority
)
{
	long socket, size, priority;
	char *hostname, *service;

	size = GciFetchSize(ooHostname);
	hostname = (char *) alloca(size + 1);
	GciFetchBytes(ooHostname, 1L, hostname, size);
	hostname[size] = 0;

	size = GciFetchSize(ooService);
	service = (char *) alloca(size + 1);
	GciFetchBytes(ooService, 1L, service, size);
	service[size] = 0;

	priority = GCI_OOP_TO_LONG(ooPriority);

	socket = isdLogin(hostname, service, priority);
	
	return GCI_LONG_TO_OOP(socket);
}

GCIUSER_ACTION_INIT_DEF()
{
	GCI_DECLARE_ACTION("gemIsdConnect", gemIsdConnect, 3);
	GCI_DECLARE_ACTION("gemIsdLogin", gemIsdLogin, 3);
	GCI_DECLARE_ACTION("gemIsdLogout", gemIsdLogout, 1);
	GCI_DECLARE_ACTION("gemIsdSend", gemIsdSend, 4);
}

GCIUSER_ACTION_SHUTDOWN_DEF()
{
}

