#Copyright (c) 2000, Thomas Gagne, tgagne@ix.netcom.com
#http://home.netcom.com/~tgagne

import isdio
from CStructure import *

class IsdHeader(CStructure):
	def __init__(self):
		CStructure.__init__(self, (
			('len','l'),
			('sequence','l'),
			('reply','h'),
			('error','h'),
			('command','h'),
			('version','h'),
			('workerid','l'),
			('more','h'),
			('fill','42x')))

class IsdMessage:
	def __init__(self):
		self.header = IsdHeader()
		self.message = ''

	def get(self, anIsdIO):
		buffer = self.header.asBytes()
		bytes = anIsdIO.recvHeader(buffer)
		self.header.fromBytes(buffer)
		length = self.header.member('len')
		self.message = struct.pack('%dx' % length)
		return anIsdIO.recvAll(self.message)

class IsdIO:
	def __init__(self):
		self.socket = -1
		self.log = None

	def __del__(self):
		if self.log:
			close(self.log)

	def attach(self, host, service, workerid):
		self.socket = isdio.attach(host, service, workerid)
		return self.socket

	def login(self, host, service, priority):
		if service == None:
			service = 'op'
		self.socket = isdio.login(host, service, priority)
		return self.socket

	def logout(self):
		return isdio.logout(self.socket)

	def send(self, message, header = None):

		if header is None:
			header = IsdHeader()
		
		return isdio.send(self.socket, message, header.asBytes())

	def recvHeader(self, anIsdHeaderString):
		return isdio.recvHeader(self.socket, anIsdHeaderString)

	def recvAll(self, aString):
		return isdio.recvAll(self.socket, aString)

	def logInit(self, serviceName):
		self.log = open("/isect/logs/%s" % serviceName, "a", 0)

	def log(self, message):
		if self.log:
			write(self.log, message)

class IsdWorker(IsdIO):
	def __init__(self):
		IsdIO.__init__(self)

	def start(self, host, service, workerid):
		self.attach(host, service, workerid)
		if self.socket >= 0:
			self.workLoop()
		self.logout()

	def workLoop(self):
		m = IsdMessage()

		while (m.get(self)):
			self.work(m)

	def work(self, anIsdMessage):
		None

class IsdEcho(IsdWorker):
	def __init__(self):
		IsdWorker.__init__(self)

	def work(self, anIsdMessage):
		anIsdMessage.header.member('more', 1)
		anIsdMessage.header.member('workerid', 2)
		anIsdMessage.header.member('sequence', 3)
		anIsdMessage.header.member('version', 4)
		anIsdMessage.header.member('command', 5)
		self.send(anIsdMessage.message, anIsdMessage.header)
		anIsdMessage.header.member('more', 0)
		self.send(anIsdMessage.message, anIsdMessage.header)
