/*
Copyright (c) 1997, Isect
*/
#include "isdio.h"
#include <errno.h>

void checkHost(char *hostname)
{
	struct hostent *hostent;

  	isdLog("Checking hosts entry for \"%s\"...\n", hostname);
	hostent = gethostbyname(hostname);
    if (hostent)
    	isdLog("\t...it's OK.\n");
    else
    	isdError("gethostbyname()\n");
}

void checkService(char *service)
{
	struct servent *servent;

  	isdLog("Checking services entry for \"%s\"...\n", service);
	servent = getservbyname(service, 0);
    if (servent)
    	isdLog("\t...it's OK.\n");
    else
    	isdError("getservbyname()\n");
}

int main(int argc, char **argv, char **env)
{
	int status = 0;
	isdHeader *headerp;

#ifdef _Windows
	WSADATA asadata;

    isdLog("Initializing Socket Library\n");
	WSAStartup((WORD) 0x20, &asadata);
#endif

	checkService(ISDHOSTNAME);
    checkService(ISDXSERVICE);
	checkHost(ISDHOSTNAME);

	isdLog("sizeof isdHeader = %d\n", sizeof *headerp);
	if (sizeof *headerp != 64)
		isdLog("WARNING: to communicate with isect\n"
		       "processes on other machine architectures\n"
		       "the sizeof isdHeader must be 64 bytes\n");

	return status;
}
