#include <stdlib.h>
#include <errno.h>
#include "isectd.h"

int 
isdWorkLoop(void)
{
	int status;
	fd_set readfds, writefds;

	atexit(abort);

	for (;;) {
		readfds = isdData.allfds;
		writefds = isdData.writefds;

		for (status = -1; status == -1;) {
			status = select(isdData.numberOfFiles, &readfds, &writefds, (fd_set *) 0, (struct timeval *) 0);
			if (status == SOCKET_ERROR && errno != EINTR) {
				isdError("select()ing\n");
				exit(1);
			}
		}

		isdLogEvent("select() = %d", status);

		isdWorkerDeaths(readfds, &isdData.LazyWorkers);		/* see if any lazy workers have died */
		isdWorkerDeaths(readfds, &isdData.IdleWorkers);		/* see if any idle workers have died */
		isdCheckReady(readfds);	/* update list of ready clients */
		isdWorkerReply(readfds);	/* check for worker replies and busy-worker deaths */
		isdWorkerReady(writefds, &isdData.IdleWorkers);		/* have messages to send to workers? */
		isdWorkerReady(writefds, &isdData.BusyWorkers);		/* have messages to send to workers? */
		isdWorkerLogin(readfds);	/* check for worker logins */
		isdWorkerBadge(readfds);	/* read worker badges */
		isdClientLogin(readfds);	/* check for new client logins */
		isdTaskMaster();		/* give client's work to matching workers */
		isdInternalAffairs(readfds);	/* check for isectd logic internal problems */
	}
}
