#include "isectd.h"

void 
isdWorkerReply(fd_set readfds)
{
	char *msgBuffer;
	isdHeader header;
	Node *node;
	isdWorker *worker;
	isdClient *client;
	int start_workers = 0;

	for (node = isdData.BusyWorkers.head; node != QNULL; node = node->next) {
		worker = (isdWorker *) node;
/*
   it's interesting to note, that in client queue processing, we first
   check to see if the socket is -1, which causes problems.  We don't
   do that for workers because when the socket becomes -1, we remove
   them from this queue and make them lazy.
 */
		if (FD_ISSET(worker->socket, &readfds)) {
			isdLogEvent("reply from worker %d (%s)", worker->id, worker->name);

			client = worker->client;

			if (msgBuffer = isdRecv(worker->socket, &header)) {
				isdLogEvent("  len=%d, seq=%d, more=%d",
							header.len,
							header.sequence,
							header.more);

				worker->fromCount++;
/*
   if message->header.more == 0, the worker
   believes he's done doing whatever he was doing.
   mark the transaction complete
 */
				if (header.more == 0) {
					if (worker->msgBuffer) 
						free(worker->msgBuffer);
					worker->msgBuffer = NULL;
				
					isdTranStats(worker);
					node = node->previous == QNULL ? (Node *) node->queue : node->previous;
					isdIdleWorker(worker);
				}
				isdClientSend(client, msgBuffer, &header);
			}
/*
   there was a problem reading the message.  Deal with
   the worker
 */
			else {
				node = node->previous == QNULL ? (Node *) node->queue : node->previous;
				isdLazyWorker(worker);
				start_workers += isdWorkerStartable(worker);
			}
		}
	}
	if (start_workers)
		isdStartWorkers();
}
