#include "isectd.h"

void 
isdWorkerReady(fd_set writefds, Queue * queue)
{
	Node *node;
	isdWorker *worker;
/*
   the only reason we come into this module, is there's workers that are
   ready to recieve message that clients have waiting for them.  We've
   already established a relationship between the client and the worker
   so now we have to keep shipping the messages over.
 */
	for (node = queue->head; node != QNULL; node = node->next) {
		worker = (isdWorker *) node;
		if (worker->socket != INVALID_SOCKET) {
			if (FD_ISSET(worker->socket, &writefds)) {
				isdLogEvent("worker %d write-ready", worker->id);
				worker->ready = 1;
				FD_CLR(worker->socket, &isdData.writefds);
			}
		}
	}
}
