#include "isectd.h"

void 
isdWorkerDeaths(fd_set readfds, Queue * queue)
{
	Node *node;
	isdWorker *worker;
	int err, restart_workers = 0;
	char c;

	for (node = queue->head; node != QNULL; node = node->next) {
		worker = (isdWorker *) node;
		if (worker->socket != INVALID_SOCKET) {
			if (FD_ISSET(worker->socket, &readfds)) {
				isdLog("worker %d (%s) may be dead, worker->client= 0x%x\n", worker->id, worker->name, worker->client);
				err = isdSockEOF(worker->socket);
				if (err) {
					worker->up_not_log_in = 0;
					isdLazyWorker(worker);
					restart_workers += isdWorkerStartable(worker);
				}
/*
   if there's stuff on the socket, attempt to drain it.
 */
				if (recv(worker->socket, &c, 1, MSG_PEEK) == 1) {
					recv(worker->socket, &c, 1, 0);
					isdLogEvent("drained 0x%x", c);
				}
			}
		}
	}
	if (restart_workers)
		isdStartWorkers();
}
