#include "isectd.h"
#ifdef _Windows
#include <dos.h>
#endif

int 
isdStartWorkers(void)
{
	int err = 0;
	Node *node;
	isdWorker *worker;

	for (node = isdData.LazyWorkers.head; node != QNULL; node = node->next) {
		worker = (isdWorker *) node;
		err = isdStartWorker(worker);
	}
	return err;
}

int
isdStartWorker(isdWorker * worker)
{
	int err = 0;
	char command[256];

	if (worker->stopped == 0 && worker->up_not_log_in == 0) {
		worker->restarts++;
		sprintf(command, "%s %s %d %d -s%s %s", worker->path, isdData.host, isdData.port, worker->id, worker->name, worker->args);
		if (err = isdexec(worker->host, command)) {
			isdLog("rmtexec(\"%s\", \"%s\") = %d : ", worker->host, command, err);
			isdLog(isdxstrerror(err));
			sleep(1);
		}
		else
			worker->up_not_log_in = 1;
	}

	return err;
}
