/*
05/17/2000	check for the -p parameter on the command line and use it's
			argument (if specified) as the client-request port.
*/

#include "isectd.h"
#include <signal.h>
#include <string.h>

int 
isdInit(int argc, char **argv)
{
	char c, *cp;
	char *serviceName = ISDHOSTNAME;
	int err = 1;

	extern char *optarg;
	extern int optind, opterr, optopt;

	struct sigaction newAction, oldAction;

#ifdef _Windows
	WSADATA asadata;

	WSAStartup((WORD) MAKEWORD(2, 0), &asadata);
#endif

	isdData.argc = argc, isdData.argv = argv;
	/* isdLogInit(argc, argv); */

/*
5/17/2000
Added an option, -p, to specify a particular port
number for isectd to wait for client connections.
*/
	while ((c = getopt(argc, argv, "p:")) != -1) {
		switch (c) {
			case 'p':
				if (optarg) {
					serviceName = strdup(optarg);
				}
				break;

			default:
				break;
		}
	}

	strcpy(isdData.command_worker, ISDSERVICE);

	if (gethostname(isdData.host, MAXHOSTNAMELEN) == 0) {
		QueueInit(&isdData.ServiceList);
		QueueInit(&isdData.PriList);
		QueueInit(&isdData.NewWorkers);
		QueueInit(&isdData.LazyWorkers);
		QueueInit(&isdData.IdleWorkers);
		QueueInit(&isdData.BusyWorkers);
		QueueInit(&isdData.Events);
		QueueInit(&isdData.OutBasket);

		isdBucketParams(6, 10);	/* default to 6 buckets of 10 seconds each */

#ifndef _Windows
		newAction.sa_handler = isdHandler;
		sigemptyset(&newAction.sa_mask);
		newAction.sa_flags = SA_RESTART;

		sigaction(SIGPIPE, &newAction, &oldAction);	/* i'd rather get the error than die */
		sigaction(SIGALRM, &newAction, &oldAction);	/* only one i'm catching */

		setservent(1);			/* keep /etc/services file open */
		sethostent(1);			/* keep /etc/hosts file open */
#endif

		if (cp = isdCommands("CONFIG SERVICE " ISDSERVICE)) {
			isdLog(cp);
			free(cp);
/*
   the op service is the first service added, so let's remember its ID
   since we'll be checking it often.
 */
			isdData.opid = ((isdService *) isdData.ServiceList.head)->id;
			if (isd1024() == 0) {
/*
   Open private socket for workers to call back-on once they've started.  We don't want
   to depend on the configuration file to allocate one.
 */
				if (isdSocket((char *) 0, "tcp", &isdData.socket, &isdData.port) != -1) {
					FD_SET(isdData.socket, &isdData.allfds);
/*
   open socket for clients
 */
					if (isdSocket(serviceName, "tcp", &isdData.req_socket, &isdData.req_port) != -1) {

						if (strcmp(serviceName, ISDHOSTNAME) != 0)
							free(serviceName);

						FD_SET(isdData.req_socket, &isdData.allfds);
						err = 0;
					}
				}
			}
		}
	}
	return err;
}
