#include <stdlib.h>
#include "isectd.h"

/*
format: config service name
*/

char *
isdAddService(char *cp, int argc, char **argv)
{
	int i, converts;
	isdService *service;
	isdSecureIP *secureIP;
	Node *node;
	unsigned int classa, classb, classc, classd;

	if (argc < 3)
		strcat(cp, "Not enough arguments for CONFIG SERVICE.\n");
	else {
		for (node = isdData.ServiceList.head; node != QNULL; node = node->next) {
			service = (isdService *) node;
			if (strcmp(service->name, argv[2]) == 0)
				break;
		}

		if (node != QNULL)
			sprintf(cp, "WARNING: duplicate service '%s' not added.\n", argv[2]);
		else {
			service = (isdService *) malloc(sizeof *service);
			strcpy(service->name, argv[2]);
			service->id = ++isdData.NextServiceID;
			QueueInit(&service->secureIP);
			InsertHead(&isdData.ServiceList, (Node *) service);
			sprintf(cp, "SERVICE '%s' added.\n", service->name);
			isdLog("service->name=%s, service->id=%d\n", service->name, service->id);

/*
Next, we'll check to see if there's any IP masking
masks and allows are the only things we know how to setup now
*/
			for (i = 3; i < argc; i++) {
				strupr(argv[i]);
				if (strcmp(argv[i], "MASK") == 0) {
					if (secureIP == NULL) {
						secureIP = (isdSecureIP *) malloc(sizeof *secureIP);
						secureIP->addrType = ISDSECIPMASK;
						secureIP->action = ISDSECIPALLOW;
						continue;
					}
					else {
						isdLog("%s not expected in CONFIG SERVICE command\n", argv[i]);
						break;
					}
				}

				else {
					if (secureIP) {
						converts = sscanf(argv[i], "%u.%u.%u.%u", &classa, &classb, &classc, &classd);

						if (converts == 4) {
							if (classa <= 255 && classb <= 255 && classc <= 255 && classc <= 255) {
								secureIP->sin_addr.s_addr  = (unsigned char) classa << 24;
								secureIP->sin_addr.s_addr |= (unsigned char) classb << 16;
								secureIP->sin_addr.s_addr |= (unsigned char) classc <<  8;
								secureIP->sin_addr.s_addr |= (unsigned char) classd;

								InsertHead(&service->secureIP, (Node *) secureIP);
								isdLog("%s accepts clients from %d.%d.%d.%d\n",
									service->name,
									classa, classb, classc, classd);
								secureIP = NULL;
							}
							else
								isdLog("mask parts must each be <= 255\n");
						}
						else {
							isdLog("%s must be in the form of aaa.bbb.ccc.ddd\n", argv[i]);
							break;
						}
					}
				}
			}
		}
	}
	return strchr(cp, 0);
}
