#include "isdio.h"
#include <errno.h>
#include <time.h>
#include <string.h>

static FILE *isdLogFile;

static char *Xport 
strTime(void)
{
	time_t tval;
	char *cp, *nl;

	tval = time((time_t *) 0);
	cp = ctime(&tval);
	if (nl = strchr(cp, '\n'))
		*nl = 0;

	return cp;
}

void Xport 
isdLogInit(int argc, char **argv)
{
	int i;
	char isdLogFileName[1024];

	sprintf(isdLogFileName, "/isect/logs/%s.log", argv[1]);

	isdLogFile = fopen(isdLogFileName, "a");
	if (isdLogFile == NULL)
		isdLogFile = stderr;

	isdLog("\nSTARTING\n");
	for (i = 0; i < argc; i++)
		isdLog("%s ", argv[i]);
}


void Xport 
isdLog(char *fmt,...)
{
	va_list args;

	va_start(args, fmt);

	if (isdLogFile == NULL)
		isdLogFile = stderr;

	fprintf(isdLogFile, "%s ", strTime());
	vfprintf(isdLogFile, fmt, args);
	fflush(isdLogFile);

	va_end(args);
}

void Xport 
isdError(char *fmt,...)
{
	va_list args;

	va_start(args, fmt);

	if (isdLogFile == NULL)
		isdLogFile = stderr;

	fprintf(isdLogFile, "SystemError : %d, %s\n\t\t", errno, strerror(errno));
	vfprintf(isdLogFile, fmt, args);
	fflush(isdLogFile);

	va_end(args);
}
