#include <stdlib.h>
#include <string.h>
#include <errno.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_WRITEV
#include <sys/uio.h>
#endif

#include "isdio.h"

/*
Convert header from host to network byte ordering
*/
isdHeader *
isdHeaderToN(isdHeader * header)
{
	header->len = htonl(header->len);
	header->sequence = htonl(header->sequence);
	header->reply = htons(header->reply);
	header->error = htons(header->error);
	header->command = htons(header->command);
	header->version = htons(header->version);
	header->workerid = htonl(header->workerid);
	header->more = htons(header->more);

	return header;
}

/*
Convert header from network to host byte ordering
*/
isdHeader *
isdHeaderToH(isdHeader * header)
{
	header->len = ntohl(header->len);
	header->sequence = ntohl(header->sequence);
	header->reply = ntohs(header->reply);
	header->error = ntohs(header->error);
	header->command = ntohs(header->command);
	header->version = ntohs(header->version);
	header->workerid = ntohl(header->workerid);
	header->more = ntohs(header->more);

	return header;
}
