#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#define SCOPE
#include "libisect.h"
#include "rmt.h"
#include "isdio.h"
#include <signal.h>

static void 
reaper(int sig)
{
	isdLog("Rmtexecd received signal %d\n", sig);
}

static isdexecd(int argc, char **argv)
{
	SOCKET sock, r_sock;
	int sig, port, size, rc;
	void (*before) (int);
	struct sigaction newAction, oldAction;
	struct sockaddr_in remoteaddr;
	int remoteaddrlen;

	char buffer[1024];

#ifdef _Windows
	WSADATA asadata;

	WSAStartup((WORD) MAKEWORD(2, 0), &asadata);
#endif

	isdLog("getwd() = %s\n", getcwd(rmt_pathname, sizeof rmt_pathname));

	QueueInit(&ReplyToQueue);

	newAction.sa_handler = reaper;
	sigemptyset(&newAction.sa_mask);
	newAction.sa_flags = 0;
/*
	Here are the signals we must catch
*/
	sigaction(SIGCHLD, &newAction, &oldAction);
/*
   These signals are optionally compiled in if available
 */
#ifdef SIGUSR1
	if ((before = signal(sig = SIGUSR1, SIG_IGN)) != SIG_IGN)
		sigaction(sig, &newAction, &oldAction);
#endif
#ifdef SIGUSR2
	if ((before = signal(sig = SIGUSR2, SIG_IGN)) != SIG_IGN)
		sigaction(sig, &newAction, &oldAction);
#endif
#ifdef SIGTERM
	if ((before = signal(sig = SIGTERM, SIG_IGN)) != SIG_IGN)
		sigaction(sig, &newAction, &oldAction);
#endif
#ifdef SIGINT
	if ((before = signal(sig = SIGINT, SIG_IGN)) != SIG_IGN)
		sigaction(sig, &newAction, &oldAction);
#endif
#ifdef SIGTSTP
	if ((before = signal(sig = SIGTSTP, SIG_IGN)) != SIG_IGN)
		sigaction(sig, &newAction, &oldAction);
#endif

	rc = isdSocket(ISDXSERVICE, "tcp", &sock, &port);
	isdLog("isdSocket() assigned %d\n", sock);
	if (rc >= 0) {
		do {
			rmtsigchild();

			remoteaddrlen = sizeof remoteaddr;
			if ((r_sock = accept(sock, (struct sockaddr *) &remoteaddr, &remoteaddrlen)) == INVALID_SOCKET) {
#ifdef _Windows
				errno = WSAGetLastError();
#endif
				if (errno == EINTR)
					continue;
				isdError("accept()");
				break;
			}
			else {				/* read the command */
				if ((size = recv(r_sock, buffer, sizeof buffer, 0)) < 0) {
					isdError("read()");
					isdLogout(r_sock);
					continue;
				}

				if (size < sizeof buffer)
					buffer[size] = 0;
				if (strcmp(buffer, "stop") == 0) {
					isdLogout(sock);
					break;
				}
				isdLog("%s\n", buffer);
				rmtdo(r_sock, buffer);
				isdLogout(r_sock);
			}
		} while (1);
		isdLogout(sock);
	}
	else {
#ifdef _Windows
		isdLog("WSAGetLastError=%d\n", WSAGetLastError());
#endif
		isdError("isdSocket()");
	}
	exit(0);
	return 0;
}

int main(int argc, char **argv)
{
	char localhost[512];

	if (argc == 1)
		isdexecd(argc, argv);
	else
		if (argc == 2) {
			if (strcmp(argv[1], "stop") == 0)
				isdexec("localhost", "stop");
		}
	else
		if (argc == 3) {
			if (strcmp(argv[2], "stop") == 0) {
				sprintf(localhost, "localhost:%s", argv[1]);
				isdexec(localhost, "stop");
			}
		}
	else
		fprintf(stderr, "%s [stop]\n", argv[0]);
}


