*Testcase dfp-080-from-packed.tst:   CDPT, CXPT

sysclear
archmode esame

#
# Following suppresses logging of program checks.  This test program, as part
# of its normal operation, generates 16 expected program specification checks from
# packed lengths greater than allowed. This is part value of the validation process.
# (Not the messages, the program checks.)
#

ostailor quiet

loadcore "$(testpath)/dfp-080-from-packed.core" 0x0
runtest 1.0

ostailor default  # restore messages for subsequent tests

*Compare

# Test Results - Convert From Packed (CDPT) - results
# ---------------------------------------------------

# CDPT test results - signed packed
# ---------------------------------
# An signed packed values is converted to a long DFP number with
# Ignore-Sign-Digit Control diabled and enabled resulting
# in 2 long DFP numbers per packed value.

r 1000.10
*Want "CDPT +0 "                    22380000 00000000 22380000 00000000 
r 1010.10
*Want "CDPT -0 "                    A2380000 00000000 22380000 00000000
r 1020.10
*Want "CDPT +12345 "                22380000 000049C5 22380000 000049C5 
r 1030.10
*Want "CDPT -12345 "                A2380000 000049C5 22380000 000049C5
r 1040.10
*Want "CDPT +271828182 "            22380000 1714B8AA 22380000 1714B8AA 
r 1050.10
*Want "CDPT -271828182 "            A2380000 1714B8AA 22380000 1714B8AA
r 1060.10
*Want "CDPT +314159265358979 "      22399436 565763BF 22399436 565763BF 
r 1070.10
*Want "CDPT -314159265358979 "      A2399436 565763BF 22399436 565763BF
r 1080.10
*Want "CDPT +3141592653589793 "     2E38C1AE B53B3FBB 2E38C1AE B53B3FBB 
r 1090.10
*Want "CDPT -3141592653589793 "     AE38C1AE B53B3FBB 2E38C1AE B53B3FBB
r 10A0.10
*Want "CDPT +93141592653589793 "    FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF 
r 10B0.10
*Want "CDPT -93141592653589793 "    FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
r 10C0.10
*Want "CDPT +993141592653589793 "   FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF 
r 10D0.10
*Want "CDPT -993141592653589793 "   FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF

# CDPT test results - signed packed - program Interupt, DXC, CC 
# ---------------------------------

r 1200.8
*Want "CDPT +0 "                    FFFF0000 FFFF0000 
r 1208.8
*Want "CDPT -0 "                    FFFF0000 FFFF0000 
r 1210.8
*Want "CDPT +12345 "                FFFF0000 FFFF0000 
r 1218.8
*Want "CDPT -12345 "                FFFF0000 FFFF0000 
r 1220.8
*Want "CDPT +271828182 "            FFFF0000 FFFF0000 
r 1228.8
*Want "CDPT -271828182 "            FFFF0000 FFFF0000 
r 1230.8
*Want "CDPT +314159265358979 "      FFFF0000 FFFF0000 
r 1238.8
*Want "CDPT -314159265358979 "      FFFF0000 FFFF0000 
r 1240.8
*Want "CDPT +3141592653589793 "     FFFF0000 FFFF0000 
r 1248.8
*Want "CDPT -3141592653589793 "     FFFF0000 FFFF0000 
r 1250.8
*Want "CDPT +93141592653589793 "    00070000 00070000 
r 1258.8
*Want "CDPT -93141592653589793 "    00070000 00070000
r 1260.8
*Want "CDPT +993141592653589793 "   00060000 00060000 
r 1268.8
*Want "CDPT -993141592653589793 "   00060000 00060000  

# CDPT test results - unsigned packed
# -----------------------------------
#
# An unsigned packed values is converted to a long DFP number with
# Ignore-Sign-Digit Control diabled and enabled resulting
# in 2 long DFP numbers per packed value.

r 1300.10
*Want "CDPT 0 "                    22380000 00000000 22380000 00000000 
r 1310.10
*Want "CDPT 1 "                    22380000 00000001 22380000 00000001
r 1320.10
*Want "CDPT 12345 "                22380000 000049C5 22380000 000049C5 
r 1330.10
*Want "CDPT 123456 "               22380000 00028E56 22380000 00028E56
r 1340.10
*Want "CDPT 271828182 "            22380000 1714B8AA 22380000 1714B8AA 
r 1350.10
*Want "CDPT 2718281828 "           22380000 B9842D2E 22380000 B9842D2E 
r 1360.10
*Want "CDPT 3141592653589793 "     2E38C1AE B53B3FBB 2E38C1AE B53B3FBB 
r 1370.10
*Want "CDPT 93141592653589793 "    FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
r 1380.10
*Want "CDPT 993141592653589793 "   FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF 
r 1390.10
*Want "CDPT 9993141592653589793 "  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF

# CDPT test results - unsigned packed - program Interupt, DXC, CC 
# ----------------------==-----------


r 1400.8
*Want "CDPT 0 "                     FFFF0000 FFFF0000 
r 1408.8
*Want "CDPT 1 "                     FFFF0000 FFFF0000 
r 1410.8
*Want "CDPT 12345 "                 FFFF0000 FFFF0000 
r 1418.8
*Want "CDPT 123456 "                FFFF0000 FFFF0000 
r 1420.8
*Want "CDPT 271828182 "             FFFF0000 FFFF0000 
r 1428.8
*Want "CDPT 2718281828 "            FFFF0000 FFFF0000 

r 1430.8
*Want "CDPT 314159265358979 "       FFFF0000 FFFF0000 
r 1438.8
*Want "CDPT 9314159265358979 "      00070000 00070000 
r 1440.8
*Want "CDPT 993141592653589793 "    00070000 00070000 
r 1448.8
*Want "CDPT 9993141592653589793 "   00060000 00060000
 


# Test Results - Convert From Packed (CXPT) - results
# ---------------------------------------------------

# CXPT test results - signed packed
# ---------------------------------
# An signed packed values is converted to an extended DFP number with
# Ignore-Sign-Digit Control diabled and enabled resulting
# in 2 extended DFP numbers per packed value.

r 1600.10
*Want "CXPT +0 "                    22080000 00000000 00000000 00000000 
r 1610.10
*Want "CXPT +0 "                    22080000 00000000 00000000 00000000 
r 1620.10
*Want "CXPT -0 "                    A2080000 00000000 00000000 00000000
r 1630.10
*Want "CXPT +0 "                    22080000 00000000 00000000 00000000 

r 1640.10
*Want "CXPT +12345 "                22080000 00000000 00000000 000049C5 
r 1650.10
*Want "CXPT +12345 "                22080000 00000000 00000000 000049C5 

r 1660.10
*Want "CXPT -12345 "                A2080000 00000000 00000000 000049C5
r 1670.10
*Want "CXPT -12345 "                22080000 00000000 00000000 000049C5 

r 1680.10
*Want "CXPT +271828182 "            22080000 00000000 00000000 1714B8AA 
r 1690.10
*Want "CXPT +271828182 "            22080000 00000000 00000000 1714B8AA 

r 16A0.10
*Want "CXPT -271828182 "            A2080000 00000000 00000000 1714B8AA
r 16B0.10
*Want "CXPT -271828182 "            22080000 00000000 00000000 1714B8AA

r 16C0.10
*Want "CXPT +314159265358979 "      22080000 00000000 00019436 565763BF 
r 16D0.10
*Want "CXPT +314159265358979 "      22080000 00000000 00019436 565763BF 

r 16E0.10
*Want "CXPT -314159265358979 "      A2080000 00000000 00019436 565763BF
r 16F0.10
*Want "CXPT -314159265358979 "      22080000 00000000 00019436 565763BF

r 1700.10
*Want "CXPT +3141592653589793 "     22080000 00000000 000CC1AE B53B3FBB 
r 1710.10
*Want "CXPT +3141592653589793 "     22080000 00000000 000CC1AE B53B3FBB 

r 1720.10
*Want "CXPT -3141592653589793 "     A2080000 00000000 000CC1AE B53B3FBB
r 1730.10
*Want "CXPT -3141592653589793 "     22080000 00000000 000CC1AE B53B3FBB

r 1740.10
*Want "CXPT +93141592653589793 "    22080000 00000000 00ECC1AE B53B3FBB 
r 1750.10
*Want "CXPT +93141592653589793 "    22080000 00000000 00ECC1AE B53B3FBB 

r 1760.10
*Want "CXPT -93141592653589793 "    A2080000 00000000 00ECC1AE B53B3FBB
r 1770.10
*Want "CXPT -93141592653589793 "    22080000 00000000 00ECC1AE B53B3FBB


r 1780.10
*Want "CXPT +993141592653589793 "    22080000 00000000 067CC1AE B53B3FBB
r 1790.10
*Want "CXPT +993141592653589793 "    22080000 00000000 067CC1AE B53B3FBB

r 17A0.10
*Want "CXPT -993141592653589793 "    A2080000 00000000 067CC1AE B53B3FBB
r 17B0.10
*Want "CXPT -993141592653589793 "    22080000 00000000 067CC1AE B53B3FBB

r 17C0.10
*Want "CXPT +1234567890123456789012345 "  22080000 00014D2E 7078A395 BCF049C5
r 17D0.10
*Want "CXPT +1234567890123456789012345 "  22080000 00014D2E 7078A395 BCF049C5

r 17E0.10
*Want "CXPT -1234567890123456789012345 "  A2080000 00014D2E 7078A395 BCF049C5
r 17F0.10
*Want "CXPT -1234567890123456789012345 "  22080000 00014D2E 7078A395 BCF049C5

r 1800.10
*Want "CXPT +3141592653589793238462643383279502 "  2E080C1A EB53B3FB B4E262D0 DAB5E682
r 1810.10
*Want "CXPT +3141592653589793238462643383279502 "  2E080C1A EB53B3FB B4E262D0 DAB5E682

r 1820.10
*Want "CXPT -3141592653589793238462643383279502 "  AE080C1A EB53B3FB B4E262D0 DAB5E682
r 1830.10
*Want "CXPT -3141592653589793238462643383279502 "  2E080C1A EB53B3FB B4E262D0 DAB5E682


r 1840.10
*Want "CXPT +93141592653589793238462643383279502 "  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
r 1850.10
*Want "CXPT +93141592653589793238462643383279502 "  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF

r 1860.10
*Want "CXPT -93141592653589793238462643383279502 "  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
r 1870.10
*Want "CXPT -93141592653589793238462643383279502 "  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF


# CXPT test results - signed packed - program Interupt, DXC, CC 
# ---------------------------------

r 2000.8
*Want "CXPT +0 "                    FFFF0000 FFFF0000 
r 2008.8
*Want "CXPT -0 "                    FFFF0000 FFFF0000 
r 2010.8
*Want "CXPT +12345 "                FFFF0000 FFFF0000 
r 2018.8
*Want "CXPT -12345 "                FFFF0000 FFFF0000 
r 2020.8
*Want "CXPT +271828182 "            FFFF0000 FFFF0000 
r 2028.8
*Want "CXPT -271828182 "            FFFF0000 FFFF0000 
r 2030.8
*Want "CXPT +314159265358979 "      FFFF0000 FFFF0000 
r 2038.8
*Want "CXPT -314159265358979 "      FFFF0000 FFFF0000 
r 2040.8
*Want "CXPT +3141592653589793 "     FFFF0000 FFFF0000 
r 2048.8
*Want "CXPT -3141592653589793 "     FFFF0000 FFFF0000 
r 2050.8
*Want "CXPT +93141592653589793 "    FFFF0000 FFFF0000 
r 2058.8
*Want "CXPT -93141592653589793 "    FFFF0000 FFFF0000
r 2060.8
*Want "CXPT +993141592653589793 "   FFFF0000 FFFF0000
r 2068.8
*Want "CXPT -993141592653589793 "   FFFF0000 FFFF0000

r 2070.8
*Want "CXPT +1234567890123456789012345 "   FFFF0000 FFFF0000
r 2078.8
*Want "CXPT -1234567890123456789012345 "   FFFF0000 FFFF0000


r 2080.8
*Want "CXPT +3141592653589793238462643383279502 "   FFFF0000 FFFF0000
r 2088.8
*Want "CXPT -3141592653589793238462643383279502 "   FFFF0000 FFFF0000

r 2090.8
*Want "CXPT +93141592653589793238462643383279502 "   00070000 00070000
r 2098.8
*Want "CXPT -93141592653589793238462643383279502 "   00070000 00070000

r 20A0.8
*Want "CXPT +993141592653589793238462643383279502 "   00060000 00060000
r 20A8.8
*Want "CXPT -993141592653589793238462643383279502 "   00060000 00060000

# CXPT test results - unsigned packed
# -----------------------------------
#
# An unsigned packed values is converted to an extended DFP number with
# Ignore-Sign-Digit Control diabled and enabled resulting
# in 2 long DFP numbers per packed value.

r 2100.10
*Want "CXPT 0 "                    22080000 00000000 00000000 00000000
r 2110.10
*Want "CXPT 0 "                    22080000 00000000 00000000 00000000 

r 2120.10
*Want "CXPT 1 "                    22080000 00000000 00000000 00000001
r 2130.10
*Want "CXPT 1 "                    22080000 00000000 00000000 00000001

r 2140.10
*Want "CXPT 12345 "                22080000 00000000 00000000 000049C5
r 2150.10
*Want "CXPT 12345 "                22080000 00000000 00000000 000049C5 

r 2160.10
*Want "CXPT 123456 "               22080000 00000000 00000000 00028E56
r 2170.10
*Want "CXPT 123456 "               22080000 00000000 00000000 00028E56

r 2180.10
*Want "CXPT 271828182 "            22080000 00000000 00000000 1714B8AA 
r 2190.10
*Want "CXPT 271828182 "            22080000 00000000 00000000 1714B8AA 

r 21A0.10
*Want "CXPT 2718281828 "           22080000 00000000 00000000 B9842D2E
r 21B0.10
*Want "CXPT 2718281828 "           22080000 00000000 00000000 B9842D2E 

r 21C0.10
*Want "CXPT 3141592653589793 "     22080000 00000000 000CC1AE B53B3FBB
r 21D0.10
*Want "CXPT 3141592653589793 "     22080000 00000000 000CC1AE B53B3FBB 

r 21E0.10
*Want "CXPT 93141592653589793 "    22080000 00000000 00ECC1AE B53B3FBB
r 21F0.10
*Want "CXPT 93141592653589793 "    22080000 00000000 00ECC1AE B53B3FBB

r 2200.10
*Want "CXPT 993141592653589793 "   22080000 00000000 067CC1AE B53B3FBB
r 2210.10
*Want "CXPT 993141592653589793 "   22080000 00000000 067CC1AE B53B3FBB 

r 2220.10
*Want "CXPT 9993141592653589793 "  22080000 00000000 967CC1AE B53B3FBB
r 2230.10
*Want "CXPT 9993141592653589793 "  22080000 00000000 967CC1AE B53B3FBB

r 2240.10
*Want "CXPT 12345678901234567890 "  22080000 00000001 27177823 534B9C1E 
r 2250.10
*Want "CXPT 12345678901234567890 "  22080000 00000001 27177823 534B9C1E 

r 2260.10
*Want "CXPT 1234567890123456789012345 "  22080000 00014D2E 7078A395 BCF049C5
r 2270.10
*Want "CXPT 1234567890123456789012345 "  22080000 00014D2E 7078A395 BCF049C5

r 2280.10
*Want "CXPT 3141592653589793238462643 "  22080000 0003306B AD4ECFEE D3898B43
r 2290.10
*Want "CXPT 3141592653589793238462643 "  22080000 0003306B AD4ECFEE D3898B43

r 22A0.10
*Want "CXPT 3141592653589793238462643383279502 " 2E080C1A EB53B3FB B4E262D0 DAB5E682
r 22B0.10
*Want "CXPT 3141592653589793238462643383279502 " 2E080C1A EB53B3FB B4E262D0 DAB5E682

r 22C0.10
*Want "CXPT 93141592653589793238462643383279502 "   FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
r 22D0.10
*Want "CXPT 93141592653589793238462643383279502 "   FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF

r 22E0.10
*Want "CXPT 993141592653589793238462643383279502 "  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
r 22F0.10
*Want "CXPT 993141592653589793238462643383279502 "  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF

r 2300.10
*Want "CXPT 9993141592653589793238462643383279502 " FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
r 2310.10
*Want "CXPT 9993141592653589793238462643383279502 " FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF

# CXPT test results - unsigned packed - program Interupt, DXC, CC 
# ----------------------==-----------

r 2500.8
*Want "CXPT 0 "                     FFFF0000 FFFF0000 
r 2508.8
*Want "CXPT 1 "                     FFFF0000 FFFF0000 
r 2510.8
*Want "CXPT 12345 "                 FFFF0000 FFFF0000 
r 2518.8
*Want "CXPT 123456 "                FFFF0000 FFFF0000 
r 2520.8
*Want "CXPT 271828182 "             FFFF0000 FFFF0000 
r 2528.8
*Want "CXPT 2718281828 "            FFFF0000 FFFF0000 
r 2530.8
*Want "CXPT 314159265358979 "       FFFF0000 FFFF0000 
r 2538.8
*Want "CXPT 9314159265358979 "      FFFF0000 FFFF0000 
r 2540.8
*Want "CXPT 993141592653589793 "    FFFF0000 FFFF0000 
r 2548.8
*Want "CXPT 9993141592653589793 "   FFFF0000 FFFF0000

r 2550.8
*Want "CXPT 12345678901234567890 "               FFFF0000 FFFF0000 
r 2558.8
*Want "CXPT 1234567890123456789012345 "          FFFF0000 FFFF0000

r 2560.8
*Want "CXPT 3141592653589793238462643 "          FFFF0000 FFFF0000 
r 2568.8
*Want "CXPT 3141592653589793238462643383279502 " FFFF0000 FFFF0000

r 2570.8
*Want "CXPT 93141592653589793238462643383279502 "   00070000 00070000  
r 2578.8
*Want "CXPT 993141592653589793238462643383279502 "  00070000 00070000  

r 2580.8
*Want "CXPT 9993141592653589793238462643383279502 " 00060000 00060000 

*Done

