/*
 * Decompiled with CFR 0.152.
 */
package org.haskell.hslogger4j;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.Decoder;
import org.apache.log4j.spi.LoggingEvent;

public class LogFileXMLReceiver
extends Receiver {
    private String fileURL;
    private Rule expressionRule;
    private String filterExpression;
    private String decoder = "org.apache.log4j.xml.XMLDecoder";
    private boolean tailing = false;
    private Decoder decoderInstance;
    private Reader reader;
    private static final String FILE_KEY = "file";
    private String host;
    private String path;
    private boolean useCurrentThread;

    public String getFileURL() {
        return this.fileURL;
    }

    public void setFileURL(String string) {
        this.fileURL = string;
    }

    public String getDecoder() {
        return this.decoder;
    }

    public void setDecoder(String string) {
        this.decoder = string;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public boolean isTailing() {
        return this.tailing;
    }

    public void setTailing(boolean bl) {
        this.tailing = bl;
    }

    public void setFilterExpression(String string) {
        this.filterExpression = string;
    }

    private boolean passesExpression(LoggingEvent loggingEvent) {
        if (loggingEvent != null && this.expressionRule != null) {
            return this.expressionRule.evaluate(loggingEvent);
        }
        return true;
    }

    public static void main(String[] stringArray) {
    }

    public void shutdown() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void activateOptions() {
        Runnable runnable = new Runnable(){

            public void run() {
                Serializable serializable;
                try {
                    serializable = new URL(LogFileXMLReceiver.this.fileURL);
                    LogFileXMLReceiver.this.host = ((URL)serializable).getHost();
                    if (LogFileXMLReceiver.this.host != null && LogFileXMLReceiver.this.host.equals("")) {
                        LogFileXMLReceiver.this.host = LogFileXMLReceiver.FILE_KEY;
                    }
                    LogFileXMLReceiver.this.path = ((URL)serializable).getPath();
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
                try {
                    if (LogFileXMLReceiver.this.filterExpression != null) {
                        LogFileXMLReceiver.this.expressionRule = ExpressionRule.getRule((String)LogFileXMLReceiver.this.filterExpression);
                    }
                }
                catch (Exception exception) {
                    LogFileXMLReceiver.this.getLogger().warn((Object)("Invalid filter expression: " + LogFileXMLReceiver.this.filterExpression), (Throwable)exception);
                }
                try {
                    serializable = Class.forName(LogFileXMLReceiver.this.decoder);
                    Object t = ((Class)serializable).newInstance();
                    if (t instanceof Decoder) {
                        LogFileXMLReceiver.this.decoderInstance = (Decoder)t;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                try {
                    LogFileXMLReceiver.this.reader = new InputStreamReader(new URL(LogFileXMLReceiver.this.getFileURL()).openStream());
                    LogFileXMLReceiver.this.process(LogFileXMLReceiver.this.reader);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LogFileXMLReceiver.this.getLogger().info((Object)"file not available");
                }
                catch (IOException iOException) {
                    LogFileXMLReceiver.this.getLogger().warn((Object)"unable to load file", (Throwable)iOException);
                    return;
                }
            }
        };
        if (this.useCurrentThread) {
            runnable.run();
        } else {
            Thread thread = new Thread(runnable, "LogFileXMLReceiver-" + this.getName());
            thread.start();
        }
    }

    private void process(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        char[] cArray = new char[10000];
        this.getLogger().debug((Object)("processing starting: " + this.fileURL));
        int n = 0;
        do {
            System.out.println("in do loop-about to process");
            while ((n = bufferedReader.read(cArray)) > -1) {
                this.processEvents(this.decoderInstance.decodeEvents(String.valueOf(cArray, 0, n)));
            }
            if (!this.tailing) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } while (this.tailing);
        this.getLogger().debug((Object)("processing complete: " + this.fileURL));
        this.shutdown();
    }

    private void processEvents(Collection collection) {
        if (collection == null) {
            return;
        }
        for (LoggingEvent loggingEvent : collection) {
            if (!this.passesExpression(loggingEvent)) continue;
            if (loggingEvent.getProperty("hostname") != null) {
                loggingEvent.setProperty("hostname", this.host);
            }
            if (loggingEvent.getProperty("application") != null) {
                loggingEvent.setProperty("application", this.path);
            }
            this.doPost(loggingEvent);
        }
    }

    public final boolean isUseCurrentThread() {
        return this.useCurrentThread;
    }

    public final void setUseCurrentThread(boolean bl) {
        this.useCurrentThread = bl;
    }
}

