/* ----------------------------------------------------------------------
 * General purpose template file
 * Copyright (C) 2000 January Weiner III
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 ---------------------------------------------------------------------- */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <zlib.h>

#include "genpak.h"
#include "gp_getopt.h"

#define VERSION "template file"
#define PROGNAME "gp_template"

#ifdef GZ
	#include "genpak_gz.h"
#else
	#define gzFile FILE
	#define gp_gzOpen TryOpen
	#define gzdopen fdopen
	#define gzgets(arg1,arg2,arg3) fgets(arg2,arg3,arg1)
	#define gzclose fclose
#endif

char *progname ;

typedef struct {
	gzFile *in ;
	FILE *out ; } opt_s ;

/*
 *
 */


int main(int argc, char *argv[])
{
	extern int optind ;
	extern char *optarg ;
	int width = 70 ; /* width with which the sequence gets formatted */
	opt_s options ;
	sekw *inseq, *outseq ;
	double p ;
	double *q ;
	double **r ;
	char bufor[BUFSIZ] ;

	int c, fd;
	char message[100] ;
	int errflg = 0 ;

	progname = argv[0] ;

	while ((c = gp_getopt(argc, argv, "Hqdvh")) != EOF)
		switch(c) {
		case 'H':
			html = TRUE ;
			break ;
		case 'q':
			quiet = TRUE ;
			break ;
		case 'v':
			fprintf(stderr,"%s version %s\n",progname,VERSION) ;
			exit(0) ;
			break ;
		case 'd':
			debug = TRUE ;
			gp_warn("Running in debug mode") ;
			break ;
		case 'h':
			Help() ;
			break ;
		default:
			errflg++ ;
			break;
		}


	if(errflg) gp_error("Type '%s -h' for help",progname) ;

/* open the file pointer to read the sequences 
 * from: standard input or a file provided? */

	if(optind >= argc) options.in = gzdopen(fileno(stdin),"r") ;
	else options.in = gp_gzOpen(argv[optind],"r") ;


/* opening the file pointer to write the output: 
 * standard output or file provided? */
	optind++ ;

	if(optind >= argc) options.out = stdout ;
	else options.out = gp_file_open(argv[optind],"wb") ;

	gzgets(options.in,bufor,BUFSIZ) ;	
	fprintf(options.out,"%s",bufor) ;
	
	if(html) gp_warn_print_all(options.out) ;
	fclose(options.out) ;
	gzclose(options.in) ;
	return(0);
}

/* Standard mesage */

void Help()
{
printf("\n");
printf("%s, v. %s- no description yet",PROGNAME,VERSION);
printf("\n");
printf("  Usage:\n");
printf("     %s [options] [ input file ] [ output file ]\n",progname);
printf("\n");
printf("  Options:\n");
printf("     -v       : print version information & exit\n");
printf("     -h       : print this help screen & exit\n");
printf("     -q       : quiet, suppress error messages\n\n");
exit(0);
}


			
