// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package retail aliases all exported identifiers in package
// "cloud.google.com/go/retail/apiv2beta/retailpb".
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package retail

import (
	src "cloud.google.com/go/retail/apiv2beta/retailpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/retail/apiv2beta/retailpb
const (
	AttributeConfigLevel_ATTRIBUTE_CONFIG_LEVEL_UNSPECIFIED                     = src.AttributeConfigLevel_ATTRIBUTE_CONFIG_LEVEL_UNSPECIFIED
	AttributeConfigLevel_CATALOG_LEVEL_ATTRIBUTE_CONFIG                         = src.AttributeConfigLevel_CATALOG_LEVEL_ATTRIBUTE_CONFIG
	AttributeConfigLevel_PRODUCT_LEVEL_ATTRIBUTE_CONFIG                         = src.AttributeConfigLevel_PRODUCT_LEVEL_ATTRIBUTE_CONFIG
	CatalogAttribute_DYNAMIC_FACETABLE_DISABLED                                 = src.CatalogAttribute_DYNAMIC_FACETABLE_DISABLED
	CatalogAttribute_DYNAMIC_FACETABLE_ENABLED                                  = src.CatalogAttribute_DYNAMIC_FACETABLE_ENABLED
	CatalogAttribute_DYNAMIC_FACETABLE_OPTION_UNSPECIFIED                       = src.CatalogAttribute_DYNAMIC_FACETABLE_OPTION_UNSPECIFIED
	CatalogAttribute_EXACT_SEARCHABLE_DISABLED                                  = src.CatalogAttribute_EXACT_SEARCHABLE_DISABLED
	CatalogAttribute_EXACT_SEARCHABLE_ENABLED                                   = src.CatalogAttribute_EXACT_SEARCHABLE_ENABLED
	CatalogAttribute_EXACT_SEARCHABLE_OPTION_UNSPECIFIED                        = src.CatalogAttribute_EXACT_SEARCHABLE_OPTION_UNSPECIFIED
	CatalogAttribute_INDEXABLE_DISABLED                                         = src.CatalogAttribute_INDEXABLE_DISABLED
	CatalogAttribute_INDEXABLE_ENABLED                                          = src.CatalogAttribute_INDEXABLE_ENABLED
	CatalogAttribute_INDEXABLE_OPTION_UNSPECIFIED                               = src.CatalogAttribute_INDEXABLE_OPTION_UNSPECIFIED
	CatalogAttribute_NUMERICAL                                                  = src.CatalogAttribute_NUMERICAL
	CatalogAttribute_SEARCHABLE_DISABLED                                        = src.CatalogAttribute_SEARCHABLE_DISABLED
	CatalogAttribute_SEARCHABLE_ENABLED                                         = src.CatalogAttribute_SEARCHABLE_ENABLED
	CatalogAttribute_SEARCHABLE_OPTION_UNSPECIFIED                              = src.CatalogAttribute_SEARCHABLE_OPTION_UNSPECIFIED
	CatalogAttribute_TEXTUAL                                                    = src.CatalogAttribute_TEXTUAL
	CatalogAttribute_UNKNOWN                                                    = src.CatalogAttribute_UNKNOWN
	ImportProductsRequest_FULL                                                  = src.ImportProductsRequest_FULL
	ImportProductsRequest_INCREMENTAL                                           = src.ImportProductsRequest_INCREMENTAL
	ImportProductsRequest_RECONCILIATION_MODE_UNSPECIFIED                       = src.ImportProductsRequest_RECONCILIATION_MODE_UNSPECIFIED
	Model_ACTIVE                                                                = src.Model_ACTIVE
	Model_ALL_TUNING_DISABLED                                                   = src.Model_ALL_TUNING_DISABLED
	Model_DATA_ERROR                                                            = src.Model_DATA_ERROR
	Model_DATA_OK                                                               = src.Model_DATA_OK
	Model_DATA_STATE_UNSPECIFIED                                                = src.Model_DATA_STATE_UNSPECIFIED
	Model_INACTIVE                                                              = src.Model_INACTIVE
	Model_PAUSED                                                                = src.Model_PAUSED
	Model_PERIODIC_TUNING_DISABLED                                              = src.Model_PERIODIC_TUNING_DISABLED
	Model_PERIODIC_TUNING_ENABLED                                               = src.Model_PERIODIC_TUNING_ENABLED
	Model_PERIODIC_TUNING_STATE_UNSPECIFIED                                     = src.Model_PERIODIC_TUNING_STATE_UNSPECIFIED
	Model_SERVING_STATE_UNSPECIFIED                                             = src.Model_SERVING_STATE_UNSPECIFIED
	Model_TRAINING                                                              = src.Model_TRAINING
	Model_TRAINING_STATE_UNSPECIFIED                                            = src.Model_TRAINING_STATE_UNSPECIFIED
	Model_TUNED                                                                 = src.Model_TUNED
	Product_AVAILABILITY_UNSPECIFIED                                            = src.Product_AVAILABILITY_UNSPECIFIED
	Product_BACKORDER                                                           = src.Product_BACKORDER
	Product_COLLECTION                                                          = src.Product_COLLECTION
	Product_IN_STOCK                                                            = src.Product_IN_STOCK
	Product_OUT_OF_STOCK                                                        = src.Product_OUT_OF_STOCK
	Product_PREORDER                                                            = src.Product_PREORDER
	Product_PRIMARY                                                             = src.Product_PRIMARY
	Product_TYPE_UNSPECIFIED                                                    = src.Product_TYPE_UNSPECIFIED
	Product_VARIANT                                                             = src.Product_VARIANT
	RecommendationsFilteringOption_RECOMMENDATIONS_FILTERING_DISABLED           = src.RecommendationsFilteringOption_RECOMMENDATIONS_FILTERING_DISABLED
	RecommendationsFilteringOption_RECOMMENDATIONS_FILTERING_ENABLED            = src.RecommendationsFilteringOption_RECOMMENDATIONS_FILTERING_ENABLED
	RecommendationsFilteringOption_RECOMMENDATIONS_FILTERING_OPTION_UNSPECIFIED = src.RecommendationsFilteringOption_RECOMMENDATIONS_FILTERING_OPTION_UNSPECIFIED
	RejoinUserEventsRequest_JOINED_EVENTS                                       = src.RejoinUserEventsRequest_JOINED_EVENTS
	RejoinUserEventsRequest_UNJOINED_EVENTS                                     = src.RejoinUserEventsRequest_UNJOINED_EVENTS
	RejoinUserEventsRequest_USER_EVENT_REJOIN_SCOPE_UNSPECIFIED                 = src.RejoinUserEventsRequest_USER_EVENT_REJOIN_SCOPE_UNSPECIFIED
	SearchRequest_DynamicFacetSpec_DISABLED                                     = src.SearchRequest_DynamicFacetSpec_DISABLED
	SearchRequest_DynamicFacetSpec_ENABLED                                      = src.SearchRequest_DynamicFacetSpec_ENABLED
	SearchRequest_DynamicFacetSpec_MODE_UNSPECIFIED                             = src.SearchRequest_DynamicFacetSpec_MODE_UNSPECIFIED
	SearchRequest_FACETED_SEARCH_ONLY                                           = src.SearchRequest_FACETED_SEARCH_ONLY
	SearchRequest_PRODUCT_SEARCH_ONLY                                           = src.SearchRequest_PRODUCT_SEARCH_ONLY
	SearchRequest_PersonalizationSpec_AUTO                                      = src.SearchRequest_PersonalizationSpec_AUTO
	SearchRequest_PersonalizationSpec_DISABLED                                  = src.SearchRequest_PersonalizationSpec_DISABLED
	SearchRequest_PersonalizationSpec_MODE_UNSPECIFIED                          = src.SearchRequest_PersonalizationSpec_MODE_UNSPECIFIED
	SearchRequest_QueryExpansionSpec_AUTO                                       = src.SearchRequest_QueryExpansionSpec_AUTO
	SearchRequest_QueryExpansionSpec_CONDITION_UNSPECIFIED                      = src.SearchRequest_QueryExpansionSpec_CONDITION_UNSPECIFIED
	SearchRequest_QueryExpansionSpec_DISABLED                                   = src.SearchRequest_QueryExpansionSpec_DISABLED
	SearchRequest_SEARCH_MODE_UNSPECIFIED                                       = src.SearchRequest_SEARCH_MODE_UNSPECIFIED
	SearchRequest_SpellCorrectionSpec_AUTO                                      = src.SearchRequest_SpellCorrectionSpec_AUTO
	SearchRequest_SpellCorrectionSpec_MODE_UNSPECIFIED                          = src.SearchRequest_SpellCorrectionSpec_MODE_UNSPECIFIED
	SearchRequest_SpellCorrectionSpec_SUGGESTION_ONLY                           = src.SearchRequest_SpellCorrectionSpec_SUGGESTION_ONLY
	SearchSolutionUseCase_SEARCH_SOLUTION_USE_CASE_BROWSE                       = src.SearchSolutionUseCase_SEARCH_SOLUTION_USE_CASE_BROWSE
	SearchSolutionUseCase_SEARCH_SOLUTION_USE_CASE_SEARCH                       = src.SearchSolutionUseCase_SEARCH_SOLUTION_USE_CASE_SEARCH
	SearchSolutionUseCase_SEARCH_SOLUTION_USE_CASE_UNSPECIFIED                  = src.SearchSolutionUseCase_SEARCH_SOLUTION_USE_CASE_UNSPECIFIED
	ServingConfig_DATA_DRIVEN_DIVERSITY                                         = src.ServingConfig_DATA_DRIVEN_DIVERSITY
	ServingConfig_DIVERSITY_TYPE_UNSPECIFIED                                    = src.ServingConfig_DIVERSITY_TYPE_UNSPECIFIED
	ServingConfig_RULE_BASED_DIVERSITY                                          = src.ServingConfig_RULE_BASED_DIVERSITY
	SolutionType_SOLUTION_TYPE_RECOMMENDATION                                   = src.SolutionType_SOLUTION_TYPE_RECOMMENDATION
	SolutionType_SOLUTION_TYPE_SEARCH                                           = src.SolutionType_SOLUTION_TYPE_SEARCH
	SolutionType_SOLUTION_TYPE_UNSPECIFIED                                      = src.SolutionType_SOLUTION_TYPE_UNSPECIFIED
)

// Deprecated: Please use vars in: cloud.google.com/go/retail/apiv2beta/retailpb
var (
	AttributeConfigLevel_name                                    = src.AttributeConfigLevel_name
	AttributeConfigLevel_value                                   = src.AttributeConfigLevel_value
	CatalogAttribute_AttributeType_name                          = src.CatalogAttribute_AttributeType_name
	CatalogAttribute_AttributeType_value                         = src.CatalogAttribute_AttributeType_value
	CatalogAttribute_DynamicFacetableOption_name                 = src.CatalogAttribute_DynamicFacetableOption_name
	CatalogAttribute_DynamicFacetableOption_value                = src.CatalogAttribute_DynamicFacetableOption_value
	CatalogAttribute_ExactSearchableOption_name                  = src.CatalogAttribute_ExactSearchableOption_name
	CatalogAttribute_ExactSearchableOption_value                 = src.CatalogAttribute_ExactSearchableOption_value
	CatalogAttribute_IndexableOption_name                        = src.CatalogAttribute_IndexableOption_name
	CatalogAttribute_IndexableOption_value                       = src.CatalogAttribute_IndexableOption_value
	CatalogAttribute_SearchableOption_name                       = src.CatalogAttribute_SearchableOption_name
	CatalogAttribute_SearchableOption_value                      = src.CatalogAttribute_SearchableOption_value
	File_google_cloud_retail_v2beta_catalog_proto                = src.File_google_cloud_retail_v2beta_catalog_proto
	File_google_cloud_retail_v2beta_catalog_service_proto        = src.File_google_cloud_retail_v2beta_catalog_service_proto
	File_google_cloud_retail_v2beta_common_proto                 = src.File_google_cloud_retail_v2beta_common_proto
	File_google_cloud_retail_v2beta_completion_service_proto     = src.File_google_cloud_retail_v2beta_completion_service_proto
	File_google_cloud_retail_v2beta_control_proto                = src.File_google_cloud_retail_v2beta_control_proto
	File_google_cloud_retail_v2beta_control_service_proto        = src.File_google_cloud_retail_v2beta_control_service_proto
	File_google_cloud_retail_v2beta_export_config_proto          = src.File_google_cloud_retail_v2beta_export_config_proto
	File_google_cloud_retail_v2beta_import_config_proto          = src.File_google_cloud_retail_v2beta_import_config_proto
	File_google_cloud_retail_v2beta_model_proto                  = src.File_google_cloud_retail_v2beta_model_proto
	File_google_cloud_retail_v2beta_model_service_proto          = src.File_google_cloud_retail_v2beta_model_service_proto
	File_google_cloud_retail_v2beta_prediction_service_proto     = src.File_google_cloud_retail_v2beta_prediction_service_proto
	File_google_cloud_retail_v2beta_product_proto                = src.File_google_cloud_retail_v2beta_product_proto
	File_google_cloud_retail_v2beta_product_service_proto        = src.File_google_cloud_retail_v2beta_product_service_proto
	File_google_cloud_retail_v2beta_promotion_proto              = src.File_google_cloud_retail_v2beta_promotion_proto
	File_google_cloud_retail_v2beta_purge_config_proto           = src.File_google_cloud_retail_v2beta_purge_config_proto
	File_google_cloud_retail_v2beta_search_service_proto         = src.File_google_cloud_retail_v2beta_search_service_proto
	File_google_cloud_retail_v2beta_serving_config_proto         = src.File_google_cloud_retail_v2beta_serving_config_proto
	File_google_cloud_retail_v2beta_serving_config_service_proto = src.File_google_cloud_retail_v2beta_serving_config_service_proto
	File_google_cloud_retail_v2beta_user_event_proto             = src.File_google_cloud_retail_v2beta_user_event_proto
	File_google_cloud_retail_v2beta_user_event_service_proto     = src.File_google_cloud_retail_v2beta_user_event_service_proto
	ImportProductsRequest_ReconciliationMode_name                = src.ImportProductsRequest_ReconciliationMode_name
	ImportProductsRequest_ReconciliationMode_value               = src.ImportProductsRequest_ReconciliationMode_value
	Model_DataState_name                                         = src.Model_DataState_name
	Model_DataState_value                                        = src.Model_DataState_value
	Model_PeriodicTuningState_name                               = src.Model_PeriodicTuningState_name
	Model_PeriodicTuningState_value                              = src.Model_PeriodicTuningState_value
	Model_ServingState_name                                      = src.Model_ServingState_name
	Model_ServingState_value                                     = src.Model_ServingState_value
	Model_TrainingState_name                                     = src.Model_TrainingState_name
	Model_TrainingState_value                                    = src.Model_TrainingState_value
	Product_Availability_name                                    = src.Product_Availability_name
	Product_Availability_value                                   = src.Product_Availability_value
	Product_Type_name                                            = src.Product_Type_name
	Product_Type_value                                           = src.Product_Type_value
	RecommendationsFilteringOption_name                          = src.RecommendationsFilteringOption_name
	RecommendationsFilteringOption_value                         = src.RecommendationsFilteringOption_value
	RejoinUserEventsRequest_UserEventRejoinScope_name            = src.RejoinUserEventsRequest_UserEventRejoinScope_name
	RejoinUserEventsRequest_UserEventRejoinScope_value           = src.RejoinUserEventsRequest_UserEventRejoinScope_value
	SearchRequest_DynamicFacetSpec_Mode_name                     = src.SearchRequest_DynamicFacetSpec_Mode_name
	SearchRequest_DynamicFacetSpec_Mode_value                    = src.SearchRequest_DynamicFacetSpec_Mode_value
	SearchRequest_PersonalizationSpec_Mode_name                  = src.SearchRequest_PersonalizationSpec_Mode_name
	SearchRequest_PersonalizationSpec_Mode_value                 = src.SearchRequest_PersonalizationSpec_Mode_value
	SearchRequest_QueryExpansionSpec_Condition_name              = src.SearchRequest_QueryExpansionSpec_Condition_name
	SearchRequest_QueryExpansionSpec_Condition_value             = src.SearchRequest_QueryExpansionSpec_Condition_value
	SearchRequest_SearchMode_name                                = src.SearchRequest_SearchMode_name
	SearchRequest_SearchMode_value                               = src.SearchRequest_SearchMode_value
	SearchRequest_SpellCorrectionSpec_Mode_name                  = src.SearchRequest_SpellCorrectionSpec_Mode_name
	SearchRequest_SpellCorrectionSpec_Mode_value                 = src.SearchRequest_SpellCorrectionSpec_Mode_value
	SearchSolutionUseCase_name                                   = src.SearchSolutionUseCase_name
	SearchSolutionUseCase_value                                  = src.SearchSolutionUseCase_value
	ServingConfig_DiversityType_name                             = src.ServingConfig_DiversityType_name
	ServingConfig_DiversityType_value                            = src.ServingConfig_DiversityType_value
	SolutionType_name                                            = src.SolutionType_name
	SolutionType_value                                           = src.SolutionType_value
)

// Request for
// [CatalogService.AddCatalogAttribute][google.cloud.retail.v2beta.CatalogService.AddCatalogAttribute]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type AddCatalogAttributeRequest = src.AddCatalogAttributeRequest

// Request for AddControl method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type AddControlRequest = src.AddControlRequest

// Metadata related to the progress of the AddFulfillmentPlaces operation.
// Currently empty because there is no meaningful metadata populated from the
// [ProductService.AddFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.AddFulfillmentPlaces]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type AddFulfillmentPlacesMetadata = src.AddFulfillmentPlacesMetadata

// Request message for
// [ProductService.AddFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.AddFulfillmentPlaces]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type AddFulfillmentPlacesRequest = src.AddFulfillmentPlacesRequest

// Response of the AddFulfillmentPlacesRequest. Currently empty because there
// is no meaningful response populated from the
// [ProductService.AddFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.AddFulfillmentPlaces]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type AddFulfillmentPlacesResponse = src.AddFulfillmentPlacesResponse

// Metadata related to the progress of the AddLocalInventories operation.
// Currently empty because there is no meaningful metadata populated from the
// [ProductService.AddLocalInventories][google.cloud.retail.v2beta.ProductService.AddLocalInventories]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type AddLocalInventoriesMetadata = src.AddLocalInventoriesMetadata

// Request message for
// [ProductService.AddLocalInventories][google.cloud.retail.v2beta.ProductService.AddLocalInventories]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type AddLocalInventoriesRequest = src.AddLocalInventoriesRequest

// Response of the
// [ProductService.AddLocalInventories][google.cloud.retail.v2beta.ProductService.AddLocalInventories]
// API. Currently empty because there is no meaningful response populated from
// the
// [ProductService.AddLocalInventories][google.cloud.retail.v2beta.ProductService.AddLocalInventories]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type AddLocalInventoriesResponse = src.AddLocalInventoriesResponse

// At which level we offer configuration for attributes.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type AttributeConfigLevel = src.AttributeConfigLevel

// Catalog level attribute config.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type AttributesConfig = src.AttributesConfig

// An intended audience of the [Product][google.cloud.retail.v2beta.Product]
// for whom it's sold.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Audience = src.Audience

// Request for
// [CatalogService.BatchRemoveCatalogAttributes][google.cloud.retail.v2beta.CatalogService.BatchRemoveCatalogAttributes]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type BatchRemoveCatalogAttributesRequest = src.BatchRemoveCatalogAttributesRequest

// Response of the
// [CatalogService.BatchRemoveCatalogAttributes][google.cloud.retail.v2beta.CatalogService.BatchRemoveCatalogAttributes].
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type BatchRemoveCatalogAttributesResponse = src.BatchRemoveCatalogAttributesResponse

// A BigQuery output result.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type BigQueryOutputResult = src.BigQueryOutputResult

// BigQuery source import data from.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type BigQuerySource = src.BigQuerySource
type BigQuerySource_PartitionDate = src.BigQuerySource_PartitionDate

// The catalog configuration.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Catalog = src.Catalog

// Catalog level attribute config for an attribute. For example, if customers
// want to enable/disable facet for a specific attribute.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CatalogAttribute = src.CatalogAttribute

// The type of an attribute.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CatalogAttribute_AttributeType = src.CatalogAttribute_AttributeType

// The status of the dynamic facetable option of a catalog attribute.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CatalogAttribute_DynamicFacetableOption = src.CatalogAttribute_DynamicFacetableOption

// The status of the exact-searchable option of a catalog attribute.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CatalogAttribute_ExactSearchableOption = src.CatalogAttribute_ExactSearchableOption

// The status of the indexable option of a catalog attribute.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CatalogAttribute_IndexableOption = src.CatalogAttribute_IndexableOption

// The status of the searchable option of a catalog attribute.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CatalogAttribute_SearchableOption = src.CatalogAttribute_SearchableOption

// CatalogServiceClient is the client API for CatalogService service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CatalogServiceClient = src.CatalogServiceClient

// CatalogServiceServer is the server API for CatalogService service.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CatalogServiceServer = src.CatalogServiceServer

// Request message for CollectUserEvent method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CollectUserEventRequest = src.CollectUserEventRequest

// The color information of a [Product][google.cloud.retail.v2beta.Product].
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ColorInfo = src.ColorInfo

// Auto-complete parameters.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CompleteQueryRequest = src.CompleteQueryRequest

// Response of the auto-complete query.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CompleteQueryResponse = src.CompleteQueryResponse

// Resource that represents completion results.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CompleteQueryResponse_CompletionResult = src.CompleteQueryResponse_CompletionResult

// Recent search of this user.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CompleteQueryResponse_RecentSearchResult = src.CompleteQueryResponse_RecentSearchResult

// Catalog level autocomplete config for customers to customize autocomplete
// feature's settings.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CompletionConfig = src.CompletionConfig

// The input config source for completion data.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CompletionDataInputConfig = src.CompletionDataInputConfig
type CompletionDataInputConfig_BigQuerySource = src.CompletionDataInputConfig_BigQuerySource

// Detailed completion information including completion attribution token and
// clicked completion info.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CompletionDetail = src.CompletionDetail

// CompletionServiceClient is the client API for CompletionService service.
// For semantics around ctx use and closing/ending streaming RPCs, please refer
// to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CompletionServiceClient = src.CompletionServiceClient

// CompletionServiceServer is the server API for CompletionService service.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CompletionServiceServer = src.CompletionServiceServer

// Metadata that is used to define a condition that triggers an action. A
// valid condition must specify at least one of 'query_terms' or
// 'products_filter'. If multiple fields are specified, the condition is met if
// all the fields are satisfied e.g. if a set of query terms and product_filter
// are set, then only items matching the product_filter for requests with a
// query matching the query terms wil get boosted.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Condition = src.Condition

// Query terms that we want to match on.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Condition_QueryTerm = src.Condition_QueryTerm

// Used for time-dependent conditions. Example: Want to have rule applied for
// week long sale.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Condition_TimeRange = src.Condition_TimeRange

// Configures dynamic metadata that can be linked to a
// [ServingConfig][google.cloud.retail.v2beta.ServingConfig] and affect search
// or recommendation results at serving time.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Control = src.Control

// ControlServiceClient is the client API for ControlService service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ControlServiceClient = src.ControlServiceClient

// ControlServiceServer is the server API for ControlService service.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ControlServiceServer = src.ControlServiceServer
type Control_FacetSpec = src.Control_FacetSpec
type Control_Rule = src.Control_Rule

// Request for CreateControl method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CreateControlRequest = src.CreateControlRequest

// Metadata associated with a create operation.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CreateModelMetadata = src.CreateModelMetadata

// Request for creating a model.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CreateModelRequest = src.CreateModelRequest

// Request message for
// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CreateProductRequest = src.CreateProductRequest

// Request for CreateServingConfig method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CreateServingConfigRequest = src.CreateServingConfigRequest

// A custom attribute that is not explicitly modeled in
// [Product][google.cloud.retail.v2beta.Product].
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type CustomAttribute = src.CustomAttribute

// Request for DeleteControl method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type DeleteControlRequest = src.DeleteControlRequest

// Request for deleting a model.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type DeleteModelRequest = src.DeleteModelRequest

// Request message for
// [ProductService.DeleteProduct][google.cloud.retail.v2beta.ProductService.DeleteProduct]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type DeleteProductRequest = src.DeleteProductRequest

// Request for DeleteServingConfig method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type DeleteServingConfigRequest = src.DeleteServingConfigRequest

// Configuration of destination for Export related errors.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ExportErrorsConfig = src.ExportErrorsConfig
type ExportErrorsConfig_GcsPrefix = src.ExportErrorsConfig_GcsPrefix

// Metadata related to the progress of the Export operation. This is returned
// by the google.longrunning.Operation.metadata field.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ExportMetadata = src.ExportMetadata

// Response of the ExportProductsRequest. If the long running operation is
// done, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ExportProductsResponse = src.ExportProductsResponse

// Response of the ExportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ExportUserEventsResponse = src.ExportUserEventsResponse

// Fulfillment information, such as the store IDs for in-store pickup or
// region IDs for different shipping methods.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type FulfillmentInfo = src.FulfillmentInfo

// Google Cloud Storage location for input content.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type GcsSource = src.GcsSource

// Request for
// [CatalogService.GetAttributesConfig][google.cloud.retail.v2beta.CatalogService.GetAttributesConfig]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type GetAttributesConfigRequest = src.GetAttributesConfigRequest

// Request for
// [CatalogService.GetCompletionConfig][google.cloud.retail.v2beta.CatalogService.GetCompletionConfig]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type GetCompletionConfigRequest = src.GetCompletionConfigRequest

// Request for GetControl method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type GetControlRequest = src.GetControlRequest

// Request message to show which branch is currently the default branch.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type GetDefaultBranchRequest = src.GetDefaultBranchRequest

// Response message of
// [CatalogService.GetDefaultBranch][google.cloud.retail.v2beta.CatalogService.GetDefaultBranch].
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type GetDefaultBranchResponse = src.GetDefaultBranchResponse

// Request message for
// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type GetProductRequest = src.GetProductRequest

// Request for GetServingConfig method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type GetServingConfigRequest = src.GetServingConfigRequest

// [Product][google.cloud.retail.v2beta.Product] image. Recommendations AI and
// Retail Search do not use product images to improve prediction and search
// results. However, product images can be returned in results, and are shown
// in prediction or search previews in the console.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Image = src.Image

// Request message for ImportCompletionData methods.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ImportCompletionDataRequest = src.ImportCompletionDataRequest

// Response of the
// [ImportCompletionDataRequest][google.cloud.retail.v2beta.ImportCompletionDataRequest].
// If the long running operation is done, this message is returned by the
// google.longrunning.Operations.response field if the operation is successful.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ImportCompletionDataResponse = src.ImportCompletionDataResponse

// Configuration of destination for Import related errors.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ImportErrorsConfig = src.ImportErrorsConfig
type ImportErrorsConfig_GcsPrefix = src.ImportErrorsConfig_GcsPrefix

// Metadata related to the progress of the Import operation. This is returned
// by the google.longrunning.Operation.metadata field.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ImportMetadata = src.ImportMetadata

// Request message for Import methods.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ImportProductsRequest = src.ImportProductsRequest

// Indicates how imported products are reconciled with the existing products
// created or imported before.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ImportProductsRequest_ReconciliationMode = src.ImportProductsRequest_ReconciliationMode

// Response of the
// [ImportProductsRequest][google.cloud.retail.v2beta.ImportProductsRequest].
// If the long running operation is done, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ImportProductsResponse = src.ImportProductsResponse

// Request message for the ImportUserEvents request.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ImportUserEventsRequest = src.ImportUserEventsRequest

// Response of the ImportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ImportUserEventsResponse = src.ImportUserEventsResponse

// A floating point interval.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Interval = src.Interval
type Interval_ExclusiveMaximum = src.Interval_ExclusiveMaximum
type Interval_ExclusiveMinimum = src.Interval_ExclusiveMinimum
type Interval_Maximum = src.Interval_Maximum
type Interval_Minimum = src.Interval_Minimum

// Request for
// [CatalogService.ListCatalogs][google.cloud.retail.v2beta.CatalogService.ListCatalogs]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ListCatalogsRequest = src.ListCatalogsRequest

// Response for
// [CatalogService.ListCatalogs][google.cloud.retail.v2beta.CatalogService.ListCatalogs]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ListCatalogsResponse = src.ListCatalogsResponse

// Request for ListControls method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ListControlsRequest = src.ListControlsRequest

// Response for ListControls method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ListControlsResponse = src.ListControlsResponse

// Request for listing models associated with a resource.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ListModelsRequest = src.ListModelsRequest

// Response to a ListModelRequest.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ListModelsResponse = src.ListModelsResponse

// Request message for
// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ListProductsRequest = src.ListProductsRequest

// Response message for
// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ListProductsResponse = src.ListProductsResponse

// Request for ListServingConfigs method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ListServingConfigsRequest = src.ListServingConfigsRequest

// Response for ListServingConfigs method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ListServingConfigsResponse = src.ListServingConfigsResponse

// The inventory information at a place (e.g. a store) identified by a place
// ID.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type LocalInventory = src.LocalInventory

// Represents a link between a Merchant Center account and a branch. Once a
// link is established, products from the linked merchant center account will
// be streamed to the linked branch.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type MerchantCenterLink = src.MerchantCenterLink

// Configures Merchant Center linking. Links contained in the config will be
// used to sync data from a Merchant Center account to a Cloud Retail branch.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type MerchantCenterLinkingConfig = src.MerchantCenterLinkingConfig

// Metadata that describes the training and serving parameters of a
// [Model][google.cloud.retail.v2beta.Model]. A
// [Model][google.cloud.retail.v2beta.Model] can be associated with a
// [ServingConfig][google.cloud.retail.v2beta.ServingConfig] and then queried
// through the Predict API.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Model = src.Model

// ModelServiceClient is the client API for ModelService service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ModelServiceClient = src.ModelServiceClient

// ModelServiceServer is the server API for ModelService service.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ModelServiceServer = src.ModelServiceServer

// Describes whether this model have sufficient training data to be
// continuously trained.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Model_DataState = src.Model_DataState

// Describes whether periodic tuning is enabled for this model or not.
// Periodic tuning is scheduled at most every three months. You can start a
// tuning process manually by using the `TuneModel` method, which starts a
// tuning process immediately and resets the quarterly schedule. Enabling or
// disabling periodic tuning does not affect any current tuning processes.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Model_PeriodicTuningState = src.Model_PeriodicTuningState

// Represents an ordered combination of valid serving configs, which can be
// used for `PAGE_OPTIMIZATION` recommendations.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Model_ServingConfigList = src.Model_ServingConfigList

// The serving state of the model.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Model_ServingState = src.Model_ServingState

// The training state of the model.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Model_TrainingState = src.Model_TrainingState

// Output result.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type OutputResult = src.OutputResult

// Request for pausing training of a model.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type PauseModelRequest = src.PauseModelRequest

// Request message for Predict method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type PredictRequest = src.PredictRequest

// Response message for predict method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type PredictResponse = src.PredictResponse

// PredictionResult represents the recommendation prediction results.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type PredictResponse_PredictionResult = src.PredictResponse_PredictionResult

// PredictionServiceClient is the client API for PredictionService service.
// For semantics around ctx use and closing/ending streaming RPCs, please refer
// to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type PredictionServiceClient = src.PredictionServiceClient

// PredictionServiceServer is the server API for PredictionService service.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type PredictionServiceServer = src.PredictionServiceServer

// The price information of a [Product][google.cloud.retail.v2beta.Product].
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type PriceInfo = src.PriceInfo

// The price range of all
// [variant][google.cloud.retail.v2beta.Product.Type.VARIANT]
// [Product][google.cloud.retail.v2beta.Product] having the same
// [Product.primary_product_id][google.cloud.retail.v2beta.Product.primary_product_id].
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type PriceInfo_PriceRange = src.PriceInfo_PriceRange

// Product captures all metadata information of items to be recommended or
// searched.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Product = src.Product

// Detailed product information associated with a user event.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ProductDetail = src.ProductDetail

// The inline source for the input config for ImportProducts method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ProductInlineSource = src.ProductInlineSource

// The input config source for products.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ProductInputConfig = src.ProductInputConfig
type ProductInputConfig_BigQuerySource = src.ProductInputConfig_BigQuerySource
type ProductInputConfig_GcsSource = src.ProductInputConfig_GcsSource
type ProductInputConfig_ProductInlineSource = src.ProductInputConfig_ProductInlineSource

// Configures what level the product should be uploaded with regards to how
// users will be send events and how predictions will be made.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ProductLevelConfig = src.ProductLevelConfig

// ProductServiceClient is the client API for ProductService service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ProductServiceClient = src.ProductServiceClient

// ProductServiceServer is the server API for ProductService service.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ProductServiceServer = src.ProductServiceServer

// Product availability. If this field is unspecified, the product is assumed
// to be in stock.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Product_Availability = src.Product_Availability
type Product_ExpireTime = src.Product_ExpireTime
type Product_Ttl = src.Product_Ttl

// The type of this product.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Product_Type = src.Product_Type

// Promotion information.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Promotion = src.Promotion

// A transaction represents the entire purchase transaction.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type PurchaseTransaction = src.PurchaseTransaction

// Metadata related to the progress of the Purge operation. This will be
// returned by the google.longrunning.Operation.metadata field.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type PurgeMetadata = src.PurgeMetadata

// Request message for PurgeUserEvents method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type PurgeUserEventsRequest = src.PurgeUserEventsRequest

// Response of the PurgeUserEventsRequest. If the long running operation is
// successfully done, then this message is returned by the
// google.longrunning.Operations.response field.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type PurgeUserEventsResponse = src.PurgeUserEventsResponse

// The rating of a [Product][google.cloud.retail.v2beta.Product].
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Rating = src.Rating

// If filtering for recommendations is enabled.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type RecommendationsFilteringOption = src.RecommendationsFilteringOption

// Metadata for `RejoinUserEvents` method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type RejoinUserEventsMetadata = src.RejoinUserEventsMetadata

// Request message for RejoinUserEvents method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type RejoinUserEventsRequest = src.RejoinUserEventsRequest

// The scope of user events to be rejoined with the latest product catalog. If
// the rejoining aims at reducing number of unjoined events, set
// `UserEventRejoinScope` to `UNJOINED_EVENTS`. If the rejoining aims at
// correcting product catalog information in joined events, set
// `UserEventRejoinScope` to `JOINED_EVENTS`. If all events needs to be
// rejoined, set `UserEventRejoinScope` to
// `USER_EVENT_REJOIN_SCOPE_UNSPECIFIED`.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type RejoinUserEventsRequest_UserEventRejoinScope = src.RejoinUserEventsRequest_UserEventRejoinScope

// Response message for `RejoinUserEvents` method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type RejoinUserEventsResponse = src.RejoinUserEventsResponse

// Request for
// [CatalogService.RemoveCatalogAttribute][google.cloud.retail.v2beta.CatalogService.RemoveCatalogAttribute]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type RemoveCatalogAttributeRequest = src.RemoveCatalogAttributeRequest

// Request for RemoveControl method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type RemoveControlRequest = src.RemoveControlRequest

// Metadata related to the progress of the RemoveFulfillmentPlaces operation.
// Currently empty because there is no meaningful metadata populated from the
// [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.RemoveFulfillmentPlaces]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type RemoveFulfillmentPlacesMetadata = src.RemoveFulfillmentPlacesMetadata

// Request message for
// [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.RemoveFulfillmentPlaces]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type RemoveFulfillmentPlacesRequest = src.RemoveFulfillmentPlacesRequest

// Response of the RemoveFulfillmentPlacesRequest. Currently empty because
// there is no meaningful response populated from the
// [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.RemoveFulfillmentPlaces]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type RemoveFulfillmentPlacesResponse = src.RemoveFulfillmentPlacesResponse

// Metadata related to the progress of the RemoveLocalInventories operation.
// Currently empty because there is no meaningful metadata populated from the
// [ProductService.RemoveLocalInventories][google.cloud.retail.v2beta.ProductService.RemoveLocalInventories]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type RemoveLocalInventoriesMetadata = src.RemoveLocalInventoriesMetadata

// Request message for
// [ProductService.RemoveLocalInventories][google.cloud.retail.v2beta.ProductService.RemoveLocalInventories]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type RemoveLocalInventoriesRequest = src.RemoveLocalInventoriesRequest

// Response of the
// [ProductService.RemoveLocalInventories][google.cloud.retail.v2beta.ProductService.RemoveLocalInventories]
// API. Currently empty because there is no meaningful response populated from
// the
// [ProductService.RemoveLocalInventories][google.cloud.retail.v2beta.ProductService.RemoveLocalInventories]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type RemoveLocalInventoriesResponse = src.RemoveLocalInventoriesResponse

// Request for
// [CatalogService.ReplaceCatalogAttribute][google.cloud.retail.v2beta.CatalogService.ReplaceCatalogAttribute]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ReplaceCatalogAttributeRequest = src.ReplaceCatalogAttributeRequest

// Request for resuming training of a model.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ResumeModelRequest = src.ResumeModelRequest

// A rule is a condition-action pair * A condition defines when a rule is to
// be triggered. * An action specifies what occurs on that trigger. Currently
// rules only work for [controls][google.cloud.retail.v2beta.Control] with
// [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2beta.SolutionType.SOLUTION_TYPE_SEARCH].
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Rule = src.Rule

// A boost action to apply to results matching condition specified above.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Rule_BoostAction = src.Rule_BoostAction
type Rule_BoostAction_ = src.Rule_BoostAction_

// Prevents `query_term` from being associated with specified terms during
// search. Example: Don't associate "gShoe" and "cheap".
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Rule_DoNotAssociateAction = src.Rule_DoNotAssociateAction
type Rule_DoNotAssociateAction_ = src.Rule_DoNotAssociateAction_

// * Rule Condition: - No
// [Condition.query_terms][google.cloud.retail.v2beta.Condition.query_terms]
// provided is a global match. - 1 or more
// [Condition.query_terms][google.cloud.retail.v2beta.Condition.query_terms]
// provided are combined with OR operator. * Action Input: The request query
// and filter that are applied to the retrieved products, in addition to any
// filters already provided with the SearchRequest. The AND operator is used to
// combine the query's existing filters with the filter rule(s). NOTE: May
// result in 0 results when filters conflict. * Action Result: Filters the
// returned objects to be ONLY those that passed the filter.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Rule_FilterAction = src.Rule_FilterAction
type Rule_FilterAction_ = src.Rule_FilterAction_

// Prevents a term in the query from being used in search. Example: Don't
// search for "shoddy".
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Rule_IgnoreAction = src.Rule_IgnoreAction
type Rule_IgnoreAction_ = src.Rule_IgnoreAction_

// Maps a set of terms to a set of synonyms. Set of synonyms will be treated
// as synonyms of each query term only. `query_terms` will not be treated as
// synonyms of each other. Example: "sneakers" will use a synonym of "shoes".
// "shoes" will not use a synonym of "sneakers".
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Rule_OnewaySynonymsAction = src.Rule_OnewaySynonymsAction
type Rule_OnewaySynonymsAction_ = src.Rule_OnewaySynonymsAction_

// Redirects a shopper to a specific page. * Rule Condition: - Must specify
// [Condition.query_terms][google.cloud.retail.v2beta.Condition.query_terms]. *
// Action Input: Request Query * Action Result: Redirects shopper to provided
// uri.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Rule_RedirectAction = src.Rule_RedirectAction
type Rule_RedirectAction_ = src.Rule_RedirectAction_

// Replaces a term in the query. Multiple replacement candidates can be
// specified. All `query_terms` will be replaced with the replacement term.
// Example: Replace "gShoe" with "google shoe".
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Rule_ReplacementAction = src.Rule_ReplacementAction
type Rule_ReplacementAction_ = src.Rule_ReplacementAction_

// Creates a set of terms that will be treated as synonyms of each other.
// Example: synonyms of "sneakers" and "shoes". - "sneakers" will use a synonym
// of "shoes". - "shoes" will use a synonym of "sneakers".
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type Rule_TwowaySynonymsAction = src.Rule_TwowaySynonymsAction
type Rule_TwowaySynonymsAction_ = src.Rule_TwowaySynonymsAction_

// Request message for
// [SearchService.Search][google.cloud.retail.v2beta.SearchService.Search]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchRequest = src.SearchRequest

// Boost specification to boost certain items.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchRequest_BoostSpec = src.SearchRequest_BoostSpec

// Boost applies to products which match a condition.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchRequest_BoostSpec_ConditionBoostSpec = src.SearchRequest_BoostSpec_ConditionBoostSpec

// The specifications of dynamically generated facets.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchRequest_DynamicFacetSpec = src.SearchRequest_DynamicFacetSpec

// Enum to control DynamicFacet mode
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchRequest_DynamicFacetSpec_Mode = src.SearchRequest_DynamicFacetSpec_Mode

// A facet specification to perform faceted search.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchRequest_FacetSpec = src.SearchRequest_FacetSpec

// Specifies how a facet is computed.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchRequest_FacetSpec_FacetKey = src.SearchRequest_FacetSpec_FacetKey

// The specification for personalization.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchRequest_PersonalizationSpec = src.SearchRequest_PersonalizationSpec

// The personalization mode of each search request.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchRequest_PersonalizationSpec_Mode = src.SearchRequest_PersonalizationSpec_Mode

// Specification to determine under which conditions query expansion should
// occur.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchRequest_QueryExpansionSpec = src.SearchRequest_QueryExpansionSpec

// Enum describing under which condition query expansion should occur.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchRequest_QueryExpansionSpec_Condition = src.SearchRequest_QueryExpansionSpec_Condition

// The search mode of each search request.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchRequest_SearchMode = src.SearchRequest_SearchMode

// The specification for query spell correction.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchRequest_SpellCorrectionSpec = src.SearchRequest_SpellCorrectionSpec

// Enum describing under which mode spell correction should occur.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchRequest_SpellCorrectionSpec_Mode = src.SearchRequest_SpellCorrectionSpec_Mode

// Response message for
// [SearchService.Search][google.cloud.retail.v2beta.SearchService.Search]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchResponse = src.SearchResponse

// A facet result.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchResponse_Facet = src.SearchResponse_Facet

// A facet value which contains value names and their count.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchResponse_Facet_FacetValue = src.SearchResponse_Facet_FacetValue
type SearchResponse_Facet_FacetValue_Interval = src.SearchResponse_Facet_FacetValue_Interval
type SearchResponse_Facet_FacetValue_Value = src.SearchResponse_Facet_FacetValue_Value

// Information describing query expansion including whether expansion has
// occurred.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchResponse_QueryExpansionInfo = src.SearchResponse_QueryExpansionInfo

// Represents the search results.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchResponse_SearchResult = src.SearchResponse_SearchResult

// SearchServiceClient is the client API for SearchService service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchServiceClient = src.SearchServiceClient

// SearchServiceServer is the server API for SearchService service.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchServiceServer = src.SearchServiceServer

// The use case of Cloud Retail Search.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SearchSolutionUseCase = src.SearchSolutionUseCase

// Configures metadata that is used to generate serving time results (e.g.
// search results or recommendation predictions).
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ServingConfig = src.ServingConfig

// ServingConfigServiceClient is the client API for ServingConfigService
// service. For semantics around ctx use and closing/ending streaming RPCs,
// please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ServingConfigServiceClient = src.ServingConfigServiceClient

// ServingConfigServiceServer is the server API for ServingConfigService
// service.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ServingConfigServiceServer = src.ServingConfigServiceServer

// What type of diversity - data or rule based. If none is specified, default
// to rule based.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type ServingConfig_DiversityType = src.ServingConfig_DiversityType

// Request message to set a specified branch as new default_branch.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SetDefaultBranchRequest = src.SetDefaultBranchRequest

// Metadata related to the progress of the SetInventory operation. Currently
// empty because there is no meaningful metadata populated from the
// [ProductService.SetInventory][google.cloud.retail.v2beta.ProductService.SetInventory]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SetInventoryMetadata = src.SetInventoryMetadata

// Request message for
// [ProductService.SetInventory][google.cloud.retail.v2beta.ProductService.SetInventory]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SetInventoryRequest = src.SetInventoryRequest

// Response of the SetInventoryRequest. Currently empty because there is no
// meaningful response populated from the
// [ProductService.SetInventory][google.cloud.retail.v2beta.ProductService.SetInventory]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SetInventoryResponse = src.SetInventoryResponse

// The type of solution.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type SolutionType = src.SolutionType

// Metadata associated with a tune operation.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type TuneModelMetadata = src.TuneModelMetadata

// Request to manually start a tuning process now (instead of waiting for the
// periodically scheduled tuning to happen).
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type TuneModelRequest = src.TuneModelRequest

// Response associated with a tune operation.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type TuneModelResponse = src.TuneModelResponse

// UnimplementedCatalogServiceServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UnimplementedCatalogServiceServer = src.UnimplementedCatalogServiceServer

// UnimplementedCompletionServiceServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UnimplementedCompletionServiceServer = src.UnimplementedCompletionServiceServer

// UnimplementedControlServiceServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UnimplementedControlServiceServer = src.UnimplementedControlServiceServer

// UnimplementedModelServiceServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UnimplementedModelServiceServer = src.UnimplementedModelServiceServer

// UnimplementedPredictionServiceServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UnimplementedPredictionServiceServer = src.UnimplementedPredictionServiceServer

// UnimplementedProductServiceServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UnimplementedProductServiceServer = src.UnimplementedProductServiceServer

// UnimplementedSearchServiceServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UnimplementedSearchServiceServer = src.UnimplementedSearchServiceServer

// UnimplementedServingConfigServiceServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UnimplementedServingConfigServiceServer = src.UnimplementedServingConfigServiceServer

// UnimplementedUserEventServiceServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UnimplementedUserEventServiceServer = src.UnimplementedUserEventServiceServer

// Request for
// [CatalogService.UpdateAttributesConfig][google.cloud.retail.v2beta.CatalogService.UpdateAttributesConfig]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UpdateAttributesConfigRequest = src.UpdateAttributesConfigRequest

// Request for
// [CatalogService.UpdateCatalog][google.cloud.retail.v2beta.CatalogService.UpdateCatalog]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UpdateCatalogRequest = src.UpdateCatalogRequest

// Request for
// [CatalogService.UpdateCompletionConfig][google.cloud.retail.v2beta.CatalogService.UpdateCompletionConfig]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UpdateCompletionConfigRequest = src.UpdateCompletionConfigRequest

// Request for UpdateControl method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UpdateControlRequest = src.UpdateControlRequest

// Request for updating an existing model.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UpdateModelRequest = src.UpdateModelRequest

// Request message for
// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UpdateProductRequest = src.UpdateProductRequest

// Request for UpdateServingConfig method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UpdateServingConfigRequest = src.UpdateServingConfigRequest

// UserEvent captures all metadata information Retail API needs to know about
// how end users interact with customers' website.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UserEvent = src.UserEvent

// A summary of import result. The UserEventImportSummary summarizes the
// import status for user events.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UserEventImportSummary = src.UserEventImportSummary

// The inline source for the input config for ImportUserEvents method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UserEventInlineSource = src.UserEventInlineSource

// The input config source for user events.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UserEventInputConfig = src.UserEventInputConfig
type UserEventInputConfig_BigQuerySource = src.UserEventInputConfig_BigQuerySource
type UserEventInputConfig_GcsSource = src.UserEventInputConfig_GcsSource
type UserEventInputConfig_UserEventInlineSource = src.UserEventInputConfig_UserEventInlineSource

// UserEventServiceClient is the client API for UserEventService service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UserEventServiceClient = src.UserEventServiceClient

// UserEventServiceServer is the server API for UserEventService service.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UserEventServiceServer = src.UserEventServiceServer

// Information of an end user.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type UserInfo = src.UserInfo

// Request message for WriteUserEvent method.
//
// Deprecated: Please use types in: cloud.google.com/go/retail/apiv2beta/retailpb
type WriteUserEventRequest = src.WriteUserEventRequest

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func NewCatalogServiceClient(cc grpc.ClientConnInterface) CatalogServiceClient {
	return src.NewCatalogServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func NewCompletionServiceClient(cc grpc.ClientConnInterface) CompletionServiceClient {
	return src.NewCompletionServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func NewControlServiceClient(cc grpc.ClientConnInterface) ControlServiceClient {
	return src.NewControlServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func NewModelServiceClient(cc grpc.ClientConnInterface) ModelServiceClient {
	return src.NewModelServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func NewPredictionServiceClient(cc grpc.ClientConnInterface) PredictionServiceClient {
	return src.NewPredictionServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func NewProductServiceClient(cc grpc.ClientConnInterface) ProductServiceClient {
	return src.NewProductServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func NewSearchServiceClient(cc grpc.ClientConnInterface) SearchServiceClient {
	return src.NewSearchServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func NewServingConfigServiceClient(cc grpc.ClientConnInterface) ServingConfigServiceClient {
	return src.NewServingConfigServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func NewUserEventServiceClient(cc grpc.ClientConnInterface) UserEventServiceClient {
	return src.NewUserEventServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func RegisterCatalogServiceServer(s *grpc.Server, srv CatalogServiceServer) {
	src.RegisterCatalogServiceServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func RegisterCompletionServiceServer(s *grpc.Server, srv CompletionServiceServer) {
	src.RegisterCompletionServiceServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func RegisterControlServiceServer(s *grpc.Server, srv ControlServiceServer) {
	src.RegisterControlServiceServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func RegisterModelServiceServer(s *grpc.Server, srv ModelServiceServer) {
	src.RegisterModelServiceServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func RegisterPredictionServiceServer(s *grpc.Server, srv PredictionServiceServer) {
	src.RegisterPredictionServiceServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func RegisterProductServiceServer(s *grpc.Server, srv ProductServiceServer) {
	src.RegisterProductServiceServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func RegisterSearchServiceServer(s *grpc.Server, srv SearchServiceServer) {
	src.RegisterSearchServiceServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func RegisterServingConfigServiceServer(s *grpc.Server, srv ServingConfigServiceServer) {
	src.RegisterServingConfigServiceServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/retail/apiv2beta/retailpb
func RegisterUserEventServiceServer(s *grpc.Server, srv UserEventServiceServer) {
	src.RegisterUserEventServiceServer(s, srv)
}
