/*
   Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __PIEGE__
#define __PIEGE__


#include <stdlib.h>
#include <stdio.h>

#include "sprite.hpp"
#include "list.hpp"
#include "explosion.hpp"
#include "spirale.hpp"

class Piege : public Sprite {
public:
    Piege(List *list, int speed, float x);
    void draw();
    void drawShadowable();
    void move();
    void collision(Sprite *);
    
    float getX() { return x_+spotX_; }
    float getY() { return .5; }
    float getZ() { return z_+spotZ_; }
    
    
protected:
    int state_;
    float spotX_,spotY_,spotZ_;
    float spotdX_,spotdZ_;
    float tetay_;
    float tuching_;
    Sprite* toFollow_;
    float lightelse_;
	float period_;
    int ringing_;
    int elapsedTime_;
};




class Poto : public Sprite {
public:
    Poto(Sprite *lamp);
    void draw();
    void drawShadowable();
    void move();
    void collision(Sprite *);   
    
};

#endif



