/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "listsprite.hpp"
#include "sprite.hpp"


ListSprite::ListSprite() {
    nNumberOfRealEnemy=0;
}

void ListSprite::draw()
{
    Sprite *current;
    
    glEnable(GL_LIGHTING);
    glEnable(GL_TEXTURE_2D);
    glDisable(GL_BLEND); 

    /* TYPE_PIEGE
    does not update the z buffer...
    so they must be drawn at the end... */
    if (mfirst) {
        current=(Sprite*)mfirst;
        do {
            if ((current->getType()!=Sprite::TYPE_PIEGE) && (current->getType()!=Sprite::TYPE_EXPLOSION) && (current->getType()!=Sprite::TYPE_MY_FIRE1)&& (current->getType()!=Sprite::TYPE_MY_FIRE4))
                current->draw();
            current = (Sprite*)current->GetNext();
        } while (current!=NULL);
    }
    

    glDisable(GL_LIGHTING);
    glDisable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);    
    
    if (mfirst) {
        current=(Sprite*)mfirst;
        do {
            if ((current->getType()==Sprite::TYPE_EXPLOSION) || (current->getType()==Sprite::TYPE_MY_FIRE1)|| (current->getType()==Sprite::TYPE_MY_FIRE4))
                current->draw();
            current = (Sprite*)current->GetNext();
        } while (current!=NULL);
    }
    
    
    if (mfirst) {
        current=(Sprite*)mfirst;
        do {
            if (current->getType()==Sprite::TYPE_PIEGE)
                current->draw();
            current = (Sprite*)current->GetNext();
        } while (current!=NULL);
    }
    glEnable(GL_LIGHTING);
    glEnable(GL_TEXTURE_2D);
    glDisable(GL_BLEND); 
    
    
    //printf("Fin de ListSprite::draw()\n");
    
}

void ListSprite::drawShadows()
{
    Sprite *current;
    
    if (mfirst) {
        current=(Sprite*)mfirst;
        do {
            current->drawShadowable();
            current = (Sprite*)current->GetNext();
        } while (current!=NULL);
    }
}


void ListSprite::move()
{
    int i=0;
    Sprite *current;
    
//     printf("ListSprite::move()...\n");
    if (mfirst!=NULL) {
        current= (Sprite*)mfirst;
        do {
  //                printf("%d -> current 0x%x\n",i++,current);
    //              printf("      current Type  %d\n",((Sprite*)current)->getType());
            
                  current->move();
      //            printf("%d -> OK...\n");
        } while ((current=(Sprite*)current->mnext)!=NULL);
    }
//       printf("Fin de ListSprite::move()...\n");
}

#define ABS(x) ((x<0)?-x:x)

void ListSprite::collision()
{
    static Sprite *current;
    static float dx,dy,dz,dcx,dcy,dcz;
    static Sprite *next;
    
    // printf("ListSprite::collision\n");
    if (mfirst!=NULL) {
        current=(Sprite *)mfirst;
        do {
            
            //      printf("- current : 0x%x\n",current);
            
            next = current;
            while ((next=(Sprite*)(next->mnext))!=NULL)
                /*        if (current->type_!=((Sprite*)current)->type_)*/
            {
                //      printf("-- next  : 0x%x\n",next);
                dx = next->getX() - current->getX();
                dy = next->getY() - current->getY();
                dz = next->getZ() - current->getZ();
                
                dcx=(next->sizex_+current->sizex_)/2;
                dcy=(next->sizey_+current->sizey_)/2;
                dcz=(next->sizez_+current->sizez_)/2;
                if ((ABS(dx)<ABS(dcx)) && (ABS(dy)<ABS(dcy)) && (ABS(dz)<ABS(dcz)))
                {
                /*            printf("dx=%f,dz=%f,dcx=%f,dcz=%f\n",
                    dx,dz,dcx,dcz);*/
                    current->collision(next);
                    next->collision(current);
                }
            }       
            //      Setcurrent(current);
        }  while ((current=(Sprite*)current->mnext)!=NULL);
    }  
    // printf("  Fin de ListSprite::collision\n");
}



void ListSprite::cleanList()
{
    Sprite *current;
    Sprite *next;
    
    // printf("ListSprite::cleanList()\n");
    if (mfirst) {
        current=(Sprite*)mfirst;
        do {
            next = (Sprite*)current->GetNext();
            if (current->isDead()) {
                if (current->bRealEnemy)
                    nNumberOfRealEnemy--;
                current->iJustDied();
                current->RemoveMe();
                delete current;
            } 
            current = next;
        } while (current);
        // printf("  Fin ListSprite::cleanList()\n");
    }
}

void ListSprite::killAll()
{
    Sprite *current;
    static Sprite *next;
    
    if (mfirst) {
        current=(Sprite*)mfirst;
        do {
            next = (Sprite*)current->GetNext();
            current->RemoveMe();
            delete current;
            current = next;
        } while (current);    
    }
    nNumberOfRealEnemy=0;
}

void ListSprite::Add(Sprite * el) {
    List::Add(el);
    if (el->bRealEnemy==true) {
        nNumberOfRealEnemy++;
        //        printf("nNumberOfRealEnemy = %d\n",nNumberOfRealEnemy);
    }
}

Sprite* ListSprite::getAnEnemy() {
    if (nNumberOfRealEnemy==0) return NULL;
    int number;
    if (nNumberOfRealEnemy==1) number=1; 
    else number=(random()%nNumberOfRealEnemy)+1;
    //    printf("-----------> Number = %d  / %d\n",number , nNumberOfRealEnemy );
    int cpt=0;
    bool found=false;
    
    if (mfirst==NULL) {
        return NULL;
    }
    
    Sprite *current = (Sprite*)mfirst;
    do {
        if (current->bRealEnemy && current->dead_==0) {
            cpt++;
        } 
        if (cpt==number) {
            found=true;
        }
        if (!found)
            current = (Sprite*)current->GetNext();
    } while ((current!=NULL) && !found);
    // printf("  Fin ListSprite::cleanList()\n");
    
    
    
    if (!found) return NULL;
    
    return current;
}
