//go:build ignore
// +build ignore

package main

import (
	"bytes"
	"compress/gzip"
	"flag"
	"html/template"
	"io"
	"os"
	"path/filepath"

	"github.com/pkg/errors"
)

// saves baseimage binaries statically into go code
func main() {
	flag.Parse()
	if len(flag.Args()) == 0 {
		panic(errors.New("arch is required"))
	}

	for _, farch := range flag.Args() {
		dir := filepath.Dir(farch)
		arch := filepath.Base(farch)

		f, err := os.Open(farch)
		if err != nil {
			panic(err)
		}
		defer f.Close()
		buf := &bytes.Buffer{}

		gz, err := gzip.NewWriterLevel(newHexStringWriter(buf), gzip.BestCompression)
		if err != nil {
			panic(err)
		}
		if _, err = io.Copy(gz, f); err != nil {
			panic(err)
		}
		if err := gz.Close(); err != nil {
			panic(err)
		}
		fn := filepath.Join(dir, arch+"_binary.go")
		dest, err := os.OpenFile(fn, os.O_WRONLY|os.O_CREATE|os.O_TRUNC, 0600)
		if err != nil {
			panic(err)
		}
		if err := tmpl.Execute(dest, struct{ Arch, Package, Data string }{Arch: arch, Package: "archutil", Data: buf.String()}); err != nil {
			panic(err)
		}
		dest.Close()
	}

}

type hexStringWriter struct {
	w io.Writer
}

func newHexStringWriter(w io.Writer) io.Writer {
	return &hexStringWriter{w: w}
}

func (w *hexStringWriter) Write(d []byte) (int, error) {
	const hextable = "0123456789abcdef"
	b := make([]byte, len(d)*4)
	for i, v := range d {
		b[i*4] = '\\'
		b[i*4+1] = 'x'
		b[i*4+2] = hextable[v>>4]
		b[i*4+3] = hextable[v&0x0f]
	}
	for {
		n, err := w.w.Write(b)
		if err == io.ErrShortWrite {
			b = b[n:]
			continue
		}
		return len(d), err
	}
}

var tmpl = template.Must(template.New("pause").Parse(`//go:build !{{.Arch}}
// +build !{{.Arch}}

package {{.Package}}

// This file is generated by running "make archutil".
// Do not edit manually.

const Binary{{.Arch}} = "{{.Data}}"
`))
