// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

package model

// Code generated by github.com/tinylib/msgp DO NOT EDIT.

import (
	"github.com/tinylib/msgp/msgp"
)

// DecodeMsg implements msgp.Decodable
func (z *Session) DecodeMsg(dc *msgp.Reader) (err error) {
	var zb0001 uint32
	zb0001, err = dc.ReadArrayHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0001 != 13 {
		err = msgp.ArrayError{Wanted: 13, Got: zb0001}
		return
	}
	z.Id, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "Id")
		return
	}
	z.Token, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "Token")
		return
	}
	z.CreateAt, err = dc.ReadInt64()
	if err != nil {
		err = msgp.WrapError(err, "CreateAt")
		return
	}
	z.ExpiresAt, err = dc.ReadInt64()
	if err != nil {
		err = msgp.WrapError(err, "ExpiresAt")
		return
	}
	z.LastActivityAt, err = dc.ReadInt64()
	if err != nil {
		err = msgp.WrapError(err, "LastActivityAt")
		return
	}
	z.UserId, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "UserId")
		return
	}
	z.DeviceId, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "DeviceId")
		return
	}
	z.Roles, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "Roles")
		return
	}
	z.IsOAuth, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "IsOAuth")
		return
	}
	z.ExpiredNotify, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "ExpiredNotify")
		return
	}
	var zb0002 uint32
	zb0002, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err, "Props")
		return
	}
	if z.Props == nil {
		z.Props = make(StringMap, zb0002)
	} else if len(z.Props) > 0 {
		for key := range z.Props {
			delete(z.Props, key)
		}
	}
	for zb0002 > 0 {
		zb0002--
		var za0001 string
		var za0002 string
		za0001, err = dc.ReadString()
		if err != nil {
			err = msgp.WrapError(err, "Props")
			return
		}
		za0002, err = dc.ReadString()
		if err != nil {
			err = msgp.WrapError(err, "Props", za0001)
			return
		}
		z.Props[za0001] = za0002
	}
	var zb0003 uint32
	zb0003, err = dc.ReadArrayHeader()
	if err != nil {
		err = msgp.WrapError(err, "TeamMembers")
		return
	}
	if cap(z.TeamMembers) >= int(zb0003) {
		z.TeamMembers = (z.TeamMembers)[:zb0003]
	} else {
		z.TeamMembers = make([]*TeamMember, zb0003)
	}
	for za0003 := range z.TeamMembers {
		if dc.IsNil() {
			err = dc.ReadNil()
			if err != nil {
				err = msgp.WrapError(err, "TeamMembers", za0003)
				return
			}
			z.TeamMembers[za0003] = nil
		} else {
			if z.TeamMembers[za0003] == nil {
				z.TeamMembers[za0003] = new(TeamMember)
			}
			err = z.TeamMembers[za0003].DecodeMsg(dc)
			if err != nil {
				err = msgp.WrapError(err, "TeamMembers", za0003)
				return
			}
		}
	}
	z.Local, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "Local")
		return
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *Session) EncodeMsg(en *msgp.Writer) (err error) {
	// array header, size 13
	err = en.Append(0x9d)
	if err != nil {
		return
	}
	err = en.WriteString(z.Id)
	if err != nil {
		err = msgp.WrapError(err, "Id")
		return
	}
	err = en.WriteString(z.Token)
	if err != nil {
		err = msgp.WrapError(err, "Token")
		return
	}
	err = en.WriteInt64(z.CreateAt)
	if err != nil {
		err = msgp.WrapError(err, "CreateAt")
		return
	}
	err = en.WriteInt64(z.ExpiresAt)
	if err != nil {
		err = msgp.WrapError(err, "ExpiresAt")
		return
	}
	err = en.WriteInt64(z.LastActivityAt)
	if err != nil {
		err = msgp.WrapError(err, "LastActivityAt")
		return
	}
	err = en.WriteString(z.UserId)
	if err != nil {
		err = msgp.WrapError(err, "UserId")
		return
	}
	err = en.WriteString(z.DeviceId)
	if err != nil {
		err = msgp.WrapError(err, "DeviceId")
		return
	}
	err = en.WriteString(z.Roles)
	if err != nil {
		err = msgp.WrapError(err, "Roles")
		return
	}
	err = en.WriteBool(z.IsOAuth)
	if err != nil {
		err = msgp.WrapError(err, "IsOAuth")
		return
	}
	err = en.WriteBool(z.ExpiredNotify)
	if err != nil {
		err = msgp.WrapError(err, "ExpiredNotify")
		return
	}
	err = en.WriteMapHeader(uint32(len(z.Props)))
	if err != nil {
		err = msgp.WrapError(err, "Props")
		return
	}
	for za0001, za0002 := range z.Props {
		err = en.WriteString(za0001)
		if err != nil {
			err = msgp.WrapError(err, "Props")
			return
		}
		err = en.WriteString(za0002)
		if err != nil {
			err = msgp.WrapError(err, "Props", za0001)
			return
		}
	}
	err = en.WriteArrayHeader(uint32(len(z.TeamMembers)))
	if err != nil {
		err = msgp.WrapError(err, "TeamMembers")
		return
	}
	for za0003 := range z.TeamMembers {
		if z.TeamMembers[za0003] == nil {
			err = en.WriteNil()
			if err != nil {
				return
			}
		} else {
			err = z.TeamMembers[za0003].EncodeMsg(en)
			if err != nil {
				err = msgp.WrapError(err, "TeamMembers", za0003)
				return
			}
		}
	}
	err = en.WriteBool(z.Local)
	if err != nil {
		err = msgp.WrapError(err, "Local")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *Session) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// array header, size 13
	o = append(o, 0x9d)
	o = msgp.AppendString(o, z.Id)
	o = msgp.AppendString(o, z.Token)
	o = msgp.AppendInt64(o, z.CreateAt)
	o = msgp.AppendInt64(o, z.ExpiresAt)
	o = msgp.AppendInt64(o, z.LastActivityAt)
	o = msgp.AppendString(o, z.UserId)
	o = msgp.AppendString(o, z.DeviceId)
	o = msgp.AppendString(o, z.Roles)
	o = msgp.AppendBool(o, z.IsOAuth)
	o = msgp.AppendBool(o, z.ExpiredNotify)
	o = msgp.AppendMapHeader(o, uint32(len(z.Props)))
	for za0001, za0002 := range z.Props {
		o = msgp.AppendString(o, za0001)
		o = msgp.AppendString(o, za0002)
	}
	o = msgp.AppendArrayHeader(o, uint32(len(z.TeamMembers)))
	for za0003 := range z.TeamMembers {
		if z.TeamMembers[za0003] == nil {
			o = msgp.AppendNil(o)
		} else {
			o, err = z.TeamMembers[za0003].MarshalMsg(o)
			if err != nil {
				err = msgp.WrapError(err, "TeamMembers", za0003)
				return
			}
		}
	}
	o = msgp.AppendBool(o, z.Local)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Session) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadArrayHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0001 != 13 {
		err = msgp.ArrayError{Wanted: 13, Got: zb0001}
		return
	}
	z.Id, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Id")
		return
	}
	z.Token, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Token")
		return
	}
	z.CreateAt, bts, err = msgp.ReadInt64Bytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "CreateAt")
		return
	}
	z.ExpiresAt, bts, err = msgp.ReadInt64Bytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "ExpiresAt")
		return
	}
	z.LastActivityAt, bts, err = msgp.ReadInt64Bytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "LastActivityAt")
		return
	}
	z.UserId, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "UserId")
		return
	}
	z.DeviceId, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "DeviceId")
		return
	}
	z.Roles, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Roles")
		return
	}
	z.IsOAuth, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "IsOAuth")
		return
	}
	z.ExpiredNotify, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "ExpiredNotify")
		return
	}
	var zb0002 uint32
	zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Props")
		return
	}
	if z.Props == nil {
		z.Props = make(StringMap, zb0002)
	} else if len(z.Props) > 0 {
		for key := range z.Props {
			delete(z.Props, key)
		}
	}
	for zb0002 > 0 {
		var za0001 string
		var za0002 string
		zb0002--
		za0001, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err, "Props")
			return
		}
		za0002, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err, "Props", za0001)
			return
		}
		z.Props[za0001] = za0002
	}
	var zb0003 uint32
	zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "TeamMembers")
		return
	}
	if cap(z.TeamMembers) >= int(zb0003) {
		z.TeamMembers = (z.TeamMembers)[:zb0003]
	} else {
		z.TeamMembers = make([]*TeamMember, zb0003)
	}
	for za0003 := range z.TeamMembers {
		if msgp.IsNil(bts) {
			bts, err = msgp.ReadNilBytes(bts)
			if err != nil {
				return
			}
			z.TeamMembers[za0003] = nil
		} else {
			if z.TeamMembers[za0003] == nil {
				z.TeamMembers[za0003] = new(TeamMember)
			}
			bts, err = z.TeamMembers[za0003].UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "TeamMembers", za0003)
				return
			}
		}
	}
	z.Local, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Local")
		return
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Session) Msgsize() (s int) {
	s = 1 + msgp.StringPrefixSize + len(z.Id) + msgp.StringPrefixSize + len(z.Token) + msgp.Int64Size + msgp.Int64Size + msgp.Int64Size + msgp.StringPrefixSize + len(z.UserId) + msgp.StringPrefixSize + len(z.DeviceId) + msgp.StringPrefixSize + len(z.Roles) + msgp.BoolSize + msgp.BoolSize + msgp.MapHeaderSize
	if z.Props != nil {
		for za0001, za0002 := range z.Props {
			_ = za0002
			s += msgp.StringPrefixSize + len(za0001) + msgp.StringPrefixSize + len(za0002)
		}
	}
	s += msgp.ArrayHeaderSize
	for za0003 := range z.TeamMembers {
		if z.TeamMembers[za0003] == nil {
			s += msgp.NilSize
		} else {
			s += z.TeamMembers[za0003].Msgsize()
		}
	}
	s += msgp.BoolSize
	return
}

// DecodeMsg implements msgp.Decodable
func (z *StringMap) DecodeMsg(dc *msgp.Reader) (err error) {
	var zb0003 uint32
	zb0003, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if (*z) == nil {
		(*z) = make(StringMap, zb0003)
	} else if len((*z)) > 0 {
		for key := range *z {
			delete((*z), key)
		}
	}
	for zb0003 > 0 {
		zb0003--
		var zb0001 string
		var zb0002 string
		zb0001, err = dc.ReadString()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		zb0002, err = dc.ReadString()
		if err != nil {
			err = msgp.WrapError(err, zb0001)
			return
		}
		(*z)[zb0001] = zb0002
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z StringMap) EncodeMsg(en *msgp.Writer) (err error) {
	err = en.WriteMapHeader(uint32(len(z)))
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0004, zb0005 := range z {
		err = en.WriteString(zb0004)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		err = en.WriteString(zb0005)
		if err != nil {
			err = msgp.WrapError(err, zb0004)
			return
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z StringMap) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendMapHeader(o, uint32(len(z)))
	for zb0004, zb0005 := range z {
		o = msgp.AppendString(o, zb0004)
		o = msgp.AppendString(o, zb0005)
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *StringMap) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var zb0003 uint32
	zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if (*z) == nil {
		(*z) = make(StringMap, zb0003)
	} else if len((*z)) > 0 {
		for key := range *z {
			delete((*z), key)
		}
	}
	for zb0003 > 0 {
		var zb0001 string
		var zb0002 string
		zb0003--
		zb0001, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		zb0002, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err, zb0001)
			return
		}
		(*z)[zb0001] = zb0002
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z StringMap) Msgsize() (s int) {
	s = msgp.MapHeaderSize
	if z != nil {
		for zb0004, zb0005 := range z {
			_ = zb0005
			s += msgp.StringPrefixSize + len(zb0004) + msgp.StringPrefixSize + len(zb0005)
		}
	}
	return
}
