// This file is generated by "./lib/proto/generate"

package proto

/*

DeviceAccess

*/

// DeviceAccessRequestID Device request id.
type DeviceAccessRequestID string

// DeviceAccessDeviceID A device id.
type DeviceAccessDeviceID string

// DeviceAccessPromptDevice Device information displayed in a user prompt to select a device.
type DeviceAccessPromptDevice struct {
	// ID ...
	ID DeviceAccessDeviceID `json:"id"`

	// Name Display name as it appears in a device request user prompt.
	Name string `json:"name"`
}

// DeviceAccessEnable Enable events in this domain.
type DeviceAccessEnable struct{}

// ProtoReq name.
func (m DeviceAccessEnable) ProtoReq() string { return "DeviceAccess.enable" }

// Call sends the request.
func (m DeviceAccessEnable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DeviceAccessDisable Disable events in this domain.
type DeviceAccessDisable struct{}

// ProtoReq name.
func (m DeviceAccessDisable) ProtoReq() string { return "DeviceAccess.disable" }

// Call sends the request.
func (m DeviceAccessDisable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DeviceAccessSelectPrompt Select a device in response to a DeviceAccess.deviceRequestPrompted event.
type DeviceAccessSelectPrompt struct {
	// ID ...
	ID DeviceAccessRequestID `json:"id"`

	// DeviceID ...
	DeviceID DeviceAccessDeviceID `json:"deviceId"`
}

// ProtoReq name.
func (m DeviceAccessSelectPrompt) ProtoReq() string { return "DeviceAccess.selectPrompt" }

// Call sends the request.
func (m DeviceAccessSelectPrompt) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DeviceAccessCancelPrompt Cancel a prompt in response to a DeviceAccess.deviceRequestPrompted event.
type DeviceAccessCancelPrompt struct {
	// ID ...
	ID DeviceAccessRequestID `json:"id"`
}

// ProtoReq name.
func (m DeviceAccessCancelPrompt) ProtoReq() string { return "DeviceAccess.cancelPrompt" }

// Call sends the request.
func (m DeviceAccessCancelPrompt) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DeviceAccessDeviceRequestPrompted A device request opened a user prompt to select a device. Respond with the
// selectPrompt or cancelPrompt command.
type DeviceAccessDeviceRequestPrompted struct {
	// ID ...
	ID DeviceAccessRequestID `json:"id"`

	// Devices ...
	Devices []*DeviceAccessPromptDevice `json:"devices"`
}

// ProtoEvent name.
func (evt DeviceAccessDeviceRequestPrompted) ProtoEvent() string {
	return "DeviceAccess.deviceRequestPrompted"
}
