// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transfer

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
)

// WaitUntilServerOffline uses the AWS Transfer API operation
// DescribeServer to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Transfer) WaitUntilServerOffline(input *DescribeServerInput) error {
	return c.WaitUntilServerOfflineWithContext(aws.BackgroundContext(), input)
}

// WaitUntilServerOfflineWithContext is an extended version of WaitUntilServerOffline.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) WaitUntilServerOfflineWithContext(ctx aws.Context, input *DescribeServerInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilServerOffline",
		MaxAttempts: 120,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "Server.State",
				Expected: "OFFLINE",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "Server.State",
				Expected: "STOP_FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeServerInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeServerRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilServerOnline uses the AWS Transfer API operation
// DescribeServer to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Transfer) WaitUntilServerOnline(input *DescribeServerInput) error {
	return c.WaitUntilServerOnlineWithContext(aws.BackgroundContext(), input)
}

// WaitUntilServerOnlineWithContext is an extended version of WaitUntilServerOnline.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) WaitUntilServerOnlineWithContext(ctx aws.Context, input *DescribeServerInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilServerOnline",
		MaxAttempts: 120,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "Server.State",
				Expected: "ONLINE",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "Server.State",
				Expected: "START_FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeServerInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeServerRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}
