// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package resiliencehub

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddDraftAppVersionResourceMappings = "AddDraftAppVersionResourceMappings"

// AddDraftAppVersionResourceMappingsRequest generates a "aws/request.Request" representing the
// client's request for the AddDraftAppVersionResourceMappings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddDraftAppVersionResourceMappings for more information on using the AddDraftAppVersionResourceMappings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddDraftAppVersionResourceMappingsRequest method.
//	req, resp := client.AddDraftAppVersionResourceMappingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/AddDraftAppVersionResourceMappings
func (c *ResilienceHub) AddDraftAppVersionResourceMappingsRequest(input *AddDraftAppVersionResourceMappingsInput) (req *request.Request, output *AddDraftAppVersionResourceMappingsOutput) {
	op := &request.Operation{
		Name:       opAddDraftAppVersionResourceMappings,
		HTTPMethod: "POST",
		HTTPPath:   "/add-draft-app-version-resource-mappings",
	}

	if input == nil {
		input = &AddDraftAppVersionResourceMappingsInput{}
	}

	output = &AddDraftAppVersionResourceMappingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddDraftAppVersionResourceMappings API operation for AWS Resilience Hub.
//
// Adds the source of resource-maps to the draft version of an application.
// During assessment, Resilience Hub will use these resource-maps to resolve
// the latest physical ID for each resource in the application template. For
// more information about different types of resources suported by Resilience
// Hub and how to add them in your application, see Step 2: How is your application
// managed? (https://docs.aws.amazon.com/resilience-hub/latest/userguide/how-app-manage.html)
// in the Resilience Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation AddDraftAppVersionResourceMappings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/AddDraftAppVersionResourceMappings
func (c *ResilienceHub) AddDraftAppVersionResourceMappings(input *AddDraftAppVersionResourceMappingsInput) (*AddDraftAppVersionResourceMappingsOutput, error) {
	req, out := c.AddDraftAppVersionResourceMappingsRequest(input)
	return out, req.Send()
}

// AddDraftAppVersionResourceMappingsWithContext is the same as AddDraftAppVersionResourceMappings with the addition of
// the ability to pass a context and additional request options.
//
// See AddDraftAppVersionResourceMappings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) AddDraftAppVersionResourceMappingsWithContext(ctx aws.Context, input *AddDraftAppVersionResourceMappingsInput, opts ...request.Option) (*AddDraftAppVersionResourceMappingsOutput, error) {
	req, out := c.AddDraftAppVersionResourceMappingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateRecommendationStatus = "BatchUpdateRecommendationStatus"

// BatchUpdateRecommendationStatusRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateRecommendationStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateRecommendationStatus for more information on using the BatchUpdateRecommendationStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdateRecommendationStatusRequest method.
//	req, resp := client.BatchUpdateRecommendationStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/BatchUpdateRecommendationStatus
func (c *ResilienceHub) BatchUpdateRecommendationStatusRequest(input *BatchUpdateRecommendationStatusInput) (req *request.Request, output *BatchUpdateRecommendationStatusOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateRecommendationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/batch-update-recommendation-status",
	}

	if input == nil {
		input = &BatchUpdateRecommendationStatusInput{}
	}

	output = &BatchUpdateRecommendationStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateRecommendationStatus API operation for AWS Resilience Hub.
//
// Enables you to include or exclude one or more operational recommendations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation BatchUpdateRecommendationStatus for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/BatchUpdateRecommendationStatus
func (c *ResilienceHub) BatchUpdateRecommendationStatus(input *BatchUpdateRecommendationStatusInput) (*BatchUpdateRecommendationStatusOutput, error) {
	req, out := c.BatchUpdateRecommendationStatusRequest(input)
	return out, req.Send()
}

// BatchUpdateRecommendationStatusWithContext is the same as BatchUpdateRecommendationStatus with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateRecommendationStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) BatchUpdateRecommendationStatusWithContext(ctx aws.Context, input *BatchUpdateRecommendationStatusInput, opts ...request.Option) (*BatchUpdateRecommendationStatusOutput, error) {
	req, out := c.BatchUpdateRecommendationStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApp = "CreateApp"

// CreateAppRequest generates a "aws/request.Request" representing the
// client's request for the CreateApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApp for more information on using the CreateApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAppRequest method.
//	req, resp := client.CreateAppRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateApp
func (c *ResilienceHub) CreateAppRequest(input *CreateAppInput) (req *request.Request, output *CreateAppOutput) {
	op := &request.Operation{
		Name:       opCreateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/create-app",
	}

	if input == nil {
		input = &CreateAppInput{}
	}

	output = &CreateAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApp API operation for AWS Resilience Hub.
//
// Creates an Resilience Hub application. An Resilience Hub application is a
// collection of Amazon Web Services resources structured to prevent and recover
// Amazon Web Services application disruptions. To describe a Resilience Hub
// application, you provide an application name, resources from one or more
// CloudFormation stacks, Resource Groups, Terraform state files, AppRegistry
// applications, and an appropriate resiliency policy. In addition, you can
// also add resources that are located on Amazon Elastic Kubernetes Service
// (Amazon EKS) clusters as optional resources. For more information about the
// number of resources supported per application, see Service quotas (https://docs.aws.amazon.com/general/latest/gr/resiliencehub.html#limits_resiliencehub).
//
// After you create an Resilience Hub application, you publish it so that you
// can run a resiliency assessment on it. You can then use recommendations from
// the assessment to improve resiliency by running another assessment, comparing
// results, and then iterating the process until you achieve your goals for
// recovery time objective (RTO) and recovery point objective (RPO).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation CreateApp for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ServiceQuotaExceededException
//     This exception occurs when you have exceeded your service quota. To perform
//     the requested action, remove some of the relevant resources, or use Service
//     Quotas to request a service quota increase.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateApp
func (c *ResilienceHub) CreateApp(input *CreateAppInput) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	return out, req.Send()
}

// CreateAppWithContext is the same as CreateApp with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) CreateAppWithContext(ctx aws.Context, input *CreateAppInput, opts ...request.Option) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAppVersionAppComponent = "CreateAppVersionAppComponent"

// CreateAppVersionAppComponentRequest generates a "aws/request.Request" representing the
// client's request for the CreateAppVersionAppComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAppVersionAppComponent for more information on using the CreateAppVersionAppComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAppVersionAppComponentRequest method.
//	req, resp := client.CreateAppVersionAppComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateAppVersionAppComponent
func (c *ResilienceHub) CreateAppVersionAppComponentRequest(input *CreateAppVersionAppComponentInput) (req *request.Request, output *CreateAppVersionAppComponentOutput) {
	op := &request.Operation{
		Name:       opCreateAppVersionAppComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/create-app-version-app-component",
	}

	if input == nil {
		input = &CreateAppVersionAppComponentInput{}
	}

	output = &CreateAppVersionAppComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAppVersionAppComponent API operation for AWS Resilience Hub.
//
// Creates a new Application Component in the Resilience Hub application.
//
// This API updates the Resilience Hub application draft version. To use this
// Application Component for running assessments, you must publish the Resilience
// Hub application using the PublishAppVersion API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation CreateAppVersionAppComponent for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ServiceQuotaExceededException
//     This exception occurs when you have exceeded your service quota. To perform
//     the requested action, remove some of the relevant resources, or use Service
//     Quotas to request a service quota increase.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateAppVersionAppComponent
func (c *ResilienceHub) CreateAppVersionAppComponent(input *CreateAppVersionAppComponentInput) (*CreateAppVersionAppComponentOutput, error) {
	req, out := c.CreateAppVersionAppComponentRequest(input)
	return out, req.Send()
}

// CreateAppVersionAppComponentWithContext is the same as CreateAppVersionAppComponent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAppVersionAppComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) CreateAppVersionAppComponentWithContext(ctx aws.Context, input *CreateAppVersionAppComponentInput, opts ...request.Option) (*CreateAppVersionAppComponentOutput, error) {
	req, out := c.CreateAppVersionAppComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAppVersionResource = "CreateAppVersionResource"

// CreateAppVersionResourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateAppVersionResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAppVersionResource for more information on using the CreateAppVersionResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAppVersionResourceRequest method.
//	req, resp := client.CreateAppVersionResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateAppVersionResource
func (c *ResilienceHub) CreateAppVersionResourceRequest(input *CreateAppVersionResourceInput) (req *request.Request, output *CreateAppVersionResourceOutput) {
	op := &request.Operation{
		Name:       opCreateAppVersionResource,
		HTTPMethod: "POST",
		HTTPPath:   "/create-app-version-resource",
	}

	if input == nil {
		input = &CreateAppVersionResourceInput{}
	}

	output = &CreateAppVersionResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAppVersionResource API operation for AWS Resilience Hub.
//
// Adds a resource to the Resilience Hub application and assigns it to the specified
// Application Components. If you specify a new Application Component, Resilience
// Hub will automatically create the Application Component.
//
//   - This action has no effect outside Resilience Hub.
//
//   - This API updates the Resilience Hub application draft version. To use
//     this resource for running resiliency assessments, you must publish the
//     Resilience Hub application using the PublishAppVersion API.
//
//   - To update application version with new physicalResourceID, you must
//     call ResolveAppVersionResources API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation CreateAppVersionResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ServiceQuotaExceededException
//     This exception occurs when you have exceeded your service quota. To perform
//     the requested action, remove some of the relevant resources, or use Service
//     Quotas to request a service quota increase.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateAppVersionResource
func (c *ResilienceHub) CreateAppVersionResource(input *CreateAppVersionResourceInput) (*CreateAppVersionResourceOutput, error) {
	req, out := c.CreateAppVersionResourceRequest(input)
	return out, req.Send()
}

// CreateAppVersionResourceWithContext is the same as CreateAppVersionResource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAppVersionResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) CreateAppVersionResourceWithContext(ctx aws.Context, input *CreateAppVersionResourceInput, opts ...request.Option) (*CreateAppVersionResourceOutput, error) {
	req, out := c.CreateAppVersionResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRecommendationTemplate = "CreateRecommendationTemplate"

// CreateRecommendationTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateRecommendationTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRecommendationTemplate for more information on using the CreateRecommendationTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRecommendationTemplateRequest method.
//	req, resp := client.CreateRecommendationTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateRecommendationTemplate
func (c *ResilienceHub) CreateRecommendationTemplateRequest(input *CreateRecommendationTemplateInput) (req *request.Request, output *CreateRecommendationTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateRecommendationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/create-recommendation-template",
	}

	if input == nil {
		input = &CreateRecommendationTemplateInput{}
	}

	output = &CreateRecommendationTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRecommendationTemplate API operation for AWS Resilience Hub.
//
// Creates a new recommendation template for the Resilience Hub application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation CreateRecommendationTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ServiceQuotaExceededException
//     This exception occurs when you have exceeded your service quota. To perform
//     the requested action, remove some of the relevant resources, or use Service
//     Quotas to request a service quota increase.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateRecommendationTemplate
func (c *ResilienceHub) CreateRecommendationTemplate(input *CreateRecommendationTemplateInput) (*CreateRecommendationTemplateOutput, error) {
	req, out := c.CreateRecommendationTemplateRequest(input)
	return out, req.Send()
}

// CreateRecommendationTemplateWithContext is the same as CreateRecommendationTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRecommendationTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) CreateRecommendationTemplateWithContext(ctx aws.Context, input *CreateRecommendationTemplateInput, opts ...request.Option) (*CreateRecommendationTemplateOutput, error) {
	req, out := c.CreateRecommendationTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResiliencyPolicy = "CreateResiliencyPolicy"

// CreateResiliencyPolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateResiliencyPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResiliencyPolicy for more information on using the CreateResiliencyPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateResiliencyPolicyRequest method.
//	req, resp := client.CreateResiliencyPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateResiliencyPolicy
func (c *ResilienceHub) CreateResiliencyPolicyRequest(input *CreateResiliencyPolicyInput) (req *request.Request, output *CreateResiliencyPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateResiliencyPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/create-resiliency-policy",
	}

	if input == nil {
		input = &CreateResiliencyPolicyInput{}
	}

	output = &CreateResiliencyPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResiliencyPolicy API operation for AWS Resilience Hub.
//
// Creates a resiliency policy for an application.
//
// Resilience Hub allows you to provide a value of zero for rtoInSecs and rpoInSecs
// of your resiliency policy. But, while assessing your application, the lowest
// possible assessment result is near zero. Hence, if you provide value zero
// for rtoInSecs and rpoInSecs, the estimated workload RTO and estimated workload
// RPO result will be near zero and the Compliance status for your application
// will be set to Policy breached.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation CreateResiliencyPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ServiceQuotaExceededException
//     This exception occurs when you have exceeded your service quota. To perform
//     the requested action, remove some of the relevant resources, or use Service
//     Quotas to request a service quota increase.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateResiliencyPolicy
func (c *ResilienceHub) CreateResiliencyPolicy(input *CreateResiliencyPolicyInput) (*CreateResiliencyPolicyOutput, error) {
	req, out := c.CreateResiliencyPolicyRequest(input)
	return out, req.Send()
}

// CreateResiliencyPolicyWithContext is the same as CreateResiliencyPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResiliencyPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) CreateResiliencyPolicyWithContext(ctx aws.Context, input *CreateResiliencyPolicyInput, opts ...request.Option) (*CreateResiliencyPolicyOutput, error) {
	req, out := c.CreateResiliencyPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApp = "DeleteApp"

// DeleteAppRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApp for more information on using the DeleteApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppRequest method.
//	req, resp := client.DeleteAppRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteApp
func (c *ResilienceHub) DeleteAppRequest(input *DeleteAppInput) (req *request.Request, output *DeleteAppOutput) {
	op := &request.Operation{
		Name:       opDeleteApp,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-app",
	}

	if input == nil {
		input = &DeleteAppInput{}
	}

	output = &DeleteAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApp API operation for AWS Resilience Hub.
//
// Deletes an Resilience Hub application. This is a destructive action that
// can't be undone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation DeleteApp for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteApp
func (c *ResilienceHub) DeleteApp(input *DeleteAppInput) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	return out, req.Send()
}

// DeleteAppWithContext is the same as DeleteApp with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) DeleteAppWithContext(ctx aws.Context, input *DeleteAppInput, opts ...request.Option) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppAssessment = "DeleteAppAssessment"

// DeleteAppAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppAssessment for more information on using the DeleteAppAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppAssessmentRequest method.
//	req, resp := client.DeleteAppAssessmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppAssessment
func (c *ResilienceHub) DeleteAppAssessmentRequest(input *DeleteAppAssessmentInput) (req *request.Request, output *DeleteAppAssessmentOutput) {
	op := &request.Operation{
		Name:       opDeleteAppAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-app-assessment",
	}

	if input == nil {
		input = &DeleteAppAssessmentInput{}
	}

	output = &DeleteAppAssessmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAppAssessment API operation for AWS Resilience Hub.
//
// Deletes an Resilience Hub application assessment. This is a destructive action
// that can't be undone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation DeleteAppAssessment for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppAssessment
func (c *ResilienceHub) DeleteAppAssessment(input *DeleteAppAssessmentInput) (*DeleteAppAssessmentOutput, error) {
	req, out := c.DeleteAppAssessmentRequest(input)
	return out, req.Send()
}

// DeleteAppAssessmentWithContext is the same as DeleteAppAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) DeleteAppAssessmentWithContext(ctx aws.Context, input *DeleteAppAssessmentInput, opts ...request.Option) (*DeleteAppAssessmentOutput, error) {
	req, out := c.DeleteAppAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppInputSource = "DeleteAppInputSource"

// DeleteAppInputSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppInputSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppInputSource for more information on using the DeleteAppInputSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppInputSourceRequest method.
//	req, resp := client.DeleteAppInputSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppInputSource
func (c *ResilienceHub) DeleteAppInputSourceRequest(input *DeleteAppInputSourceInput) (req *request.Request, output *DeleteAppInputSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteAppInputSource,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-app-input-source",
	}

	if input == nil {
		input = &DeleteAppInputSourceInput{}
	}

	output = &DeleteAppInputSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAppInputSource API operation for AWS Resilience Hub.
//
// Deletes the input source and all of its imported resources from the Resilience
// Hub application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation DeleteAppInputSource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppInputSource
func (c *ResilienceHub) DeleteAppInputSource(input *DeleteAppInputSourceInput) (*DeleteAppInputSourceOutput, error) {
	req, out := c.DeleteAppInputSourceRequest(input)
	return out, req.Send()
}

// DeleteAppInputSourceWithContext is the same as DeleteAppInputSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppInputSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) DeleteAppInputSourceWithContext(ctx aws.Context, input *DeleteAppInputSourceInput, opts ...request.Option) (*DeleteAppInputSourceOutput, error) {
	req, out := c.DeleteAppInputSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppVersionAppComponent = "DeleteAppVersionAppComponent"

// DeleteAppVersionAppComponentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppVersionAppComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppVersionAppComponent for more information on using the DeleteAppVersionAppComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppVersionAppComponentRequest method.
//	req, resp := client.DeleteAppVersionAppComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppVersionAppComponent
func (c *ResilienceHub) DeleteAppVersionAppComponentRequest(input *DeleteAppVersionAppComponentInput) (req *request.Request, output *DeleteAppVersionAppComponentOutput) {
	op := &request.Operation{
		Name:       opDeleteAppVersionAppComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-app-version-app-component",
	}

	if input == nil {
		input = &DeleteAppVersionAppComponentInput{}
	}

	output = &DeleteAppVersionAppComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAppVersionAppComponent API operation for AWS Resilience Hub.
//
// Deletes an Application Component from the Resilience Hub application.
//
//   - This API updates the Resilience Hub application draft version. To use
//     this Application Component for running assessments, you must publish the
//     Resilience Hub application using the PublishAppVersion API.
//
//   - You will not be able to delete an Application Component if it has resources
//     associated with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation DeleteAppVersionAppComponent for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppVersionAppComponent
func (c *ResilienceHub) DeleteAppVersionAppComponent(input *DeleteAppVersionAppComponentInput) (*DeleteAppVersionAppComponentOutput, error) {
	req, out := c.DeleteAppVersionAppComponentRequest(input)
	return out, req.Send()
}

// DeleteAppVersionAppComponentWithContext is the same as DeleteAppVersionAppComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppVersionAppComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) DeleteAppVersionAppComponentWithContext(ctx aws.Context, input *DeleteAppVersionAppComponentInput, opts ...request.Option) (*DeleteAppVersionAppComponentOutput, error) {
	req, out := c.DeleteAppVersionAppComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppVersionResource = "DeleteAppVersionResource"

// DeleteAppVersionResourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppVersionResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppVersionResource for more information on using the DeleteAppVersionResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppVersionResourceRequest method.
//	req, resp := client.DeleteAppVersionResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppVersionResource
func (c *ResilienceHub) DeleteAppVersionResourceRequest(input *DeleteAppVersionResourceInput) (req *request.Request, output *DeleteAppVersionResourceOutput) {
	op := &request.Operation{
		Name:       opDeleteAppVersionResource,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-app-version-resource",
	}

	if input == nil {
		input = &DeleteAppVersionResourceInput{}
	}

	output = &DeleteAppVersionResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAppVersionResource API operation for AWS Resilience Hub.
//
// Deletes a resource from the Resilience Hub application.
//
//   - You can only delete a manually added resource. To exclude non-manually
//     added resources, use the UpdateAppVersionResource API.
//
//   - This action has no effect outside Resilience Hub.
//
//   - This API updates the Resilience Hub application draft version. To use
//     this resource for running resiliency assessments, you must publish the
//     Resilience Hub application using the PublishAppVersion API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation DeleteAppVersionResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppVersionResource
func (c *ResilienceHub) DeleteAppVersionResource(input *DeleteAppVersionResourceInput) (*DeleteAppVersionResourceOutput, error) {
	req, out := c.DeleteAppVersionResourceRequest(input)
	return out, req.Send()
}

// DeleteAppVersionResourceWithContext is the same as DeleteAppVersionResource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppVersionResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) DeleteAppVersionResourceWithContext(ctx aws.Context, input *DeleteAppVersionResourceInput, opts ...request.Option) (*DeleteAppVersionResourceOutput, error) {
	req, out := c.DeleteAppVersionResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRecommendationTemplate = "DeleteRecommendationTemplate"

// DeleteRecommendationTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRecommendationTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRecommendationTemplate for more information on using the DeleteRecommendationTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRecommendationTemplateRequest method.
//	req, resp := client.DeleteRecommendationTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteRecommendationTemplate
func (c *ResilienceHub) DeleteRecommendationTemplateRequest(input *DeleteRecommendationTemplateInput) (req *request.Request, output *DeleteRecommendationTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteRecommendationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-recommendation-template",
	}

	if input == nil {
		input = &DeleteRecommendationTemplateInput{}
	}

	output = &DeleteRecommendationTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRecommendationTemplate API operation for AWS Resilience Hub.
//
// Deletes a recommendation template. This is a destructive action that can't
// be undone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation DeleteRecommendationTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteRecommendationTemplate
func (c *ResilienceHub) DeleteRecommendationTemplate(input *DeleteRecommendationTemplateInput) (*DeleteRecommendationTemplateOutput, error) {
	req, out := c.DeleteRecommendationTemplateRequest(input)
	return out, req.Send()
}

// DeleteRecommendationTemplateWithContext is the same as DeleteRecommendationTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRecommendationTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) DeleteRecommendationTemplateWithContext(ctx aws.Context, input *DeleteRecommendationTemplateInput, opts ...request.Option) (*DeleteRecommendationTemplateOutput, error) {
	req, out := c.DeleteRecommendationTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResiliencyPolicy = "DeleteResiliencyPolicy"

// DeleteResiliencyPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResiliencyPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResiliencyPolicy for more information on using the DeleteResiliencyPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResiliencyPolicyRequest method.
//	req, resp := client.DeleteResiliencyPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteResiliencyPolicy
func (c *ResilienceHub) DeleteResiliencyPolicyRequest(input *DeleteResiliencyPolicyInput) (req *request.Request, output *DeleteResiliencyPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResiliencyPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-resiliency-policy",
	}

	if input == nil {
		input = &DeleteResiliencyPolicyInput{}
	}

	output = &DeleteResiliencyPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResiliencyPolicy API operation for AWS Resilience Hub.
//
// Deletes a resiliency policy. This is a destructive action that can't be undone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation DeleteResiliencyPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteResiliencyPolicy
func (c *ResilienceHub) DeleteResiliencyPolicy(input *DeleteResiliencyPolicyInput) (*DeleteResiliencyPolicyOutput, error) {
	req, out := c.DeleteResiliencyPolicyRequest(input)
	return out, req.Send()
}

// DeleteResiliencyPolicyWithContext is the same as DeleteResiliencyPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResiliencyPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) DeleteResiliencyPolicyWithContext(ctx aws.Context, input *DeleteResiliencyPolicyInput, opts ...request.Option) (*DeleteResiliencyPolicyOutput, error) {
	req, out := c.DeleteResiliencyPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApp = "DescribeApp"

// DescribeAppRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApp for more information on using the DescribeApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAppRequest method.
//	req, resp := client.DescribeAppRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeApp
func (c *ResilienceHub) DescribeAppRequest(input *DescribeAppInput) (req *request.Request, output *DescribeAppOutput) {
	op := &request.Operation{
		Name:       opDescribeApp,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-app",
	}

	if input == nil {
		input = &DescribeAppInput{}
	}

	output = &DescribeAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApp API operation for AWS Resilience Hub.
//
// Describes an Resilience Hub application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation DescribeApp for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeApp
func (c *ResilienceHub) DescribeApp(input *DescribeAppInput) (*DescribeAppOutput, error) {
	req, out := c.DescribeAppRequest(input)
	return out, req.Send()
}

// DescribeAppWithContext is the same as DescribeApp with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) DescribeAppWithContext(ctx aws.Context, input *DescribeAppInput, opts ...request.Option) (*DescribeAppOutput, error) {
	req, out := c.DescribeAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppAssessment = "DescribeAppAssessment"

// DescribeAppAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppAssessment for more information on using the DescribeAppAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAppAssessmentRequest method.
//	req, resp := client.DescribeAppAssessmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppAssessment
func (c *ResilienceHub) DescribeAppAssessmentRequest(input *DescribeAppAssessmentInput) (req *request.Request, output *DescribeAppAssessmentOutput) {
	op := &request.Operation{
		Name:       opDescribeAppAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-app-assessment",
	}

	if input == nil {
		input = &DescribeAppAssessmentInput{}
	}

	output = &DescribeAppAssessmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAppAssessment API operation for AWS Resilience Hub.
//
// Describes an assessment for an Resilience Hub application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation DescribeAppAssessment for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppAssessment
func (c *ResilienceHub) DescribeAppAssessment(input *DescribeAppAssessmentInput) (*DescribeAppAssessmentOutput, error) {
	req, out := c.DescribeAppAssessmentRequest(input)
	return out, req.Send()
}

// DescribeAppAssessmentWithContext is the same as DescribeAppAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) DescribeAppAssessmentWithContext(ctx aws.Context, input *DescribeAppAssessmentInput, opts ...request.Option) (*DescribeAppAssessmentOutput, error) {
	req, out := c.DescribeAppAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppVersion = "DescribeAppVersion"

// DescribeAppVersionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppVersion for more information on using the DescribeAppVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAppVersionRequest method.
//	req, resp := client.DescribeAppVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersion
func (c *ResilienceHub) DescribeAppVersionRequest(input *DescribeAppVersionInput) (req *request.Request, output *DescribeAppVersionOutput) {
	op := &request.Operation{
		Name:       opDescribeAppVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-app-version",
	}

	if input == nil {
		input = &DescribeAppVersionInput{}
	}

	output = &DescribeAppVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAppVersion API operation for AWS Resilience Hub.
//
// Describes the Resilience Hub application version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation DescribeAppVersion for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersion
func (c *ResilienceHub) DescribeAppVersion(input *DescribeAppVersionInput) (*DescribeAppVersionOutput, error) {
	req, out := c.DescribeAppVersionRequest(input)
	return out, req.Send()
}

// DescribeAppVersionWithContext is the same as DescribeAppVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) DescribeAppVersionWithContext(ctx aws.Context, input *DescribeAppVersionInput, opts ...request.Option) (*DescribeAppVersionOutput, error) {
	req, out := c.DescribeAppVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppVersionAppComponent = "DescribeAppVersionAppComponent"

// DescribeAppVersionAppComponentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppVersionAppComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppVersionAppComponent for more information on using the DescribeAppVersionAppComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAppVersionAppComponentRequest method.
//	req, resp := client.DescribeAppVersionAppComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionAppComponent
func (c *ResilienceHub) DescribeAppVersionAppComponentRequest(input *DescribeAppVersionAppComponentInput) (req *request.Request, output *DescribeAppVersionAppComponentOutput) {
	op := &request.Operation{
		Name:       opDescribeAppVersionAppComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-app-version-app-component",
	}

	if input == nil {
		input = &DescribeAppVersionAppComponentInput{}
	}

	output = &DescribeAppVersionAppComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAppVersionAppComponent API operation for AWS Resilience Hub.
//
// Describes an Application Component in the Resilience Hub application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation DescribeAppVersionAppComponent for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionAppComponent
func (c *ResilienceHub) DescribeAppVersionAppComponent(input *DescribeAppVersionAppComponentInput) (*DescribeAppVersionAppComponentOutput, error) {
	req, out := c.DescribeAppVersionAppComponentRequest(input)
	return out, req.Send()
}

// DescribeAppVersionAppComponentWithContext is the same as DescribeAppVersionAppComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppVersionAppComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) DescribeAppVersionAppComponentWithContext(ctx aws.Context, input *DescribeAppVersionAppComponentInput, opts ...request.Option) (*DescribeAppVersionAppComponentOutput, error) {
	req, out := c.DescribeAppVersionAppComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppVersionResource = "DescribeAppVersionResource"

// DescribeAppVersionResourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppVersionResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppVersionResource for more information on using the DescribeAppVersionResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAppVersionResourceRequest method.
//	req, resp := client.DescribeAppVersionResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionResource
func (c *ResilienceHub) DescribeAppVersionResourceRequest(input *DescribeAppVersionResourceInput) (req *request.Request, output *DescribeAppVersionResourceOutput) {
	op := &request.Operation{
		Name:       opDescribeAppVersionResource,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-app-version-resource",
	}

	if input == nil {
		input = &DescribeAppVersionResourceInput{}
	}

	output = &DescribeAppVersionResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAppVersionResource API operation for AWS Resilience Hub.
//
// Describes a resource of the Resilience Hub application.
//
// This API accepts only one of the following parameters to descibe the resource:
//
//   - resourceName
//
//   - logicalResourceId
//
//   - physicalResourceId (Along with physicalResourceId, you can also provide
//     awsAccountId, and awsRegion)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation DescribeAppVersionResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionResource
func (c *ResilienceHub) DescribeAppVersionResource(input *DescribeAppVersionResourceInput) (*DescribeAppVersionResourceOutput, error) {
	req, out := c.DescribeAppVersionResourceRequest(input)
	return out, req.Send()
}

// DescribeAppVersionResourceWithContext is the same as DescribeAppVersionResource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppVersionResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) DescribeAppVersionResourceWithContext(ctx aws.Context, input *DescribeAppVersionResourceInput, opts ...request.Option) (*DescribeAppVersionResourceOutput, error) {
	req, out := c.DescribeAppVersionResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppVersionResourcesResolutionStatus = "DescribeAppVersionResourcesResolutionStatus"

// DescribeAppVersionResourcesResolutionStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppVersionResourcesResolutionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppVersionResourcesResolutionStatus for more information on using the DescribeAppVersionResourcesResolutionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAppVersionResourcesResolutionStatusRequest method.
//	req, resp := client.DescribeAppVersionResourcesResolutionStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionResourcesResolutionStatus
func (c *ResilienceHub) DescribeAppVersionResourcesResolutionStatusRequest(input *DescribeAppVersionResourcesResolutionStatusInput) (req *request.Request, output *DescribeAppVersionResourcesResolutionStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeAppVersionResourcesResolutionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-app-version-resources-resolution-status",
	}

	if input == nil {
		input = &DescribeAppVersionResourcesResolutionStatusInput{}
	}

	output = &DescribeAppVersionResourcesResolutionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAppVersionResourcesResolutionStatus API operation for AWS Resilience Hub.
//
// Returns the resolution status for the specified resolution identifier for
// an application version. If resolutionId is not specified, the current resolution
// status is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation DescribeAppVersionResourcesResolutionStatus for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionResourcesResolutionStatus
func (c *ResilienceHub) DescribeAppVersionResourcesResolutionStatus(input *DescribeAppVersionResourcesResolutionStatusInput) (*DescribeAppVersionResourcesResolutionStatusOutput, error) {
	req, out := c.DescribeAppVersionResourcesResolutionStatusRequest(input)
	return out, req.Send()
}

// DescribeAppVersionResourcesResolutionStatusWithContext is the same as DescribeAppVersionResourcesResolutionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppVersionResourcesResolutionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) DescribeAppVersionResourcesResolutionStatusWithContext(ctx aws.Context, input *DescribeAppVersionResourcesResolutionStatusInput, opts ...request.Option) (*DescribeAppVersionResourcesResolutionStatusOutput, error) {
	req, out := c.DescribeAppVersionResourcesResolutionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppVersionTemplate = "DescribeAppVersionTemplate"

// DescribeAppVersionTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppVersionTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppVersionTemplate for more information on using the DescribeAppVersionTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAppVersionTemplateRequest method.
//	req, resp := client.DescribeAppVersionTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionTemplate
func (c *ResilienceHub) DescribeAppVersionTemplateRequest(input *DescribeAppVersionTemplateInput) (req *request.Request, output *DescribeAppVersionTemplateOutput) {
	op := &request.Operation{
		Name:       opDescribeAppVersionTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-app-version-template",
	}

	if input == nil {
		input = &DescribeAppVersionTemplateInput{}
	}

	output = &DescribeAppVersionTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAppVersionTemplate API operation for AWS Resilience Hub.
//
// Describes details about an Resilience Hub application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation DescribeAppVersionTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionTemplate
func (c *ResilienceHub) DescribeAppVersionTemplate(input *DescribeAppVersionTemplateInput) (*DescribeAppVersionTemplateOutput, error) {
	req, out := c.DescribeAppVersionTemplateRequest(input)
	return out, req.Send()
}

// DescribeAppVersionTemplateWithContext is the same as DescribeAppVersionTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppVersionTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) DescribeAppVersionTemplateWithContext(ctx aws.Context, input *DescribeAppVersionTemplateInput, opts ...request.Option) (*DescribeAppVersionTemplateOutput, error) {
	req, out := c.DescribeAppVersionTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDraftAppVersionResourcesImportStatus = "DescribeDraftAppVersionResourcesImportStatus"

// DescribeDraftAppVersionResourcesImportStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDraftAppVersionResourcesImportStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDraftAppVersionResourcesImportStatus for more information on using the DescribeDraftAppVersionResourcesImportStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDraftAppVersionResourcesImportStatusRequest method.
//	req, resp := client.DescribeDraftAppVersionResourcesImportStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeDraftAppVersionResourcesImportStatus
func (c *ResilienceHub) DescribeDraftAppVersionResourcesImportStatusRequest(input *DescribeDraftAppVersionResourcesImportStatusInput) (req *request.Request, output *DescribeDraftAppVersionResourcesImportStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeDraftAppVersionResourcesImportStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-draft-app-version-resources-import-status",
	}

	if input == nil {
		input = &DescribeDraftAppVersionResourcesImportStatusInput{}
	}

	output = &DescribeDraftAppVersionResourcesImportStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDraftAppVersionResourcesImportStatus API operation for AWS Resilience Hub.
//
// Describes the status of importing resources to an application version.
//
// If you get a 404 error with ResourceImportStatusNotFoundAppMetadataException,
// you must call importResourcesToDraftAppVersion after creating the application
// and before calling describeDraftAppVersionResourcesImportStatus to obtain
// the status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation DescribeDraftAppVersionResourcesImportStatus for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeDraftAppVersionResourcesImportStatus
func (c *ResilienceHub) DescribeDraftAppVersionResourcesImportStatus(input *DescribeDraftAppVersionResourcesImportStatusInput) (*DescribeDraftAppVersionResourcesImportStatusOutput, error) {
	req, out := c.DescribeDraftAppVersionResourcesImportStatusRequest(input)
	return out, req.Send()
}

// DescribeDraftAppVersionResourcesImportStatusWithContext is the same as DescribeDraftAppVersionResourcesImportStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDraftAppVersionResourcesImportStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) DescribeDraftAppVersionResourcesImportStatusWithContext(ctx aws.Context, input *DescribeDraftAppVersionResourcesImportStatusInput, opts ...request.Option) (*DescribeDraftAppVersionResourcesImportStatusOutput, error) {
	req, out := c.DescribeDraftAppVersionResourcesImportStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeResiliencyPolicy = "DescribeResiliencyPolicy"

// DescribeResiliencyPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResiliencyPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResiliencyPolicy for more information on using the DescribeResiliencyPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeResiliencyPolicyRequest method.
//	req, resp := client.DescribeResiliencyPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeResiliencyPolicy
func (c *ResilienceHub) DescribeResiliencyPolicyRequest(input *DescribeResiliencyPolicyInput) (req *request.Request, output *DescribeResiliencyPolicyOutput) {
	op := &request.Operation{
		Name:       opDescribeResiliencyPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-resiliency-policy",
	}

	if input == nil {
		input = &DescribeResiliencyPolicyInput{}
	}

	output = &DescribeResiliencyPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResiliencyPolicy API operation for AWS Resilience Hub.
//
// Describes a specified resiliency policy for an Resilience Hub application.
// The returned policy object includes creation time, data location constraints,
// the Amazon Resource Name (ARN) for the policy, tags, tier, and more.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation DescribeResiliencyPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeResiliencyPolicy
func (c *ResilienceHub) DescribeResiliencyPolicy(input *DescribeResiliencyPolicyInput) (*DescribeResiliencyPolicyOutput, error) {
	req, out := c.DescribeResiliencyPolicyRequest(input)
	return out, req.Send()
}

// DescribeResiliencyPolicyWithContext is the same as DescribeResiliencyPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResiliencyPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) DescribeResiliencyPolicyWithContext(ctx aws.Context, input *DescribeResiliencyPolicyInput, opts ...request.Option) (*DescribeResiliencyPolicyOutput, error) {
	req, out := c.DescribeResiliencyPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportResourcesToDraftAppVersion = "ImportResourcesToDraftAppVersion"

// ImportResourcesToDraftAppVersionRequest generates a "aws/request.Request" representing the
// client's request for the ImportResourcesToDraftAppVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportResourcesToDraftAppVersion for more information on using the ImportResourcesToDraftAppVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportResourcesToDraftAppVersionRequest method.
//	req, resp := client.ImportResourcesToDraftAppVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ImportResourcesToDraftAppVersion
func (c *ResilienceHub) ImportResourcesToDraftAppVersionRequest(input *ImportResourcesToDraftAppVersionInput) (req *request.Request, output *ImportResourcesToDraftAppVersionOutput) {
	op := &request.Operation{
		Name:       opImportResourcesToDraftAppVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/import-resources-to-draft-app-version",
	}

	if input == nil {
		input = &ImportResourcesToDraftAppVersionInput{}
	}

	output = &ImportResourcesToDraftAppVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportResourcesToDraftAppVersion API operation for AWS Resilience Hub.
//
// Imports resources to Resilience Hub application draft version from different
// input sources. For more information about the input sources supported by
// Resilience Hub, see Discover the structure and describe your Resilience Hub
// application (https://docs.aws.amazon.com/resilience-hub/latest/userguide/discover-structure.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ImportResourcesToDraftAppVersion for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ServiceQuotaExceededException
//     This exception occurs when you have exceeded your service quota. To perform
//     the requested action, remove some of the relevant resources, or use Service
//     Quotas to request a service quota increase.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ImportResourcesToDraftAppVersion
func (c *ResilienceHub) ImportResourcesToDraftAppVersion(input *ImportResourcesToDraftAppVersionInput) (*ImportResourcesToDraftAppVersionOutput, error) {
	req, out := c.ImportResourcesToDraftAppVersionRequest(input)
	return out, req.Send()
}

// ImportResourcesToDraftAppVersionWithContext is the same as ImportResourcesToDraftAppVersion with the addition of
// the ability to pass a context and additional request options.
//
// See ImportResourcesToDraftAppVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ImportResourcesToDraftAppVersionWithContext(ctx aws.Context, input *ImportResourcesToDraftAppVersionInput, opts ...request.Option) (*ImportResourcesToDraftAppVersionOutput, error) {
	req, out := c.ImportResourcesToDraftAppVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAlarmRecommendations = "ListAlarmRecommendations"

// ListAlarmRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the ListAlarmRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAlarmRecommendations for more information on using the ListAlarmRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAlarmRecommendationsRequest method.
//	req, resp := client.ListAlarmRecommendationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAlarmRecommendations
func (c *ResilienceHub) ListAlarmRecommendationsRequest(input *ListAlarmRecommendationsInput) (req *request.Request, output *ListAlarmRecommendationsOutput) {
	op := &request.Operation{
		Name:       opListAlarmRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/list-alarm-recommendations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAlarmRecommendationsInput{}
	}

	output = &ListAlarmRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAlarmRecommendations API operation for AWS Resilience Hub.
//
// Lists the alarm recommendations for an Resilience Hub application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListAlarmRecommendations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAlarmRecommendations
func (c *ResilienceHub) ListAlarmRecommendations(input *ListAlarmRecommendationsInput) (*ListAlarmRecommendationsOutput, error) {
	req, out := c.ListAlarmRecommendationsRequest(input)
	return out, req.Send()
}

// ListAlarmRecommendationsWithContext is the same as ListAlarmRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See ListAlarmRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAlarmRecommendationsWithContext(ctx aws.Context, input *ListAlarmRecommendationsInput, opts ...request.Option) (*ListAlarmRecommendationsOutput, error) {
	req, out := c.ListAlarmRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAlarmRecommendationsPages iterates over the pages of a ListAlarmRecommendations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAlarmRecommendations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAlarmRecommendations operation.
//	pageNum := 0
//	err := client.ListAlarmRecommendationsPages(params,
//	    func(page *resiliencehub.ListAlarmRecommendationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListAlarmRecommendationsPages(input *ListAlarmRecommendationsInput, fn func(*ListAlarmRecommendationsOutput, bool) bool) error {
	return c.ListAlarmRecommendationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAlarmRecommendationsPagesWithContext same as ListAlarmRecommendationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAlarmRecommendationsPagesWithContext(ctx aws.Context, input *ListAlarmRecommendationsInput, fn func(*ListAlarmRecommendationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAlarmRecommendationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAlarmRecommendationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAlarmRecommendationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppAssessmentComplianceDrifts = "ListAppAssessmentComplianceDrifts"

// ListAppAssessmentComplianceDriftsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppAssessmentComplianceDrifts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppAssessmentComplianceDrifts for more information on using the ListAppAssessmentComplianceDrifts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppAssessmentComplianceDriftsRequest method.
//	req, resp := client.ListAppAssessmentComplianceDriftsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessmentComplianceDrifts
func (c *ResilienceHub) ListAppAssessmentComplianceDriftsRequest(input *ListAppAssessmentComplianceDriftsInput) (req *request.Request, output *ListAppAssessmentComplianceDriftsOutput) {
	op := &request.Operation{
		Name:       opListAppAssessmentComplianceDrifts,
		HTTPMethod: "POST",
		HTTPPath:   "/list-app-assessment-compliance-drifts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppAssessmentComplianceDriftsInput{}
	}

	output = &ListAppAssessmentComplianceDriftsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppAssessmentComplianceDrifts API operation for AWS Resilience Hub.
//
// List of compliance drifts that were detected while running an assessment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListAppAssessmentComplianceDrifts for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessmentComplianceDrifts
func (c *ResilienceHub) ListAppAssessmentComplianceDrifts(input *ListAppAssessmentComplianceDriftsInput) (*ListAppAssessmentComplianceDriftsOutput, error) {
	req, out := c.ListAppAssessmentComplianceDriftsRequest(input)
	return out, req.Send()
}

// ListAppAssessmentComplianceDriftsWithContext is the same as ListAppAssessmentComplianceDrifts with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppAssessmentComplianceDrifts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppAssessmentComplianceDriftsWithContext(ctx aws.Context, input *ListAppAssessmentComplianceDriftsInput, opts ...request.Option) (*ListAppAssessmentComplianceDriftsOutput, error) {
	req, out := c.ListAppAssessmentComplianceDriftsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppAssessmentComplianceDriftsPages iterates over the pages of a ListAppAssessmentComplianceDrifts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppAssessmentComplianceDrifts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppAssessmentComplianceDrifts operation.
//	pageNum := 0
//	err := client.ListAppAssessmentComplianceDriftsPages(params,
//	    func(page *resiliencehub.ListAppAssessmentComplianceDriftsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListAppAssessmentComplianceDriftsPages(input *ListAppAssessmentComplianceDriftsInput, fn func(*ListAppAssessmentComplianceDriftsOutput, bool) bool) error {
	return c.ListAppAssessmentComplianceDriftsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppAssessmentComplianceDriftsPagesWithContext same as ListAppAssessmentComplianceDriftsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppAssessmentComplianceDriftsPagesWithContext(ctx aws.Context, input *ListAppAssessmentComplianceDriftsInput, fn func(*ListAppAssessmentComplianceDriftsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppAssessmentComplianceDriftsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppAssessmentComplianceDriftsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppAssessmentComplianceDriftsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppAssessmentResourceDrifts = "ListAppAssessmentResourceDrifts"

// ListAppAssessmentResourceDriftsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppAssessmentResourceDrifts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppAssessmentResourceDrifts for more information on using the ListAppAssessmentResourceDrifts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppAssessmentResourceDriftsRequest method.
//	req, resp := client.ListAppAssessmentResourceDriftsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessmentResourceDrifts
func (c *ResilienceHub) ListAppAssessmentResourceDriftsRequest(input *ListAppAssessmentResourceDriftsInput) (req *request.Request, output *ListAppAssessmentResourceDriftsOutput) {
	op := &request.Operation{
		Name:       opListAppAssessmentResourceDrifts,
		HTTPMethod: "POST",
		HTTPPath:   "/list-app-assessment-resource-drifts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppAssessmentResourceDriftsInput{}
	}

	output = &ListAppAssessmentResourceDriftsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppAssessmentResourceDrifts API operation for AWS Resilience Hub.
//
// Indicates the list of resource drifts that were detected while running an
// assessment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListAppAssessmentResourceDrifts for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessmentResourceDrifts
func (c *ResilienceHub) ListAppAssessmentResourceDrifts(input *ListAppAssessmentResourceDriftsInput) (*ListAppAssessmentResourceDriftsOutput, error) {
	req, out := c.ListAppAssessmentResourceDriftsRequest(input)
	return out, req.Send()
}

// ListAppAssessmentResourceDriftsWithContext is the same as ListAppAssessmentResourceDrifts with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppAssessmentResourceDrifts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppAssessmentResourceDriftsWithContext(ctx aws.Context, input *ListAppAssessmentResourceDriftsInput, opts ...request.Option) (*ListAppAssessmentResourceDriftsOutput, error) {
	req, out := c.ListAppAssessmentResourceDriftsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppAssessmentResourceDriftsPages iterates over the pages of a ListAppAssessmentResourceDrifts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppAssessmentResourceDrifts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppAssessmentResourceDrifts operation.
//	pageNum := 0
//	err := client.ListAppAssessmentResourceDriftsPages(params,
//	    func(page *resiliencehub.ListAppAssessmentResourceDriftsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListAppAssessmentResourceDriftsPages(input *ListAppAssessmentResourceDriftsInput, fn func(*ListAppAssessmentResourceDriftsOutput, bool) bool) error {
	return c.ListAppAssessmentResourceDriftsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppAssessmentResourceDriftsPagesWithContext same as ListAppAssessmentResourceDriftsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppAssessmentResourceDriftsPagesWithContext(ctx aws.Context, input *ListAppAssessmentResourceDriftsInput, fn func(*ListAppAssessmentResourceDriftsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppAssessmentResourceDriftsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppAssessmentResourceDriftsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppAssessmentResourceDriftsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppAssessments = "ListAppAssessments"

// ListAppAssessmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppAssessments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppAssessments for more information on using the ListAppAssessments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppAssessmentsRequest method.
//	req, resp := client.ListAppAssessmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessments
func (c *ResilienceHub) ListAppAssessmentsRequest(input *ListAppAssessmentsInput) (req *request.Request, output *ListAppAssessmentsOutput) {
	op := &request.Operation{
		Name:       opListAppAssessments,
		HTTPMethod: "GET",
		HTTPPath:   "/list-app-assessments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppAssessmentsInput{}
	}

	output = &ListAppAssessmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppAssessments API operation for AWS Resilience Hub.
//
// Lists the assessments for an Resilience Hub application. You can use request
// parameters to refine the results for the response object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListAppAssessments for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessments
func (c *ResilienceHub) ListAppAssessments(input *ListAppAssessmentsInput) (*ListAppAssessmentsOutput, error) {
	req, out := c.ListAppAssessmentsRequest(input)
	return out, req.Send()
}

// ListAppAssessmentsWithContext is the same as ListAppAssessments with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppAssessments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppAssessmentsWithContext(ctx aws.Context, input *ListAppAssessmentsInput, opts ...request.Option) (*ListAppAssessmentsOutput, error) {
	req, out := c.ListAppAssessmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppAssessmentsPages iterates over the pages of a ListAppAssessments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppAssessments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppAssessments operation.
//	pageNum := 0
//	err := client.ListAppAssessmentsPages(params,
//	    func(page *resiliencehub.ListAppAssessmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListAppAssessmentsPages(input *ListAppAssessmentsInput, fn func(*ListAppAssessmentsOutput, bool) bool) error {
	return c.ListAppAssessmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppAssessmentsPagesWithContext same as ListAppAssessmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppAssessmentsPagesWithContext(ctx aws.Context, input *ListAppAssessmentsInput, fn func(*ListAppAssessmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppAssessmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppAssessmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppAssessmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppComponentCompliances = "ListAppComponentCompliances"

// ListAppComponentCompliancesRequest generates a "aws/request.Request" representing the
// client's request for the ListAppComponentCompliances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppComponentCompliances for more information on using the ListAppComponentCompliances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppComponentCompliancesRequest method.
//	req, resp := client.ListAppComponentCompliancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentCompliances
func (c *ResilienceHub) ListAppComponentCompliancesRequest(input *ListAppComponentCompliancesInput) (req *request.Request, output *ListAppComponentCompliancesOutput) {
	op := &request.Operation{
		Name:       opListAppComponentCompliances,
		HTTPMethod: "POST",
		HTTPPath:   "/list-app-component-compliances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppComponentCompliancesInput{}
	}

	output = &ListAppComponentCompliancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppComponentCompliances API operation for AWS Resilience Hub.
//
// Lists the compliances for an Resilience Hub Application Component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListAppComponentCompliances for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentCompliances
func (c *ResilienceHub) ListAppComponentCompliances(input *ListAppComponentCompliancesInput) (*ListAppComponentCompliancesOutput, error) {
	req, out := c.ListAppComponentCompliancesRequest(input)
	return out, req.Send()
}

// ListAppComponentCompliancesWithContext is the same as ListAppComponentCompliances with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppComponentCompliances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppComponentCompliancesWithContext(ctx aws.Context, input *ListAppComponentCompliancesInput, opts ...request.Option) (*ListAppComponentCompliancesOutput, error) {
	req, out := c.ListAppComponentCompliancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppComponentCompliancesPages iterates over the pages of a ListAppComponentCompliances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppComponentCompliances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppComponentCompliances operation.
//	pageNum := 0
//	err := client.ListAppComponentCompliancesPages(params,
//	    func(page *resiliencehub.ListAppComponentCompliancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListAppComponentCompliancesPages(input *ListAppComponentCompliancesInput, fn func(*ListAppComponentCompliancesOutput, bool) bool) error {
	return c.ListAppComponentCompliancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppComponentCompliancesPagesWithContext same as ListAppComponentCompliancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppComponentCompliancesPagesWithContext(ctx aws.Context, input *ListAppComponentCompliancesInput, fn func(*ListAppComponentCompliancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppComponentCompliancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppComponentCompliancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppComponentCompliancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppComponentRecommendations = "ListAppComponentRecommendations"

// ListAppComponentRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppComponentRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppComponentRecommendations for more information on using the ListAppComponentRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppComponentRecommendationsRequest method.
//	req, resp := client.ListAppComponentRecommendationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentRecommendations
func (c *ResilienceHub) ListAppComponentRecommendationsRequest(input *ListAppComponentRecommendationsInput) (req *request.Request, output *ListAppComponentRecommendationsOutput) {
	op := &request.Operation{
		Name:       opListAppComponentRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/list-app-component-recommendations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppComponentRecommendationsInput{}
	}

	output = &ListAppComponentRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppComponentRecommendations API operation for AWS Resilience Hub.
//
// Lists the recommendations for an Resilience Hub Application Component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListAppComponentRecommendations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentRecommendations
func (c *ResilienceHub) ListAppComponentRecommendations(input *ListAppComponentRecommendationsInput) (*ListAppComponentRecommendationsOutput, error) {
	req, out := c.ListAppComponentRecommendationsRequest(input)
	return out, req.Send()
}

// ListAppComponentRecommendationsWithContext is the same as ListAppComponentRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppComponentRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppComponentRecommendationsWithContext(ctx aws.Context, input *ListAppComponentRecommendationsInput, opts ...request.Option) (*ListAppComponentRecommendationsOutput, error) {
	req, out := c.ListAppComponentRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppComponentRecommendationsPages iterates over the pages of a ListAppComponentRecommendations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppComponentRecommendations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppComponentRecommendations operation.
//	pageNum := 0
//	err := client.ListAppComponentRecommendationsPages(params,
//	    func(page *resiliencehub.ListAppComponentRecommendationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListAppComponentRecommendationsPages(input *ListAppComponentRecommendationsInput, fn func(*ListAppComponentRecommendationsOutput, bool) bool) error {
	return c.ListAppComponentRecommendationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppComponentRecommendationsPagesWithContext same as ListAppComponentRecommendationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppComponentRecommendationsPagesWithContext(ctx aws.Context, input *ListAppComponentRecommendationsInput, fn func(*ListAppComponentRecommendationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppComponentRecommendationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppComponentRecommendationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppComponentRecommendationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppInputSources = "ListAppInputSources"

// ListAppInputSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListAppInputSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppInputSources for more information on using the ListAppInputSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppInputSourcesRequest method.
//	req, resp := client.ListAppInputSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppInputSources
func (c *ResilienceHub) ListAppInputSourcesRequest(input *ListAppInputSourcesInput) (req *request.Request, output *ListAppInputSourcesOutput) {
	op := &request.Operation{
		Name:       opListAppInputSources,
		HTTPMethod: "POST",
		HTTPPath:   "/list-app-input-sources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppInputSourcesInput{}
	}

	output = &ListAppInputSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppInputSources API operation for AWS Resilience Hub.
//
// Lists all the input sources of the Resilience Hub application. For more information
// about the input sources supported by Resilience Hub, see Discover the structure
// and describe your Resilience Hub application (https://docs.aws.amazon.com/resilience-hub/latest/userguide/discover-structure.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListAppInputSources for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppInputSources
func (c *ResilienceHub) ListAppInputSources(input *ListAppInputSourcesInput) (*ListAppInputSourcesOutput, error) {
	req, out := c.ListAppInputSourcesRequest(input)
	return out, req.Send()
}

// ListAppInputSourcesWithContext is the same as ListAppInputSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppInputSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppInputSourcesWithContext(ctx aws.Context, input *ListAppInputSourcesInput, opts ...request.Option) (*ListAppInputSourcesOutput, error) {
	req, out := c.ListAppInputSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppInputSourcesPages iterates over the pages of a ListAppInputSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppInputSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppInputSources operation.
//	pageNum := 0
//	err := client.ListAppInputSourcesPages(params,
//	    func(page *resiliencehub.ListAppInputSourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListAppInputSourcesPages(input *ListAppInputSourcesInput, fn func(*ListAppInputSourcesOutput, bool) bool) error {
	return c.ListAppInputSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppInputSourcesPagesWithContext same as ListAppInputSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppInputSourcesPagesWithContext(ctx aws.Context, input *ListAppInputSourcesInput, fn func(*ListAppInputSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppInputSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppInputSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppInputSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppVersionAppComponents = "ListAppVersionAppComponents"

// ListAppVersionAppComponentsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppVersionAppComponents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppVersionAppComponents for more information on using the ListAppVersionAppComponents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppVersionAppComponentsRequest method.
//	req, resp := client.ListAppVersionAppComponentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionAppComponents
func (c *ResilienceHub) ListAppVersionAppComponentsRequest(input *ListAppVersionAppComponentsInput) (req *request.Request, output *ListAppVersionAppComponentsOutput) {
	op := &request.Operation{
		Name:       opListAppVersionAppComponents,
		HTTPMethod: "POST",
		HTTPPath:   "/list-app-version-app-components",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppVersionAppComponentsInput{}
	}

	output = &ListAppVersionAppComponentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppVersionAppComponents API operation for AWS Resilience Hub.
//
// Lists all the Application Components in the Resilience Hub application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListAppVersionAppComponents for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionAppComponents
func (c *ResilienceHub) ListAppVersionAppComponents(input *ListAppVersionAppComponentsInput) (*ListAppVersionAppComponentsOutput, error) {
	req, out := c.ListAppVersionAppComponentsRequest(input)
	return out, req.Send()
}

// ListAppVersionAppComponentsWithContext is the same as ListAppVersionAppComponents with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppVersionAppComponents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppVersionAppComponentsWithContext(ctx aws.Context, input *ListAppVersionAppComponentsInput, opts ...request.Option) (*ListAppVersionAppComponentsOutput, error) {
	req, out := c.ListAppVersionAppComponentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppVersionAppComponentsPages iterates over the pages of a ListAppVersionAppComponents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppVersionAppComponents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppVersionAppComponents operation.
//	pageNum := 0
//	err := client.ListAppVersionAppComponentsPages(params,
//	    func(page *resiliencehub.ListAppVersionAppComponentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListAppVersionAppComponentsPages(input *ListAppVersionAppComponentsInput, fn func(*ListAppVersionAppComponentsOutput, bool) bool) error {
	return c.ListAppVersionAppComponentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppVersionAppComponentsPagesWithContext same as ListAppVersionAppComponentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppVersionAppComponentsPagesWithContext(ctx aws.Context, input *ListAppVersionAppComponentsInput, fn func(*ListAppVersionAppComponentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppVersionAppComponentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppVersionAppComponentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppVersionAppComponentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppVersionResourceMappings = "ListAppVersionResourceMappings"

// ListAppVersionResourceMappingsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppVersionResourceMappings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppVersionResourceMappings for more information on using the ListAppVersionResourceMappings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppVersionResourceMappingsRequest method.
//	req, resp := client.ListAppVersionResourceMappingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResourceMappings
func (c *ResilienceHub) ListAppVersionResourceMappingsRequest(input *ListAppVersionResourceMappingsInput) (req *request.Request, output *ListAppVersionResourceMappingsOutput) {
	op := &request.Operation{
		Name:       opListAppVersionResourceMappings,
		HTTPMethod: "POST",
		HTTPPath:   "/list-app-version-resource-mappings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppVersionResourceMappingsInput{}
	}

	output = &ListAppVersionResourceMappingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppVersionResourceMappings API operation for AWS Resilience Hub.
//
// Lists how the resources in an application version are mapped/sourced from.
// Mappings can be physical resource identifiers, CloudFormation stacks, resource-groups,
// or an application registry app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListAppVersionResourceMappings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResourceMappings
func (c *ResilienceHub) ListAppVersionResourceMappings(input *ListAppVersionResourceMappingsInput) (*ListAppVersionResourceMappingsOutput, error) {
	req, out := c.ListAppVersionResourceMappingsRequest(input)
	return out, req.Send()
}

// ListAppVersionResourceMappingsWithContext is the same as ListAppVersionResourceMappings with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppVersionResourceMappings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppVersionResourceMappingsWithContext(ctx aws.Context, input *ListAppVersionResourceMappingsInput, opts ...request.Option) (*ListAppVersionResourceMappingsOutput, error) {
	req, out := c.ListAppVersionResourceMappingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppVersionResourceMappingsPages iterates over the pages of a ListAppVersionResourceMappings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppVersionResourceMappings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppVersionResourceMappings operation.
//	pageNum := 0
//	err := client.ListAppVersionResourceMappingsPages(params,
//	    func(page *resiliencehub.ListAppVersionResourceMappingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListAppVersionResourceMappingsPages(input *ListAppVersionResourceMappingsInput, fn func(*ListAppVersionResourceMappingsOutput, bool) bool) error {
	return c.ListAppVersionResourceMappingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppVersionResourceMappingsPagesWithContext same as ListAppVersionResourceMappingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppVersionResourceMappingsPagesWithContext(ctx aws.Context, input *ListAppVersionResourceMappingsInput, fn func(*ListAppVersionResourceMappingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppVersionResourceMappingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppVersionResourceMappingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppVersionResourceMappingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppVersionResources = "ListAppVersionResources"

// ListAppVersionResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListAppVersionResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppVersionResources for more information on using the ListAppVersionResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppVersionResourcesRequest method.
//	req, resp := client.ListAppVersionResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResources
func (c *ResilienceHub) ListAppVersionResourcesRequest(input *ListAppVersionResourcesInput) (req *request.Request, output *ListAppVersionResourcesOutput) {
	op := &request.Operation{
		Name:       opListAppVersionResources,
		HTTPMethod: "POST",
		HTTPPath:   "/list-app-version-resources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppVersionResourcesInput{}
	}

	output = &ListAppVersionResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppVersionResources API operation for AWS Resilience Hub.
//
// Lists all the resources in an Resilience Hub application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListAppVersionResources for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResources
func (c *ResilienceHub) ListAppVersionResources(input *ListAppVersionResourcesInput) (*ListAppVersionResourcesOutput, error) {
	req, out := c.ListAppVersionResourcesRequest(input)
	return out, req.Send()
}

// ListAppVersionResourcesWithContext is the same as ListAppVersionResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppVersionResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppVersionResourcesWithContext(ctx aws.Context, input *ListAppVersionResourcesInput, opts ...request.Option) (*ListAppVersionResourcesOutput, error) {
	req, out := c.ListAppVersionResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppVersionResourcesPages iterates over the pages of a ListAppVersionResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppVersionResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppVersionResources operation.
//	pageNum := 0
//	err := client.ListAppVersionResourcesPages(params,
//	    func(page *resiliencehub.ListAppVersionResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListAppVersionResourcesPages(input *ListAppVersionResourcesInput, fn func(*ListAppVersionResourcesOutput, bool) bool) error {
	return c.ListAppVersionResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppVersionResourcesPagesWithContext same as ListAppVersionResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppVersionResourcesPagesWithContext(ctx aws.Context, input *ListAppVersionResourcesInput, fn func(*ListAppVersionResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppVersionResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppVersionResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppVersionResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppVersions = "ListAppVersions"

// ListAppVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppVersions for more information on using the ListAppVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppVersionsRequest method.
//	req, resp := client.ListAppVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersions
func (c *ResilienceHub) ListAppVersionsRequest(input *ListAppVersionsInput) (req *request.Request, output *ListAppVersionsOutput) {
	op := &request.Operation{
		Name:       opListAppVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/list-app-versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppVersionsInput{}
	}

	output = &ListAppVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppVersions API operation for AWS Resilience Hub.
//
// Lists the different versions for the Resilience Hub applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListAppVersions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersions
func (c *ResilienceHub) ListAppVersions(input *ListAppVersionsInput) (*ListAppVersionsOutput, error) {
	req, out := c.ListAppVersionsRequest(input)
	return out, req.Send()
}

// ListAppVersionsWithContext is the same as ListAppVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppVersionsWithContext(ctx aws.Context, input *ListAppVersionsInput, opts ...request.Option) (*ListAppVersionsOutput, error) {
	req, out := c.ListAppVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppVersionsPages iterates over the pages of a ListAppVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppVersions operation.
//	pageNum := 0
//	err := client.ListAppVersionsPages(params,
//	    func(page *resiliencehub.ListAppVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListAppVersionsPages(input *ListAppVersionsInput, fn func(*ListAppVersionsOutput, bool) bool) error {
	return c.ListAppVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppVersionsPagesWithContext same as ListAppVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppVersionsPagesWithContext(ctx aws.Context, input *ListAppVersionsInput, fn func(*ListAppVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListApps = "ListApps"

// ListAppsRequest generates a "aws/request.Request" representing the
// client's request for the ListApps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApps for more information on using the ListApps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppsRequest method.
//	req, resp := client.ListAppsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListApps
func (c *ResilienceHub) ListAppsRequest(input *ListAppsInput) (req *request.Request, output *ListAppsOutput) {
	op := &request.Operation{
		Name:       opListApps,
		HTTPMethod: "GET",
		HTTPPath:   "/list-apps",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppsInput{}
	}

	output = &ListAppsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApps API operation for AWS Resilience Hub.
//
// Lists your Resilience Hub applications.
//
// You can filter applications using only one filter at a time or without using
// any filter. If you try to filter applications using multiple filters, you
// will get the following error:
//
// An error occurred (ValidationException) when calling the ListApps operation:
// Only one filter is supported for this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListApps for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListApps
func (c *ResilienceHub) ListApps(input *ListAppsInput) (*ListAppsOutput, error) {
	req, out := c.ListAppsRequest(input)
	return out, req.Send()
}

// ListAppsWithContext is the same as ListApps with the addition of
// the ability to pass a context and additional request options.
//
// See ListApps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppsWithContext(ctx aws.Context, input *ListAppsInput, opts ...request.Option) (*ListAppsOutput, error) {
	req, out := c.ListAppsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppsPages iterates over the pages of a ListApps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApps operation.
//	pageNum := 0
//	err := client.ListAppsPages(params,
//	    func(page *resiliencehub.ListAppsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListAppsPages(input *ListAppsInput, fn func(*ListAppsOutput, bool) bool) error {
	return c.ListAppsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppsPagesWithContext same as ListAppsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListAppsPagesWithContext(ctx aws.Context, input *ListAppsInput, fn func(*ListAppsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecommendationTemplates = "ListRecommendationTemplates"

// ListRecommendationTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListRecommendationTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecommendationTemplates for more information on using the ListRecommendationTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRecommendationTemplatesRequest method.
//	req, resp := client.ListRecommendationTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListRecommendationTemplates
func (c *ResilienceHub) ListRecommendationTemplatesRequest(input *ListRecommendationTemplatesInput) (req *request.Request, output *ListRecommendationTemplatesOutput) {
	op := &request.Operation{
		Name:       opListRecommendationTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/list-recommendation-templates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecommendationTemplatesInput{}
	}

	output = &ListRecommendationTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecommendationTemplates API operation for AWS Resilience Hub.
//
// Lists the recommendation templates for the Resilience Hub applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListRecommendationTemplates for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListRecommendationTemplates
func (c *ResilienceHub) ListRecommendationTemplates(input *ListRecommendationTemplatesInput) (*ListRecommendationTemplatesOutput, error) {
	req, out := c.ListRecommendationTemplatesRequest(input)
	return out, req.Send()
}

// ListRecommendationTemplatesWithContext is the same as ListRecommendationTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecommendationTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListRecommendationTemplatesWithContext(ctx aws.Context, input *ListRecommendationTemplatesInput, opts ...request.Option) (*ListRecommendationTemplatesOutput, error) {
	req, out := c.ListRecommendationTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecommendationTemplatesPages iterates over the pages of a ListRecommendationTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecommendationTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRecommendationTemplates operation.
//	pageNum := 0
//	err := client.ListRecommendationTemplatesPages(params,
//	    func(page *resiliencehub.ListRecommendationTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListRecommendationTemplatesPages(input *ListRecommendationTemplatesInput, fn func(*ListRecommendationTemplatesOutput, bool) bool) error {
	return c.ListRecommendationTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecommendationTemplatesPagesWithContext same as ListRecommendationTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListRecommendationTemplatesPagesWithContext(ctx aws.Context, input *ListRecommendationTemplatesInput, fn func(*ListRecommendationTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecommendationTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecommendationTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecommendationTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResiliencyPolicies = "ListResiliencyPolicies"

// ListResiliencyPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListResiliencyPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResiliencyPolicies for more information on using the ListResiliencyPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResiliencyPoliciesRequest method.
//	req, resp := client.ListResiliencyPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListResiliencyPolicies
func (c *ResilienceHub) ListResiliencyPoliciesRequest(input *ListResiliencyPoliciesInput) (req *request.Request, output *ListResiliencyPoliciesOutput) {
	op := &request.Operation{
		Name:       opListResiliencyPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/list-resiliency-policies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResiliencyPoliciesInput{}
	}

	output = &ListResiliencyPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResiliencyPolicies API operation for AWS Resilience Hub.
//
// Lists the resiliency policies for the Resilience Hub applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListResiliencyPolicies for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListResiliencyPolicies
func (c *ResilienceHub) ListResiliencyPolicies(input *ListResiliencyPoliciesInput) (*ListResiliencyPoliciesOutput, error) {
	req, out := c.ListResiliencyPoliciesRequest(input)
	return out, req.Send()
}

// ListResiliencyPoliciesWithContext is the same as ListResiliencyPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListResiliencyPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListResiliencyPoliciesWithContext(ctx aws.Context, input *ListResiliencyPoliciesInput, opts ...request.Option) (*ListResiliencyPoliciesOutput, error) {
	req, out := c.ListResiliencyPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResiliencyPoliciesPages iterates over the pages of a ListResiliencyPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResiliencyPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResiliencyPolicies operation.
//	pageNum := 0
//	err := client.ListResiliencyPoliciesPages(params,
//	    func(page *resiliencehub.ListResiliencyPoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListResiliencyPoliciesPages(input *ListResiliencyPoliciesInput, fn func(*ListResiliencyPoliciesOutput, bool) bool) error {
	return c.ListResiliencyPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResiliencyPoliciesPagesWithContext same as ListResiliencyPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListResiliencyPoliciesPagesWithContext(ctx aws.Context, input *ListResiliencyPoliciesInput, fn func(*ListResiliencyPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResiliencyPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResiliencyPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResiliencyPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSopRecommendations = "ListSopRecommendations"

// ListSopRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the ListSopRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSopRecommendations for more information on using the ListSopRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSopRecommendationsRequest method.
//	req, resp := client.ListSopRecommendationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSopRecommendations
func (c *ResilienceHub) ListSopRecommendationsRequest(input *ListSopRecommendationsInput) (req *request.Request, output *ListSopRecommendationsOutput) {
	op := &request.Operation{
		Name:       opListSopRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/list-sop-recommendations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSopRecommendationsInput{}
	}

	output = &ListSopRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSopRecommendations API operation for AWS Resilience Hub.
//
// Lists the standard operating procedure (SOP) recommendations for the Resilience
// Hub applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListSopRecommendations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSopRecommendations
func (c *ResilienceHub) ListSopRecommendations(input *ListSopRecommendationsInput) (*ListSopRecommendationsOutput, error) {
	req, out := c.ListSopRecommendationsRequest(input)
	return out, req.Send()
}

// ListSopRecommendationsWithContext is the same as ListSopRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See ListSopRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListSopRecommendationsWithContext(ctx aws.Context, input *ListSopRecommendationsInput, opts ...request.Option) (*ListSopRecommendationsOutput, error) {
	req, out := c.ListSopRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSopRecommendationsPages iterates over the pages of a ListSopRecommendations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSopRecommendations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSopRecommendations operation.
//	pageNum := 0
//	err := client.ListSopRecommendationsPages(params,
//	    func(page *resiliencehub.ListSopRecommendationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListSopRecommendationsPages(input *ListSopRecommendationsInput, fn func(*ListSopRecommendationsOutput, bool) bool) error {
	return c.ListSopRecommendationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSopRecommendationsPagesWithContext same as ListSopRecommendationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListSopRecommendationsPagesWithContext(ctx aws.Context, input *ListSopRecommendationsInput, fn func(*ListSopRecommendationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSopRecommendationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSopRecommendationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSopRecommendationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSuggestedResiliencyPolicies = "ListSuggestedResiliencyPolicies"

// ListSuggestedResiliencyPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListSuggestedResiliencyPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSuggestedResiliencyPolicies for more information on using the ListSuggestedResiliencyPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSuggestedResiliencyPoliciesRequest method.
//	req, resp := client.ListSuggestedResiliencyPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSuggestedResiliencyPolicies
func (c *ResilienceHub) ListSuggestedResiliencyPoliciesRequest(input *ListSuggestedResiliencyPoliciesInput) (req *request.Request, output *ListSuggestedResiliencyPoliciesOutput) {
	op := &request.Operation{
		Name:       opListSuggestedResiliencyPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/list-suggested-resiliency-policies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSuggestedResiliencyPoliciesInput{}
	}

	output = &ListSuggestedResiliencyPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSuggestedResiliencyPolicies API operation for AWS Resilience Hub.
//
// Lists the suggested resiliency policies for the Resilience Hub applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListSuggestedResiliencyPolicies for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSuggestedResiliencyPolicies
func (c *ResilienceHub) ListSuggestedResiliencyPolicies(input *ListSuggestedResiliencyPoliciesInput) (*ListSuggestedResiliencyPoliciesOutput, error) {
	req, out := c.ListSuggestedResiliencyPoliciesRequest(input)
	return out, req.Send()
}

// ListSuggestedResiliencyPoliciesWithContext is the same as ListSuggestedResiliencyPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListSuggestedResiliencyPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListSuggestedResiliencyPoliciesWithContext(ctx aws.Context, input *ListSuggestedResiliencyPoliciesInput, opts ...request.Option) (*ListSuggestedResiliencyPoliciesOutput, error) {
	req, out := c.ListSuggestedResiliencyPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSuggestedResiliencyPoliciesPages iterates over the pages of a ListSuggestedResiliencyPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSuggestedResiliencyPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSuggestedResiliencyPolicies operation.
//	pageNum := 0
//	err := client.ListSuggestedResiliencyPoliciesPages(params,
//	    func(page *resiliencehub.ListSuggestedResiliencyPoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListSuggestedResiliencyPoliciesPages(input *ListSuggestedResiliencyPoliciesInput, fn func(*ListSuggestedResiliencyPoliciesOutput, bool) bool) error {
	return c.ListSuggestedResiliencyPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSuggestedResiliencyPoliciesPagesWithContext same as ListSuggestedResiliencyPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListSuggestedResiliencyPoliciesPagesWithContext(ctx aws.Context, input *ListSuggestedResiliencyPoliciesInput, fn func(*ListSuggestedResiliencyPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSuggestedResiliencyPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSuggestedResiliencyPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSuggestedResiliencyPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTagsForResource
func (c *ResilienceHub) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Resilience Hub.
//
// Lists the tags for your resources in your Resilience Hub applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTagsForResource
func (c *ResilienceHub) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTestRecommendations = "ListTestRecommendations"

// ListTestRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the ListTestRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestRecommendations for more information on using the ListTestRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestRecommendationsRequest method.
//	req, resp := client.ListTestRecommendationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTestRecommendations
func (c *ResilienceHub) ListTestRecommendationsRequest(input *ListTestRecommendationsInput) (req *request.Request, output *ListTestRecommendationsOutput) {
	op := &request.Operation{
		Name:       opListTestRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/list-test-recommendations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestRecommendationsInput{}
	}

	output = &ListTestRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestRecommendations API operation for AWS Resilience Hub.
//
// Lists the test recommendations for the Resilience Hub application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListTestRecommendations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTestRecommendations
func (c *ResilienceHub) ListTestRecommendations(input *ListTestRecommendationsInput) (*ListTestRecommendationsOutput, error) {
	req, out := c.ListTestRecommendationsRequest(input)
	return out, req.Send()
}

// ListTestRecommendationsWithContext is the same as ListTestRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListTestRecommendationsWithContext(ctx aws.Context, input *ListTestRecommendationsInput, opts ...request.Option) (*ListTestRecommendationsOutput, error) {
	req, out := c.ListTestRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestRecommendationsPages iterates over the pages of a ListTestRecommendations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestRecommendations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestRecommendations operation.
//	pageNum := 0
//	err := client.ListTestRecommendationsPages(params,
//	    func(page *resiliencehub.ListTestRecommendationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListTestRecommendationsPages(input *ListTestRecommendationsInput, fn func(*ListTestRecommendationsOutput, bool) bool) error {
	return c.ListTestRecommendationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestRecommendationsPagesWithContext same as ListTestRecommendationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListTestRecommendationsPagesWithContext(ctx aws.Context, input *ListTestRecommendationsInput, fn func(*ListTestRecommendationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestRecommendationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestRecommendationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestRecommendationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUnsupportedAppVersionResources = "ListUnsupportedAppVersionResources"

// ListUnsupportedAppVersionResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListUnsupportedAppVersionResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUnsupportedAppVersionResources for more information on using the ListUnsupportedAppVersionResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUnsupportedAppVersionResourcesRequest method.
//	req, resp := client.ListUnsupportedAppVersionResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListUnsupportedAppVersionResources
func (c *ResilienceHub) ListUnsupportedAppVersionResourcesRequest(input *ListUnsupportedAppVersionResourcesInput) (req *request.Request, output *ListUnsupportedAppVersionResourcesOutput) {
	op := &request.Operation{
		Name:       opListUnsupportedAppVersionResources,
		HTTPMethod: "POST",
		HTTPPath:   "/list-unsupported-app-version-resources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUnsupportedAppVersionResourcesInput{}
	}

	output = &ListUnsupportedAppVersionResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUnsupportedAppVersionResources API operation for AWS Resilience Hub.
//
// Lists the resources that are not currently supported in Resilience Hub. An
// unsupported resource is a resource that exists in the object that was used
// to create an app, but is not supported by Resilience Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ListUnsupportedAppVersionResources for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListUnsupportedAppVersionResources
func (c *ResilienceHub) ListUnsupportedAppVersionResources(input *ListUnsupportedAppVersionResourcesInput) (*ListUnsupportedAppVersionResourcesOutput, error) {
	req, out := c.ListUnsupportedAppVersionResourcesRequest(input)
	return out, req.Send()
}

// ListUnsupportedAppVersionResourcesWithContext is the same as ListUnsupportedAppVersionResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListUnsupportedAppVersionResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListUnsupportedAppVersionResourcesWithContext(ctx aws.Context, input *ListUnsupportedAppVersionResourcesInput, opts ...request.Option) (*ListUnsupportedAppVersionResourcesOutput, error) {
	req, out := c.ListUnsupportedAppVersionResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUnsupportedAppVersionResourcesPages iterates over the pages of a ListUnsupportedAppVersionResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUnsupportedAppVersionResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUnsupportedAppVersionResources operation.
//	pageNum := 0
//	err := client.ListUnsupportedAppVersionResourcesPages(params,
//	    func(page *resiliencehub.ListUnsupportedAppVersionResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResilienceHub) ListUnsupportedAppVersionResourcesPages(input *ListUnsupportedAppVersionResourcesInput, fn func(*ListUnsupportedAppVersionResourcesOutput, bool) bool) error {
	return c.ListUnsupportedAppVersionResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUnsupportedAppVersionResourcesPagesWithContext same as ListUnsupportedAppVersionResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ListUnsupportedAppVersionResourcesPagesWithContext(ctx aws.Context, input *ListUnsupportedAppVersionResourcesInput, fn func(*ListUnsupportedAppVersionResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUnsupportedAppVersionResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUnsupportedAppVersionResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUnsupportedAppVersionResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPublishAppVersion = "PublishAppVersion"

// PublishAppVersionRequest generates a "aws/request.Request" representing the
// client's request for the PublishAppVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PublishAppVersion for more information on using the PublishAppVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PublishAppVersionRequest method.
//	req, resp := client.PublishAppVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/PublishAppVersion
func (c *ResilienceHub) PublishAppVersionRequest(input *PublishAppVersionInput) (req *request.Request, output *PublishAppVersionOutput) {
	op := &request.Operation{
		Name:       opPublishAppVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/publish-app-version",
	}

	if input == nil {
		input = &PublishAppVersionInput{}
	}

	output = &PublishAppVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PublishAppVersion API operation for AWS Resilience Hub.
//
// Publishes a new version of a specific Resilience Hub application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation PublishAppVersion for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/PublishAppVersion
func (c *ResilienceHub) PublishAppVersion(input *PublishAppVersionInput) (*PublishAppVersionOutput, error) {
	req, out := c.PublishAppVersionRequest(input)
	return out, req.Send()
}

// PublishAppVersionWithContext is the same as PublishAppVersion with the addition of
// the ability to pass a context and additional request options.
//
// See PublishAppVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) PublishAppVersionWithContext(ctx aws.Context, input *PublishAppVersionInput, opts ...request.Option) (*PublishAppVersionOutput, error) {
	req, out := c.PublishAppVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutDraftAppVersionTemplate = "PutDraftAppVersionTemplate"

// PutDraftAppVersionTemplateRequest generates a "aws/request.Request" representing the
// client's request for the PutDraftAppVersionTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDraftAppVersionTemplate for more information on using the PutDraftAppVersionTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutDraftAppVersionTemplateRequest method.
//	req, resp := client.PutDraftAppVersionTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/PutDraftAppVersionTemplate
func (c *ResilienceHub) PutDraftAppVersionTemplateRequest(input *PutDraftAppVersionTemplateInput) (req *request.Request, output *PutDraftAppVersionTemplateOutput) {
	op := &request.Operation{
		Name:       opPutDraftAppVersionTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/put-draft-app-version-template",
	}

	if input == nil {
		input = &PutDraftAppVersionTemplateInput{}
	}

	output = &PutDraftAppVersionTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutDraftAppVersionTemplate API operation for AWS Resilience Hub.
//
// Adds or updates the app template for an Resilience Hub application draft
// version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation PutDraftAppVersionTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/PutDraftAppVersionTemplate
func (c *ResilienceHub) PutDraftAppVersionTemplate(input *PutDraftAppVersionTemplateInput) (*PutDraftAppVersionTemplateOutput, error) {
	req, out := c.PutDraftAppVersionTemplateRequest(input)
	return out, req.Send()
}

// PutDraftAppVersionTemplateWithContext is the same as PutDraftAppVersionTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See PutDraftAppVersionTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) PutDraftAppVersionTemplateWithContext(ctx aws.Context, input *PutDraftAppVersionTemplateInput, opts ...request.Option) (*PutDraftAppVersionTemplateOutput, error) {
	req, out := c.PutDraftAppVersionTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveDraftAppVersionResourceMappings = "RemoveDraftAppVersionResourceMappings"

// RemoveDraftAppVersionResourceMappingsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveDraftAppVersionResourceMappings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveDraftAppVersionResourceMappings for more information on using the RemoveDraftAppVersionResourceMappings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveDraftAppVersionResourceMappingsRequest method.
//	req, resp := client.RemoveDraftAppVersionResourceMappingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/RemoveDraftAppVersionResourceMappings
func (c *ResilienceHub) RemoveDraftAppVersionResourceMappingsRequest(input *RemoveDraftAppVersionResourceMappingsInput) (req *request.Request, output *RemoveDraftAppVersionResourceMappingsOutput) {
	op := &request.Operation{
		Name:       opRemoveDraftAppVersionResourceMappings,
		HTTPMethod: "POST",
		HTTPPath:   "/remove-draft-app-version-resource-mappings",
	}

	if input == nil {
		input = &RemoveDraftAppVersionResourceMappingsInput{}
	}

	output = &RemoveDraftAppVersionResourceMappingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveDraftAppVersionResourceMappings API operation for AWS Resilience Hub.
//
// Removes resource mappings from a draft application version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation RemoveDraftAppVersionResourceMappings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/RemoveDraftAppVersionResourceMappings
func (c *ResilienceHub) RemoveDraftAppVersionResourceMappings(input *RemoveDraftAppVersionResourceMappingsInput) (*RemoveDraftAppVersionResourceMappingsOutput, error) {
	req, out := c.RemoveDraftAppVersionResourceMappingsRequest(input)
	return out, req.Send()
}

// RemoveDraftAppVersionResourceMappingsWithContext is the same as RemoveDraftAppVersionResourceMappings with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveDraftAppVersionResourceMappings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) RemoveDraftAppVersionResourceMappingsWithContext(ctx aws.Context, input *RemoveDraftAppVersionResourceMappingsInput, opts ...request.Option) (*RemoveDraftAppVersionResourceMappingsOutput, error) {
	req, out := c.RemoveDraftAppVersionResourceMappingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResolveAppVersionResources = "ResolveAppVersionResources"

// ResolveAppVersionResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ResolveAppVersionResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResolveAppVersionResources for more information on using the ResolveAppVersionResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ResolveAppVersionResourcesRequest method.
//	req, resp := client.ResolveAppVersionResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ResolveAppVersionResources
func (c *ResilienceHub) ResolveAppVersionResourcesRequest(input *ResolveAppVersionResourcesInput) (req *request.Request, output *ResolveAppVersionResourcesOutput) {
	op := &request.Operation{
		Name:       opResolveAppVersionResources,
		HTTPMethod: "POST",
		HTTPPath:   "/resolve-app-version-resources",
	}

	if input == nil {
		input = &ResolveAppVersionResourcesInput{}
	}

	output = &ResolveAppVersionResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResolveAppVersionResources API operation for AWS Resilience Hub.
//
// Resolves the resources for an application version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation ResolveAppVersionResources for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ResolveAppVersionResources
func (c *ResilienceHub) ResolveAppVersionResources(input *ResolveAppVersionResourcesInput) (*ResolveAppVersionResourcesOutput, error) {
	req, out := c.ResolveAppVersionResourcesRequest(input)
	return out, req.Send()
}

// ResolveAppVersionResourcesWithContext is the same as ResolveAppVersionResources with the addition of
// the ability to pass a context and additional request options.
//
// See ResolveAppVersionResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) ResolveAppVersionResourcesWithContext(ctx aws.Context, input *ResolveAppVersionResourcesInput, opts ...request.Option) (*ResolveAppVersionResourcesOutput, error) {
	req, out := c.ResolveAppVersionResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartAppAssessment = "StartAppAssessment"

// StartAppAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the StartAppAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAppAssessment for more information on using the StartAppAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartAppAssessmentRequest method.
//	req, resp := client.StartAppAssessmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/StartAppAssessment
func (c *ResilienceHub) StartAppAssessmentRequest(input *StartAppAssessmentInput) (req *request.Request, output *StartAppAssessmentOutput) {
	op := &request.Operation{
		Name:       opStartAppAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/start-app-assessment",
	}

	if input == nil {
		input = &StartAppAssessmentInput{}
	}

	output = &StartAppAssessmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartAppAssessment API operation for AWS Resilience Hub.
//
// Creates a new application assessment for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation StartAppAssessment for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ServiceQuotaExceededException
//     This exception occurs when you have exceeded your service quota. To perform
//     the requested action, remove some of the relevant resources, or use Service
//     Quotas to request a service quota increase.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/StartAppAssessment
func (c *ResilienceHub) StartAppAssessment(input *StartAppAssessmentInput) (*StartAppAssessmentOutput, error) {
	req, out := c.StartAppAssessmentRequest(input)
	return out, req.Send()
}

// StartAppAssessmentWithContext is the same as StartAppAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See StartAppAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) StartAppAssessmentWithContext(ctx aws.Context, input *StartAppAssessmentInput, opts ...request.Option) (*StartAppAssessmentOutput, error) {
	req, out := c.StartAppAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/TagResource
func (c *ResilienceHub) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Resilience Hub.
//
// Applies one or more tags to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/TagResource
func (c *ResilienceHub) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UntagResource
func (c *ResilienceHub) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Resilience Hub.
//
// Removes one or more tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UntagResource
func (c *ResilienceHub) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApp = "UpdateApp"

// UpdateAppRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApp for more information on using the UpdateApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAppRequest method.
//	req, resp := client.UpdateAppRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateApp
func (c *ResilienceHub) UpdateAppRequest(input *UpdateAppInput) (req *request.Request, output *UpdateAppOutput) {
	op := &request.Operation{
		Name:       opUpdateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/update-app",
	}

	if input == nil {
		input = &UpdateAppInput{}
	}

	output = &UpdateAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApp API operation for AWS Resilience Hub.
//
// Updates an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation UpdateApp for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateApp
func (c *ResilienceHub) UpdateApp(input *UpdateAppInput) (*UpdateAppOutput, error) {
	req, out := c.UpdateAppRequest(input)
	return out, req.Send()
}

// UpdateAppWithContext is the same as UpdateApp with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) UpdateAppWithContext(ctx aws.Context, input *UpdateAppInput, opts ...request.Option) (*UpdateAppOutput, error) {
	req, out := c.UpdateAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAppVersion = "UpdateAppVersion"

// UpdateAppVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAppVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAppVersion for more information on using the UpdateAppVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAppVersionRequest method.
//	req, resp := client.UpdateAppVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateAppVersion
func (c *ResilienceHub) UpdateAppVersionRequest(input *UpdateAppVersionInput) (req *request.Request, output *UpdateAppVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateAppVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/update-app-version",
	}

	if input == nil {
		input = &UpdateAppVersionInput{}
	}

	output = &UpdateAppVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAppVersion API operation for AWS Resilience Hub.
//
// Updates the Resilience Hub application version.
//
// This API updates the Resilience Hub application draft version. To use this
// information for running resiliency assessments, you must publish the Resilience
// Hub application using the PublishAppVersion API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation UpdateAppVersion for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateAppVersion
func (c *ResilienceHub) UpdateAppVersion(input *UpdateAppVersionInput) (*UpdateAppVersionOutput, error) {
	req, out := c.UpdateAppVersionRequest(input)
	return out, req.Send()
}

// UpdateAppVersionWithContext is the same as UpdateAppVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAppVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) UpdateAppVersionWithContext(ctx aws.Context, input *UpdateAppVersionInput, opts ...request.Option) (*UpdateAppVersionOutput, error) {
	req, out := c.UpdateAppVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAppVersionAppComponent = "UpdateAppVersionAppComponent"

// UpdateAppVersionAppComponentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAppVersionAppComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAppVersionAppComponent for more information on using the UpdateAppVersionAppComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAppVersionAppComponentRequest method.
//	req, resp := client.UpdateAppVersionAppComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateAppVersionAppComponent
func (c *ResilienceHub) UpdateAppVersionAppComponentRequest(input *UpdateAppVersionAppComponentInput) (req *request.Request, output *UpdateAppVersionAppComponentOutput) {
	op := &request.Operation{
		Name:       opUpdateAppVersionAppComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/update-app-version-app-component",
	}

	if input == nil {
		input = &UpdateAppVersionAppComponentInput{}
	}

	output = &UpdateAppVersionAppComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAppVersionAppComponent API operation for AWS Resilience Hub.
//
// Updates an existing Application Component in the Resilience Hub application.
//
// This API updates the Resilience Hub application draft version. To use this
// Application Component for running assessments, you must publish the Resilience
// Hub application using the PublishAppVersion API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation UpdateAppVersionAppComponent for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateAppVersionAppComponent
func (c *ResilienceHub) UpdateAppVersionAppComponent(input *UpdateAppVersionAppComponentInput) (*UpdateAppVersionAppComponentOutput, error) {
	req, out := c.UpdateAppVersionAppComponentRequest(input)
	return out, req.Send()
}

// UpdateAppVersionAppComponentWithContext is the same as UpdateAppVersionAppComponent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAppVersionAppComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) UpdateAppVersionAppComponentWithContext(ctx aws.Context, input *UpdateAppVersionAppComponentInput, opts ...request.Option) (*UpdateAppVersionAppComponentOutput, error) {
	req, out := c.UpdateAppVersionAppComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAppVersionResource = "UpdateAppVersionResource"

// UpdateAppVersionResourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAppVersionResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAppVersionResource for more information on using the UpdateAppVersionResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAppVersionResourceRequest method.
//	req, resp := client.UpdateAppVersionResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateAppVersionResource
func (c *ResilienceHub) UpdateAppVersionResourceRequest(input *UpdateAppVersionResourceInput) (req *request.Request, output *UpdateAppVersionResourceOutput) {
	op := &request.Operation{
		Name:       opUpdateAppVersionResource,
		HTTPMethod: "POST",
		HTTPPath:   "/update-app-version-resource",
	}

	if input == nil {
		input = &UpdateAppVersionResourceInput{}
	}

	output = &UpdateAppVersionResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAppVersionResource API operation for AWS Resilience Hub.
//
// Updates the resource details in the Resilience Hub application.
//
//   - This action has no effect outside Resilience Hub.
//
//   - This API updates the Resilience Hub application draft version. To use
//     this resource for running resiliency assessments, you must publish the
//     Resilience Hub application using the PublishAppVersion API.
//
//   - To update application version with new physicalResourceID, you must
//     call ResolveAppVersionResources API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation UpdateAppVersionResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ServiceQuotaExceededException
//     This exception occurs when you have exceeded your service quota. To perform
//     the requested action, remove some of the relevant resources, or use Service
//     Quotas to request a service quota increase.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateAppVersionResource
func (c *ResilienceHub) UpdateAppVersionResource(input *UpdateAppVersionResourceInput) (*UpdateAppVersionResourceOutput, error) {
	req, out := c.UpdateAppVersionResourceRequest(input)
	return out, req.Send()
}

// UpdateAppVersionResourceWithContext is the same as UpdateAppVersionResource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAppVersionResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) UpdateAppVersionResourceWithContext(ctx aws.Context, input *UpdateAppVersionResourceInput, opts ...request.Option) (*UpdateAppVersionResourceOutput, error) {
	req, out := c.UpdateAppVersionResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResiliencyPolicy = "UpdateResiliencyPolicy"

// UpdateResiliencyPolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResiliencyPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResiliencyPolicy for more information on using the UpdateResiliencyPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateResiliencyPolicyRequest method.
//	req, resp := client.UpdateResiliencyPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateResiliencyPolicy
func (c *ResilienceHub) UpdateResiliencyPolicyRequest(input *UpdateResiliencyPolicyInput) (req *request.Request, output *UpdateResiliencyPolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateResiliencyPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/update-resiliency-policy",
	}

	if input == nil {
		input = &UpdateResiliencyPolicyInput{}
	}

	output = &UpdateResiliencyPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResiliencyPolicy API operation for AWS Resilience Hub.
//
// Updates a resiliency policy.
//
// Resilience Hub allows you to provide a value of zero for rtoInSecs and rpoInSecs
// of your resiliency policy. But, while assessing your application, the lowest
// possible assessment result is near zero. Hence, if you provide value zero
// for rtoInSecs and rpoInSecs, the estimated workload RTO and estimated workload
// RPO result will be near zero and the Compliance status for your application
// will be set to Policy breached.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resilience Hub's
// API operation UpdateResiliencyPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Resilience
//     Hub service.
//
//   - ResourceNotFoundException
//     This exception occurs when the specified resource could not be found.
//
//   - ConflictException
//     This exception occurs when a conflict with a previous successful write is
//     detected. This generally occurs when the previous write did not have time
//     to propagate to the host serving the current request. A retry (with appropriate
//     backoff logic) is the recommended response to this exception.
//
//   - ThrottlingException
//     This exception occurs when you have exceeded the limit on the number of requests
//     per second.
//
//   - ValidationException
//     This exception occurs when a request is not valid.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateResiliencyPolicy
func (c *ResilienceHub) UpdateResiliencyPolicy(input *UpdateResiliencyPolicyInput) (*UpdateResiliencyPolicyOutput, error) {
	req, out := c.UpdateResiliencyPolicyRequest(input)
	return out, req.Send()
}

// UpdateResiliencyPolicyWithContext is the same as UpdateResiliencyPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResiliencyPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResilienceHub) UpdateResiliencyPolicyWithContext(ctx aws.Context, input *UpdateResiliencyPolicyInput, opts ...request.Option) (*UpdateResiliencyPolicyOutput, error) {
	req, out := c.UpdateResiliencyPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have permissions to perform the requested operation. The user or
// role that is making the request must have at least one IAM permissions policy
// attached that grants the required permissions.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AddDraftAppVersionResourceMappingsInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Mappings used to map logical resources from the template to physical resources.
	// You can use the mapping type CFN_STACK if the application template uses a
	// logical stack name. Or you can map individual resources by using the mapping
	// type RESOURCE. We recommend using the mapping type CFN_STACK if the application
	// is backed by a CloudFormation stack.
	//
	// ResourceMappings is a required field
	ResourceMappings []*ResourceMapping `locationName:"resourceMappings" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddDraftAppVersionResourceMappingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddDraftAppVersionResourceMappingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddDraftAppVersionResourceMappingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddDraftAppVersionResourceMappingsInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.ResourceMappings == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceMappings"))
	}
	if s.ResourceMappings != nil {
		for i, v := range s.ResourceMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *AddDraftAppVersionResourceMappingsInput) SetAppArn(v string) *AddDraftAppVersionResourceMappingsInput {
	s.AppArn = &v
	return s
}

// SetResourceMappings sets the ResourceMappings field's value.
func (s *AddDraftAppVersionResourceMappingsInput) SetResourceMappings(v []*ResourceMapping) *AddDraftAppVersionResourceMappingsInput {
	s.ResourceMappings = v
	return s
}

type AddDraftAppVersionResourceMappingsOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The version of the application.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// List of sources that are used to map a logical resource from the template
	// to a physical resource. You can use sources such as CloudFormation, Terraform
	// state files, AppRegistry applications, or Amazon EKS.
	//
	// ResourceMappings is a required field
	ResourceMappings []*ResourceMapping `locationName:"resourceMappings" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddDraftAppVersionResourceMappingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddDraftAppVersionResourceMappingsOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *AddDraftAppVersionResourceMappingsOutput) SetAppArn(v string) *AddDraftAppVersionResourceMappingsOutput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *AddDraftAppVersionResourceMappingsOutput) SetAppVersion(v string) *AddDraftAppVersionResourceMappingsOutput {
	s.AppVersion = &v
	return s
}

// SetResourceMappings sets the ResourceMappings field's value.
func (s *AddDraftAppVersionResourceMappingsOutput) SetResourceMappings(v []*ResourceMapping) *AddDraftAppVersionResourceMappingsOutput {
	s.ResourceMappings = v
	return s
}

// Defines a recommendation for a CloudWatch alarm.
type AlarmRecommendation struct {
	_ struct{} `type:"structure"`

	// Application Component name for the CloudWatch alarm recommendation. This
	// name is saved as the first item in the appComponentNames list.
	//
	// Deprecated: An alarm recommendation can be attached to multiple Application Components, hence this property will be replaced by the new property 'appComponentNames'.
	AppComponentName *string `locationName:"appComponentName" deprecated:"true" type:"string"`

	// List of Application Component names for the CloudWatch alarm recommendation.
	AppComponentNames []*string `locationName:"appComponentNames" type:"list"`

	// Description of the alarm recommendation.
	Description *string `locationName:"description" type:"string"`

	// List of CloudWatch alarm recommendations.
	Items []*RecommendationItem `locationName:"items" type:"list"`

	// Name of the alarm recommendation.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The prerequisite for the alarm recommendation.
	Prerequisite *string `locationName:"prerequisite" min:"1" type:"string"`

	// Identifier of the alarm recommendation.
	//
	// RecommendationId is a required field
	RecommendationId *string `locationName:"recommendationId" type:"string" required:"true"`

	// Status of the recommended Amazon CloudWatch alarm.
	RecommendationStatus *string `locationName:"recommendationStatus" type:"string" enum:"RecommendationStatus"`

	// Reference identifier of the alarm recommendation.
	//
	// ReferenceId is a required field
	ReferenceId *string `locationName:"referenceId" min:"1" type:"string" required:"true"`

	// Type of alarm recommendation.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"AlarmType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlarmRecommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlarmRecommendation) GoString() string {
	return s.String()
}

// SetAppComponentName sets the AppComponentName field's value.
func (s *AlarmRecommendation) SetAppComponentName(v string) *AlarmRecommendation {
	s.AppComponentName = &v
	return s
}

// SetAppComponentNames sets the AppComponentNames field's value.
func (s *AlarmRecommendation) SetAppComponentNames(v []*string) *AlarmRecommendation {
	s.AppComponentNames = v
	return s
}

// SetDescription sets the Description field's value.
func (s *AlarmRecommendation) SetDescription(v string) *AlarmRecommendation {
	s.Description = &v
	return s
}

// SetItems sets the Items field's value.
func (s *AlarmRecommendation) SetItems(v []*RecommendationItem) *AlarmRecommendation {
	s.Items = v
	return s
}

// SetName sets the Name field's value.
func (s *AlarmRecommendation) SetName(v string) *AlarmRecommendation {
	s.Name = &v
	return s
}

// SetPrerequisite sets the Prerequisite field's value.
func (s *AlarmRecommendation) SetPrerequisite(v string) *AlarmRecommendation {
	s.Prerequisite = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *AlarmRecommendation) SetRecommendationId(v string) *AlarmRecommendation {
	s.RecommendationId = &v
	return s
}

// SetRecommendationStatus sets the RecommendationStatus field's value.
func (s *AlarmRecommendation) SetRecommendationStatus(v string) *AlarmRecommendation {
	s.RecommendationStatus = &v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *AlarmRecommendation) SetReferenceId(v string) *AlarmRecommendation {
	s.ReferenceId = &v
	return s
}

// SetType sets the Type field's value.
func (s *AlarmRecommendation) SetType(v string) *AlarmRecommendation {
	s.Type = &v
	return s
}

// Defines an Resilience Hub application.
type App struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Assessment execution schedule with 'Daily' or 'Disabled' values.
	AssessmentSchedule *string `locationName:"assessmentSchedule" type:"string" enum:"AppAssessmentScheduleType"`

	// Current status of compliance for the resiliency policy.
	ComplianceStatus *string `locationName:"complianceStatus" type:"string" enum:"AppComplianceStatusType"`

	// Date and time when the app was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// Optional description for an application.
	Description *string `locationName:"description" type:"string"`

	// Indicates if compliance drifts (deviations) were detected while running an
	// assessment for your application.
	DriftStatus *string `locationName:"driftStatus" type:"string" enum:"AppDriftStatusType"`

	// The list of events you would like to subscribe and get notification for.
	// Currently, Resilience Hub supports notifications only for Drift detected
	// and Scheduled assessment failure events.
	EventSubscriptions []*EventSubscription `locationName:"eventSubscriptions" type:"list"`

	// Date and time the most recent compliance evaluation.
	LastAppComplianceEvaluationTime *time.Time `locationName:"lastAppComplianceEvaluationTime" type:"timestamp"`

	// Indicates the last time that a drift was evaluated.
	LastDriftEvaluationTime *time.Time `locationName:"lastDriftEvaluationTime" type:"timestamp"`

	// Date and time the most recent resiliency score evaluation.
	LastResiliencyScoreEvaluationTime *time.Time `locationName:"lastResiliencyScoreEvaluationTime" type:"timestamp"`

	// Name for the application.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Defines the roles and credentials that Resilience Hub would use while creating
	// the application, importing its resources, and running an assessment.
	PermissionModel *PermissionModel `locationName:"permissionModel" type:"structure"`

	// Amazon Resource Name (ARN) of the resiliency policy. The format for this
	// ARN is: arn:partition:resiliencehub:region:account:resiliency-policy/policy-id.
	// For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// Current resiliency score for the application.
	ResiliencyScore *float64 `locationName:"resiliencyScore" type:"double"`

	// Recovery Point Objective (RPO) in seconds.
	RpoInSecs *int64 `locationName:"rpoInSecs" type:"integer"`

	// Recovery Time Objective (RTO) in seconds.
	RtoInSecs *int64 `locationName:"rtoInSecs" type:"integer"`

	// Status of the application.
	Status *string `locationName:"status" type:"string" enum:"AppStatusType"`

	// Tags assigned to the resource. A tag is a label that you assign to an Amazon
	// Web Services resource. Each tag consists of a key/value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by App's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s App) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s App) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *App) SetAppArn(v string) *App {
	s.AppArn = &v
	return s
}

// SetAssessmentSchedule sets the AssessmentSchedule field's value.
func (s *App) SetAssessmentSchedule(v string) *App {
	s.AssessmentSchedule = &v
	return s
}

// SetComplianceStatus sets the ComplianceStatus field's value.
func (s *App) SetComplianceStatus(v string) *App {
	s.ComplianceStatus = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *App) SetCreationTime(v time.Time) *App {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *App) SetDescription(v string) *App {
	s.Description = &v
	return s
}

// SetDriftStatus sets the DriftStatus field's value.
func (s *App) SetDriftStatus(v string) *App {
	s.DriftStatus = &v
	return s
}

// SetEventSubscriptions sets the EventSubscriptions field's value.
func (s *App) SetEventSubscriptions(v []*EventSubscription) *App {
	s.EventSubscriptions = v
	return s
}

// SetLastAppComplianceEvaluationTime sets the LastAppComplianceEvaluationTime field's value.
func (s *App) SetLastAppComplianceEvaluationTime(v time.Time) *App {
	s.LastAppComplianceEvaluationTime = &v
	return s
}

// SetLastDriftEvaluationTime sets the LastDriftEvaluationTime field's value.
func (s *App) SetLastDriftEvaluationTime(v time.Time) *App {
	s.LastDriftEvaluationTime = &v
	return s
}

// SetLastResiliencyScoreEvaluationTime sets the LastResiliencyScoreEvaluationTime field's value.
func (s *App) SetLastResiliencyScoreEvaluationTime(v time.Time) *App {
	s.LastResiliencyScoreEvaluationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *App) SetName(v string) *App {
	s.Name = &v
	return s
}

// SetPermissionModel sets the PermissionModel field's value.
func (s *App) SetPermissionModel(v *PermissionModel) *App {
	s.PermissionModel = v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *App) SetPolicyArn(v string) *App {
	s.PolicyArn = &v
	return s
}

// SetResiliencyScore sets the ResiliencyScore field's value.
func (s *App) SetResiliencyScore(v float64) *App {
	s.ResiliencyScore = &v
	return s
}

// SetRpoInSecs sets the RpoInSecs field's value.
func (s *App) SetRpoInSecs(v int64) *App {
	s.RpoInSecs = &v
	return s
}

// SetRtoInSecs sets the RtoInSecs field's value.
func (s *App) SetRtoInSecs(v int64) *App {
	s.RtoInSecs = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *App) SetStatus(v string) *App {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *App) SetTags(v map[string]*string) *App {
	s.Tags = v
	return s
}

// Defines an application assessment.
type AppAssessment struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	AppArn *string `locationName:"appArn" type:"string"`

	// Version of an application.
	AppVersion *string `locationName:"appVersion" type:"string"`

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
	// arn:partition:resiliencehub:region:account:app-assessment/app-id. For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AssessmentArn is a required field
	AssessmentArn *string `locationName:"assessmentArn" type:"string" required:"true"`

	// Name of the assessment.
	AssessmentName *string `locationName:"assessmentName" type:"string"`

	// Current status of the assessment for the resiliency policy.
	//
	// AssessmentStatus is a required field
	AssessmentStatus *string `locationName:"assessmentStatus" type:"string" required:"true" enum:"AssessmentStatus"`

	// Application compliance against the resiliency policy.
	Compliance map[string]*DisruptionCompliance `locationName:"compliance" type:"map"`

	// Current status of the compliance for the resiliency policy.
	ComplianceStatus *string `locationName:"complianceStatus" type:"string" enum:"ComplianceStatus"`

	// Cost for the application.
	Cost *Cost `locationName:"cost" type:"structure"`

	// Indicates if compliance drifts (deviations) were detected while running an
	// assessment for your application.
	DriftStatus *string `locationName:"driftStatus" type:"string" enum:"DriftStatus"`

	// End time for the action.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The entity that invoked the assessment.
	//
	// Invoker is a required field
	Invoker *string `locationName:"invoker" type:"string" required:"true" enum:"AssessmentInvoker"`

	// Error or warning message from the assessment execution
	Message *string `locationName:"message" min:"1" type:"string"`

	// Resiliency policy of an application.
	Policy *ResiliencyPolicy `locationName:"policy" type:"structure"`

	// Current resiliency score for an application.
	ResiliencyScore *ResiliencyScore `locationName:"resiliencyScore" type:"structure"`

	// A resource error object containing a list of errors retrieving an application's
	// resources.
	ResourceErrorsDetails *ResourceErrorsDetails `locationName:"resourceErrorsDetails" type:"structure"`

	// Starting time for the action.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// Tags assigned to the resource. A tag is a label that you assign to an Amazon
	// Web Services resource. Each tag consists of a key/value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppAssessment's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`

	// Version name of the published application.
	VersionName *string `locationName:"versionName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppAssessment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppAssessment) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *AppAssessment) SetAppArn(v string) *AppAssessment {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *AppAssessment) SetAppVersion(v string) *AppAssessment {
	s.AppVersion = &v
	return s
}

// SetAssessmentArn sets the AssessmentArn field's value.
func (s *AppAssessment) SetAssessmentArn(v string) *AppAssessment {
	s.AssessmentArn = &v
	return s
}

// SetAssessmentName sets the AssessmentName field's value.
func (s *AppAssessment) SetAssessmentName(v string) *AppAssessment {
	s.AssessmentName = &v
	return s
}

// SetAssessmentStatus sets the AssessmentStatus field's value.
func (s *AppAssessment) SetAssessmentStatus(v string) *AppAssessment {
	s.AssessmentStatus = &v
	return s
}

// SetCompliance sets the Compliance field's value.
func (s *AppAssessment) SetCompliance(v map[string]*DisruptionCompliance) *AppAssessment {
	s.Compliance = v
	return s
}

// SetComplianceStatus sets the ComplianceStatus field's value.
func (s *AppAssessment) SetComplianceStatus(v string) *AppAssessment {
	s.ComplianceStatus = &v
	return s
}

// SetCost sets the Cost field's value.
func (s *AppAssessment) SetCost(v *Cost) *AppAssessment {
	s.Cost = v
	return s
}

// SetDriftStatus sets the DriftStatus field's value.
func (s *AppAssessment) SetDriftStatus(v string) *AppAssessment {
	s.DriftStatus = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *AppAssessment) SetEndTime(v time.Time) *AppAssessment {
	s.EndTime = &v
	return s
}

// SetInvoker sets the Invoker field's value.
func (s *AppAssessment) SetInvoker(v string) *AppAssessment {
	s.Invoker = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AppAssessment) SetMessage(v string) *AppAssessment {
	s.Message = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *AppAssessment) SetPolicy(v *ResiliencyPolicy) *AppAssessment {
	s.Policy = v
	return s
}

// SetResiliencyScore sets the ResiliencyScore field's value.
func (s *AppAssessment) SetResiliencyScore(v *ResiliencyScore) *AppAssessment {
	s.ResiliencyScore = v
	return s
}

// SetResourceErrorsDetails sets the ResourceErrorsDetails field's value.
func (s *AppAssessment) SetResourceErrorsDetails(v *ResourceErrorsDetails) *AppAssessment {
	s.ResourceErrorsDetails = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AppAssessment) SetStartTime(v time.Time) *AppAssessment {
	s.StartTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AppAssessment) SetTags(v map[string]*string) *AppAssessment {
	s.Tags = v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *AppAssessment) SetVersionName(v string) *AppAssessment {
	s.VersionName = &v
	return s
}

// Defines an application assessment summary.
type AppAssessmentSummary struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	AppArn *string `locationName:"appArn" type:"string"`

	// Version of an application.
	AppVersion *string `locationName:"appVersion" type:"string"`

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
	// arn:partition:resiliencehub:region:account:app-assessment/app-id. For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AssessmentArn is a required field
	AssessmentArn *string `locationName:"assessmentArn" type:"string" required:"true"`

	// Name of the assessment.
	AssessmentName *string `locationName:"assessmentName" type:"string"`

	// Current status of the assessment for the resiliency policy.
	//
	// AssessmentStatus is a required field
	AssessmentStatus *string `locationName:"assessmentStatus" type:"string" required:"true" enum:"AssessmentStatus"`

	// TCurrent status of compliance for the resiliency policy.
	ComplianceStatus *string `locationName:"complianceStatus" type:"string" enum:"ComplianceStatus"`

	// Cost for an application.
	Cost *Cost `locationName:"cost" type:"structure"`

	// Indicates if compliance drifts (deviations) were detected while running an
	// assessment for your application.
	DriftStatus *string `locationName:"driftStatus" type:"string" enum:"DriftStatus"`

	// End time for the action.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// Entity that invoked the assessment.
	Invoker *string `locationName:"invoker" type:"string" enum:"AssessmentInvoker"`

	// Message from the assessment run.
	Message *string `locationName:"message" min:"1" type:"string"`

	// Current resiliency score for the application.
	ResiliencyScore *float64 `locationName:"resiliencyScore" type:"double"`

	// Starting time for the action.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// Name of an application version.
	VersionName *string `locationName:"versionName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppAssessmentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppAssessmentSummary) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *AppAssessmentSummary) SetAppArn(v string) *AppAssessmentSummary {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *AppAssessmentSummary) SetAppVersion(v string) *AppAssessmentSummary {
	s.AppVersion = &v
	return s
}

// SetAssessmentArn sets the AssessmentArn field's value.
func (s *AppAssessmentSummary) SetAssessmentArn(v string) *AppAssessmentSummary {
	s.AssessmentArn = &v
	return s
}

// SetAssessmentName sets the AssessmentName field's value.
func (s *AppAssessmentSummary) SetAssessmentName(v string) *AppAssessmentSummary {
	s.AssessmentName = &v
	return s
}

// SetAssessmentStatus sets the AssessmentStatus field's value.
func (s *AppAssessmentSummary) SetAssessmentStatus(v string) *AppAssessmentSummary {
	s.AssessmentStatus = &v
	return s
}

// SetComplianceStatus sets the ComplianceStatus field's value.
func (s *AppAssessmentSummary) SetComplianceStatus(v string) *AppAssessmentSummary {
	s.ComplianceStatus = &v
	return s
}

// SetCost sets the Cost field's value.
func (s *AppAssessmentSummary) SetCost(v *Cost) *AppAssessmentSummary {
	s.Cost = v
	return s
}

// SetDriftStatus sets the DriftStatus field's value.
func (s *AppAssessmentSummary) SetDriftStatus(v string) *AppAssessmentSummary {
	s.DriftStatus = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *AppAssessmentSummary) SetEndTime(v time.Time) *AppAssessmentSummary {
	s.EndTime = &v
	return s
}

// SetInvoker sets the Invoker field's value.
func (s *AppAssessmentSummary) SetInvoker(v string) *AppAssessmentSummary {
	s.Invoker = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AppAssessmentSummary) SetMessage(v string) *AppAssessmentSummary {
	s.Message = &v
	return s
}

// SetResiliencyScore sets the ResiliencyScore field's value.
func (s *AppAssessmentSummary) SetResiliencyScore(v float64) *AppAssessmentSummary {
	s.ResiliencyScore = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AppAssessmentSummary) SetStartTime(v time.Time) *AppAssessmentSummary {
	s.StartTime = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *AppAssessmentSummary) SetVersionName(v string) *AppAssessmentSummary {
	s.VersionName = &v
	return s
}

// Defines an Application Component.
type AppComponent struct {
	_ struct{} `type:"structure"`

	// Additional configuration parameters for an Resilience Hub application. If
	// you want to implement additionalInfo through the Resilience Hub console rather
	// than using an API call, see Configure the application configuration parameters
	// (https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
	//
	// Currently, this parameter accepts a key-value mapping (in a string format)
	// of only one failover region and one associated account.
	//
	// Key: "failover-regions"
	//
	// Value: "[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"
	AdditionalInfo map[string][]*string `locationName:"additionalInfo" type:"map"`

	// Identifier of the Application Component.
	Id *string `locationName:"id" min:"1" type:"string"`

	// Name of the Application Component.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The type of Application Component.
	//
	// Type is a required field
	Type *string `locationName:"type" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppComponent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppComponent) GoString() string {
	return s.String()
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *AppComponent) SetAdditionalInfo(v map[string][]*string) *AppComponent {
	s.AdditionalInfo = v
	return s
}

// SetId sets the Id field's value.
func (s *AppComponent) SetId(v string) *AppComponent {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppComponent) SetName(v string) *AppComponent {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AppComponent) SetType(v string) *AppComponent {
	s.Type = &v
	return s
}

// Defines the compliance of an Application Component against the resiliency
// policy.
type AppComponentCompliance struct {
	_ struct{} `type:"structure"`

	// Name of the Application Component.
	AppComponentName *string `locationName:"appComponentName" type:"string"`

	// The compliance of the Application Component against the resiliency policy.
	Compliance map[string]*DisruptionCompliance `locationName:"compliance" type:"map"`

	// The cost for the application.
	Cost *Cost `locationName:"cost" type:"structure"`

	// The compliance message.
	Message *string `locationName:"message" min:"1" type:"string"`

	// The current resiliency score for the application.
	ResiliencyScore *ResiliencyScore `locationName:"resiliencyScore" type:"structure"`

	// Status of the action.
	Status *string `locationName:"status" type:"string" enum:"ComplianceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppComponentCompliance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppComponentCompliance) GoString() string {
	return s.String()
}

// SetAppComponentName sets the AppComponentName field's value.
func (s *AppComponentCompliance) SetAppComponentName(v string) *AppComponentCompliance {
	s.AppComponentName = &v
	return s
}

// SetCompliance sets the Compliance field's value.
func (s *AppComponentCompliance) SetCompliance(v map[string]*DisruptionCompliance) *AppComponentCompliance {
	s.Compliance = v
	return s
}

// SetCost sets the Cost field's value.
func (s *AppComponentCompliance) SetCost(v *Cost) *AppComponentCompliance {
	s.Cost = v
	return s
}

// SetMessage sets the Message field's value.
func (s *AppComponentCompliance) SetMessage(v string) *AppComponentCompliance {
	s.Message = &v
	return s
}

// SetResiliencyScore sets the ResiliencyScore field's value.
func (s *AppComponentCompliance) SetResiliencyScore(v *ResiliencyScore) *AppComponentCompliance {
	s.ResiliencyScore = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AppComponentCompliance) SetStatus(v string) *AppComponentCompliance {
	s.Status = &v
	return s
}

// The list of Resilience Hub application input sources.
type AppInputSource struct {
	_ struct{} `type:"structure"`

	// The namespace on your Amazon Elastic Kubernetes Service cluster.
	EksSourceClusterNamespace *EksSourceClusterNamespace `locationName:"eksSourceClusterNamespace" type:"structure"`

	// The resource type of the input source.
	//
	// ImportType is a required field
	ImportType *string `locationName:"importType" type:"string" required:"true" enum:"ResourceMappingType"`

	// The number of resources.
	ResourceCount *int64 `locationName:"resourceCount" type:"integer"`

	// The Amazon Resource Name (ARN) of the input source. For more information
	// about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	SourceArn *string `locationName:"sourceArn" type:"string"`

	// The name of the input source.
	SourceName *string `locationName:"sourceName" min:"1" type:"string"`

	// The name of the Terraform s3 state ﬁle.
	TerraformSource *TerraformSource `locationName:"terraformSource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInputSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInputSource) GoString() string {
	return s.String()
}

// SetEksSourceClusterNamespace sets the EksSourceClusterNamespace field's value.
func (s *AppInputSource) SetEksSourceClusterNamespace(v *EksSourceClusterNamespace) *AppInputSource {
	s.EksSourceClusterNamespace = v
	return s
}

// SetImportType sets the ImportType field's value.
func (s *AppInputSource) SetImportType(v string) *AppInputSource {
	s.ImportType = &v
	return s
}

// SetResourceCount sets the ResourceCount field's value.
func (s *AppInputSource) SetResourceCount(v int64) *AppInputSource {
	s.ResourceCount = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *AppInputSource) SetSourceArn(v string) *AppInputSource {
	s.SourceArn = &v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *AppInputSource) SetSourceName(v string) *AppInputSource {
	s.SourceName = &v
	return s
}

// SetTerraformSource sets the TerraformSource field's value.
func (s *AppInputSource) SetTerraformSource(v *TerraformSource) *AppInputSource {
	s.TerraformSource = v
	return s
}

// Defines an application summary.
type AppSummary struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Assessment execution schedule with 'Daily' or 'Disabled' values.
	AssessmentSchedule *string `locationName:"assessmentSchedule" type:"string" enum:"AppAssessmentScheduleType"`

	// The current status of compliance for the resiliency policy.
	ComplianceStatus *string `locationName:"complianceStatus" type:"string" enum:"AppComplianceStatusType"`

	// Date and time when the app was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The optional description for an app.
	Description *string `locationName:"description" type:"string"`

	// Indicates if compliance drifts (deviations) were detected while running an
	// assessment for your application.
	DriftStatus *string `locationName:"driftStatus" type:"string" enum:"AppDriftStatusType"`

	// Date and time of the most recent compliance evaluation.
	LastAppComplianceEvaluationTime *time.Time `locationName:"lastAppComplianceEvaluationTime" type:"timestamp"`

	// The name of the application.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The current resiliency score for the application.
	ResiliencyScore *float64 `locationName:"resiliencyScore" type:"double"`

	// Recovery Point Objective (RPO) in seconds.
	RpoInSecs *int64 `locationName:"rpoInSecs" type:"integer"`

	// Recovery Time Objective (RTO) in seconds.
	RtoInSecs *int64 `locationName:"rtoInSecs" type:"integer"`

	// Status of the application.
	Status *string `locationName:"status" type:"string" enum:"AppStatusType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppSummary) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *AppSummary) SetAppArn(v string) *AppSummary {
	s.AppArn = &v
	return s
}

// SetAssessmentSchedule sets the AssessmentSchedule field's value.
func (s *AppSummary) SetAssessmentSchedule(v string) *AppSummary {
	s.AssessmentSchedule = &v
	return s
}

// SetComplianceStatus sets the ComplianceStatus field's value.
func (s *AppSummary) SetComplianceStatus(v string) *AppSummary {
	s.ComplianceStatus = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AppSummary) SetCreationTime(v time.Time) *AppSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AppSummary) SetDescription(v string) *AppSummary {
	s.Description = &v
	return s
}

// SetDriftStatus sets the DriftStatus field's value.
func (s *AppSummary) SetDriftStatus(v string) *AppSummary {
	s.DriftStatus = &v
	return s
}

// SetLastAppComplianceEvaluationTime sets the LastAppComplianceEvaluationTime field's value.
func (s *AppSummary) SetLastAppComplianceEvaluationTime(v time.Time) *AppSummary {
	s.LastAppComplianceEvaluationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppSummary) SetName(v string) *AppSummary {
	s.Name = &v
	return s
}

// SetResiliencyScore sets the ResiliencyScore field's value.
func (s *AppSummary) SetResiliencyScore(v float64) *AppSummary {
	s.ResiliencyScore = &v
	return s
}

// SetRpoInSecs sets the RpoInSecs field's value.
func (s *AppSummary) SetRpoInSecs(v int64) *AppSummary {
	s.RpoInSecs = &v
	return s
}

// SetRtoInSecs sets the RtoInSecs field's value.
func (s *AppSummary) SetRtoInSecs(v int64) *AppSummary {
	s.RtoInSecs = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AppSummary) SetStatus(v string) *AppSummary {
	s.Status = &v
	return s
}

// Version of an application.
type AppVersionSummary struct {
	_ struct{} `type:"structure"`

	// Version of an application.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// Creation time of the application version.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// Identifier of the application version.
	Identifier *int64 `locationName:"identifier" type:"long"`

	// Name of the application version.
	VersionName *string `locationName:"versionName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppVersionSummary) GoString() string {
	return s.String()
}

// SetAppVersion sets the AppVersion field's value.
func (s *AppVersionSummary) SetAppVersion(v string) *AppVersionSummary {
	s.AppVersion = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AppVersionSummary) SetCreationTime(v time.Time) *AppVersionSummary {
	s.CreationTime = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *AppVersionSummary) SetIdentifier(v int64) *AppVersionSummary {
	s.Identifier = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *AppVersionSummary) SetVersionName(v string) *AppVersionSummary {
	s.VersionName = &v
	return s
}

// List of operational recommendations that did not get included or excluded.
type BatchUpdateRecommendationStatusFailedEntry struct {
	_ struct{} `type:"structure"`

	// An identifier of an entry in this batch that is used to communicate the result.
	//
	// The entryIds of a batch request need to be unique within a request.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// Indicates the error that occurred while excluding an operational recommendation.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `locationName:"errorMessage" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateRecommendationStatusFailedEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateRecommendationStatusFailedEntry) GoString() string {
	return s.String()
}

// SetEntryId sets the EntryId field's value.
func (s *BatchUpdateRecommendationStatusFailedEntry) SetEntryId(v string) *BatchUpdateRecommendationStatusFailedEntry {
	s.EntryId = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchUpdateRecommendationStatusFailedEntry) SetErrorMessage(v string) *BatchUpdateRecommendationStatusFailedEntry {
	s.ErrorMessage = &v
	return s
}

type BatchUpdateRecommendationStatusInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Defines the list of operational recommendations that need to be included
	// or excluded.
	//
	// RequestEntries is a required field
	RequestEntries []*UpdateRecommendationStatusRequestEntry `locationName:"requestEntries" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateRecommendationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateRecommendationStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateRecommendationStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateRecommendationStatusInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.RequestEntries == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestEntries"))
	}
	if s.RequestEntries != nil && len(s.RequestEntries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestEntries", 1))
	}
	if s.RequestEntries != nil {
		for i, v := range s.RequestEntries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RequestEntries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *BatchUpdateRecommendationStatusInput) SetAppArn(v string) *BatchUpdateRecommendationStatusInput {
	s.AppArn = &v
	return s
}

// SetRequestEntries sets the RequestEntries field's value.
func (s *BatchUpdateRecommendationStatusInput) SetRequestEntries(v []*UpdateRecommendationStatusRequestEntry) *BatchUpdateRecommendationStatusInput {
	s.RequestEntries = v
	return s
}

type BatchUpdateRecommendationStatusOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// A list of items with error details about each item, which could not be included
	// or excluded.
	//
	// FailedEntries is a required field
	FailedEntries []*BatchUpdateRecommendationStatusFailedEntry `locationName:"failedEntries" type:"list" required:"true"`

	// A list of items that were included or excluded.
	//
	// SuccessfulEntries is a required field
	SuccessfulEntries []*BatchUpdateRecommendationStatusSuccessfulEntry `locationName:"successfulEntries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateRecommendationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateRecommendationStatusOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *BatchUpdateRecommendationStatusOutput) SetAppArn(v string) *BatchUpdateRecommendationStatusOutput {
	s.AppArn = &v
	return s
}

// SetFailedEntries sets the FailedEntries field's value.
func (s *BatchUpdateRecommendationStatusOutput) SetFailedEntries(v []*BatchUpdateRecommendationStatusFailedEntry) *BatchUpdateRecommendationStatusOutput {
	s.FailedEntries = v
	return s
}

// SetSuccessfulEntries sets the SuccessfulEntries field's value.
func (s *BatchUpdateRecommendationStatusOutput) SetSuccessfulEntries(v []*BatchUpdateRecommendationStatusSuccessfulEntry) *BatchUpdateRecommendationStatusOutput {
	s.SuccessfulEntries = v
	return s
}

// List of operational recommendations that were successfully included or excluded.
type BatchUpdateRecommendationStatusSuccessfulEntry struct {
	_ struct{} `type:"structure"`

	// An identifier for an entry in this batch that is used to communicate the
	// result.
	//
	// The entryIds of a batch request need to be unique within a request.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// Indicates the reason for excluding an operational recommendation.
	ExcludeReason *string `locationName:"excludeReason" type:"string" enum:"ExcludeRecommendationReason"`

	// Indicates if the operational recommendation was successfully excluded.
	//
	// Excluded is a required field
	Excluded *bool `locationName:"excluded" type:"boolean" required:"true"`

	// The operational recommendation item.
	//
	// Item is a required field
	Item *UpdateRecommendationStatusItem `locationName:"item" type:"structure" required:"true"`

	// Reference identifier of the operational recommendation.
	//
	// ReferenceId is a required field
	ReferenceId *string `locationName:"referenceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateRecommendationStatusSuccessfulEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateRecommendationStatusSuccessfulEntry) GoString() string {
	return s.String()
}

// SetEntryId sets the EntryId field's value.
func (s *BatchUpdateRecommendationStatusSuccessfulEntry) SetEntryId(v string) *BatchUpdateRecommendationStatusSuccessfulEntry {
	s.EntryId = &v
	return s
}

// SetExcludeReason sets the ExcludeReason field's value.
func (s *BatchUpdateRecommendationStatusSuccessfulEntry) SetExcludeReason(v string) *BatchUpdateRecommendationStatusSuccessfulEntry {
	s.ExcludeReason = &v
	return s
}

// SetExcluded sets the Excluded field's value.
func (s *BatchUpdateRecommendationStatusSuccessfulEntry) SetExcluded(v bool) *BatchUpdateRecommendationStatusSuccessfulEntry {
	s.Excluded = &v
	return s
}

// SetItem sets the Item field's value.
func (s *BatchUpdateRecommendationStatusSuccessfulEntry) SetItem(v *UpdateRecommendationStatusItem) *BatchUpdateRecommendationStatusSuccessfulEntry {
	s.Item = v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *BatchUpdateRecommendationStatusSuccessfulEntry) SetReferenceId(v string) *BatchUpdateRecommendationStatusSuccessfulEntry {
	s.ReferenceId = &v
	return s
}

// Indicates the compliance drifts (recovery time objective (RTO) and recovery
// point objective (RPO)) that were detected for an assessed entity.
type ComplianceDrift struct {
	_ struct{} `type:"structure"`

	// Assessment identifier that is associated with this drift item.
	ActualReferenceId *string `locationName:"actualReferenceId" min:"1" type:"string"`

	// Actual compliance value of the entity.
	ActualValue map[string]*DisruptionCompliance `locationName:"actualValue" type:"map"`

	// Identifier of your application.
	AppId *string `locationName:"appId" min:"1" type:"string"`

	// Published version of your application on which drift was detected.
	AppVersion *string `locationName:"appVersion" min:"1" type:"string"`

	// Difference type between actual and expected recovery point objective (RPO)
	// and recovery time objective (RTO) values. Currently, Resilience Hub supports
	// only NotEqual difference type.
	DiffType *string `locationName:"diffType" type:"string" enum:"DifferenceType"`

	// The type of drift detected. Currently, Resilience Hub supports only ApplicationCompliance
	// drift type.
	DriftType *string `locationName:"driftType" type:"string" enum:"DriftType"`

	// Identifier of an entity in which drift was detected. For compliance drift,
	// the entity ID can be either application ID or the AppComponent ID.
	EntityId *string `locationName:"entityId" min:"1" type:"string"`

	// The type of entity in which drift was detected. For compliance drifts, Resilience
	// Hub supports AWS::ResilienceHub::AppComponent and AWS::ResilienceHub::Application.
	EntityType *string `locationName:"entityType" min:"1" type:"string"`

	// Assessment identifier of a previous assessment of the same application version.
	// Resilience Hub uses the previous assessment (associated with the reference
	// identifier) to compare the compliance with the current assessment to identify
	// drifts.
	ExpectedReferenceId *string `locationName:"expectedReferenceId" min:"1" type:"string"`

	// The expected compliance value of an entity.
	ExpectedValue map[string]*DisruptionCompliance `locationName:"expectedValue" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComplianceDrift) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComplianceDrift) GoString() string {
	return s.String()
}

// SetActualReferenceId sets the ActualReferenceId field's value.
func (s *ComplianceDrift) SetActualReferenceId(v string) *ComplianceDrift {
	s.ActualReferenceId = &v
	return s
}

// SetActualValue sets the ActualValue field's value.
func (s *ComplianceDrift) SetActualValue(v map[string]*DisruptionCompliance) *ComplianceDrift {
	s.ActualValue = v
	return s
}

// SetAppId sets the AppId field's value.
func (s *ComplianceDrift) SetAppId(v string) *ComplianceDrift {
	s.AppId = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *ComplianceDrift) SetAppVersion(v string) *ComplianceDrift {
	s.AppVersion = &v
	return s
}

// SetDiffType sets the DiffType field's value.
func (s *ComplianceDrift) SetDiffType(v string) *ComplianceDrift {
	s.DiffType = &v
	return s
}

// SetDriftType sets the DriftType field's value.
func (s *ComplianceDrift) SetDriftType(v string) *ComplianceDrift {
	s.DriftType = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *ComplianceDrift) SetEntityId(v string) *ComplianceDrift {
	s.EntityId = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *ComplianceDrift) SetEntityType(v string) *ComplianceDrift {
	s.EntityType = &v
	return s
}

// SetExpectedReferenceId sets the ExpectedReferenceId field's value.
func (s *ComplianceDrift) SetExpectedReferenceId(v string) *ComplianceDrift {
	s.ExpectedReferenceId = &v
	return s
}

// SetExpectedValue sets the ExpectedValue field's value.
func (s *ComplianceDrift) SetExpectedValue(v map[string]*DisruptionCompliance) *ComplianceDrift {
	s.ExpectedValue = v
	return s
}

// Defines recommendations for an Resilience Hub Application Component, returned
// as an object. This object contains component names, configuration recommendations,
// and recommendation statuses.
type ComponentRecommendation struct {
	_ struct{} `type:"structure"`

	// Name of the Application Component.
	//
	// AppComponentName is a required field
	AppComponentName *string `locationName:"appComponentName" type:"string" required:"true"`

	// List of recommendations.
	//
	// ConfigRecommendations is a required field
	ConfigRecommendations []*ConfigRecommendation `locationName:"configRecommendations" type:"list" required:"true"`

	// Status of the recommendation.
	//
	// RecommendationStatus is a required field
	RecommendationStatus *string `locationName:"recommendationStatus" type:"string" required:"true" enum:"RecommendationComplianceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentRecommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentRecommendation) GoString() string {
	return s.String()
}

// SetAppComponentName sets the AppComponentName field's value.
func (s *ComponentRecommendation) SetAppComponentName(v string) *ComponentRecommendation {
	s.AppComponentName = &v
	return s
}

// SetConfigRecommendations sets the ConfigRecommendations field's value.
func (s *ComponentRecommendation) SetConfigRecommendations(v []*ConfigRecommendation) *ComponentRecommendation {
	s.ConfigRecommendations = v
	return s
}

// SetRecommendationStatus sets the RecommendationStatus field's value.
func (s *ComponentRecommendation) SetRecommendationStatus(v string) *ComponentRecommendation {
	s.RecommendationStatus = &v
	return s
}

// Defines a recommendation configuration.
type ConfigRecommendation struct {
	_ struct{} `type:"structure"`

	// Name of the Application Component.
	AppComponentName *string `locationName:"appComponentName" type:"string"`

	// The current compliance against the resiliency policy before applying the
	// configuration change.
	Compliance map[string]*DisruptionCompliance `locationName:"compliance" type:"map"`

	// The cost for the application.
	Cost *Cost `locationName:"cost" type:"structure"`

	// The optional description for an app.
	Description *string `locationName:"description" type:"string"`

	// The architecture type.
	HaArchitecture *string `locationName:"haArchitecture" type:"string" enum:"HaArchitecture"`

	// The name of the recommendation configuration.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The type of optimization.
	//
	// OptimizationType is a required field
	OptimizationType *string `locationName:"optimizationType" type:"string" required:"true" enum:"ConfigRecommendationOptimizationType"`

	// The expected compliance against the resiliency policy after applying the
	// configuration change.
	RecommendationCompliance map[string]*RecommendationDisruptionCompliance `locationName:"recommendationCompliance" type:"map"`

	// Reference identifier for the recommendation configuration.
	//
	// ReferenceId is a required field
	ReferenceId *string `locationName:"referenceId" min:"1" type:"string" required:"true"`

	// List of the suggested configuration changes.
	SuggestedChanges []*string `locationName:"suggestedChanges" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigRecommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigRecommendation) GoString() string {
	return s.String()
}

// SetAppComponentName sets the AppComponentName field's value.
func (s *ConfigRecommendation) SetAppComponentName(v string) *ConfigRecommendation {
	s.AppComponentName = &v
	return s
}

// SetCompliance sets the Compliance field's value.
func (s *ConfigRecommendation) SetCompliance(v map[string]*DisruptionCompliance) *ConfigRecommendation {
	s.Compliance = v
	return s
}

// SetCost sets the Cost field's value.
func (s *ConfigRecommendation) SetCost(v *Cost) *ConfigRecommendation {
	s.Cost = v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConfigRecommendation) SetDescription(v string) *ConfigRecommendation {
	s.Description = &v
	return s
}

// SetHaArchitecture sets the HaArchitecture field's value.
func (s *ConfigRecommendation) SetHaArchitecture(v string) *ConfigRecommendation {
	s.HaArchitecture = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConfigRecommendation) SetName(v string) *ConfigRecommendation {
	s.Name = &v
	return s
}

// SetOptimizationType sets the OptimizationType field's value.
func (s *ConfigRecommendation) SetOptimizationType(v string) *ConfigRecommendation {
	s.OptimizationType = &v
	return s
}

// SetRecommendationCompliance sets the RecommendationCompliance field's value.
func (s *ConfigRecommendation) SetRecommendationCompliance(v map[string]*RecommendationDisruptionCompliance) *ConfigRecommendation {
	s.RecommendationCompliance = v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *ConfigRecommendation) SetReferenceId(v string) *ConfigRecommendation {
	s.ReferenceId = &v
	return s
}

// SetSuggestedChanges sets the SuggestedChanges field's value.
func (s *ConfigRecommendation) SetSuggestedChanges(v []*string) *ConfigRecommendation {
	s.SuggestedChanges = v
	return s
}

// This exception occurs when a conflict with a previous successful write is
// detected. This generally occurs when the previous write did not have time
// to propagate to the host serving the current request. A retry (with appropriate
// backoff logic) is the recommended response to this exception.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The identifier of the resource that the exception applies to.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of the resource that the exception applies to.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Defines a cost object.
type Cost struct {
	_ struct{} `type:"structure"`

	// The cost amount.
	//
	// Amount is a required field
	Amount *float64 `locationName:"amount" type:"double" required:"true"`

	// The cost currency, for example USD.
	//
	// Currency is a required field
	Currency *string `locationName:"currency" type:"string" required:"true"`

	// The cost frequency.
	//
	// Frequency is a required field
	Frequency *string `locationName:"frequency" type:"string" required:"true" enum:"CostFrequency"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cost) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cost) GoString() string {
	return s.String()
}

// SetAmount sets the Amount field's value.
func (s *Cost) SetAmount(v float64) *Cost {
	s.Amount = &v
	return s
}

// SetCurrency sets the Currency field's value.
func (s *Cost) SetCurrency(v string) *Cost {
	s.Currency = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *Cost) SetFrequency(v string) *Cost {
	s.Frequency = &v
	return s
}

type CreateAppInput struct {
	_ struct{} `type:"structure"`

	// Assessment execution schedule with 'Daily' or 'Disabled' values.
	AssessmentSchedule *string `locationName:"assessmentSchedule" type:"string" enum:"AppAssessmentScheduleType"`

	// Used for an idempotency token. A client token is a unique, case-sensitive
	// string of up to 64 ASCII characters. You should not reuse the same client
	// token for other API requests.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The optional description for an app.
	Description *string `locationName:"description" type:"string"`

	// The list of events you would like to subscribe and get notification for.
	// Currently, Resilience Hub supports only Drift detected and Scheduled assessment
	// failure events notification.
	EventSubscriptions []*EventSubscription `locationName:"eventSubscriptions" type:"list"`

	// Name of the application.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Defines the roles and credentials that Resilience Hub would use while creating
	// the application, importing its resources, and running an assessment.
	PermissionModel *PermissionModel `locationName:"permissionModel" type:"structure"`

	// Amazon Resource Name (ARN) of the resiliency policy. The format for this
	// ARN is: arn:partition:resiliencehub:region:account:resiliency-policy/policy-id.
	// For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// Tags assigned to the resource. A tag is a label that you assign to an Amazon
	// Web Services resource. Each tag consists of a key/value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAppInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.EventSubscriptions != nil {
		for i, v := range s.EventSubscriptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EventSubscriptions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PermissionModel != nil {
		if err := s.PermissionModel.Validate(); err != nil {
			invalidParams.AddNested("PermissionModel", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentSchedule sets the AssessmentSchedule field's value.
func (s *CreateAppInput) SetAssessmentSchedule(v string) *CreateAppInput {
	s.AssessmentSchedule = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAppInput) SetClientToken(v string) *CreateAppInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAppInput) SetDescription(v string) *CreateAppInput {
	s.Description = &v
	return s
}

// SetEventSubscriptions sets the EventSubscriptions field's value.
func (s *CreateAppInput) SetEventSubscriptions(v []*EventSubscription) *CreateAppInput {
	s.EventSubscriptions = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAppInput) SetName(v string) *CreateAppInput {
	s.Name = &v
	return s
}

// SetPermissionModel sets the PermissionModel field's value.
func (s *CreateAppInput) SetPermissionModel(v *PermissionModel) *CreateAppInput {
	s.PermissionModel = v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *CreateAppInput) SetPolicyArn(v string) *CreateAppInput {
	s.PolicyArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAppInput) SetTags(v map[string]*string) *CreateAppInput {
	s.Tags = v
	return s
}

type CreateAppOutput struct {
	_ struct{} `type:"structure"`

	// The created application returned as an object with details including compliance
	// status, creation time, description, resiliency score, and more.
	//
	// App is a required field
	App *App `locationName:"app" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppOutput) GoString() string {
	return s.String()
}

// SetApp sets the App field's value.
func (s *CreateAppOutput) SetApp(v *App) *CreateAppOutput {
	s.App = v
	return s
}

type CreateAppVersionAppComponentInput struct {
	_ struct{} `type:"structure"`

	// Currently, there is no supported additional information for Application Components.
	AdditionalInfo map[string][]*string `locationName:"additionalInfo" type:"map"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Used for an idempotency token. A client token is a unique, case-sensitive
	// string of up to 64 ASCII characters. You should not reuse the same client
	// token for other API requests.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Identifier of the Application Component.
	Id *string `locationName:"id" min:"1" type:"string"`

	// Name of the Application Component.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Type of Application Component. For more information about the types of Application
	// Component, see Grouping resources in an AppComponent (https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html).
	//
	// Type is a required field
	Type *string `locationName:"type" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppVersionAppComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppVersionAppComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppVersionAppComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppVersionAppComponentInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *CreateAppVersionAppComponentInput) SetAdditionalInfo(v map[string][]*string) *CreateAppVersionAppComponentInput {
	s.AdditionalInfo = v
	return s
}

// SetAppArn sets the AppArn field's value.
func (s *CreateAppVersionAppComponentInput) SetAppArn(v string) *CreateAppVersionAppComponentInput {
	s.AppArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAppVersionAppComponentInput) SetClientToken(v string) *CreateAppVersionAppComponentInput {
	s.ClientToken = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateAppVersionAppComponentInput) SetId(v string) *CreateAppVersionAppComponentInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAppVersionAppComponentInput) SetName(v string) *CreateAppVersionAppComponentInput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateAppVersionAppComponentInput) SetType(v string) *CreateAppVersionAppComponentInput {
	s.Type = &v
	return s
}

type CreateAppVersionAppComponentOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// List of Application Components that belong to this resource.
	AppComponent *AppComponent `locationName:"appComponent" type:"structure"`

	// Resilience Hub application version.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppVersionAppComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppVersionAppComponentOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *CreateAppVersionAppComponentOutput) SetAppArn(v string) *CreateAppVersionAppComponentOutput {
	s.AppArn = &v
	return s
}

// SetAppComponent sets the AppComponent field's value.
func (s *CreateAppVersionAppComponentOutput) SetAppComponent(v *AppComponent) *CreateAppVersionAppComponentOutput {
	s.AppComponent = v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *CreateAppVersionAppComponentOutput) SetAppVersion(v string) *CreateAppVersionAppComponentOutput {
	s.AppVersion = &v
	return s
}

type CreateAppVersionResourceInput struct {
	_ struct{} `type:"structure"`

	// Currently, there is no supported additional information for resources.
	AdditionalInfo map[string][]*string `locationName:"additionalInfo" type:"map"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// List of Application Components that this resource belongs to. If an Application
	// Component is not part of the Resilience Hub application, it will be added.
	//
	// AppComponents is a required field
	AppComponents []*string `locationName:"appComponents" type:"list" required:"true"`

	// Amazon Web Services account that owns the physical resource.
	AwsAccountId *string `locationName:"awsAccountId" type:"string"`

	// Amazon Web Services region that owns the physical resource.
	AwsRegion *string `locationName:"awsRegion" type:"string"`

	// Used for an idempotency token. A client token is a unique, case-sensitive
	// string of up to 64 ASCII characters. You should not reuse the same client
	// token for other API requests.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Logical identifier of the resource.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *LogicalResourceId `locationName:"logicalResourceId" type:"structure" required:"true"`

	// Physical identifier of the resource.
	//
	// PhysicalResourceId is a required field
	PhysicalResourceId *string `locationName:"physicalResourceId" min:"1" type:"string" required:"true"`

	// Name of the resource.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// Type of resource.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppVersionResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppVersionResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppVersionResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppVersionResourceInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.AppComponents == nil {
		invalidParams.Add(request.NewErrParamRequired("AppComponents"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.LogicalResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("LogicalResourceId"))
	}
	if s.PhysicalResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhysicalResourceId"))
	}
	if s.PhysicalResourceId != nil && len(*s.PhysicalResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhysicalResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}
	if s.LogicalResourceId != nil {
		if err := s.LogicalResourceId.Validate(); err != nil {
			invalidParams.AddNested("LogicalResourceId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *CreateAppVersionResourceInput) SetAdditionalInfo(v map[string][]*string) *CreateAppVersionResourceInput {
	s.AdditionalInfo = v
	return s
}

// SetAppArn sets the AppArn field's value.
func (s *CreateAppVersionResourceInput) SetAppArn(v string) *CreateAppVersionResourceInput {
	s.AppArn = &v
	return s
}

// SetAppComponents sets the AppComponents field's value.
func (s *CreateAppVersionResourceInput) SetAppComponents(v []*string) *CreateAppVersionResourceInput {
	s.AppComponents = v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateAppVersionResourceInput) SetAwsAccountId(v string) *CreateAppVersionResourceInput {
	s.AwsAccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *CreateAppVersionResourceInput) SetAwsRegion(v string) *CreateAppVersionResourceInput {
	s.AwsRegion = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAppVersionResourceInput) SetClientToken(v string) *CreateAppVersionResourceInput {
	s.ClientToken = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *CreateAppVersionResourceInput) SetLogicalResourceId(v *LogicalResourceId) *CreateAppVersionResourceInput {
	s.LogicalResourceId = v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *CreateAppVersionResourceInput) SetPhysicalResourceId(v string) *CreateAppVersionResourceInput {
	s.PhysicalResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *CreateAppVersionResourceInput) SetResourceName(v string) *CreateAppVersionResourceInput {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *CreateAppVersionResourceInput) SetResourceType(v string) *CreateAppVersionResourceInput {
	s.ResourceType = &v
	return s
}

type CreateAppVersionResourceOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Resilience Hub application version.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// Defines a physical resource. A physical resource is a resource that exists
	// in your account. It can be identified using an Amazon Resource Name (ARN)
	// or a Resilience Hub-native identifier.
	PhysicalResource *PhysicalResource `locationName:"physicalResource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppVersionResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppVersionResourceOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *CreateAppVersionResourceOutput) SetAppArn(v string) *CreateAppVersionResourceOutput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *CreateAppVersionResourceOutput) SetAppVersion(v string) *CreateAppVersionResourceOutput {
	s.AppVersion = &v
	return s
}

// SetPhysicalResource sets the PhysicalResource field's value.
func (s *CreateAppVersionResourceOutput) SetPhysicalResource(v *PhysicalResource) *CreateAppVersionResourceOutput {
	s.PhysicalResource = v
	return s
}

type CreateRecommendationTemplateInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
	// arn:partition:resiliencehub:region:account:app-assessment/app-id. For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AssessmentArn is a required field
	AssessmentArn *string `locationName:"assessmentArn" type:"string" required:"true"`

	// The name of the Amazon S3 bucket that will contain the recommendation template.
	BucketName *string `locationName:"bucketName" type:"string"`

	// Used for an idempotency token. A client token is a unique, case-sensitive
	// string of up to 64 ASCII characters. You should not reuse the same client
	// token for other API requests.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The format for the recommendation template.
	//
	// CfnJson
	//
	// The template is CloudFormation JSON.
	//
	// CfnYaml
	//
	// The template is CloudFormation YAML.
	Format *string `locationName:"format" type:"string" enum:"TemplateFormat"`

	// The name for the recommendation template.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Identifiers for the recommendations used to create a recommendation template.
	RecommendationIds []*string `locationName:"recommendationIds" min:"1" type:"list"`

	// An array of strings that specify the recommendation template type or types.
	//
	// Alarm
	//
	// The template is an AlarmRecommendation template.
	//
	// Sop
	//
	// The template is a SopRecommendation template.
	//
	// Test
	//
	// The template is a TestRecommendation template.
	RecommendationTypes []*string `locationName:"recommendationTypes" min:"1" type:"list" enum:"RenderRecommendationType"`

	// Tags assigned to the resource. A tag is a label that you assign to an Amazon
	// Web Services resource. Each tag consists of a key/value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateRecommendationTemplateInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecommendationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecommendationTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRecommendationTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRecommendationTemplateInput"}
	if s.AssessmentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentArn"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RecommendationIds != nil && len(s.RecommendationIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecommendationIds", 1))
	}
	if s.RecommendationTypes != nil && len(s.RecommendationTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecommendationTypes", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentArn sets the AssessmentArn field's value.
func (s *CreateRecommendationTemplateInput) SetAssessmentArn(v string) *CreateRecommendationTemplateInput {
	s.AssessmentArn = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *CreateRecommendationTemplateInput) SetBucketName(v string) *CreateRecommendationTemplateInput {
	s.BucketName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateRecommendationTemplateInput) SetClientToken(v string) *CreateRecommendationTemplateInput {
	s.ClientToken = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *CreateRecommendationTemplateInput) SetFormat(v string) *CreateRecommendationTemplateInput {
	s.Format = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRecommendationTemplateInput) SetName(v string) *CreateRecommendationTemplateInput {
	s.Name = &v
	return s
}

// SetRecommendationIds sets the RecommendationIds field's value.
func (s *CreateRecommendationTemplateInput) SetRecommendationIds(v []*string) *CreateRecommendationTemplateInput {
	s.RecommendationIds = v
	return s
}

// SetRecommendationTypes sets the RecommendationTypes field's value.
func (s *CreateRecommendationTemplateInput) SetRecommendationTypes(v []*string) *CreateRecommendationTemplateInput {
	s.RecommendationTypes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRecommendationTemplateInput) SetTags(v map[string]*string) *CreateRecommendationTemplateInput {
	s.Tags = v
	return s
}

type CreateRecommendationTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The newly created recommendation template, returned as an object. This object
	// includes the template's name, format, status, tags, Amazon S3 bucket location,
	// and more.
	RecommendationTemplate *RecommendationTemplate `locationName:"recommendationTemplate" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecommendationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecommendationTemplateOutput) GoString() string {
	return s.String()
}

// SetRecommendationTemplate sets the RecommendationTemplate field's value.
func (s *CreateRecommendationTemplateOutput) SetRecommendationTemplate(v *RecommendationTemplate) *CreateRecommendationTemplateOutput {
	s.RecommendationTemplate = v
	return s
}

type CreateResiliencyPolicyInput struct {
	_ struct{} `type:"structure"`

	// Used for an idempotency token. A client token is a unique, case-sensitive
	// string of up to 64 ASCII characters. You should not reuse the same client
	// token for other API requests.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Specifies a high-level geographical location constraint for where your resilience
	// policy data can be stored.
	DataLocationConstraint *string `locationName:"dataLocationConstraint" type:"string" enum:"DataLocationConstraint"`

	// The type of resiliency policy to be created, including the recovery time
	// objective (RTO) and recovery point objective (RPO) in seconds.
	//
	// Policy is a required field
	Policy map[string]*FailurePolicy `locationName:"policy" type:"map" required:"true"`

	// The description for the policy.
	PolicyDescription *string `locationName:"policyDescription" type:"string"`

	// The name of the policy
	//
	// PolicyName is a required field
	PolicyName *string `locationName:"policyName" type:"string" required:"true"`

	// Tags assigned to the resource. A tag is a label that you assign to an Amazon
	// Web Services resource. Each tag consists of a key/value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateResiliencyPolicyInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`

	// The tier for this resiliency policy, ranging from the highest severity (MissionCritical)
	// to lowest (NonCritical).
	//
	// Tier is a required field
	Tier *string `locationName:"tier" type:"string" required:"true" enum:"ResiliencyPolicyTier"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResiliencyPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResiliencyPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResiliencyPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResiliencyPolicyInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tier == nil {
		invalidParams.Add(request.NewErrParamRequired("Tier"))
	}
	if s.Policy != nil {
		for i, v := range s.Policy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Policy", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateResiliencyPolicyInput) SetClientToken(v string) *CreateResiliencyPolicyInput {
	s.ClientToken = &v
	return s
}

// SetDataLocationConstraint sets the DataLocationConstraint field's value.
func (s *CreateResiliencyPolicyInput) SetDataLocationConstraint(v string) *CreateResiliencyPolicyInput {
	s.DataLocationConstraint = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *CreateResiliencyPolicyInput) SetPolicy(v map[string]*FailurePolicy) *CreateResiliencyPolicyInput {
	s.Policy = v
	return s
}

// SetPolicyDescription sets the PolicyDescription field's value.
func (s *CreateResiliencyPolicyInput) SetPolicyDescription(v string) *CreateResiliencyPolicyInput {
	s.PolicyDescription = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *CreateResiliencyPolicyInput) SetPolicyName(v string) *CreateResiliencyPolicyInput {
	s.PolicyName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResiliencyPolicyInput) SetTags(v map[string]*string) *CreateResiliencyPolicyInput {
	s.Tags = v
	return s
}

// SetTier sets the Tier field's value.
func (s *CreateResiliencyPolicyInput) SetTier(v string) *CreateResiliencyPolicyInput {
	s.Tier = &v
	return s
}

type CreateResiliencyPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The type of resiliency policy that was created, including the recovery time
	// objective (RTO) and recovery point objective (RPO) in seconds.
	//
	// Policy is a required field
	Policy *ResiliencyPolicy `locationName:"policy" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResiliencyPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResiliencyPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *CreateResiliencyPolicyOutput) SetPolicy(v *ResiliencyPolicy) *CreateResiliencyPolicyOutput {
	s.Policy = v
	return s
}

type DeleteAppAssessmentInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
	// arn:partition:resiliencehub:region:account:app-assessment/app-id. For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AssessmentArn is a required field
	AssessmentArn *string `locationName:"assessmentArn" type:"string" required:"true"`

	// Used for an idempotency token. A client token is a unique, case-sensitive
	// string of up to 64 ASCII characters. You should not reuse the same client
	// token for other API requests.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppAssessmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppAssessmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppAssessmentInput"}
	if s.AssessmentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentArn"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentArn sets the AssessmentArn field's value.
func (s *DeleteAppAssessmentInput) SetAssessmentArn(v string) *DeleteAppAssessmentInput {
	s.AssessmentArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteAppAssessmentInput) SetClientToken(v string) *DeleteAppAssessmentInput {
	s.ClientToken = &v
	return s
}

type DeleteAppAssessmentOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
	// arn:partition:resiliencehub:region:account:app-assessment/app-id. For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AssessmentArn is a required field
	AssessmentArn *string `locationName:"assessmentArn" type:"string" required:"true"`

	// The current status of the assessment for the resiliency policy.
	//
	// AssessmentStatus is a required field
	AssessmentStatus *string `locationName:"assessmentStatus" type:"string" required:"true" enum:"AssessmentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppAssessmentOutput) GoString() string {
	return s.String()
}

// SetAssessmentArn sets the AssessmentArn field's value.
func (s *DeleteAppAssessmentOutput) SetAssessmentArn(v string) *DeleteAppAssessmentOutput {
	s.AssessmentArn = &v
	return s
}

// SetAssessmentStatus sets the AssessmentStatus field's value.
func (s *DeleteAppAssessmentOutput) SetAssessmentStatus(v string) *DeleteAppAssessmentOutput {
	s.AssessmentStatus = &v
	return s
}

type DeleteAppInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Used for an idempotency token. A client token is a unique, case-sensitive
	// string of up to 64 ASCII characters. You should not reuse the same client
	// token for other API requests.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A boolean option to force the deletion of an Resilience Hub application.
	ForceDelete *bool `locationName:"forceDelete" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *DeleteAppInput) SetAppArn(v string) *DeleteAppInput {
	s.AppArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteAppInput) SetClientToken(v string) *DeleteAppInput {
	s.ClientToken = &v
	return s
}

// SetForceDelete sets the ForceDelete field's value.
func (s *DeleteAppInput) SetForceDelete(v bool) *DeleteAppInput {
	s.ForceDelete = &v
	return s
}

type DeleteAppInputSourceInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Used for an idempotency token. A client token is a unique, case-sensitive
	// string of up to 64 ASCII characters. You should not reuse the same client
	// token for other API requests.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The namespace on your Amazon Elastic Kubernetes Service cluster that you
	// want to delete from the Resilience Hub application.
	EksSourceClusterNamespace *EksSourceClusterNamespace `locationName:"eksSourceClusterNamespace" type:"structure"`

	// The Amazon Resource Name (ARN) of the imported resource you want to remove
	// from the Resilience Hub application. For more information about ARNs, see
	// Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	SourceArn *string `locationName:"sourceArn" type:"string"`

	// The imported Terraform s3 state ﬁle you want to remove from the Resilience
	// Hub application.
	TerraformSource *TerraformSource `locationName:"terraformSource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInputSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInputSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppInputSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppInputSourceInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.EksSourceClusterNamespace != nil {
		if err := s.EksSourceClusterNamespace.Validate(); err != nil {
			invalidParams.AddNested("EksSourceClusterNamespace", err.(request.ErrInvalidParams))
		}
	}
	if s.TerraformSource != nil {
		if err := s.TerraformSource.Validate(); err != nil {
			invalidParams.AddNested("TerraformSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *DeleteAppInputSourceInput) SetAppArn(v string) *DeleteAppInputSourceInput {
	s.AppArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteAppInputSourceInput) SetClientToken(v string) *DeleteAppInputSourceInput {
	s.ClientToken = &v
	return s
}

// SetEksSourceClusterNamespace sets the EksSourceClusterNamespace field's value.
func (s *DeleteAppInputSourceInput) SetEksSourceClusterNamespace(v *EksSourceClusterNamespace) *DeleteAppInputSourceInput {
	s.EksSourceClusterNamespace = v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *DeleteAppInputSourceInput) SetSourceArn(v string) *DeleteAppInputSourceInput {
	s.SourceArn = &v
	return s
}

// SetTerraformSource sets the TerraformSource field's value.
func (s *DeleteAppInputSourceInput) SetTerraformSource(v *TerraformSource) *DeleteAppInputSourceInput {
	s.TerraformSource = v
	return s
}

type DeleteAppInputSourceOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	AppArn *string `locationName:"appArn" type:"string"`

	// Name of the input source from where the application resource is imported
	// from.
	AppInputSource *AppInputSource `locationName:"appInputSource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInputSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInputSourceOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *DeleteAppInputSourceOutput) SetAppArn(v string) *DeleteAppInputSourceOutput {
	s.AppArn = &v
	return s
}

// SetAppInputSource sets the AppInputSource field's value.
func (s *DeleteAppInputSourceOutput) SetAppInputSource(v *AppInputSource) *DeleteAppInputSourceOutput {
	s.AppInputSource = v
	return s
}

type DeleteAppOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *DeleteAppOutput) SetAppArn(v string) *DeleteAppOutput {
	s.AppArn = &v
	return s
}

type DeleteAppVersionAppComponentInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Used for an idempotency token. A client token is a unique, case-sensitive
	// string of up to 64 ASCII characters. You should not reuse the same client
	// token for other API requests.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Identifier of the Application Component.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppVersionAppComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppVersionAppComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppVersionAppComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppVersionAppComponentInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *DeleteAppVersionAppComponentInput) SetAppArn(v string) *DeleteAppVersionAppComponentInput {
	s.AppArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteAppVersionAppComponentInput) SetClientToken(v string) *DeleteAppVersionAppComponentInput {
	s.ClientToken = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteAppVersionAppComponentInput) SetId(v string) *DeleteAppVersionAppComponentInput {
	s.Id = &v
	return s
}

type DeleteAppVersionAppComponentOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// List of Application Components that belong to this resource.
	AppComponent *AppComponent `locationName:"appComponent" type:"structure"`

	// Resilience Hub application version.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppVersionAppComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppVersionAppComponentOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *DeleteAppVersionAppComponentOutput) SetAppArn(v string) *DeleteAppVersionAppComponentOutput {
	s.AppArn = &v
	return s
}

// SetAppComponent sets the AppComponent field's value.
func (s *DeleteAppVersionAppComponentOutput) SetAppComponent(v *AppComponent) *DeleteAppVersionAppComponentOutput {
	s.AppComponent = v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *DeleteAppVersionAppComponentOutput) SetAppVersion(v string) *DeleteAppVersionAppComponentOutput {
	s.AppVersion = &v
	return s
}

type DeleteAppVersionResourceInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Amazon Web Services account that owns the physical resource.
	AwsAccountId *string `locationName:"awsAccountId" type:"string"`

	// Amazon Web Services region that owns the physical resource.
	AwsRegion *string `locationName:"awsRegion" type:"string"`

	// Used for an idempotency token. A client token is a unique, case-sensitive
	// string of up to 64 ASCII characters. You should not reuse the same client
	// token for other API requests.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Logical identifier of the resource.
	LogicalResourceId *LogicalResourceId `locationName:"logicalResourceId" type:"structure"`

	// Physical identifier of the resource.
	PhysicalResourceId *string `locationName:"physicalResourceId" min:"1" type:"string"`

	// Name of the resource.
	ResourceName *string `locationName:"resourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppVersionResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppVersionResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppVersionResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppVersionResourceInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.PhysicalResourceId != nil && len(*s.PhysicalResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhysicalResourceId", 1))
	}
	if s.LogicalResourceId != nil {
		if err := s.LogicalResourceId.Validate(); err != nil {
			invalidParams.AddNested("LogicalResourceId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *DeleteAppVersionResourceInput) SetAppArn(v string) *DeleteAppVersionResourceInput {
	s.AppArn = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteAppVersionResourceInput) SetAwsAccountId(v string) *DeleteAppVersionResourceInput {
	s.AwsAccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *DeleteAppVersionResourceInput) SetAwsRegion(v string) *DeleteAppVersionResourceInput {
	s.AwsRegion = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteAppVersionResourceInput) SetClientToken(v string) *DeleteAppVersionResourceInput {
	s.ClientToken = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *DeleteAppVersionResourceInput) SetLogicalResourceId(v *LogicalResourceId) *DeleteAppVersionResourceInput {
	s.LogicalResourceId = v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *DeleteAppVersionResourceInput) SetPhysicalResourceId(v string) *DeleteAppVersionResourceInput {
	s.PhysicalResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *DeleteAppVersionResourceInput) SetResourceName(v string) *DeleteAppVersionResourceInput {
	s.ResourceName = &v
	return s
}

type DeleteAppVersionResourceOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Resilience Hub application version.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// Defines a physical resource. A physical resource is a resource that exists
	// in your account. It can be identified using an Amazon Resource Name (ARN)
	// or a Resilience Hub-native identifier.
	PhysicalResource *PhysicalResource `locationName:"physicalResource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppVersionResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppVersionResourceOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *DeleteAppVersionResourceOutput) SetAppArn(v string) *DeleteAppVersionResourceOutput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *DeleteAppVersionResourceOutput) SetAppVersion(v string) *DeleteAppVersionResourceOutput {
	s.AppVersion = &v
	return s
}

// SetPhysicalResource sets the PhysicalResource field's value.
func (s *DeleteAppVersionResourceOutput) SetPhysicalResource(v *PhysicalResource) *DeleteAppVersionResourceOutput {
	s.PhysicalResource = v
	return s
}

type DeleteRecommendationTemplateInput struct {
	_ struct{} `type:"structure"`

	// Used for an idempotency token. A client token is a unique, case-sensitive
	// string of up to 64 ASCII characters. You should not reuse the same client
	// token for other API requests.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) for a recommendation template.
	//
	// RecommendationTemplateArn is a required field
	RecommendationTemplateArn *string `locationName:"recommendationTemplateArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecommendationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecommendationTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRecommendationTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRecommendationTemplateInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.RecommendationTemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommendationTemplateArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteRecommendationTemplateInput) SetClientToken(v string) *DeleteRecommendationTemplateInput {
	s.ClientToken = &v
	return s
}

// SetRecommendationTemplateArn sets the RecommendationTemplateArn field's value.
func (s *DeleteRecommendationTemplateInput) SetRecommendationTemplateArn(v string) *DeleteRecommendationTemplateInput {
	s.RecommendationTemplateArn = &v
	return s
}

type DeleteRecommendationTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for a recommendation template.
	//
	// RecommendationTemplateArn is a required field
	RecommendationTemplateArn *string `locationName:"recommendationTemplateArn" type:"string" required:"true"`

	// Status of the action.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"RecommendationTemplateStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecommendationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecommendationTemplateOutput) GoString() string {
	return s.String()
}

// SetRecommendationTemplateArn sets the RecommendationTemplateArn field's value.
func (s *DeleteRecommendationTemplateOutput) SetRecommendationTemplateArn(v string) *DeleteRecommendationTemplateOutput {
	s.RecommendationTemplateArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteRecommendationTemplateOutput) SetStatus(v string) *DeleteRecommendationTemplateOutput {
	s.Status = &v
	return s
}

type DeleteResiliencyPolicyInput struct {
	_ struct{} `type:"structure"`

	// Used for an idempotency token. A client token is a unique, case-sensitive
	// string of up to 64 ASCII characters. You should not reuse the same client
	// token for other API requests.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Amazon Resource Name (ARN) of the resiliency policy. The format for this
	// ARN is: arn:partition:resiliencehub:region:account:resiliency-policy/policy-id.
	// For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// PolicyArn is a required field
	PolicyArn *string `locationName:"policyArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResiliencyPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResiliencyPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResiliencyPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResiliencyPolicyInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteResiliencyPolicyInput) SetClientToken(v string) *DeleteResiliencyPolicyInput {
	s.ClientToken = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *DeleteResiliencyPolicyInput) SetPolicyArn(v string) *DeleteResiliencyPolicyInput {
	s.PolicyArn = &v
	return s
}

type DeleteResiliencyPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the resiliency policy. The format for this
	// ARN is: arn:partition:resiliencehub:region:account:resiliency-policy/policy-id.
	// For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// PolicyArn is a required field
	PolicyArn *string `locationName:"policyArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResiliencyPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResiliencyPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *DeleteResiliencyPolicyOutput) SetPolicyArn(v string) *DeleteResiliencyPolicyOutput {
	s.PolicyArn = &v
	return s
}

type DescribeAppAssessmentInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
	// arn:partition:resiliencehub:region:account:app-assessment/app-id. For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AssessmentArn is a required field
	AssessmentArn *string `locationName:"assessmentArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppAssessmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppAssessmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppAssessmentInput"}
	if s.AssessmentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentArn sets the AssessmentArn field's value.
func (s *DescribeAppAssessmentInput) SetAssessmentArn(v string) *DescribeAppAssessmentInput {
	s.AssessmentArn = &v
	return s
}

type DescribeAppAssessmentOutput struct {
	_ struct{} `type:"structure"`

	// The assessment for an Resilience Hub application, returned as an object.
	// This object includes Amazon Resource Names (ARNs), compliance information,
	// compliance status, cost, messages, resiliency scores, and more.
	//
	// Assessment is a required field
	Assessment *AppAssessment `locationName:"assessment" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppAssessmentOutput) GoString() string {
	return s.String()
}

// SetAssessment sets the Assessment field's value.
func (s *DescribeAppAssessmentOutput) SetAssessment(v *AppAssessment) *DescribeAppAssessmentOutput {
	s.Assessment = v
	return s
}

type DescribeAppInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *DescribeAppInput) SetAppArn(v string) *DescribeAppInput {
	s.AppArn = &v
	return s
}

type DescribeAppOutput struct {
	_ struct{} `type:"structure"`

	// The specified application, returned as an object with details including compliance
	// status, creation time, description, resiliency score, and more.
	//
	// App is a required field
	App *App `locationName:"app" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppOutput) GoString() string {
	return s.String()
}

// SetApp sets the App field's value.
func (s *DescribeAppOutput) SetApp(v *App) *DescribeAppOutput {
	s.App = v
	return s
}

type DescribeAppVersionAppComponentInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Resilience Hub application version.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// Identifier of the Application Component.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionAppComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionAppComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppVersionAppComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppVersionAppComponentInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.AppVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AppVersion"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *DescribeAppVersionAppComponentInput) SetAppArn(v string) *DescribeAppVersionAppComponentInput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *DescribeAppVersionAppComponentInput) SetAppVersion(v string) *DescribeAppVersionAppComponentInput {
	s.AppVersion = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeAppVersionAppComponentInput) SetId(v string) *DescribeAppVersionAppComponentInput {
	s.Id = &v
	return s
}

type DescribeAppVersionAppComponentOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// List of Application Components that belong to this resource.
	AppComponent *AppComponent `locationName:"appComponent" type:"structure"`

	// Resilience Hub application version.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionAppComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionAppComponentOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *DescribeAppVersionAppComponentOutput) SetAppArn(v string) *DescribeAppVersionAppComponentOutput {
	s.AppArn = &v
	return s
}

// SetAppComponent sets the AppComponent field's value.
func (s *DescribeAppVersionAppComponentOutput) SetAppComponent(v *AppComponent) *DescribeAppVersionAppComponentOutput {
	s.AppComponent = v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *DescribeAppVersionAppComponentOutput) SetAppVersion(v string) *DescribeAppVersionAppComponentOutput {
	s.AppVersion = &v
	return s
}

type DescribeAppVersionInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Resilience Hub application version.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppVersionInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.AppVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AppVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *DescribeAppVersionInput) SetAppArn(v string) *DescribeAppVersionInput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *DescribeAppVersionInput) SetAppVersion(v string) *DescribeAppVersionInput {
	s.AppVersion = &v
	return s
}

type DescribeAppVersionOutput struct {
	_ struct{} `type:"structure"`

	// Additional configuration parameters for an Resilience Hub application. If
	// you want to implement additionalInfo through the Resilience Hub console rather
	// than using an API call, see Configure the application configuration parameters
	// (https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
	//
	// Currently, this parameter supports only failover region and account.
	AdditionalInfo map[string][]*string `locationName:"additionalInfo" type:"map"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Resilience Hub application version.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionOutput) GoString() string {
	return s.String()
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *DescribeAppVersionOutput) SetAdditionalInfo(v map[string][]*string) *DescribeAppVersionOutput {
	s.AdditionalInfo = v
	return s
}

// SetAppArn sets the AppArn field's value.
func (s *DescribeAppVersionOutput) SetAppArn(v string) *DescribeAppVersionOutput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *DescribeAppVersionOutput) SetAppVersion(v string) *DescribeAppVersionOutput {
	s.AppVersion = &v
	return s
}

type DescribeAppVersionResourceInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Resilience Hub application version.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// Amazon Web Services account that owns the physical resource.
	AwsAccountId *string `locationName:"awsAccountId" type:"string"`

	// Amazon Web Services region that owns the physical resource.
	AwsRegion *string `locationName:"awsRegion" type:"string"`

	// Logical identifier of the resource.
	LogicalResourceId *LogicalResourceId `locationName:"logicalResourceId" type:"structure"`

	// Physical identifier of the resource.
	PhysicalResourceId *string `locationName:"physicalResourceId" min:"1" type:"string"`

	// Name of the resource.
	ResourceName *string `locationName:"resourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppVersionResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppVersionResourceInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.AppVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AppVersion"))
	}
	if s.PhysicalResourceId != nil && len(*s.PhysicalResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhysicalResourceId", 1))
	}
	if s.LogicalResourceId != nil {
		if err := s.LogicalResourceId.Validate(); err != nil {
			invalidParams.AddNested("LogicalResourceId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *DescribeAppVersionResourceInput) SetAppArn(v string) *DescribeAppVersionResourceInput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *DescribeAppVersionResourceInput) SetAppVersion(v string) *DescribeAppVersionResourceInput {
	s.AppVersion = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeAppVersionResourceInput) SetAwsAccountId(v string) *DescribeAppVersionResourceInput {
	s.AwsAccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *DescribeAppVersionResourceInput) SetAwsRegion(v string) *DescribeAppVersionResourceInput {
	s.AwsRegion = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *DescribeAppVersionResourceInput) SetLogicalResourceId(v *LogicalResourceId) *DescribeAppVersionResourceInput {
	s.LogicalResourceId = v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *DescribeAppVersionResourceInput) SetPhysicalResourceId(v string) *DescribeAppVersionResourceInput {
	s.PhysicalResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *DescribeAppVersionResourceInput) SetResourceName(v string) *DescribeAppVersionResourceInput {
	s.ResourceName = &v
	return s
}

type DescribeAppVersionResourceOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Resilience Hub application version.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// Defines a physical resource. A physical resource is a resource that exists
	// in your account. It can be identified using an Amazon Resource Name (ARN)
	// or a Resilience Hub-native identifier.
	PhysicalResource *PhysicalResource `locationName:"physicalResource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionResourceOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *DescribeAppVersionResourceOutput) SetAppArn(v string) *DescribeAppVersionResourceOutput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *DescribeAppVersionResourceOutput) SetAppVersion(v string) *DescribeAppVersionResourceOutput {
	s.AppVersion = &v
	return s
}

// SetPhysicalResource sets the PhysicalResource field's value.
func (s *DescribeAppVersionResourceOutput) SetPhysicalResource(v *PhysicalResource) *DescribeAppVersionResourceOutput {
	s.PhysicalResource = v
	return s
}

type DescribeAppVersionResourcesResolutionStatusInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The version of the application.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// The identifier for a specific resolution.
	ResolutionId *string `locationName:"resolutionId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionResourcesResolutionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionResourcesResolutionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppVersionResourcesResolutionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppVersionResourcesResolutionStatusInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.AppVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AppVersion"))
	}
	if s.ResolutionId != nil && len(*s.ResolutionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolutionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *DescribeAppVersionResourcesResolutionStatusInput) SetAppArn(v string) *DescribeAppVersionResourcesResolutionStatusInput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *DescribeAppVersionResourcesResolutionStatusInput) SetAppVersion(v string) *DescribeAppVersionResourcesResolutionStatusInput {
	s.AppVersion = &v
	return s
}

// SetResolutionId sets the ResolutionId field's value.
func (s *DescribeAppVersionResourcesResolutionStatusInput) SetResolutionId(v string) *DescribeAppVersionResourcesResolutionStatusInput {
	s.ResolutionId = &v
	return s
}

type DescribeAppVersionResourcesResolutionStatusOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The version of the application.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// The returned error message for the request.
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string"`

	// The identifier for a specific resolution.
	//
	// ResolutionId is a required field
	ResolutionId *string `locationName:"resolutionId" min:"1" type:"string" required:"true"`

	// Status of the action.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ResourceResolutionStatusType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionResourcesResolutionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionResourcesResolutionStatusOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *DescribeAppVersionResourcesResolutionStatusOutput) SetAppArn(v string) *DescribeAppVersionResourcesResolutionStatusOutput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *DescribeAppVersionResourcesResolutionStatusOutput) SetAppVersion(v string) *DescribeAppVersionResourcesResolutionStatusOutput {
	s.AppVersion = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeAppVersionResourcesResolutionStatusOutput) SetErrorMessage(v string) *DescribeAppVersionResourcesResolutionStatusOutput {
	s.ErrorMessage = &v
	return s
}

// SetResolutionId sets the ResolutionId field's value.
func (s *DescribeAppVersionResourcesResolutionStatusOutput) SetResolutionId(v string) *DescribeAppVersionResourcesResolutionStatusOutput {
	s.ResolutionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeAppVersionResourcesResolutionStatusOutput) SetStatus(v string) *DescribeAppVersionResourcesResolutionStatusOutput {
	s.Status = &v
	return s
}

type DescribeAppVersionTemplateInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The version of the application.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppVersionTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppVersionTemplateInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.AppVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AppVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *DescribeAppVersionTemplateInput) SetAppArn(v string) *DescribeAppVersionTemplateInput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *DescribeAppVersionTemplateInput) SetAppVersion(v string) *DescribeAppVersionTemplateInput {
	s.AppVersion = &v
	return s
}

type DescribeAppVersionTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// A JSON string that provides information about your application structure.
	// To learn more about the appTemplateBody template, see the sample template
	// provided in the Examples section.
	//
	// The appTemplateBody JSON string has the following structure:
	//
	//    * resources The list of logical resources that must be included in the
	//    Resilience Hub application. Type: Array Don't add the resources that you
	//    want to exclude. Each resources array item includes the following fields:
	//    logicalResourceId Logical identifier of the resource. Type: Object Each
	//    logicalResourceId object includes the following fields: identifier Identifier
	//    of the resource. Type: String logicalStackName The name of the CloudFormation
	//    stack this resource belongs to. Type: String resourceGroupName The name
	//    of the resource group this resource belongs to. Type: String terraformSourceName
	//    The name of the Terraform S3 state file this resource belongs to. Type:
	//    String eksSourceName Name of the Amazon Elastic Kubernetes Service cluster
	//    and namespace this resource belongs to. This parameter accepts values
	//    in "eks-cluster/namespace" format. Type: String type The type of resource.
	//    Type: string name The name of the resource. Type: String additionalInfo
	//    Additional configuration parameters for an Resilience Hub application.
	//    If you want to implement additionalInfo through the Resilience Hub console
	//    rather than using an API call, see Configure the application configuration
	//    parameters (https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
	//    Currently, this parameter accepts a key-value mapping (in a string format)
	//    of only one failover region and one associated account. Key: "failover-regions"
	//    Value: "[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"
	//
	//    * appComponents List of Application Components that this resource belongs
	//    to. If an Application Component is not part of the Resilience Hub application,
	//    it will be added. Type: Array Each appComponents array item includes the
	//    following fields: name Name of the Application Component. Type: String
	//    type Type of Application Component. For more information about the types
	//    of Application Component, see Grouping resources in an AppComponent (https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html).
	//    Type: String resourceNames The list of included resources that are assigned
	//    to the Application Component. Type: Array of strings additionalInfo Additional
	//    configuration parameters for an Resilience Hub application. If you want
	//    to implement additionalInfo through the Resilience Hub console rather
	//    than using an API call, see Configure the application configuration parameters
	//    (https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
	//    Currently, this parameter accepts a key-value mapping (in a string format)
	//    of only one failover region and one associated account. Key: "failover-regions"
	//    Value: "[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"
	//
	//    * excludedResources The list of logical resource identifiers to be excluded
	//    from the application. Type: Array Don't add the resources that you want
	//    to include. Each excludedResources array item includes the following fields:
	//    logicalResourceIds Logical identifier of the resource. Type: Object You
	//    can configure only one of the following fields: logicalStackName resourceGroupName
	//    terraformSourceName eksSourceName Each logicalResourceIds object includes
	//    the following fields: identifier Identifier of the resource. Type: String
	//    logicalStackName The name of the CloudFormation stack this resource belongs
	//    to. Type: String resourceGroupName The name of the resource group this
	//    resource belongs to. Type: String terraformSourceName The name of the
	//    Terraform S3 state file this resource belongs to. Type: String eksSourceName
	//    Name of the Amazon Elastic Kubernetes Service cluster and namespace this
	//    resource belongs to. This parameter accepts values in "eks-cluster/namespace"
	//    format. Type: String
	//
	//    * version Resilience Hub application version.
	//
	//    * additionalInfo Additional configuration parameters for an Resilience
	//    Hub application. If you want to implement additionalInfo through the Resilience
	//    Hub console rather than using an API call, see Configure the application
	//    configuration parameters (https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
	//    Currently, this parameter accepts a key-value mapping (in a string format)
	//    of only one failover region and one associated account. Key: "failover-regions"
	//    Value: "[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"
	//
	// AppTemplateBody is a required field
	AppTemplateBody *string `locationName:"appTemplateBody" type:"string" required:"true"`

	// The version of the application.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppVersionTemplateOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *DescribeAppVersionTemplateOutput) SetAppArn(v string) *DescribeAppVersionTemplateOutput {
	s.AppArn = &v
	return s
}

// SetAppTemplateBody sets the AppTemplateBody field's value.
func (s *DescribeAppVersionTemplateOutput) SetAppTemplateBody(v string) *DescribeAppVersionTemplateOutput {
	s.AppTemplateBody = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *DescribeAppVersionTemplateOutput) SetAppVersion(v string) *DescribeAppVersionTemplateOutput {
	s.AppVersion = &v
	return s
}

type DescribeDraftAppVersionResourcesImportStatusInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDraftAppVersionResourcesImportStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDraftAppVersionResourcesImportStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDraftAppVersionResourcesImportStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDraftAppVersionResourcesImportStatusInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *DescribeDraftAppVersionResourcesImportStatusInput) SetAppArn(v string) *DescribeDraftAppVersionResourcesImportStatusInput {
	s.AppArn = &v
	return s
}

type DescribeDraftAppVersionResourcesImportStatusOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The version of the application.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// The returned error message for the request.
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string"`

	// Status of the action.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ResourceImportStatusType"`

	// The time when the status last changed.
	//
	// StatusChangeTime is a required field
	StatusChangeTime *time.Time `locationName:"statusChangeTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDraftAppVersionResourcesImportStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDraftAppVersionResourcesImportStatusOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *DescribeDraftAppVersionResourcesImportStatusOutput) SetAppArn(v string) *DescribeDraftAppVersionResourcesImportStatusOutput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *DescribeDraftAppVersionResourcesImportStatusOutput) SetAppVersion(v string) *DescribeDraftAppVersionResourcesImportStatusOutput {
	s.AppVersion = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeDraftAppVersionResourcesImportStatusOutput) SetErrorMessage(v string) *DescribeDraftAppVersionResourcesImportStatusOutput {
	s.ErrorMessage = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDraftAppVersionResourcesImportStatusOutput) SetStatus(v string) *DescribeDraftAppVersionResourcesImportStatusOutput {
	s.Status = &v
	return s
}

// SetStatusChangeTime sets the StatusChangeTime field's value.
func (s *DescribeDraftAppVersionResourcesImportStatusOutput) SetStatusChangeTime(v time.Time) *DescribeDraftAppVersionResourcesImportStatusOutput {
	s.StatusChangeTime = &v
	return s
}

type DescribeResiliencyPolicyInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the resiliency policy. The format for this
	// ARN is: arn:partition:resiliencehub:region:account:resiliency-policy/policy-id.
	// For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// PolicyArn is a required field
	PolicyArn *string `locationName:"policyArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResiliencyPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResiliencyPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResiliencyPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResiliencyPolicyInput"}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *DescribeResiliencyPolicyInput) SetPolicyArn(v string) *DescribeResiliencyPolicyInput {
	s.PolicyArn = &v
	return s
}

type DescribeResiliencyPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specific resiliency policy, returned as an object.
	// This object includes creation time, data location constraints, its name,
	// description, tags, the recovery time objective (RTO) and recovery point objective
	// (RPO) in seconds, and more.
	//
	// Policy is a required field
	Policy *ResiliencyPolicy `locationName:"policy" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResiliencyPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResiliencyPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *DescribeResiliencyPolicyOutput) SetPolicy(v *ResiliencyPolicy) *DescribeResiliencyPolicyOutput {
	s.Policy = v
	return s
}

// Defines the compliance against the resiliency policy for a disruption.
type DisruptionCompliance struct {
	_ struct{} `type:"structure"`

	// The Recovery Point Objective (RPO) that is achievable, in seconds.
	AchievableRpoInSecs *int64 `locationName:"achievableRpoInSecs" type:"integer"`

	// The Recovery Time Objective (RTO) that is achievable, in seconds
	AchievableRtoInSecs *int64 `locationName:"achievableRtoInSecs" type:"integer"`

	// The current status of compliance for the resiliency policy.
	//
	// ComplianceStatus is a required field
	ComplianceStatus *string `locationName:"complianceStatus" type:"string" required:"true" enum:"ComplianceStatus"`

	// The current RPO, in seconds.
	CurrentRpoInSecs *int64 `locationName:"currentRpoInSecs" type:"integer"`

	// The current RTO, in seconds.
	CurrentRtoInSecs *int64 `locationName:"currentRtoInSecs" type:"integer"`

	// The disruption compliance message.
	Message *string `locationName:"message" min:"1" type:"string"`

	// The RPO description.
	RpoDescription *string `locationName:"rpoDescription" min:"1" type:"string"`

	// Reference identifier of the RPO .
	RpoReferenceId *string `locationName:"rpoReferenceId" min:"1" type:"string"`

	// The RTO description.
	RtoDescription *string `locationName:"rtoDescription" min:"1" type:"string"`

	// Reference identifier of the RTO.
	RtoReferenceId *string `locationName:"rtoReferenceId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisruptionCompliance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisruptionCompliance) GoString() string {
	return s.String()
}

// SetAchievableRpoInSecs sets the AchievableRpoInSecs field's value.
func (s *DisruptionCompliance) SetAchievableRpoInSecs(v int64) *DisruptionCompliance {
	s.AchievableRpoInSecs = &v
	return s
}

// SetAchievableRtoInSecs sets the AchievableRtoInSecs field's value.
func (s *DisruptionCompliance) SetAchievableRtoInSecs(v int64) *DisruptionCompliance {
	s.AchievableRtoInSecs = &v
	return s
}

// SetComplianceStatus sets the ComplianceStatus field's value.
func (s *DisruptionCompliance) SetComplianceStatus(v string) *DisruptionCompliance {
	s.ComplianceStatus = &v
	return s
}

// SetCurrentRpoInSecs sets the CurrentRpoInSecs field's value.
func (s *DisruptionCompliance) SetCurrentRpoInSecs(v int64) *DisruptionCompliance {
	s.CurrentRpoInSecs = &v
	return s
}

// SetCurrentRtoInSecs sets the CurrentRtoInSecs field's value.
func (s *DisruptionCompliance) SetCurrentRtoInSecs(v int64) *DisruptionCompliance {
	s.CurrentRtoInSecs = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DisruptionCompliance) SetMessage(v string) *DisruptionCompliance {
	s.Message = &v
	return s
}

// SetRpoDescription sets the RpoDescription field's value.
func (s *DisruptionCompliance) SetRpoDescription(v string) *DisruptionCompliance {
	s.RpoDescription = &v
	return s
}

// SetRpoReferenceId sets the RpoReferenceId field's value.
func (s *DisruptionCompliance) SetRpoReferenceId(v string) *DisruptionCompliance {
	s.RpoReferenceId = &v
	return s
}

// SetRtoDescription sets the RtoDescription field's value.
func (s *DisruptionCompliance) SetRtoDescription(v string) *DisruptionCompliance {
	s.RtoDescription = &v
	return s
}

// SetRtoReferenceId sets the RtoReferenceId field's value.
func (s *DisruptionCompliance) SetRtoReferenceId(v string) *DisruptionCompliance {
	s.RtoReferenceId = &v
	return s
}

// The input source of the Amazon Elastic Kubernetes Service cluster.
type EksSource struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon Elastic Kubernetes Service cluster.
	// The format for this ARN is: arn:aws:eks:region:account-id:cluster/cluster-name.
	// For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// EksClusterArn is a required field
	EksClusterArn *string `locationName:"eksClusterArn" type:"string" required:"true"`

	// The list of namespaces located on your Amazon Elastic Kubernetes Service
	// cluster.
	//
	// Namespaces is a required field
	Namespaces []*string `locationName:"namespaces" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EksSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EksSource"}
	if s.EksClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EksClusterArn"))
	}
	if s.Namespaces == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespaces"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEksClusterArn sets the EksClusterArn field's value.
func (s *EksSource) SetEksClusterArn(v string) *EksSource {
	s.EksClusterArn = &v
	return s
}

// SetNamespaces sets the Namespaces field's value.
func (s *EksSource) SetNamespaces(v []*string) *EksSource {
	s.Namespaces = v
	return s
}

// The input source of the namespace that is located on your Amazon Elastic
// Kubernetes Service cluster.
type EksSourceClusterNamespace struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon Elastic Kubernetes Service cluster.
	// The format for this ARN is: arn:aws:eks:region:account-id:cluster/cluster-name.
	// For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// EksClusterArn is a required field
	EksClusterArn *string `locationName:"eksClusterArn" type:"string" required:"true"`

	// Name of the namespace that is located on your Amazon Elastic Kubernetes Service
	// cluster.
	//
	// Namespace is a required field
	Namespace *string `locationName:"namespace" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksSourceClusterNamespace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksSourceClusterNamespace) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EksSourceClusterNamespace) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EksSourceClusterNamespace"}
	if s.EksClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EksClusterArn"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEksClusterArn sets the EksClusterArn field's value.
func (s *EksSourceClusterNamespace) SetEksClusterArn(v string) *EksSourceClusterNamespace {
	s.EksClusterArn = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *EksSourceClusterNamespace) SetNamespace(v string) *EksSourceClusterNamespace {
	s.Namespace = &v
	return s
}

// Indicates an event you would like to subscribe and get notification for.
// Currently, Resilience Hub supports notifications only for Drift detected
// and Scheduled assessment failure events.
type EventSubscription struct {
	_ struct{} `type:"structure"`

	// The type of event you would like to subscribe and get notification for. Currently,
	// Resilience Hub supports notifications only for Drift detected (DriftDetected)
	// and Scheduled assessment failure (ScheduledAssessmentFailure) events.
	//
	// EventType is a required field
	EventType *string `locationName:"eventType" type:"string" required:"true" enum:"EventType"`

	// Unique name to identify an event subscription.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic.
	// The format for this ARN is: arn:partition:sns:region:account:topic-name.
	// For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	SnsTopicArn *string `locationName:"snsTopicArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventSubscription) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventSubscription) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventSubscription"}
	if s.EventType == nil {
		invalidParams.Add(request.NewErrParamRequired("EventType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventType sets the EventType field's value.
func (s *EventSubscription) SetEventType(v string) *EventSubscription {
	s.EventType = &v
	return s
}

// SetName sets the Name field's value.
func (s *EventSubscription) SetName(v string) *EventSubscription {
	s.Name = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *EventSubscription) SetSnsTopicArn(v string) *EventSubscription {
	s.SnsTopicArn = &v
	return s
}

// Defines a failure policy.
type FailurePolicy struct {
	_ struct{} `type:"structure"`

	// Recovery Point Objective (RPO) in seconds.
	//
	// RpoInSecs is a required field
	RpoInSecs *int64 `locationName:"rpoInSecs" type:"integer" required:"true"`

	// Recovery Time Objective (RTO) in seconds.
	//
	// RtoInSecs is a required field
	RtoInSecs *int64 `locationName:"rtoInSecs" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailurePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailurePolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FailurePolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FailurePolicy"}
	if s.RpoInSecs == nil {
		invalidParams.Add(request.NewErrParamRequired("RpoInSecs"))
	}
	if s.RtoInSecs == nil {
		invalidParams.Add(request.NewErrParamRequired("RtoInSecs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRpoInSecs sets the RpoInSecs field's value.
func (s *FailurePolicy) SetRpoInSecs(v int64) *FailurePolicy {
	s.RpoInSecs = &v
	return s
}

// SetRtoInSecs sets the RtoInSecs field's value.
func (s *FailurePolicy) SetRtoInSecs(v int64) *FailurePolicy {
	s.RtoInSecs = &v
	return s
}

type ImportResourcesToDraftAppVersionInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The input sources of the Amazon Elastic Kubernetes Service resources you
	// need to import.
	EksSources []*EksSource `locationName:"eksSources" type:"list"`

	// The import strategy you would like to set to import resources into Resilience
	// Hub application.
	ImportStrategy *string `locationName:"importStrategy" type:"string" enum:"ResourceImportStrategyType"`

	// The Amazon Resource Names (ARNs) for the resources.
	SourceArns []*string `locationName:"sourceArns" type:"list"`

	// A list of terraform file s3 URLs you need to import.
	TerraformSources []*TerraformSource `locationName:"terraformSources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportResourcesToDraftAppVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportResourcesToDraftAppVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportResourcesToDraftAppVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportResourcesToDraftAppVersionInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.EksSources != nil {
		for i, v := range s.EksSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EksSources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TerraformSources != nil {
		for i, v := range s.TerraformSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TerraformSources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *ImportResourcesToDraftAppVersionInput) SetAppArn(v string) *ImportResourcesToDraftAppVersionInput {
	s.AppArn = &v
	return s
}

// SetEksSources sets the EksSources field's value.
func (s *ImportResourcesToDraftAppVersionInput) SetEksSources(v []*EksSource) *ImportResourcesToDraftAppVersionInput {
	s.EksSources = v
	return s
}

// SetImportStrategy sets the ImportStrategy field's value.
func (s *ImportResourcesToDraftAppVersionInput) SetImportStrategy(v string) *ImportResourcesToDraftAppVersionInput {
	s.ImportStrategy = &v
	return s
}

// SetSourceArns sets the SourceArns field's value.
func (s *ImportResourcesToDraftAppVersionInput) SetSourceArns(v []*string) *ImportResourcesToDraftAppVersionInput {
	s.SourceArns = v
	return s
}

// SetTerraformSources sets the TerraformSources field's value.
func (s *ImportResourcesToDraftAppVersionInput) SetTerraformSources(v []*TerraformSource) *ImportResourcesToDraftAppVersionInput {
	s.TerraformSources = v
	return s
}

type ImportResourcesToDraftAppVersionOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The version of the application.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// The input sources of the Amazon Elastic Kubernetes Service resources you
	// have imported.
	EksSources []*EksSource `locationName:"eksSources" type:"list"`

	// The Amazon Resource Names (ARNs) for the resources you have imported.
	SourceArns []*string `locationName:"sourceArns" type:"list"`

	// Status of the action.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ResourceImportStatusType"`

	// A list of terraform file s3 URLs you have imported.
	TerraformSources []*TerraformSource `locationName:"terraformSources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportResourcesToDraftAppVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportResourcesToDraftAppVersionOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *ImportResourcesToDraftAppVersionOutput) SetAppArn(v string) *ImportResourcesToDraftAppVersionOutput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *ImportResourcesToDraftAppVersionOutput) SetAppVersion(v string) *ImportResourcesToDraftAppVersionOutput {
	s.AppVersion = &v
	return s
}

// SetEksSources sets the EksSources field's value.
func (s *ImportResourcesToDraftAppVersionOutput) SetEksSources(v []*EksSource) *ImportResourcesToDraftAppVersionOutput {
	s.EksSources = v
	return s
}

// SetSourceArns sets the SourceArns field's value.
func (s *ImportResourcesToDraftAppVersionOutput) SetSourceArns(v []*string) *ImportResourcesToDraftAppVersionOutput {
	s.SourceArns = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ImportResourcesToDraftAppVersionOutput) SetStatus(v string) *ImportResourcesToDraftAppVersionOutput {
	s.Status = &v
	return s
}

// SetTerraformSources sets the TerraformSources field's value.
func (s *ImportResourcesToDraftAppVersionOutput) SetTerraformSources(v []*TerraformSource) *ImportResourcesToDraftAppVersionOutput {
	s.TerraformSources = v
	return s
}

// This exception occurs when there is an internal failure in the Resilience
// Hub service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAlarmRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
	// arn:partition:resiliencehub:region:account:app-assessment/app-id. For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AssessmentArn is a required field
	AssessmentArn *string `locationName:"assessmentArn" type:"string" required:"true"`

	// Maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAlarmRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAlarmRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAlarmRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAlarmRecommendationsInput"}
	if s.AssessmentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentArn sets the AssessmentArn field's value.
func (s *ListAlarmRecommendationsInput) SetAssessmentArn(v string) *ListAlarmRecommendationsInput {
	s.AssessmentArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAlarmRecommendationsInput) SetMaxResults(v int64) *ListAlarmRecommendationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAlarmRecommendationsInput) SetNextToken(v string) *ListAlarmRecommendationsInput {
	s.NextToken = &v
	return s
}

type ListAlarmRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// The alarm recommendations for an Resilience Hub application, returned as
	// an object. This object includes Application Component names, descriptions,
	// information about whether a recommendation has already been implemented or
	// not, prerequisites, and more.
	//
	// AlarmRecommendations is a required field
	AlarmRecommendations []*AlarmRecommendation `locationName:"alarmRecommendations" type:"list" required:"true"`

	// Token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAlarmRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAlarmRecommendationsOutput) GoString() string {
	return s.String()
}

// SetAlarmRecommendations sets the AlarmRecommendations field's value.
func (s *ListAlarmRecommendationsOutput) SetAlarmRecommendations(v []*AlarmRecommendation) *ListAlarmRecommendationsOutput {
	s.AlarmRecommendations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAlarmRecommendationsOutput) SetNextToken(v string) *ListAlarmRecommendationsOutput {
	s.NextToken = &v
	return s
}

type ListAppAssessmentComplianceDriftsInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
	// arn:partition:resiliencehub:region:account:app-assessment/app-id. For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AssessmentArn is a required field
	AssessmentArn *string `locationName:"assessmentArn" type:"string" required:"true"`

	// Indicates the maximum number of applications requested.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Indicates the unique token number of the next application to be checked for
	// compliance and regulatory requirements from the list of applications.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppAssessmentComplianceDriftsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppAssessmentComplianceDriftsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppAssessmentComplianceDriftsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppAssessmentComplianceDriftsInput"}
	if s.AssessmentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentArn sets the AssessmentArn field's value.
func (s *ListAppAssessmentComplianceDriftsInput) SetAssessmentArn(v string) *ListAppAssessmentComplianceDriftsInput {
	s.AssessmentArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppAssessmentComplianceDriftsInput) SetMaxResults(v int64) *ListAppAssessmentComplianceDriftsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppAssessmentComplianceDriftsInput) SetNextToken(v string) *ListAppAssessmentComplianceDriftsInput {
	s.NextToken = &v
	return s
}

type ListAppAssessmentComplianceDriftsOutput struct {
	_ struct{} `type:"structure"`

	// Indicates compliance drifts (recovery time objective (RTO) and recovery point
	// objective (RPO)) detected for an assessed entity.
	//
	// ComplianceDrifts is a required field
	ComplianceDrifts []*ComplianceDrift `locationName:"complianceDrifts" type:"list" required:"true"`

	// Token number of the next application to be checked for compliance and regulatory
	// requirements from the list of applications.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppAssessmentComplianceDriftsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppAssessmentComplianceDriftsOutput) GoString() string {
	return s.String()
}

// SetComplianceDrifts sets the ComplianceDrifts field's value.
func (s *ListAppAssessmentComplianceDriftsOutput) SetComplianceDrifts(v []*ComplianceDrift) *ListAppAssessmentComplianceDriftsOutput {
	s.ComplianceDrifts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppAssessmentComplianceDriftsOutput) SetNextToken(v string) *ListAppAssessmentComplianceDriftsOutput {
	s.NextToken = &v
	return s
}

type ListAppAssessmentResourceDriftsInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
	// arn:partition:resiliencehub:region:account:app-assessment/app-id. For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AssessmentArn is a required field
	AssessmentArn *string `locationName:"assessmentArn" type:"string" required:"true"`

	// Indicates the maximum number of drift results to include in the response.
	// If more results exist than the specified MaxResults value, a token is included
	// in the response so that the remaining results can be retrieved.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppAssessmentResourceDriftsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppAssessmentResourceDriftsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppAssessmentResourceDriftsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppAssessmentResourceDriftsInput"}
	if s.AssessmentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentArn sets the AssessmentArn field's value.
func (s *ListAppAssessmentResourceDriftsInput) SetAssessmentArn(v string) *ListAppAssessmentResourceDriftsInput {
	s.AssessmentArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppAssessmentResourceDriftsInput) SetMaxResults(v int64) *ListAppAssessmentResourceDriftsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppAssessmentResourceDriftsInput) SetNextToken(v string) *ListAppAssessmentResourceDriftsInput {
	s.NextToken = &v
	return s
}

type ListAppAssessmentResourceDriftsOutput struct {
	_ struct{} `type:"structure"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Indicates all the resource drifts detected for an assessed entity.
	//
	// ResourceDrifts is a required field
	ResourceDrifts []*ResourceDrift `locationName:"resourceDrifts" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppAssessmentResourceDriftsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppAssessmentResourceDriftsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppAssessmentResourceDriftsOutput) SetNextToken(v string) *ListAppAssessmentResourceDriftsOutput {
	s.NextToken = &v
	return s
}

// SetResourceDrifts sets the ResourceDrifts field's value.
func (s *ListAppAssessmentResourceDriftsOutput) SetResourceDrifts(v []*ResourceDrift) *ListAppAssessmentResourceDriftsOutput {
	s.ResourceDrifts = v
	return s
}

type ListAppAssessmentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	AppArn *string `location:"querystring" locationName:"appArn" type:"string"`

	// The name for the assessment.
	AssessmentName *string `location:"querystring" locationName:"assessmentName" type:"string"`

	// The current status of the assessment for the resiliency policy.
	AssessmentStatus []*string `location:"querystring" locationName:"assessmentStatus" min:"1" type:"list" enum:"AssessmentStatus"`

	// The current status of compliance for the resiliency policy.
	ComplianceStatus *string `location:"querystring" locationName:"complianceStatus" type:"string" enum:"ComplianceStatus"`

	// Specifies the entity that invoked a specific assessment, either a User or
	// the System.
	Invoker *string `location:"querystring" locationName:"invoker" type:"string" enum:"AssessmentInvoker"`

	// Maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The default is to sort by ascending startTime. To sort by descending startTime,
	// set reverseOrder to true.
	ReverseOrder *bool `location:"querystring" locationName:"reverseOrder" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppAssessmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppAssessmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppAssessmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppAssessmentsInput"}
	if s.AssessmentStatus != nil && len(s.AssessmentStatus) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentStatus", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *ListAppAssessmentsInput) SetAppArn(v string) *ListAppAssessmentsInput {
	s.AppArn = &v
	return s
}

// SetAssessmentName sets the AssessmentName field's value.
func (s *ListAppAssessmentsInput) SetAssessmentName(v string) *ListAppAssessmentsInput {
	s.AssessmentName = &v
	return s
}

// SetAssessmentStatus sets the AssessmentStatus field's value.
func (s *ListAppAssessmentsInput) SetAssessmentStatus(v []*string) *ListAppAssessmentsInput {
	s.AssessmentStatus = v
	return s
}

// SetComplianceStatus sets the ComplianceStatus field's value.
func (s *ListAppAssessmentsInput) SetComplianceStatus(v string) *ListAppAssessmentsInput {
	s.ComplianceStatus = &v
	return s
}

// SetInvoker sets the Invoker field's value.
func (s *ListAppAssessmentsInput) SetInvoker(v string) *ListAppAssessmentsInput {
	s.Invoker = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppAssessmentsInput) SetMaxResults(v int64) *ListAppAssessmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppAssessmentsInput) SetNextToken(v string) *ListAppAssessmentsInput {
	s.NextToken = &v
	return s
}

// SetReverseOrder sets the ReverseOrder field's value.
func (s *ListAppAssessmentsInput) SetReverseOrder(v bool) *ListAppAssessmentsInput {
	s.ReverseOrder = &v
	return s
}

type ListAppAssessmentsOutput struct {
	_ struct{} `type:"structure"`

	// The summaries for the specified assessments, returned as an object. This
	// object includes application versions, associated Amazon Resource Numbers
	// (ARNs), cost, messages, resiliency scores, and more.
	//
	// AssessmentSummaries is a required field
	AssessmentSummaries []*AppAssessmentSummary `locationName:"assessmentSummaries" type:"list" required:"true"`

	// Token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppAssessmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppAssessmentsOutput) GoString() string {
	return s.String()
}

// SetAssessmentSummaries sets the AssessmentSummaries field's value.
func (s *ListAppAssessmentsOutput) SetAssessmentSummaries(v []*AppAssessmentSummary) *ListAppAssessmentsOutput {
	s.AssessmentSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppAssessmentsOutput) SetNextToken(v string) *ListAppAssessmentsOutput {
	s.NextToken = &v
	return s
}

type ListAppComponentCompliancesInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
	// arn:partition:resiliencehub:region:account:app-assessment/app-id. For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AssessmentArn is a required field
	AssessmentArn *string `locationName:"assessmentArn" type:"string" required:"true"`

	// Maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppComponentCompliancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppComponentCompliancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppComponentCompliancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppComponentCompliancesInput"}
	if s.AssessmentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentArn sets the AssessmentArn field's value.
func (s *ListAppComponentCompliancesInput) SetAssessmentArn(v string) *ListAppComponentCompliancesInput {
	s.AssessmentArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppComponentCompliancesInput) SetMaxResults(v int64) *ListAppComponentCompliancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppComponentCompliancesInput) SetNextToken(v string) *ListAppComponentCompliancesInput {
	s.NextToken = &v
	return s
}

type ListAppComponentCompliancesOutput struct {
	_ struct{} `type:"structure"`

	// The compliances for an Resilience Hub Application Component, returned as
	// an object. This object contains the names of the Application Components,
	// compliances, costs, resiliency scores, outage scores, and more.
	//
	// ComponentCompliances is a required field
	ComponentCompliances []*AppComponentCompliance `locationName:"componentCompliances" type:"list" required:"true"`

	// Token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppComponentCompliancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppComponentCompliancesOutput) GoString() string {
	return s.String()
}

// SetComponentCompliances sets the ComponentCompliances field's value.
func (s *ListAppComponentCompliancesOutput) SetComponentCompliances(v []*AppComponentCompliance) *ListAppComponentCompliancesOutput {
	s.ComponentCompliances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppComponentCompliancesOutput) SetNextToken(v string) *ListAppComponentCompliancesOutput {
	s.NextToken = &v
	return s
}

type ListAppComponentRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
	// arn:partition:resiliencehub:region:account:app-assessment/app-id. For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AssessmentArn is a required field
	AssessmentArn *string `locationName:"assessmentArn" type:"string" required:"true"`

	// Maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppComponentRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppComponentRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppComponentRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppComponentRecommendationsInput"}
	if s.AssessmentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentArn sets the AssessmentArn field's value.
func (s *ListAppComponentRecommendationsInput) SetAssessmentArn(v string) *ListAppComponentRecommendationsInput {
	s.AssessmentArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppComponentRecommendationsInput) SetMaxResults(v int64) *ListAppComponentRecommendationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppComponentRecommendationsInput) SetNextToken(v string) *ListAppComponentRecommendationsInput {
	s.NextToken = &v
	return s
}

type ListAppComponentRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// The recommendations for an Resilience Hub Application Component, returned
	// as an object. This object contains the names of the Application Components,
	// configuration recommendations, and recommendation statuses.
	//
	// ComponentRecommendations is a required field
	ComponentRecommendations []*ComponentRecommendation `locationName:"componentRecommendations" type:"list" required:"true"`

	// Token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppComponentRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppComponentRecommendationsOutput) GoString() string {
	return s.String()
}

// SetComponentRecommendations sets the ComponentRecommendations field's value.
func (s *ListAppComponentRecommendationsOutput) SetComponentRecommendations(v []*ComponentRecommendation) *ListAppComponentRecommendationsOutput {
	s.ComponentRecommendations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppComponentRecommendationsOutput) SetNextToken(v string) *ListAppComponentRecommendationsOutput {
	s.NextToken = &v
	return s
}

type ListAppInputSourcesInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Resilience Hub application version.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// Maximum number of input sources to be displayed per Resilience Hub application.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInputSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInputSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppInputSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppInputSourcesInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.AppVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AppVersion"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *ListAppInputSourcesInput) SetAppArn(v string) *ListAppInputSourcesInput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *ListAppInputSourcesInput) SetAppVersion(v string) *ListAppInputSourcesInput {
	s.AppVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppInputSourcesInput) SetMaxResults(v int64) *ListAppInputSourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInputSourcesInput) SetNextToken(v string) *ListAppInputSourcesInput {
	s.NextToken = &v
	return s
}

type ListAppInputSourcesOutput struct {
	_ struct{} `type:"structure"`

	// The list of Resilience Hub application input sources.
	//
	// AppInputSources is a required field
	AppInputSources []*AppInputSource `locationName:"appInputSources" type:"list" required:"true"`

	// Token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInputSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInputSourcesOutput) GoString() string {
	return s.String()
}

// SetAppInputSources sets the AppInputSources field's value.
func (s *ListAppInputSourcesOutput) SetAppInputSources(v []*AppInputSource) *ListAppInputSourcesOutput {
	s.AppInputSources = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInputSourcesOutput) SetNextToken(v string) *ListAppInputSourcesOutput {
	s.NextToken = &v
	return s
}

type ListAppVersionAppComponentsInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Version of the Application Component.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// Maximum number of Application Components to be displayed per Resilience Hub
	// application version.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppVersionAppComponentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppVersionAppComponentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppVersionAppComponentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppVersionAppComponentsInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.AppVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AppVersion"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *ListAppVersionAppComponentsInput) SetAppArn(v string) *ListAppVersionAppComponentsInput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *ListAppVersionAppComponentsInput) SetAppVersion(v string) *ListAppVersionAppComponentsInput {
	s.AppVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppVersionAppComponentsInput) SetMaxResults(v int64) *ListAppVersionAppComponentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppVersionAppComponentsInput) SetNextToken(v string) *ListAppVersionAppComponentsInput {
	s.NextToken = &v
	return s
}

type ListAppVersionAppComponentsOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Defines an Application Component.
	AppComponents []*AppComponent `locationName:"appComponents" type:"list"`

	// Resilience Hub application version.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// Token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppVersionAppComponentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppVersionAppComponentsOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *ListAppVersionAppComponentsOutput) SetAppArn(v string) *ListAppVersionAppComponentsOutput {
	s.AppArn = &v
	return s
}

// SetAppComponents sets the AppComponents field's value.
func (s *ListAppVersionAppComponentsOutput) SetAppComponents(v []*AppComponent) *ListAppVersionAppComponentsOutput {
	s.AppComponents = v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *ListAppVersionAppComponentsOutput) SetAppVersion(v string) *ListAppVersionAppComponentsOutput {
	s.AppVersion = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppVersionAppComponentsOutput) SetNextToken(v string) *ListAppVersionAppComponentsOutput {
	s.NextToken = &v
	return s
}

type ListAppVersionResourceMappingsInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The version of the application.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// Maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppVersionResourceMappingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppVersionResourceMappingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppVersionResourceMappingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppVersionResourceMappingsInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.AppVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AppVersion"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *ListAppVersionResourceMappingsInput) SetAppArn(v string) *ListAppVersionResourceMappingsInput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *ListAppVersionResourceMappingsInput) SetAppVersion(v string) *ListAppVersionResourceMappingsInput {
	s.AppVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppVersionResourceMappingsInput) SetMaxResults(v int64) *ListAppVersionResourceMappingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppVersionResourceMappingsInput) SetNextToken(v string) *ListAppVersionResourceMappingsInput {
	s.NextToken = &v
	return s
}

type ListAppVersionResourceMappingsOutput struct {
	_ struct{} `type:"structure"`

	// Token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Mappings used to map logical resources from the template to physical resources.
	// You can use the mapping type CFN_STACK if the application template uses a
	// logical stack name. Or you can map individual resources by using the mapping
	// type RESOURCE. We recommend using the mapping type CFN_STACK if the application
	// is backed by a CloudFormation stack.
	//
	// ResourceMappings is a required field
	ResourceMappings []*ResourceMapping `locationName:"resourceMappings" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppVersionResourceMappingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppVersionResourceMappingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppVersionResourceMappingsOutput) SetNextToken(v string) *ListAppVersionResourceMappingsOutput {
	s.NextToken = &v
	return s
}

// SetResourceMappings sets the ResourceMappings field's value.
func (s *ListAppVersionResourceMappingsOutput) SetResourceMappings(v []*ResourceMapping) *ListAppVersionResourceMappingsOutput {
	s.ResourceMappings = v
	return s
}

type ListAppVersionResourcesInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The version of the application.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// Maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The identifier for a specific resolution.
	ResolutionId *string `locationName:"resolutionId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppVersionResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppVersionResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppVersionResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppVersionResourcesInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.AppVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AppVersion"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResolutionId != nil && len(*s.ResolutionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolutionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *ListAppVersionResourcesInput) SetAppArn(v string) *ListAppVersionResourcesInput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *ListAppVersionResourcesInput) SetAppVersion(v string) *ListAppVersionResourcesInput {
	s.AppVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppVersionResourcesInput) SetMaxResults(v int64) *ListAppVersionResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppVersionResourcesInput) SetNextToken(v string) *ListAppVersionResourcesInput {
	s.NextToken = &v
	return s
}

// SetResolutionId sets the ResolutionId field's value.
func (s *ListAppVersionResourcesInput) SetResolutionId(v string) *ListAppVersionResourcesInput {
	s.ResolutionId = &v
	return s
}

type ListAppVersionResourcesOutput struct {
	_ struct{} `type:"structure"`

	// Token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The physical resources in the application version.
	//
	// PhysicalResources is a required field
	PhysicalResources []*PhysicalResource `locationName:"physicalResources" type:"list" required:"true"`

	// The ID for a specific resolution.
	//
	// ResolutionId is a required field
	ResolutionId *string `locationName:"resolutionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppVersionResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppVersionResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppVersionResourcesOutput) SetNextToken(v string) *ListAppVersionResourcesOutput {
	s.NextToken = &v
	return s
}

// SetPhysicalResources sets the PhysicalResources field's value.
func (s *ListAppVersionResourcesOutput) SetPhysicalResources(v []*PhysicalResource) *ListAppVersionResourcesOutput {
	s.PhysicalResources = v
	return s
}

// SetResolutionId sets the ResolutionId field's value.
func (s *ListAppVersionResourcesOutput) SetResolutionId(v string) *ListAppVersionResourcesOutput {
	s.ResolutionId = &v
	return s
}

type ListAppVersionsInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Upper limit of the time range to filter the application versions.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// Maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Lower limit of the time range to filter the application versions.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppVersionsInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *ListAppVersionsInput) SetAppArn(v string) *ListAppVersionsInput {
	s.AppArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ListAppVersionsInput) SetEndTime(v time.Time) *ListAppVersionsInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppVersionsInput) SetMaxResults(v int64) *ListAppVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppVersionsInput) SetNextToken(v string) *ListAppVersionsInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListAppVersionsInput) SetStartTime(v time.Time) *ListAppVersionsInput {
	s.StartTime = &v
	return s
}

type ListAppVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The version of the application.
	//
	// AppVersions is a required field
	AppVersions []*AppVersionSummary `locationName:"appVersions" type:"list" required:"true"`

	// Token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppVersionsOutput) GoString() string {
	return s.String()
}

// SetAppVersions sets the AppVersions field's value.
func (s *ListAppVersionsOutput) SetAppVersions(v []*AppVersionSummary) *ListAppVersionsOutput {
	s.AppVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppVersionsOutput) SetNextToken(v string) *ListAppVersionsOutput {
	s.NextToken = &v
	return s
}

type ListAppsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	AppArn *string `location:"querystring" locationName:"appArn" type:"string"`

	// Indicates the lower limit of the range that is used to filter applications
	// based on their last assessment times.
	FromLastAssessmentTime *time.Time `location:"querystring" locationName:"fromLastAssessmentTime" type:"timestamp"`

	// Maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The name for the one of the listed applications.
	Name *string `location:"querystring" locationName:"name" type:"string"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The application list is sorted based on the values of lastAppComplianceEvaluationTime
	// field. By default, application list is sorted in ascending order. To sort
	// the appliation list in descending order, set this field to True.
	ReverseOrder *bool `location:"querystring" locationName:"reverseOrder" type:"boolean"`

	// Indicates the upper limit of the range that is used to filter the applications
	// based on their last assessment times.
	ToLastAssessmentTime *time.Time `location:"querystring" locationName:"toLastAssessmentTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *ListAppsInput) SetAppArn(v string) *ListAppsInput {
	s.AppArn = &v
	return s
}

// SetFromLastAssessmentTime sets the FromLastAssessmentTime field's value.
func (s *ListAppsInput) SetFromLastAssessmentTime(v time.Time) *ListAppsInput {
	s.FromLastAssessmentTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppsInput) SetMaxResults(v int64) *ListAppsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListAppsInput) SetName(v string) *ListAppsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppsInput) SetNextToken(v string) *ListAppsInput {
	s.NextToken = &v
	return s
}

// SetReverseOrder sets the ReverseOrder field's value.
func (s *ListAppsInput) SetReverseOrder(v bool) *ListAppsInput {
	s.ReverseOrder = &v
	return s
}

// SetToLastAssessmentTime sets the ToLastAssessmentTime field's value.
func (s *ListAppsInput) SetToLastAssessmentTime(v time.Time) *ListAppsInput {
	s.ToLastAssessmentTime = &v
	return s
}

type ListAppsOutput struct {
	_ struct{} `type:"structure"`

	// Summaries for the Resilience Hub application.
	//
	// AppSummaries is a required field
	AppSummaries []*AppSummary `locationName:"appSummaries" type:"list" required:"true"`

	// Token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppsOutput) GoString() string {
	return s.String()
}

// SetAppSummaries sets the AppSummaries field's value.
func (s *ListAppsOutput) SetAppSummaries(v []*AppSummary) *ListAppsOutput {
	s.AppSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppsOutput) SetNextToken(v string) *ListAppsOutput {
	s.NextToken = &v
	return s
}

type ListRecommendationTemplatesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
	// arn:partition:resiliencehub:region:account:app-assessment/app-id. For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	AssessmentArn *string `location:"querystring" locationName:"assessmentArn" type:"string"`

	// Maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The name for one of the listed recommendation templates.
	Name *string `location:"querystring" locationName:"name" type:"string"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) for a recommendation template.
	RecommendationTemplateArn *string `location:"querystring" locationName:"recommendationTemplateArn" type:"string"`

	// The default is to sort by ascending startTime. To sort by descending startTime,
	// set reverseOrder to true.
	ReverseOrder *bool `location:"querystring" locationName:"reverseOrder" type:"boolean"`

	// Status of the action.
	Status []*string `location:"querystring" locationName:"status" min:"1" type:"list" enum:"RecommendationTemplateStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecommendationTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecommendationTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Status != nil && len(s.Status) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Status", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentArn sets the AssessmentArn field's value.
func (s *ListRecommendationTemplatesInput) SetAssessmentArn(v string) *ListRecommendationTemplatesInput {
	s.AssessmentArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecommendationTemplatesInput) SetMaxResults(v int64) *ListRecommendationTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListRecommendationTemplatesInput) SetName(v string) *ListRecommendationTemplatesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationTemplatesInput) SetNextToken(v string) *ListRecommendationTemplatesInput {
	s.NextToken = &v
	return s
}

// SetRecommendationTemplateArn sets the RecommendationTemplateArn field's value.
func (s *ListRecommendationTemplatesInput) SetRecommendationTemplateArn(v string) *ListRecommendationTemplatesInput {
	s.RecommendationTemplateArn = &v
	return s
}

// SetReverseOrder sets the ReverseOrder field's value.
func (s *ListRecommendationTemplatesInput) SetReverseOrder(v bool) *ListRecommendationTemplatesInput {
	s.ReverseOrder = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListRecommendationTemplatesInput) SetStatus(v []*string) *ListRecommendationTemplatesInput {
	s.Status = v
	return s
}

type ListRecommendationTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// Token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The recommendation templates for the Resilience Hub applications.
	RecommendationTemplates []*RecommendationTemplate `locationName:"recommendationTemplates" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationTemplatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationTemplatesOutput) SetNextToken(v string) *ListRecommendationTemplatesOutput {
	s.NextToken = &v
	return s
}

// SetRecommendationTemplates sets the RecommendationTemplates field's value.
func (s *ListRecommendationTemplatesOutput) SetRecommendationTemplates(v []*RecommendationTemplate) *ListRecommendationTemplatesOutput {
	s.RecommendationTemplates = v
	return s
}

type ListResiliencyPoliciesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the policy
	PolicyName *string `location:"querystring" locationName:"policyName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResiliencyPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResiliencyPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResiliencyPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResiliencyPoliciesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResiliencyPoliciesInput) SetMaxResults(v int64) *ListResiliencyPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResiliencyPoliciesInput) SetNextToken(v string) *ListResiliencyPoliciesInput {
	s.NextToken = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *ListResiliencyPoliciesInput) SetPolicyName(v string) *ListResiliencyPoliciesInput {
	s.PolicyName = &v
	return s
}

type ListResiliencyPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// Token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The resiliency policies for the Resilience Hub applications.
	//
	// ResiliencyPolicies is a required field
	ResiliencyPolicies []*ResiliencyPolicy `locationName:"resiliencyPolicies" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResiliencyPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResiliencyPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResiliencyPoliciesOutput) SetNextToken(v string) *ListResiliencyPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetResiliencyPolicies sets the ResiliencyPolicies field's value.
func (s *ListResiliencyPoliciesOutput) SetResiliencyPolicies(v []*ResiliencyPolicy) *ListResiliencyPoliciesOutput {
	s.ResiliencyPolicies = v
	return s
}

type ListSopRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
	// arn:partition:resiliencehub:region:account:app-assessment/app-id. For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AssessmentArn is a required field
	AssessmentArn *string `locationName:"assessmentArn" type:"string" required:"true"`

	// Maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSopRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSopRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSopRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSopRecommendationsInput"}
	if s.AssessmentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentArn sets the AssessmentArn field's value.
func (s *ListSopRecommendationsInput) SetAssessmentArn(v string) *ListSopRecommendationsInput {
	s.AssessmentArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSopRecommendationsInput) SetMaxResults(v int64) *ListSopRecommendationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSopRecommendationsInput) SetNextToken(v string) *ListSopRecommendationsInput {
	s.NextToken = &v
	return s
}

type ListSopRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// Token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The standard operating procedure (SOP) recommendations for the Resilience
	// Hub applications.
	//
	// SopRecommendations is a required field
	SopRecommendations []*SopRecommendation `locationName:"sopRecommendations" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSopRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSopRecommendationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSopRecommendationsOutput) SetNextToken(v string) *ListSopRecommendationsOutput {
	s.NextToken = &v
	return s
}

// SetSopRecommendations sets the SopRecommendations field's value.
func (s *ListSopRecommendationsOutput) SetSopRecommendations(v []*SopRecommendation) *ListSopRecommendationsOutput {
	s.SopRecommendations = v
	return s
}

type ListSuggestedResiliencyPoliciesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSuggestedResiliencyPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSuggestedResiliencyPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSuggestedResiliencyPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSuggestedResiliencyPoliciesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSuggestedResiliencyPoliciesInput) SetMaxResults(v int64) *ListSuggestedResiliencyPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSuggestedResiliencyPoliciesInput) SetNextToken(v string) *ListSuggestedResiliencyPoliciesInput {
	s.NextToken = &v
	return s
}

type ListSuggestedResiliencyPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// Token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The suggested resiliency policies for the Resilience Hub applications.
	//
	// ResiliencyPolicies is a required field
	ResiliencyPolicies []*ResiliencyPolicy `locationName:"resiliencyPolicies" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSuggestedResiliencyPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSuggestedResiliencyPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSuggestedResiliencyPoliciesOutput) SetNextToken(v string) *ListSuggestedResiliencyPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetResiliencyPolicies sets the ResiliencyPolicies field's value.
func (s *ListSuggestedResiliencyPoliciesOutput) SetResiliencyPolicies(v []*ResiliencyPolicy) *ListSuggestedResiliencyPoliciesOutput {
	s.ResiliencyPolicies = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) for a specific resource in your Resilience
	// Hub application.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Tags assigned to the resource. A tag is a label that you assign to an Amazon
	// Web Services resource. Each tag consists of a key/value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListTagsForResourceOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTestRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
	// arn:partition:resiliencehub:region:account:app-assessment/app-id. For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AssessmentArn is a required field
	AssessmentArn *string `locationName:"assessmentArn" type:"string" required:"true"`

	// Maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTestRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTestRecommendationsInput"}
	if s.AssessmentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentArn sets the AssessmentArn field's value.
func (s *ListTestRecommendationsInput) SetAssessmentArn(v string) *ListTestRecommendationsInput {
	s.AssessmentArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTestRecommendationsInput) SetMaxResults(v int64) *ListTestRecommendationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestRecommendationsInput) SetNextToken(v string) *ListTestRecommendationsInput {
	s.NextToken = &v
	return s
}

type ListTestRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// Token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The test recommendations for the Resilience Hub application.
	//
	// TestRecommendations is a required field
	TestRecommendations []*TestRecommendation `locationName:"testRecommendations" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestRecommendationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestRecommendationsOutput) SetNextToken(v string) *ListTestRecommendationsOutput {
	s.NextToken = &v
	return s
}

// SetTestRecommendations sets the TestRecommendations field's value.
func (s *ListTestRecommendationsOutput) SetTestRecommendations(v []*TestRecommendation) *ListTestRecommendationsOutput {
	s.TestRecommendations = v
	return s
}

type ListUnsupportedAppVersionResourcesInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The version of the application.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// Maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The identifier for a specific resolution.
	ResolutionId *string `locationName:"resolutionId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUnsupportedAppVersionResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUnsupportedAppVersionResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUnsupportedAppVersionResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUnsupportedAppVersionResourcesInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.AppVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AppVersion"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResolutionId != nil && len(*s.ResolutionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolutionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *ListUnsupportedAppVersionResourcesInput) SetAppArn(v string) *ListUnsupportedAppVersionResourcesInput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *ListUnsupportedAppVersionResourcesInput) SetAppVersion(v string) *ListUnsupportedAppVersionResourcesInput {
	s.AppVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUnsupportedAppVersionResourcesInput) SetMaxResults(v int64) *ListUnsupportedAppVersionResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUnsupportedAppVersionResourcesInput) SetNextToken(v string) *ListUnsupportedAppVersionResourcesInput {
	s.NextToken = &v
	return s
}

// SetResolutionId sets the ResolutionId field's value.
func (s *ListUnsupportedAppVersionResourcesInput) SetResolutionId(v string) *ListUnsupportedAppVersionResourcesInput {
	s.ResolutionId = &v
	return s
}

type ListUnsupportedAppVersionResourcesOutput struct {
	_ struct{} `type:"structure"`

	// Token for the next set of results, or null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The identifier for a specific resolution.
	//
	// ResolutionId is a required field
	ResolutionId *string `locationName:"resolutionId" min:"1" type:"string" required:"true"`

	// The unsupported resources for the application.
	//
	// UnsupportedResources is a required field
	UnsupportedResources []*UnsupportedResource `locationName:"unsupportedResources" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUnsupportedAppVersionResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUnsupportedAppVersionResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUnsupportedAppVersionResourcesOutput) SetNextToken(v string) *ListUnsupportedAppVersionResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResolutionId sets the ResolutionId field's value.
func (s *ListUnsupportedAppVersionResourcesOutput) SetResolutionId(v string) *ListUnsupportedAppVersionResourcesOutput {
	s.ResolutionId = &v
	return s
}

// SetUnsupportedResources sets the UnsupportedResources field's value.
func (s *ListUnsupportedAppVersionResourcesOutput) SetUnsupportedResources(v []*UnsupportedResource) *ListUnsupportedAppVersionResourcesOutput {
	s.UnsupportedResources = v
	return s
}

// Defines a logical resource identifier.
type LogicalResourceId struct {
	_ struct{} `type:"structure"`

	// Name of the Amazon Elastic Kubernetes Service cluster and namespace this
	// resource belongs to.
	//
	// This parameter accepts values in "eks-cluster/namespace" format.
	EksSourceName *string `locationName:"eksSourceName" min:"1" type:"string"`

	// Identifier of the resource.
	//
	// Identifier is a required field
	Identifier *string `locationName:"identifier" min:"1" type:"string" required:"true"`

	// The name of the CloudFormation stack this resource belongs to.
	LogicalStackName *string `locationName:"logicalStackName" min:"1" type:"string"`

	// The name of the resource group that this resource belongs to.
	ResourceGroupName *string `locationName:"resourceGroupName" type:"string"`

	// The name of the Terraform S3 state file this resource belongs to.
	TerraformSourceName *string `locationName:"terraformSourceName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogicalResourceId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogicalResourceId) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogicalResourceId) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogicalResourceId"}
	if s.EksSourceName != nil && len(*s.EksSourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EksSourceName", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.LogicalStackName != nil && len(*s.LogicalStackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogicalStackName", 1))
	}
	if s.TerraformSourceName != nil && len(*s.TerraformSourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TerraformSourceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEksSourceName sets the EksSourceName field's value.
func (s *LogicalResourceId) SetEksSourceName(v string) *LogicalResourceId {
	s.EksSourceName = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *LogicalResourceId) SetIdentifier(v string) *LogicalResourceId {
	s.Identifier = &v
	return s
}

// SetLogicalStackName sets the LogicalStackName field's value.
func (s *LogicalResourceId) SetLogicalStackName(v string) *LogicalResourceId {
	s.LogicalStackName = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *LogicalResourceId) SetResourceGroupName(v string) *LogicalResourceId {
	s.ResourceGroupName = &v
	return s
}

// SetTerraformSourceName sets the TerraformSourceName field's value.
func (s *LogicalResourceId) SetTerraformSourceName(v string) *LogicalResourceId {
	s.TerraformSourceName = &v
	return s
}

// Defines the roles and credentials that Resilience Hub would use while creating
// the application, importing its resources, and running an assessment.
type PermissionModel struct {
	_ struct{} `type:"structure"`

	// Defines a list of role Amazon Resource Names (ARNs) to be used in other accounts.
	// These ARNs are used for querying purposes while importing resources and assessing
	// your application.
	//
	//    * These ARNs are required only when your resources are in other accounts
	//    and you have different role name in these accounts. Else, the invoker
	//    role name will be used in the other accounts.
	//
	//    * These roles must have a trust policy with iam:AssumeRole permission
	//    to the invoker role in the primary account.
	CrossAccountRoleArns []*string `locationName:"crossAccountRoleArns" type:"list"`

	// Existing Amazon Web Services IAM role name in the primary Amazon Web Services
	// account that will be assumed by Resilience Hub Service Principle to obtain
	// a read-only access to your application resources while running an assessment.
	//
	//    * You must have iam:passRole permission for this role while creating or
	//    updating the application.
	//
	//    * Currently, invokerRoleName accepts only [A-Za-z0-9_+=,.@-] characters.
	InvokerRoleName *string `locationName:"invokerRoleName" type:"string"`

	// Defines how Resilience Hub scans your resources. It can scan for the resources
	// by using a pre-existing role in your Amazon Web Services account, or by using
	// the credentials of the current IAM user.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"PermissionModelType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionModel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PermissionModel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PermissionModel"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrossAccountRoleArns sets the CrossAccountRoleArns field's value.
func (s *PermissionModel) SetCrossAccountRoleArns(v []*string) *PermissionModel {
	s.CrossAccountRoleArns = v
	return s
}

// SetInvokerRoleName sets the InvokerRoleName field's value.
func (s *PermissionModel) SetInvokerRoleName(v string) *PermissionModel {
	s.InvokerRoleName = &v
	return s
}

// SetType sets the Type field's value.
func (s *PermissionModel) SetType(v string) *PermissionModel {
	s.Type = &v
	return s
}

// Defines a physical resource. A physical resource is a resource that exists
// in your account. It can be identified using an Amazon Resource Name (ARN)
// or an Resilience Hub-native identifier.
type PhysicalResource struct {
	_ struct{} `type:"structure"`

	// Additional configuration parameters for an Resilience Hub application. If
	// you want to implement additionalInfo through the Resilience Hub console rather
	// than using an API call, see Configure the application configuration parameters
	// (https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
	//
	// Currently, this parameter accepts a key-value mapping (in a string format)
	// of only one failover region and one associated account.
	//
	// Key: "failover-regions"
	//
	// Value: "[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"
	AdditionalInfo map[string][]*string `locationName:"additionalInfo" type:"map"`

	// The application components that belong to this resource.
	AppComponents []*AppComponent `locationName:"appComponents" type:"list"`

	// Indicates if a resource is included or excluded from the assessment.
	Excluded *bool `locationName:"excluded" type:"boolean"`

	// Logical identifier of the resource.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *LogicalResourceId `locationName:"logicalResourceId" type:"structure" required:"true"`

	// Name of the parent resource.
	ParentResourceName *string `locationName:"parentResourceName" type:"string"`

	// Identifier of the physical resource.
	//
	// PhysicalResourceId is a required field
	PhysicalResourceId *PhysicalResourceId `locationName:"physicalResourceId" type:"structure" required:"true"`

	// The name of the resource.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// Type of resource.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" min:"1" type:"string" required:"true"`

	// Type of input source.
	SourceType *string `locationName:"sourceType" type:"string" enum:"ResourceSourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhysicalResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhysicalResource) GoString() string {
	return s.String()
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *PhysicalResource) SetAdditionalInfo(v map[string][]*string) *PhysicalResource {
	s.AdditionalInfo = v
	return s
}

// SetAppComponents sets the AppComponents field's value.
func (s *PhysicalResource) SetAppComponents(v []*AppComponent) *PhysicalResource {
	s.AppComponents = v
	return s
}

// SetExcluded sets the Excluded field's value.
func (s *PhysicalResource) SetExcluded(v bool) *PhysicalResource {
	s.Excluded = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *PhysicalResource) SetLogicalResourceId(v *LogicalResourceId) *PhysicalResource {
	s.LogicalResourceId = v
	return s
}

// SetParentResourceName sets the ParentResourceName field's value.
func (s *PhysicalResource) SetParentResourceName(v string) *PhysicalResource {
	s.ParentResourceName = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *PhysicalResource) SetPhysicalResourceId(v *PhysicalResourceId) *PhysicalResource {
	s.PhysicalResourceId = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *PhysicalResource) SetResourceName(v string) *PhysicalResource {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *PhysicalResource) SetResourceType(v string) *PhysicalResource {
	s.ResourceType = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *PhysicalResource) SetSourceType(v string) *PhysicalResource {
	s.SourceType = &v
	return s
}

// Defines a physical resource identifier.
type PhysicalResourceId struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account that owns the physical resource.
	AwsAccountId *string `locationName:"awsAccountId" type:"string"`

	// The Amazon Web Services Region that the physical resource is located in.
	AwsRegion *string `locationName:"awsRegion" type:"string"`

	// Identifier of the physical resource.
	//
	// Identifier is a required field
	Identifier *string `locationName:"identifier" min:"1" type:"string" required:"true"`

	// Specifies the type of physical resource identifier.
	//
	// Arn
	//
	// The resource identifier is an Amazon Resource Name (ARN) and it can identify
	// the following list of resources:
	//
	//    * AWS::ECS::Service
	//
	//    * AWS::EFS::FileSystem
	//
	//    * AWS::ElasticLoadBalancingV2::LoadBalancer
	//
	//    * AWS::Lambda::Function
	//
	//    * AWS::SNS::Topic
	//
	// Native
	//
	// The resource identifier is an Resilience Hub-native identifier and it can
	// identify the following list of resources:
	//
	//    * AWS::ApiGateway::RestApi
	//
	//    * AWS::ApiGatewayV2::Api
	//
	//    * AWS::AutoScaling::AutoScalingGroup
	//
	//    * AWS::DocDB::DBCluster
	//
	//    * AWS::DocDB::DBGlobalCluster
	//
	//    * AWS::DocDB::DBInstance
	//
	//    * AWS::DynamoDB::GlobalTable
	//
	//    * AWS::DynamoDB::Table
	//
	//    * AWS::EC2::EC2Fleet
	//
	//    * AWS::EC2::Instance
	//
	//    * AWS::EC2::NatGateway
	//
	//    * AWS::EC2::Volume
	//
	//    * AWS::ElasticLoadBalancing::LoadBalancer
	//
	//    * AWS::RDS::DBCluster
	//
	//    * AWS::RDS::DBInstance
	//
	//    * AWS::RDS::GlobalCluster
	//
	//    * AWS::Route53::RecordSet
	//
	//    * AWS::S3::Bucket
	//
	//    * AWS::SQS::Queue
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"PhysicalIdentifierType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhysicalResourceId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhysicalResourceId) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PhysicalResourceId) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PhysicalResourceId"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *PhysicalResourceId) SetAwsAccountId(v string) *PhysicalResourceId {
	s.AwsAccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *PhysicalResourceId) SetAwsRegion(v string) *PhysicalResourceId {
	s.AwsRegion = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *PhysicalResourceId) SetIdentifier(v string) *PhysicalResourceId {
	s.Identifier = &v
	return s
}

// SetType sets the Type field's value.
func (s *PhysicalResourceId) SetType(v string) *PhysicalResourceId {
	s.Type = &v
	return s
}

type PublishAppVersionInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Name of the application version.
	VersionName *string `locationName:"versionName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishAppVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishAppVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublishAppVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PublishAppVersionInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *PublishAppVersionInput) SetAppArn(v string) *PublishAppVersionInput {
	s.AppArn = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *PublishAppVersionInput) SetVersionName(v string) *PublishAppVersionInput {
	s.VersionName = &v
	return s
}

type PublishAppVersionOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The version of the application.
	AppVersion *string `locationName:"appVersion" type:"string"`

	// Identifier of the application version.
	Identifier *int64 `locationName:"identifier" type:"long"`

	// Name of the application version.
	VersionName *string `locationName:"versionName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishAppVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishAppVersionOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *PublishAppVersionOutput) SetAppArn(v string) *PublishAppVersionOutput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *PublishAppVersionOutput) SetAppVersion(v string) *PublishAppVersionOutput {
	s.AppVersion = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *PublishAppVersionOutput) SetIdentifier(v int64) *PublishAppVersionOutput {
	s.Identifier = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *PublishAppVersionOutput) SetVersionName(v string) *PublishAppVersionOutput {
	s.VersionName = &v
	return s
}

type PutDraftAppVersionTemplateInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// A JSON string that provides information about your application structure.
	// To learn more about the appTemplateBody template, see the sample template
	// provided in the Examples section.
	//
	// The appTemplateBody JSON string has the following structure:
	//
	//    * resources The list of logical resources that must be included in the
	//    Resilience Hub application. Type: Array Don't add the resources that you
	//    want to exclude. Each resources array item includes the following fields:
	//    logicalResourceId Logical identifier of the resource. Type: Object Each
	//    logicalResourceId object includes the following fields: identifier Identifier
	//    of the resource. Type: String logicalStackName The name of the CloudFormation
	//    stack this resource belongs to. Type: String resourceGroupName The name
	//    of the resource group this resource belongs to. Type: String terraformSourceName
	//    The name of the Terraform S3 state file this resource belongs to. Type:
	//    String eksSourceName Name of the Amazon Elastic Kubernetes Service cluster
	//    and namespace this resource belongs to. This parameter accepts values
	//    in "eks-cluster/namespace" format. Type: String type The type of resource.
	//    Type: string name The name of the resource. Type: String additionalInfo
	//    Additional configuration parameters for an Resilience Hub application.
	//    If you want to implement additionalInfo through the Resilience Hub console
	//    rather than using an API call, see Configure the application configuration
	//    parameters (https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
	//    Currently, this parameter accepts a key-value mapping (in a string format)
	//    of only one failover region and one associated account. Key: "failover-regions"
	//    Value: "[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"
	//
	//    * appComponents List of Application Components that this resource belongs
	//    to. If an Application Component is not part of the Resilience Hub application,
	//    it will be added. Type: Array Each appComponents array item includes the
	//    following fields: name Name of the Application Component. Type: String
	//    type Type of Application Component. For more information about the types
	//    of Application Component, see Grouping resources in an AppComponent (https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html).
	//    Type: String resourceNames The list of included resources that are assigned
	//    to the Application Component. Type: Array of strings additionalInfo Additional
	//    configuration parameters for an Resilience Hub application. If you want
	//    to implement additionalInfo through the Resilience Hub console rather
	//    than using an API call, see Configure the application configuration parameters
	//    (https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
	//    Currently, this parameter accepts a key-value mapping (in a string format)
	//    of only one failover region and one associated account. Key: "failover-regions"
	//    Value: "[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"
	//
	//    * excludedResources The list of logical resource identifiers to be excluded
	//    from the application. Type: Array Don't add the resources that you want
	//    to include. Each excludedResources array item includes the following fields:
	//    logicalResourceIds Logical identifier of the resource. Type: Object You
	//    can configure only one of the following fields: logicalStackName resourceGroupName
	//    terraformSourceName eksSourceName Each logicalResourceIds object includes
	//    the following fields: identifier Identifier of the resource. Type: String
	//    logicalStackName The name of the CloudFormation stack this resource belongs
	//    to. Type: String resourceGroupName The name of the resource group this
	//    resource belongs to. Type: String terraformSourceName The name of the
	//    Terraform S3 state file this resource belongs to. Type: String eksSourceName
	//    Name of the Amazon Elastic Kubernetes Service cluster and namespace this
	//    resource belongs to. This parameter accepts values in "eks-cluster/namespace"
	//    format. Type: String
	//
	//    * version Resilience Hub application version.
	//
	//    * additionalInfo Additional configuration parameters for an Resilience
	//    Hub application. If you want to implement additionalInfo through the Resilience
	//    Hub console rather than using an API call, see Configure the application
	//    configuration parameters (https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
	//    Currently, this parameter accepts a key-value mapping (in a string format)
	//    of only one failover region and one associated account. Key: "failover-regions"
	//    Value: "[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"
	//
	// AppTemplateBody is a required field
	AppTemplateBody *string `locationName:"appTemplateBody" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDraftAppVersionTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDraftAppVersionTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDraftAppVersionTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDraftAppVersionTemplateInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.AppTemplateBody == nil {
		invalidParams.Add(request.NewErrParamRequired("AppTemplateBody"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *PutDraftAppVersionTemplateInput) SetAppArn(v string) *PutDraftAppVersionTemplateInput {
	s.AppArn = &v
	return s
}

// SetAppTemplateBody sets the AppTemplateBody field's value.
func (s *PutDraftAppVersionTemplateInput) SetAppTemplateBody(v string) *PutDraftAppVersionTemplateInput {
	s.AppTemplateBody = &v
	return s
}

type PutDraftAppVersionTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	AppArn *string `locationName:"appArn" type:"string"`

	// The version of the application.
	AppVersion *string `locationName:"appVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDraftAppVersionTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDraftAppVersionTemplateOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *PutDraftAppVersionTemplateOutput) SetAppArn(v string) *PutDraftAppVersionTemplateOutput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *PutDraftAppVersionTemplateOutput) SetAppVersion(v string) *PutDraftAppVersionTemplateOutput {
	s.AppVersion = &v
	return s
}

// Defines a disruption compliance recommendation.
type RecommendationDisruptionCompliance struct {
	_ struct{} `type:"structure"`

	// The expected compliance status after applying the recommended configuration
	// change.
	//
	// ExpectedComplianceStatus is a required field
	ExpectedComplianceStatus *string `locationName:"expectedComplianceStatus" type:"string" required:"true" enum:"ComplianceStatus"`

	// The expected Recovery Point Objective (RPO) description after applying the
	// recommended configuration change.
	ExpectedRpoDescription *string `locationName:"expectedRpoDescription" min:"1" type:"string"`

	// The expected RPO after applying the recommended configuration change.
	ExpectedRpoInSecs *int64 `locationName:"expectedRpoInSecs" type:"integer"`

	// The expected Recovery Time Objective (RTO) description after applying the
	// recommended configuration change.
	ExpectedRtoDescription *string `locationName:"expectedRtoDescription" min:"1" type:"string"`

	// The expected RTO after applying the recommended configuration change.
	ExpectedRtoInSecs *int64 `locationName:"expectedRtoInSecs" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationDisruptionCompliance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationDisruptionCompliance) GoString() string {
	return s.String()
}

// SetExpectedComplianceStatus sets the ExpectedComplianceStatus field's value.
func (s *RecommendationDisruptionCompliance) SetExpectedComplianceStatus(v string) *RecommendationDisruptionCompliance {
	s.ExpectedComplianceStatus = &v
	return s
}

// SetExpectedRpoDescription sets the ExpectedRpoDescription field's value.
func (s *RecommendationDisruptionCompliance) SetExpectedRpoDescription(v string) *RecommendationDisruptionCompliance {
	s.ExpectedRpoDescription = &v
	return s
}

// SetExpectedRpoInSecs sets the ExpectedRpoInSecs field's value.
func (s *RecommendationDisruptionCompliance) SetExpectedRpoInSecs(v int64) *RecommendationDisruptionCompliance {
	s.ExpectedRpoInSecs = &v
	return s
}

// SetExpectedRtoDescription sets the ExpectedRtoDescription field's value.
func (s *RecommendationDisruptionCompliance) SetExpectedRtoDescription(v string) *RecommendationDisruptionCompliance {
	s.ExpectedRtoDescription = &v
	return s
}

// SetExpectedRtoInSecs sets the ExpectedRtoInSecs field's value.
func (s *RecommendationDisruptionCompliance) SetExpectedRtoInSecs(v int64) *RecommendationDisruptionCompliance {
	s.ExpectedRtoInSecs = &v
	return s
}

// Defines a recommendation.
type RecommendationItem struct {
	_ struct{} `type:"structure"`

	// Specifies if the recommendation has already been implemented.
	AlreadyImplemented *bool `locationName:"alreadyImplemented" type:"boolean"`

	// Indicates the reason for excluding an operational recommendation.
	ExcludeReason *string `locationName:"excludeReason" type:"string" enum:"ExcludeRecommendationReason"`

	// Indicates if an operational recommendation item is excluded.
	Excluded *bool `locationName:"excluded" type:"boolean"`

	// Identifier of the resource.
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// Identifier of the target account.
	TargetAccountId *string `locationName:"targetAccountId" type:"string"`

	// The target region.
	TargetRegion *string `locationName:"targetRegion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationItem) GoString() string {
	return s.String()
}

// SetAlreadyImplemented sets the AlreadyImplemented field's value.
func (s *RecommendationItem) SetAlreadyImplemented(v bool) *RecommendationItem {
	s.AlreadyImplemented = &v
	return s
}

// SetExcludeReason sets the ExcludeReason field's value.
func (s *RecommendationItem) SetExcludeReason(v string) *RecommendationItem {
	s.ExcludeReason = &v
	return s
}

// SetExcluded sets the Excluded field's value.
func (s *RecommendationItem) SetExcluded(v bool) *RecommendationItem {
	s.Excluded = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *RecommendationItem) SetResourceId(v string) *RecommendationItem {
	s.ResourceId = &v
	return s
}

// SetTargetAccountId sets the TargetAccountId field's value.
func (s *RecommendationItem) SetTargetAccountId(v string) *RecommendationItem {
	s.TargetAccountId = &v
	return s
}

// SetTargetRegion sets the TargetRegion field's value.
func (s *RecommendationItem) SetTargetRegion(v string) *RecommendationItem {
	s.TargetRegion = &v
	return s
}

// Defines a recommendation template created with the CreateRecommendationTemplate
// action.
type RecommendationTemplate struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	AppArn *string `locationName:"appArn" type:"string"`

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
	// arn:partition:resiliencehub:region:account:app-assessment/app-id. For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AssessmentArn is a required field
	AssessmentArn *string `locationName:"assessmentArn" type:"string" required:"true"`

	// The end time for the action.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// Format of the recommendation template.
	//
	// CfnJson
	//
	// The template is CloudFormation JSON.
	//
	// CfnYaml
	//
	// The template is CloudFormation YAML.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"TemplateFormat"`

	// Message for the recommendation template.
	Message *string `locationName:"message" min:"1" type:"string"`

	// Name for the recommendation template.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Indicates if replacements are needed.
	NeedsReplacements *bool `locationName:"needsReplacements" type:"boolean"`

	// Identifiers for the recommendations used in the recommendation template.
	RecommendationIds []*string `locationName:"recommendationIds" min:"1" type:"list"`

	// Amazon Resource Name (ARN) for the recommendation template.
	//
	// RecommendationTemplateArn is a required field
	RecommendationTemplateArn *string `locationName:"recommendationTemplateArn" type:"string" required:"true"`

	// An array of strings that specify the recommendation template type or types.
	//
	// Alarm
	//
	// The template is an AlarmRecommendation template.
	//
	// Sop
	//
	// The template is a SopRecommendation template.
	//
	// Test
	//
	// The template is a TestRecommendation template.
	//
	// RecommendationTypes is a required field
	RecommendationTypes []*string `locationName:"recommendationTypes" min:"1" type:"list" required:"true" enum:"RenderRecommendationType"`

	// The start time for the action.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// Status of the action.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"RecommendationTemplateStatus"`

	// Tags assigned to the resource. A tag is a label that you assign to an Amazon
	// Web Services resource. Each tag consists of a key/value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RecommendationTemplate's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`

	// The file location of the template.
	TemplatesLocation *S3Location `locationName:"templatesLocation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationTemplate) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *RecommendationTemplate) SetAppArn(v string) *RecommendationTemplate {
	s.AppArn = &v
	return s
}

// SetAssessmentArn sets the AssessmentArn field's value.
func (s *RecommendationTemplate) SetAssessmentArn(v string) *RecommendationTemplate {
	s.AssessmentArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *RecommendationTemplate) SetEndTime(v time.Time) *RecommendationTemplate {
	s.EndTime = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *RecommendationTemplate) SetFormat(v string) *RecommendationTemplate {
	s.Format = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *RecommendationTemplate) SetMessage(v string) *RecommendationTemplate {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *RecommendationTemplate) SetName(v string) *RecommendationTemplate {
	s.Name = &v
	return s
}

// SetNeedsReplacements sets the NeedsReplacements field's value.
func (s *RecommendationTemplate) SetNeedsReplacements(v bool) *RecommendationTemplate {
	s.NeedsReplacements = &v
	return s
}

// SetRecommendationIds sets the RecommendationIds field's value.
func (s *RecommendationTemplate) SetRecommendationIds(v []*string) *RecommendationTemplate {
	s.RecommendationIds = v
	return s
}

// SetRecommendationTemplateArn sets the RecommendationTemplateArn field's value.
func (s *RecommendationTemplate) SetRecommendationTemplateArn(v string) *RecommendationTemplate {
	s.RecommendationTemplateArn = &v
	return s
}

// SetRecommendationTypes sets the RecommendationTypes field's value.
func (s *RecommendationTemplate) SetRecommendationTypes(v []*string) *RecommendationTemplate {
	s.RecommendationTypes = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *RecommendationTemplate) SetStartTime(v time.Time) *RecommendationTemplate {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RecommendationTemplate) SetStatus(v string) *RecommendationTemplate {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RecommendationTemplate) SetTags(v map[string]*string) *RecommendationTemplate {
	s.Tags = v
	return s
}

// SetTemplatesLocation sets the TemplatesLocation field's value.
func (s *RecommendationTemplate) SetTemplatesLocation(v *S3Location) *RecommendationTemplate {
	s.TemplatesLocation = v
	return s
}

type RemoveDraftAppVersionResourceMappingsInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The names of the registered applications you want to remove from the resource
	// mappings.
	AppRegistryAppNames []*string `locationName:"appRegistryAppNames" type:"list"`

	// The names of the Amazon Elastic Kubernetes Service clusters and namespaces
	// you want to remove from the resource mappings.
	//
	// This parameter accepts values in "eks-cluster/namespace" format.
	EksSourceNames []*string `locationName:"eksSourceNames" type:"list"`

	// The names of the CloudFormation stacks you want to remove from the resource
	// mappings.
	LogicalStackNames []*string `locationName:"logicalStackNames" type:"list"`

	// The names of the resource groups you want to remove from the resource mappings.
	ResourceGroupNames []*string `locationName:"resourceGroupNames" type:"list"`

	// The names of the resources you want to remove from the resource mappings.
	ResourceNames []*string `locationName:"resourceNames" type:"list"`

	// The names of the Terraform sources you want to remove from the resource mappings.
	TerraformSourceNames []*string `locationName:"terraformSourceNames" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveDraftAppVersionResourceMappingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveDraftAppVersionResourceMappingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveDraftAppVersionResourceMappingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveDraftAppVersionResourceMappingsInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *RemoveDraftAppVersionResourceMappingsInput) SetAppArn(v string) *RemoveDraftAppVersionResourceMappingsInput {
	s.AppArn = &v
	return s
}

// SetAppRegistryAppNames sets the AppRegistryAppNames field's value.
func (s *RemoveDraftAppVersionResourceMappingsInput) SetAppRegistryAppNames(v []*string) *RemoveDraftAppVersionResourceMappingsInput {
	s.AppRegistryAppNames = v
	return s
}

// SetEksSourceNames sets the EksSourceNames field's value.
func (s *RemoveDraftAppVersionResourceMappingsInput) SetEksSourceNames(v []*string) *RemoveDraftAppVersionResourceMappingsInput {
	s.EksSourceNames = v
	return s
}

// SetLogicalStackNames sets the LogicalStackNames field's value.
func (s *RemoveDraftAppVersionResourceMappingsInput) SetLogicalStackNames(v []*string) *RemoveDraftAppVersionResourceMappingsInput {
	s.LogicalStackNames = v
	return s
}

// SetResourceGroupNames sets the ResourceGroupNames field's value.
func (s *RemoveDraftAppVersionResourceMappingsInput) SetResourceGroupNames(v []*string) *RemoveDraftAppVersionResourceMappingsInput {
	s.ResourceGroupNames = v
	return s
}

// SetResourceNames sets the ResourceNames field's value.
func (s *RemoveDraftAppVersionResourceMappingsInput) SetResourceNames(v []*string) *RemoveDraftAppVersionResourceMappingsInput {
	s.ResourceNames = v
	return s
}

// SetTerraformSourceNames sets the TerraformSourceNames field's value.
func (s *RemoveDraftAppVersionResourceMappingsInput) SetTerraformSourceNames(v []*string) *RemoveDraftAppVersionResourceMappingsInput {
	s.TerraformSourceNames = v
	return s
}

type RemoveDraftAppVersionResourceMappingsOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	AppArn *string `locationName:"appArn" type:"string"`

	// The version of the application.
	AppVersion *string `locationName:"appVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveDraftAppVersionResourceMappingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveDraftAppVersionResourceMappingsOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *RemoveDraftAppVersionResourceMappingsOutput) SetAppArn(v string) *RemoveDraftAppVersionResourceMappingsOutput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *RemoveDraftAppVersionResourceMappingsOutput) SetAppVersion(v string) *RemoveDraftAppVersionResourceMappingsOutput {
	s.AppVersion = &v
	return s
}

// Defines a resiliency policy.
//
// Resilience Hub allows you to provide a value of zero for rtoInSecs and rpoInSecs
// of your resiliency policy. But, while assessing your application, the lowest
// possible assessment result is near zero. Hence, if you provide value zero
// for rtoInSecs and rpoInSecs, the estimated workload RTO and estimated workload
// RPO result will be near zero and the Compliance status for your application
// will be set to Policy breached.
type ResiliencyPolicy struct {
	_ struct{} `type:"structure"`

	// Date and time when the resiliency policy was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// Specifies a high-level geographical location constraint for where your resilience
	// policy data can be stored.
	DataLocationConstraint *string `locationName:"dataLocationConstraint" type:"string" enum:"DataLocationConstraint"`

	// Specifies the estimated cost tier of the resiliency policy.
	EstimatedCostTier *string `locationName:"estimatedCostTier" type:"string" enum:"EstimatedCostTier"`

	// The resiliency policy.
	Policy map[string]*FailurePolicy `locationName:"policy" type:"map"`

	// Amazon Resource Name (ARN) of the resiliency policy. The format for this
	// ARN is: arn:partition:resiliencehub:region:account:resiliency-policy/policy-id.
	// For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The description for the policy.
	PolicyDescription *string `locationName:"policyDescription" type:"string"`

	// The name of the policy
	PolicyName *string `locationName:"policyName" type:"string"`

	// Tags assigned to the resource. A tag is a label that you assign to an Amazon
	// Web Services resource. Each tag consists of a key/value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ResiliencyPolicy's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`

	// The tier for this resiliency policy, ranging from the highest severity (MissionCritical)
	// to lowest (NonCritical).
	Tier *string `locationName:"tier" type:"string" enum:"ResiliencyPolicyTier"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResiliencyPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResiliencyPolicy) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResiliencyPolicy) SetCreationTime(v time.Time) *ResiliencyPolicy {
	s.CreationTime = &v
	return s
}

// SetDataLocationConstraint sets the DataLocationConstraint field's value.
func (s *ResiliencyPolicy) SetDataLocationConstraint(v string) *ResiliencyPolicy {
	s.DataLocationConstraint = &v
	return s
}

// SetEstimatedCostTier sets the EstimatedCostTier field's value.
func (s *ResiliencyPolicy) SetEstimatedCostTier(v string) *ResiliencyPolicy {
	s.EstimatedCostTier = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *ResiliencyPolicy) SetPolicy(v map[string]*FailurePolicy) *ResiliencyPolicy {
	s.Policy = v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *ResiliencyPolicy) SetPolicyArn(v string) *ResiliencyPolicy {
	s.PolicyArn = &v
	return s
}

// SetPolicyDescription sets the PolicyDescription field's value.
func (s *ResiliencyPolicy) SetPolicyDescription(v string) *ResiliencyPolicy {
	s.PolicyDescription = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *ResiliencyPolicy) SetPolicyName(v string) *ResiliencyPolicy {
	s.PolicyName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ResiliencyPolicy) SetTags(v map[string]*string) *ResiliencyPolicy {
	s.Tags = v
	return s
}

// SetTier sets the Tier field's value.
func (s *ResiliencyPolicy) SetTier(v string) *ResiliencyPolicy {
	s.Tier = &v
	return s
}

// The overall resiliency score, returned as an object that includes the disruption
// score and outage score.
type ResiliencyScore struct {
	_ struct{} `type:"structure"`

	// The score generated by Resilience Hub for the scoring component after running
	// an assessment.
	//
	// For example, if the score is 25 points, it indicates the overall score of
	// your application generated by Resilience Hub after running an assessment.
	ComponentScore map[string]*ScoringComponentResiliencyScore `locationName:"componentScore" type:"map"`

	// The disruption score for a valid key.
	//
	// DisruptionScore is a required field
	DisruptionScore map[string]*float64 `locationName:"disruptionScore" type:"map" required:"true"`

	// The outage score for a valid key.
	//
	// Score is a required field
	Score *float64 `locationName:"score" type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResiliencyScore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResiliencyScore) GoString() string {
	return s.String()
}

// SetComponentScore sets the ComponentScore field's value.
func (s *ResiliencyScore) SetComponentScore(v map[string]*ScoringComponentResiliencyScore) *ResiliencyScore {
	s.ComponentScore = v
	return s
}

// SetDisruptionScore sets the DisruptionScore field's value.
func (s *ResiliencyScore) SetDisruptionScore(v map[string]*float64) *ResiliencyScore {
	s.DisruptionScore = v
	return s
}

// SetScore sets the Score field's value.
func (s *ResiliencyScore) SetScore(v float64) *ResiliencyScore {
	s.Score = &v
	return s
}

type ResolveAppVersionResourcesInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The version of the application.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolveAppVersionResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolveAppVersionResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResolveAppVersionResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResolveAppVersionResourcesInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.AppVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AppVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *ResolveAppVersionResourcesInput) SetAppArn(v string) *ResolveAppVersionResourcesInput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *ResolveAppVersionResourcesInput) SetAppVersion(v string) *ResolveAppVersionResourcesInput {
	s.AppVersion = &v
	return s
}

type ResolveAppVersionResourcesOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The version of the application.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// The identifier for a specific resolution.
	//
	// ResolutionId is a required field
	ResolutionId *string `locationName:"resolutionId" min:"1" type:"string" required:"true"`

	// Status of the action.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ResourceResolutionStatusType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolveAppVersionResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolveAppVersionResourcesOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *ResolveAppVersionResourcesOutput) SetAppArn(v string) *ResolveAppVersionResourcesOutput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *ResolveAppVersionResourcesOutput) SetAppVersion(v string) *ResolveAppVersionResourcesOutput {
	s.AppVersion = &v
	return s
}

// SetResolutionId sets the ResolutionId field's value.
func (s *ResolveAppVersionResourcesOutput) SetResolutionId(v string) *ResolveAppVersionResourcesOutput {
	s.ResolutionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResolveAppVersionResourcesOutput) SetStatus(v string) *ResolveAppVersionResourcesOutput {
	s.Status = &v
	return s
}

// Indicates the resources that have drifted in the current application version.
type ResourceDrift struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the application whose resources have drifted.
	// The format for this ARN is: arn:partition:resiliencehub:region:account:app-assessment/app-id.
	// For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	AppArn *string `locationName:"appArn" type:"string"`

	// Version of the application whose resources have drifted.
	AppVersion *string `locationName:"appVersion" type:"string"`

	// Indicates if the resource was added or removed.
	DiffType *string `locationName:"diffType" type:"string" enum:"DifferenceType"`

	// Reference identifier of the resource drift.
	ReferenceId *string `locationName:"referenceId" type:"string"`

	// Identifier of the drifted resource.
	ResourceIdentifier *ResourceIdentifier `locationName:"resourceIdentifier" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDrift) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDrift) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *ResourceDrift) SetAppArn(v string) *ResourceDrift {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *ResourceDrift) SetAppVersion(v string) *ResourceDrift {
	s.AppVersion = &v
	return s
}

// SetDiffType sets the DiffType field's value.
func (s *ResourceDrift) SetDiffType(v string) *ResourceDrift {
	s.DiffType = &v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *ResourceDrift) SetReferenceId(v string) *ResourceDrift {
	s.ReferenceId = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ResourceDrift) SetResourceIdentifier(v *ResourceIdentifier) *ResourceDrift {
	s.ResourceIdentifier = v
	return s
}

// Defines application resource errors.
type ResourceError struct {
	_ struct{} `type:"structure"`

	// Identifier of the logical resource.
	LogicalResourceId *string `locationName:"logicalResourceId" min:"1" type:"string"`

	// Identifier of the physical resource.
	PhysicalResourceId *string `locationName:"physicalResourceId" min:"1" type:"string"`

	// This is the error message.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceError) GoString() string {
	return s.String()
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *ResourceError) SetLogicalResourceId(v string) *ResourceError {
	s.LogicalResourceId = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *ResourceError) SetPhysicalResourceId(v string) *ResourceError {
	s.PhysicalResourceId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ResourceError) SetReason(v string) *ResourceError {
	s.Reason = &v
	return s
}

// A list of errors retrieving an application's resources.
type ResourceErrorsDetails struct {
	_ struct{} `type:"structure"`

	// This indicates if there are more errors not listed in the resourceErrors
	// list.
	HasMoreErrors *bool `locationName:"hasMoreErrors" type:"boolean"`

	// A list of errors retrieving an application's resources.
	ResourceErrors []*ResourceError `locationName:"resourceErrors" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceErrorsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceErrorsDetails) GoString() string {
	return s.String()
}

// SetHasMoreErrors sets the HasMoreErrors field's value.
func (s *ResourceErrorsDetails) SetHasMoreErrors(v bool) *ResourceErrorsDetails {
	s.HasMoreErrors = &v
	return s
}

// SetResourceErrors sets the ResourceErrors field's value.
func (s *ResourceErrorsDetails) SetResourceErrors(v []*ResourceError) *ResourceErrorsDetails {
	s.ResourceErrors = v
	return s
}

// Defines a resource identifier for the drifted resource.
type ResourceIdentifier struct {
	_ struct{} `type:"structure"`

	// Logical identifier of the drifted resource.
	LogicalResourceId *LogicalResourceId `locationName:"logicalResourceId" type:"structure"`

	// Type of the drifted resource.
	ResourceType *string `locationName:"resourceType" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceIdentifier) GoString() string {
	return s.String()
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *ResourceIdentifier) SetLogicalResourceId(v *LogicalResourceId) *ResourceIdentifier {
	s.LogicalResourceId = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceIdentifier) SetResourceType(v string) *ResourceIdentifier {
	s.ResourceType = &v
	return s
}

// Defines a resource mapping.
type ResourceMapping struct {
	_ struct{} `type:"structure"`

	// Name of the application this resource is mapped to when the mappingType is
	// AppRegistryApp.
	AppRegistryAppName *string `locationName:"appRegistryAppName" type:"string"`

	// Name of the Amazon Elastic Kubernetes Service cluster and namespace that
	// this resource is mapped to when the mappingType is EKS.
	//
	// This parameter accepts values in "eks-cluster/namespace" format.
	EksSourceName *string `locationName:"eksSourceName" min:"1" type:"string"`

	// Name of the CloudFormation stack this resource is mapped to when the mappingType
	// is CfnStack.
	LogicalStackName *string `locationName:"logicalStackName" min:"1" type:"string"`

	// Specifies the type of resource mapping.
	//
	// MappingType is a required field
	MappingType *string `locationName:"mappingType" type:"string" required:"true" enum:"ResourceMappingType"`

	// Identifier of the physical resource.
	//
	// PhysicalResourceId is a required field
	PhysicalResourceId *PhysicalResourceId `locationName:"physicalResourceId" type:"structure" required:"true"`

	// Name of the Resource Groups that this resource is mapped to when the mappingType
	// is ResourceGroup.
	ResourceGroupName *string `locationName:"resourceGroupName" type:"string"`

	// Name of the resource that this resource is mapped to when the mappingType
	// is Resource.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// Name of the Terraform source that this resource is mapped to when the mappingType
	// is Terraform.
	TerraformSourceName *string `locationName:"terraformSourceName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceMapping"}
	if s.EksSourceName != nil && len(*s.EksSourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EksSourceName", 1))
	}
	if s.LogicalStackName != nil && len(*s.LogicalStackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogicalStackName", 1))
	}
	if s.MappingType == nil {
		invalidParams.Add(request.NewErrParamRequired("MappingType"))
	}
	if s.PhysicalResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhysicalResourceId"))
	}
	if s.TerraformSourceName != nil && len(*s.TerraformSourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TerraformSourceName", 1))
	}
	if s.PhysicalResourceId != nil {
		if err := s.PhysicalResourceId.Validate(); err != nil {
			invalidParams.AddNested("PhysicalResourceId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppRegistryAppName sets the AppRegistryAppName field's value.
func (s *ResourceMapping) SetAppRegistryAppName(v string) *ResourceMapping {
	s.AppRegistryAppName = &v
	return s
}

// SetEksSourceName sets the EksSourceName field's value.
func (s *ResourceMapping) SetEksSourceName(v string) *ResourceMapping {
	s.EksSourceName = &v
	return s
}

// SetLogicalStackName sets the LogicalStackName field's value.
func (s *ResourceMapping) SetLogicalStackName(v string) *ResourceMapping {
	s.LogicalStackName = &v
	return s
}

// SetMappingType sets the MappingType field's value.
func (s *ResourceMapping) SetMappingType(v string) *ResourceMapping {
	s.MappingType = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *ResourceMapping) SetPhysicalResourceId(v *PhysicalResourceId) *ResourceMapping {
	s.PhysicalResourceId = v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *ResourceMapping) SetResourceGroupName(v string) *ResourceMapping {
	s.ResourceGroupName = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ResourceMapping) SetResourceName(v string) *ResourceMapping {
	s.ResourceName = &v
	return s
}

// SetTerraformSourceName sets the TerraformSourceName field's value.
func (s *ResourceMapping) SetTerraformSourceName(v string) *ResourceMapping {
	s.TerraformSourceName = &v
	return s
}

// This exception occurs when the specified resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The identifier of the resource that the exception applies to.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of the resource that the exception applies to.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The location of the Amazon S3 bucket.
type S3Location struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket.
	Bucket *string `locationName:"bucket" min:"1" type:"string"`

	// The prefix for the Amazon S3 bucket.
	Prefix *string `locationName:"prefix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *S3Location) SetBucket(v string) *S3Location {
	s.Bucket = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3Location) SetPrefix(v string) *S3Location {
	s.Prefix = &v
	return s
}

// Resiliency score of each scoring component. For more information about scoring
// component, see Calculating resiliency score (https://docs.aws.amazon.com/resilience-hub/latest/userguide/calculate-score.html).
type ScoringComponentResiliencyScore struct {
	_ struct{} `type:"structure"`

	// Number of recommendations that were excluded from the assessment.
	//
	// For example, if the excludedCount for Alarms coverage scoring component is
	// 7, it indicates that 7 Amazon CloudWatch alarms are excluded from the assessment.
	ExcludedCount *int64 `locationName:"excludedCount" type:"long"`

	// Number of recommendations that must be implemented to obtain the maximum
	// possible score for the scoring component. For SOPs, alarms, and tests, these
	// are the number of recommendations that must be implemented. For compliance,
	// these are the number of Application Components that have breached the resiliency
	// policy.
	//
	// For example, if the outstandingCount for Alarms coverage scoring component
	// is 5, it indicates that 5 Amazon CloudWatch alarms need to be implemented
	// to achieve the maximum possible score.
	OutstandingCount *int64 `locationName:"outstandingCount" type:"long"`

	// Maximum possible score that can be obtained for the scoring component.
	//
	// For example, if the possibleScore is 20 points, it indicates the maximum
	// possible score you can achieve for the scoring component when you run a new
	// assessment after implementing all the Resilience Hub recommendations.
	PossibleScore *float64 `locationName:"possibleScore" type:"double"`

	// Resiliency score points given for the scoring component. The score is always
	// less than or equal to the possibleScore.
	Score *float64 `locationName:"score" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScoringComponentResiliencyScore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScoringComponentResiliencyScore) GoString() string {
	return s.String()
}

// SetExcludedCount sets the ExcludedCount field's value.
func (s *ScoringComponentResiliencyScore) SetExcludedCount(v int64) *ScoringComponentResiliencyScore {
	s.ExcludedCount = &v
	return s
}

// SetOutstandingCount sets the OutstandingCount field's value.
func (s *ScoringComponentResiliencyScore) SetOutstandingCount(v int64) *ScoringComponentResiliencyScore {
	s.OutstandingCount = &v
	return s
}

// SetPossibleScore sets the PossibleScore field's value.
func (s *ScoringComponentResiliencyScore) SetPossibleScore(v float64) *ScoringComponentResiliencyScore {
	s.PossibleScore = &v
	return s
}

// SetScore sets the Score field's value.
func (s *ScoringComponentResiliencyScore) SetScore(v float64) *ScoringComponentResiliencyScore {
	s.Score = &v
	return s
}

// This exception occurs when you have exceeded your service quota. To perform
// the requested action, remove some of the relevant resources, or use Service
// Quotas to request a service quota increase.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Defines a standard operating procedure (SOP) recommendation.
type SopRecommendation struct {
	_ struct{} `type:"structure"`

	// Name of the Application Component.
	AppComponentName *string `locationName:"appComponentName" type:"string"`

	// Description of the SOP recommendation.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The recommendation items.
	Items []*RecommendationItem `locationName:"items" type:"list"`

	// Name of the SOP recommendation.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Prerequisite for the SOP recommendation.
	Prerequisite *string `locationName:"prerequisite" min:"1" type:"string"`

	// Identifier for the SOP recommendation.
	//
	// RecommendationId is a required field
	RecommendationId *string `locationName:"recommendationId" type:"string" required:"true"`

	// Status of the recommended standard operating procedure.
	RecommendationStatus *string `locationName:"recommendationStatus" type:"string" enum:"RecommendationStatus"`

	// Reference identifier for the SOP recommendation.
	//
	// ReferenceId is a required field
	ReferenceId *string `locationName:"referenceId" min:"1" type:"string" required:"true"`

	// The service type.
	//
	// ServiceType is a required field
	ServiceType *string `locationName:"serviceType" type:"string" required:"true" enum:"SopServiceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SopRecommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SopRecommendation) GoString() string {
	return s.String()
}

// SetAppComponentName sets the AppComponentName field's value.
func (s *SopRecommendation) SetAppComponentName(v string) *SopRecommendation {
	s.AppComponentName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SopRecommendation) SetDescription(v string) *SopRecommendation {
	s.Description = &v
	return s
}

// SetItems sets the Items field's value.
func (s *SopRecommendation) SetItems(v []*RecommendationItem) *SopRecommendation {
	s.Items = v
	return s
}

// SetName sets the Name field's value.
func (s *SopRecommendation) SetName(v string) *SopRecommendation {
	s.Name = &v
	return s
}

// SetPrerequisite sets the Prerequisite field's value.
func (s *SopRecommendation) SetPrerequisite(v string) *SopRecommendation {
	s.Prerequisite = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *SopRecommendation) SetRecommendationId(v string) *SopRecommendation {
	s.RecommendationId = &v
	return s
}

// SetRecommendationStatus sets the RecommendationStatus field's value.
func (s *SopRecommendation) SetRecommendationStatus(v string) *SopRecommendation {
	s.RecommendationStatus = &v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *SopRecommendation) SetReferenceId(v string) *SopRecommendation {
	s.ReferenceId = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *SopRecommendation) SetServiceType(v string) *SopRecommendation {
	s.ServiceType = &v
	return s
}

type StartAppAssessmentInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The version of the application.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// The name for the assessment.
	//
	// AssessmentName is a required field
	AssessmentName *string `locationName:"assessmentName" type:"string" required:"true"`

	// Used for an idempotency token. A client token is a unique, case-sensitive
	// string of up to 64 ASCII characters. You should not reuse the same client
	// token for other API requests.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Tags assigned to the resource. A tag is a label that you assign to an Amazon
	// Web Services resource. Each tag consists of a key/value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartAppAssessmentInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAppAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAppAssessmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartAppAssessmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartAppAssessmentInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.AppVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AppVersion"))
	}
	if s.AssessmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentName"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *StartAppAssessmentInput) SetAppArn(v string) *StartAppAssessmentInput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *StartAppAssessmentInput) SetAppVersion(v string) *StartAppAssessmentInput {
	s.AppVersion = &v
	return s
}

// SetAssessmentName sets the AssessmentName field's value.
func (s *StartAppAssessmentInput) SetAssessmentName(v string) *StartAppAssessmentInput {
	s.AssessmentName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *StartAppAssessmentInput) SetClientToken(v string) *StartAppAssessmentInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartAppAssessmentInput) SetTags(v map[string]*string) *StartAppAssessmentInput {
	s.Tags = v
	return s
}

type StartAppAssessmentOutput struct {
	_ struct{} `type:"structure"`

	// The assessment created.
	//
	// Assessment is a required field
	Assessment *AppAssessment `locationName:"assessment" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAppAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAppAssessmentOutput) GoString() string {
	return s.String()
}

// SetAssessment sets the Assessment field's value.
func (s *StartAppAssessmentOutput) SetAssessment(v *AppAssessment) *StartAppAssessmentOutput {
	s.Assessment = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags to assign to the resource. Each tag consists of a key/value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TagResourceInput's
	// String and GoString methods.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The Terraform s3 state file you need to import.
type TerraformSource struct {
	_ struct{} `type:"structure"`

	// The URL of the Terraform s3 state file you need to import.
	//
	// S3StateFileUrl is a required field
	S3StateFileUrl *string `locationName:"s3StateFileUrl" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerraformSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerraformSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerraformSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerraformSource"}
	if s.S3StateFileUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("S3StateFileUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3StateFileUrl sets the S3StateFileUrl field's value.
func (s *TerraformSource) SetS3StateFileUrl(v string) *TerraformSource {
	s.S3StateFileUrl = &v
	return s
}

// Defines a test recommendation.
type TestRecommendation struct {
	_ struct{} `type:"structure"`

	// Name of the Application Component.
	AppComponentName *string `locationName:"appComponentName" type:"string"`

	// A list of recommended alarms that are used in the test and must be exported
	// before or with the test.
	DependsOnAlarms []*string `locationName:"dependsOnAlarms" min:"1" type:"list"`

	// Description for the test recommendation.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Intent of the test recommendation.
	Intent *string `locationName:"intent" type:"string"`

	// The test recommendation items.
	Items []*RecommendationItem `locationName:"items" type:"list"`

	// Name of the test recommendation.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Prerequisite of the test recommendation.
	Prerequisite *string `locationName:"prerequisite" min:"1" type:"string"`

	// Identifier for the test recommendation.
	RecommendationId *string `locationName:"recommendationId" type:"string"`

	// Status of the recommended test.
	RecommendationStatus *string `locationName:"recommendationStatus" type:"string" enum:"RecommendationStatus"`

	// Reference identifier for the test recommendation.
	//
	// ReferenceId is a required field
	ReferenceId *string `locationName:"referenceId" min:"1" type:"string" required:"true"`

	// Level of risk for this test recommendation.
	Risk *string `locationName:"risk" type:"string" enum:"TestRisk"`

	// Type of test recommendation.
	Type *string `locationName:"type" type:"string" enum:"TestType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestRecommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestRecommendation) GoString() string {
	return s.String()
}

// SetAppComponentName sets the AppComponentName field's value.
func (s *TestRecommendation) SetAppComponentName(v string) *TestRecommendation {
	s.AppComponentName = &v
	return s
}

// SetDependsOnAlarms sets the DependsOnAlarms field's value.
func (s *TestRecommendation) SetDependsOnAlarms(v []*string) *TestRecommendation {
	s.DependsOnAlarms = v
	return s
}

// SetDescription sets the Description field's value.
func (s *TestRecommendation) SetDescription(v string) *TestRecommendation {
	s.Description = &v
	return s
}

// SetIntent sets the Intent field's value.
func (s *TestRecommendation) SetIntent(v string) *TestRecommendation {
	s.Intent = &v
	return s
}

// SetItems sets the Items field's value.
func (s *TestRecommendation) SetItems(v []*RecommendationItem) *TestRecommendation {
	s.Items = v
	return s
}

// SetName sets the Name field's value.
func (s *TestRecommendation) SetName(v string) *TestRecommendation {
	s.Name = &v
	return s
}

// SetPrerequisite sets the Prerequisite field's value.
func (s *TestRecommendation) SetPrerequisite(v string) *TestRecommendation {
	s.Prerequisite = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *TestRecommendation) SetRecommendationId(v string) *TestRecommendation {
	s.RecommendationId = &v
	return s
}

// SetRecommendationStatus sets the RecommendationStatus field's value.
func (s *TestRecommendation) SetRecommendationStatus(v string) *TestRecommendation {
	s.RecommendationStatus = &v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *TestRecommendation) SetReferenceId(v string) *TestRecommendation {
	s.ReferenceId = &v
	return s
}

// SetRisk sets the Risk field's value.
func (s *TestRecommendation) SetRisk(v string) *TestRecommendation {
	s.Risk = &v
	return s
}

// SetType sets the Type field's value.
func (s *TestRecommendation) SetType(v string) *TestRecommendation {
	s.Type = &v
	return s
}

// This exception occurs when you have exceeded the limit on the number of requests
// per second.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The number of seconds to wait before retrying the operation.
	RetryAfterSeconds *int64 `locationName:"retryAfterSeconds" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Defines a resource that is not supported by Resilience Hub.
type UnsupportedResource struct {
	_ struct{} `type:"structure"`

	// Logical resource identifier for the unsupported resource.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *LogicalResourceId `locationName:"logicalResourceId" type:"structure" required:"true"`

	// Physical resource identifier for the unsupported resource.
	//
	// PhysicalResourceId is a required field
	PhysicalResourceId *PhysicalResourceId `locationName:"physicalResourceId" type:"structure" required:"true"`

	// The type of resource.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" min:"1" type:"string" required:"true"`

	// The status of the unsupported resource.
	UnsupportedResourceStatus *string `locationName:"unsupportedResourceStatus" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedResource) GoString() string {
	return s.String()
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *UnsupportedResource) SetLogicalResourceId(v *LogicalResourceId) *UnsupportedResource {
	s.LogicalResourceId = v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *UnsupportedResource) SetPhysicalResourceId(v *PhysicalResourceId) *UnsupportedResource {
	s.PhysicalResourceId = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *UnsupportedResource) SetResourceType(v string) *UnsupportedResource {
	s.ResourceType = &v
	return s
}

// SetUnsupportedResourceStatus sets the UnsupportedResourceStatus field's value.
func (s *UnsupportedResource) SetUnsupportedResourceStatus(v string) *UnsupportedResource {
	s.UnsupportedResourceStatus = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The keys of the tags you want to remove.
	//
	// TagKeys is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UntagResourceInput's
	// String and GoString methods.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAppInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Assessment execution schedule with 'Daily' or 'Disabled' values.
	AssessmentSchedule *string `locationName:"assessmentSchedule" type:"string" enum:"AppAssessmentScheduleType"`

	// Specifies if the resiliency policy ARN should be cleared.
	ClearResiliencyPolicyArn *bool `locationName:"clearResiliencyPolicyArn" type:"boolean"`

	// The optional description for an app.
	Description *string `locationName:"description" type:"string"`

	// The list of events you would like to subscribe and get notification for.
	// Currently, Resilience Hub supports notifications only for Drift detected
	// and Scheduled assessment failure events.
	EventSubscriptions []*EventSubscription `locationName:"eventSubscriptions" type:"list"`

	// Defines the roles and credentials that Resilience Hub would use while creating
	// an application, importing its resources, and running an assessment.
	PermissionModel *PermissionModel `locationName:"permissionModel" type:"structure"`

	// Amazon Resource Name (ARN) of the resiliency policy. The format for this
	// ARN is: arn:partition:resiliencehub:region:account:resiliency-policy/policy-id.
	// For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	PolicyArn *string `locationName:"policyArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAppInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.EventSubscriptions != nil {
		for i, v := range s.EventSubscriptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EventSubscriptions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PermissionModel != nil {
		if err := s.PermissionModel.Validate(); err != nil {
			invalidParams.AddNested("PermissionModel", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *UpdateAppInput) SetAppArn(v string) *UpdateAppInput {
	s.AppArn = &v
	return s
}

// SetAssessmentSchedule sets the AssessmentSchedule field's value.
func (s *UpdateAppInput) SetAssessmentSchedule(v string) *UpdateAppInput {
	s.AssessmentSchedule = &v
	return s
}

// SetClearResiliencyPolicyArn sets the ClearResiliencyPolicyArn field's value.
func (s *UpdateAppInput) SetClearResiliencyPolicyArn(v bool) *UpdateAppInput {
	s.ClearResiliencyPolicyArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAppInput) SetDescription(v string) *UpdateAppInput {
	s.Description = &v
	return s
}

// SetEventSubscriptions sets the EventSubscriptions field's value.
func (s *UpdateAppInput) SetEventSubscriptions(v []*EventSubscription) *UpdateAppInput {
	s.EventSubscriptions = v
	return s
}

// SetPermissionModel sets the PermissionModel field's value.
func (s *UpdateAppInput) SetPermissionModel(v *PermissionModel) *UpdateAppInput {
	s.PermissionModel = v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *UpdateAppInput) SetPolicyArn(v string) *UpdateAppInput {
	s.PolicyArn = &v
	return s
}

type UpdateAppOutput struct {
	_ struct{} `type:"structure"`

	// The specified application, returned as an object with details including compliance
	// status, creation time, description, resiliency score, and more.
	//
	// App is a required field
	App *App `locationName:"app" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppOutput) GoString() string {
	return s.String()
}

// SetApp sets the App field's value.
func (s *UpdateAppOutput) SetApp(v *App) *UpdateAppOutput {
	s.App = v
	return s
}

type UpdateAppVersionAppComponentInput struct {
	_ struct{} `type:"structure"`

	// Currently, there is no supported additional information for Application Components.
	AdditionalInfo map[string][]*string `locationName:"additionalInfo" type:"map"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Identifier of the Application Component.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Name of the Application Component.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Type of Application Component. For more information about the types of Application
	// Component, see Grouping resources in an AppComponent (https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html).
	Type *string `locationName:"type" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppVersionAppComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppVersionAppComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAppVersionAppComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAppVersionAppComponentInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *UpdateAppVersionAppComponentInput) SetAdditionalInfo(v map[string][]*string) *UpdateAppVersionAppComponentInput {
	s.AdditionalInfo = v
	return s
}

// SetAppArn sets the AppArn field's value.
func (s *UpdateAppVersionAppComponentInput) SetAppArn(v string) *UpdateAppVersionAppComponentInput {
	s.AppArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateAppVersionAppComponentInput) SetId(v string) *UpdateAppVersionAppComponentInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAppVersionAppComponentInput) SetName(v string) *UpdateAppVersionAppComponentInput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateAppVersionAppComponentInput) SetType(v string) *UpdateAppVersionAppComponentInput {
	s.Type = &v
	return s
}

type UpdateAppVersionAppComponentOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// List of Application Components that belong to this resource.
	AppComponent *AppComponent `locationName:"appComponent" type:"structure"`

	// Resilience Hub application version.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppVersionAppComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppVersionAppComponentOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *UpdateAppVersionAppComponentOutput) SetAppArn(v string) *UpdateAppVersionAppComponentOutput {
	s.AppArn = &v
	return s
}

// SetAppComponent sets the AppComponent field's value.
func (s *UpdateAppVersionAppComponentOutput) SetAppComponent(v *AppComponent) *UpdateAppVersionAppComponentOutput {
	s.AppComponent = v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *UpdateAppVersionAppComponentOutput) SetAppVersion(v string) *UpdateAppVersionAppComponentOutput {
	s.AppVersion = &v
	return s
}

type UpdateAppVersionInput struct {
	_ struct{} `type:"structure"`

	// Additional configuration parameters for an Resilience Hub application. If
	// you want to implement additionalInfo through the Resilience Hub console rather
	// than using an API call, see Configure the application configuration parameters
	// (https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
	//
	// Currently, this parameter accepts a key-value mapping (in a string format)
	// of only one failover region and one associated account.
	//
	// Key: "failover-regions"
	//
	// Value: "[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"
	AdditionalInfo map[string][]*string `locationName:"additionalInfo" type:"map"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAppVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAppVersionInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *UpdateAppVersionInput) SetAdditionalInfo(v map[string][]*string) *UpdateAppVersionInput {
	s.AdditionalInfo = v
	return s
}

// SetAppArn sets the AppArn field's value.
func (s *UpdateAppVersionInput) SetAppArn(v string) *UpdateAppVersionInput {
	s.AppArn = &v
	return s
}

type UpdateAppVersionOutput struct {
	_ struct{} `type:"structure"`

	// Additional configuration parameters for an Resilience Hub application. If
	// you want to implement additionalInfo through the Resilience Hub console rather
	// than using an API call, see Configure the application configuration parameters
	// (https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
	//
	// Currently, this parameter supports only failover region and account.
	AdditionalInfo map[string][]*string `locationName:"additionalInfo" type:"map"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Resilience Hub application version.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppVersionOutput) GoString() string {
	return s.String()
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *UpdateAppVersionOutput) SetAdditionalInfo(v map[string][]*string) *UpdateAppVersionOutput {
	s.AdditionalInfo = v
	return s
}

// SetAppArn sets the AppArn field's value.
func (s *UpdateAppVersionOutput) SetAppArn(v string) *UpdateAppVersionOutput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *UpdateAppVersionOutput) SetAppVersion(v string) *UpdateAppVersionOutput {
	s.AppVersion = &v
	return s
}

type UpdateAppVersionResourceInput struct {
	_ struct{} `type:"structure"`

	// Currently, there is no supported additional information for resources.
	AdditionalInfo map[string][]*string `locationName:"additionalInfo" type:"map"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// List of Application Components that this resource belongs to. If an Application
	// Component is not part of the Resilience Hub application, it will be added.
	AppComponents []*string `locationName:"appComponents" type:"list"`

	// Amazon Web Services account that owns the physical resource.
	AwsAccountId *string `locationName:"awsAccountId" type:"string"`

	// Amazon Web Services region that owns the physical resource.
	AwsRegion *string `locationName:"awsRegion" type:"string"`

	// Indicates if a resource is excluded from an Resilience Hub application.
	//
	// You can exclude only imported resources from an Resilience Hub application.
	Excluded *bool `locationName:"excluded" type:"boolean"`

	// Logical identifier of the resource.
	LogicalResourceId *LogicalResourceId `locationName:"logicalResourceId" type:"structure"`

	// Physical identifier of the resource.
	PhysicalResourceId *string `locationName:"physicalResourceId" min:"1" type:"string"`

	// Name of the resource.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// Type of resource.
	ResourceType *string `locationName:"resourceType" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppVersionResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppVersionResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAppVersionResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAppVersionResourceInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.PhysicalResourceId != nil && len(*s.PhysicalResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhysicalResourceId", 1))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}
	if s.LogicalResourceId != nil {
		if err := s.LogicalResourceId.Validate(); err != nil {
			invalidParams.AddNested("LogicalResourceId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *UpdateAppVersionResourceInput) SetAdditionalInfo(v map[string][]*string) *UpdateAppVersionResourceInput {
	s.AdditionalInfo = v
	return s
}

// SetAppArn sets the AppArn field's value.
func (s *UpdateAppVersionResourceInput) SetAppArn(v string) *UpdateAppVersionResourceInput {
	s.AppArn = &v
	return s
}

// SetAppComponents sets the AppComponents field's value.
func (s *UpdateAppVersionResourceInput) SetAppComponents(v []*string) *UpdateAppVersionResourceInput {
	s.AppComponents = v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateAppVersionResourceInput) SetAwsAccountId(v string) *UpdateAppVersionResourceInput {
	s.AwsAccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *UpdateAppVersionResourceInput) SetAwsRegion(v string) *UpdateAppVersionResourceInput {
	s.AwsRegion = &v
	return s
}

// SetExcluded sets the Excluded field's value.
func (s *UpdateAppVersionResourceInput) SetExcluded(v bool) *UpdateAppVersionResourceInput {
	s.Excluded = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *UpdateAppVersionResourceInput) SetLogicalResourceId(v *LogicalResourceId) *UpdateAppVersionResourceInput {
	s.LogicalResourceId = v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *UpdateAppVersionResourceInput) SetPhysicalResourceId(v string) *UpdateAppVersionResourceInput {
	s.PhysicalResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *UpdateAppVersionResourceInput) SetResourceName(v string) *UpdateAppVersionResourceInput {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *UpdateAppVersionResourceInput) SetResourceType(v string) *UpdateAppVersionResourceInput {
	s.ResourceType = &v
	return s
}

type UpdateAppVersionResourceOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format
	// for this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Resilience Hub application version.
	//
	// AppVersion is a required field
	AppVersion *string `locationName:"appVersion" type:"string" required:"true"`

	// Defines a physical resource. A physical resource is a resource that exists
	// in your account. It can be identified using an Amazon Resource Name (ARN)
	// or a Resilience Hub-native identifier.
	PhysicalResource *PhysicalResource `locationName:"physicalResource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppVersionResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppVersionResourceOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *UpdateAppVersionResourceOutput) SetAppArn(v string) *UpdateAppVersionResourceOutput {
	s.AppArn = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *UpdateAppVersionResourceOutput) SetAppVersion(v string) *UpdateAppVersionResourceOutput {
	s.AppVersion = &v
	return s
}

// SetPhysicalResource sets the PhysicalResource field's value.
func (s *UpdateAppVersionResourceOutput) SetPhysicalResource(v *PhysicalResource) *UpdateAppVersionResourceOutput {
	s.PhysicalResource = v
	return s
}

// Defines the operational recommendation item that needs a status update.
type UpdateRecommendationStatusItem struct {
	_ struct{} `type:"structure"`

	// Resource identifier of the operational recommendation item.
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// Identifier of the target Amazon Web Services account.
	TargetAccountId *string `locationName:"targetAccountId" type:"string"`

	// Identifier of the target Amazon Web Services Region.
	TargetRegion *string `locationName:"targetRegion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecommendationStatusItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecommendationStatusItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRecommendationStatusItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRecommendationStatusItem"}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *UpdateRecommendationStatusItem) SetResourceId(v string) *UpdateRecommendationStatusItem {
	s.ResourceId = &v
	return s
}

// SetTargetAccountId sets the TargetAccountId field's value.
func (s *UpdateRecommendationStatusItem) SetTargetAccountId(v string) *UpdateRecommendationStatusItem {
	s.TargetAccountId = &v
	return s
}

// SetTargetRegion sets the TargetRegion field's value.
func (s *UpdateRecommendationStatusItem) SetTargetRegion(v string) *UpdateRecommendationStatusItem {
	s.TargetRegion = &v
	return s
}

// Defines the operational recommendation item that is to be included or excluded.
type UpdateRecommendationStatusRequestEntry struct {
	_ struct{} `type:"structure"`

	// An identifier for an entry in this batch that is used to communicate the
	// result.
	//
	// The entryIds of a batch request need to be unique within a request.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// Indicates the reason for excluding an operational recommendation.
	ExcludeReason *string `locationName:"excludeReason" type:"string" enum:"ExcludeRecommendationReason"`

	// Indicates if the operational recommendation needs to be excluded. If set
	// to True, the operational recommendation will be excluded.
	//
	// Excluded is a required field
	Excluded *bool `locationName:"excluded" type:"boolean" required:"true"`

	// The operational recommendation item.
	//
	// Item is a required field
	Item *UpdateRecommendationStatusItem `locationName:"item" type:"structure" required:"true"`

	// Reference identifier of the operational recommendation item.
	//
	// ReferenceId is a required field
	ReferenceId *string `locationName:"referenceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecommendationStatusRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecommendationStatusRequestEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRecommendationStatusRequestEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRecommendationStatusRequestEntry"}
	if s.EntryId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntryId"))
	}
	if s.EntryId != nil && len(*s.EntryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntryId", 1))
	}
	if s.Excluded == nil {
		invalidParams.Add(request.NewErrParamRequired("Excluded"))
	}
	if s.Item == nil {
		invalidParams.Add(request.NewErrParamRequired("Item"))
	}
	if s.ReferenceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceId"))
	}
	if s.ReferenceId != nil && len(*s.ReferenceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceId", 1))
	}
	if s.Item != nil {
		if err := s.Item.Validate(); err != nil {
			invalidParams.AddNested("Item", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntryId sets the EntryId field's value.
func (s *UpdateRecommendationStatusRequestEntry) SetEntryId(v string) *UpdateRecommendationStatusRequestEntry {
	s.EntryId = &v
	return s
}

// SetExcludeReason sets the ExcludeReason field's value.
func (s *UpdateRecommendationStatusRequestEntry) SetExcludeReason(v string) *UpdateRecommendationStatusRequestEntry {
	s.ExcludeReason = &v
	return s
}

// SetExcluded sets the Excluded field's value.
func (s *UpdateRecommendationStatusRequestEntry) SetExcluded(v bool) *UpdateRecommendationStatusRequestEntry {
	s.Excluded = &v
	return s
}

// SetItem sets the Item field's value.
func (s *UpdateRecommendationStatusRequestEntry) SetItem(v *UpdateRecommendationStatusItem) *UpdateRecommendationStatusRequestEntry {
	s.Item = v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *UpdateRecommendationStatusRequestEntry) SetReferenceId(v string) *UpdateRecommendationStatusRequestEntry {
	s.ReferenceId = &v
	return s
}

type UpdateResiliencyPolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies a high-level geographical location constraint for where your resilience
	// policy data can be stored.
	DataLocationConstraint *string `locationName:"dataLocationConstraint" type:"string" enum:"DataLocationConstraint"`

	// The type of resiliency policy to be created, including the recovery time
	// objective (RTO) and recovery point objective (RPO) in seconds.
	Policy map[string]*FailurePolicy `locationName:"policy" type:"map"`

	// Amazon Resource Name (ARN) of the resiliency policy. The format for this
	// ARN is: arn:partition:resiliencehub:region:account:resiliency-policy/policy-id.
	// For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// PolicyArn is a required field
	PolicyArn *string `locationName:"policyArn" type:"string" required:"true"`

	// The description for the policy.
	PolicyDescription *string `locationName:"policyDescription" type:"string"`

	// The name of the policy
	PolicyName *string `locationName:"policyName" type:"string"`

	// The tier for this resiliency policy, ranging from the highest severity (MissionCritical)
	// to lowest (NonCritical).
	Tier *string `locationName:"tier" type:"string" enum:"ResiliencyPolicyTier"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResiliencyPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResiliencyPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResiliencyPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResiliencyPolicyInput"}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.Policy != nil {
		for i, v := range s.Policy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Policy", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataLocationConstraint sets the DataLocationConstraint field's value.
func (s *UpdateResiliencyPolicyInput) SetDataLocationConstraint(v string) *UpdateResiliencyPolicyInput {
	s.DataLocationConstraint = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *UpdateResiliencyPolicyInput) SetPolicy(v map[string]*FailurePolicy) *UpdateResiliencyPolicyInput {
	s.Policy = v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *UpdateResiliencyPolicyInput) SetPolicyArn(v string) *UpdateResiliencyPolicyInput {
	s.PolicyArn = &v
	return s
}

// SetPolicyDescription sets the PolicyDescription field's value.
func (s *UpdateResiliencyPolicyInput) SetPolicyDescription(v string) *UpdateResiliencyPolicyInput {
	s.PolicyDescription = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *UpdateResiliencyPolicyInput) SetPolicyName(v string) *UpdateResiliencyPolicyInput {
	s.PolicyName = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *UpdateResiliencyPolicyInput) SetTier(v string) *UpdateResiliencyPolicyInput {
	s.Tier = &v
	return s
}

type UpdateResiliencyPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The type of resiliency policy that was updated, including the recovery time
	// objective (RTO) and recovery point objective (RPO) in seconds.
	//
	// Policy is a required field
	Policy *ResiliencyPolicy `locationName:"policy" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResiliencyPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResiliencyPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *UpdateResiliencyPolicyOutput) SetPolicy(v *ResiliencyPolicy) *UpdateResiliencyPolicyOutput {
	s.Policy = v
	return s
}

// This exception occurs when a request is not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AlarmTypeMetric is a AlarmType enum value
	AlarmTypeMetric = "Metric"

	// AlarmTypeComposite is a AlarmType enum value
	AlarmTypeComposite = "Composite"

	// AlarmTypeCanary is a AlarmType enum value
	AlarmTypeCanary = "Canary"

	// AlarmTypeLogs is a AlarmType enum value
	AlarmTypeLogs = "Logs"

	// AlarmTypeEvent is a AlarmType enum value
	AlarmTypeEvent = "Event"
)

// AlarmType_Values returns all elements of the AlarmType enum
func AlarmType_Values() []string {
	return []string{
		AlarmTypeMetric,
		AlarmTypeComposite,
		AlarmTypeCanary,
		AlarmTypeLogs,
		AlarmTypeEvent,
	}
}

const (
	// AppAssessmentScheduleTypeDisabled is a AppAssessmentScheduleType enum value
	AppAssessmentScheduleTypeDisabled = "Disabled"

	// AppAssessmentScheduleTypeDaily is a AppAssessmentScheduleType enum value
	AppAssessmentScheduleTypeDaily = "Daily"
)

// AppAssessmentScheduleType_Values returns all elements of the AppAssessmentScheduleType enum
func AppAssessmentScheduleType_Values() []string {
	return []string{
		AppAssessmentScheduleTypeDisabled,
		AppAssessmentScheduleTypeDaily,
	}
}

const (
	// AppComplianceStatusTypePolicyBreached is a AppComplianceStatusType enum value
	AppComplianceStatusTypePolicyBreached = "PolicyBreached"

	// AppComplianceStatusTypePolicyMet is a AppComplianceStatusType enum value
	AppComplianceStatusTypePolicyMet = "PolicyMet"

	// AppComplianceStatusTypeNotAssessed is a AppComplianceStatusType enum value
	AppComplianceStatusTypeNotAssessed = "NotAssessed"

	// AppComplianceStatusTypeChangesDetected is a AppComplianceStatusType enum value
	AppComplianceStatusTypeChangesDetected = "ChangesDetected"
)

// AppComplianceStatusType_Values returns all elements of the AppComplianceStatusType enum
func AppComplianceStatusType_Values() []string {
	return []string{
		AppComplianceStatusTypePolicyBreached,
		AppComplianceStatusTypePolicyMet,
		AppComplianceStatusTypeNotAssessed,
		AppComplianceStatusTypeChangesDetected,
	}
}

const (
	// AppDriftStatusTypeNotChecked is a AppDriftStatusType enum value
	AppDriftStatusTypeNotChecked = "NotChecked"

	// AppDriftStatusTypeNotDetected is a AppDriftStatusType enum value
	AppDriftStatusTypeNotDetected = "NotDetected"

	// AppDriftStatusTypeDetected is a AppDriftStatusType enum value
	AppDriftStatusTypeDetected = "Detected"
)

// AppDriftStatusType_Values returns all elements of the AppDriftStatusType enum
func AppDriftStatusType_Values() []string {
	return []string{
		AppDriftStatusTypeNotChecked,
		AppDriftStatusTypeNotDetected,
		AppDriftStatusTypeDetected,
	}
}

const (
	// AppStatusTypeActive is a AppStatusType enum value
	AppStatusTypeActive = "Active"

	// AppStatusTypeDeleting is a AppStatusType enum value
	AppStatusTypeDeleting = "Deleting"
)

// AppStatusType_Values returns all elements of the AppStatusType enum
func AppStatusType_Values() []string {
	return []string{
		AppStatusTypeActive,
		AppStatusTypeDeleting,
	}
}

const (
	// AssessmentInvokerUser is a AssessmentInvoker enum value
	AssessmentInvokerUser = "User"

	// AssessmentInvokerSystem is a AssessmentInvoker enum value
	AssessmentInvokerSystem = "System"
)

// AssessmentInvoker_Values returns all elements of the AssessmentInvoker enum
func AssessmentInvoker_Values() []string {
	return []string{
		AssessmentInvokerUser,
		AssessmentInvokerSystem,
	}
}

const (
	// AssessmentStatusPending is a AssessmentStatus enum value
	AssessmentStatusPending = "Pending"

	// AssessmentStatusInProgress is a AssessmentStatus enum value
	AssessmentStatusInProgress = "InProgress"

	// AssessmentStatusFailed is a AssessmentStatus enum value
	AssessmentStatusFailed = "Failed"

	// AssessmentStatusSuccess is a AssessmentStatus enum value
	AssessmentStatusSuccess = "Success"
)

// AssessmentStatus_Values returns all elements of the AssessmentStatus enum
func AssessmentStatus_Values() []string {
	return []string{
		AssessmentStatusPending,
		AssessmentStatusInProgress,
		AssessmentStatusFailed,
		AssessmentStatusSuccess,
	}
}

const (
	// ComplianceStatusPolicyBreached is a ComplianceStatus enum value
	ComplianceStatusPolicyBreached = "PolicyBreached"

	// ComplianceStatusPolicyMet is a ComplianceStatus enum value
	ComplianceStatusPolicyMet = "PolicyMet"
)

// ComplianceStatus_Values returns all elements of the ComplianceStatus enum
func ComplianceStatus_Values() []string {
	return []string{
		ComplianceStatusPolicyBreached,
		ComplianceStatusPolicyMet,
	}
}

const (
	// ConfigRecommendationOptimizationTypeLeastCost is a ConfigRecommendationOptimizationType enum value
	ConfigRecommendationOptimizationTypeLeastCost = "LeastCost"

	// ConfigRecommendationOptimizationTypeLeastChange is a ConfigRecommendationOptimizationType enum value
	ConfigRecommendationOptimizationTypeLeastChange = "LeastChange"

	// ConfigRecommendationOptimizationTypeBestAzrecovery is a ConfigRecommendationOptimizationType enum value
	ConfigRecommendationOptimizationTypeBestAzrecovery = "BestAZRecovery"

	// ConfigRecommendationOptimizationTypeLeastErrors is a ConfigRecommendationOptimizationType enum value
	ConfigRecommendationOptimizationTypeLeastErrors = "LeastErrors"

	// ConfigRecommendationOptimizationTypeBestAttainable is a ConfigRecommendationOptimizationType enum value
	ConfigRecommendationOptimizationTypeBestAttainable = "BestAttainable"

	// ConfigRecommendationOptimizationTypeBestRegionRecovery is a ConfigRecommendationOptimizationType enum value
	ConfigRecommendationOptimizationTypeBestRegionRecovery = "BestRegionRecovery"
)

// ConfigRecommendationOptimizationType_Values returns all elements of the ConfigRecommendationOptimizationType enum
func ConfigRecommendationOptimizationType_Values() []string {
	return []string{
		ConfigRecommendationOptimizationTypeLeastCost,
		ConfigRecommendationOptimizationTypeLeastChange,
		ConfigRecommendationOptimizationTypeBestAzrecovery,
		ConfigRecommendationOptimizationTypeLeastErrors,
		ConfigRecommendationOptimizationTypeBestAttainable,
		ConfigRecommendationOptimizationTypeBestRegionRecovery,
	}
}

const (
	// CostFrequencyHourly is a CostFrequency enum value
	CostFrequencyHourly = "Hourly"

	// CostFrequencyDaily is a CostFrequency enum value
	CostFrequencyDaily = "Daily"

	// CostFrequencyMonthly is a CostFrequency enum value
	CostFrequencyMonthly = "Monthly"

	// CostFrequencyYearly is a CostFrequency enum value
	CostFrequencyYearly = "Yearly"
)

// CostFrequency_Values returns all elements of the CostFrequency enum
func CostFrequency_Values() []string {
	return []string{
		CostFrequencyHourly,
		CostFrequencyDaily,
		CostFrequencyMonthly,
		CostFrequencyYearly,
	}
}

const (
	// DataLocationConstraintAnyLocation is a DataLocationConstraint enum value
	DataLocationConstraintAnyLocation = "AnyLocation"

	// DataLocationConstraintSameContinent is a DataLocationConstraint enum value
	DataLocationConstraintSameContinent = "SameContinent"

	// DataLocationConstraintSameCountry is a DataLocationConstraint enum value
	DataLocationConstraintSameCountry = "SameCountry"
)

// DataLocationConstraint_Values returns all elements of the DataLocationConstraint enum
func DataLocationConstraint_Values() []string {
	return []string{
		DataLocationConstraintAnyLocation,
		DataLocationConstraintSameContinent,
		DataLocationConstraintSameCountry,
	}
}

const (
	// DifferenceTypeNotEqual is a DifferenceType enum value
	DifferenceTypeNotEqual = "NotEqual"

	// DifferenceTypeAdded is a DifferenceType enum value
	DifferenceTypeAdded = "Added"

	// DifferenceTypeRemoved is a DifferenceType enum value
	DifferenceTypeRemoved = "Removed"
)

// DifferenceType_Values returns all elements of the DifferenceType enum
func DifferenceType_Values() []string {
	return []string{
		DifferenceTypeNotEqual,
		DifferenceTypeAdded,
		DifferenceTypeRemoved,
	}
}

const (
	// DisruptionTypeSoftware is a DisruptionType enum value
	DisruptionTypeSoftware = "Software"

	// DisruptionTypeHardware is a DisruptionType enum value
	DisruptionTypeHardware = "Hardware"

	// DisruptionTypeAz is a DisruptionType enum value
	DisruptionTypeAz = "AZ"

	// DisruptionTypeRegion is a DisruptionType enum value
	DisruptionTypeRegion = "Region"
)

// DisruptionType_Values returns all elements of the DisruptionType enum
func DisruptionType_Values() []string {
	return []string{
		DisruptionTypeSoftware,
		DisruptionTypeHardware,
		DisruptionTypeAz,
		DisruptionTypeRegion,
	}
}

const (
	// DriftStatusNotChecked is a DriftStatus enum value
	DriftStatusNotChecked = "NotChecked"

	// DriftStatusNotDetected is a DriftStatus enum value
	DriftStatusNotDetected = "NotDetected"

	// DriftStatusDetected is a DriftStatus enum value
	DriftStatusDetected = "Detected"
)

// DriftStatus_Values returns all elements of the DriftStatus enum
func DriftStatus_Values() []string {
	return []string{
		DriftStatusNotChecked,
		DriftStatusNotDetected,
		DriftStatusDetected,
	}
}

const (
	// DriftTypeApplicationCompliance is a DriftType enum value
	DriftTypeApplicationCompliance = "ApplicationCompliance"

	// DriftTypeAppComponentResiliencyComplianceStatus is a DriftType enum value
	DriftTypeAppComponentResiliencyComplianceStatus = "AppComponentResiliencyComplianceStatus"
)

// DriftType_Values returns all elements of the DriftType enum
func DriftType_Values() []string {
	return []string{
		DriftTypeApplicationCompliance,
		DriftTypeAppComponentResiliencyComplianceStatus,
	}
}

const (
	// EstimatedCostTierL1 is a EstimatedCostTier enum value
	EstimatedCostTierL1 = "L1"

	// EstimatedCostTierL2 is a EstimatedCostTier enum value
	EstimatedCostTierL2 = "L2"

	// EstimatedCostTierL3 is a EstimatedCostTier enum value
	EstimatedCostTierL3 = "L3"

	// EstimatedCostTierL4 is a EstimatedCostTier enum value
	EstimatedCostTierL4 = "L4"
)

// EstimatedCostTier_Values returns all elements of the EstimatedCostTier enum
func EstimatedCostTier_Values() []string {
	return []string{
		EstimatedCostTierL1,
		EstimatedCostTierL2,
		EstimatedCostTierL3,
		EstimatedCostTierL4,
	}
}

const (
	// EventTypeScheduledAssessmentFailure is a EventType enum value
	EventTypeScheduledAssessmentFailure = "ScheduledAssessmentFailure"

	// EventTypeDriftDetected is a EventType enum value
	EventTypeDriftDetected = "DriftDetected"
)

// EventType_Values returns all elements of the EventType enum
func EventType_Values() []string {
	return []string{
		EventTypeScheduledAssessmentFailure,
		EventTypeDriftDetected,
	}
}

const (
	// ExcludeRecommendationReasonAlreadyImplemented is a ExcludeRecommendationReason enum value
	ExcludeRecommendationReasonAlreadyImplemented = "AlreadyImplemented"

	// ExcludeRecommendationReasonNotRelevant is a ExcludeRecommendationReason enum value
	ExcludeRecommendationReasonNotRelevant = "NotRelevant"

	// ExcludeRecommendationReasonComplexityOfImplementation is a ExcludeRecommendationReason enum value
	ExcludeRecommendationReasonComplexityOfImplementation = "ComplexityOfImplementation"
)

// ExcludeRecommendationReason_Values returns all elements of the ExcludeRecommendationReason enum
func ExcludeRecommendationReason_Values() []string {
	return []string{
		ExcludeRecommendationReasonAlreadyImplemented,
		ExcludeRecommendationReasonNotRelevant,
		ExcludeRecommendationReasonComplexityOfImplementation,
	}
}

const (
	// HaArchitectureMultiSite is a HaArchitecture enum value
	HaArchitectureMultiSite = "MultiSite"

	// HaArchitectureWarmStandby is a HaArchitecture enum value
	HaArchitectureWarmStandby = "WarmStandby"

	// HaArchitecturePilotLight is a HaArchitecture enum value
	HaArchitecturePilotLight = "PilotLight"

	// HaArchitectureBackupAndRestore is a HaArchitecture enum value
	HaArchitectureBackupAndRestore = "BackupAndRestore"

	// HaArchitectureNoRecoveryPlan is a HaArchitecture enum value
	HaArchitectureNoRecoveryPlan = "NoRecoveryPlan"
)

// HaArchitecture_Values returns all elements of the HaArchitecture enum
func HaArchitecture_Values() []string {
	return []string{
		HaArchitectureMultiSite,
		HaArchitectureWarmStandby,
		HaArchitecturePilotLight,
		HaArchitectureBackupAndRestore,
		HaArchitectureNoRecoveryPlan,
	}
}

const (
	// PermissionModelTypeLegacyIamuser is a PermissionModelType enum value
	PermissionModelTypeLegacyIamuser = "LegacyIAMUser"

	// PermissionModelTypeRoleBased is a PermissionModelType enum value
	PermissionModelTypeRoleBased = "RoleBased"
)

// PermissionModelType_Values returns all elements of the PermissionModelType enum
func PermissionModelType_Values() []string {
	return []string{
		PermissionModelTypeLegacyIamuser,
		PermissionModelTypeRoleBased,
	}
}

const (
	// PhysicalIdentifierTypeArn is a PhysicalIdentifierType enum value
	PhysicalIdentifierTypeArn = "Arn"

	// PhysicalIdentifierTypeNative is a PhysicalIdentifierType enum value
	PhysicalIdentifierTypeNative = "Native"
)

// PhysicalIdentifierType_Values returns all elements of the PhysicalIdentifierType enum
func PhysicalIdentifierType_Values() []string {
	return []string{
		PhysicalIdentifierTypeArn,
		PhysicalIdentifierTypeNative,
	}
}

const (
	// RecommendationComplianceStatusBreachedUnattainable is a RecommendationComplianceStatus enum value
	RecommendationComplianceStatusBreachedUnattainable = "BreachedUnattainable"

	// RecommendationComplianceStatusBreachedCanMeet is a RecommendationComplianceStatus enum value
	RecommendationComplianceStatusBreachedCanMeet = "BreachedCanMeet"

	// RecommendationComplianceStatusMetCanImprove is a RecommendationComplianceStatus enum value
	RecommendationComplianceStatusMetCanImprove = "MetCanImprove"
)

// RecommendationComplianceStatus_Values returns all elements of the RecommendationComplianceStatus enum
func RecommendationComplianceStatus_Values() []string {
	return []string{
		RecommendationComplianceStatusBreachedUnattainable,
		RecommendationComplianceStatusBreachedCanMeet,
		RecommendationComplianceStatusMetCanImprove,
	}
}

const (
	// RecommendationStatusImplemented is a RecommendationStatus enum value
	RecommendationStatusImplemented = "Implemented"

	// RecommendationStatusInactive is a RecommendationStatus enum value
	RecommendationStatusInactive = "Inactive"

	// RecommendationStatusNotImplemented is a RecommendationStatus enum value
	RecommendationStatusNotImplemented = "NotImplemented"

	// RecommendationStatusExcluded is a RecommendationStatus enum value
	RecommendationStatusExcluded = "Excluded"
)

// RecommendationStatus_Values returns all elements of the RecommendationStatus enum
func RecommendationStatus_Values() []string {
	return []string{
		RecommendationStatusImplemented,
		RecommendationStatusInactive,
		RecommendationStatusNotImplemented,
		RecommendationStatusExcluded,
	}
}

const (
	// RecommendationTemplateStatusPending is a RecommendationTemplateStatus enum value
	RecommendationTemplateStatusPending = "Pending"

	// RecommendationTemplateStatusInProgress is a RecommendationTemplateStatus enum value
	RecommendationTemplateStatusInProgress = "InProgress"

	// RecommendationTemplateStatusFailed is a RecommendationTemplateStatus enum value
	RecommendationTemplateStatusFailed = "Failed"

	// RecommendationTemplateStatusSuccess is a RecommendationTemplateStatus enum value
	RecommendationTemplateStatusSuccess = "Success"
)

// RecommendationTemplateStatus_Values returns all elements of the RecommendationTemplateStatus enum
func RecommendationTemplateStatus_Values() []string {
	return []string{
		RecommendationTemplateStatusPending,
		RecommendationTemplateStatusInProgress,
		RecommendationTemplateStatusFailed,
		RecommendationTemplateStatusSuccess,
	}
}

const (
	// RenderRecommendationTypeAlarm is a RenderRecommendationType enum value
	RenderRecommendationTypeAlarm = "Alarm"

	// RenderRecommendationTypeSop is a RenderRecommendationType enum value
	RenderRecommendationTypeSop = "Sop"

	// RenderRecommendationTypeTest is a RenderRecommendationType enum value
	RenderRecommendationTypeTest = "Test"
)

// RenderRecommendationType_Values returns all elements of the RenderRecommendationType enum
func RenderRecommendationType_Values() []string {
	return []string{
		RenderRecommendationTypeAlarm,
		RenderRecommendationTypeSop,
		RenderRecommendationTypeTest,
	}
}

const (
	// ResiliencyPolicyTierMissionCritical is a ResiliencyPolicyTier enum value
	ResiliencyPolicyTierMissionCritical = "MissionCritical"

	// ResiliencyPolicyTierCritical is a ResiliencyPolicyTier enum value
	ResiliencyPolicyTierCritical = "Critical"

	// ResiliencyPolicyTierImportant is a ResiliencyPolicyTier enum value
	ResiliencyPolicyTierImportant = "Important"

	// ResiliencyPolicyTierCoreServices is a ResiliencyPolicyTier enum value
	ResiliencyPolicyTierCoreServices = "CoreServices"

	// ResiliencyPolicyTierNonCritical is a ResiliencyPolicyTier enum value
	ResiliencyPolicyTierNonCritical = "NonCritical"

	// ResiliencyPolicyTierNotApplicable is a ResiliencyPolicyTier enum value
	ResiliencyPolicyTierNotApplicable = "NotApplicable"
)

// ResiliencyPolicyTier_Values returns all elements of the ResiliencyPolicyTier enum
func ResiliencyPolicyTier_Values() []string {
	return []string{
		ResiliencyPolicyTierMissionCritical,
		ResiliencyPolicyTierCritical,
		ResiliencyPolicyTierImportant,
		ResiliencyPolicyTierCoreServices,
		ResiliencyPolicyTierNonCritical,
		ResiliencyPolicyTierNotApplicable,
	}
}

const (
	// ResiliencyScoreTypeCompliance is a ResiliencyScoreType enum value
	ResiliencyScoreTypeCompliance = "Compliance"

	// ResiliencyScoreTypeTest is a ResiliencyScoreType enum value
	ResiliencyScoreTypeTest = "Test"

	// ResiliencyScoreTypeAlarm is a ResiliencyScoreType enum value
	ResiliencyScoreTypeAlarm = "Alarm"

	// ResiliencyScoreTypeSop is a ResiliencyScoreType enum value
	ResiliencyScoreTypeSop = "Sop"
)

// ResiliencyScoreType_Values returns all elements of the ResiliencyScoreType enum
func ResiliencyScoreType_Values() []string {
	return []string{
		ResiliencyScoreTypeCompliance,
		ResiliencyScoreTypeTest,
		ResiliencyScoreTypeAlarm,
		ResiliencyScoreTypeSop,
	}
}

const (
	// ResourceImportStatusTypePending is a ResourceImportStatusType enum value
	ResourceImportStatusTypePending = "Pending"

	// ResourceImportStatusTypeInProgress is a ResourceImportStatusType enum value
	ResourceImportStatusTypeInProgress = "InProgress"

	// ResourceImportStatusTypeFailed is a ResourceImportStatusType enum value
	ResourceImportStatusTypeFailed = "Failed"

	// ResourceImportStatusTypeSuccess is a ResourceImportStatusType enum value
	ResourceImportStatusTypeSuccess = "Success"
)

// ResourceImportStatusType_Values returns all elements of the ResourceImportStatusType enum
func ResourceImportStatusType_Values() []string {
	return []string{
		ResourceImportStatusTypePending,
		ResourceImportStatusTypeInProgress,
		ResourceImportStatusTypeFailed,
		ResourceImportStatusTypeSuccess,
	}
}

const (
	// ResourceImportStrategyTypeAddOnly is a ResourceImportStrategyType enum value
	ResourceImportStrategyTypeAddOnly = "AddOnly"

	// ResourceImportStrategyTypeReplaceAll is a ResourceImportStrategyType enum value
	ResourceImportStrategyTypeReplaceAll = "ReplaceAll"
)

// ResourceImportStrategyType_Values returns all elements of the ResourceImportStrategyType enum
func ResourceImportStrategyType_Values() []string {
	return []string{
		ResourceImportStrategyTypeAddOnly,
		ResourceImportStrategyTypeReplaceAll,
	}
}

const (
	// ResourceMappingTypeCfnStack is a ResourceMappingType enum value
	ResourceMappingTypeCfnStack = "CfnStack"

	// ResourceMappingTypeResource is a ResourceMappingType enum value
	ResourceMappingTypeResource = "Resource"

	// ResourceMappingTypeAppRegistryApp is a ResourceMappingType enum value
	ResourceMappingTypeAppRegistryApp = "AppRegistryApp"

	// ResourceMappingTypeResourceGroup is a ResourceMappingType enum value
	ResourceMappingTypeResourceGroup = "ResourceGroup"

	// ResourceMappingTypeTerraform is a ResourceMappingType enum value
	ResourceMappingTypeTerraform = "Terraform"

	// ResourceMappingTypeEks is a ResourceMappingType enum value
	ResourceMappingTypeEks = "EKS"
)

// ResourceMappingType_Values returns all elements of the ResourceMappingType enum
func ResourceMappingType_Values() []string {
	return []string{
		ResourceMappingTypeCfnStack,
		ResourceMappingTypeResource,
		ResourceMappingTypeAppRegistryApp,
		ResourceMappingTypeResourceGroup,
		ResourceMappingTypeTerraform,
		ResourceMappingTypeEks,
	}
}

const (
	// ResourceResolutionStatusTypePending is a ResourceResolutionStatusType enum value
	ResourceResolutionStatusTypePending = "Pending"

	// ResourceResolutionStatusTypeInProgress is a ResourceResolutionStatusType enum value
	ResourceResolutionStatusTypeInProgress = "InProgress"

	// ResourceResolutionStatusTypeFailed is a ResourceResolutionStatusType enum value
	ResourceResolutionStatusTypeFailed = "Failed"

	// ResourceResolutionStatusTypeSuccess is a ResourceResolutionStatusType enum value
	ResourceResolutionStatusTypeSuccess = "Success"
)

// ResourceResolutionStatusType_Values returns all elements of the ResourceResolutionStatusType enum
func ResourceResolutionStatusType_Values() []string {
	return []string{
		ResourceResolutionStatusTypePending,
		ResourceResolutionStatusTypeInProgress,
		ResourceResolutionStatusTypeFailed,
		ResourceResolutionStatusTypeSuccess,
	}
}

const (
	// ResourceSourceTypeAppTemplate is a ResourceSourceType enum value
	ResourceSourceTypeAppTemplate = "AppTemplate"

	// ResourceSourceTypeDiscovered is a ResourceSourceType enum value
	ResourceSourceTypeDiscovered = "Discovered"
)

// ResourceSourceType_Values returns all elements of the ResourceSourceType enum
func ResourceSourceType_Values() []string {
	return []string{
		ResourceSourceTypeAppTemplate,
		ResourceSourceTypeDiscovered,
	}
}

const (
	// SopServiceTypeSsm is a SopServiceType enum value
	SopServiceTypeSsm = "SSM"
)

// SopServiceType_Values returns all elements of the SopServiceType enum
func SopServiceType_Values() []string {
	return []string{
		SopServiceTypeSsm,
	}
}

const (
	// TemplateFormatCfnYaml is a TemplateFormat enum value
	TemplateFormatCfnYaml = "CfnYaml"

	// TemplateFormatCfnJson is a TemplateFormat enum value
	TemplateFormatCfnJson = "CfnJson"
)

// TemplateFormat_Values returns all elements of the TemplateFormat enum
func TemplateFormat_Values() []string {
	return []string{
		TemplateFormatCfnYaml,
		TemplateFormatCfnJson,
	}
}

const (
	// TestRiskSmall is a TestRisk enum value
	TestRiskSmall = "Small"

	// TestRiskMedium is a TestRisk enum value
	TestRiskMedium = "Medium"

	// TestRiskHigh is a TestRisk enum value
	TestRiskHigh = "High"
)

// TestRisk_Values returns all elements of the TestRisk enum
func TestRisk_Values() []string {
	return []string{
		TestRiskSmall,
		TestRiskMedium,
		TestRiskHigh,
	}
}

const (
	// TestTypeSoftware is a TestType enum value
	TestTypeSoftware = "Software"

	// TestTypeHardware is a TestType enum value
	TestTypeHardware = "Hardware"

	// TestTypeAz is a TestType enum value
	TestTypeAz = "AZ"

	// TestTypeRegion is a TestType enum value
	TestTypeRegion = "Region"
)

// TestType_Values returns all elements of the TestType enum
func TestType_Values() []string {
	return []string{
		TestTypeSoftware,
		TestTypeHardware,
		TestTypeAz,
		TestTypeRegion,
	}
}
