// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package mediapackagev2iface provides an interface to enable mocking the AWS Elemental MediaPackage v2 service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package mediapackagev2iface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/mediapackagev2"
)

// MediaPackageV2API provides an interface to enable mocking the
// mediapackagev2.MediaPackageV2 service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Elemental MediaPackage v2.
//	func myFunc(svc mediapackagev2iface.MediaPackageV2API) bool {
//	    // Make svc.CreateChannel request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := mediapackagev2.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockMediaPackageV2Client struct {
//	    mediapackagev2iface.MediaPackageV2API
//	}
//	func (m *mockMediaPackageV2Client) CreateChannel(input *mediapackagev2.CreateChannelInput) (*mediapackagev2.CreateChannelOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockMediaPackageV2Client{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type MediaPackageV2API interface {
	CreateChannel(*mediapackagev2.CreateChannelInput) (*mediapackagev2.CreateChannelOutput, error)
	CreateChannelWithContext(aws.Context, *mediapackagev2.CreateChannelInput, ...request.Option) (*mediapackagev2.CreateChannelOutput, error)
	CreateChannelRequest(*mediapackagev2.CreateChannelInput) (*request.Request, *mediapackagev2.CreateChannelOutput)

	CreateChannelGroup(*mediapackagev2.CreateChannelGroupInput) (*mediapackagev2.CreateChannelGroupOutput, error)
	CreateChannelGroupWithContext(aws.Context, *mediapackagev2.CreateChannelGroupInput, ...request.Option) (*mediapackagev2.CreateChannelGroupOutput, error)
	CreateChannelGroupRequest(*mediapackagev2.CreateChannelGroupInput) (*request.Request, *mediapackagev2.CreateChannelGroupOutput)

	CreateOriginEndpoint(*mediapackagev2.CreateOriginEndpointInput) (*mediapackagev2.CreateOriginEndpointOutput, error)
	CreateOriginEndpointWithContext(aws.Context, *mediapackagev2.CreateOriginEndpointInput, ...request.Option) (*mediapackagev2.CreateOriginEndpointOutput, error)
	CreateOriginEndpointRequest(*mediapackagev2.CreateOriginEndpointInput) (*request.Request, *mediapackagev2.CreateOriginEndpointOutput)

	DeleteChannel(*mediapackagev2.DeleteChannelInput) (*mediapackagev2.DeleteChannelOutput, error)
	DeleteChannelWithContext(aws.Context, *mediapackagev2.DeleteChannelInput, ...request.Option) (*mediapackagev2.DeleteChannelOutput, error)
	DeleteChannelRequest(*mediapackagev2.DeleteChannelInput) (*request.Request, *mediapackagev2.DeleteChannelOutput)

	DeleteChannelGroup(*mediapackagev2.DeleteChannelGroupInput) (*mediapackagev2.DeleteChannelGroupOutput, error)
	DeleteChannelGroupWithContext(aws.Context, *mediapackagev2.DeleteChannelGroupInput, ...request.Option) (*mediapackagev2.DeleteChannelGroupOutput, error)
	DeleteChannelGroupRequest(*mediapackagev2.DeleteChannelGroupInput) (*request.Request, *mediapackagev2.DeleteChannelGroupOutput)

	DeleteChannelPolicy(*mediapackagev2.DeleteChannelPolicyInput) (*mediapackagev2.DeleteChannelPolicyOutput, error)
	DeleteChannelPolicyWithContext(aws.Context, *mediapackagev2.DeleteChannelPolicyInput, ...request.Option) (*mediapackagev2.DeleteChannelPolicyOutput, error)
	DeleteChannelPolicyRequest(*mediapackagev2.DeleteChannelPolicyInput) (*request.Request, *mediapackagev2.DeleteChannelPolicyOutput)

	DeleteOriginEndpoint(*mediapackagev2.DeleteOriginEndpointInput) (*mediapackagev2.DeleteOriginEndpointOutput, error)
	DeleteOriginEndpointWithContext(aws.Context, *mediapackagev2.DeleteOriginEndpointInput, ...request.Option) (*mediapackagev2.DeleteOriginEndpointOutput, error)
	DeleteOriginEndpointRequest(*mediapackagev2.DeleteOriginEndpointInput) (*request.Request, *mediapackagev2.DeleteOriginEndpointOutput)

	DeleteOriginEndpointPolicy(*mediapackagev2.DeleteOriginEndpointPolicyInput) (*mediapackagev2.DeleteOriginEndpointPolicyOutput, error)
	DeleteOriginEndpointPolicyWithContext(aws.Context, *mediapackagev2.DeleteOriginEndpointPolicyInput, ...request.Option) (*mediapackagev2.DeleteOriginEndpointPolicyOutput, error)
	DeleteOriginEndpointPolicyRequest(*mediapackagev2.DeleteOriginEndpointPolicyInput) (*request.Request, *mediapackagev2.DeleteOriginEndpointPolicyOutput)

	GetChannel(*mediapackagev2.GetChannelInput) (*mediapackagev2.GetChannelOutput, error)
	GetChannelWithContext(aws.Context, *mediapackagev2.GetChannelInput, ...request.Option) (*mediapackagev2.GetChannelOutput, error)
	GetChannelRequest(*mediapackagev2.GetChannelInput) (*request.Request, *mediapackagev2.GetChannelOutput)

	GetChannelGroup(*mediapackagev2.GetChannelGroupInput) (*mediapackagev2.GetChannelGroupOutput, error)
	GetChannelGroupWithContext(aws.Context, *mediapackagev2.GetChannelGroupInput, ...request.Option) (*mediapackagev2.GetChannelGroupOutput, error)
	GetChannelGroupRequest(*mediapackagev2.GetChannelGroupInput) (*request.Request, *mediapackagev2.GetChannelGroupOutput)

	GetChannelPolicy(*mediapackagev2.GetChannelPolicyInput) (*mediapackagev2.GetChannelPolicyOutput, error)
	GetChannelPolicyWithContext(aws.Context, *mediapackagev2.GetChannelPolicyInput, ...request.Option) (*mediapackagev2.GetChannelPolicyOutput, error)
	GetChannelPolicyRequest(*mediapackagev2.GetChannelPolicyInput) (*request.Request, *mediapackagev2.GetChannelPolicyOutput)

	GetOriginEndpoint(*mediapackagev2.GetOriginEndpointInput) (*mediapackagev2.GetOriginEndpointOutput, error)
	GetOriginEndpointWithContext(aws.Context, *mediapackagev2.GetOriginEndpointInput, ...request.Option) (*mediapackagev2.GetOriginEndpointOutput, error)
	GetOriginEndpointRequest(*mediapackagev2.GetOriginEndpointInput) (*request.Request, *mediapackagev2.GetOriginEndpointOutput)

	GetOriginEndpointPolicy(*mediapackagev2.GetOriginEndpointPolicyInput) (*mediapackagev2.GetOriginEndpointPolicyOutput, error)
	GetOriginEndpointPolicyWithContext(aws.Context, *mediapackagev2.GetOriginEndpointPolicyInput, ...request.Option) (*mediapackagev2.GetOriginEndpointPolicyOutput, error)
	GetOriginEndpointPolicyRequest(*mediapackagev2.GetOriginEndpointPolicyInput) (*request.Request, *mediapackagev2.GetOriginEndpointPolicyOutput)

	ListChannelGroups(*mediapackagev2.ListChannelGroupsInput) (*mediapackagev2.ListChannelGroupsOutput, error)
	ListChannelGroupsWithContext(aws.Context, *mediapackagev2.ListChannelGroupsInput, ...request.Option) (*mediapackagev2.ListChannelGroupsOutput, error)
	ListChannelGroupsRequest(*mediapackagev2.ListChannelGroupsInput) (*request.Request, *mediapackagev2.ListChannelGroupsOutput)

	ListChannelGroupsPages(*mediapackagev2.ListChannelGroupsInput, func(*mediapackagev2.ListChannelGroupsOutput, bool) bool) error
	ListChannelGroupsPagesWithContext(aws.Context, *mediapackagev2.ListChannelGroupsInput, func(*mediapackagev2.ListChannelGroupsOutput, bool) bool, ...request.Option) error

	ListChannels(*mediapackagev2.ListChannelsInput) (*mediapackagev2.ListChannelsOutput, error)
	ListChannelsWithContext(aws.Context, *mediapackagev2.ListChannelsInput, ...request.Option) (*mediapackagev2.ListChannelsOutput, error)
	ListChannelsRequest(*mediapackagev2.ListChannelsInput) (*request.Request, *mediapackagev2.ListChannelsOutput)

	ListChannelsPages(*mediapackagev2.ListChannelsInput, func(*mediapackagev2.ListChannelsOutput, bool) bool) error
	ListChannelsPagesWithContext(aws.Context, *mediapackagev2.ListChannelsInput, func(*mediapackagev2.ListChannelsOutput, bool) bool, ...request.Option) error

	ListOriginEndpoints(*mediapackagev2.ListOriginEndpointsInput) (*mediapackagev2.ListOriginEndpointsOutput, error)
	ListOriginEndpointsWithContext(aws.Context, *mediapackagev2.ListOriginEndpointsInput, ...request.Option) (*mediapackagev2.ListOriginEndpointsOutput, error)
	ListOriginEndpointsRequest(*mediapackagev2.ListOriginEndpointsInput) (*request.Request, *mediapackagev2.ListOriginEndpointsOutput)

	ListOriginEndpointsPages(*mediapackagev2.ListOriginEndpointsInput, func(*mediapackagev2.ListOriginEndpointsOutput, bool) bool) error
	ListOriginEndpointsPagesWithContext(aws.Context, *mediapackagev2.ListOriginEndpointsInput, func(*mediapackagev2.ListOriginEndpointsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*mediapackagev2.ListTagsForResourceInput) (*mediapackagev2.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *mediapackagev2.ListTagsForResourceInput, ...request.Option) (*mediapackagev2.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*mediapackagev2.ListTagsForResourceInput) (*request.Request, *mediapackagev2.ListTagsForResourceOutput)

	PutChannelPolicy(*mediapackagev2.PutChannelPolicyInput) (*mediapackagev2.PutChannelPolicyOutput, error)
	PutChannelPolicyWithContext(aws.Context, *mediapackagev2.PutChannelPolicyInput, ...request.Option) (*mediapackagev2.PutChannelPolicyOutput, error)
	PutChannelPolicyRequest(*mediapackagev2.PutChannelPolicyInput) (*request.Request, *mediapackagev2.PutChannelPolicyOutput)

	PutOriginEndpointPolicy(*mediapackagev2.PutOriginEndpointPolicyInput) (*mediapackagev2.PutOriginEndpointPolicyOutput, error)
	PutOriginEndpointPolicyWithContext(aws.Context, *mediapackagev2.PutOriginEndpointPolicyInput, ...request.Option) (*mediapackagev2.PutOriginEndpointPolicyOutput, error)
	PutOriginEndpointPolicyRequest(*mediapackagev2.PutOriginEndpointPolicyInput) (*request.Request, *mediapackagev2.PutOriginEndpointPolicyOutput)

	TagResource(*mediapackagev2.TagResourceInput) (*mediapackagev2.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *mediapackagev2.TagResourceInput, ...request.Option) (*mediapackagev2.TagResourceOutput, error)
	TagResourceRequest(*mediapackagev2.TagResourceInput) (*request.Request, *mediapackagev2.TagResourceOutput)

	UntagResource(*mediapackagev2.UntagResourceInput) (*mediapackagev2.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *mediapackagev2.UntagResourceInput, ...request.Option) (*mediapackagev2.UntagResourceOutput, error)
	UntagResourceRequest(*mediapackagev2.UntagResourceInput) (*request.Request, *mediapackagev2.UntagResourceOutput)

	UpdateChannel(*mediapackagev2.UpdateChannelInput) (*mediapackagev2.UpdateChannelOutput, error)
	UpdateChannelWithContext(aws.Context, *mediapackagev2.UpdateChannelInput, ...request.Option) (*mediapackagev2.UpdateChannelOutput, error)
	UpdateChannelRequest(*mediapackagev2.UpdateChannelInput) (*request.Request, *mediapackagev2.UpdateChannelOutput)

	UpdateChannelGroup(*mediapackagev2.UpdateChannelGroupInput) (*mediapackagev2.UpdateChannelGroupOutput, error)
	UpdateChannelGroupWithContext(aws.Context, *mediapackagev2.UpdateChannelGroupInput, ...request.Option) (*mediapackagev2.UpdateChannelGroupOutput, error)
	UpdateChannelGroupRequest(*mediapackagev2.UpdateChannelGroupInput) (*request.Request, *mediapackagev2.UpdateChannelGroupOutput)

	UpdateOriginEndpoint(*mediapackagev2.UpdateOriginEndpointInput) (*mediapackagev2.UpdateOriginEndpointOutput, error)
	UpdateOriginEndpointWithContext(aws.Context, *mediapackagev2.UpdateOriginEndpointInput, ...request.Option) (*mediapackagev2.UpdateOriginEndpointOutput, error)
	UpdateOriginEndpointRequest(*mediapackagev2.UpdateOriginEndpointInput) (*request.Request, *mediapackagev2.UpdateOriginEndpointOutput)
}

var _ MediaPackageV2API = (*mediapackagev2.MediaPackageV2)(nil)
