// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediapackagev2_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/mediapackagev2"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// Creating a Channel
//

func ExampleMediaPackageV2_CreateChannel_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.CreateChannelInput{
		ChannelGroupName: aws.String("exampleChannelGroup"),
		ChannelName:      aws.String("exampleChannel"),
		Description:      aws.String("Description for exampleChannel"),
		InputType:        aws.String("HLS"),
		Tags: map[string]*string{
			"key1": aws.String("value1"),
			"key2": aws.String("value2"),
		},
	}

	result, err := svc.CreateChannel(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeConflictException:
				fmt.Println(mediapackagev2.ErrCodeConflictException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			case mediapackagev2.ErrCodeResourceNotFoundException:
				fmt.Println(mediapackagev2.ErrCodeResourceNotFoundException, aerr.Error())
			case mediapackagev2.ErrCodeServiceQuotaExceededException:
				fmt.Println(mediapackagev2.ErrCodeServiceQuotaExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Creating a Channel Group
//

func ExampleMediaPackageV2_CreateChannelGroup_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.CreateChannelGroupInput{
		ChannelGroupName: aws.String("exampleChannelGroup"),
		Description:      aws.String("Description for exampleChannelGroup"),
		Tags: map[string]*string{
			"key1": aws.String("value1"),
			"key2": aws.String("value2"),
		},
	}

	result, err := svc.CreateChannelGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeConflictException:
				fmt.Println(mediapackagev2.ErrCodeConflictException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			case mediapackagev2.ErrCodeResourceNotFoundException:
				fmt.Println(mediapackagev2.ErrCodeResourceNotFoundException, aerr.Error())
			case mediapackagev2.ErrCodeServiceQuotaExceededException:
				fmt.Println(mediapackagev2.ErrCodeServiceQuotaExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Creating an OriginEndpoint with container type TS, and encryption enabled
//

func ExampleMediaPackageV2_CreateOriginEndpoint_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.CreateOriginEndpointInput{
		ChannelGroupName: aws.String("exampleChannelGroup"),
		ChannelName:      aws.String("exampleChannel"),
		ContainerType:    aws.String("TS"),
		Description:      aws.String("Description for exampleOriginEndpointTS"),
		ForceEndpointErrorConfiguration: &mediapackagev2.ForceEndpointErrorConfiguration{
			EndpointErrorConditions: []*string{
				aws.String("STALE_MANIFEST"),
				aws.String("INCOMPLETE_MANIFEST"),
				aws.String("MISSING_DRM_KEY"),
				aws.String("SLATE_INPUT"),
			},
		},
		HlsManifests: []*mediapackagev2.CreateHlsManifestConfiguration{
			{
				ChildManifestName:              aws.String("exampleChildManifest1"),
				ManifestName:                   aws.String("exampleManifest1"),
				ManifestWindowSeconds:          aws.Int64(30),
				ProgramDateTimeIntervalSeconds: aws.Int64(60),
				ScteHls: &mediapackagev2.ScteHls{
					AdMarkerHls: aws.String("DATERANGE"),
				},
			},
			{
				ChildManifestName:              aws.String("exampleManifest2"),
				ManifestName:                   aws.String("exampleManifest2"),
				ManifestWindowSeconds:          aws.Int64(30),
				ProgramDateTimeIntervalSeconds: aws.Int64(60),
				ScteHls: &mediapackagev2.ScteHls{
					AdMarkerHls: aws.String("DATERANGE"),
				},
			},
		},
		LowLatencyHlsManifests: []*mediapackagev2.CreateLowLatencyHlsManifestConfiguration{
			{
				ChildManifestName:              aws.String("exampleLLChildManifest1"),
				ManifestName:                   aws.String("exampleLLManifest1"),
				ManifestWindowSeconds:          aws.Int64(30),
				ProgramDateTimeIntervalSeconds: aws.Int64(60),
				ScteHls: &mediapackagev2.ScteHls{
					AdMarkerHls: aws.String("DATERANGE"),
				},
			},
			{
				ChildManifestName:              aws.String("exampleLLManifest2"),
				ManifestName:                   aws.String("exampleLLManifest2"),
				ManifestWindowSeconds:          aws.Int64(30),
				ProgramDateTimeIntervalSeconds: aws.Int64(60),
				ScteHls: &mediapackagev2.ScteHls{
					AdMarkerHls: aws.String("DATERANGE"),
				},
			},
		},
		OriginEndpointName: aws.String("exampleOriginEndpointTS"),
		Segment: &mediapackagev2.Segment{
			Encryption: &mediapackagev2.Encryption{
				ConstantInitializationVector: aws.String("A382A901F3C1F7718512266CFFBB0B7E"),
				EncryptionMethod: &mediapackagev2.EncryptionMethod{
					TsEncryptionMethod: aws.String("AES_128"),
				},
				KeyRotationIntervalSeconds: aws.Int64(300),
				SpekeKeyProvider: &mediapackagev2.SpekeKeyProvider{
					DrmSystems: []*string{
						aws.String("CLEAR_KEY_AES_128"),
					},
					EncryptionContractConfiguration: &mediapackagev2.EncryptionContractConfiguration{
						PresetSpeke20Audio: aws.String("SHARED"),
						PresetSpeke20Video: aws.String("SHARED"),
					},
					ResourceId: aws.String("ResourceId"),
					RoleArn:    aws.String("arn:aws:iam::123456789012:role/empRole"),
					Url:        aws.String("https://foo.com"),
				},
			},
			IncludeIframeOnlyStreams: aws.Bool(true),
			Scte: &mediapackagev2.Scte{
				ScteFilter: []*string{
					aws.String("SPLICE_INSERT"),
					aws.String("BREAK"),
				},
			},
			SegmentDurationSeconds:   aws.Int64(6),
			SegmentName:              aws.String("segmentName"),
			TsIncludeDvbSubtitles:    aws.Bool(true),
			TsUseAudioRenditionGroup: aws.Bool(true),
		},
		StartoverWindowSeconds: aws.Int64(300),
		Tags: map[string]*string{
			"key1": aws.String("value1"),
			"key2": aws.String("value2"),
		},
	}

	result, err := svc.CreateOriginEndpoint(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeConflictException:
				fmt.Println(mediapackagev2.ErrCodeConflictException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			case mediapackagev2.ErrCodeResourceNotFoundException:
				fmt.Println(mediapackagev2.ErrCodeResourceNotFoundException, aerr.Error())
			case mediapackagev2.ErrCodeServiceQuotaExceededException:
				fmt.Println(mediapackagev2.ErrCodeServiceQuotaExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Creating an OriginEndpoint with container type CMAF, and encryption enabled
//

func ExampleMediaPackageV2_CreateOriginEndpoint_shared01() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.CreateOriginEndpointInput{
		ChannelGroupName: aws.String("exampleChannelGroup"),
		ChannelName:      aws.String("exampleChannel"),
		ContainerType:    aws.String("CMAF"),
		DashManifests: []*mediapackagev2.CreateDashManifestConfiguration{
			{
				DrmSignaling:           aws.String("INDIVIDUAL"),
				ManifestName:           aws.String("exampleDashManifest1"),
				ManifestWindowSeconds:  aws.Int64(300),
				MinBufferTimeSeconds:   aws.Int64(30),
				MinUpdatePeriodSeconds: aws.Int64(5),
				PeriodTriggers: []*string{
					aws.String("AVAILS"),
				},
				ScteDash: &mediapackagev2.ScteDash{
					AdMarkerDash: aws.String("XML"),
				},
				SegmentTemplateFormat:             aws.String("NUMBER_WITH_TIMELINE"),
				SuggestedPresentationDelaySeconds: aws.Int64(2),
			},
			{
				DrmSignaling:           aws.String("INDIVIDUAL"),
				ManifestName:           aws.String("exampleDashManifest2"),
				ManifestWindowSeconds:  aws.Int64(60),
				MinBufferTimeSeconds:   aws.Int64(9),
				MinUpdatePeriodSeconds: aws.Int64(3),
				PeriodTriggers: []*string{
					aws.String("AVAILS"),
					aws.String("DRM_KEY_ROTATION"),
					aws.String("SOURCE_CHANGES"),
					aws.String("SOURCE_DISRUPTIONS"),
				},
				ScteDash: &mediapackagev2.ScteDash{
					AdMarkerDash: aws.String("XML"),
				},
				SegmentTemplateFormat:             aws.String("NUMBER_WITH_TIMELINE"),
				SuggestedPresentationDelaySeconds: aws.Int64(12),
			},
		},
		ForceEndpointErrorConfiguration: &mediapackagev2.ForceEndpointErrorConfiguration{
			EndpointErrorConditions: []*string{
				aws.String("STALE_MANIFEST"),
				aws.String("INCOMPLETE_MANIFEST"),
				aws.String("MISSING_DRM_KEY"),
				aws.String("SLATE_INPUT"),
			},
		},
		HlsManifests: []*mediapackagev2.CreateHlsManifestConfiguration{
			{
				ChildManifestName:              aws.String("exampleChildManifest1"),
				ManifestName:                   aws.String("exampleManifest1"),
				ManifestWindowSeconds:          aws.Int64(30),
				ProgramDateTimeIntervalSeconds: aws.Int64(60),
				ScteHls: &mediapackagev2.ScteHls{
					AdMarkerHls: aws.String("DATERANGE"),
				},
			},
			{
				ChildManifestName:              aws.String("exampleManifest2"),
				ManifestName:                   aws.String("exampleManifest2"),
				ManifestWindowSeconds:          aws.Int64(30),
				ProgramDateTimeIntervalSeconds: aws.Int64(60),
				ScteHls: &mediapackagev2.ScteHls{
					AdMarkerHls: aws.String("DATERANGE"),
				},
			},
		},
		LowLatencyHlsManifests: []*mediapackagev2.CreateLowLatencyHlsManifestConfiguration{
			{
				ChildManifestName:              aws.String("exampleLLChildManifest1"),
				ManifestName:                   aws.String("exampleLLManifest1"),
				ManifestWindowSeconds:          aws.Int64(30),
				ProgramDateTimeIntervalSeconds: aws.Int64(60),
				ScteHls: &mediapackagev2.ScteHls{
					AdMarkerHls: aws.String("DATERANGE"),
				},
			},
			{
				ChildManifestName:              aws.String("exampleLLManifest2"),
				ManifestName:                   aws.String("exampleLLManifest2"),
				ManifestWindowSeconds:          aws.Int64(30),
				ProgramDateTimeIntervalSeconds: aws.Int64(60),
				ScteHls: &mediapackagev2.ScteHls{
					AdMarkerHls: aws.String("DATERANGE"),
				},
			},
		},
		OriginEndpointName: aws.String("exampleOriginEndpointCMAF"),
		Segment: &mediapackagev2.Segment{
			Encryption: &mediapackagev2.Encryption{
				ConstantInitializationVector: aws.String("A382A901F3C1F7718512266CFFBB0B9F"),
				EncryptionMethod: &mediapackagev2.EncryptionMethod{
					CmafEncryptionMethod: aws.String("CBCS"),
				},
				KeyRotationIntervalSeconds: aws.Int64(300),
				SpekeKeyProvider: &mediapackagev2.SpekeKeyProvider{
					DrmSystems: []*string{
						aws.String("PLAYREADY"),
						aws.String("WIDEVINE"),
					},
					EncryptionContractConfiguration: &mediapackagev2.EncryptionContractConfiguration{
						PresetSpeke20Audio: aws.String("PRESET_AUDIO_1"),
						PresetSpeke20Video: aws.String("PRESET_VIDEO_1"),
					},
					ResourceId: aws.String("ResourceId"),
					RoleArn:    aws.String("arn:aws:iam::123456789012:role/empRole"),
					Url:        aws.String("https://foo.com"),
				},
			},
			IncludeIframeOnlyStreams: aws.Bool(true),
			Scte: &mediapackagev2.Scte{
				ScteFilter: []*string{
					aws.String("SPLICE_INSERT"),
					aws.String("BREAK"),
				},
			},
			SegmentDurationSeconds: aws.Int64(6),
			SegmentName:            aws.String("segmentName"),
		},
		StartoverWindowSeconds: aws.Int64(300),
		Tags: map[string]*string{
			"key1": aws.String("value1"),
			"key2": aws.String("value2"),
		},
	}

	result, err := svc.CreateOriginEndpoint(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeConflictException:
				fmt.Println(mediapackagev2.ErrCodeConflictException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			case mediapackagev2.ErrCodeResourceNotFoundException:
				fmt.Println(mediapackagev2.ErrCodeResourceNotFoundException, aerr.Error())
			case mediapackagev2.ErrCodeServiceQuotaExceededException:
				fmt.Println(mediapackagev2.ErrCodeServiceQuotaExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Deleting a Channel
//

func ExampleMediaPackageV2_DeleteChannel_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.DeleteChannelInput{
		ChannelGroupName: aws.String("exampleChannelGroup"),
		ChannelName:      aws.String("exampleChannel"),
	}

	result, err := svc.DeleteChannel(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeConflictException:
				fmt.Println(mediapackagev2.ErrCodeConflictException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Deleting a Channel Group
//

func ExampleMediaPackageV2_DeleteChannelGroup_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.DeleteChannelGroupInput{
		ChannelGroupName: aws.String("exampleChannelGroup"),
	}

	result, err := svc.DeleteChannelGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeConflictException:
				fmt.Println(mediapackagev2.ErrCodeConflictException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Deleting a Channel Policy
//

func ExampleMediaPackageV2_DeleteChannelPolicy_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.DeleteChannelPolicyInput{
		ChannelGroupName: aws.String("exampleChannelGroup"),
		ChannelName:      aws.String("exampleChannel"),
	}

	result, err := svc.DeleteChannelPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeConflictException:
				fmt.Println(mediapackagev2.ErrCodeConflictException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Deleting an OriginEndpoint
//

func ExampleMediaPackageV2_DeleteOriginEndpoint_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.DeleteOriginEndpointInput{
		ChannelGroupName:   aws.String("exampleChannelGroup"),
		ChannelName:        aws.String("exampleChannel"),
		OriginEndpointName: aws.String("exampleOriginEndpointTS"),
	}

	result, err := svc.DeleteOriginEndpoint(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Deleting an Origin Endpoint Policy
//

func ExampleMediaPackageV2_DeleteOriginEndpointPolicy_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.DeleteOriginEndpointPolicyInput{
		ChannelGroupName:   aws.String("exampleChannelGroup"),
		ChannelName:        aws.String("exampleChannel"),
		OriginEndpointName: aws.String("exampleOriginEndpoint"),
	}

	result, err := svc.DeleteOriginEndpointPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeConflictException:
				fmt.Println(mediapackagev2.ErrCodeConflictException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Getting a Channel
//

func ExampleMediaPackageV2_GetChannel_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.GetChannelInput{
		ChannelGroupName: aws.String("exampleChannelGroup"),
		ChannelName:      aws.String("exampleChannel"),
	}

	result, err := svc.GetChannel(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			case mediapackagev2.ErrCodeResourceNotFoundException:
				fmt.Println(mediapackagev2.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Getting a Channel Group
//

func ExampleMediaPackageV2_GetChannelGroup_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.GetChannelGroupInput{
		ChannelGroupName: aws.String("exampleChannelGroup"),
	}

	result, err := svc.GetChannelGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			case mediapackagev2.ErrCodeResourceNotFoundException:
				fmt.Println(mediapackagev2.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Getting a Channel Policy
//

func ExampleMediaPackageV2_GetChannelPolicy_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.GetChannelPolicyInput{
		ChannelGroupName: aws.String("exampleChannelGroup"),
		ChannelName:      aws.String("exampleChannel"),
	}

	result, err := svc.GetChannelPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			case mediapackagev2.ErrCodeResourceNotFoundException:
				fmt.Println(mediapackagev2.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Getting an OriginEndpoint
//

func ExampleMediaPackageV2_GetOriginEndpoint_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.GetOriginEndpointInput{
		ChannelGroupName:   aws.String("exampleChannelGroup"),
		ChannelName:        aws.String("exampleChannel"),
		OriginEndpointName: aws.String("exampleOriginEndpointTS"),
	}

	result, err := svc.GetOriginEndpoint(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			case mediapackagev2.ErrCodeResourceNotFoundException:
				fmt.Println(mediapackagev2.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Getting an Origin Endpoint Policy
//

func ExampleMediaPackageV2_GetOriginEndpointPolicy_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.GetOriginEndpointPolicyInput{
		ChannelGroupName:   aws.String("exampleChannelGroup"),
		ChannelName:        aws.String("exampleChannel"),
		OriginEndpointName: aws.String("exampleOriginEndpoint"),
	}

	result, err := svc.GetOriginEndpointPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			case mediapackagev2.ErrCodeResourceNotFoundException:
				fmt.Println(mediapackagev2.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Listing all Channel Groups
//

func ExampleMediaPackageV2_ListChannelGroups_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.ListChannelGroupsInput{}

	result, err := svc.ListChannelGroups(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Listing all Channels
//

func ExampleMediaPackageV2_ListChannels_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.ListChannelsInput{
		ChannelGroupName: aws.String("exampleChannelGroup"),
	}

	result, err := svc.ListChannels(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			case mediapackagev2.ErrCodeResourceNotFoundException:
				fmt.Println(mediapackagev2.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Listing all OriginEndpoints
//

func ExampleMediaPackageV2_ListOriginEndpoints_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.ListOriginEndpointsInput{
		ChannelGroupName: aws.String("exampleChannelGroup"),
		ChannelName:      aws.String("exampleChannel"),
	}

	result, err := svc.ListOriginEndpoints(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			case mediapackagev2.ErrCodeResourceNotFoundException:
				fmt.Println(mediapackagev2.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// List all tags for a resource
//

func ExampleMediaPackageV2_ListTagsForResource_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.ListTagsForResourceInput{
		ResourceArn: aws.String("arn:aws:mediapackagev2:us-west-2:123456789012:channelGroup/exampleChannelGroup/channel/exampleChannel"),
	}

	result, err := svc.ListTagsForResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Creating a Channel Policy
//

func ExampleMediaPackageV2_PutChannelPolicy_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.PutChannelPolicyInput{
		ChannelGroupName: aws.String("exampleChannelGroup"),
		ChannelName:      aws.String("exampleChannel"),
		Policy:           aws.String("{...}"),
	}

	result, err := svc.PutChannelPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeConflictException:
				fmt.Println(mediapackagev2.ErrCodeConflictException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			case mediapackagev2.ErrCodeResourceNotFoundException:
				fmt.Println(mediapackagev2.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Creating an Origin Endpoint Policy
//

func ExampleMediaPackageV2_PutOriginEndpointPolicy_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.PutOriginEndpointPolicyInput{
		ChannelGroupName:   aws.String("exampleChannelGroup"),
		ChannelName:        aws.String("exampleChannel"),
		OriginEndpointName: aws.String("exampleOriginEndpoint"),
		Policy:             aws.String("{...}"),
	}

	result, err := svc.PutOriginEndpointPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeConflictException:
				fmt.Println(mediapackagev2.ErrCodeConflictException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			case mediapackagev2.ErrCodeResourceNotFoundException:
				fmt.Println(mediapackagev2.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Add tags to a resource
//

func ExampleMediaPackageV2_TagResource_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.TagResourceInput{
		ResourceArn: aws.String("arn:aws:mediapackagev2:us-west-2:123456789012:channelGroup/exampleChannelGroup/channel/exampleChannel"),
		Tags: map[string]*string{
			"key3": aws.String("value3"),
			"key4": aws.String("value4"),
		},
	}

	result, err := svc.TagResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Remove tags from a resource
//

func ExampleMediaPackageV2_UntagResource_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.UntagResourceInput{
		ResourceArn: aws.String("arn:aws:mediapackagev2:us-west-2:123456789012:channelGroup/exampleChannelGroup/channel/exampleChannel"),
		TagKeys: []*string{
			aws.String("key3"),
			aws.String("key4"),
		},
	}

	result, err := svc.UntagResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Updating a Channel
//

func ExampleMediaPackageV2_UpdateChannel_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.UpdateChannelInput{
		ChannelGroupName: aws.String("exampleChannelGroup"),
		ChannelName:      aws.String("exampleChannel"),
		Description:      aws.String("Updated description for exampleChannel"),
	}

	result, err := svc.UpdateChannel(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeConflictException:
				fmt.Println(mediapackagev2.ErrCodeConflictException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			case mediapackagev2.ErrCodeResourceNotFoundException:
				fmt.Println(mediapackagev2.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Updating a Channel Group
//

func ExampleMediaPackageV2_UpdateChannelGroup_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.UpdateChannelGroupInput{
		ChannelGroupName: aws.String("exampleChannelGroup"),
		Description:      aws.String("Updated description for exampleChannelGroup"),
	}

	result, err := svc.UpdateChannelGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeConflictException:
				fmt.Println(mediapackagev2.ErrCodeConflictException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			case mediapackagev2.ErrCodeResourceNotFoundException:
				fmt.Println(mediapackagev2.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Updating an OriginEndpoint
//

func ExampleMediaPackageV2_UpdateOriginEndpoint_shared00() {
	svc := mediapackagev2.New(session.New())
	input := &mediapackagev2.UpdateOriginEndpointInput{
		ChannelGroupName: aws.String("exampleChannelGroup"),
		ChannelName:      aws.String("exampleChannel"),
		ContainerType:    aws.String("TS"),
		Description:      aws.String("Updated description for exampleOriginEndpointTS"),
		ForceEndpointErrorConfiguration: &mediapackagev2.ForceEndpointErrorConfiguration{
			EndpointErrorConditions: []*string{
				aws.String("STALE_MANIFEST"),
				aws.String("INCOMPLETE_MANIFEST"),
				aws.String("MISSING_DRM_KEY"),
				aws.String("SLATE_INPUT"),
			},
		},
		HlsManifests: []*mediapackagev2.CreateHlsManifestConfiguration{
			{
				ChildManifestName:              aws.String("exampleChildManifest1"),
				ManifestName:                   aws.String("exampleManifest1"),
				ManifestWindowSeconds:          aws.Int64(30),
				ProgramDateTimeIntervalSeconds: aws.Int64(60),
				ScteHls: &mediapackagev2.ScteHls{
					AdMarkerHls: aws.String("DATERANGE"),
				},
			},
			{
				ChildManifestName:              aws.String("exampleManifest2"),
				ManifestName:                   aws.String("exampleManifest2"),
				ManifestWindowSeconds:          aws.Int64(30),
				ProgramDateTimeIntervalSeconds: aws.Int64(60),
				ScteHls: &mediapackagev2.ScteHls{
					AdMarkerHls: aws.String("DATERANGE"),
				},
			},
		},
		LowLatencyHlsManifests: []*mediapackagev2.CreateLowLatencyHlsManifestConfiguration{
			{
				ChildManifestName:              aws.String("exampleLLChildManifest1"),
				ManifestName:                   aws.String("exampleLLManifest1"),
				ManifestWindowSeconds:          aws.Int64(30),
				ProgramDateTimeIntervalSeconds: aws.Int64(60),
				ScteHls: &mediapackagev2.ScteHls{
					AdMarkerHls: aws.String("DATERANGE"),
				},
			},
			{
				ChildManifestName:              aws.String("exampleLLManifest2"),
				ManifestName:                   aws.String("exampleLLManifest2"),
				ManifestWindowSeconds:          aws.Int64(30),
				ProgramDateTimeIntervalSeconds: aws.Int64(60),
				ScteHls: &mediapackagev2.ScteHls{
					AdMarkerHls: aws.String("DATERANGE"),
				},
			},
		},
		OriginEndpointName: aws.String("exampleOriginEndpointTS"),
		Segment: &mediapackagev2.Segment{
			Encryption: &mediapackagev2.Encryption{
				ConstantInitializationVector: aws.String("A382A901F3C1F7718512266CFFBB0B7E"),
				EncryptionMethod: &mediapackagev2.EncryptionMethod{
					TsEncryptionMethod: aws.String("AES_128"),
				},
				KeyRotationIntervalSeconds: aws.Int64(300),
				SpekeKeyProvider: &mediapackagev2.SpekeKeyProvider{
					DrmSystems: []*string{
						aws.String("CLEAR_KEY_AES_128"),
					},
					EncryptionContractConfiguration: &mediapackagev2.EncryptionContractConfiguration{
						PresetSpeke20Audio: aws.String("SHARED"),
						PresetSpeke20Video: aws.String("SHARED"),
					},
					ResourceId: aws.String("ResourceId"),
					RoleArn:    aws.String("arn:aws:iam::123456789012:role/empRole"),
					Url:        aws.String("https://foo.com"),
				},
			},
			IncludeIframeOnlyStreams: aws.Bool(false),
			Scte: &mediapackagev2.Scte{
				ScteFilter: []*string{
					aws.String("SPLICE_INSERT"),
				},
			},
			SegmentDurationSeconds:   aws.Int64(7),
			SegmentName:              aws.String("segmentName2"),
			TsIncludeDvbSubtitles:    aws.Bool(false),
			TsUseAudioRenditionGroup: aws.Bool(true),
		},
		StartoverWindowSeconds: aws.Int64(600),
	}

	result, err := svc.UpdateOriginEndpoint(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case mediapackagev2.ErrCodeThrottlingException:
				fmt.Println(mediapackagev2.ErrCodeThrottlingException, aerr.Error())
			case mediapackagev2.ErrCodeConflictException:
				fmt.Println(mediapackagev2.ErrCodeConflictException, aerr.Error())
			case mediapackagev2.ErrCodeInternalServerException:
				fmt.Println(mediapackagev2.ErrCodeInternalServerException, aerr.Error())
			case mediapackagev2.ErrCodeAccessDeniedException:
				fmt.Println(mediapackagev2.ErrCodeAccessDeniedException, aerr.Error())
			case mediapackagev2.ErrCodeValidationException:
				fmt.Println(mediapackagev2.ErrCodeValidationException, aerr.Error())
			case mediapackagev2.ErrCodeResourceNotFoundException:
				fmt.Println(mediapackagev2.ErrCodeResourceNotFoundException, aerr.Error())
			case mediapackagev2.ErrCodeServiceQuotaExceededException:
				fmt.Println(mediapackagev2.ErrCodeServiceQuotaExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
