// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationsignals

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchGetServiceLevelObjectiveBudgetReport = "BatchGetServiceLevelObjectiveBudgetReport"

// BatchGetServiceLevelObjectiveBudgetReportRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetServiceLevelObjectiveBudgetReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetServiceLevelObjectiveBudgetReport for more information on using the BatchGetServiceLevelObjectiveBudgetReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetServiceLevelObjectiveBudgetReportRequest method.
//	req, resp := client.BatchGetServiceLevelObjectiveBudgetReportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/BatchGetServiceLevelObjectiveBudgetReport
func (c *ApplicationSignals) BatchGetServiceLevelObjectiveBudgetReportRequest(input *BatchGetServiceLevelObjectiveBudgetReportInput) (req *request.Request, output *BatchGetServiceLevelObjectiveBudgetReportOutput) {
	op := &request.Operation{
		Name:       opBatchGetServiceLevelObjectiveBudgetReport,
		HTTPMethod: "POST",
		HTTPPath:   "/budget-report",
	}

	if input == nil {
		input = &BatchGetServiceLevelObjectiveBudgetReportInput{}
	}

	output = &BatchGetServiceLevelObjectiveBudgetReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetServiceLevelObjectiveBudgetReport API operation for Amazon CloudWatch Application Signals.
//
// Use this operation to retrieve one or more service level objective (SLO)
// budget reports.
//
// An error budget is the amount of time in unhealthy periods that your service
// can accumulate during an interval before your overall SLO budget health is
// breached and the SLO is considered to be unmet. For example, an SLO with
// a threshold of 99.95% and a monthly interval translates to an error budget
// of 21.9 minutes of downtime in a 30-day month.
//
// Budget reports include a health indicator, the attainment value, and remaining
// budget.
//
// For more information about SLO error budgets, see SLO concepts (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-ServiceLevelObjectives.html#CloudWatch-ServiceLevelObjectives-concepts).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Signals's
// API operation BatchGetServiceLevelObjectiveBudgetReport for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The resource is not valid.
//
//   - ThrottlingException
//     The request was throttled because of quota limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/BatchGetServiceLevelObjectiveBudgetReport
func (c *ApplicationSignals) BatchGetServiceLevelObjectiveBudgetReport(input *BatchGetServiceLevelObjectiveBudgetReportInput) (*BatchGetServiceLevelObjectiveBudgetReportOutput, error) {
	req, out := c.BatchGetServiceLevelObjectiveBudgetReportRequest(input)
	return out, req.Send()
}

// BatchGetServiceLevelObjectiveBudgetReportWithContext is the same as BatchGetServiceLevelObjectiveBudgetReport with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetServiceLevelObjectiveBudgetReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) BatchGetServiceLevelObjectiveBudgetReportWithContext(ctx aws.Context, input *BatchGetServiceLevelObjectiveBudgetReportInput, opts ...request.Option) (*BatchGetServiceLevelObjectiveBudgetReportOutput, error) {
	req, out := c.BatchGetServiceLevelObjectiveBudgetReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateServiceLevelObjective = "CreateServiceLevelObjective"

// CreateServiceLevelObjectiveRequest generates a "aws/request.Request" representing the
// client's request for the CreateServiceLevelObjective operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateServiceLevelObjective for more information on using the CreateServiceLevelObjective
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateServiceLevelObjectiveRequest method.
//	req, resp := client.CreateServiceLevelObjectiveRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/CreateServiceLevelObjective
func (c *ApplicationSignals) CreateServiceLevelObjectiveRequest(input *CreateServiceLevelObjectiveInput) (req *request.Request, output *CreateServiceLevelObjectiveOutput) {
	op := &request.Operation{
		Name:       opCreateServiceLevelObjective,
		HTTPMethod: "POST",
		HTTPPath:   "/slo",
	}

	if input == nil {
		input = &CreateServiceLevelObjectiveInput{}
	}

	output = &CreateServiceLevelObjectiveOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateServiceLevelObjective API operation for Amazon CloudWatch Application Signals.
//
// Creates a service level objective (SLO), which can help you ensure that your
// critical business operations are meeting customer expectations. Use SLOs
// to set and track specific target levels for the reliability and availability
// of your applications and services. SLOs use service level indicators (SLIs)
// to calculate whether the application is performing at the level that you
// want.
//
// Create an SLO to set a target for a service or operation’s availability
// or latency. CloudWatch measures this target frequently you can find whether
// it has been breached.
//
// When you create an SLO, you set an attainment goal for it. An attainment
// goal is the ratio of good periods that meet the threshold requirements to
// the total periods within the interval. For example, an attainment goal of
// 99.9% means that within your interval, you are targeting 99.9% of the periods
// to be in healthy state.
//
// After you have created an SLO, you can retrieve error budget reports for
// it. An error budget is the number of periods or amount of time that your
// service can accumulate during an interval before your overall SLO budget
// health is breached and the SLO is considered to be unmet. for example, an
// SLO with a threshold that 99.95% of requests must be completed under 2000ms
// every month translates to an error budget of 21.9 minutes of downtime per
// month.
//
// When you call this operation, Application Signals creates the AWSServiceRoleForCloudWatchApplicationSignals
// service-linked role, if it doesn't already exist in your account. This service-
// linked role has the following permissions:
//
//   - xray:GetServiceGraph
//
//   - logs:StartQuery
//
//   - logs:GetQueryResults
//
//   - cloudwatch:GetMetricData
//
//   - cloudwatch:ListMetrics
//
//   - tag:GetResources
//
//   - autoscaling:DescribeAutoScalingGroups
//
// You can easily set SLO targets for your applications that are discovered
// by Application Signals, using critical metrics such as latency and availability.
// You can also set SLOs against any CloudWatch metric or math expression that
// produces a time series.
//
// For more information about SLOs, see Service level objectives (SLOs) (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-ServiceLevelObjectives.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Signals's
// API operation CreateServiceLevelObjective for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The resource is not valid.
//
//   - ThrottlingException
//     The request was throttled because of quota limits.
//
//   - AccessDeniedException
//     You don't have sufficient permissions to perform this action.
//
//   - ServiceQuotaExceededException
//     This request exceeds a service quota.
//
//   - ConflictException
//     This operation attempted to create a resource that already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/CreateServiceLevelObjective
func (c *ApplicationSignals) CreateServiceLevelObjective(input *CreateServiceLevelObjectiveInput) (*CreateServiceLevelObjectiveOutput, error) {
	req, out := c.CreateServiceLevelObjectiveRequest(input)
	return out, req.Send()
}

// CreateServiceLevelObjectiveWithContext is the same as CreateServiceLevelObjective with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServiceLevelObjective for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) CreateServiceLevelObjectiveWithContext(ctx aws.Context, input *CreateServiceLevelObjectiveInput, opts ...request.Option) (*CreateServiceLevelObjectiveOutput, error) {
	req, out := c.CreateServiceLevelObjectiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServiceLevelObjective = "DeleteServiceLevelObjective"

// DeleteServiceLevelObjectiveRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServiceLevelObjective operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteServiceLevelObjective for more information on using the DeleteServiceLevelObjective
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteServiceLevelObjectiveRequest method.
//	req, resp := client.DeleteServiceLevelObjectiveRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/DeleteServiceLevelObjective
func (c *ApplicationSignals) DeleteServiceLevelObjectiveRequest(input *DeleteServiceLevelObjectiveInput) (req *request.Request, output *DeleteServiceLevelObjectiveOutput) {
	op := &request.Operation{
		Name:       opDeleteServiceLevelObjective,
		HTTPMethod: "DELETE",
		HTTPPath:   "/slo/{Id}",
	}

	if input == nil {
		input = &DeleteServiceLevelObjectiveInput{}
	}

	output = &DeleteServiceLevelObjectiveOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteServiceLevelObjective API operation for Amazon CloudWatch Application Signals.
//
// Deletes the specified service level objective.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Signals's
// API operation DeleteServiceLevelObjective for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The resource is not valid.
//
//   - ResourceNotFoundException
//     Resource not found.
//
//   - ThrottlingException
//     The request was throttled because of quota limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/DeleteServiceLevelObjective
func (c *ApplicationSignals) DeleteServiceLevelObjective(input *DeleteServiceLevelObjectiveInput) (*DeleteServiceLevelObjectiveOutput, error) {
	req, out := c.DeleteServiceLevelObjectiveRequest(input)
	return out, req.Send()
}

// DeleteServiceLevelObjectiveWithContext is the same as DeleteServiceLevelObjective with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServiceLevelObjective for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) DeleteServiceLevelObjectiveWithContext(ctx aws.Context, input *DeleteServiceLevelObjectiveInput, opts ...request.Option) (*DeleteServiceLevelObjectiveOutput, error) {
	req, out := c.DeleteServiceLevelObjectiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetService = "GetService"

// GetServiceRequest generates a "aws/request.Request" representing the
// client's request for the GetService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetService for more information on using the GetService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServiceRequest method.
//	req, resp := client.GetServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/GetService
func (c *ApplicationSignals) GetServiceRequest(input *GetServiceInput) (req *request.Request, output *GetServiceOutput) {
	op := &request.Operation{
		Name:       opGetService,
		HTTPMethod: "POST",
		HTTPPath:   "/service",
	}

	if input == nil {
		input = &GetServiceInput{}
	}

	output = &GetServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetService API operation for Amazon CloudWatch Application Signals.
//
// Returns information about a service discovered by Application Signals.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Signals's
// API operation GetService for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The resource is not valid.
//
//   - ThrottlingException
//     The request was throttled because of quota limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/GetService
func (c *ApplicationSignals) GetService(input *GetServiceInput) (*GetServiceOutput, error) {
	req, out := c.GetServiceRequest(input)
	return out, req.Send()
}

// GetServiceWithContext is the same as GetService with the addition of
// the ability to pass a context and additional request options.
//
// See GetService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) GetServiceWithContext(ctx aws.Context, input *GetServiceInput, opts ...request.Option) (*GetServiceOutput, error) {
	req, out := c.GetServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceLevelObjective = "GetServiceLevelObjective"

// GetServiceLevelObjectiveRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceLevelObjective operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceLevelObjective for more information on using the GetServiceLevelObjective
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServiceLevelObjectiveRequest method.
//	req, resp := client.GetServiceLevelObjectiveRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/GetServiceLevelObjective
func (c *ApplicationSignals) GetServiceLevelObjectiveRequest(input *GetServiceLevelObjectiveInput) (req *request.Request, output *GetServiceLevelObjectiveOutput) {
	op := &request.Operation{
		Name:       opGetServiceLevelObjective,
		HTTPMethod: "GET",
		HTTPPath:   "/slo/{Id}",
	}

	if input == nil {
		input = &GetServiceLevelObjectiveInput{}
	}

	output = &GetServiceLevelObjectiveOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceLevelObjective API operation for Amazon CloudWatch Application Signals.
//
// Returns information about one SLO created in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Signals's
// API operation GetServiceLevelObjective for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The resource is not valid.
//
//   - ResourceNotFoundException
//     Resource not found.
//
//   - ThrottlingException
//     The request was throttled because of quota limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/GetServiceLevelObjective
func (c *ApplicationSignals) GetServiceLevelObjective(input *GetServiceLevelObjectiveInput) (*GetServiceLevelObjectiveOutput, error) {
	req, out := c.GetServiceLevelObjectiveRequest(input)
	return out, req.Send()
}

// GetServiceLevelObjectiveWithContext is the same as GetServiceLevelObjective with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceLevelObjective for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) GetServiceLevelObjectiveWithContext(ctx aws.Context, input *GetServiceLevelObjectiveInput, opts ...request.Option) (*GetServiceLevelObjectiveOutput, error) {
	req, out := c.GetServiceLevelObjectiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListServiceDependencies = "ListServiceDependencies"

// ListServiceDependenciesRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceDependencies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceDependencies for more information on using the ListServiceDependencies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServiceDependenciesRequest method.
//	req, resp := client.ListServiceDependenciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceDependencies
func (c *ApplicationSignals) ListServiceDependenciesRequest(input *ListServiceDependenciesInput) (req *request.Request, output *ListServiceDependenciesOutput) {
	op := &request.Operation{
		Name:       opListServiceDependencies,
		HTTPMethod: "POST",
		HTTPPath:   "/service-dependencies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceDependenciesInput{}
	}

	output = &ListServiceDependenciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceDependencies API operation for Amazon CloudWatch Application Signals.
//
// Returns a list of service dependencies of the service that you specify. A
// dependency is an infrastructure component that an operation of this service
// connects with. Dependencies can include Amazon Web Services services, Amazon
// Web Services resources, and third-party services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Signals's
// API operation ListServiceDependencies for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The resource is not valid.
//
//   - ThrottlingException
//     The request was throttled because of quota limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceDependencies
func (c *ApplicationSignals) ListServiceDependencies(input *ListServiceDependenciesInput) (*ListServiceDependenciesOutput, error) {
	req, out := c.ListServiceDependenciesRequest(input)
	return out, req.Send()
}

// ListServiceDependenciesWithContext is the same as ListServiceDependencies with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceDependencies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) ListServiceDependenciesWithContext(ctx aws.Context, input *ListServiceDependenciesInput, opts ...request.Option) (*ListServiceDependenciesOutput, error) {
	req, out := c.ListServiceDependenciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceDependenciesPages iterates over the pages of a ListServiceDependencies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceDependencies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServiceDependencies operation.
//	pageNum := 0
//	err := client.ListServiceDependenciesPages(params,
//	    func(page *applicationsignals.ListServiceDependenciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ApplicationSignals) ListServiceDependenciesPages(input *ListServiceDependenciesInput, fn func(*ListServiceDependenciesOutput, bool) bool) error {
	return c.ListServiceDependenciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceDependenciesPagesWithContext same as ListServiceDependenciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) ListServiceDependenciesPagesWithContext(ctx aws.Context, input *ListServiceDependenciesInput, fn func(*ListServiceDependenciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceDependenciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceDependenciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServiceDependenciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServiceDependents = "ListServiceDependents"

// ListServiceDependentsRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceDependents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceDependents for more information on using the ListServiceDependents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServiceDependentsRequest method.
//	req, resp := client.ListServiceDependentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceDependents
func (c *ApplicationSignals) ListServiceDependentsRequest(input *ListServiceDependentsInput) (req *request.Request, output *ListServiceDependentsOutput) {
	op := &request.Operation{
		Name:       opListServiceDependents,
		HTTPMethod: "POST",
		HTTPPath:   "/service-dependents",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceDependentsInput{}
	}

	output = &ListServiceDependentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceDependents API operation for Amazon CloudWatch Application Signals.
//
// Returns the list of dependents that invoked the specified service during
// the provided time range. Dependents include other services, CloudWatch Synthetics
// canaries, and clients that are instrumented with CloudWatch RUM app monitors.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Signals's
// API operation ListServiceDependents for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The resource is not valid.
//
//   - ThrottlingException
//     The request was throttled because of quota limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceDependents
func (c *ApplicationSignals) ListServiceDependents(input *ListServiceDependentsInput) (*ListServiceDependentsOutput, error) {
	req, out := c.ListServiceDependentsRequest(input)
	return out, req.Send()
}

// ListServiceDependentsWithContext is the same as ListServiceDependents with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceDependents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) ListServiceDependentsWithContext(ctx aws.Context, input *ListServiceDependentsInput, opts ...request.Option) (*ListServiceDependentsOutput, error) {
	req, out := c.ListServiceDependentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceDependentsPages iterates over the pages of a ListServiceDependents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceDependents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServiceDependents operation.
//	pageNum := 0
//	err := client.ListServiceDependentsPages(params,
//	    func(page *applicationsignals.ListServiceDependentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ApplicationSignals) ListServiceDependentsPages(input *ListServiceDependentsInput, fn func(*ListServiceDependentsOutput, bool) bool) error {
	return c.ListServiceDependentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceDependentsPagesWithContext same as ListServiceDependentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) ListServiceDependentsPagesWithContext(ctx aws.Context, input *ListServiceDependentsInput, fn func(*ListServiceDependentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceDependentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceDependentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServiceDependentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServiceLevelObjectives = "ListServiceLevelObjectives"

// ListServiceLevelObjectivesRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceLevelObjectives operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceLevelObjectives for more information on using the ListServiceLevelObjectives
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServiceLevelObjectivesRequest method.
//	req, resp := client.ListServiceLevelObjectivesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceLevelObjectives
func (c *ApplicationSignals) ListServiceLevelObjectivesRequest(input *ListServiceLevelObjectivesInput) (req *request.Request, output *ListServiceLevelObjectivesOutput) {
	op := &request.Operation{
		Name:       opListServiceLevelObjectives,
		HTTPMethod: "POST",
		HTTPPath:   "/slos",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceLevelObjectivesInput{}
	}

	output = &ListServiceLevelObjectivesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceLevelObjectives API operation for Amazon CloudWatch Application Signals.
//
// Returns a list of SLOs created in this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Signals's
// API operation ListServiceLevelObjectives for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The resource is not valid.
//
//   - ThrottlingException
//     The request was throttled because of quota limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceLevelObjectives
func (c *ApplicationSignals) ListServiceLevelObjectives(input *ListServiceLevelObjectivesInput) (*ListServiceLevelObjectivesOutput, error) {
	req, out := c.ListServiceLevelObjectivesRequest(input)
	return out, req.Send()
}

// ListServiceLevelObjectivesWithContext is the same as ListServiceLevelObjectives with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceLevelObjectives for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) ListServiceLevelObjectivesWithContext(ctx aws.Context, input *ListServiceLevelObjectivesInput, opts ...request.Option) (*ListServiceLevelObjectivesOutput, error) {
	req, out := c.ListServiceLevelObjectivesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceLevelObjectivesPages iterates over the pages of a ListServiceLevelObjectives operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceLevelObjectives method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServiceLevelObjectives operation.
//	pageNum := 0
//	err := client.ListServiceLevelObjectivesPages(params,
//	    func(page *applicationsignals.ListServiceLevelObjectivesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ApplicationSignals) ListServiceLevelObjectivesPages(input *ListServiceLevelObjectivesInput, fn func(*ListServiceLevelObjectivesOutput, bool) bool) error {
	return c.ListServiceLevelObjectivesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceLevelObjectivesPagesWithContext same as ListServiceLevelObjectivesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) ListServiceLevelObjectivesPagesWithContext(ctx aws.Context, input *ListServiceLevelObjectivesInput, fn func(*ListServiceLevelObjectivesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceLevelObjectivesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceLevelObjectivesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServiceLevelObjectivesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServiceOperations = "ListServiceOperations"

// ListServiceOperationsRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceOperations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceOperations for more information on using the ListServiceOperations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServiceOperationsRequest method.
//	req, resp := client.ListServiceOperationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceOperations
func (c *ApplicationSignals) ListServiceOperationsRequest(input *ListServiceOperationsInput) (req *request.Request, output *ListServiceOperationsOutput) {
	op := &request.Operation{
		Name:       opListServiceOperations,
		HTTPMethod: "POST",
		HTTPPath:   "/service-operations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceOperationsInput{}
	}

	output = &ListServiceOperationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceOperations API operation for Amazon CloudWatch Application Signals.
//
// Returns a list of the operations of this service that have been discovered
// by Application Signals. Only the operations that were invoked during the
// specified time range are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Signals's
// API operation ListServiceOperations for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The resource is not valid.
//
//   - ThrottlingException
//     The request was throttled because of quota limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceOperations
func (c *ApplicationSignals) ListServiceOperations(input *ListServiceOperationsInput) (*ListServiceOperationsOutput, error) {
	req, out := c.ListServiceOperationsRequest(input)
	return out, req.Send()
}

// ListServiceOperationsWithContext is the same as ListServiceOperations with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceOperations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) ListServiceOperationsWithContext(ctx aws.Context, input *ListServiceOperationsInput, opts ...request.Option) (*ListServiceOperationsOutput, error) {
	req, out := c.ListServiceOperationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceOperationsPages iterates over the pages of a ListServiceOperations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceOperations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServiceOperations operation.
//	pageNum := 0
//	err := client.ListServiceOperationsPages(params,
//	    func(page *applicationsignals.ListServiceOperationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ApplicationSignals) ListServiceOperationsPages(input *ListServiceOperationsInput, fn func(*ListServiceOperationsOutput, bool) bool) error {
	return c.ListServiceOperationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceOperationsPagesWithContext same as ListServiceOperationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) ListServiceOperationsPagesWithContext(ctx aws.Context, input *ListServiceOperationsInput, fn func(*ListServiceOperationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceOperationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceOperationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServiceOperationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServices = "ListServices"

// ListServicesRequest generates a "aws/request.Request" representing the
// client's request for the ListServices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServices for more information on using the ListServices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServicesRequest method.
//	req, resp := client.ListServicesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServices
func (c *ApplicationSignals) ListServicesRequest(input *ListServicesInput) (req *request.Request, output *ListServicesOutput) {
	op := &request.Operation{
		Name:       opListServices,
		HTTPMethod: "GET",
		HTTPPath:   "/services",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServicesInput{}
	}

	output = &ListServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServices API operation for Amazon CloudWatch Application Signals.
//
// Returns a list of services that have been discovered by Application Signals.
// A service represents a minimum logical and transactional unit that completes
// a business function. Services are discovered through Application Signals
// instrumentation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Signals's
// API operation ListServices for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The resource is not valid.
//
//   - ThrottlingException
//     The request was throttled because of quota limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServices
func (c *ApplicationSignals) ListServices(input *ListServicesInput) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	return out, req.Send()
}

// ListServicesWithContext is the same as ListServices with the addition of
// the ability to pass a context and additional request options.
//
// See ListServices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) ListServicesWithContext(ctx aws.Context, input *ListServicesInput, opts ...request.Option) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServicesPages iterates over the pages of a ListServices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServices operation.
//	pageNum := 0
//	err := client.ListServicesPages(params,
//	    func(page *applicationsignals.ListServicesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ApplicationSignals) ListServicesPages(input *ListServicesInput, fn func(*ListServicesOutput, bool) bool) error {
	return c.ListServicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServicesPagesWithContext same as ListServicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) ListServicesPagesWithContext(ctx aws.Context, input *ListServicesInput, fn func(*ListServicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListTagsForResource
func (c *ApplicationSignals) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon CloudWatch Application Signals.
//
// Displays the tags associated with a CloudWatch resource. Tags can be assigned
// to service level objectives.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Signals's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Resource not found.
//
//   - ThrottlingException
//     The request was throttled because of quota limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListTagsForResource
func (c *ApplicationSignals) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDiscovery = "StartDiscovery"

// StartDiscoveryRequest generates a "aws/request.Request" representing the
// client's request for the StartDiscovery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDiscovery for more information on using the StartDiscovery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartDiscoveryRequest method.
//	req, resp := client.StartDiscoveryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/StartDiscovery
func (c *ApplicationSignals) StartDiscoveryRequest(input *StartDiscoveryInput) (req *request.Request, output *StartDiscoveryOutput) {
	op := &request.Operation{
		Name:       opStartDiscovery,
		HTTPMethod: "POST",
		HTTPPath:   "/start-discovery",
	}

	if input == nil {
		input = &StartDiscoveryInput{}
	}

	output = &StartDiscoveryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartDiscovery API operation for Amazon CloudWatch Application Signals.
//
// Enables this Amazon Web Services account to be able to use CloudWatch Application
// Signals by creating the AWSServiceRoleForCloudWatchApplicationSignals service-linked
// role. This service- linked role has the following permissions:
//
//   - xray:GetServiceGraph
//
//   - logs:StartQuery
//
//   - logs:GetQueryResults
//
//   - cloudwatch:GetMetricData
//
//   - cloudwatch:ListMetrics
//
//   - tag:GetResources
//
//   - autoscaling:DescribeAutoScalingGroups
//
// After completing this step, you still need to instrument your Java and Python
// applications to send data to Application Signals. For more information, see
// Enabling Application Signals (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Application-Signals-Enable.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Signals's
// API operation StartDiscovery for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The resource is not valid.
//
//   - ThrottlingException
//     The request was throttled because of quota limits.
//
//   - AccessDeniedException
//     You don't have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/StartDiscovery
func (c *ApplicationSignals) StartDiscovery(input *StartDiscoveryInput) (*StartDiscoveryOutput, error) {
	req, out := c.StartDiscoveryRequest(input)
	return out, req.Send()
}

// StartDiscoveryWithContext is the same as StartDiscovery with the addition of
// the ability to pass a context and additional request options.
//
// See StartDiscovery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) StartDiscoveryWithContext(ctx aws.Context, input *StartDiscoveryInput, opts ...request.Option) (*StartDiscoveryOutput, error) {
	req, out := c.StartDiscoveryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/TagResource
func (c *ApplicationSignals) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tag-resource",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon CloudWatch Application Signals.
//
// Assigns one or more tags (key-value pairs) to the specified CloudWatch resource,
// such as a service level objective.
//
// Tags can help you organize and categorize your resources. You can also use
// them to scope user permissions by granting a user permission to access or
// change only resources with certain tag values.
//
// Tags don't have any semantic meaning to Amazon Web Services and are interpreted
// strictly as strings of characters.
//
// You can use the TagResource action with an alarm that already has tags. If
// you specify a new tag key for the alarm, this tag is appended to the list
// of tags associated with the alarm. If you specify a tag key that is already
// associated with the alarm, the new tag value that you specify replaces the
// previous value for that tag.
//
// You can associate as many as 50 tags with a CloudWatch resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Signals's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Resource not found.
//
//   - ThrottlingException
//     The request was throttled because of quota limits.
//
//   - ServiceQuotaExceededException
//     This request exceeds a service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/TagResource
func (c *ApplicationSignals) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/UntagResource
func (c *ApplicationSignals) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/untag-resource",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon CloudWatch Application Signals.
//
// Removes one or more tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Signals's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Resource not found.
//
//   - ThrottlingException
//     The request was throttled because of quota limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/UntagResource
func (c *ApplicationSignals) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServiceLevelObjective = "UpdateServiceLevelObjective"

// UpdateServiceLevelObjectiveRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServiceLevelObjective operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServiceLevelObjective for more information on using the UpdateServiceLevelObjective
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServiceLevelObjectiveRequest method.
//	req, resp := client.UpdateServiceLevelObjectiveRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/UpdateServiceLevelObjective
func (c *ApplicationSignals) UpdateServiceLevelObjectiveRequest(input *UpdateServiceLevelObjectiveInput) (req *request.Request, output *UpdateServiceLevelObjectiveOutput) {
	op := &request.Operation{
		Name:       opUpdateServiceLevelObjective,
		HTTPMethod: "PATCH",
		HTTPPath:   "/slo/{Id}",
	}

	if input == nil {
		input = &UpdateServiceLevelObjectiveInput{}
	}

	output = &UpdateServiceLevelObjectiveOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateServiceLevelObjective API operation for Amazon CloudWatch Application Signals.
//
// Updates an existing service level objective (SLO). If you omit parameters,
// the previous values of those parameters are retained.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Signals's
// API operation UpdateServiceLevelObjective for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The resource is not valid.
//
//   - ResourceNotFoundException
//     Resource not found.
//
//   - ThrottlingException
//     The request was throttled because of quota limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/UpdateServiceLevelObjective
func (c *ApplicationSignals) UpdateServiceLevelObjective(input *UpdateServiceLevelObjectiveInput) (*UpdateServiceLevelObjectiveOutput, error) {
	req, out := c.UpdateServiceLevelObjectiveRequest(input)
	return out, req.Send()
}

// UpdateServiceLevelObjectiveWithContext is the same as UpdateServiceLevelObjective with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServiceLevelObjective for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationSignals) UpdateServiceLevelObjectiveWithContext(ctx aws.Context, input *UpdateServiceLevelObjectiveInput, opts ...request.Option) (*UpdateServiceLevelObjectiveOutput, error) {
	req, out := c.UpdateServiceLevelObjectiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have sufficient permissions to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type BatchGetServiceLevelObjectiveBudgetReportInput struct {
	_ struct{} `type:"structure"`

	// An array containing the IDs of the service level objectives that you want
	// to include in the report.
	//
	// SloIds is a required field
	SloIds []*string `min:"1" type:"list" required:"true"`

	// The date and time that you want the report to be for. It is expressed as
	// the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetServiceLevelObjectiveBudgetReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetServiceLevelObjectiveBudgetReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetServiceLevelObjectiveBudgetReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetServiceLevelObjectiveBudgetReportInput"}
	if s.SloIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SloIds"))
	}
	if s.SloIds != nil && len(s.SloIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SloIds", 1))
	}
	if s.Timestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("Timestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSloIds sets the SloIds field's value.
func (s *BatchGetServiceLevelObjectiveBudgetReportInput) SetSloIds(v []*string) *BatchGetServiceLevelObjectiveBudgetReportInput {
	s.SloIds = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *BatchGetServiceLevelObjectiveBudgetReportInput) SetTimestamp(v time.Time) *BatchGetServiceLevelObjectiveBudgetReportInput {
	s.Timestamp = &v
	return s
}

type BatchGetServiceLevelObjectiveBudgetReportOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures, where each structure includes an error indicating
	// that one of the requests in the array was not valid.
	//
	// Errors is a required field
	Errors []*ServiceLevelObjectiveBudgetReportError `type:"list" required:"true"`

	// An array of structures, where each structure is one budget report.
	//
	// Reports is a required field
	Reports []*ServiceLevelObjectiveBudgetReport `type:"list" required:"true"`

	// The date and time that the report is for. It is expressed as the number of
	// milliseconds since Jan 1, 1970 00:00:00 UTC.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetServiceLevelObjectiveBudgetReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetServiceLevelObjectiveBudgetReportOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchGetServiceLevelObjectiveBudgetReportOutput) SetErrors(v []*ServiceLevelObjectiveBudgetReportError) *BatchGetServiceLevelObjectiveBudgetReportOutput {
	s.Errors = v
	return s
}

// SetReports sets the Reports field's value.
func (s *BatchGetServiceLevelObjectiveBudgetReportOutput) SetReports(v []*ServiceLevelObjectiveBudgetReport) *BatchGetServiceLevelObjectiveBudgetReportOutput {
	s.Reports = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *BatchGetServiceLevelObjectiveBudgetReportOutput) SetTimestamp(v time.Time) *BatchGetServiceLevelObjectiveBudgetReportOutput {
	s.Timestamp = &v
	return s
}

// If the interval for this service level objective is a calendar interval,
// this structure contains the interval specifications.
type CalendarInterval struct {
	_ struct{} `type:"structure"`

	// Specifies the duration of each calendar interval. For example, if Duration
	// is 1 and DurationUnit is MONTH, each interval is one month, aligned with
	// the calendar.
	//
	// Duration is a required field
	Duration *int64 `min:"1" type:"integer" required:"true"`

	// Specifies the calendar interval unit.
	//
	// DurationUnit is a required field
	DurationUnit *string `type:"string" required:"true" enum:"DurationUnit"`

	// The date and time when you want the first interval to start. Be sure to choose
	// a time that configures the intervals the way that you want. For example,
	// if you want weekly intervals starting on Mondays at 6 a.m., be sure to specify
	// a start time that is a Monday at 6 a.m.
	//
	// When used in a raw HTTP Query API, it is formatted as be epoch time in seconds.
	// For example: 1698778057
	//
	// As soon as one calendar interval ends, another automatically begins.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalendarInterval) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalendarInterval) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CalendarInterval) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CalendarInterval"}
	if s.Duration == nil {
		invalidParams.Add(request.NewErrParamRequired("Duration"))
	}
	if s.Duration != nil && *s.Duration < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Duration", 1))
	}
	if s.DurationUnit == nil {
		invalidParams.Add(request.NewErrParamRequired("DurationUnit"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDuration sets the Duration field's value.
func (s *CalendarInterval) SetDuration(v int64) *CalendarInterval {
	s.Duration = &v
	return s
}

// SetDurationUnit sets the DurationUnit field's value.
func (s *CalendarInterval) SetDurationUnit(v string) *CalendarInterval {
	s.DurationUnit = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CalendarInterval) SetStartTime(v time.Time) *CalendarInterval {
	s.StartTime = &v
	return s
}

// This operation attempted to create a resource that already exists.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateServiceLevelObjectiveInput struct {
	_ struct{} `type:"structure"`

	// An optional description for this SLO.
	Description *string `min:"1" type:"string"`

	// A structure that contains the attributes that determine the goal of the SLO.
	// This includes the time period for evaluation and the attainment threshold.
	Goal *Goal `type:"structure"`

	// A name for this SLO.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A structure that contains information about what service and what performance
	// metric that this SLO will monitor.
	//
	// SliConfig is a required field
	SliConfig *ServiceLevelIndicatorConfig `type:"structure" required:"true"`

	// A list of key-value pairs to associate with the SLO. You can associate as
	// many as 50 tags with an SLO. To be able to associate tags with the SLO when
	// you create the SLO, you must have the cloudwatch:TagResource permission.
	//
	// Tags can help you organize and categorize your resources. You can also use
	// them to scope user permissions by granting a user permission to access or
	// change only resources with certain tag values.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceLevelObjectiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceLevelObjectiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceLevelObjectiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceLevelObjectiveInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SliConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("SliConfig"))
	}
	if s.Goal != nil {
		if err := s.Goal.Validate(); err != nil {
			invalidParams.AddNested("Goal", err.(request.ErrInvalidParams))
		}
	}
	if s.SliConfig != nil {
		if err := s.SliConfig.Validate(); err != nil {
			invalidParams.AddNested("SliConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateServiceLevelObjectiveInput) SetDescription(v string) *CreateServiceLevelObjectiveInput {
	s.Description = &v
	return s
}

// SetGoal sets the Goal field's value.
func (s *CreateServiceLevelObjectiveInput) SetGoal(v *Goal) *CreateServiceLevelObjectiveInput {
	s.Goal = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateServiceLevelObjectiveInput) SetName(v string) *CreateServiceLevelObjectiveInput {
	s.Name = &v
	return s
}

// SetSliConfig sets the SliConfig field's value.
func (s *CreateServiceLevelObjectiveInput) SetSliConfig(v *ServiceLevelIndicatorConfig) *CreateServiceLevelObjectiveInput {
	s.SliConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServiceLevelObjectiveInput) SetTags(v []*Tag) *CreateServiceLevelObjectiveInput {
	s.Tags = v
	return s
}

type CreateServiceLevelObjectiveOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about the SLO that you just created.
	//
	// Slo is a required field
	Slo *ServiceLevelObjective `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceLevelObjectiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceLevelObjectiveOutput) GoString() string {
	return s.String()
}

// SetSlo sets the Slo field's value.
func (s *CreateServiceLevelObjectiveOutput) SetSlo(v *ServiceLevelObjective) *CreateServiceLevelObjectiveOutput {
	s.Slo = v
	return s
}

type DeleteServiceLevelObjectiveInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN or name of the service level objective to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceLevelObjectiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceLevelObjectiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceLevelObjectiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceLevelObjectiveInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteServiceLevelObjectiveInput) SetId(v string) *DeleteServiceLevelObjectiveInput {
	s.Id = &v
	return s
}

type DeleteServiceLevelObjectiveOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceLevelObjectiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceLevelObjectiveOutput) GoString() string {
	return s.String()
}

// A dimension is a name/value pair that is part of the identity of a metric.
// Because dimensions are part of the unique identifier for a metric, whenever
// you add a unique name/value pair to one of your metrics, you are creating
// a new variation of that metric. For example, many Amazon EC2 metrics publish
// InstanceId as a dimension name, and the actual instance ID as the value for
// that dimension.
//
// You can assign up to 30 dimensions to a metric.
type Dimension struct {
	_ struct{} `type:"structure"`

	// The name of the dimension. Dimension names must contain only ASCII characters,
	// must include at least one non-whitespace character, and cannot start with
	// a colon (:). ASCII control characters are not supported as part of dimension
	// names.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value of the dimension. Dimension values must contain only ASCII characters
	// and must include at least one non-whitespace character. ASCII control characters
	// are not supported as part of dimension values.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Dimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Dimension"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Dimension) SetName(v string) *Dimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Dimension) SetValue(v string) *Dimension {
	s.Value = &v
	return s
}

type GetServiceInput struct {
	_ struct{} `type:"structure"`

	// The end of the time period to retrieve information about. When used in a
	// raw HTTP Query API, it is formatted as be epoch time in seconds. For example:
	// 1698778057
	//
	// Your requested start time will be rounded to the nearest hour.
	//
	// EndTime is a required field
	EndTime *time.Time `location:"querystring" locationName:"EndTime" type:"timestamp" required:"true"`

	// Use this field to specify which service you want to retrieve information
	// for. You must specify at least the Type, Name, and Environment attributes.
	//
	// This is a string-to-string map. It can include the following fields.
	//
	//    * Type designates the type of object this is.
	//
	//    * ResourceType specifies the type of the resource. This field is used
	//    only when the value of the Type field is Resource or AWS::Resource.
	//
	//    * Name specifies the name of the object. This is used only if the value
	//    of the Type field is Service, RemoteService, or AWS::Service.
	//
	//    * Identifier identifies the resource objects of this resource. This is
	//    used only if the value of the Type field is Resource or AWS::Resource.
	//
	//    * Environment specifies the location where this object is hosted, or what
	//    it belongs to.
	//
	// KeyAttributes is a required field
	KeyAttributes map[string]*string `min:"1" type:"map" required:"true"`

	// The start of the time period to retrieve information about. When used in
	// a raw HTTP Query API, it is formatted as be epoch time in seconds. For example:
	// 1698778057
	//
	// Your requested start time will be rounded to the nearest hour.
	//
	// StartTime is a required field
	StartTime *time.Time `location:"querystring" locationName:"StartTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.KeyAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyAttributes"))
	}
	if s.KeyAttributes != nil && len(s.KeyAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyAttributes", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetServiceInput) SetEndTime(v time.Time) *GetServiceInput {
	s.EndTime = &v
	return s
}

// SetKeyAttributes sets the KeyAttributes field's value.
func (s *GetServiceInput) SetKeyAttributes(v map[string]*string) *GetServiceInput {
	s.KeyAttributes = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetServiceInput) SetStartTime(v time.Time) *GetServiceInput {
	s.StartTime = &v
	return s
}

type GetServiceLevelObjectiveInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN or name of the SLO that you want to retrieve information about. You
	// can find the ARNs of SLOs by using the ListServiceLevelObjectives (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListServiceLevelObjectives.html)
	// operation.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceLevelObjectiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceLevelObjectiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceLevelObjectiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceLevelObjectiveInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetServiceLevelObjectiveInput) SetId(v string) *GetServiceLevelObjectiveInput {
	s.Id = &v
	return s
}

type GetServiceLevelObjectiveOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing the information about the SLO.
	//
	// Slo is a required field
	Slo *ServiceLevelObjective `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceLevelObjectiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceLevelObjectiveOutput) GoString() string {
	return s.String()
}

// SetSlo sets the Slo field's value.
func (s *GetServiceLevelObjectiveOutput) SetSlo(v *ServiceLevelObjective) *GetServiceLevelObjectiveOutput {
	s.Slo = v
	return s
}

type GetServiceOutput struct {
	_ struct{} `type:"structure"`

	// The end time of the data included in the response. In a raw HTTP Query API,
	// it is formatted as be epoch time in seconds. For example: 1698778057.
	//
	// This displays the time that Application Signals used for the request. It
	// might not match your request exactly, because it was rounded to the nearest
	// hour.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// An array of string-to-string maps that each contain information about one
	// log group associated with this service. Each string-to-string map includes
	// the following fields:
	//
	//    * "Type": "AWS::Resource"
	//
	//    * "ResourceType": "AWS::Logs::LogGroup"
	//
	//    * "Identifier": "name-of-log-group"
	LogGroupReferences []map[string]*string `type:"list"`

	// A structure containing information about the service.
	//
	// Service is a required field
	Service *Service `type:"structure" required:"true"`

	// The start time of the data included in the response. In a raw HTTP Query
	// API, it is formatted as be epoch time in seconds. For example: 1698778057.
	//
	// This displays the time that Application Signals used for the request. It
	// might not match your request exactly, because it was rounded to the nearest
	// hour.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *GetServiceOutput) SetEndTime(v time.Time) *GetServiceOutput {
	s.EndTime = &v
	return s
}

// SetLogGroupReferences sets the LogGroupReferences field's value.
func (s *GetServiceOutput) SetLogGroupReferences(v []map[string]*string) *GetServiceOutput {
	s.LogGroupReferences = v
	return s
}

// SetService sets the Service field's value.
func (s *GetServiceOutput) SetService(v *Service) *GetServiceOutput {
	s.Service = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetServiceOutput) SetStartTime(v time.Time) *GetServiceOutput {
	s.StartTime = &v
	return s
}

// This structure contains the attributes that determine the goal of an SLO.
// This includes the time period for evaluation and the attainment threshold.
type Goal struct {
	_ struct{} `type:"structure"`

	// The threshold that determines if the goal is being met. An attainment goal
	// is the ratio of good periods that meet the threshold requirements to the
	// total periods within the interval. For example, an attainment goal of 99.9%
	// means that within your interval, you are targeting 99.9% of the periods to
	// be in healthy state.
	//
	// If you omit this parameter, 99 is used to represent 99% as the attainment
	// goal.
	AttainmentGoal *float64 `type:"double"`

	// The time period used to evaluate the SLO. It can be either a calendar interval
	// or rolling interval.
	//
	// If you omit this parameter, a rolling interval of 7 days is used.
	Interval *Interval `type:"structure"`

	// The percentage of remaining budget over total budget that you want to get
	// warnings for. If you omit this parameter, the default of 50.0 is used.
	WarningThreshold *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Goal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Goal) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Goal) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Goal"}
	if s.Interval != nil {
		if err := s.Interval.Validate(); err != nil {
			invalidParams.AddNested("Interval", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttainmentGoal sets the AttainmentGoal field's value.
func (s *Goal) SetAttainmentGoal(v float64) *Goal {
	s.AttainmentGoal = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *Goal) SetInterval(v *Interval) *Goal {
	s.Interval = v
	return s
}

// SetWarningThreshold sets the WarningThreshold field's value.
func (s *Goal) SetWarningThreshold(v float64) *Goal {
	s.WarningThreshold = &v
	return s
}

// The time period used to evaluate the SLO. It can be either a calendar interval
// or rolling interval.
type Interval struct {
	_ struct{} `type:"structure"`

	// If the interval is a calendar interval, this structure contains the interval
	// specifications.
	CalendarInterval *CalendarInterval `type:"structure"`

	// If the interval is a rolling interval, this structure contains the interval
	// specifications.
	RollingInterval *RollingInterval `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Interval) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Interval) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Interval) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Interval"}
	if s.CalendarInterval != nil {
		if err := s.CalendarInterval.Validate(); err != nil {
			invalidParams.AddNested("CalendarInterval", err.(request.ErrInvalidParams))
		}
	}
	if s.RollingInterval != nil {
		if err := s.RollingInterval.Validate(); err != nil {
			invalidParams.AddNested("RollingInterval", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCalendarInterval sets the CalendarInterval field's value.
func (s *Interval) SetCalendarInterval(v *CalendarInterval) *Interval {
	s.CalendarInterval = v
	return s
}

// SetRollingInterval sets the RollingInterval field's value.
func (s *Interval) SetRollingInterval(v *RollingInterval) *Interval {
	s.RollingInterval = v
	return s
}

type ListServiceDependenciesInput struct {
	_ struct{} `type:"structure"`

	// The end of the time period to retrieve information about. When used in a
	// raw HTTP Query API, it is formatted as be epoch time in seconds. For example:
	// 1698778057
	//
	// Your requested end time will be rounded to the nearest hour.
	//
	// EndTime is a required field
	EndTime *time.Time `location:"querystring" locationName:"EndTime" type:"timestamp" required:"true"`

	// Use this field to specify which service you want to retrieve information
	// for. You must specify at least the Type, Name, and Environment attributes.
	//
	// This is a string-to-string map. It can include the following fields.
	//
	//    * Type designates the type of object this is.
	//
	//    * ResourceType specifies the type of the resource. This field is used
	//    only when the value of the Type field is Resource or AWS::Resource.
	//
	//    * Name specifies the name of the object. This is used only if the value
	//    of the Type field is Service, RemoteService, or AWS::Service.
	//
	//    * Identifier identifies the resource objects of this resource. This is
	//    used only if the value of the Type field is Resource or AWS::Resource.
	//
	//    * Environment specifies the location where this object is hosted, or what
	//    it belongs to.
	//
	// KeyAttributes is a required field
	KeyAttributes map[string]*string `min:"1" type:"map" required:"true"`

	// The maximum number of results to return in one operation. If you omit this
	// parameter, the default of 50 is used.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Include this value, if it was returned by the previous operation, to get
	// the next set of service dependencies.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The start of the time period to retrieve information about. When used in
	// a raw HTTP Query API, it is formatted as be epoch time in seconds. For example:
	// 1698778057
	//
	// Your requested start time will be rounded to the nearest hour.
	//
	// StartTime is a required field
	StartTime *time.Time `location:"querystring" locationName:"StartTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceDependenciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceDependenciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceDependenciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceDependenciesInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.KeyAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyAttributes"))
	}
	if s.KeyAttributes != nil && len(s.KeyAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyAttributes", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListServiceDependenciesInput) SetEndTime(v time.Time) *ListServiceDependenciesInput {
	s.EndTime = &v
	return s
}

// SetKeyAttributes sets the KeyAttributes field's value.
func (s *ListServiceDependenciesInput) SetKeyAttributes(v map[string]*string) *ListServiceDependenciesInput {
	s.KeyAttributes = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServiceDependenciesInput) SetMaxResults(v int64) *ListServiceDependenciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceDependenciesInput) SetNextToken(v string) *ListServiceDependenciesInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListServiceDependenciesInput) SetStartTime(v time.Time) *ListServiceDependenciesInput {
	s.StartTime = &v
	return s
}

type ListServiceDependenciesOutput struct {
	_ struct{} `type:"structure"`

	// The end of the time period that the returned information applies to. When
	// used in a raw HTTP Query API, it is formatted as be epoch time in seconds.
	// For example: 1698778057
	//
	// This displays the time that Application Signals used for the request. It
	// might not match your request exactly, because it was rounded to the nearest
	// hour.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// Include this value in your next use of this API to get next set of service
	// dependencies.
	NextToken *string `type:"string"`

	// An array, where each object in the array contains information about one of
	// the dependencies of this service.
	//
	// ServiceDependencies is a required field
	ServiceDependencies []*ServiceDependency `type:"list" required:"true"`

	// The start of the time period that the returned information applies to. When
	// used in a raw HTTP Query API, it is formatted as be epoch time in seconds.
	// For example: 1698778057
	//
	// This displays the time that Application Signals used for the request. It
	// might not match your request exactly, because it was rounded to the nearest
	// hour.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceDependenciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceDependenciesOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *ListServiceDependenciesOutput) SetEndTime(v time.Time) *ListServiceDependenciesOutput {
	s.EndTime = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceDependenciesOutput) SetNextToken(v string) *ListServiceDependenciesOutput {
	s.NextToken = &v
	return s
}

// SetServiceDependencies sets the ServiceDependencies field's value.
func (s *ListServiceDependenciesOutput) SetServiceDependencies(v []*ServiceDependency) *ListServiceDependenciesOutput {
	s.ServiceDependencies = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListServiceDependenciesOutput) SetStartTime(v time.Time) *ListServiceDependenciesOutput {
	s.StartTime = &v
	return s
}

type ListServiceDependentsInput struct {
	_ struct{} `type:"structure"`

	// The end of the time period to retrieve information about. When used in a
	// raw HTTP Query API, it is formatted as be epoch time in seconds. For example:
	// 1698778057
	//
	// Your requested start time will be rounded to the nearest hour.
	//
	// EndTime is a required field
	EndTime *time.Time `location:"querystring" locationName:"EndTime" type:"timestamp" required:"true"`

	// Use this field to specify which service you want to retrieve information
	// for. You must specify at least the Type, Name, and Environment attributes.
	//
	// This is a string-to-string map. It can include the following fields.
	//
	//    * Type designates the type of object this is.
	//
	//    * ResourceType specifies the type of the resource. This field is used
	//    only when the value of the Type field is Resource or AWS::Resource.
	//
	//    * Name specifies the name of the object. This is used only if the value
	//    of the Type field is Service, RemoteService, or AWS::Service.
	//
	//    * Identifier identifies the resource objects of this resource. This is
	//    used only if the value of the Type field is Resource or AWS::Resource.
	//
	//    * Environment specifies the location where this object is hosted, or what
	//    it belongs to.
	//
	// KeyAttributes is a required field
	KeyAttributes map[string]*string `min:"1" type:"map" required:"true"`

	// The maximum number of results to return in one operation. If you omit this
	// parameter, the default of 50 is used.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Include this value, if it was returned by the previous operation, to get
	// the next set of service dependents.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The start of the time period to retrieve information about. When used in
	// a raw HTTP Query API, it is formatted as be epoch time in seconds. For example:
	// 1698778057
	//
	// Your requested start time will be rounded to the nearest hour.
	//
	// StartTime is a required field
	StartTime *time.Time `location:"querystring" locationName:"StartTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceDependentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceDependentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceDependentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceDependentsInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.KeyAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyAttributes"))
	}
	if s.KeyAttributes != nil && len(s.KeyAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyAttributes", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListServiceDependentsInput) SetEndTime(v time.Time) *ListServiceDependentsInput {
	s.EndTime = &v
	return s
}

// SetKeyAttributes sets the KeyAttributes field's value.
func (s *ListServiceDependentsInput) SetKeyAttributes(v map[string]*string) *ListServiceDependentsInput {
	s.KeyAttributes = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServiceDependentsInput) SetMaxResults(v int64) *ListServiceDependentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceDependentsInput) SetNextToken(v string) *ListServiceDependentsInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListServiceDependentsInput) SetStartTime(v time.Time) *ListServiceDependentsInput {
	s.StartTime = &v
	return s
}

type ListServiceDependentsOutput struct {
	_ struct{} `type:"structure"`

	// The end of the time period that the returned information applies to. When
	// used in a raw HTTP Query API, it is formatted as be epoch time in seconds.
	// For example: 1698778057
	//
	// This displays the time that Application Signals used for the request. It
	// might not match your request exactly, because it was rounded to the nearest
	// hour.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// Include this value in your next use of this API to get next set of service
	// dependents.
	NextToken *string `type:"string"`

	// An array, where each object in the array contains information about one of
	// the dependents of this service.
	//
	// ServiceDependents is a required field
	ServiceDependents []*ServiceDependent `type:"list" required:"true"`

	// The start of the time period that the returned information applies to. When
	// used in a raw HTTP Query API, it is formatted as be epoch time in seconds.
	// For example: 1698778057
	//
	// This displays the time that Application Signals used for the request. It
	// might not match your request exactly, because it was rounded to the nearest
	// hour.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceDependentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceDependentsOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *ListServiceDependentsOutput) SetEndTime(v time.Time) *ListServiceDependentsOutput {
	s.EndTime = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceDependentsOutput) SetNextToken(v string) *ListServiceDependentsOutput {
	s.NextToken = &v
	return s
}

// SetServiceDependents sets the ServiceDependents field's value.
func (s *ListServiceDependentsOutput) SetServiceDependents(v []*ServiceDependent) *ListServiceDependentsOutput {
	s.ServiceDependents = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListServiceDependentsOutput) SetStartTime(v time.Time) *ListServiceDependentsOutput {
	s.StartTime = &v
	return s
}

type ListServiceLevelObjectivesInput struct {
	_ struct{} `type:"structure"`

	// You can use this optional field to specify which services you want to retrieve
	// SLO information for.
	//
	// This is a string-to-string map. It can include the following fields.
	//
	//    * Type designates the type of object this is.
	//
	//    * ResourceType specifies the type of the resource. This field is used
	//    only when the value of the Type field is Resource or AWS::Resource.
	//
	//    * Name specifies the name of the object. This is used only if the value
	//    of the Type field is Service, RemoteService, or AWS::Service.
	//
	//    * Identifier identifies the resource objects of this resource. This is
	//    used only if the value of the Type field is Resource or AWS::Resource.
	//
	//    * Environment specifies the location where this object is hosted, or what
	//    it belongs to.
	KeyAttributes map[string]*string `min:"1" type:"map"`

	// The maximum number of results to return in one operation. If you omit this
	// parameter, the default of 50 is used.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Include this value, if it was returned by the previous operation, to get
	// the next set of service level objectives.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The name of the operation that this SLO is associated with.
	OperationName *string `location:"querystring" locationName:"OperationName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceLevelObjectivesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceLevelObjectivesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceLevelObjectivesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceLevelObjectivesInput"}
	if s.KeyAttributes != nil && len(s.KeyAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyAttributes", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.OperationName != nil && len(*s.OperationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyAttributes sets the KeyAttributes field's value.
func (s *ListServiceLevelObjectivesInput) SetKeyAttributes(v map[string]*string) *ListServiceLevelObjectivesInput {
	s.KeyAttributes = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServiceLevelObjectivesInput) SetMaxResults(v int64) *ListServiceLevelObjectivesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceLevelObjectivesInput) SetNextToken(v string) *ListServiceLevelObjectivesInput {
	s.NextToken = &v
	return s
}

// SetOperationName sets the OperationName field's value.
func (s *ListServiceLevelObjectivesInput) SetOperationName(v string) *ListServiceLevelObjectivesInput {
	s.OperationName = &v
	return s
}

type ListServiceLevelObjectivesOutput struct {
	_ struct{} `type:"structure"`

	// Include this value in your next use of this API to get next set of service
	// level objectives.
	NextToken *string `type:"string"`

	// An array of structures, where each structure contains information about one
	// SLO.
	SloSummaries []*ServiceLevelObjectiveSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceLevelObjectivesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceLevelObjectivesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceLevelObjectivesOutput) SetNextToken(v string) *ListServiceLevelObjectivesOutput {
	s.NextToken = &v
	return s
}

// SetSloSummaries sets the SloSummaries field's value.
func (s *ListServiceLevelObjectivesOutput) SetSloSummaries(v []*ServiceLevelObjectiveSummary) *ListServiceLevelObjectivesOutput {
	s.SloSummaries = v
	return s
}

type ListServiceOperationsInput struct {
	_ struct{} `type:"structure"`

	// The end of the time period to retrieve information about. When used in a
	// raw HTTP Query API, it is formatted as be epoch time in seconds. For example:
	// 1698778057
	//
	// Your requested end time will be rounded to the nearest hour.
	//
	// EndTime is a required field
	EndTime *time.Time `location:"querystring" locationName:"EndTime" type:"timestamp" required:"true"`

	// Use this field to specify which service you want to retrieve information
	// for. You must specify at least the Type, Name, and Environment attributes.
	//
	// This is a string-to-string map. It can include the following fields.
	//
	//    * Type designates the type of object this is.
	//
	//    * ResourceType specifies the type of the resource. This field is used
	//    only when the value of the Type field is Resource or AWS::Resource.
	//
	//    * Name specifies the name of the object. This is used only if the value
	//    of the Type field is Service, RemoteService, or AWS::Service.
	//
	//    * Identifier identifies the resource objects of this resource. This is
	//    used only if the value of the Type field is Resource or AWS::Resource.
	//
	//    * Environment specifies the location where this object is hosted, or what
	//    it belongs to.
	//
	// KeyAttributes is a required field
	KeyAttributes map[string]*string `min:"1" type:"map" required:"true"`

	// The maximum number of results to return in one operation. If you omit this
	// parameter, the default of 50 is used.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Include this value, if it was returned by the previous operation, to get
	// the next set of service operations.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The start of the time period to retrieve information about. When used in
	// a raw HTTP Query API, it is formatted as be epoch time in seconds. For example:
	// 1698778057
	//
	// Your requested start time will be rounded to the nearest hour.
	//
	// StartTime is a required field
	StartTime *time.Time `location:"querystring" locationName:"StartTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceOperationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceOperationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceOperationsInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.KeyAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyAttributes"))
	}
	if s.KeyAttributes != nil && len(s.KeyAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyAttributes", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListServiceOperationsInput) SetEndTime(v time.Time) *ListServiceOperationsInput {
	s.EndTime = &v
	return s
}

// SetKeyAttributes sets the KeyAttributes field's value.
func (s *ListServiceOperationsInput) SetKeyAttributes(v map[string]*string) *ListServiceOperationsInput {
	s.KeyAttributes = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServiceOperationsInput) SetMaxResults(v int64) *ListServiceOperationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceOperationsInput) SetNextToken(v string) *ListServiceOperationsInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListServiceOperationsInput) SetStartTime(v time.Time) *ListServiceOperationsInput {
	s.StartTime = &v
	return s
}

type ListServiceOperationsOutput struct {
	_ struct{} `type:"structure"`

	// The end of the time period that the returned information applies to. When
	// used in a raw HTTP Query API, it is formatted as be epoch time in seconds.
	// For example: 1698778057
	//
	// This displays the time that Application Signals used for the request. It
	// might not match your request exactly, because it was rounded to the nearest
	// hour.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// Include this value in your next use of this API to get next set of service
	// operations.
	NextToken *string `type:"string"`

	// An array of structures that each contain information about one operation
	// of this service.
	//
	// ServiceOperations is a required field
	ServiceOperations []*ServiceOperation `type:"list" required:"true"`

	// The start of the time period that the returned information applies to. When
	// used in a raw HTTP Query API, it is formatted as be epoch time in seconds.
	// For example: 1698778057
	//
	// This displays the time that Application Signals used for the request. It
	// might not match your request exactly, because it was rounded to the nearest
	// hour.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceOperationsOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *ListServiceOperationsOutput) SetEndTime(v time.Time) *ListServiceOperationsOutput {
	s.EndTime = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceOperationsOutput) SetNextToken(v string) *ListServiceOperationsOutput {
	s.NextToken = &v
	return s
}

// SetServiceOperations sets the ServiceOperations field's value.
func (s *ListServiceOperationsOutput) SetServiceOperations(v []*ServiceOperation) *ListServiceOperationsOutput {
	s.ServiceOperations = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListServiceOperationsOutput) SetStartTime(v time.Time) *ListServiceOperationsOutput {
	s.StartTime = &v
	return s
}

type ListServicesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The end of the time period to retrieve information about. When used in a
	// raw HTTP Query API, it is formatted as be epoch time in seconds. For example:
	// 1698778057
	//
	// Your requested start time will be rounded to the nearest hour.
	//
	// EndTime is a required field
	EndTime *time.Time `location:"querystring" locationName:"EndTime" type:"timestamp" required:"true"`

	// The maximum number of results to return in one operation. If you omit this
	// parameter, the default of 50 is used.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Include this value, if it was returned by the previous operation, to get
	// the next set of services.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The start of the time period to retrieve information about. When used in
	// a raw HTTP Query API, it is formatted as be epoch time in seconds. For example:
	// 1698778057
	//
	// Your requested start time will be rounded to the nearest hour.
	//
	// StartTime is a required field
	StartTime *time.Time `location:"querystring" locationName:"StartTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServicesInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListServicesInput) SetEndTime(v time.Time) *ListServicesInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServicesInput) SetMaxResults(v int64) *ListServicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesInput) SetNextToken(v string) *ListServicesInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListServicesInput) SetStartTime(v time.Time) *ListServicesInput {
	s.StartTime = &v
	return s
}

type ListServicesOutput struct {
	_ struct{} `type:"structure"`

	// The end of the time period that the returned information applies to. When
	// used in a raw HTTP Query API, it is formatted as be epoch time in seconds.
	// For example: 1698778057
	//
	// This displays the time that Application Signals used for the request. It
	// might not match your request exactly, because it was rounded to the nearest
	// hour.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// Include this value in your next use of this API to get next set of services.
	NextToken *string `type:"string"`

	// An array of structures, where each structure contains some information about
	// a service. To get complete information about a service, use GetService (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetService.html).
	//
	// ServiceSummaries is a required field
	ServiceSummaries []*ServiceSummary `type:"list" required:"true"`

	// The start of the time period that the returned information applies to. When
	// used in a raw HTTP Query API, it is formatted as be epoch time in seconds.
	// For example: 1698778057
	//
	// This displays the time that Application Signals used for the request. It
	// might not match your request exactly, because it was rounded to the nearest
	// hour.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *ListServicesOutput) SetEndTime(v time.Time) *ListServicesOutput {
	s.EndTime = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesOutput) SetNextToken(v string) *ListServicesOutput {
	s.NextToken = &v
	return s
}

// SetServiceSummaries sets the ServiceSummaries field's value.
func (s *ListServicesOutput) SetServiceSummaries(v []*ServiceSummary) *ListServicesOutput {
	s.ServiceSummaries = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListServicesOutput) SetStartTime(v time.Time) *ListServicesOutput {
	s.StartTime = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the CloudWatch resource that you want to
	// view tags for.
	//
	// The ARN format of an Application Signals SLO is arn:aws:cloudwatch:Region:account-id:slo:slo-name
	//
	// For more information about ARN format, see Resource Types Defined by Amazon
	// CloudWatch (https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies)
	// in the Amazon Web Services General Reference.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"ResourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tag keys and values associated with the resource you specified.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// This structure defines the metric used for a service level indicator, including
// the metric name, namespace, and dimensions
type Metric struct {
	_ struct{} `type:"structure"`

	// An array of one or more dimensions to use to define the metric that you want
	// to use. For more information, see Dimensions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension).
	Dimensions []*Dimension `type:"list"`

	// The name of the metric to use.
	MetricName *string `min:"1" type:"string"`

	// The namespace of the metric. For more information, see Namespaces (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace).
	Namespace *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Metric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Metric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Metric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Metric"}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *Metric) SetDimensions(v []*Dimension) *Metric {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *Metric) SetMetricName(v string) *Metric {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *Metric) SetNamespace(v string) *Metric {
	s.Namespace = &v
	return s
}

// Use this structure to define a metric or metric math expression that you
// want to use as for a service level objective.
//
// Each MetricDataQuery in the MetricDataQueries array specifies either a metric
// to retrieve, or a metric math expression to be performed on retrieved metrics.
// A single MetricDataQueries array can include as many as 20 MetricDataQuery
// structures in the array. The 20 structures can include as many as 10 structures
// that contain a MetricStat parameter to retrieve a metric, and as many as
// 10 structures that contain the Expression parameter to perform a math expression.
// Of those Expression structures, exactly one must have true as the value for
// ReturnData. The result of this expression used for the SLO.
//
// For more information about metric math expressions, see CloudWatchUse metric
// math (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html).
//
// Within each MetricDataQuery object, you must specify either Expression or
// MetricStat but not both.
type MetricDataQuery struct {
	_ struct{} `type:"structure"`

	// The ID of the account where this metric is located. If you are performing
	// this operatiion in a monitoring account, use this to specify which source
	// account to retrieve this metric from.
	AccountId *string `min:"1" type:"string"`

	// This field can contain a metric math expression to be performed on the other
	// metrics that you are retrieving within this MetricDataQueries structure.
	//
	// A math expression can use the Id of the other metrics or queries to refer
	// to those metrics, and can also use the Id of other expressions to use the
	// result of those expressions. For more information about metric math expressions,
	// see Metric Math Syntax and Functions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax)
	// in the Amazon CloudWatch User Guide.
	//
	// Within each MetricDataQuery object, you must specify either Expression or
	// MetricStat but not both.
	Expression *string `min:"1" type:"string"`

	// A short name used to tie this object to the results in the response. This
	// Id must be unique within a MetricDataQueries array. If you are performing
	// math expressions on this set of data, this name represents that data and
	// can serve as a variable in the metric math expression. The valid characters
	// are letters, numbers, and underscore. The first character must be a lowercase
	// letter.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A human-readable label for this metric or expression. This is especially
	// useful if this is an expression, so that you know what the value represents.
	// If the metric or expression is shown in a CloudWatch dashboard widget, the
	// label is shown. If Label is omitted, CloudWatch generates a default.
	//
	// You can put dynamic expressions into a label, so that it is more descriptive.
	// For more information, see Using Dynamic Labels (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html).
	Label *string `type:"string"`

	// A metric to be used directly for the SLO, or to be used in the math expression
	// that will be used for the SLO.
	//
	// Within one MetricDataQuery object, you must specify either Expression or
	// MetricStat but not both.
	MetricStat *MetricStat `type:"structure"`

	// The granularity, in seconds, of the returned data points for this metric.
	// For metrics with regular resolution, a period can be as short as one minute
	// (60 seconds) and must be a multiple of 60. For high-resolution metrics that
	// are collected at intervals of less than one minute, the period can be 1,
	// 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics
	// stored by a PutMetricData call that includes a StorageResolution of 1 second.
	//
	// If the StartTime parameter specifies a time stamp that is greater than 3
	// hours ago, you must specify the period as follows or no data points in that
	// time range is returned:
	//
	//    * Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds
	//    (1 minute).
	//
	//    * Start time between 15 and 63 days ago - Use a multiple of 300 seconds
	//    (5 minutes).
	//
	//    * Start time greater than 63 days ago - Use a multiple of 3600 seconds
	//    (1 hour).
	Period *int64 `min:"1" type:"integer"`

	// Use this only if you are using a metric math expression for the SLO. Specify
	// true for ReturnData for only the one expression result to use as the alarm.
	// For all other metrics and expressions in the same CreateServiceLevelObjective
	// operation, specify ReturnData as false.
	ReturnData *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDataQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDataQuery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDataQuery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDataQuery"}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 1))
	}
	if s.MetricStat != nil {
		if err := s.MetricStat.Validate(); err != nil {
			invalidParams.AddNested("MetricStat", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *MetricDataQuery) SetAccountId(v string) *MetricDataQuery {
	s.AccountId = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *MetricDataQuery) SetExpression(v string) *MetricDataQuery {
	s.Expression = &v
	return s
}

// SetId sets the Id field's value.
func (s *MetricDataQuery) SetId(v string) *MetricDataQuery {
	s.Id = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *MetricDataQuery) SetLabel(v string) *MetricDataQuery {
	s.Label = &v
	return s
}

// SetMetricStat sets the MetricStat field's value.
func (s *MetricDataQuery) SetMetricStat(v *MetricStat) *MetricDataQuery {
	s.MetricStat = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *MetricDataQuery) SetPeriod(v int64) *MetricDataQuery {
	s.Period = &v
	return s
}

// SetReturnData sets the ReturnData field's value.
func (s *MetricDataQuery) SetReturnData(v bool) *MetricDataQuery {
	s.ReturnData = &v
	return s
}

// This structure contains information about one CloudWatch metric associated
// with this entity discovered by Application Signals.
type MetricReference struct {
	_ struct{} `type:"structure"`

	// An array of one or more dimensions that further define the metric. For more
	// information, see CloudWatchDimensions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension).
	Dimensions []*Dimension `type:"list"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// Used to display the appropriate statistics in the CloudWatch console.
	//
	// MetricType is a required field
	MetricType *string `type:"string" required:"true"`

	// The namespace of the metric. For more information, see CloudWatchNamespaces
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace).
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricReference) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *MetricReference) SetDimensions(v []*Dimension) *MetricReference {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *MetricReference) SetMetricName(v string) *MetricReference {
	s.MetricName = &v
	return s
}

// SetMetricType sets the MetricType field's value.
func (s *MetricReference) SetMetricType(v string) *MetricReference {
	s.MetricType = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *MetricReference) SetNamespace(v string) *MetricReference {
	s.Namespace = &v
	return s
}

// This structure defines the metric to be used as the service level indicator,
// along with the statistics, period, and unit.
type MetricStat struct {
	_ struct{} `type:"structure"`

	// The metric to use as the service level indicator, including the metric name,
	// namespace, and dimensions.
	//
	// Metric is a required field
	Metric *Metric `type:"structure" required:"true"`

	// The granularity, in seconds, to be used for the metric. For metrics with
	// regular resolution, a period can be as short as one minute (60 seconds) and
	// must be a multiple of 60. For high-resolution metrics that are collected
	// at intervals of less than one minute, the period can be 1, 5, 10, 30, 60,
	// or any multiple of 60. High-resolution metrics are those metrics stored by
	// a PutMetricData call that includes a StorageResolution of 1 second.
	//
	// Period is a required field
	Period *int64 `min:"1" type:"integer" required:"true"`

	// The statistic to use for comparison to the threshold. It can be any CloudWatch
	// statistic or extended statistic. For more information about statistics, see
	// CloudWatch statistics definitions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html).
	//
	// Stat is a required field
	Stat *string `type:"string" required:"true"`

	// If you omit Unit then all data that was collected with any unit is returned,
	// along with the corresponding units that were specified when the data was
	// reported to CloudWatch. If you specify a unit, the operation returns only
	// data that was collected with that unit specified. If you specify a unit that
	// does not match the data collected, the results of the operation are null.
	// CloudWatch does not perform unit conversions.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricStat) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricStat) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricStat) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricStat"}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 1))
	}
	if s.Stat == nil {
		invalidParams.Add(request.NewErrParamRequired("Stat"))
	}
	if s.Metric != nil {
		if err := s.Metric.Validate(); err != nil {
			invalidParams.AddNested("Metric", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetric sets the Metric field's value.
func (s *MetricStat) SetMetric(v *Metric) *MetricStat {
	s.Metric = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *MetricStat) SetPeriod(v int64) *MetricStat {
	s.Period = &v
	return s
}

// SetStat sets the Stat field's value.
func (s *MetricStat) SetStat(v string) *MetricStat {
	s.Stat = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricStat) SetUnit(v string) *MetricStat {
	s.Unit = &v
	return s
}

// Resource not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Can't find the resource id.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The resource type is not valid.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// If the interval for this SLO is a rolling interval, this structure contains
// the interval specifications.
type RollingInterval struct {
	_ struct{} `type:"structure"`

	// Specifies the duration of each rolling interval. For example, if Duration
	// is 7 and DurationUnit is DAY, each rolling interval is seven days.
	//
	// Duration is a required field
	Duration *int64 `min:"1" type:"integer" required:"true"`

	// Specifies the rolling interval unit.
	//
	// DurationUnit is a required field
	DurationUnit *string `type:"string" required:"true" enum:"DurationUnit"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollingInterval) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollingInterval) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollingInterval) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RollingInterval"}
	if s.Duration == nil {
		invalidParams.Add(request.NewErrParamRequired("Duration"))
	}
	if s.Duration != nil && *s.Duration < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Duration", 1))
	}
	if s.DurationUnit == nil {
		invalidParams.Add(request.NewErrParamRequired("DurationUnit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDuration sets the Duration field's value.
func (s *RollingInterval) SetDuration(v int64) *RollingInterval {
	s.Duration = &v
	return s
}

// SetDurationUnit sets the DurationUnit field's value.
func (s *RollingInterval) SetDurationUnit(v string) *RollingInterval {
	s.DurationUnit = &v
	return s
}

// This structure contains information about one of your services that was discovered
// by Application Signals.
type Service struct {
	_ struct{} `type:"structure"`

	// This structure contains one or more string-to-string maps that help identify
	// this service. It can include platform attributes, application attributes,
	// and telemetry attributes.
	//
	// Platform attributes contain information the service's platform.
	//
	//    * PlatformType defines the hosted-in platform.
	//
	//    * EKS.Cluster is the name of the Amazon EKS cluster.
	//
	//    * K8s.Cluster is the name of the self-hosted Kubernetes cluster.
	//
	//    * K8s.Namespace is the name of the Kubernetes namespace in either Amazon
	//    EKS or Kubernetes clusters.
	//
	//    * K8s.Workload is the name of the Kubernetes workload in either Amazon
	//    EKS or Kubernetes clusters.
	//
	//    * K8s.Node is the name of the Kubernetes node in either Amazon EKS or
	//    Kubernetes clusters.
	//
	//    * K8s.Pod is the name of the Kubernetes pod in either Amazon EKS or Kubernetes
	//    clusters.
	//
	//    * EC2.AutoScalingGroup is the name of the Amazon EC2 Auto Scaling group.
	//
	//    * EC2.InstanceId is the ID of the Amazon EC2 instance.
	//
	//    * Host is the name of the host, for all platform types.
	//
	// Applciation attributes contain information about the application.
	//
	//    * AWS.Application is the application's name in Amazon Web Services Service
	//    Catalog AppRegistry.
	//
	//    * AWS.Application.ARN is the application's ARN in Amazon Web Services
	//    Service Catalog AppRegistry.
	//
	// Telemetry attributes contain telemetry information.
	//
	//    * Telemetry.SDK is the fingerprint of the OpenTelemetry SDK version for
	//    instrumented services.
	//
	//    * Telemetry.Agent is the fingerprint of the agent used to collect and
	//    send telemetry data.
	//
	//    * Telemetry.Source Specifies the point of application where the telemetry
	//    was collected or specifies what was used for the source of telemetry data.
	AttributeMaps []map[string]*string `type:"list"`

	// This is a string-to-string map. It can include the following fields.
	//
	//    * Type designates the type of object this is.
	//
	//    * ResourceType specifies the type of the resource. This field is used
	//    only when the value of the Type field is Resource or AWS::Resource.
	//
	//    * Name specifies the name of the object. This is used only if the value
	//    of the Type field is Service, RemoteService, or AWS::Service.
	//
	//    * Identifier identifies the resource objects of this resource. This is
	//    used only if the value of the Type field is Resource or AWS::Resource.
	//
	//    * Environment specifies the location where this object is hosted, or what
	//    it belongs to.
	//
	// KeyAttributes is a required field
	KeyAttributes map[string]*string `min:"1" type:"map" required:"true"`

	// An array of string-to-string maps that each contain information about one
	// log group associated with this service. Each string-to-string map includes
	// the following fields:
	//
	//    * "Type": "AWS::Resource"
	//
	//    * "ResourceType": "AWS::Logs::LogGroup"
	//
	//    * "Identifier": "name-of-log-group"
	LogGroupReferences []map[string]*string `type:"list"`

	// An array of structures that each contain information about one metric associated
	// with this service.
	//
	// MetricReferences is a required field
	MetricReferences []*MetricReference `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Service) GoString() string {
	return s.String()
}

// SetAttributeMaps sets the AttributeMaps field's value.
func (s *Service) SetAttributeMaps(v []map[string]*string) *Service {
	s.AttributeMaps = v
	return s
}

// SetKeyAttributes sets the KeyAttributes field's value.
func (s *Service) SetKeyAttributes(v map[string]*string) *Service {
	s.KeyAttributes = v
	return s
}

// SetLogGroupReferences sets the LogGroupReferences field's value.
func (s *Service) SetLogGroupReferences(v []map[string]*string) *Service {
	s.LogGroupReferences = v
	return s
}

// SetMetricReferences sets the MetricReferences field's value.
func (s *Service) SetMetricReferences(v []*MetricReference) *Service {
	s.MetricReferences = v
	return s
}

// This structure contains information about one dependency of this service.
type ServiceDependency struct {
	_ struct{} `type:"structure"`

	// This is a string-to-string map. It can include the following fields.
	//
	//    * Type designates the type of object this is.
	//
	//    * ResourceType specifies the type of the resource. This field is used
	//    only when the value of the Type field is Resource or AWS::Resource.
	//
	//    * Name specifies the name of the object. This is used only if the value
	//    of the Type field is Service, RemoteService, or AWS::Service.
	//
	//    * Identifier identifies the resource objects of this resource. This is
	//    used only if the value of the Type field is Resource or AWS::Resource.
	//
	//    * Environment specifies the location where this object is hosted, or what
	//    it belongs to.
	//
	// DependencyKeyAttributes is a required field
	DependencyKeyAttributes map[string]*string `min:"1" type:"map" required:"true"`

	// The name of the called operation in the dependency.
	//
	// DependencyOperationName is a required field
	DependencyOperationName *string `min:"1" type:"string" required:"true"`

	// An array of structures that each contain information about one metric associated
	// with this service dependency that was discovered by Application Signals.
	//
	// MetricReferences is a required field
	MetricReferences []*MetricReference `type:"list" required:"true"`

	// The name of the operation in this service that calls the dependency.
	//
	// OperationName is a required field
	OperationName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceDependency) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceDependency) GoString() string {
	return s.String()
}

// SetDependencyKeyAttributes sets the DependencyKeyAttributes field's value.
func (s *ServiceDependency) SetDependencyKeyAttributes(v map[string]*string) *ServiceDependency {
	s.DependencyKeyAttributes = v
	return s
}

// SetDependencyOperationName sets the DependencyOperationName field's value.
func (s *ServiceDependency) SetDependencyOperationName(v string) *ServiceDependency {
	s.DependencyOperationName = &v
	return s
}

// SetMetricReferences sets the MetricReferences field's value.
func (s *ServiceDependency) SetMetricReferences(v []*MetricReference) *ServiceDependency {
	s.MetricReferences = v
	return s
}

// SetOperationName sets the OperationName field's value.
func (s *ServiceDependency) SetOperationName(v string) *ServiceDependency {
	s.OperationName = &v
	return s
}

// This structure contains information about a service dependent that was discovered
// by Application Signals. A dependent is an entity that invoked the specified
// service during the provided time range. Dependents include other services,
// CloudWatch Synthetics canaries, and clients that are instrumented with CloudWatch
// RUM app monitors.
type ServiceDependent struct {
	_ struct{} `type:"structure"`

	// This is a string-to-string map. It can include the following fields.
	//
	//    * Type designates the type of object this is.
	//
	//    * ResourceType specifies the type of the resource. This field is used
	//    only when the value of the Type field is Resource or AWS::Resource.
	//
	//    * Name specifies the name of the object. This is used only if the value
	//    of the Type field is Service, RemoteService, or AWS::Service.
	//
	//    * Identifier identifies the resource objects of this resource. This is
	//    used only if the value of the Type field is Resource or AWS::Resource.
	//
	//    * Environment specifies the location where this object is hosted, or what
	//    it belongs to.
	//
	// DependentKeyAttributes is a required field
	DependentKeyAttributes map[string]*string `min:"1" type:"map" required:"true"`

	// If the dependent invoker was a service that invoked it from an operation,
	// the name of that dependent operation is displayed here.
	DependentOperationName *string `min:"1" type:"string"`

	// An array of structures that each contain information about one metric associated
	// with this service dependent that was discovered by Application Signals.
	//
	// MetricReferences is a required field
	MetricReferences []*MetricReference `type:"list" required:"true"`

	// If the invoked entity is an operation on an entity, the name of that dependent
	// operation is displayed here.
	OperationName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceDependent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceDependent) GoString() string {
	return s.String()
}

// SetDependentKeyAttributes sets the DependentKeyAttributes field's value.
func (s *ServiceDependent) SetDependentKeyAttributes(v map[string]*string) *ServiceDependent {
	s.DependentKeyAttributes = v
	return s
}

// SetDependentOperationName sets the DependentOperationName field's value.
func (s *ServiceDependent) SetDependentOperationName(v string) *ServiceDependent {
	s.DependentOperationName = &v
	return s
}

// SetMetricReferences sets the MetricReferences field's value.
func (s *ServiceDependent) SetMetricReferences(v []*MetricReference) *ServiceDependent {
	s.MetricReferences = v
	return s
}

// SetOperationName sets the OperationName field's value.
func (s *ServiceDependent) SetOperationName(v string) *ServiceDependent {
	s.OperationName = &v
	return s
}

// This structure contains information about the performance metric that an
// SLO monitors.
type ServiceLevelIndicator struct {
	_ struct{} `type:"structure"`

	// The arithmetic operation used when comparing the specified metric to the
	// threshold.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true" enum:"ServiceLevelIndicatorComparisonOperator"`

	// The value that the SLI metric is compared to.
	//
	// MetricThreshold is a required field
	MetricThreshold *float64 `type:"double" required:"true"`

	// A structure that contains information about the metric that the SLO monitors.
	//
	// SliMetric is a required field
	SliMetric *ServiceLevelIndicatorMetric `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLevelIndicator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLevelIndicator) GoString() string {
	return s.String()
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *ServiceLevelIndicator) SetComparisonOperator(v string) *ServiceLevelIndicator {
	s.ComparisonOperator = &v
	return s
}

// SetMetricThreshold sets the MetricThreshold field's value.
func (s *ServiceLevelIndicator) SetMetricThreshold(v float64) *ServiceLevelIndicator {
	s.MetricThreshold = &v
	return s
}

// SetSliMetric sets the SliMetric field's value.
func (s *ServiceLevelIndicator) SetSliMetric(v *ServiceLevelIndicatorMetric) *ServiceLevelIndicator {
	s.SliMetric = v
	return s
}

// This structure specifies the information about the service and the performance
// metric that an SLO is to monitor.
type ServiceLevelIndicatorConfig struct {
	_ struct{} `type:"structure"`

	// The arithmetic operation to use when comparing the specified metric to the
	// threshold.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true" enum:"ServiceLevelIndicatorComparisonOperator"`

	// The value that the SLI metric is compared to.
	//
	// MetricThreshold is a required field
	MetricThreshold *float64 `type:"double" required:"true"`

	// Use this structure to specify the metric to be used for the SLO.
	//
	// SliMetricConfig is a required field
	SliMetricConfig *ServiceLevelIndicatorMetricConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLevelIndicatorConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLevelIndicatorConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceLevelIndicatorConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceLevelIndicatorConfig"}
	if s.ComparisonOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("ComparisonOperator"))
	}
	if s.MetricThreshold == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricThreshold"))
	}
	if s.SliMetricConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("SliMetricConfig"))
	}
	if s.SliMetricConfig != nil {
		if err := s.SliMetricConfig.Validate(); err != nil {
			invalidParams.AddNested("SliMetricConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *ServiceLevelIndicatorConfig) SetComparisonOperator(v string) *ServiceLevelIndicatorConfig {
	s.ComparisonOperator = &v
	return s
}

// SetMetricThreshold sets the MetricThreshold field's value.
func (s *ServiceLevelIndicatorConfig) SetMetricThreshold(v float64) *ServiceLevelIndicatorConfig {
	s.MetricThreshold = &v
	return s
}

// SetSliMetricConfig sets the SliMetricConfig field's value.
func (s *ServiceLevelIndicatorConfig) SetSliMetricConfig(v *ServiceLevelIndicatorMetricConfig) *ServiceLevelIndicatorConfig {
	s.SliMetricConfig = v
	return s
}

// This structure contains the information about the metric that is used for
// the SLO.
type ServiceLevelIndicatorMetric struct {
	_ struct{} `type:"structure"`

	// This is a string-to-string map that contains information about the type of
	// object that this SLO is related to. It can include the following fields.
	//
	//    * Type designates the type of object that this SLO is related to.
	//
	//    * ResourceType specifies the type of the resource. This field is used
	//    only when the value of the Type field is Resource or AWS::Resource.
	//
	//    * Name specifies the name of the object. This is used only if the value
	//    of the Type field is Service, RemoteService, or AWS::Service.
	//
	//    * Identifier identifies the resource objects of this resource. This is
	//    used only if the value of the Type field is Resource or AWS::Resource.
	//
	//    * Environment specifies the location where this object is hosted, or what
	//    it belongs to.
	KeyAttributes map[string]*string `min:"1" type:"map"`

	// If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric
	// math expression, this structure includes the information about that metric
	// or expression.
	//
	// MetricDataQueries is a required field
	MetricDataQueries []*MetricDataQuery `type:"list" required:"true"`

	// If the SLO monitors either the LATENCY or AVAILABILITY metric that Application
	// Signals collects, this field displays which of those metrics is used.
	MetricType *string `type:"string" enum:"ServiceLevelIndicatorMetricType"`

	// If the SLO monitors a specific operation of the service, this field displays
	// that operation name.
	OperationName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLevelIndicatorMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLevelIndicatorMetric) GoString() string {
	return s.String()
}

// SetKeyAttributes sets the KeyAttributes field's value.
func (s *ServiceLevelIndicatorMetric) SetKeyAttributes(v map[string]*string) *ServiceLevelIndicatorMetric {
	s.KeyAttributes = v
	return s
}

// SetMetricDataQueries sets the MetricDataQueries field's value.
func (s *ServiceLevelIndicatorMetric) SetMetricDataQueries(v []*MetricDataQuery) *ServiceLevelIndicatorMetric {
	s.MetricDataQueries = v
	return s
}

// SetMetricType sets the MetricType field's value.
func (s *ServiceLevelIndicatorMetric) SetMetricType(v string) *ServiceLevelIndicatorMetric {
	s.MetricType = &v
	return s
}

// SetOperationName sets the OperationName field's value.
func (s *ServiceLevelIndicatorMetric) SetOperationName(v string) *ServiceLevelIndicatorMetric {
	s.OperationName = &v
	return s
}

// Use this structure to specify the information for the metric that the SLO
// will monitor.
type ServiceLevelIndicatorMetricConfig struct {
	_ struct{} `type:"structure"`

	// If this SLO is related to a metric collected by Application Signals, you
	// must use this field to specify which service the SLO metric is related to.
	// To do so, you must specify at least the Type, Name, and Environment attributes.
	//
	// This is a string-to-string map. It can include the following fields.
	//
	//    * Type designates the type of object this is.
	//
	//    * ResourceType specifies the type of the resource. This field is used
	//    only when the value of the Type field is Resource or AWS::Resource.
	//
	//    * Name specifies the name of the object. This is used only if the value
	//    of the Type field is Service, RemoteService, or AWS::Service.
	//
	//    * Identifier identifies the resource objects of this resource. This is
	//    used only if the value of the Type field is Resource or AWS::Resource.
	//
	//    * Environment specifies the location where this object is hosted, or what
	//    it belongs to.
	KeyAttributes map[string]*string `min:"1" type:"map"`

	// If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric
	// math expression, use this structure to specify that metric or expression.
	MetricDataQueries []*MetricDataQuery `type:"list"`

	// If the SLO is to monitor either the LATENCY or AVAILABILITY metric that Application
	// Signals collects, use this field to specify which of those metrics is used.
	MetricType *string `type:"string" enum:"ServiceLevelIndicatorMetricType"`

	// If the SLO is to monitor a specific operation of the service, use this field
	// to specify the name of that operation.
	OperationName *string `min:"1" type:"string"`

	// The number of seconds to use as the period for SLO evaluation. Your application's
	// performance is compared to the SLI during each period. For each period, the
	// application is determined to have either achieved or not achieved the necessary
	// performance.
	PeriodSeconds *int64 `min:"60" type:"integer"`

	// The statistic to use for comparison to the threshold. It can be any CloudWatch
	// statistic or extended statistic. For more information about statistics, see
	// CloudWatch statistics definitions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html).
	Statistic *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLevelIndicatorMetricConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLevelIndicatorMetricConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceLevelIndicatorMetricConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceLevelIndicatorMetricConfig"}
	if s.KeyAttributes != nil && len(s.KeyAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyAttributes", 1))
	}
	if s.OperationName != nil && len(*s.OperationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationName", 1))
	}
	if s.PeriodSeconds != nil && *s.PeriodSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("PeriodSeconds", 60))
	}
	if s.Statistic != nil && len(*s.Statistic) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Statistic", 1))
	}
	if s.MetricDataQueries != nil {
		for i, v := range s.MetricDataQueries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricDataQueries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyAttributes sets the KeyAttributes field's value.
func (s *ServiceLevelIndicatorMetricConfig) SetKeyAttributes(v map[string]*string) *ServiceLevelIndicatorMetricConfig {
	s.KeyAttributes = v
	return s
}

// SetMetricDataQueries sets the MetricDataQueries field's value.
func (s *ServiceLevelIndicatorMetricConfig) SetMetricDataQueries(v []*MetricDataQuery) *ServiceLevelIndicatorMetricConfig {
	s.MetricDataQueries = v
	return s
}

// SetMetricType sets the MetricType field's value.
func (s *ServiceLevelIndicatorMetricConfig) SetMetricType(v string) *ServiceLevelIndicatorMetricConfig {
	s.MetricType = &v
	return s
}

// SetOperationName sets the OperationName field's value.
func (s *ServiceLevelIndicatorMetricConfig) SetOperationName(v string) *ServiceLevelIndicatorMetricConfig {
	s.OperationName = &v
	return s
}

// SetPeriodSeconds sets the PeriodSeconds field's value.
func (s *ServiceLevelIndicatorMetricConfig) SetPeriodSeconds(v int64) *ServiceLevelIndicatorMetricConfig {
	s.PeriodSeconds = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *ServiceLevelIndicatorMetricConfig) SetStatistic(v string) *ServiceLevelIndicatorMetricConfig {
	s.Statistic = &v
	return s
}

// A structure containing information about one service level objective (SLO)
// that has been created in Application Signals. Creating SLOs can help you
// ensure your services are performing to the level that you expect. SLOs help
// you set and track a specific target level for the reliability and availability
// of your applications and services. Each SLO uses a service level indicator
// (SLI), which is a key performance metric, to calculate how much underperformance
// can be tolerated before the goal that you set for the SLO is not achieved.
type ServiceLevelObjective struct {
	_ struct{} `type:"structure"`

	// The ARN of this SLO.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// The date and time that this SLO was created. When used in a raw HTTP Query
	// API, it is formatted as yyyy-MM-dd'T'HH:mm:ss. For example, 2019-07-01T23:59:59.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// The description that you created for this SLO.
	Description *string `min:"1" type:"string"`

	// This structure contains the attributes that determine the goal of an SLO.
	// This includes the time period for evaluation and the attainment threshold.
	//
	// Goal is a required field
	Goal *Goal `type:"structure" required:"true"`

	// The time that this SLO was most recently updated. When used in a raw HTTP
	// Query API, it is formatted as yyyy-MM-dd'T'HH:mm:ss. For example, 2019-07-01T23:59:59.
	//
	// LastUpdatedTime is a required field
	LastUpdatedTime *time.Time `type:"timestamp" required:"true"`

	// The name of this SLO.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A structure containing information about the performance metric that this
	// SLO monitors.
	//
	// Sli is a required field
	Sli *ServiceLevelIndicator `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLevelObjective) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLevelObjective) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceLevelObjective) SetArn(v string) *ServiceLevelObjective {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ServiceLevelObjective) SetCreatedTime(v time.Time) *ServiceLevelObjective {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ServiceLevelObjective) SetDescription(v string) *ServiceLevelObjective {
	s.Description = &v
	return s
}

// SetGoal sets the Goal field's value.
func (s *ServiceLevelObjective) SetGoal(v *Goal) *ServiceLevelObjective {
	s.Goal = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ServiceLevelObjective) SetLastUpdatedTime(v time.Time) *ServiceLevelObjective {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceLevelObjective) SetName(v string) *ServiceLevelObjective {
	s.Name = &v
	return s
}

// SetSli sets the Sli field's value.
func (s *ServiceLevelObjective) SetSli(v *ServiceLevelIndicator) *ServiceLevelObjective {
	s.Sli = v
	return s
}

// A structure containing an SLO budget report that you have requested.
type ServiceLevelObjectiveBudgetReport struct {
	_ struct{} `type:"structure"`

	// The ARN of the SLO that this report is for.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// A number between 0 and 100 that represents the percentage of time periods
	// that the service has attained the SLO's attainment goal, as of the time of
	// the request.
	Attainment *float64 `type:"double"`

	// The budget amount remaining before the SLO status becomes BREACHING, at the
	// time specified in the Timestemp parameter of the request. If this value is
	// negative, then the SLO is already in BREACHING status.
	BudgetSecondsRemaining *int64 `type:"integer"`

	// The status of this SLO, as it relates to the error budget for the entire
	// time interval.
	//
	//    * OK means that the SLO had remaining budget above the warning threshold,
	//    as of the time that you specified in TimeStamp.
	//
	//    * WARNING means that the SLO's remaining budget was below the warning
	//    threshold, as of the time that you specified in TimeStamp.
	//
	//    * BREACHED means that the SLO's budget was exhausted, as of the time that
	//    you specified in TimeStamp.
	//
	//    * INSUFFICIENT_DATA means that the specifed start and end times were before
	//    the SLO was created, or that attainment data is missing.
	//
	// BudgetStatus is a required field
	BudgetStatus *string `type:"string" required:"true" enum:"ServiceLevelObjectiveBudgetStatus"`

	// This structure contains the attributes that determine the goal of an SLO.
	// This includes the time period for evaluation and the attainment threshold.
	Goal *Goal `type:"structure"`

	// The name of the SLO that this report is for.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A structure that contains information about the performance metric that this
	// SLO monitors.
	Sli *ServiceLevelIndicator `type:"structure"`

	// The total number of seconds in the error budget for the interval.
	TotalBudgetSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLevelObjectiveBudgetReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLevelObjectiveBudgetReport) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceLevelObjectiveBudgetReport) SetArn(v string) *ServiceLevelObjectiveBudgetReport {
	s.Arn = &v
	return s
}

// SetAttainment sets the Attainment field's value.
func (s *ServiceLevelObjectiveBudgetReport) SetAttainment(v float64) *ServiceLevelObjectiveBudgetReport {
	s.Attainment = &v
	return s
}

// SetBudgetSecondsRemaining sets the BudgetSecondsRemaining field's value.
func (s *ServiceLevelObjectiveBudgetReport) SetBudgetSecondsRemaining(v int64) *ServiceLevelObjectiveBudgetReport {
	s.BudgetSecondsRemaining = &v
	return s
}

// SetBudgetStatus sets the BudgetStatus field's value.
func (s *ServiceLevelObjectiveBudgetReport) SetBudgetStatus(v string) *ServiceLevelObjectiveBudgetReport {
	s.BudgetStatus = &v
	return s
}

// SetGoal sets the Goal field's value.
func (s *ServiceLevelObjectiveBudgetReport) SetGoal(v *Goal) *ServiceLevelObjectiveBudgetReport {
	s.Goal = v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceLevelObjectiveBudgetReport) SetName(v string) *ServiceLevelObjectiveBudgetReport {
	s.Name = &v
	return s
}

// SetSli sets the Sli field's value.
func (s *ServiceLevelObjectiveBudgetReport) SetSli(v *ServiceLevelIndicator) *ServiceLevelObjectiveBudgetReport {
	s.Sli = v
	return s
}

// SetTotalBudgetSeconds sets the TotalBudgetSeconds field's value.
func (s *ServiceLevelObjectiveBudgetReport) SetTotalBudgetSeconds(v int64) *ServiceLevelObjectiveBudgetReport {
	s.TotalBudgetSeconds = &v
	return s
}

// A structure containing information about one error that occurred during a
// BatchGetServiceLevelObjectiveBudgetReport (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_BatchGetServiceLevelObjectiveBudgetReport.html)
// operation.
type ServiceLevelObjectiveBudgetReportError struct {
	_ struct{} `type:"structure"`

	// The ARN of the SLO that this error is related to.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// The error code for this error.
	//
	// ErrorCode is a required field
	ErrorCode *string `type:"string" required:"true"`

	// The message for this error.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `type:"string" required:"true"`

	// The name of the SLO that this error is related to.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLevelObjectiveBudgetReportError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLevelObjectiveBudgetReportError) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceLevelObjectiveBudgetReportError) SetArn(v string) *ServiceLevelObjectiveBudgetReportError {
	s.Arn = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ServiceLevelObjectiveBudgetReportError) SetErrorCode(v string) *ServiceLevelObjectiveBudgetReportError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ServiceLevelObjectiveBudgetReportError) SetErrorMessage(v string) *ServiceLevelObjectiveBudgetReportError {
	s.ErrorMessage = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceLevelObjectiveBudgetReportError) SetName(v string) *ServiceLevelObjectiveBudgetReportError {
	s.Name = &v
	return s
}

// A structure that contains information about one service level objective (SLO)
// created in Application Signals.
type ServiceLevelObjectiveSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of this service level objective.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// The date and time that this service level objective was created. It is expressed
	// as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
	CreatedTime *time.Time `type:"timestamp"`

	// This is a string-to-string map. It can include the following fields.
	//
	//    * Type designates the type of object this service level objective is for.
	//
	//    * ResourceType specifies the type of the resource. This field is used
	//    only when the value of the Type field is Resource or AWS::Resource.
	//
	//    * Name specifies the name of the object. This is used only if the value
	//    of the Type field is Service, RemoteService, or AWS::Service.
	//
	//    * Identifier identifies the resource objects of this resource. This is
	//    used only if the value of the Type field is Resource or AWS::Resource.
	//
	//    * Environment specifies the location where this object is hosted, or what
	//    it belongs to.
	KeyAttributes map[string]*string `min:"1" type:"map"`

	// The name of the service level objective.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// If this service level objective is specific to a single operation, this field
	// displays the name of that operation.
	OperationName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLevelObjectiveSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLevelObjectiveSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceLevelObjectiveSummary) SetArn(v string) *ServiceLevelObjectiveSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ServiceLevelObjectiveSummary) SetCreatedTime(v time.Time) *ServiceLevelObjectiveSummary {
	s.CreatedTime = &v
	return s
}

// SetKeyAttributes sets the KeyAttributes field's value.
func (s *ServiceLevelObjectiveSummary) SetKeyAttributes(v map[string]*string) *ServiceLevelObjectiveSummary {
	s.KeyAttributes = v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceLevelObjectiveSummary) SetName(v string) *ServiceLevelObjectiveSummary {
	s.Name = &v
	return s
}

// SetOperationName sets the OperationName field's value.
func (s *ServiceLevelObjectiveSummary) SetOperationName(v string) *ServiceLevelObjectiveSummary {
	s.OperationName = &v
	return s
}

// This structure contains information about an operation discovered by Application
// Signals. An operation is a specific function performed by a service that
// was discovered by Application Signals, and is often an API that is called
// by an upstream dependent.
type ServiceOperation struct {
	_ struct{} `type:"structure"`

	// An array of structures that each contain information about one metric associated
	// with this service operation that was discovered by Application Signals.
	//
	// MetricReferences is a required field
	MetricReferences []*MetricReference `type:"list" required:"true"`

	// The name of the operation, discovered by Application Signals.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceOperation) GoString() string {
	return s.String()
}

// SetMetricReferences sets the MetricReferences field's value.
func (s *ServiceOperation) SetMetricReferences(v []*MetricReference) *ServiceOperation {
	s.MetricReferences = v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceOperation) SetName(v string) *ServiceOperation {
	s.Name = &v
	return s
}

// This request exceeds a service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This structure contains information about one of your services that was discoverd
// by Application Signals
type ServiceSummary struct {
	_ struct{} `type:"structure"`

	// This structure contains one or more string-to-string maps that help identify
	// this service. It can include platform attributes, application attributes,
	// and telemetry attributes.
	//
	// Platform attributes contain information the service's platform.
	//
	//    * PlatformType defines the hosted-in platform.
	//
	//    * EKS.Cluster is the name of the Amazon EKS cluster.
	//
	//    * K8s.Cluster is the name of the self-hosted Kubernetes cluster.
	//
	//    * K8s.Namespace is the name of the Kubernetes namespace in either Amazon
	//    EKS or Kubernetes clusters.
	//
	//    * K8s.Workload is the name of the Kubernetes workload in either Amazon
	//    EKS or Kubernetes clusters.
	//
	//    * K8s.Node is the name of the Kubernetes node in either Amazon EKS or
	//    Kubernetes clusters.
	//
	//    * K8s.Pod is the name of the Kubernetes pod in either Amazon EKS or Kubernetes
	//    clusters.
	//
	//    * EC2.AutoScalingGroup is the name of the Amazon EC2 Auto Scaling group.
	//
	//    * EC2.InstanceId is the ID of the Amazon EC2 instance.
	//
	//    * Host is the name of the host, for all platform types.
	//
	// Applciation attributes contain information about the application.
	//
	//    * AWS.Application is the application's name in Amazon Web Services Service
	//    Catalog AppRegistry.
	//
	//    * AWS.Application.ARN is the application's ARN in Amazon Web Services
	//    Service Catalog AppRegistry.
	//
	// Telemetry attributes contain telemetry information.
	//
	//    * Telemetry.SDK is the fingerprint of the OpenTelemetry SDK version for
	//    instrumented services.
	//
	//    * Telemetry.Agent is the fingerprint of the agent used to collect and
	//    send telemetry data.
	//
	//    * Telemetry.Source Specifies the point of application where the telemetry
	//    was collected or specifies what was used for the source of telemetry data.
	AttributeMaps []map[string]*string `type:"list"`

	// This is a string-to-string map that help identify the objects discovered
	// by Application Signals. It can include the following fields.
	//
	//    * Type designates the type of object this is.
	//
	//    * ResourceType specifies the type of the resource. This field is used
	//    only when the value of the Type field is Resource or AWS::Resource.
	//
	//    * Name specifies the name of the object. This is used only if the value
	//    of the Type field is Service, RemoteService, or AWS::Service.
	//
	//    * Identifier identifies the resource objects of this resource. This is
	//    used only if the value of the Type field is Resource or AWS::Resource.
	//
	//    * Environment specifies the location where this object is hosted, or what
	//    it belongs to.
	//
	// KeyAttributes is a required field
	KeyAttributes map[string]*string `min:"1" type:"map" required:"true"`

	// An array of structures that each contain information about one metric associated
	// with this service.
	//
	// MetricReferences is a required field
	MetricReferences []*MetricReference `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSummary) GoString() string {
	return s.String()
}

// SetAttributeMaps sets the AttributeMaps field's value.
func (s *ServiceSummary) SetAttributeMaps(v []map[string]*string) *ServiceSummary {
	s.AttributeMaps = v
	return s
}

// SetKeyAttributes sets the KeyAttributes field's value.
func (s *ServiceSummary) SetKeyAttributes(v map[string]*string) *ServiceSummary {
	s.KeyAttributes = v
	return s
}

// SetMetricReferences sets the MetricReferences field's value.
func (s *ServiceSummary) SetMetricReferences(v []*MetricReference) *ServiceSummary {
	s.MetricReferences = v
	return s
}

type StartDiscoveryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDiscoveryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDiscoveryInput) GoString() string {
	return s.String()
}

type StartDiscoveryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDiscoveryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDiscoveryOutput) GoString() string {
	return s.String()
}

// A key-value pair associated with a resource. Tags can help you organize and
// categorize your resources.
type Tag struct {
	_ struct{} `type:"structure"`

	// A string that you can use to assign a value. The combination of tag keys
	// and values can help you organize and categorize your resources.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value for the specified tag key.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CloudWatch resource that you want to
	// set tags for.
	//
	// The ARN format of an Application Signals SLO is arn:aws:cloudwatch:Region:account-id:slo:slo-name
	//
	// For more information about ARN format, see Resource Types Defined by Amazon
	// CloudWatch (https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies)
	// in the Amazon Web Services General Reference.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The list of key-value pairs to associate with the alarm.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was throttled because of quota limits.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CloudWatch resource that you want to
	// delete tags from.
	//
	// The ARN format of an Application Signals SLO is arn:aws:cloudwatch:Region:account-id:slo:slo-name
	//
	// For more information about ARN format, see Resource Types Defined by Amazon
	// CloudWatch (https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies)
	// in the Amazon Web Services General Reference.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The list of tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateServiceLevelObjectiveInput struct {
	_ struct{} `type:"structure"`

	// An optional description for the SLO.
	Description *string `min:"1" type:"string"`

	// A structure that contains the attributes that determine the goal of the SLO.
	// This includes the time period for evaluation and the attainment threshold.
	Goal *Goal `type:"structure"`

	// The Amazon Resource Name (ARN) or name of the service level objective that
	// you want to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// A structure that contains information about what performance metric this
	// SLO will monitor.
	SliConfig *ServiceLevelIndicatorConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceLevelObjectiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceLevelObjectiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceLevelObjectiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceLevelObjectiveInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Goal != nil {
		if err := s.Goal.Validate(); err != nil {
			invalidParams.AddNested("Goal", err.(request.ErrInvalidParams))
		}
	}
	if s.SliConfig != nil {
		if err := s.SliConfig.Validate(); err != nil {
			invalidParams.AddNested("SliConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateServiceLevelObjectiveInput) SetDescription(v string) *UpdateServiceLevelObjectiveInput {
	s.Description = &v
	return s
}

// SetGoal sets the Goal field's value.
func (s *UpdateServiceLevelObjectiveInput) SetGoal(v *Goal) *UpdateServiceLevelObjectiveInput {
	s.Goal = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateServiceLevelObjectiveInput) SetId(v string) *UpdateServiceLevelObjectiveInput {
	s.Id = &v
	return s
}

// SetSliConfig sets the SliConfig field's value.
func (s *UpdateServiceLevelObjectiveInput) SetSliConfig(v *ServiceLevelIndicatorConfig) *UpdateServiceLevelObjectiveInput {
	s.SliConfig = v
	return s
}

type UpdateServiceLevelObjectiveOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about the SLO that you just updated.
	//
	// Slo is a required field
	Slo *ServiceLevelObjective `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceLevelObjectiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceLevelObjectiveOutput) GoString() string {
	return s.String()
}

// SetSlo sets the Slo field's value.
func (s *UpdateServiceLevelObjectiveOutput) SetSlo(v *ServiceLevelObjective) *UpdateServiceLevelObjectiveOutput {
	s.Slo = v
	return s
}

// The resource is not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// DurationUnitDay is a DurationUnit enum value
	DurationUnitDay = "DAY"

	// DurationUnitMonth is a DurationUnit enum value
	DurationUnitMonth = "MONTH"
)

// DurationUnit_Values returns all elements of the DurationUnit enum
func DurationUnit_Values() []string {
	return []string{
		DurationUnitDay,
		DurationUnitMonth,
	}
}

const (
	// ServiceLevelIndicatorComparisonOperatorGreaterThanOrEqualTo is a ServiceLevelIndicatorComparisonOperator enum value
	ServiceLevelIndicatorComparisonOperatorGreaterThanOrEqualTo = "GreaterThanOrEqualTo"

	// ServiceLevelIndicatorComparisonOperatorGreaterThan is a ServiceLevelIndicatorComparisonOperator enum value
	ServiceLevelIndicatorComparisonOperatorGreaterThan = "GreaterThan"

	// ServiceLevelIndicatorComparisonOperatorLessThan is a ServiceLevelIndicatorComparisonOperator enum value
	ServiceLevelIndicatorComparisonOperatorLessThan = "LessThan"

	// ServiceLevelIndicatorComparisonOperatorLessThanOrEqualTo is a ServiceLevelIndicatorComparisonOperator enum value
	ServiceLevelIndicatorComparisonOperatorLessThanOrEqualTo = "LessThanOrEqualTo"
)

// ServiceLevelIndicatorComparisonOperator_Values returns all elements of the ServiceLevelIndicatorComparisonOperator enum
func ServiceLevelIndicatorComparisonOperator_Values() []string {
	return []string{
		ServiceLevelIndicatorComparisonOperatorGreaterThanOrEqualTo,
		ServiceLevelIndicatorComparisonOperatorGreaterThan,
		ServiceLevelIndicatorComparisonOperatorLessThan,
		ServiceLevelIndicatorComparisonOperatorLessThanOrEqualTo,
	}
}

const (
	// ServiceLevelIndicatorMetricTypeLatency is a ServiceLevelIndicatorMetricType enum value
	ServiceLevelIndicatorMetricTypeLatency = "LATENCY"

	// ServiceLevelIndicatorMetricTypeAvailability is a ServiceLevelIndicatorMetricType enum value
	ServiceLevelIndicatorMetricTypeAvailability = "AVAILABILITY"
)

// ServiceLevelIndicatorMetricType_Values returns all elements of the ServiceLevelIndicatorMetricType enum
func ServiceLevelIndicatorMetricType_Values() []string {
	return []string{
		ServiceLevelIndicatorMetricTypeLatency,
		ServiceLevelIndicatorMetricTypeAvailability,
	}
}

const (
	// ServiceLevelObjectiveBudgetStatusOk is a ServiceLevelObjectiveBudgetStatus enum value
	ServiceLevelObjectiveBudgetStatusOk = "OK"

	// ServiceLevelObjectiveBudgetStatusWarning is a ServiceLevelObjectiveBudgetStatus enum value
	ServiceLevelObjectiveBudgetStatusWarning = "WARNING"

	// ServiceLevelObjectiveBudgetStatusBreached is a ServiceLevelObjectiveBudgetStatus enum value
	ServiceLevelObjectiveBudgetStatusBreached = "BREACHED"

	// ServiceLevelObjectiveBudgetStatusInsufficientData is a ServiceLevelObjectiveBudgetStatus enum value
	ServiceLevelObjectiveBudgetStatusInsufficientData = "INSUFFICIENT_DATA"
)

// ServiceLevelObjectiveBudgetStatus_Values returns all elements of the ServiceLevelObjectiveBudgetStatus enum
func ServiceLevelObjectiveBudgetStatus_Values() []string {
	return []string{
		ServiceLevelObjectiveBudgetStatusOk,
		ServiceLevelObjectiveBudgetStatusWarning,
		ServiceLevelObjectiveBudgetStatusBreached,
		ServiceLevelObjectiveBudgetStatusInsufficientData,
	}
}

const (
	// StandardUnitMicroseconds is a StandardUnit enum value
	StandardUnitMicroseconds = "Microseconds"

	// StandardUnitMilliseconds is a StandardUnit enum value
	StandardUnitMilliseconds = "Milliseconds"

	// StandardUnitSeconds is a StandardUnit enum value
	StandardUnitSeconds = "Seconds"

	// StandardUnitBytes is a StandardUnit enum value
	StandardUnitBytes = "Bytes"

	// StandardUnitKilobytes is a StandardUnit enum value
	StandardUnitKilobytes = "Kilobytes"

	// StandardUnitMegabytes is a StandardUnit enum value
	StandardUnitMegabytes = "Megabytes"

	// StandardUnitGigabytes is a StandardUnit enum value
	StandardUnitGigabytes = "Gigabytes"

	// StandardUnitTerabytes is a StandardUnit enum value
	StandardUnitTerabytes = "Terabytes"

	// StandardUnitBits is a StandardUnit enum value
	StandardUnitBits = "Bits"

	// StandardUnitKilobits is a StandardUnit enum value
	StandardUnitKilobits = "Kilobits"

	// StandardUnitMegabits is a StandardUnit enum value
	StandardUnitMegabits = "Megabits"

	// StandardUnitGigabits is a StandardUnit enum value
	StandardUnitGigabits = "Gigabits"

	// StandardUnitTerabits is a StandardUnit enum value
	StandardUnitTerabits = "Terabits"

	// StandardUnitPercent is a StandardUnit enum value
	StandardUnitPercent = "Percent"

	// StandardUnitCount is a StandardUnit enum value
	StandardUnitCount = "Count"

	// StandardUnitBytesSecond is a StandardUnit enum value
	StandardUnitBytesSecond = "Bytes/Second"

	// StandardUnitKilobytesSecond is a StandardUnit enum value
	StandardUnitKilobytesSecond = "Kilobytes/Second"

	// StandardUnitMegabytesSecond is a StandardUnit enum value
	StandardUnitMegabytesSecond = "Megabytes/Second"

	// StandardUnitGigabytesSecond is a StandardUnit enum value
	StandardUnitGigabytesSecond = "Gigabytes/Second"

	// StandardUnitTerabytesSecond is a StandardUnit enum value
	StandardUnitTerabytesSecond = "Terabytes/Second"

	// StandardUnitBitsSecond is a StandardUnit enum value
	StandardUnitBitsSecond = "Bits/Second"

	// StandardUnitKilobitsSecond is a StandardUnit enum value
	StandardUnitKilobitsSecond = "Kilobits/Second"

	// StandardUnitMegabitsSecond is a StandardUnit enum value
	StandardUnitMegabitsSecond = "Megabits/Second"

	// StandardUnitGigabitsSecond is a StandardUnit enum value
	StandardUnitGigabitsSecond = "Gigabits/Second"

	// StandardUnitTerabitsSecond is a StandardUnit enum value
	StandardUnitTerabitsSecond = "Terabits/Second"

	// StandardUnitCountSecond is a StandardUnit enum value
	StandardUnitCountSecond = "Count/Second"

	// StandardUnitNone is a StandardUnit enum value
	StandardUnitNone = "None"
)

// StandardUnit_Values returns all elements of the StandardUnit enum
func StandardUnit_Values() []string {
	return []string{
		StandardUnitMicroseconds,
		StandardUnitMilliseconds,
		StandardUnitSeconds,
		StandardUnitBytes,
		StandardUnitKilobytes,
		StandardUnitMegabytes,
		StandardUnitGigabytes,
		StandardUnitTerabytes,
		StandardUnitBits,
		StandardUnitKilobits,
		StandardUnitMegabits,
		StandardUnitGigabits,
		StandardUnitTerabits,
		StandardUnitPercent,
		StandardUnitCount,
		StandardUnitBytesSecond,
		StandardUnitKilobytesSecond,
		StandardUnitMegabytesSecond,
		StandardUnitGigabytesSecond,
		StandardUnitTerabytesSecond,
		StandardUnitBitsSecond,
		StandardUnitKilobitsSecond,
		StandardUnitMegabitsSecond,
		StandardUnitGigabitsSecond,
		StandardUnitTerabitsSecond,
		StandardUnitCountSecond,
		StandardUnitNone,
	}
}
