// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transcribestreamingservice

import (
	"bytes"
	"fmt"
	"io"
	"sync"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/client"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/signer/v4"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream/eventstreamapi"
	"github.com/aws/aws-sdk-go/private/protocol/rest"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opStartCallAnalyticsStreamTranscription = "StartCallAnalyticsStreamTranscription"

// StartCallAnalyticsStreamTranscriptionRequest generates a "aws/request.Request" representing the
// client's request for the StartCallAnalyticsStreamTranscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartCallAnalyticsStreamTranscription for more information on using the StartCallAnalyticsStreamTranscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartCallAnalyticsStreamTranscriptionRequest method.
//	req, resp := client.StartCallAnalyticsStreamTranscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-streaming-2017-10-26/StartCallAnalyticsStreamTranscription
func (c *TranscribeStreamingService) StartCallAnalyticsStreamTranscriptionRequest(input *StartCallAnalyticsStreamTranscriptionInput) (req *request.Request, output *StartCallAnalyticsStreamTranscriptionOutput) {
	op := &request.Operation{
		Name:       opStartCallAnalyticsStreamTranscription,
		HTTPMethod: "POST",
		HTTPPath:   "/call-analytics-stream-transcription",
	}

	if input == nil {
		input = &StartCallAnalyticsStreamTranscriptionInput{}
	}

	output = &StartCallAnalyticsStreamTranscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.UnmarshalMeta.PushBack(
		protocol.RequireHTTPMinProtocol{Major: 2}.Handler,
	)

	es := NewStartCallAnalyticsStreamTranscriptionEventStream()
	output.eventStream = es

	req.Handlers.Sign.PushFront(es.setupInputPipe)
	req.Handlers.UnmarshalError.PushBackNamed(request.NamedHandler{
		Name: "InputPipeCloser",
		Fn: func(r *request.Request) {
			err := es.closeInputPipe()
			if err != nil {
				r.Error = awserr.New(eventstreamapi.InputWriterCloseErrorCode, err.Error(), r.Error)
			}
		},
	})
	req.Handlers.Build.PushBack(request.WithSetRequestHeaders(map[string]string{
		"Content-Type":         "application/vnd.amazon.eventstream",
		"X-Amz-Content-Sha256": "STREAMING-AWS4-HMAC-SHA256-EVENTS",
	}))
	req.Handlers.Build.Swap(restjson.BuildHandler.Name, rest.BuildHandler)
	eventstreamapi.ApplyHTTPTransportFixes(req)
	req.Handlers.Send.Swap(client.LogHTTPRequestHandler.Name, client.LogHTTPRequestHeaderHandler)
	req.Handlers.Unmarshal.PushBack(es.runInputStream)

	req.Handlers.Send.Swap(client.LogHTTPResponseHandler.Name, client.LogHTTPResponseHeaderHandler)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, rest.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBack(es.runOutputStream)
	req.Handlers.Unmarshal.PushBack(es.runOnStreamPartClose)
	return
}

// StartCallAnalyticsStreamTranscription API operation for Amazon Transcribe Streaming Service.
//
// Starts a bidirectional HTTP/2 or WebSocket stream where audio is streamed
// to Amazon Transcribe and the transcription results are streamed to your application.
// Use this operation for Call Analytics (https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html)
// transcriptions.
//
// The following parameters are required:
//
//   - language-code
//
//   - media-encoding
//
//   - sample-rate
//
// For more information on streaming with Amazon Transcribe, see Transcribing
// streaming audio (https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Streaming Service's
// API operation StartCallAnalyticsStreamTranscription for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     One or more arguments to the StartStreamTranscription, StartMedicalStreamTranscription,
//     or StartCallAnalyticsStreamTranscription operation was not valid. For example,
//     MediaEncoding or LanguageCode used not valid values. Check the specified
//     parameters and try your request again.
//
//   - LimitExceededException
//     Your client has exceeded one of the Amazon Transcribe limits. This is typically
//     the audio length limit. Break your audio stream into smaller chunks and try
//     your request again.
//
//   - InternalFailureException
//     A problem occurred while processing the audio. Amazon Transcribe terminated
//     processing.
//
//   - ConflictException
//     A new stream started with the same session ID. The current stream has been
//     terminated.
//
//   - ServiceUnavailableException
//     The service is currently unavailable. Try your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-streaming-2017-10-26/StartCallAnalyticsStreamTranscription
func (c *TranscribeStreamingService) StartCallAnalyticsStreamTranscription(input *StartCallAnalyticsStreamTranscriptionInput) (*StartCallAnalyticsStreamTranscriptionOutput, error) {
	req, out := c.StartCallAnalyticsStreamTranscriptionRequest(input)
	return out, req.Send()
}

// StartCallAnalyticsStreamTranscriptionWithContext is the same as StartCallAnalyticsStreamTranscription with the addition of
// the ability to pass a context and additional request options.
//
// See StartCallAnalyticsStreamTranscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeStreamingService) StartCallAnalyticsStreamTranscriptionWithContext(ctx aws.Context, input *StartCallAnalyticsStreamTranscriptionInput, opts ...request.Option) (*StartCallAnalyticsStreamTranscriptionOutput, error) {
	req, out := c.StartCallAnalyticsStreamTranscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

var _ awserr.Error
var _ time.Time

// StartCallAnalyticsStreamTranscriptionEventStream provides the event stream handling for the StartCallAnalyticsStreamTranscription.
//
// For testing and mocking the event stream this type should be initialized via
// the NewStartCallAnalyticsStreamTranscriptionEventStream constructor function. Using the functional options
// to pass in nested mock behavior.
type StartCallAnalyticsStreamTranscriptionEventStream struct {

	// Writer is the EventStream writer for the AudioStream
	// events. This value is automatically set by the SDK when the API call is made
	// Use this member when unit testing your code with the SDK to mock out the
	// EventStream Writer.
	//
	// Must not be nil.
	Writer AudioStreamWriter

	inputWriter io.WriteCloser

	// Reader is the EventStream reader for the CallAnalyticsTranscriptResultStream
	// events. This value is automatically set by the SDK when the API call is made
	// Use this member when unit testing your code with the SDK to mock out the
	// EventStream Reader.
	//
	// Must not be nil.
	Reader CallAnalyticsTranscriptResultStreamReader

	outputReader io.ReadCloser

	done      chan struct{}
	closeOnce sync.Once
	err       *eventstreamapi.OnceError
}

// NewStartCallAnalyticsStreamTranscriptionEventStream initializes an StartCallAnalyticsStreamTranscriptionEventStream.
// This function should only be used for testing and mocking the StartCallAnalyticsStreamTranscriptionEventStream
// stream within your application.
//
// The Writer member must be set before writing events to the stream.
//
// The Reader member must be set before reading events from the stream.
//
//	es := NewStartCallAnalyticsStreamTranscriptionEventStream(func(o *StartCallAnalyticsStreamTranscriptionEventStream){
//	    es.Writer = myMockStreamWriter
//	    es.Reader = myMockStreamReader
//	})
func NewStartCallAnalyticsStreamTranscriptionEventStream(opts ...func(*StartCallAnalyticsStreamTranscriptionEventStream)) *StartCallAnalyticsStreamTranscriptionEventStream {
	es := &StartCallAnalyticsStreamTranscriptionEventStream{
		done: make(chan struct{}),
		err:  eventstreamapi.NewOnceError(),
	}

	for _, fn := range opts {
		fn(es)
	}

	return es
}

func (es *StartCallAnalyticsStreamTranscriptionEventStream) runOnStreamPartClose(r *request.Request) {
	if es.done == nil {
		return
	}
	go es.waitStreamPartClose()

}

func (es *StartCallAnalyticsStreamTranscriptionEventStream) waitStreamPartClose() {
	var inputErrCh <-chan struct{}
	if v, ok := es.Writer.(interface{ ErrorSet() <-chan struct{} }); ok {
		inputErrCh = v.ErrorSet()
	}
	var outputErrCh <-chan struct{}
	if v, ok := es.Reader.(interface{ ErrorSet() <-chan struct{} }); ok {
		outputErrCh = v.ErrorSet()
	}
	var outputClosedCh <-chan struct{}
	if v, ok := es.Reader.(interface{ Closed() <-chan struct{} }); ok {
		outputClosedCh = v.Closed()
	}

	select {
	case <-es.done:
	case <-inputErrCh:
		es.err.SetError(es.Writer.Err())
		es.Close()
	case <-outputErrCh:
		es.err.SetError(es.Reader.Err())
		es.Close()
	case <-outputClosedCh:
		if err := es.Reader.Err(); err != nil {
			es.err.SetError(es.Reader.Err())
		}
		es.Close()
	}
}

func (es *StartCallAnalyticsStreamTranscriptionEventStream) setupInputPipe(r *request.Request) {
	inputReader, inputWriter := io.Pipe()
	r.SetStreamingBody(inputReader)
	es.inputWriter = inputWriter
}

// Closes the input-pipe writer
func (es *StartCallAnalyticsStreamTranscriptionEventStream) closeInputPipe() error {
	if es.inputWriter != nil {
		return es.inputWriter.Close()
	}
	return nil
}

// Send writes the event to the stream blocking until the event is written.
// Returns an error if the event was not written.
//
// These events are:
//
//   - AudioEvent
//   - ConfigurationEvent
func (es *StartCallAnalyticsStreamTranscriptionEventStream) Send(ctx aws.Context, event AudioStreamEvent) error {
	return es.Writer.Send(ctx, event)
}

func (es *StartCallAnalyticsStreamTranscriptionEventStream) runInputStream(r *request.Request) {
	var opts []func(*eventstream.Encoder)
	if r.Config.Logger != nil && r.Config.LogLevel.Matches(aws.LogDebugWithEventStreamBody) {
		opts = append(opts, eventstream.EncodeWithLogger(r.Config.Logger))
	}
	var encoder eventstreamapi.Encoder = eventstream.NewEncoder(es.inputWriter, opts...)

	var closer aws.MultiCloser
	sigSeed, err := v4.GetSignedRequestSignature(r.HTTPRequest)
	if err != nil {
		r.Error = awserr.New(request.ErrCodeSerialization,
			"unable to get initial request's signature", err)
		return
	}
	signer := eventstreamapi.NewSignEncoder(
		v4.NewStreamSigner(r.ClientInfo.SigningRegion, r.ClientInfo.SigningName,
			sigSeed, r.Config.Credentials),
		encoder,
	)
	encoder = signer
	closer = append(closer, signer)
	closer = append(closer, es.inputWriter)

	eventWriter := eventstreamapi.NewEventWriter(encoder,
		protocol.HandlerPayloadMarshal{
			Marshalers: r.Handlers.BuildStream,
		},
		eventTypeForAudioStreamEvent,
	)

	es.Writer = &writeAudioStream{
		StreamWriter: eventstreamapi.NewStreamWriter(eventWriter, closer),
	}
}

// Events returns a channel to read events from.
//
// These events are:
//
//   - CategoryEvent
//   - UtteranceEvent
//   - CallAnalyticsTranscriptResultStreamUnknownEvent
func (es *StartCallAnalyticsStreamTranscriptionEventStream) Events() <-chan CallAnalyticsTranscriptResultStreamEvent {
	return es.Reader.Events()
}

func (es *StartCallAnalyticsStreamTranscriptionEventStream) runOutputStream(r *request.Request) {
	var opts []func(*eventstream.Decoder)
	if r.Config.Logger != nil && r.Config.LogLevel.Matches(aws.LogDebugWithEventStreamBody) {
		opts = append(opts, eventstream.DecodeWithLogger(r.Config.Logger))
	}

	unmarshalerForEvent := unmarshalerForCallAnalyticsTranscriptResultStreamEvent{
		metadata: protocol.ResponseMetadata{
			StatusCode: r.HTTPResponse.StatusCode,
			RequestID:  r.RequestID,
		},
	}.UnmarshalerForEventName

	decoder := eventstream.NewDecoder(r.HTTPResponse.Body, opts...)
	eventReader := eventstreamapi.NewEventReader(decoder,
		protocol.HandlerPayloadUnmarshal{
			Unmarshalers: r.Handlers.UnmarshalStream,
		},
		unmarshalerForEvent,
	)

	es.outputReader = r.HTTPResponse.Body
	es.Reader = newReadCallAnalyticsTranscriptResultStream(eventReader)
}

// Close closes the stream. This will also cause the stream to be closed.
// Close must be called when done using the stream API. Not calling Close
// may result in resource leaks.
//
// Will close the underlying EventStream writer, and no more events can be
// sent.
//
// You can use the closing of the Reader's Events channel to terminate your
// application's read from the API's stream.
func (es *StartCallAnalyticsStreamTranscriptionEventStream) Close() (err error) {
	es.closeOnce.Do(es.safeClose)
	return es.Err()
}

func (es *StartCallAnalyticsStreamTranscriptionEventStream) safeClose() {
	if es.done != nil {
		close(es.done)
	}

	t := time.NewTicker(time.Second)
	defer t.Stop()
	writeCloseDone := make(chan error)
	go func() {
		if err := es.Writer.Close(); err != nil {
			es.err.SetError(err)
		}
		close(writeCloseDone)
	}()
	select {
	case <-t.C:
	case <-writeCloseDone:
	}
	if err := es.closeInputPipe(); err != nil {
		es.err.SetError(err)
	}

	es.Reader.Close()
	if es.outputReader != nil {
		es.outputReader.Close()
	}
}

// Err returns any error that occurred while reading or writing EventStream
// Events from the service API's response. Returns nil if there were no errors.
func (es *StartCallAnalyticsStreamTranscriptionEventStream) Err() error {
	if err := es.err.Err(); err != nil {
		return err
	}
	if err := es.Writer.Err(); err != nil {
		return err
	}
	if err := es.Reader.Err(); err != nil {
		return err
	}

	return nil
}

const opStartMedicalStreamTranscription = "StartMedicalStreamTranscription"

// StartMedicalStreamTranscriptionRequest generates a "aws/request.Request" representing the
// client's request for the StartMedicalStreamTranscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMedicalStreamTranscription for more information on using the StartMedicalStreamTranscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMedicalStreamTranscriptionRequest method.
//	req, resp := client.StartMedicalStreamTranscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-streaming-2017-10-26/StartMedicalStreamTranscription
func (c *TranscribeStreamingService) StartMedicalStreamTranscriptionRequest(input *StartMedicalStreamTranscriptionInput) (req *request.Request, output *StartMedicalStreamTranscriptionOutput) {
	op := &request.Operation{
		Name:       opStartMedicalStreamTranscription,
		HTTPMethod: "POST",
		HTTPPath:   "/medical-stream-transcription",
	}

	if input == nil {
		input = &StartMedicalStreamTranscriptionInput{}
	}

	output = &StartMedicalStreamTranscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.UnmarshalMeta.PushBack(
		protocol.RequireHTTPMinProtocol{Major: 2}.Handler,
	)

	es := NewStartMedicalStreamTranscriptionEventStream()
	output.eventStream = es

	req.Handlers.Sign.PushFront(es.setupInputPipe)
	req.Handlers.UnmarshalError.PushBackNamed(request.NamedHandler{
		Name: "InputPipeCloser",
		Fn: func(r *request.Request) {
			err := es.closeInputPipe()
			if err != nil {
				r.Error = awserr.New(eventstreamapi.InputWriterCloseErrorCode, err.Error(), r.Error)
			}
		},
	})
	req.Handlers.Build.PushBack(request.WithSetRequestHeaders(map[string]string{
		"Content-Type":         "application/vnd.amazon.eventstream",
		"X-Amz-Content-Sha256": "STREAMING-AWS4-HMAC-SHA256-EVENTS",
	}))
	req.Handlers.Build.Swap(restjson.BuildHandler.Name, rest.BuildHandler)
	eventstreamapi.ApplyHTTPTransportFixes(req)
	req.Handlers.Send.Swap(client.LogHTTPRequestHandler.Name, client.LogHTTPRequestHeaderHandler)
	req.Handlers.Unmarshal.PushBack(es.runInputStream)

	req.Handlers.Send.Swap(client.LogHTTPResponseHandler.Name, client.LogHTTPResponseHeaderHandler)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, rest.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBack(es.runOutputStream)
	req.Handlers.Unmarshal.PushBack(es.runOnStreamPartClose)
	return
}

// StartMedicalStreamTranscription API operation for Amazon Transcribe Streaming Service.
//
// Starts a bidirectional HTTP/2 or WebSocket stream where audio is streamed
// to Amazon Transcribe Medical and the transcription results are streamed to
// your application.
//
// The following parameters are required:
//
//   - language-code
//
//   - media-encoding
//
//   - sample-rate
//
// For more information on streaming with Amazon Transcribe Medical, see Transcribing
// streaming audio (https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Streaming Service's
// API operation StartMedicalStreamTranscription for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     One or more arguments to the StartStreamTranscription, StartMedicalStreamTranscription,
//     or StartCallAnalyticsStreamTranscription operation was not valid. For example,
//     MediaEncoding or LanguageCode used not valid values. Check the specified
//     parameters and try your request again.
//
//   - LimitExceededException
//     Your client has exceeded one of the Amazon Transcribe limits. This is typically
//     the audio length limit. Break your audio stream into smaller chunks and try
//     your request again.
//
//   - InternalFailureException
//     A problem occurred while processing the audio. Amazon Transcribe terminated
//     processing.
//
//   - ConflictException
//     A new stream started with the same session ID. The current stream has been
//     terminated.
//
//   - ServiceUnavailableException
//     The service is currently unavailable. Try your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-streaming-2017-10-26/StartMedicalStreamTranscription
func (c *TranscribeStreamingService) StartMedicalStreamTranscription(input *StartMedicalStreamTranscriptionInput) (*StartMedicalStreamTranscriptionOutput, error) {
	req, out := c.StartMedicalStreamTranscriptionRequest(input)
	return out, req.Send()
}

// StartMedicalStreamTranscriptionWithContext is the same as StartMedicalStreamTranscription with the addition of
// the ability to pass a context and additional request options.
//
// See StartMedicalStreamTranscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeStreamingService) StartMedicalStreamTranscriptionWithContext(ctx aws.Context, input *StartMedicalStreamTranscriptionInput, opts ...request.Option) (*StartMedicalStreamTranscriptionOutput, error) {
	req, out := c.StartMedicalStreamTranscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

var _ awserr.Error
var _ time.Time

// StartMedicalStreamTranscriptionEventStream provides the event stream handling for the StartMedicalStreamTranscription.
//
// For testing and mocking the event stream this type should be initialized via
// the NewStartMedicalStreamTranscriptionEventStream constructor function. Using the functional options
// to pass in nested mock behavior.
type StartMedicalStreamTranscriptionEventStream struct {

	// Writer is the EventStream writer for the AudioStream
	// events. This value is automatically set by the SDK when the API call is made
	// Use this member when unit testing your code with the SDK to mock out the
	// EventStream Writer.
	//
	// Must not be nil.
	Writer AudioStreamWriter

	inputWriter io.WriteCloser

	// Reader is the EventStream reader for the MedicalTranscriptResultStream
	// events. This value is automatically set by the SDK when the API call is made
	// Use this member when unit testing your code with the SDK to mock out the
	// EventStream Reader.
	//
	// Must not be nil.
	Reader MedicalTranscriptResultStreamReader

	outputReader io.ReadCloser

	done      chan struct{}
	closeOnce sync.Once
	err       *eventstreamapi.OnceError
}

// NewStartMedicalStreamTranscriptionEventStream initializes an StartMedicalStreamTranscriptionEventStream.
// This function should only be used for testing and mocking the StartMedicalStreamTranscriptionEventStream
// stream within your application.
//
// The Writer member must be set before writing events to the stream.
//
// The Reader member must be set before reading events from the stream.
//
//	es := NewStartMedicalStreamTranscriptionEventStream(func(o *StartMedicalStreamTranscriptionEventStream){
//	    es.Writer = myMockStreamWriter
//	    es.Reader = myMockStreamReader
//	})
func NewStartMedicalStreamTranscriptionEventStream(opts ...func(*StartMedicalStreamTranscriptionEventStream)) *StartMedicalStreamTranscriptionEventStream {
	es := &StartMedicalStreamTranscriptionEventStream{
		done: make(chan struct{}),
		err:  eventstreamapi.NewOnceError(),
	}

	for _, fn := range opts {
		fn(es)
	}

	return es
}

func (es *StartMedicalStreamTranscriptionEventStream) runOnStreamPartClose(r *request.Request) {
	if es.done == nil {
		return
	}
	go es.waitStreamPartClose()

}

func (es *StartMedicalStreamTranscriptionEventStream) waitStreamPartClose() {
	var inputErrCh <-chan struct{}
	if v, ok := es.Writer.(interface{ ErrorSet() <-chan struct{} }); ok {
		inputErrCh = v.ErrorSet()
	}
	var outputErrCh <-chan struct{}
	if v, ok := es.Reader.(interface{ ErrorSet() <-chan struct{} }); ok {
		outputErrCh = v.ErrorSet()
	}
	var outputClosedCh <-chan struct{}
	if v, ok := es.Reader.(interface{ Closed() <-chan struct{} }); ok {
		outputClosedCh = v.Closed()
	}

	select {
	case <-es.done:
	case <-inputErrCh:
		es.err.SetError(es.Writer.Err())
		es.Close()
	case <-outputErrCh:
		es.err.SetError(es.Reader.Err())
		es.Close()
	case <-outputClosedCh:
		if err := es.Reader.Err(); err != nil {
			es.err.SetError(es.Reader.Err())
		}
		es.Close()
	}
}

func (es *StartMedicalStreamTranscriptionEventStream) setupInputPipe(r *request.Request) {
	inputReader, inputWriter := io.Pipe()
	r.SetStreamingBody(inputReader)
	es.inputWriter = inputWriter
}

// Closes the input-pipe writer
func (es *StartMedicalStreamTranscriptionEventStream) closeInputPipe() error {
	if es.inputWriter != nil {
		return es.inputWriter.Close()
	}
	return nil
}

// Send writes the event to the stream blocking until the event is written.
// Returns an error if the event was not written.
//
// These events are:
//
//   - AudioEvent
//   - ConfigurationEvent
func (es *StartMedicalStreamTranscriptionEventStream) Send(ctx aws.Context, event AudioStreamEvent) error {
	return es.Writer.Send(ctx, event)
}

func (es *StartMedicalStreamTranscriptionEventStream) runInputStream(r *request.Request) {
	var opts []func(*eventstream.Encoder)
	if r.Config.Logger != nil && r.Config.LogLevel.Matches(aws.LogDebugWithEventStreamBody) {
		opts = append(opts, eventstream.EncodeWithLogger(r.Config.Logger))
	}
	var encoder eventstreamapi.Encoder = eventstream.NewEncoder(es.inputWriter, opts...)

	var closer aws.MultiCloser
	sigSeed, err := v4.GetSignedRequestSignature(r.HTTPRequest)
	if err != nil {
		r.Error = awserr.New(request.ErrCodeSerialization,
			"unable to get initial request's signature", err)
		return
	}
	signer := eventstreamapi.NewSignEncoder(
		v4.NewStreamSigner(r.ClientInfo.SigningRegion, r.ClientInfo.SigningName,
			sigSeed, r.Config.Credentials),
		encoder,
	)
	encoder = signer
	closer = append(closer, signer)
	closer = append(closer, es.inputWriter)

	eventWriter := eventstreamapi.NewEventWriter(encoder,
		protocol.HandlerPayloadMarshal{
			Marshalers: r.Handlers.BuildStream,
		},
		eventTypeForAudioStreamEvent,
	)

	es.Writer = &writeAudioStream{
		StreamWriter: eventstreamapi.NewStreamWriter(eventWriter, closer),
	}
}

// Events returns a channel to read events from.
//
// These events are:
//
//   - MedicalTranscriptEvent
//   - MedicalTranscriptResultStreamUnknownEvent
func (es *StartMedicalStreamTranscriptionEventStream) Events() <-chan MedicalTranscriptResultStreamEvent {
	return es.Reader.Events()
}

func (es *StartMedicalStreamTranscriptionEventStream) runOutputStream(r *request.Request) {
	var opts []func(*eventstream.Decoder)
	if r.Config.Logger != nil && r.Config.LogLevel.Matches(aws.LogDebugWithEventStreamBody) {
		opts = append(opts, eventstream.DecodeWithLogger(r.Config.Logger))
	}

	unmarshalerForEvent := unmarshalerForMedicalTranscriptResultStreamEvent{
		metadata: protocol.ResponseMetadata{
			StatusCode: r.HTTPResponse.StatusCode,
			RequestID:  r.RequestID,
		},
	}.UnmarshalerForEventName

	decoder := eventstream.NewDecoder(r.HTTPResponse.Body, opts...)
	eventReader := eventstreamapi.NewEventReader(decoder,
		protocol.HandlerPayloadUnmarshal{
			Unmarshalers: r.Handlers.UnmarshalStream,
		},
		unmarshalerForEvent,
	)

	es.outputReader = r.HTTPResponse.Body
	es.Reader = newReadMedicalTranscriptResultStream(eventReader)
}

// Close closes the stream. This will also cause the stream to be closed.
// Close must be called when done using the stream API. Not calling Close
// may result in resource leaks.
//
// Will close the underlying EventStream writer, and no more events can be
// sent.
//
// You can use the closing of the Reader's Events channel to terminate your
// application's read from the API's stream.
func (es *StartMedicalStreamTranscriptionEventStream) Close() (err error) {
	es.closeOnce.Do(es.safeClose)
	return es.Err()
}

func (es *StartMedicalStreamTranscriptionEventStream) safeClose() {
	if es.done != nil {
		close(es.done)
	}

	t := time.NewTicker(time.Second)
	defer t.Stop()
	writeCloseDone := make(chan error)
	go func() {
		if err := es.Writer.Close(); err != nil {
			es.err.SetError(err)
		}
		close(writeCloseDone)
	}()
	select {
	case <-t.C:
	case <-writeCloseDone:
	}
	if err := es.closeInputPipe(); err != nil {
		es.err.SetError(err)
	}

	es.Reader.Close()
	if es.outputReader != nil {
		es.outputReader.Close()
	}
}

// Err returns any error that occurred while reading or writing EventStream
// Events from the service API's response. Returns nil if there were no errors.
func (es *StartMedicalStreamTranscriptionEventStream) Err() error {
	if err := es.err.Err(); err != nil {
		return err
	}
	if err := es.Writer.Err(); err != nil {
		return err
	}
	if err := es.Reader.Err(); err != nil {
		return err
	}

	return nil
}

const opStartStreamTranscription = "StartStreamTranscription"

// StartStreamTranscriptionRequest generates a "aws/request.Request" representing the
// client's request for the StartStreamTranscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartStreamTranscription for more information on using the StartStreamTranscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartStreamTranscriptionRequest method.
//	req, resp := client.StartStreamTranscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-streaming-2017-10-26/StartStreamTranscription
func (c *TranscribeStreamingService) StartStreamTranscriptionRequest(input *StartStreamTranscriptionInput) (req *request.Request, output *StartStreamTranscriptionOutput) {
	op := &request.Operation{
		Name:       opStartStreamTranscription,
		HTTPMethod: "POST",
		HTTPPath:   "/stream-transcription",
	}

	if input == nil {
		input = &StartStreamTranscriptionInput{}
	}

	output = &StartStreamTranscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.UnmarshalMeta.PushBack(
		protocol.RequireHTTPMinProtocol{Major: 2}.Handler,
	)

	es := NewStartStreamTranscriptionEventStream()
	output.eventStream = es

	req.Handlers.Sign.PushFront(es.setupInputPipe)
	req.Handlers.UnmarshalError.PushBackNamed(request.NamedHandler{
		Name: "InputPipeCloser",
		Fn: func(r *request.Request) {
			err := es.closeInputPipe()
			if err != nil {
				r.Error = awserr.New(eventstreamapi.InputWriterCloseErrorCode, err.Error(), r.Error)
			}
		},
	})
	req.Handlers.Build.PushBack(request.WithSetRequestHeaders(map[string]string{
		"Content-Type":         "application/vnd.amazon.eventstream",
		"X-Amz-Content-Sha256": "STREAMING-AWS4-HMAC-SHA256-EVENTS",
	}))
	req.Handlers.Build.Swap(restjson.BuildHandler.Name, rest.BuildHandler)
	eventstreamapi.ApplyHTTPTransportFixes(req)
	req.Handlers.Send.Swap(client.LogHTTPRequestHandler.Name, client.LogHTTPRequestHeaderHandler)
	req.Handlers.Unmarshal.PushBack(es.runInputStream)

	req.Handlers.Send.Swap(client.LogHTTPResponseHandler.Name, client.LogHTTPResponseHeaderHandler)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, rest.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBack(es.runOutputStream)
	req.Handlers.Unmarshal.PushBack(es.runOnStreamPartClose)
	return
}

// StartStreamTranscription API operation for Amazon Transcribe Streaming Service.
//
// Starts a bidirectional HTTP/2 or WebSocket stream where audio is streamed
// to Amazon Transcribe and the transcription results are streamed to your application.
//
// The following parameters are required:
//
//   - language-code or identify-language or identify-multiple-language
//
//   - media-encoding
//
//   - sample-rate
//
// For more information on streaming with Amazon Transcribe, see Transcribing
// streaming audio (https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Streaming Service's
// API operation StartStreamTranscription for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     One or more arguments to the StartStreamTranscription, StartMedicalStreamTranscription,
//     or StartCallAnalyticsStreamTranscription operation was not valid. For example,
//     MediaEncoding or LanguageCode used not valid values. Check the specified
//     parameters and try your request again.
//
//   - LimitExceededException
//     Your client has exceeded one of the Amazon Transcribe limits. This is typically
//     the audio length limit. Break your audio stream into smaller chunks and try
//     your request again.
//
//   - InternalFailureException
//     A problem occurred while processing the audio. Amazon Transcribe terminated
//     processing.
//
//   - ConflictException
//     A new stream started with the same session ID. The current stream has been
//     terminated.
//
//   - ServiceUnavailableException
//     The service is currently unavailable. Try your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-streaming-2017-10-26/StartStreamTranscription
func (c *TranscribeStreamingService) StartStreamTranscription(input *StartStreamTranscriptionInput) (*StartStreamTranscriptionOutput, error) {
	req, out := c.StartStreamTranscriptionRequest(input)
	return out, req.Send()
}

// StartStreamTranscriptionWithContext is the same as StartStreamTranscription with the addition of
// the ability to pass a context and additional request options.
//
// See StartStreamTranscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeStreamingService) StartStreamTranscriptionWithContext(ctx aws.Context, input *StartStreamTranscriptionInput, opts ...request.Option) (*StartStreamTranscriptionOutput, error) {
	req, out := c.StartStreamTranscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

var _ awserr.Error
var _ time.Time

// StartStreamTranscriptionEventStream provides the event stream handling for the StartStreamTranscription.
//
// For testing and mocking the event stream this type should be initialized via
// the NewStartStreamTranscriptionEventStream constructor function. Using the functional options
// to pass in nested mock behavior.
type StartStreamTranscriptionEventStream struct {

	// Writer is the EventStream writer for the AudioStream
	// events. This value is automatically set by the SDK when the API call is made
	// Use this member when unit testing your code with the SDK to mock out the
	// EventStream Writer.
	//
	// Must not be nil.
	Writer AudioStreamWriter

	inputWriter io.WriteCloser

	// Reader is the EventStream reader for the TranscriptResultStream
	// events. This value is automatically set by the SDK when the API call is made
	// Use this member when unit testing your code with the SDK to mock out the
	// EventStream Reader.
	//
	// Must not be nil.
	Reader TranscriptResultStreamReader

	outputReader io.ReadCloser

	done      chan struct{}
	closeOnce sync.Once
	err       *eventstreamapi.OnceError
}

// NewStartStreamTranscriptionEventStream initializes an StartStreamTranscriptionEventStream.
// This function should only be used for testing and mocking the StartStreamTranscriptionEventStream
// stream within your application.
//
// The Writer member must be set before writing events to the stream.
//
// The Reader member must be set before reading events from the stream.
//
//	es := NewStartStreamTranscriptionEventStream(func(o *StartStreamTranscriptionEventStream){
//	    es.Writer = myMockStreamWriter
//	    es.Reader = myMockStreamReader
//	})
func NewStartStreamTranscriptionEventStream(opts ...func(*StartStreamTranscriptionEventStream)) *StartStreamTranscriptionEventStream {
	es := &StartStreamTranscriptionEventStream{
		done: make(chan struct{}),
		err:  eventstreamapi.NewOnceError(),
	}

	for _, fn := range opts {
		fn(es)
	}

	return es
}

func (es *StartStreamTranscriptionEventStream) runOnStreamPartClose(r *request.Request) {
	if es.done == nil {
		return
	}
	go es.waitStreamPartClose()

}

func (es *StartStreamTranscriptionEventStream) waitStreamPartClose() {
	var inputErrCh <-chan struct{}
	if v, ok := es.Writer.(interface{ ErrorSet() <-chan struct{} }); ok {
		inputErrCh = v.ErrorSet()
	}
	var outputErrCh <-chan struct{}
	if v, ok := es.Reader.(interface{ ErrorSet() <-chan struct{} }); ok {
		outputErrCh = v.ErrorSet()
	}
	var outputClosedCh <-chan struct{}
	if v, ok := es.Reader.(interface{ Closed() <-chan struct{} }); ok {
		outputClosedCh = v.Closed()
	}

	select {
	case <-es.done:
	case <-inputErrCh:
		es.err.SetError(es.Writer.Err())
		es.Close()
	case <-outputErrCh:
		es.err.SetError(es.Reader.Err())
		es.Close()
	case <-outputClosedCh:
		if err := es.Reader.Err(); err != nil {
			es.err.SetError(es.Reader.Err())
		}
		es.Close()
	}
}

func (es *StartStreamTranscriptionEventStream) setupInputPipe(r *request.Request) {
	inputReader, inputWriter := io.Pipe()
	r.SetStreamingBody(inputReader)
	es.inputWriter = inputWriter
}

// Closes the input-pipe writer
func (es *StartStreamTranscriptionEventStream) closeInputPipe() error {
	if es.inputWriter != nil {
		return es.inputWriter.Close()
	}
	return nil
}

// Send writes the event to the stream blocking until the event is written.
// Returns an error if the event was not written.
//
// These events are:
//
//   - AudioEvent
//   - ConfigurationEvent
func (es *StartStreamTranscriptionEventStream) Send(ctx aws.Context, event AudioStreamEvent) error {
	return es.Writer.Send(ctx, event)
}

func (es *StartStreamTranscriptionEventStream) runInputStream(r *request.Request) {
	var opts []func(*eventstream.Encoder)
	if r.Config.Logger != nil && r.Config.LogLevel.Matches(aws.LogDebugWithEventStreamBody) {
		opts = append(opts, eventstream.EncodeWithLogger(r.Config.Logger))
	}
	var encoder eventstreamapi.Encoder = eventstream.NewEncoder(es.inputWriter, opts...)

	var closer aws.MultiCloser
	sigSeed, err := v4.GetSignedRequestSignature(r.HTTPRequest)
	if err != nil {
		r.Error = awserr.New(request.ErrCodeSerialization,
			"unable to get initial request's signature", err)
		return
	}
	signer := eventstreamapi.NewSignEncoder(
		v4.NewStreamSigner(r.ClientInfo.SigningRegion, r.ClientInfo.SigningName,
			sigSeed, r.Config.Credentials),
		encoder,
	)
	encoder = signer
	closer = append(closer, signer)
	closer = append(closer, es.inputWriter)

	eventWriter := eventstreamapi.NewEventWriter(encoder,
		protocol.HandlerPayloadMarshal{
			Marshalers: r.Handlers.BuildStream,
		},
		eventTypeForAudioStreamEvent,
	)

	es.Writer = &writeAudioStream{
		StreamWriter: eventstreamapi.NewStreamWriter(eventWriter, closer),
	}
}

// Events returns a channel to read events from.
//
// These events are:
//
//   - TranscriptEvent
//   - TranscriptResultStreamUnknownEvent
func (es *StartStreamTranscriptionEventStream) Events() <-chan TranscriptResultStreamEvent {
	return es.Reader.Events()
}

func (es *StartStreamTranscriptionEventStream) runOutputStream(r *request.Request) {
	var opts []func(*eventstream.Decoder)
	if r.Config.Logger != nil && r.Config.LogLevel.Matches(aws.LogDebugWithEventStreamBody) {
		opts = append(opts, eventstream.DecodeWithLogger(r.Config.Logger))
	}

	unmarshalerForEvent := unmarshalerForTranscriptResultStreamEvent{
		metadata: protocol.ResponseMetadata{
			StatusCode: r.HTTPResponse.StatusCode,
			RequestID:  r.RequestID,
		},
	}.UnmarshalerForEventName

	decoder := eventstream.NewDecoder(r.HTTPResponse.Body, opts...)
	eventReader := eventstreamapi.NewEventReader(decoder,
		protocol.HandlerPayloadUnmarshal{
			Unmarshalers: r.Handlers.UnmarshalStream,
		},
		unmarshalerForEvent,
	)

	es.outputReader = r.HTTPResponse.Body
	es.Reader = newReadTranscriptResultStream(eventReader)
}

// Close closes the stream. This will also cause the stream to be closed.
// Close must be called when done using the stream API. Not calling Close
// may result in resource leaks.
//
// Will close the underlying EventStream writer, and no more events can be
// sent.
//
// You can use the closing of the Reader's Events channel to terminate your
// application's read from the API's stream.
func (es *StartStreamTranscriptionEventStream) Close() (err error) {
	es.closeOnce.Do(es.safeClose)
	return es.Err()
}

func (es *StartStreamTranscriptionEventStream) safeClose() {
	if es.done != nil {
		close(es.done)
	}

	t := time.NewTicker(time.Second)
	defer t.Stop()
	writeCloseDone := make(chan error)
	go func() {
		if err := es.Writer.Close(); err != nil {
			es.err.SetError(err)
		}
		close(writeCloseDone)
	}()
	select {
	case <-t.C:
	case <-writeCloseDone:
	}
	if err := es.closeInputPipe(); err != nil {
		es.err.SetError(err)
	}

	es.Reader.Close()
	if es.outputReader != nil {
		es.outputReader.Close()
	}
}

// Err returns any error that occurred while reading or writing EventStream
// Events from the service API's response. Returns nil if there were no errors.
func (es *StartStreamTranscriptionEventStream) Err() error {
	if err := es.err.Err(); err != nil {
		return err
	}
	if err := es.Writer.Err(); err != nil {
		return err
	}
	if err := es.Reader.Err(); err != nil {
		return err
	}

	return nil
}

// A list of possible alternative transcriptions for the input audio. Each alternative
// may contain one or more of Items, Entities, or Transcript.
type Alternative struct {
	_ struct{} `type:"structure"`

	// Contains entities identified as personally identifiable information (PII)
	// in your transcription output.
	Entities []*Entity `type:"list"`

	// Contains words, phrases, or punctuation marks in your transcription output.
	Items []*Item `type:"list"`

	// Contains transcribed text.
	Transcript *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alternative) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alternative) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *Alternative) SetEntities(v []*Entity) *Alternative {
	s.Entities = v
	return s
}

// SetItems sets the Items field's value.
func (s *Alternative) SetItems(v []*Item) *Alternative {
	s.Items = v
	return s
}

// SetTranscript sets the Transcript field's value.
func (s *Alternative) SetTranscript(v string) *Alternative {
	s.Transcript = &v
	return s
}

// A wrapper for your audio chunks. Your audio stream consists of one or more
// audio events, which consist of one or more audio chunks.
//
// For more information, see Event stream encoding (https://docs.aws.amazon.com/transcribe/latest/dg/event-stream.html).
type AudioEvent struct {
	_ struct{} `type:"structure" payload:"AudioChunk"`

	// An audio blob that contains the next part of the audio that you want to transcribe.
	// The maximum audio chunk size is 32 KB.
	// AudioChunk is automatically base64 encoded/decoded by the SDK.
	AudioChunk []byte `type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioEvent) GoString() string {
	return s.String()
}

// SetAudioChunk sets the AudioChunk field's value.
func (s *AudioEvent) SetAudioChunk(v []byte) *AudioEvent {
	s.AudioChunk = v
	return s
}

// The AudioEvent is and event in the AudioStream group of events.
func (s *AudioEvent) eventAudioStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the AudioEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *AudioEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	s.AudioChunk = make([]byte, len(msg.Payload))
	copy(s.AudioChunk, msg.Payload)
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *AudioEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	msg.Headers.Set(":content-type", eventstream.StringValue("application/octet-stream"))
	msg.Payload = s.AudioChunk
	return msg, err
}

// AudioStreamEvent groups together all EventStream
// events writes for AudioStream.
//
// These events are:
//
//   - AudioEvent
//   - ConfigurationEvent
type AudioStreamEvent interface {
	eventAudioStream()
	eventstreamapi.Marshaler
	eventstreamapi.Unmarshaler
}

// AudioStreamWriter provides the interface for writing events to the stream.
// The default implementation for this interface will be AudioStream.
//
// The writer's Close method must allow multiple concurrent calls.
//
// These events are:
//
//   - AudioEvent
//   - ConfigurationEvent
type AudioStreamWriter interface {
	// Sends writes events to the stream blocking until the event has been
	// written. An error is returned if the write fails.
	Send(aws.Context, AudioStreamEvent) error

	// Close will stop the writer writing to the event stream.
	Close() error

	// Returns any error that has occurred while writing to the event stream.
	Err() error
}

type writeAudioStream struct {
	*eventstreamapi.StreamWriter
}

func (w *writeAudioStream) Send(ctx aws.Context, event AudioStreamEvent) error {
	return w.StreamWriter.Send(ctx, event)
}

func eventTypeForAudioStreamEvent(event eventstreamapi.Marshaler) (string, error) {
	switch event.(type) {
	case *AudioEvent:
		return "AudioEvent", nil
	case *ConfigurationEvent:
		return "ConfigurationEvent", nil
	default:
		return "", awserr.New(
			request.ErrCodeSerialization,
			fmt.Sprintf("unknown event type, %T, for AudioStream", event),
			nil,
		)
	}
}

// One or more arguments to the StartStreamTranscription, StartMedicalStreamTranscription,
// or StartCallAnalyticsStreamTranscription operation was not valid. For example,
// MediaEncoding or LanguageCode used not valid values. Check the specified
// parameters and try your request again.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

// The BadRequestException is and event in the CallAnalyticsTranscriptResultStream group of events.
func (s *BadRequestException) eventCallAnalyticsTranscriptResultStream() {}

// The BadRequestException is and event in the MedicalTranscriptResultStream group of events.
func (s *BadRequestException) eventMedicalTranscriptResultStream() {}

// The BadRequestException is and event in the TranscriptResultStream group of events.
func (s *BadRequestException) eventTranscriptResultStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the BadRequestException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *BadRequestException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *BadRequestException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains entities identified as personally identifiable information (PII)
// in your transcription output, along with various associated attributes. Examples
// include category, confidence score, content, type, and start and end times.
type CallAnalyticsEntity struct {
	_ struct{} `type:"structure"`

	// The time, in milliseconds, from the beginning of the audio stream to the
	// start of the identified entity.
	BeginOffsetMillis *int64 `type:"long"`

	// The category of information identified. For example, PII.
	Category *string `type:"string"`

	// The confidence score associated with the identification of an entity in your
	// transcript.
	//
	// Confidence scores are values between 0 and 1. A larger value indicates a
	// higher probability that the identified entity correctly matches the entity
	// spoken in your media.
	Confidence *float64 `type:"double"`

	// The word or words that represent the identified entity.
	Content *string `type:"string"`

	// The time, in milliseconds, from the beginning of the audio stream to the
	// end of the identified entity.
	EndOffsetMillis *int64 `type:"long"`

	// The type of PII identified. For example, NAME or CREDIT_DEBIT_NUMBER.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallAnalyticsEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallAnalyticsEntity) GoString() string {
	return s.String()
}

// SetBeginOffsetMillis sets the BeginOffsetMillis field's value.
func (s *CallAnalyticsEntity) SetBeginOffsetMillis(v int64) *CallAnalyticsEntity {
	s.BeginOffsetMillis = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *CallAnalyticsEntity) SetCategory(v string) *CallAnalyticsEntity {
	s.Category = &v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *CallAnalyticsEntity) SetConfidence(v float64) *CallAnalyticsEntity {
	s.Confidence = &v
	return s
}

// SetContent sets the Content field's value.
func (s *CallAnalyticsEntity) SetContent(v string) *CallAnalyticsEntity {
	s.Content = &v
	return s
}

// SetEndOffsetMillis sets the EndOffsetMillis field's value.
func (s *CallAnalyticsEntity) SetEndOffsetMillis(v int64) *CallAnalyticsEntity {
	s.EndOffsetMillis = &v
	return s
}

// SetType sets the Type field's value.
func (s *CallAnalyticsEntity) SetType(v string) *CallAnalyticsEntity {
	s.Type = &v
	return s
}

// A word, phrase, or punctuation mark in your Call Analytics transcription
// output, along with various associated attributes, such as confidence score,
// type, and start and end times.
type CallAnalyticsItem struct {
	_ struct{} `type:"structure"`

	// The time, in milliseconds, from the beginning of the audio stream to the
	// start of the identified item.
	BeginOffsetMillis *int64 `type:"long"`

	// The confidence score associated with a word or phrase in your transcript.
	//
	// Confidence scores are values between 0 and 1. A larger value indicates a
	// higher probability that the identified item correctly matches the item spoken
	// in your media.
	Confidence *float64 `type:"double"`

	// The word or punctuation that was transcribed.
	Content *string `type:"string"`

	// The time, in milliseconds, from the beginning of the audio stream to the
	// end of the identified item.
	EndOffsetMillis *int64 `type:"long"`

	// If partial result stabilization is enabled, Stable indicates whether the
	// specified item is stable (true) or if it may change when the segment is complete
	// (false).
	Stable *bool `type:"boolean"`

	// The type of item identified. Options are: PRONUNCIATION (spoken words) and
	// PUNCTUATION.
	Type *string `type:"string" enum:"ItemType"`

	// Indicates whether the specified item matches a word in the vocabulary filter
	// included in your Call Analytics request. If true, there is a vocabulary filter
	// match.
	VocabularyFilterMatch *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallAnalyticsItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallAnalyticsItem) GoString() string {
	return s.String()
}

// SetBeginOffsetMillis sets the BeginOffsetMillis field's value.
func (s *CallAnalyticsItem) SetBeginOffsetMillis(v int64) *CallAnalyticsItem {
	s.BeginOffsetMillis = &v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *CallAnalyticsItem) SetConfidence(v float64) *CallAnalyticsItem {
	s.Confidence = &v
	return s
}

// SetContent sets the Content field's value.
func (s *CallAnalyticsItem) SetContent(v string) *CallAnalyticsItem {
	s.Content = &v
	return s
}

// SetEndOffsetMillis sets the EndOffsetMillis field's value.
func (s *CallAnalyticsItem) SetEndOffsetMillis(v int64) *CallAnalyticsItem {
	s.EndOffsetMillis = &v
	return s
}

// SetStable sets the Stable field's value.
func (s *CallAnalyticsItem) SetStable(v bool) *CallAnalyticsItem {
	s.Stable = &v
	return s
}

// SetType sets the Type field's value.
func (s *CallAnalyticsItem) SetType(v string) *CallAnalyticsItem {
	s.Type = &v
	return s
}

// SetVocabularyFilterMatch sets the VocabularyFilterMatch field's value.
func (s *CallAnalyticsItem) SetVocabularyFilterMatch(v bool) *CallAnalyticsItem {
	s.VocabularyFilterMatch = &v
	return s
}

// CallAnalyticsTranscriptResultStreamEvent groups together all EventStream
// events writes for CallAnalyticsTranscriptResultStream.
//
// These events are:
//
//   - CategoryEvent
//   - UtteranceEvent
type CallAnalyticsTranscriptResultStreamEvent interface {
	eventCallAnalyticsTranscriptResultStream()
	eventstreamapi.Marshaler
	eventstreamapi.Unmarshaler
}

// CallAnalyticsTranscriptResultStreamReader provides the interface for reading to the stream. The
// default implementation for this interface will be CallAnalyticsTranscriptResultStream.
//
// The reader's Close method must allow multiple concurrent calls.
//
// These events are:
//
//   - CategoryEvent
//   - UtteranceEvent
//   - CallAnalyticsTranscriptResultStreamUnknownEvent
type CallAnalyticsTranscriptResultStreamReader interface {
	// Returns a channel of events as they are read from the event stream.
	Events() <-chan CallAnalyticsTranscriptResultStreamEvent

	// Close will stop the reader reading events from the stream.
	Close() error

	// Returns any error that has occurred while reading from the event stream.
	Err() error
}

type readCallAnalyticsTranscriptResultStream struct {
	eventReader *eventstreamapi.EventReader
	stream      chan CallAnalyticsTranscriptResultStreamEvent
	err         *eventstreamapi.OnceError

	done      chan struct{}
	closeOnce sync.Once
}

func newReadCallAnalyticsTranscriptResultStream(eventReader *eventstreamapi.EventReader) *readCallAnalyticsTranscriptResultStream {
	r := &readCallAnalyticsTranscriptResultStream{
		eventReader: eventReader,
		stream:      make(chan CallAnalyticsTranscriptResultStreamEvent),
		done:        make(chan struct{}),
		err:         eventstreamapi.NewOnceError(),
	}
	go r.readEventStream()

	return r
}

// Close will close the underlying event stream reader.
func (r *readCallAnalyticsTranscriptResultStream) Close() error {
	r.closeOnce.Do(r.safeClose)
	return r.Err()
}

func (r *readCallAnalyticsTranscriptResultStream) ErrorSet() <-chan struct{} {
	return r.err.ErrorSet()
}

func (r *readCallAnalyticsTranscriptResultStream) Closed() <-chan struct{} {
	return r.done
}

func (r *readCallAnalyticsTranscriptResultStream) safeClose() {
	close(r.done)
}

func (r *readCallAnalyticsTranscriptResultStream) Err() error {
	return r.err.Err()
}

func (r *readCallAnalyticsTranscriptResultStream) Events() <-chan CallAnalyticsTranscriptResultStreamEvent {
	return r.stream
}

func (r *readCallAnalyticsTranscriptResultStream) readEventStream() {
	defer r.Close()
	defer close(r.stream)

	for {
		event, err := r.eventReader.ReadEvent()
		if err != nil {
			if err == io.EOF {
				return
			}
			select {
			case <-r.done:
				// If closed already ignore the error
				return
			default:
			}
			if _, ok := err.(*eventstreamapi.UnknownMessageTypeError); ok {
				continue
			}
			r.err.SetError(err)
			return
		}

		select {
		case r.stream <- event.(CallAnalyticsTranscriptResultStreamEvent):
		case <-r.done:
			return
		}
	}
}

type unmarshalerForCallAnalyticsTranscriptResultStreamEvent struct {
	metadata protocol.ResponseMetadata
}

func (u unmarshalerForCallAnalyticsTranscriptResultStreamEvent) UnmarshalerForEventName(eventType string) (eventstreamapi.Unmarshaler, error) {
	switch eventType {
	case "CategoryEvent":
		return &CategoryEvent{}, nil
	case "UtteranceEvent":
		return &UtteranceEvent{}, nil
	case "BadRequestException":
		return newErrorBadRequestException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "ConflictException":
		return newErrorConflictException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "InternalFailureException":
		return newErrorInternalFailureException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "LimitExceededException":
		return newErrorLimitExceededException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "ServiceUnavailableException":
		return newErrorServiceUnavailableException(u.metadata).(eventstreamapi.Unmarshaler), nil
	default:
		return &CallAnalyticsTranscriptResultStreamUnknownEvent{Type: eventType}, nil
	}
}

// CallAnalyticsTranscriptResultStreamUnknownEvent provides a failsafe event for the
// CallAnalyticsTranscriptResultStream group of events when an unknown event is received.
type CallAnalyticsTranscriptResultStreamUnknownEvent struct {
	Type    string
	Message eventstream.Message
}

// The CallAnalyticsTranscriptResultStreamUnknownEvent is and event in the CallAnalyticsTranscriptResultStream
// group of events.
func (s *CallAnalyticsTranscriptResultStreamUnknownEvent) eventCallAnalyticsTranscriptResultStream() {
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (e *CallAnalyticsTranscriptResultStreamUnknownEvent) MarshalEvent(pm protocol.PayloadMarshaler) (
	msg eventstream.Message, err error,
) {
	return e.Message.Clone(), nil
}

// UnmarshalEvent unmarshals the EventStream Message into the CallAnalyticsTranscriptResultStream value.
// This method is only used internally within the SDK's EventStream handling.
func (e *CallAnalyticsTranscriptResultStreamUnknownEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	e.Message = msg.Clone()
	return nil
}

// Provides information on any TranscriptFilterType categories that matched
// your transcription output. Matches are identified for each segment upon completion
// of that segment.
type CategoryEvent struct {
	_ struct{} `type:"structure"`

	// Lists the categories that were matched in your audio segment.
	MatchedCategories []*string `type:"list"`

	// Contains information about the matched categories, including category names
	// and timestamps.
	MatchedDetails map[string]*PointsOfInterest `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoryEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoryEvent) GoString() string {
	return s.String()
}

// SetMatchedCategories sets the MatchedCategories field's value.
func (s *CategoryEvent) SetMatchedCategories(v []*string) *CategoryEvent {
	s.MatchedCategories = v
	return s
}

// SetMatchedDetails sets the MatchedDetails field's value.
func (s *CategoryEvent) SetMatchedDetails(v map[string]*PointsOfInterest) *CategoryEvent {
	s.MatchedDetails = v
	return s
}

// The CategoryEvent is and event in the CallAnalyticsTranscriptResultStream group of events.
func (s *CategoryEvent) eventCallAnalyticsTranscriptResultStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the CategoryEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *CategoryEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *CategoryEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// Makes it possible to specify which speaker is on which audio channel. For
// example, if your agent is the first participant to speak, you would set ChannelId
// to 0 (to indicate the first channel) and ParticipantRole to AGENT (to indicate
// that it's the agent speaking).
type ChannelDefinition struct {
	_ struct{} `type:"structure"`

	// Specify the audio channel you want to define.
	//
	// ChannelId is a required field
	ChannelId *int64 `type:"integer" required:"true"`

	// Specify the speaker you want to define. Omitting this parameter is equivalent
	// to specifying both participants.
	//
	// ParticipantRole is a required field
	ParticipantRole *string `type:"string" required:"true" enum:"ParticipantRole"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelDefinition) GoString() string {
	return s.String()
}

// SetChannelId sets the ChannelId field's value.
func (s *ChannelDefinition) SetChannelId(v int64) *ChannelDefinition {
	s.ChannelId = &v
	return s
}

// SetParticipantRole sets the ParticipantRole field's value.
func (s *ChannelDefinition) SetParticipantRole(v string) *ChannelDefinition {
	s.ParticipantRole = &v
	return s
}

// Provides the location, using character count, in your transcript where a
// match is identified. For example, the location of an issue or a category
// match within a segment.
type CharacterOffsets struct {
	_ struct{} `type:"structure"`

	// Provides the character count of the first character where a match is identified.
	// For example, the first character associated with an issue or a category match
	// in a segment transcript.
	Begin *int64 `type:"integer"`

	// Provides the character count of the last character where a match is identified.
	// For example, the last character associated with an issue or a category match
	// in a segment transcript.
	End *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CharacterOffsets) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CharacterOffsets) GoString() string {
	return s.String()
}

// SetBegin sets the Begin field's value.
func (s *CharacterOffsets) SetBegin(v int64) *CharacterOffsets {
	s.Begin = &v
	return s
}

// SetEnd sets the End field's value.
func (s *CharacterOffsets) SetEnd(v int64) *CharacterOffsets {
	s.End = &v
	return s
}

// Allows you to set audio channel definitions and post-call analytics settings.
type ConfigurationEvent struct {
	_ struct{} `type:"structure"`

	// Indicates which speaker is on which audio channel.
	ChannelDefinitions []*ChannelDefinition `min:"2" type:"list"`

	// Provides additional optional settings for your Call Analytics post-call request,
	// including encryption and output locations for your redacted and unredacted
	// transcript.
	PostCallAnalyticsSettings *PostCallAnalyticsSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationEvent) GoString() string {
	return s.String()
}

// SetChannelDefinitions sets the ChannelDefinitions field's value.
func (s *ConfigurationEvent) SetChannelDefinitions(v []*ChannelDefinition) *ConfigurationEvent {
	s.ChannelDefinitions = v
	return s
}

// SetPostCallAnalyticsSettings sets the PostCallAnalyticsSettings field's value.
func (s *ConfigurationEvent) SetPostCallAnalyticsSettings(v *PostCallAnalyticsSettings) *ConfigurationEvent {
	s.PostCallAnalyticsSettings = v
	return s
}

// The ConfigurationEvent is and event in the AudioStream group of events.
func (s *ConfigurationEvent) eventAudioStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ConfigurationEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ConfigurationEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ConfigurationEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// A new stream started with the same session ID. The current stream has been
// terminated.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

// The ConflictException is and event in the CallAnalyticsTranscriptResultStream group of events.
func (s *ConflictException) eventCallAnalyticsTranscriptResultStream() {}

// The ConflictException is and event in the MedicalTranscriptResultStream group of events.
func (s *ConflictException) eventMedicalTranscriptResultStream() {}

// The ConflictException is and event in the TranscriptResultStream group of events.
func (s *ConflictException) eventTranscriptResultStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ConflictException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ConflictException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ConflictException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains entities identified as personally identifiable information (PII)
// in your transcription output, along with various associated attributes. Examples
// include category, confidence score, type, stability score, and start and
// end times.
type Entity struct {
	_ struct{} `type:"structure"`

	// The category of information identified. The only category is PII.
	Category *string `type:"string"`

	// The confidence score associated with the identified PII entity in your audio.
	//
	// Confidence scores are values between 0 and 1. A larger value indicates a
	// higher probability that the identified entity correctly matches the entity
	// spoken in your media.
	Confidence *float64 `type:"double"`

	// The word or words identified as PII.
	Content *string `type:"string"`

	// The end time, in milliseconds, of the utterance that was identified as PII.
	EndTime *float64 `type:"double"`

	// The start time, in milliseconds, of the utterance that was identified as
	// PII.
	StartTime *float64 `type:"double"`

	// The type of PII identified. For example, NAME or CREDIT_DEBIT_NUMBER.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Entity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Entity) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *Entity) SetCategory(v string) *Entity {
	s.Category = &v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *Entity) SetConfidence(v float64) *Entity {
	s.Confidence = &v
	return s
}

// SetContent sets the Content field's value.
func (s *Entity) SetContent(v string) *Entity {
	s.Content = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Entity) SetEndTime(v float64) *Entity {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Entity) SetStartTime(v float64) *Entity {
	s.StartTime = &v
	return s
}

// SetType sets the Type field's value.
func (s *Entity) SetType(v string) *Entity {
	s.Type = &v
	return s
}

// A problem occurred while processing the audio. Amazon Transcribe terminated
// processing.
type InternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) GoString() string {
	return s.String()
}

// The InternalFailureException is and event in the CallAnalyticsTranscriptResultStream group of events.
func (s *InternalFailureException) eventCallAnalyticsTranscriptResultStream() {}

// The InternalFailureException is and event in the MedicalTranscriptResultStream group of events.
func (s *InternalFailureException) eventMedicalTranscriptResultStream() {}

// The InternalFailureException is and event in the TranscriptResultStream group of events.
func (s *InternalFailureException) eventTranscriptResultStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the InternalFailureException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *InternalFailureException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *InternalFailureException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorInternalFailureException(v protocol.ResponseMetadata) error {
	return &InternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailureException) Code() string {
	return "InternalFailureException"
}

// Message returns the exception's message.
func (s *InternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailureException) OrigErr() error {
	return nil
}

func (s *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Lists the issues that were identified in your audio segment.
type IssueDetected struct {
	_ struct{} `type:"structure"`

	// Provides the timestamps that identify when in an audio segment the specified
	// issue occurs.
	CharacterOffsets *CharacterOffsets `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IssueDetected) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IssueDetected) GoString() string {
	return s.String()
}

// SetCharacterOffsets sets the CharacterOffsets field's value.
func (s *IssueDetected) SetCharacterOffsets(v *CharacterOffsets) *IssueDetected {
	s.CharacterOffsets = v
	return s
}

// A word, phrase, or punctuation mark in your transcription output, along with
// various associated attributes, such as confidence score, type, and start
// and end times.
type Item struct {
	_ struct{} `type:"structure"`

	// The confidence score associated with a word or phrase in your transcript.
	//
	// Confidence scores are values between 0 and 1. A larger value indicates a
	// higher probability that the identified item correctly matches the item spoken
	// in your media.
	Confidence *float64 `type:"double"`

	// The word or punctuation that was transcribed.
	Content *string `type:"string"`

	// The end time, in milliseconds, of the transcribed item.
	EndTime *float64 `type:"double"`

	// If speaker partitioning is enabled, Speaker labels the speaker of the specified
	// item.
	Speaker *string `type:"string"`

	// If partial result stabilization is enabled, Stable indicates whether the
	// specified item is stable (true) or if it may change when the segment is complete
	// (false).
	Stable *bool `type:"boolean"`

	// The start time, in milliseconds, of the transcribed item.
	StartTime *float64 `type:"double"`

	// The type of item identified. Options are: PRONUNCIATION (spoken words) and
	// PUNCTUATION.
	Type *string `type:"string" enum:"ItemType"`

	// Indicates whether the specified item matches a word in the vocabulary filter
	// included in your request. If true, there is a vocabulary filter match.
	VocabularyFilterMatch *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Item) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Item) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *Item) SetConfidence(v float64) *Item {
	s.Confidence = &v
	return s
}

// SetContent sets the Content field's value.
func (s *Item) SetContent(v string) *Item {
	s.Content = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Item) SetEndTime(v float64) *Item {
	s.EndTime = &v
	return s
}

// SetSpeaker sets the Speaker field's value.
func (s *Item) SetSpeaker(v string) *Item {
	s.Speaker = &v
	return s
}

// SetStable sets the Stable field's value.
func (s *Item) SetStable(v bool) *Item {
	s.Stable = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Item) SetStartTime(v float64) *Item {
	s.StartTime = &v
	return s
}

// SetType sets the Type field's value.
func (s *Item) SetType(v string) *Item {
	s.Type = &v
	return s
}

// SetVocabularyFilterMatch sets the VocabularyFilterMatch field's value.
func (s *Item) SetVocabularyFilterMatch(v bool) *Item {
	s.VocabularyFilterMatch = &v
	return s
}

// The language code that represents the language identified in your audio,
// including the associated confidence score. If you enabled channel identification
// in your request and each channel contained a different language, you will
// have more than one LanguageWithScore result.
type LanguageWithScore struct {
	_ struct{} `type:"structure"`

	// The language code of the identified language.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The confidence score associated with the identified language code. Confidence
	// scores are values between zero and one; larger values indicate a higher confidence
	// in the identified language.
	Score *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LanguageWithScore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LanguageWithScore) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *LanguageWithScore) SetLanguageCode(v string) *LanguageWithScore {
	s.LanguageCode = &v
	return s
}

// SetScore sets the Score field's value.
func (s *LanguageWithScore) SetScore(v float64) *LanguageWithScore {
	s.Score = &v
	return s
}

// Your client has exceeded one of the Amazon Transcribe limits. This is typically
// the audio length limit. Break your audio stream into smaller chunks and try
// your request again.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

// The LimitExceededException is and event in the CallAnalyticsTranscriptResultStream group of events.
func (s *LimitExceededException) eventCallAnalyticsTranscriptResultStream() {}

// The LimitExceededException is and event in the MedicalTranscriptResultStream group of events.
func (s *LimitExceededException) eventMedicalTranscriptResultStream() {}

// The LimitExceededException is and event in the TranscriptResultStream group of events.
func (s *LimitExceededException) eventTranscriptResultStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the LimitExceededException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *LimitExceededException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *LimitExceededException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A list of possible alternative transcriptions for the input audio. Each alternative
// may contain one or more of Items, Entities, or Transcript.
type MedicalAlternative struct {
	_ struct{} `type:"structure"`

	// Contains entities identified as personal health information (PHI) in your
	// transcription output.
	Entities []*MedicalEntity `type:"list"`

	// Contains words, phrases, or punctuation marks in your transcription output.
	Items []*MedicalItem `type:"list"`

	// Contains transcribed text.
	Transcript *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalAlternative) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalAlternative) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *MedicalAlternative) SetEntities(v []*MedicalEntity) *MedicalAlternative {
	s.Entities = v
	return s
}

// SetItems sets the Items field's value.
func (s *MedicalAlternative) SetItems(v []*MedicalItem) *MedicalAlternative {
	s.Items = v
	return s
}

// SetTranscript sets the Transcript field's value.
func (s *MedicalAlternative) SetTranscript(v string) *MedicalAlternative {
	s.Transcript = &v
	return s
}

// Contains entities identified as personal health information (PHI) in your
// transcription output, along with various associated attributes. Examples
// include category, confidence score, type, stability score, and start and
// end times.
type MedicalEntity struct {
	_ struct{} `type:"structure"`

	// The category of information identified. The only category is PHI.
	Category *string `type:"string"`

	// The confidence score associated with the identified PHI entity in your audio.
	//
	// Confidence scores are values between 0 and 1. A larger value indicates a
	// higher probability that the identified entity correctly matches the entity
	// spoken in your media.
	Confidence *float64 `type:"double"`

	// The word or words identified as PHI.
	Content *string `type:"string"`

	// The end time, in milliseconds, of the utterance that was identified as PHI.
	EndTime *float64 `type:"double"`

	// The start time, in milliseconds, of the utterance that was identified as
	// PHI.
	StartTime *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalEntity) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *MedicalEntity) SetCategory(v string) *MedicalEntity {
	s.Category = &v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *MedicalEntity) SetConfidence(v float64) *MedicalEntity {
	s.Confidence = &v
	return s
}

// SetContent sets the Content field's value.
func (s *MedicalEntity) SetContent(v string) *MedicalEntity {
	s.Content = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *MedicalEntity) SetEndTime(v float64) *MedicalEntity {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *MedicalEntity) SetStartTime(v float64) *MedicalEntity {
	s.StartTime = &v
	return s
}

// A word, phrase, or punctuation mark in your transcription output, along with
// various associated attributes, such as confidence score, type, and start
// and end times.
type MedicalItem struct {
	_ struct{} `type:"structure"`

	// The confidence score associated with a word or phrase in your transcript.
	//
	// Confidence scores are values between 0 and 1. A larger value indicates a
	// higher probability that the identified item correctly matches the item spoken
	// in your media.
	Confidence *float64 `type:"double"`

	// The word or punctuation that was transcribed.
	Content *string `type:"string"`

	// The end time, in milliseconds, of the transcribed item.
	EndTime *float64 `type:"double"`

	// If speaker partitioning is enabled, Speaker labels the speaker of the specified
	// item.
	Speaker *string `type:"string"`

	// The start time, in milliseconds, of the transcribed item.
	StartTime *float64 `type:"double"`

	// The type of item identified. Options are: PRONUNCIATION (spoken words) and
	// PUNCTUATION.
	Type *string `type:"string" enum:"ItemType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalItem) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *MedicalItem) SetConfidence(v float64) *MedicalItem {
	s.Confidence = &v
	return s
}

// SetContent sets the Content field's value.
func (s *MedicalItem) SetContent(v string) *MedicalItem {
	s.Content = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *MedicalItem) SetEndTime(v float64) *MedicalItem {
	s.EndTime = &v
	return s
}

// SetSpeaker sets the Speaker field's value.
func (s *MedicalItem) SetSpeaker(v string) *MedicalItem {
	s.Speaker = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *MedicalItem) SetStartTime(v float64) *MedicalItem {
	s.StartTime = &v
	return s
}

// SetType sets the Type field's value.
func (s *MedicalItem) SetType(v string) *MedicalItem {
	s.Type = &v
	return s
}

// The Result associated with a .
//
// Contains a set of transcription results from one or more audio segments,
// along with additional information per your request parameters. This can include
// information relating to alternative transcriptions, channel identification,
// partial result stabilization, language identification, and other transcription-related
// data.
type MedicalResult struct {
	_ struct{} `type:"structure"`

	// A list of possible alternative transcriptions for the input audio. Each alternative
	// may contain one or more of Items, Entities, or Transcript.
	Alternatives []*MedicalAlternative `type:"list"`

	// Indicates the channel identified for the Result.
	ChannelId *string `type:"string"`

	// The end time, in milliseconds, of the Result.
	EndTime *float64 `type:"double"`

	// Indicates if the segment is complete.
	//
	// If IsPartial is true, the segment is not complete. If IsPartial is false,
	// the segment is complete.
	IsPartial *bool `type:"boolean"`

	// Provides a unique identifier for the Result.
	ResultId *string `type:"string"`

	// The start time, in milliseconds, of the Result.
	StartTime *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalResult) GoString() string {
	return s.String()
}

// SetAlternatives sets the Alternatives field's value.
func (s *MedicalResult) SetAlternatives(v []*MedicalAlternative) *MedicalResult {
	s.Alternatives = v
	return s
}

// SetChannelId sets the ChannelId field's value.
func (s *MedicalResult) SetChannelId(v string) *MedicalResult {
	s.ChannelId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *MedicalResult) SetEndTime(v float64) *MedicalResult {
	s.EndTime = &v
	return s
}

// SetIsPartial sets the IsPartial field's value.
func (s *MedicalResult) SetIsPartial(v bool) *MedicalResult {
	s.IsPartial = &v
	return s
}

// SetResultId sets the ResultId field's value.
func (s *MedicalResult) SetResultId(v string) *MedicalResult {
	s.ResultId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *MedicalResult) SetStartTime(v float64) *MedicalResult {
	s.StartTime = &v
	return s
}

// The MedicalTranscript associated with a .
//
// MedicalTranscript contains Results, which contains a set of transcription
// results from one or more audio segments, along with additional information
// per your request parameters.
type MedicalTranscript struct {
	_ struct{} `type:"structure"`

	// Contains a set of transcription results from one or more audio segments,
	// along with additional information per your request parameters. This can include
	// information relating to alternative transcriptions, channel identification,
	// partial result stabilization, language identification, and other transcription-related
	// data.
	Results []*MedicalResult `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscript) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscript) GoString() string {
	return s.String()
}

// SetResults sets the Results field's value.
func (s *MedicalTranscript) SetResults(v []*MedicalResult) *MedicalTranscript {
	s.Results = v
	return s
}

// The MedicalTranscriptEvent associated with a MedicalTranscriptResultStream.
//
// Contains a set of transcription results from one or more audio segments,
// along with additional information per your request parameters.
type MedicalTranscriptEvent struct {
	_ struct{} `type:"structure"`

	// Contains Results, which contains a set of transcription results from one
	// or more audio segments, along with additional information per your request
	// parameters. This can include information relating to alternative transcriptions,
	// channel identification, partial result stabilization, language identification,
	// and other transcription-related data.
	Transcript *MedicalTranscript `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscriptEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscriptEvent) GoString() string {
	return s.String()
}

// SetTranscript sets the Transcript field's value.
func (s *MedicalTranscriptEvent) SetTranscript(v *MedicalTranscript) *MedicalTranscriptEvent {
	s.Transcript = v
	return s
}

// The MedicalTranscriptEvent is and event in the MedicalTranscriptResultStream group of events.
func (s *MedicalTranscriptEvent) eventMedicalTranscriptResultStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the MedicalTranscriptEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *MedicalTranscriptEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *MedicalTranscriptEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// MedicalTranscriptResultStreamEvent groups together all EventStream
// events writes for MedicalTranscriptResultStream.
//
// These events are:
//
//   - MedicalTranscriptEvent
type MedicalTranscriptResultStreamEvent interface {
	eventMedicalTranscriptResultStream()
	eventstreamapi.Marshaler
	eventstreamapi.Unmarshaler
}

// MedicalTranscriptResultStreamReader provides the interface for reading to the stream. The
// default implementation for this interface will be MedicalTranscriptResultStream.
//
// The reader's Close method must allow multiple concurrent calls.
//
// These events are:
//
//   - MedicalTranscriptEvent
//   - MedicalTranscriptResultStreamUnknownEvent
type MedicalTranscriptResultStreamReader interface {
	// Returns a channel of events as they are read from the event stream.
	Events() <-chan MedicalTranscriptResultStreamEvent

	// Close will stop the reader reading events from the stream.
	Close() error

	// Returns any error that has occurred while reading from the event stream.
	Err() error
}

type readMedicalTranscriptResultStream struct {
	eventReader *eventstreamapi.EventReader
	stream      chan MedicalTranscriptResultStreamEvent
	err         *eventstreamapi.OnceError

	done      chan struct{}
	closeOnce sync.Once
}

func newReadMedicalTranscriptResultStream(eventReader *eventstreamapi.EventReader) *readMedicalTranscriptResultStream {
	r := &readMedicalTranscriptResultStream{
		eventReader: eventReader,
		stream:      make(chan MedicalTranscriptResultStreamEvent),
		done:        make(chan struct{}),
		err:         eventstreamapi.NewOnceError(),
	}
	go r.readEventStream()

	return r
}

// Close will close the underlying event stream reader.
func (r *readMedicalTranscriptResultStream) Close() error {
	r.closeOnce.Do(r.safeClose)
	return r.Err()
}

func (r *readMedicalTranscriptResultStream) ErrorSet() <-chan struct{} {
	return r.err.ErrorSet()
}

func (r *readMedicalTranscriptResultStream) Closed() <-chan struct{} {
	return r.done
}

func (r *readMedicalTranscriptResultStream) safeClose() {
	close(r.done)
}

func (r *readMedicalTranscriptResultStream) Err() error {
	return r.err.Err()
}

func (r *readMedicalTranscriptResultStream) Events() <-chan MedicalTranscriptResultStreamEvent {
	return r.stream
}

func (r *readMedicalTranscriptResultStream) readEventStream() {
	defer r.Close()
	defer close(r.stream)

	for {
		event, err := r.eventReader.ReadEvent()
		if err != nil {
			if err == io.EOF {
				return
			}
			select {
			case <-r.done:
				// If closed already ignore the error
				return
			default:
			}
			if _, ok := err.(*eventstreamapi.UnknownMessageTypeError); ok {
				continue
			}
			r.err.SetError(err)
			return
		}

		select {
		case r.stream <- event.(MedicalTranscriptResultStreamEvent):
		case <-r.done:
			return
		}
	}
}

type unmarshalerForMedicalTranscriptResultStreamEvent struct {
	metadata protocol.ResponseMetadata
}

func (u unmarshalerForMedicalTranscriptResultStreamEvent) UnmarshalerForEventName(eventType string) (eventstreamapi.Unmarshaler, error) {
	switch eventType {
	case "TranscriptEvent":
		return &MedicalTranscriptEvent{}, nil
	case "BadRequestException":
		return newErrorBadRequestException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "ConflictException":
		return newErrorConflictException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "InternalFailureException":
		return newErrorInternalFailureException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "LimitExceededException":
		return newErrorLimitExceededException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "ServiceUnavailableException":
		return newErrorServiceUnavailableException(u.metadata).(eventstreamapi.Unmarshaler), nil
	default:
		return &MedicalTranscriptResultStreamUnknownEvent{Type: eventType}, nil
	}
}

// MedicalTranscriptResultStreamUnknownEvent provides a failsafe event for the
// MedicalTranscriptResultStream group of events when an unknown event is received.
type MedicalTranscriptResultStreamUnknownEvent struct {
	Type    string
	Message eventstream.Message
}

// The MedicalTranscriptResultStreamUnknownEvent is and event in the MedicalTranscriptResultStream
// group of events.
func (s *MedicalTranscriptResultStreamUnknownEvent) eventMedicalTranscriptResultStream() {}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (e *MedicalTranscriptResultStreamUnknownEvent) MarshalEvent(pm protocol.PayloadMarshaler) (
	msg eventstream.Message, err error,
) {
	return e.Message.Clone(), nil
}

// UnmarshalEvent unmarshals the EventStream Message into the MedicalTranscriptResultStream value.
// This method is only used internally within the SDK's EventStream handling.
func (e *MedicalTranscriptResultStreamUnknownEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	e.Message = msg.Clone()
	return nil
}

// Contains the timestamps of matched categories.
type PointsOfInterest struct {
	_ struct{} `type:"structure"`

	// Contains the timestamp ranges (start time through end time) of matched categories
	// and rules.
	TimestampRanges []*TimestampRange `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PointsOfInterest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PointsOfInterest) GoString() string {
	return s.String()
}

// SetTimestampRanges sets the TimestampRanges field's value.
func (s *PointsOfInterest) SetTimestampRanges(v []*TimestampRange) *PointsOfInterest {
	s.TimestampRanges = v
	return s
}

// Allows you to specify additional settings for your streaming Call Analytics
// post-call request, including output locations for your redacted and unredacted
// transcript, which IAM role to use, and, optionally, which encryption key
// to use.
//
// ContentRedactionOutput, DataAccessRoleArn, and OutputLocation are required
// fields.
type PostCallAnalyticsSettings struct {
	_ struct{} `type:"structure"`

	// Specify whether you want only a redacted transcript or both a redacted and
	// an unredacted transcript. If you choose redacted and unredacted, two JSON
	// files are generated and stored in the Amazon S3 output location you specify.
	//
	// Note that to include ContentRedactionOutput in your request, you must enable
	// content redaction (ContentRedactionType).
	ContentRedactionOutput *string `type:"string" enum:"ContentRedactionOutput_"`

	// The Amazon Resource Name (ARN) of an IAM role that has permissions to access
	// the Amazon S3 bucket that contains your input files. If the role that you
	// specify doesn’t have the appropriate permissions to access the specified
	// Amazon S3 location, your request fails.
	//
	// IAM role ARNs have the format arn:partition:iam::account:role/role-name-with-path.
	// For example: arn:aws:iam::111122223333:role/Admin. For more information,
	// see IAM ARNs (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `type:"string" required:"true"`

	// The KMS key you want to use to encrypt your Call Analytics post-call output.
	//
	// If using a key located in the current Amazon Web Services account, you can
	// specify your KMS key in one of four ways:
	//
	// Use the KMS key ID itself. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	// Use an alias for the KMS key ID. For example, alias/ExampleAlias.
	//
	// Use the Amazon Resource Name (ARN) for the KMS key ID. For example, arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	// Use the ARN for the KMS key alias. For example, arn:aws:kms:region:account-ID:alias/ExampleAlias.
	//
	// If using a key located in a different Amazon Web Services account than the
	// current Amazon Web Services account, you can specify your KMS key in one
	// of two ways:
	//
	// Use the ARN for the KMS key ID. For example, arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	// Use the ARN for the KMS key alias. For example, arn:aws:kms:region:account-ID:alias/ExampleAlias.
	//
	// Note that the user making the request must have permission to use the specified
	// KMS key.
	OutputEncryptionKMSKeyId *string `type:"string"`

	// The Amazon S3 location where you want your Call Analytics post-call transcription
	// output stored. You can use any of the following formats to specify the output
	// location:
	//
	// s3://DOC-EXAMPLE-BUCKET
	//
	// s3://DOC-EXAMPLE-BUCKET/my-output-folder/
	//
	// s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json
	//
	// OutputLocation is a required field
	OutputLocation *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PostCallAnalyticsSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PostCallAnalyticsSettings) GoString() string {
	return s.String()
}

// SetContentRedactionOutput sets the ContentRedactionOutput field's value.
func (s *PostCallAnalyticsSettings) SetContentRedactionOutput(v string) *PostCallAnalyticsSettings {
	s.ContentRedactionOutput = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *PostCallAnalyticsSettings) SetDataAccessRoleArn(v string) *PostCallAnalyticsSettings {
	s.DataAccessRoleArn = &v
	return s
}

// SetOutputEncryptionKMSKeyId sets the OutputEncryptionKMSKeyId field's value.
func (s *PostCallAnalyticsSettings) SetOutputEncryptionKMSKeyId(v string) *PostCallAnalyticsSettings {
	s.OutputEncryptionKMSKeyId = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *PostCallAnalyticsSettings) SetOutputLocation(v string) *PostCallAnalyticsSettings {
	s.OutputLocation = &v
	return s
}

// The Result associated with a .
//
// Contains a set of transcription results from one or more audio segments,
// along with additional information per your request parameters. This can include
// information relating to alternative transcriptions, channel identification,
// partial result stabilization, language identification, and other transcription-related
// data.
type Result struct {
	_ struct{} `type:"structure"`

	// A list of possible alternative transcriptions for the input audio. Each alternative
	// may contain one or more of Items, Entities, or Transcript.
	Alternatives []*Alternative `type:"list"`

	// Indicates which audio channel is associated with the Result.
	ChannelId *string `type:"string"`

	// The end time, in milliseconds, of the Result.
	EndTime *float64 `type:"double"`

	// Indicates if the segment is complete.
	//
	// If IsPartial is true, the segment is not complete. If IsPartial is false,
	// the segment is complete.
	IsPartial *bool `type:"boolean"`

	// The language code that represents the language spoken in your audio stream.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The language code of the dominant language identified in your stream.
	//
	// If you enabled channel identification and each channel of your audio contains
	// a different language, you may have more than one result.
	LanguageIdentification []*LanguageWithScore `type:"list"`

	// Provides a unique identifier for the Result.
	ResultId *string `type:"string"`

	// The start time, in milliseconds, of the Result.
	StartTime *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Result) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Result) GoString() string {
	return s.String()
}

// SetAlternatives sets the Alternatives field's value.
func (s *Result) SetAlternatives(v []*Alternative) *Result {
	s.Alternatives = v
	return s
}

// SetChannelId sets the ChannelId field's value.
func (s *Result) SetChannelId(v string) *Result {
	s.ChannelId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Result) SetEndTime(v float64) *Result {
	s.EndTime = &v
	return s
}

// SetIsPartial sets the IsPartial field's value.
func (s *Result) SetIsPartial(v bool) *Result {
	s.IsPartial = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *Result) SetLanguageCode(v string) *Result {
	s.LanguageCode = &v
	return s
}

// SetLanguageIdentification sets the LanguageIdentification field's value.
func (s *Result) SetLanguageIdentification(v []*LanguageWithScore) *Result {
	s.LanguageIdentification = v
	return s
}

// SetResultId sets the ResultId field's value.
func (s *Result) SetResultId(v string) *Result {
	s.ResultId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Result) SetStartTime(v float64) *Result {
	s.StartTime = &v
	return s
}

// The service is currently unavailable. Try your request later.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

// The ServiceUnavailableException is and event in the CallAnalyticsTranscriptResultStream group of events.
func (s *ServiceUnavailableException) eventCallAnalyticsTranscriptResultStream() {}

// The ServiceUnavailableException is and event in the MedicalTranscriptResultStream group of events.
func (s *ServiceUnavailableException) eventMedicalTranscriptResultStream() {}

// The ServiceUnavailableException is and event in the TranscriptResultStream group of events.
func (s *ServiceUnavailableException) eventTranscriptResultStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ServiceUnavailableException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ServiceUnavailableException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ServiceUnavailableException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartCallAnalyticsStreamTranscriptionInput struct {
	_ struct{} `type:"structure" payload:"AudioStream"`

	// Labels all personally identifiable information (PII) identified in your transcript.
	//
	// Content identification is performed at the segment level; PII specified in
	// PiiEntityTypes is flagged upon complete transcription of an audio segment.
	//
	// You can’t set ContentIdentificationType and ContentRedactionType in the
	// same request. If you set both, your request returns a BadRequestException.
	//
	// For more information, see Redacting or identifying personally identifiable
	// information (https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html).
	ContentIdentificationType *string `location:"header" locationName:"x-amzn-transcribe-content-identification-type" type:"string" enum:"ContentIdentificationType"`

	// Redacts all personally identifiable information (PII) identified in your
	// transcript.
	//
	// Content redaction is performed at the segment level; PII specified in PiiEntityTypes
	// is redacted upon complete transcription of an audio segment.
	//
	// You can’t set ContentRedactionType and ContentIdentificationType in the
	// same request. If you set both, your request returns a BadRequestException.
	//
	// For more information, see Redacting or identifying personally identifiable
	// information (https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html).
	ContentRedactionType *string `location:"header" locationName:"x-amzn-transcribe-content-redaction-type" type:"string" enum:"ContentRedactionType"`

	// Enables partial result stabilization for your transcription. Partial result
	// stabilization can reduce latency in your output, but may impact accuracy.
	// For more information, see Partial-result stabilization (https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization).
	EnablePartialResultsStabilization *bool `location:"header" locationName:"x-amzn-transcribe-enable-partial-results-stabilization" type:"boolean"`

	// Specify the language code that represents the language spoken in your audio.
	//
	// If you're unsure of the language spoken in your audio, consider using IdentifyLanguage
	// to enable automatic language identification.
	//
	// For a list of languages supported with streaming Call Analytics, refer to
	// the Supported languages (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
	// table.
	//
	// LanguageCode is a required field
	LanguageCode *string `location:"header" locationName:"x-amzn-transcribe-language-code" type:"string" required:"true" enum:"CallAnalyticsLanguageCode"`

	// Specify the name of the custom language model that you want to use when processing
	// your transcription. Note that language model names are case sensitive.
	//
	// The language of the specified language model must match the language code
	// you specify in your transcription request. If the languages don't match,
	// the custom language model isn't applied. There are no errors or warnings
	// associated with a language mismatch.
	//
	// For more information, see Custom language models (https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html).
	LanguageModelName *string `location:"header" locationName:"x-amzn-transcribe-language-model-name" min:"1" type:"string"`

	// Specify the encoding of your input audio. Supported formats are:
	//
	//    * FLAC
	//
	//    * OPUS-encoded audio in an Ogg container
	//
	//    * PCM (only signed 16-bit little-endian audio formats, which does not
	//    include WAV)
	//
	// For more information, see Media formats (https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio).
	//
	// MediaEncoding is a required field
	MediaEncoding *string `location:"header" locationName:"x-amzn-transcribe-media-encoding" type:"string" required:"true" enum:"MediaEncoding"`

	// The sample rate of the input audio (in hertz). Low-quality audio, such as
	// telephone audio, is typically around 8,000 Hz. High-quality audio typically
	// ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify
	// must match that of your audio.
	//
	// MediaSampleRateHertz is a required field
	MediaSampleRateHertz *int64 `location:"header" locationName:"x-amzn-transcribe-sample-rate" min:"8000" type:"integer" required:"true"`

	// Specify the level of stability to use when you enable partial results stabilization
	// (EnablePartialResultsStabilization).
	//
	// Low stability provides the highest accuracy. High stability transcribes faster,
	// but with slightly lower accuracy.
	//
	// For more information, see Partial-result stabilization (https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization).
	PartialResultsStability *string `location:"header" locationName:"x-amzn-transcribe-partial-results-stability" type:"string" enum:"PartialResultsStability"`

	// Specify which types of personally identifiable information (PII) you want
	// to redact in your transcript. You can include as many types as you'd like,
	// or you can select ALL.
	//
	// To include PiiEntityTypes in your Call Analytics request, you must also include
	// either ContentIdentificationType or ContentRedactionType.
	//
	// Values must be comma-separated and can include: BANK_ACCOUNT_NUMBER, BANK_ROUTING,
	// CREDIT_DEBIT_NUMBER, CREDIT_DEBIT_CVV, CREDIT_DEBIT_EXPIRY, PIN, EMAIL, ADDRESS,
	// NAME, PHONE, SSN, or ALL.
	PiiEntityTypes *string `location:"header" locationName:"x-amzn-transcribe-pii-entity-types" min:"1" type:"string"`

	// Specify a name for your Call Analytics transcription session. If you don't
	// include this parameter in your request, Amazon Transcribe generates an ID
	// and returns it in the response.
	//
	// You can use a session ID to retry a streaming session.
	SessionId *string `location:"header" locationName:"x-amzn-transcribe-session-id" min:"36" type:"string"`

	// Specify how you want your vocabulary filter applied to your transcript.
	//
	// To replace words with ***, choose mask.
	//
	// To delete words, choose remove.
	//
	// To flag words without changing them, choose tag.
	VocabularyFilterMethod *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-filter-method" type:"string" enum:"VocabularyFilterMethod"`

	// Specify the name of the custom vocabulary filter that you want to use when
	// processing your transcription. Note that vocabulary filter names are case
	// sensitive.
	//
	// If the language of the specified custom vocabulary filter doesn't match the
	// language identified in your media, the vocabulary filter is not applied to
	// your transcription.
	//
	// For more information, see Using vocabulary filtering with unwanted words
	// (https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html).
	VocabularyFilterName *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-filter-name" min:"1" type:"string"`

	// Specify the name of the custom vocabulary that you want to use when processing
	// your transcription. Note that vocabulary names are case sensitive.
	//
	// If the language of the specified custom vocabulary doesn't match the language
	// identified in your media, the custom vocabulary is not applied to your transcription.
	//
	// For more information, see Custom vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
	VocabularyName *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCallAnalyticsStreamTranscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCallAnalyticsStreamTranscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCallAnalyticsStreamTranscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartCallAnalyticsStreamTranscriptionInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.LanguageModelName != nil && len(*s.LanguageModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageModelName", 1))
	}
	if s.MediaEncoding == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaEncoding"))
	}
	if s.MediaSampleRateHertz == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaSampleRateHertz"))
	}
	if s.MediaSampleRateHertz != nil && *s.MediaSampleRateHertz < 8000 {
		invalidParams.Add(request.NewErrParamMinValue("MediaSampleRateHertz", 8000))
	}
	if s.PiiEntityTypes != nil && len(*s.PiiEntityTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PiiEntityTypes", 1))
	}
	if s.SessionId != nil && len(*s.SessionId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 36))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentIdentificationType sets the ContentIdentificationType field's value.
func (s *StartCallAnalyticsStreamTranscriptionInput) SetContentIdentificationType(v string) *StartCallAnalyticsStreamTranscriptionInput {
	s.ContentIdentificationType = &v
	return s
}

// SetContentRedactionType sets the ContentRedactionType field's value.
func (s *StartCallAnalyticsStreamTranscriptionInput) SetContentRedactionType(v string) *StartCallAnalyticsStreamTranscriptionInput {
	s.ContentRedactionType = &v
	return s
}

// SetEnablePartialResultsStabilization sets the EnablePartialResultsStabilization field's value.
func (s *StartCallAnalyticsStreamTranscriptionInput) SetEnablePartialResultsStabilization(v bool) *StartCallAnalyticsStreamTranscriptionInput {
	s.EnablePartialResultsStabilization = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartCallAnalyticsStreamTranscriptionInput) SetLanguageCode(v string) *StartCallAnalyticsStreamTranscriptionInput {
	s.LanguageCode = &v
	return s
}

// SetLanguageModelName sets the LanguageModelName field's value.
func (s *StartCallAnalyticsStreamTranscriptionInput) SetLanguageModelName(v string) *StartCallAnalyticsStreamTranscriptionInput {
	s.LanguageModelName = &v
	return s
}

// SetMediaEncoding sets the MediaEncoding field's value.
func (s *StartCallAnalyticsStreamTranscriptionInput) SetMediaEncoding(v string) *StartCallAnalyticsStreamTranscriptionInput {
	s.MediaEncoding = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *StartCallAnalyticsStreamTranscriptionInput) SetMediaSampleRateHertz(v int64) *StartCallAnalyticsStreamTranscriptionInput {
	s.MediaSampleRateHertz = &v
	return s
}

// SetPartialResultsStability sets the PartialResultsStability field's value.
func (s *StartCallAnalyticsStreamTranscriptionInput) SetPartialResultsStability(v string) *StartCallAnalyticsStreamTranscriptionInput {
	s.PartialResultsStability = &v
	return s
}

// SetPiiEntityTypes sets the PiiEntityTypes field's value.
func (s *StartCallAnalyticsStreamTranscriptionInput) SetPiiEntityTypes(v string) *StartCallAnalyticsStreamTranscriptionInput {
	s.PiiEntityTypes = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *StartCallAnalyticsStreamTranscriptionInput) SetSessionId(v string) *StartCallAnalyticsStreamTranscriptionInput {
	s.SessionId = &v
	return s
}

// SetVocabularyFilterMethod sets the VocabularyFilterMethod field's value.
func (s *StartCallAnalyticsStreamTranscriptionInput) SetVocabularyFilterMethod(v string) *StartCallAnalyticsStreamTranscriptionInput {
	s.VocabularyFilterMethod = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *StartCallAnalyticsStreamTranscriptionInput) SetVocabularyFilterName(v string) *StartCallAnalyticsStreamTranscriptionInput {
	s.VocabularyFilterName = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *StartCallAnalyticsStreamTranscriptionInput) SetVocabularyName(v string) *StartCallAnalyticsStreamTranscriptionInput {
	s.VocabularyName = &v
	return s
}

type StartCallAnalyticsStreamTranscriptionOutput struct {
	_ struct{} `type:"structure" payload:"CallAnalyticsTranscriptResultStream"`

	eventStream *StartCallAnalyticsStreamTranscriptionEventStream

	// Shows whether content identification was enabled for your Call Analytics
	// transcription.
	ContentIdentificationType *string `location:"header" locationName:"x-amzn-transcribe-content-identification-type" type:"string" enum:"ContentIdentificationType"`

	// Shows whether content redaction was enabled for your Call Analytics transcription.
	ContentRedactionType *string `location:"header" locationName:"x-amzn-transcribe-content-redaction-type" type:"string" enum:"ContentRedactionType"`

	// Shows whether partial results stabilization was enabled for your Call Analytics
	// transcription.
	EnablePartialResultsStabilization *bool `location:"header" locationName:"x-amzn-transcribe-enable-partial-results-stabilization" type:"boolean"`

	// Provides the language code that you specified in your Call Analytics request.
	LanguageCode *string `location:"header" locationName:"x-amzn-transcribe-language-code" type:"string" enum:"CallAnalyticsLanguageCode"`

	// Provides the name of the custom language model that you specified in your
	// Call Analytics request.
	LanguageModelName *string `location:"header" locationName:"x-amzn-transcribe-language-model-name" min:"1" type:"string"`

	// Provides the media encoding you specified in your Call Analytics request.
	MediaEncoding *string `location:"header" locationName:"x-amzn-transcribe-media-encoding" type:"string" enum:"MediaEncoding"`

	// Provides the sample rate that you specified in your Call Analytics request.
	MediaSampleRateHertz *int64 `location:"header" locationName:"x-amzn-transcribe-sample-rate" min:"8000" type:"integer"`

	// Provides the stabilization level used for your transcription.
	PartialResultsStability *string `location:"header" locationName:"x-amzn-transcribe-partial-results-stability" type:"string" enum:"PartialResultsStability"`

	// Lists the PII entity types you specified in your Call Analytics request.
	PiiEntityTypes *string `location:"header" locationName:"x-amzn-transcribe-pii-entity-types" min:"1" type:"string"`

	// Provides the identifier for your Call Analytics streaming request.
	RequestId *string `location:"header" locationName:"x-amzn-request-id" type:"string"`

	// Provides the identifier for your Call Analytics transcription session.
	SessionId *string `location:"header" locationName:"x-amzn-transcribe-session-id" min:"36" type:"string"`

	// Provides the vocabulary filtering method used in your Call Analytics transcription.
	VocabularyFilterMethod *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-filter-method" type:"string" enum:"VocabularyFilterMethod"`

	// Provides the name of the custom vocabulary filter that you specified in your
	// Call Analytics request.
	VocabularyFilterName *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-filter-name" min:"1" type:"string"`

	// Provides the name of the custom vocabulary that you specified in your Call
	// Analytics request.
	VocabularyName *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCallAnalyticsStreamTranscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCallAnalyticsStreamTranscriptionOutput) GoString() string {
	return s.String()
}

// SetContentIdentificationType sets the ContentIdentificationType field's value.
func (s *StartCallAnalyticsStreamTranscriptionOutput) SetContentIdentificationType(v string) *StartCallAnalyticsStreamTranscriptionOutput {
	s.ContentIdentificationType = &v
	return s
}

// SetContentRedactionType sets the ContentRedactionType field's value.
func (s *StartCallAnalyticsStreamTranscriptionOutput) SetContentRedactionType(v string) *StartCallAnalyticsStreamTranscriptionOutput {
	s.ContentRedactionType = &v
	return s
}

// SetEnablePartialResultsStabilization sets the EnablePartialResultsStabilization field's value.
func (s *StartCallAnalyticsStreamTranscriptionOutput) SetEnablePartialResultsStabilization(v bool) *StartCallAnalyticsStreamTranscriptionOutput {
	s.EnablePartialResultsStabilization = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartCallAnalyticsStreamTranscriptionOutput) SetLanguageCode(v string) *StartCallAnalyticsStreamTranscriptionOutput {
	s.LanguageCode = &v
	return s
}

// SetLanguageModelName sets the LanguageModelName field's value.
func (s *StartCallAnalyticsStreamTranscriptionOutput) SetLanguageModelName(v string) *StartCallAnalyticsStreamTranscriptionOutput {
	s.LanguageModelName = &v
	return s
}

// SetMediaEncoding sets the MediaEncoding field's value.
func (s *StartCallAnalyticsStreamTranscriptionOutput) SetMediaEncoding(v string) *StartCallAnalyticsStreamTranscriptionOutput {
	s.MediaEncoding = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *StartCallAnalyticsStreamTranscriptionOutput) SetMediaSampleRateHertz(v int64) *StartCallAnalyticsStreamTranscriptionOutput {
	s.MediaSampleRateHertz = &v
	return s
}

// SetPartialResultsStability sets the PartialResultsStability field's value.
func (s *StartCallAnalyticsStreamTranscriptionOutput) SetPartialResultsStability(v string) *StartCallAnalyticsStreamTranscriptionOutput {
	s.PartialResultsStability = &v
	return s
}

// SetPiiEntityTypes sets the PiiEntityTypes field's value.
func (s *StartCallAnalyticsStreamTranscriptionOutput) SetPiiEntityTypes(v string) *StartCallAnalyticsStreamTranscriptionOutput {
	s.PiiEntityTypes = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *StartCallAnalyticsStreamTranscriptionOutput) SetRequestId(v string) *StartCallAnalyticsStreamTranscriptionOutput {
	s.RequestId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *StartCallAnalyticsStreamTranscriptionOutput) SetSessionId(v string) *StartCallAnalyticsStreamTranscriptionOutput {
	s.SessionId = &v
	return s
}

// SetVocabularyFilterMethod sets the VocabularyFilterMethod field's value.
func (s *StartCallAnalyticsStreamTranscriptionOutput) SetVocabularyFilterMethod(v string) *StartCallAnalyticsStreamTranscriptionOutput {
	s.VocabularyFilterMethod = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *StartCallAnalyticsStreamTranscriptionOutput) SetVocabularyFilterName(v string) *StartCallAnalyticsStreamTranscriptionOutput {
	s.VocabularyFilterName = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *StartCallAnalyticsStreamTranscriptionOutput) SetVocabularyName(v string) *StartCallAnalyticsStreamTranscriptionOutput {
	s.VocabularyName = &v
	return s
}

// GetStream returns the type to interact with the event stream.
func (s *StartCallAnalyticsStreamTranscriptionOutput) GetStream() *StartCallAnalyticsStreamTranscriptionEventStream {
	return s.eventStream
}

type StartMedicalStreamTranscriptionInput struct {
	_ struct{} `type:"structure" payload:"AudioStream"`

	// Labels all personal health information (PHI) identified in your transcript.
	//
	// Content identification is performed at the segment level; PHI is flagged
	// upon complete transcription of an audio segment.
	//
	// For more information, see Identifying personal health information (PHI) in
	// a transcription (https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html).
	ContentIdentificationType *string `location:"header" locationName:"x-amzn-transcribe-content-identification-type" type:"string" enum:"MedicalContentIdentificationType"`

	// Enables channel identification in multi-channel audio.
	//
	// Channel identification transcribes the audio on each channel independently,
	// then appends the output for each channel into one transcript.
	//
	// If you have multi-channel audio and do not enable channel identification,
	// your audio is transcribed in a continuous manner and your transcript is not
	// separated by channel.
	//
	// For more information, see Transcribing multi-channel audio (https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html).
	EnableChannelIdentification *bool `location:"header" locationName:"x-amzn-transcribe-enable-channel-identification" type:"boolean"`

	// Specify the language code that represents the language spoken in your audio.
	//
	// Amazon Transcribe Medical only supports US English (en-US).
	//
	// LanguageCode is a required field
	LanguageCode *string `location:"header" locationName:"x-amzn-transcribe-language-code" type:"string" required:"true" enum:"LanguageCode"`

	// Specify the encoding used for the input audio. Supported formats are:
	//
	//    * FLAC
	//
	//    * OPUS-encoded audio in an Ogg container
	//
	//    * PCM (only signed 16-bit little-endian audio formats, which does not
	//    include WAV)
	//
	// For more information, see Media formats (https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio).
	//
	// MediaEncoding is a required field
	MediaEncoding *string `location:"header" locationName:"x-amzn-transcribe-media-encoding" type:"string" required:"true" enum:"MediaEncoding"`

	// The sample rate of the input audio (in hertz). Amazon Transcribe Medical
	// supports a range from 16,000 Hz to 48,000 Hz. Note that the sample rate you
	// specify must match that of your audio.
	//
	// MediaSampleRateHertz is a required field
	MediaSampleRateHertz *int64 `location:"header" locationName:"x-amzn-transcribe-sample-rate" min:"8000" type:"integer" required:"true"`

	// Specify the number of channels in your audio stream. Up to two channels are
	// supported.
	NumberOfChannels *int64 `location:"header" locationName:"x-amzn-transcribe-number-of-channels" min:"2" type:"integer"`

	// Specify a name for your transcription session. If you don't include this
	// parameter in your request, Amazon Transcribe Medical generates an ID and
	// returns it in the response.
	//
	// You can use a session ID to retry a streaming session.
	SessionId *string `location:"header" locationName:"x-amzn-transcribe-session-id" min:"36" type:"string"`

	// Enables speaker partitioning (diarization) in your transcription output.
	// Speaker partitioning labels the speech from individual speakers in your media
	// file.
	//
	// For more information, see Partitioning speakers (diarization) (https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html).
	ShowSpeakerLabel *bool `location:"header" locationName:"x-amzn-transcribe-show-speaker-label" type:"boolean"`

	// Specify the medical specialty contained in your audio.
	//
	// Specialty is a required field
	Specialty *string `location:"header" locationName:"x-amzn-transcribe-specialty" type:"string" required:"true" enum:"Specialty"`

	// Specify the type of input audio. For example, choose DICTATION for a provider
	// dictating patient notes and CONVERSATION for a dialogue between a patient
	// and a medical professional.
	//
	// Type is a required field
	Type *string `location:"header" locationName:"x-amzn-transcribe-type" type:"string" required:"true" enum:"Type"`

	// Specify the name of the custom vocabulary that you want to use when processing
	// your transcription. Note that vocabulary names are case sensitive.
	VocabularyName *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMedicalStreamTranscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMedicalStreamTranscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMedicalStreamTranscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMedicalStreamTranscriptionInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.MediaEncoding == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaEncoding"))
	}
	if s.MediaSampleRateHertz == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaSampleRateHertz"))
	}
	if s.MediaSampleRateHertz != nil && *s.MediaSampleRateHertz < 8000 {
		invalidParams.Add(request.NewErrParamMinValue("MediaSampleRateHertz", 8000))
	}
	if s.NumberOfChannels != nil && *s.NumberOfChannels < 2 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfChannels", 2))
	}
	if s.SessionId != nil && len(*s.SessionId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 36))
	}
	if s.Specialty == nil {
		invalidParams.Add(request.NewErrParamRequired("Specialty"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentIdentificationType sets the ContentIdentificationType field's value.
func (s *StartMedicalStreamTranscriptionInput) SetContentIdentificationType(v string) *StartMedicalStreamTranscriptionInput {
	s.ContentIdentificationType = &v
	return s
}

// SetEnableChannelIdentification sets the EnableChannelIdentification field's value.
func (s *StartMedicalStreamTranscriptionInput) SetEnableChannelIdentification(v bool) *StartMedicalStreamTranscriptionInput {
	s.EnableChannelIdentification = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartMedicalStreamTranscriptionInput) SetLanguageCode(v string) *StartMedicalStreamTranscriptionInput {
	s.LanguageCode = &v
	return s
}

// SetMediaEncoding sets the MediaEncoding field's value.
func (s *StartMedicalStreamTranscriptionInput) SetMediaEncoding(v string) *StartMedicalStreamTranscriptionInput {
	s.MediaEncoding = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *StartMedicalStreamTranscriptionInput) SetMediaSampleRateHertz(v int64) *StartMedicalStreamTranscriptionInput {
	s.MediaSampleRateHertz = &v
	return s
}

// SetNumberOfChannels sets the NumberOfChannels field's value.
func (s *StartMedicalStreamTranscriptionInput) SetNumberOfChannels(v int64) *StartMedicalStreamTranscriptionInput {
	s.NumberOfChannels = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *StartMedicalStreamTranscriptionInput) SetSessionId(v string) *StartMedicalStreamTranscriptionInput {
	s.SessionId = &v
	return s
}

// SetShowSpeakerLabel sets the ShowSpeakerLabel field's value.
func (s *StartMedicalStreamTranscriptionInput) SetShowSpeakerLabel(v bool) *StartMedicalStreamTranscriptionInput {
	s.ShowSpeakerLabel = &v
	return s
}

// SetSpecialty sets the Specialty field's value.
func (s *StartMedicalStreamTranscriptionInput) SetSpecialty(v string) *StartMedicalStreamTranscriptionInput {
	s.Specialty = &v
	return s
}

// SetType sets the Type field's value.
func (s *StartMedicalStreamTranscriptionInput) SetType(v string) *StartMedicalStreamTranscriptionInput {
	s.Type = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *StartMedicalStreamTranscriptionInput) SetVocabularyName(v string) *StartMedicalStreamTranscriptionInput {
	s.VocabularyName = &v
	return s
}

type StartMedicalStreamTranscriptionOutput struct {
	_ struct{} `type:"structure" payload:"TranscriptResultStream"`

	eventStream *StartMedicalStreamTranscriptionEventStream

	// Shows whether content identification was enabled for your transcription.
	ContentIdentificationType *string `location:"header" locationName:"x-amzn-transcribe-content-identification-type" type:"string" enum:"MedicalContentIdentificationType"`

	// Shows whether channel identification was enabled for your transcription.
	EnableChannelIdentification *bool `location:"header" locationName:"x-amzn-transcribe-enable-channel-identification" type:"boolean"`

	// Provides the language code that you specified in your request. This must
	// be en-US.
	LanguageCode *string `location:"header" locationName:"x-amzn-transcribe-language-code" type:"string" enum:"LanguageCode"`

	// Provides the media encoding you specified in your request.
	MediaEncoding *string `location:"header" locationName:"x-amzn-transcribe-media-encoding" type:"string" enum:"MediaEncoding"`

	// Provides the sample rate that you specified in your request.
	MediaSampleRateHertz *int64 `location:"header" locationName:"x-amzn-transcribe-sample-rate" min:"8000" type:"integer"`

	// Provides the number of channels that you specified in your request.
	NumberOfChannels *int64 `location:"header" locationName:"x-amzn-transcribe-number-of-channels" min:"2" type:"integer"`

	// Provides the identifier for your streaming request.
	RequestId *string `location:"header" locationName:"x-amzn-request-id" type:"string"`

	// Provides the identifier for your transcription session.
	SessionId *string `location:"header" locationName:"x-amzn-transcribe-session-id" min:"36" type:"string"`

	// Shows whether speaker partitioning was enabled for your transcription.
	ShowSpeakerLabel *bool `location:"header" locationName:"x-amzn-transcribe-show-speaker-label" type:"boolean"`

	// Provides the medical specialty that you specified in your request.
	Specialty *string `location:"header" locationName:"x-amzn-transcribe-specialty" type:"string" enum:"Specialty"`

	// Provides the type of audio you specified in your request.
	Type *string `location:"header" locationName:"x-amzn-transcribe-type" type:"string" enum:"Type"`

	// Provides the name of the custom vocabulary that you specified in your request.
	VocabularyName *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMedicalStreamTranscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMedicalStreamTranscriptionOutput) GoString() string {
	return s.String()
}

// SetContentIdentificationType sets the ContentIdentificationType field's value.
func (s *StartMedicalStreamTranscriptionOutput) SetContentIdentificationType(v string) *StartMedicalStreamTranscriptionOutput {
	s.ContentIdentificationType = &v
	return s
}

// SetEnableChannelIdentification sets the EnableChannelIdentification field's value.
func (s *StartMedicalStreamTranscriptionOutput) SetEnableChannelIdentification(v bool) *StartMedicalStreamTranscriptionOutput {
	s.EnableChannelIdentification = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartMedicalStreamTranscriptionOutput) SetLanguageCode(v string) *StartMedicalStreamTranscriptionOutput {
	s.LanguageCode = &v
	return s
}

// SetMediaEncoding sets the MediaEncoding field's value.
func (s *StartMedicalStreamTranscriptionOutput) SetMediaEncoding(v string) *StartMedicalStreamTranscriptionOutput {
	s.MediaEncoding = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *StartMedicalStreamTranscriptionOutput) SetMediaSampleRateHertz(v int64) *StartMedicalStreamTranscriptionOutput {
	s.MediaSampleRateHertz = &v
	return s
}

// SetNumberOfChannels sets the NumberOfChannels field's value.
func (s *StartMedicalStreamTranscriptionOutput) SetNumberOfChannels(v int64) *StartMedicalStreamTranscriptionOutput {
	s.NumberOfChannels = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *StartMedicalStreamTranscriptionOutput) SetRequestId(v string) *StartMedicalStreamTranscriptionOutput {
	s.RequestId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *StartMedicalStreamTranscriptionOutput) SetSessionId(v string) *StartMedicalStreamTranscriptionOutput {
	s.SessionId = &v
	return s
}

// SetShowSpeakerLabel sets the ShowSpeakerLabel field's value.
func (s *StartMedicalStreamTranscriptionOutput) SetShowSpeakerLabel(v bool) *StartMedicalStreamTranscriptionOutput {
	s.ShowSpeakerLabel = &v
	return s
}

// SetSpecialty sets the Specialty field's value.
func (s *StartMedicalStreamTranscriptionOutput) SetSpecialty(v string) *StartMedicalStreamTranscriptionOutput {
	s.Specialty = &v
	return s
}

// SetType sets the Type field's value.
func (s *StartMedicalStreamTranscriptionOutput) SetType(v string) *StartMedicalStreamTranscriptionOutput {
	s.Type = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *StartMedicalStreamTranscriptionOutput) SetVocabularyName(v string) *StartMedicalStreamTranscriptionOutput {
	s.VocabularyName = &v
	return s
}

// GetStream returns the type to interact with the event stream.
func (s *StartMedicalStreamTranscriptionOutput) GetStream() *StartMedicalStreamTranscriptionEventStream {
	return s.eventStream
}

type StartStreamTranscriptionInput struct {
	_ struct{} `type:"structure" payload:"AudioStream"`

	// Labels all personally identifiable information (PII) identified in your transcript.
	//
	// Content identification is performed at the segment level; PII specified in
	// PiiEntityTypes is flagged upon complete transcription of an audio segment.
	//
	// You can’t set ContentIdentificationType and ContentRedactionType in the
	// same request. If you set both, your request returns a BadRequestException.
	//
	// For more information, see Redacting or identifying personally identifiable
	// information (https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html).
	ContentIdentificationType *string `location:"header" locationName:"x-amzn-transcribe-content-identification-type" type:"string" enum:"ContentIdentificationType"`

	// Redacts all personally identifiable information (PII) identified in your
	// transcript.
	//
	// Content redaction is performed at the segment level; PII specified in PiiEntityTypes
	// is redacted upon complete transcription of an audio segment.
	//
	// You can’t set ContentRedactionType and ContentIdentificationType in the
	// same request. If you set both, your request returns a BadRequestException.
	//
	// For more information, see Redacting or identifying personally identifiable
	// information (https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html).
	ContentRedactionType *string `location:"header" locationName:"x-amzn-transcribe-content-redaction-type" type:"string" enum:"ContentRedactionType"`

	// Enables channel identification in multi-channel audio.
	//
	// Channel identification transcribes the audio on each channel independently,
	// then appends the output for each channel into one transcript.
	//
	// If you have multi-channel audio and do not enable channel identification,
	// your audio is transcribed in a continuous manner and your transcript is not
	// separated by channel.
	//
	// For more information, see Transcribing multi-channel audio (https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html).
	EnableChannelIdentification *bool `location:"header" locationName:"x-amzn-transcribe-enable-channel-identification" type:"boolean"`

	// Enables partial result stabilization for your transcription. Partial result
	// stabilization can reduce latency in your output, but may impact accuracy.
	// For more information, see Partial-result stabilization (https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization).
	EnablePartialResultsStabilization *bool `location:"header" locationName:"x-amzn-transcribe-enable-partial-results-stabilization" type:"boolean"`

	// Enables automatic language identification for your transcription.
	//
	// If you include IdentifyLanguage, you can optionally include a list of language
	// codes, using LanguageOptions, that you think may be present in your audio
	// stream. Including language options can improve transcription accuracy.
	//
	// You can also include a preferred language using PreferredLanguage. Adding
	// a preferred language can help Amazon Transcribe identify the language faster
	// than if you omit this parameter.
	//
	// If you have multi-channel audio that contains different languages on each
	// channel, and you've enabled channel identification, automatic language identification
	// identifies the dominant language on each audio channel.
	//
	// Note that you must include either LanguageCode or IdentifyLanguage or IdentifyMultipleLanguages
	// in your request. If you include more than one of these parameters, your transcription
	// job fails.
	//
	// Streaming language identification can't be combined with custom language
	// models or redaction.
	IdentifyLanguage *bool `location:"header" locationName:"x-amzn-transcribe-identify-language" type:"boolean"`

	// Enables automatic multi-language identification in your transcription job
	// request. Use this parameter if your stream contains more than one language.
	// If your stream contains only one language, use IdentifyLanguage instead.
	//
	// If you include IdentifyMultipleLanguages, you can optionally include a list
	// of language codes, using LanguageOptions, that you think may be present in
	// your stream. Including LanguageOptions restricts IdentifyMultipleLanguages
	// to only the language options that you specify, which can improve transcription
	// accuracy.
	//
	// If you want to apply a custom vocabulary or a custom vocabulary filter to
	// your automatic multiple language identification request, include VocabularyNames
	// or VocabularyFilterNames.
	//
	// Note that you must include one of LanguageCode, IdentifyLanguage, or IdentifyMultipleLanguages
	// in your request. If you include more than one of these parameters, your transcription
	// job fails.
	IdentifyMultipleLanguages *bool `location:"header" locationName:"x-amzn-transcribe-identify-multiple-languages" type:"boolean"`

	// Specify the language code that represents the language spoken in your audio.
	//
	// If you're unsure of the language spoken in your audio, consider using IdentifyLanguage
	// to enable automatic language identification.
	//
	// For a list of languages supported with Amazon Transcribe streaming, refer
	// to the Supported languages (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
	// table.
	LanguageCode *string `location:"header" locationName:"x-amzn-transcribe-language-code" type:"string" enum:"LanguageCode"`

	// Specify the name of the custom language model that you want to use when processing
	// your transcription. Note that language model names are case sensitive.
	//
	// The language of the specified language model must match the language code
	// you specify in your transcription request. If the languages don't match,
	// the custom language model isn't applied. There are no errors or warnings
	// associated with a language mismatch.
	//
	// For more information, see Custom language models (https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html).
	LanguageModelName *string `location:"header" locationName:"x-amzn-transcribe-language-model-name" min:"1" type:"string"`

	// Specify two or more language codes that represent the languages you think
	// may be present in your media; including more than five is not recommended.
	// If you're unsure what languages are present, do not include this parameter.
	//
	// Including language options can improve the accuracy of language identification.
	//
	// If you include LanguageOptions in your request, you must also include IdentifyLanguage.
	//
	// For a list of languages supported with Amazon Transcribe streaming, refer
	// to the Supported languages (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
	// table.
	//
	// You can only include one language dialect per language per stream. For example,
	// you cannot include en-US and en-AU in the same request.
	LanguageOptions *string `location:"header" locationName:"x-amzn-transcribe-language-options" min:"1" type:"string"`

	// Specify the encoding of your input audio. Supported formats are:
	//
	//    * FLAC
	//
	//    * OPUS-encoded audio in an Ogg container
	//
	//    * PCM (only signed 16-bit little-endian audio formats, which does not
	//    include WAV)
	//
	// For more information, see Media formats (https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio).
	//
	// MediaEncoding is a required field
	MediaEncoding *string `location:"header" locationName:"x-amzn-transcribe-media-encoding" type:"string" required:"true" enum:"MediaEncoding"`

	// The sample rate of the input audio (in hertz). Low-quality audio, such as
	// telephone audio, is typically around 8,000 Hz. High-quality audio typically
	// ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify
	// must match that of your audio.
	//
	// MediaSampleRateHertz is a required field
	MediaSampleRateHertz *int64 `location:"header" locationName:"x-amzn-transcribe-sample-rate" min:"8000" type:"integer" required:"true"`

	// Specify the number of channels in your audio stream. Up to two channels are
	// supported.
	NumberOfChannels *int64 `location:"header" locationName:"x-amzn-transcribe-number-of-channels" min:"2" type:"integer"`

	// Specify the level of stability to use when you enable partial results stabilization
	// (EnablePartialResultsStabilization).
	//
	// Low stability provides the highest accuracy. High stability transcribes faster,
	// but with slightly lower accuracy.
	//
	// For more information, see Partial-result stabilization (https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization).
	PartialResultsStability *string `location:"header" locationName:"x-amzn-transcribe-partial-results-stability" type:"string" enum:"PartialResultsStability"`

	// Specify which types of personally identifiable information (PII) you want
	// to redact in your transcript. You can include as many types as you'd like,
	// or you can select ALL.
	//
	// To include PiiEntityTypes in your request, you must also include either ContentIdentificationType
	// or ContentRedactionType.
	//
	// Values must be comma-separated and can include: BANK_ACCOUNT_NUMBER, BANK_ROUTING,
	// CREDIT_DEBIT_NUMBER, CREDIT_DEBIT_CVV, CREDIT_DEBIT_EXPIRY, PIN, EMAIL, ADDRESS,
	// NAME, PHONE, SSN, or ALL.
	PiiEntityTypes *string `location:"header" locationName:"x-amzn-transcribe-pii-entity-types" min:"1" type:"string"`

	// Specify a preferred language from the subset of languages codes you specified
	// in LanguageOptions.
	//
	// You can only use this parameter if you've included IdentifyLanguage and LanguageOptions
	// in your request.
	PreferredLanguage *string `location:"header" locationName:"x-amzn-transcribe-preferred-language" type:"string" enum:"LanguageCode"`

	// Specify a name for your transcription session. If you don't include this
	// parameter in your request, Amazon Transcribe generates an ID and returns
	// it in the response.
	//
	// You can use a session ID to retry a streaming session.
	SessionId *string `location:"header" locationName:"x-amzn-transcribe-session-id" min:"36" type:"string"`

	// Enables speaker partitioning (diarization) in your transcription output.
	// Speaker partitioning labels the speech from individual speakers in your media
	// file.
	//
	// For more information, see Partitioning speakers (diarization) (https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html).
	ShowSpeakerLabel *bool `location:"header" locationName:"x-amzn-transcribe-show-speaker-label" type:"boolean"`

	// Specify how you want your vocabulary filter applied to your transcript.
	//
	// To replace words with ***, choose mask.
	//
	// To delete words, choose remove.
	//
	// To flag words without changing them, choose tag.
	VocabularyFilterMethod *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-filter-method" type:"string" enum:"VocabularyFilterMethod"`

	// Specify the name of the custom vocabulary filter that you want to use when
	// processing your transcription. Note that vocabulary filter names are case
	// sensitive.
	//
	// If the language of the specified custom vocabulary filter doesn't match the
	// language identified in your media, the vocabulary filter is not applied to
	// your transcription.
	//
	// This parameter is not intended for use with the IdentifyLanguage parameter.
	// If you're including IdentifyLanguage in your request and want to use one
	// or more vocabulary filters with your transcription, use the VocabularyFilterNames
	// parameter instead.
	//
	// For more information, see Using vocabulary filtering with unwanted words
	// (https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html).
	VocabularyFilterName *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-filter-name" min:"1" type:"string"`

	// Specify the names of the custom vocabulary filters that you want to use when
	// processing your transcription. Note that vocabulary filter names are case
	// sensitive.
	//
	// If none of the languages of the specified custom vocabulary filters match
	// the language identified in your media, your job fails.
	//
	// This parameter is only intended for use with the IdentifyLanguage parameter.
	// If you're not including IdentifyLanguage in your request and want to use
	// a custom vocabulary filter with your transcription, use the VocabularyFilterName
	// parameter instead.
	//
	// For more information, see Using vocabulary filtering with unwanted words
	// (https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html).
	VocabularyFilterNames *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-filter-names" min:"1" type:"string"`

	// Specify the name of the custom vocabulary that you want to use when processing
	// your transcription. Note that vocabulary names are case sensitive.
	//
	// If the language of the specified custom vocabulary doesn't match the language
	// identified in your media, the custom vocabulary is not applied to your transcription.
	//
	// This parameter is not intended for use with the IdentifyLanguage parameter.
	// If you're including IdentifyLanguage in your request and want to use one
	// or more custom vocabularies with your transcription, use the VocabularyNames
	// parameter instead.
	//
	// For more information, see Custom vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
	VocabularyName *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-name" min:"1" type:"string"`

	// Specify the names of the custom vocabularies that you want to use when processing
	// your transcription. Note that vocabulary names are case sensitive.
	//
	// If none of the languages of the specified custom vocabularies match the language
	// identified in your media, your job fails.
	//
	// This parameter is only intended for use with the IdentifyLanguage parameter.
	// If you're not including IdentifyLanguage in your request and want to use
	// a custom vocabulary with your transcription, use the VocabularyName parameter
	// instead.
	//
	// For more information, see Custom vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
	VocabularyNames *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-names" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStreamTranscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStreamTranscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartStreamTranscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartStreamTranscriptionInput"}
	if s.LanguageModelName != nil && len(*s.LanguageModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageModelName", 1))
	}
	if s.LanguageOptions != nil && len(*s.LanguageOptions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageOptions", 1))
	}
	if s.MediaEncoding == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaEncoding"))
	}
	if s.MediaSampleRateHertz == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaSampleRateHertz"))
	}
	if s.MediaSampleRateHertz != nil && *s.MediaSampleRateHertz < 8000 {
		invalidParams.Add(request.NewErrParamMinValue("MediaSampleRateHertz", 8000))
	}
	if s.NumberOfChannels != nil && *s.NumberOfChannels < 2 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfChannels", 2))
	}
	if s.PiiEntityTypes != nil && len(*s.PiiEntityTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PiiEntityTypes", 1))
	}
	if s.SessionId != nil && len(*s.SessionId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 36))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}
	if s.VocabularyFilterNames != nil && len(*s.VocabularyFilterNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterNames", 1))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}
	if s.VocabularyNames != nil && len(*s.VocabularyNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentIdentificationType sets the ContentIdentificationType field's value.
func (s *StartStreamTranscriptionInput) SetContentIdentificationType(v string) *StartStreamTranscriptionInput {
	s.ContentIdentificationType = &v
	return s
}

// SetContentRedactionType sets the ContentRedactionType field's value.
func (s *StartStreamTranscriptionInput) SetContentRedactionType(v string) *StartStreamTranscriptionInput {
	s.ContentRedactionType = &v
	return s
}

// SetEnableChannelIdentification sets the EnableChannelIdentification field's value.
func (s *StartStreamTranscriptionInput) SetEnableChannelIdentification(v bool) *StartStreamTranscriptionInput {
	s.EnableChannelIdentification = &v
	return s
}

// SetEnablePartialResultsStabilization sets the EnablePartialResultsStabilization field's value.
func (s *StartStreamTranscriptionInput) SetEnablePartialResultsStabilization(v bool) *StartStreamTranscriptionInput {
	s.EnablePartialResultsStabilization = &v
	return s
}

// SetIdentifyLanguage sets the IdentifyLanguage field's value.
func (s *StartStreamTranscriptionInput) SetIdentifyLanguage(v bool) *StartStreamTranscriptionInput {
	s.IdentifyLanguage = &v
	return s
}

// SetIdentifyMultipleLanguages sets the IdentifyMultipleLanguages field's value.
func (s *StartStreamTranscriptionInput) SetIdentifyMultipleLanguages(v bool) *StartStreamTranscriptionInput {
	s.IdentifyMultipleLanguages = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartStreamTranscriptionInput) SetLanguageCode(v string) *StartStreamTranscriptionInput {
	s.LanguageCode = &v
	return s
}

// SetLanguageModelName sets the LanguageModelName field's value.
func (s *StartStreamTranscriptionInput) SetLanguageModelName(v string) *StartStreamTranscriptionInput {
	s.LanguageModelName = &v
	return s
}

// SetLanguageOptions sets the LanguageOptions field's value.
func (s *StartStreamTranscriptionInput) SetLanguageOptions(v string) *StartStreamTranscriptionInput {
	s.LanguageOptions = &v
	return s
}

// SetMediaEncoding sets the MediaEncoding field's value.
func (s *StartStreamTranscriptionInput) SetMediaEncoding(v string) *StartStreamTranscriptionInput {
	s.MediaEncoding = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *StartStreamTranscriptionInput) SetMediaSampleRateHertz(v int64) *StartStreamTranscriptionInput {
	s.MediaSampleRateHertz = &v
	return s
}

// SetNumberOfChannels sets the NumberOfChannels field's value.
func (s *StartStreamTranscriptionInput) SetNumberOfChannels(v int64) *StartStreamTranscriptionInput {
	s.NumberOfChannels = &v
	return s
}

// SetPartialResultsStability sets the PartialResultsStability field's value.
func (s *StartStreamTranscriptionInput) SetPartialResultsStability(v string) *StartStreamTranscriptionInput {
	s.PartialResultsStability = &v
	return s
}

// SetPiiEntityTypes sets the PiiEntityTypes field's value.
func (s *StartStreamTranscriptionInput) SetPiiEntityTypes(v string) *StartStreamTranscriptionInput {
	s.PiiEntityTypes = &v
	return s
}

// SetPreferredLanguage sets the PreferredLanguage field's value.
func (s *StartStreamTranscriptionInput) SetPreferredLanguage(v string) *StartStreamTranscriptionInput {
	s.PreferredLanguage = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *StartStreamTranscriptionInput) SetSessionId(v string) *StartStreamTranscriptionInput {
	s.SessionId = &v
	return s
}

// SetShowSpeakerLabel sets the ShowSpeakerLabel field's value.
func (s *StartStreamTranscriptionInput) SetShowSpeakerLabel(v bool) *StartStreamTranscriptionInput {
	s.ShowSpeakerLabel = &v
	return s
}

// SetVocabularyFilterMethod sets the VocabularyFilterMethod field's value.
func (s *StartStreamTranscriptionInput) SetVocabularyFilterMethod(v string) *StartStreamTranscriptionInput {
	s.VocabularyFilterMethod = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *StartStreamTranscriptionInput) SetVocabularyFilterName(v string) *StartStreamTranscriptionInput {
	s.VocabularyFilterName = &v
	return s
}

// SetVocabularyFilterNames sets the VocabularyFilterNames field's value.
func (s *StartStreamTranscriptionInput) SetVocabularyFilterNames(v string) *StartStreamTranscriptionInput {
	s.VocabularyFilterNames = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *StartStreamTranscriptionInput) SetVocabularyName(v string) *StartStreamTranscriptionInput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyNames sets the VocabularyNames field's value.
func (s *StartStreamTranscriptionInput) SetVocabularyNames(v string) *StartStreamTranscriptionInput {
	s.VocabularyNames = &v
	return s
}

type StartStreamTranscriptionOutput struct {
	_ struct{} `type:"structure" payload:"TranscriptResultStream"`

	eventStream *StartStreamTranscriptionEventStream

	// Shows whether content identification was enabled for your transcription.
	ContentIdentificationType *string `location:"header" locationName:"x-amzn-transcribe-content-identification-type" type:"string" enum:"ContentIdentificationType"`

	// Shows whether content redaction was enabled for your transcription.
	ContentRedactionType *string `location:"header" locationName:"x-amzn-transcribe-content-redaction-type" type:"string" enum:"ContentRedactionType"`

	// Shows whether channel identification was enabled for your transcription.
	EnableChannelIdentification *bool `location:"header" locationName:"x-amzn-transcribe-enable-channel-identification" type:"boolean"`

	// Shows whether partial results stabilization was enabled for your transcription.
	EnablePartialResultsStabilization *bool `location:"header" locationName:"x-amzn-transcribe-enable-partial-results-stabilization" type:"boolean"`

	// Shows whether automatic language identification was enabled for your transcription.
	IdentifyLanguage *bool `location:"header" locationName:"x-amzn-transcribe-identify-language" type:"boolean"`

	// Shows whether automatic multi-language identification was enabled for your
	// transcription.
	IdentifyMultipleLanguages *bool `location:"header" locationName:"x-amzn-transcribe-identify-multiple-languages" type:"boolean"`

	// Provides the language code that you specified in your request.
	LanguageCode *string `location:"header" locationName:"x-amzn-transcribe-language-code" type:"string" enum:"LanguageCode"`

	// Provides the name of the custom language model that you specified in your
	// request.
	LanguageModelName *string `location:"header" locationName:"x-amzn-transcribe-language-model-name" min:"1" type:"string"`

	// Provides the language codes that you specified in your request.
	LanguageOptions *string `location:"header" locationName:"x-amzn-transcribe-language-options" min:"1" type:"string"`

	// Provides the media encoding you specified in your request.
	MediaEncoding *string `location:"header" locationName:"x-amzn-transcribe-media-encoding" type:"string" enum:"MediaEncoding"`

	// Provides the sample rate that you specified in your request.
	MediaSampleRateHertz *int64 `location:"header" locationName:"x-amzn-transcribe-sample-rate" min:"8000" type:"integer"`

	// Provides the number of channels that you specified in your request.
	NumberOfChannels *int64 `location:"header" locationName:"x-amzn-transcribe-number-of-channels" min:"2" type:"integer"`

	// Provides the stabilization level used for your transcription.
	PartialResultsStability *string `location:"header" locationName:"x-amzn-transcribe-partial-results-stability" type:"string" enum:"PartialResultsStability"`

	// Lists the PII entity types you specified in your request.
	PiiEntityTypes *string `location:"header" locationName:"x-amzn-transcribe-pii-entity-types" min:"1" type:"string"`

	// Provides the preferred language that you specified in your request.
	PreferredLanguage *string `location:"header" locationName:"x-amzn-transcribe-preferred-language" type:"string" enum:"LanguageCode"`

	// Provides the identifier for your streaming request.
	RequestId *string `location:"header" locationName:"x-amzn-request-id" type:"string"`

	// Provides the identifier for your transcription session.
	SessionId *string `location:"header" locationName:"x-amzn-transcribe-session-id" min:"36" type:"string"`

	// Shows whether speaker partitioning was enabled for your transcription.
	ShowSpeakerLabel *bool `location:"header" locationName:"x-amzn-transcribe-show-speaker-label" type:"boolean"`

	// Provides the vocabulary filtering method used in your transcription.
	VocabularyFilterMethod *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-filter-method" type:"string" enum:"VocabularyFilterMethod"`

	// Provides the name of the custom vocabulary filter that you specified in your
	// request.
	VocabularyFilterName *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-filter-name" min:"1" type:"string"`

	// Provides the names of the custom vocabulary filters that you specified in
	// your request.
	VocabularyFilterNames *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-filter-names" min:"1" type:"string"`

	// Provides the name of the custom vocabulary that you specified in your request.
	VocabularyName *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-name" min:"1" type:"string"`

	// Provides the names of the custom vocabularies that you specified in your
	// request.
	VocabularyNames *string `location:"header" locationName:"x-amzn-transcribe-vocabulary-names" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStreamTranscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStreamTranscriptionOutput) GoString() string {
	return s.String()
}

// SetContentIdentificationType sets the ContentIdentificationType field's value.
func (s *StartStreamTranscriptionOutput) SetContentIdentificationType(v string) *StartStreamTranscriptionOutput {
	s.ContentIdentificationType = &v
	return s
}

// SetContentRedactionType sets the ContentRedactionType field's value.
func (s *StartStreamTranscriptionOutput) SetContentRedactionType(v string) *StartStreamTranscriptionOutput {
	s.ContentRedactionType = &v
	return s
}

// SetEnableChannelIdentification sets the EnableChannelIdentification field's value.
func (s *StartStreamTranscriptionOutput) SetEnableChannelIdentification(v bool) *StartStreamTranscriptionOutput {
	s.EnableChannelIdentification = &v
	return s
}

// SetEnablePartialResultsStabilization sets the EnablePartialResultsStabilization field's value.
func (s *StartStreamTranscriptionOutput) SetEnablePartialResultsStabilization(v bool) *StartStreamTranscriptionOutput {
	s.EnablePartialResultsStabilization = &v
	return s
}

// SetIdentifyLanguage sets the IdentifyLanguage field's value.
func (s *StartStreamTranscriptionOutput) SetIdentifyLanguage(v bool) *StartStreamTranscriptionOutput {
	s.IdentifyLanguage = &v
	return s
}

// SetIdentifyMultipleLanguages sets the IdentifyMultipleLanguages field's value.
func (s *StartStreamTranscriptionOutput) SetIdentifyMultipleLanguages(v bool) *StartStreamTranscriptionOutput {
	s.IdentifyMultipleLanguages = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartStreamTranscriptionOutput) SetLanguageCode(v string) *StartStreamTranscriptionOutput {
	s.LanguageCode = &v
	return s
}

// SetLanguageModelName sets the LanguageModelName field's value.
func (s *StartStreamTranscriptionOutput) SetLanguageModelName(v string) *StartStreamTranscriptionOutput {
	s.LanguageModelName = &v
	return s
}

// SetLanguageOptions sets the LanguageOptions field's value.
func (s *StartStreamTranscriptionOutput) SetLanguageOptions(v string) *StartStreamTranscriptionOutput {
	s.LanguageOptions = &v
	return s
}

// SetMediaEncoding sets the MediaEncoding field's value.
func (s *StartStreamTranscriptionOutput) SetMediaEncoding(v string) *StartStreamTranscriptionOutput {
	s.MediaEncoding = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *StartStreamTranscriptionOutput) SetMediaSampleRateHertz(v int64) *StartStreamTranscriptionOutput {
	s.MediaSampleRateHertz = &v
	return s
}

// SetNumberOfChannels sets the NumberOfChannels field's value.
func (s *StartStreamTranscriptionOutput) SetNumberOfChannels(v int64) *StartStreamTranscriptionOutput {
	s.NumberOfChannels = &v
	return s
}

// SetPartialResultsStability sets the PartialResultsStability field's value.
func (s *StartStreamTranscriptionOutput) SetPartialResultsStability(v string) *StartStreamTranscriptionOutput {
	s.PartialResultsStability = &v
	return s
}

// SetPiiEntityTypes sets the PiiEntityTypes field's value.
func (s *StartStreamTranscriptionOutput) SetPiiEntityTypes(v string) *StartStreamTranscriptionOutput {
	s.PiiEntityTypes = &v
	return s
}

// SetPreferredLanguage sets the PreferredLanguage field's value.
func (s *StartStreamTranscriptionOutput) SetPreferredLanguage(v string) *StartStreamTranscriptionOutput {
	s.PreferredLanguage = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *StartStreamTranscriptionOutput) SetRequestId(v string) *StartStreamTranscriptionOutput {
	s.RequestId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *StartStreamTranscriptionOutput) SetSessionId(v string) *StartStreamTranscriptionOutput {
	s.SessionId = &v
	return s
}

// SetShowSpeakerLabel sets the ShowSpeakerLabel field's value.
func (s *StartStreamTranscriptionOutput) SetShowSpeakerLabel(v bool) *StartStreamTranscriptionOutput {
	s.ShowSpeakerLabel = &v
	return s
}

// SetVocabularyFilterMethod sets the VocabularyFilterMethod field's value.
func (s *StartStreamTranscriptionOutput) SetVocabularyFilterMethod(v string) *StartStreamTranscriptionOutput {
	s.VocabularyFilterMethod = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *StartStreamTranscriptionOutput) SetVocabularyFilterName(v string) *StartStreamTranscriptionOutput {
	s.VocabularyFilterName = &v
	return s
}

// SetVocabularyFilterNames sets the VocabularyFilterNames field's value.
func (s *StartStreamTranscriptionOutput) SetVocabularyFilterNames(v string) *StartStreamTranscriptionOutput {
	s.VocabularyFilterNames = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *StartStreamTranscriptionOutput) SetVocabularyName(v string) *StartStreamTranscriptionOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyNames sets the VocabularyNames field's value.
func (s *StartStreamTranscriptionOutput) SetVocabularyNames(v string) *StartStreamTranscriptionOutput {
	s.VocabularyNames = &v
	return s
}

// GetStream returns the type to interact with the event stream.
func (s *StartStreamTranscriptionOutput) GetStream() *StartStreamTranscriptionEventStream {
	return s.eventStream
}

// Contains the timestamp range (start time through end time) of a matched category.
type TimestampRange struct {
	_ struct{} `type:"structure"`

	// The time, in milliseconds, from the beginning of the audio stream to the
	// start of the category match.
	BeginOffsetMillis *int64 `type:"long"`

	// The time, in milliseconds, from the beginning of the audio stream to the
	// end of the category match.
	EndOffsetMillis *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestampRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestampRange) GoString() string {
	return s.String()
}

// SetBeginOffsetMillis sets the BeginOffsetMillis field's value.
func (s *TimestampRange) SetBeginOffsetMillis(v int64) *TimestampRange {
	s.BeginOffsetMillis = &v
	return s
}

// SetEndOffsetMillis sets the EndOffsetMillis field's value.
func (s *TimestampRange) SetEndOffsetMillis(v int64) *TimestampRange {
	s.EndOffsetMillis = &v
	return s
}

// The Transcript associated with a .
//
// Transcript contains Results, which contains a set of transcription results
// from one or more audio segments, along with additional information per your
// request parameters.
type Transcript struct {
	_ struct{} `type:"structure"`

	// Contains a set of transcription results from one or more audio segments,
	// along with additional information per your request parameters. This can include
	// information relating to alternative transcriptions, channel identification,
	// partial result stabilization, language identification, and other transcription-related
	// data.
	Results []*Result `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Transcript) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Transcript) GoString() string {
	return s.String()
}

// SetResults sets the Results field's value.
func (s *Transcript) SetResults(v []*Result) *Transcript {
	s.Results = v
	return s
}

// The TranscriptEvent associated with a TranscriptResultStream.
//
// Contains a set of transcription results from one or more audio segments,
// along with additional information per your request parameters.
type TranscriptEvent struct {
	_ struct{} `type:"structure"`

	// Contains Results, which contains a set of transcription results from one
	// or more audio segments, along with additional information per your request
	// parameters. This can include information relating to alternative transcriptions,
	// channel identification, partial result stabilization, language identification,
	// and other transcription-related data.
	Transcript *Transcript `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptEvent) GoString() string {
	return s.String()
}

// SetTranscript sets the Transcript field's value.
func (s *TranscriptEvent) SetTranscript(v *Transcript) *TranscriptEvent {
	s.Transcript = v
	return s
}

// The TranscriptEvent is and event in the TranscriptResultStream group of events.
func (s *TranscriptEvent) eventTranscriptResultStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the TranscriptEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *TranscriptEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *TranscriptEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// TranscriptResultStreamEvent groups together all EventStream
// events writes for TranscriptResultStream.
//
// These events are:
//
//   - TranscriptEvent
type TranscriptResultStreamEvent interface {
	eventTranscriptResultStream()
	eventstreamapi.Marshaler
	eventstreamapi.Unmarshaler
}

// TranscriptResultStreamReader provides the interface for reading to the stream. The
// default implementation for this interface will be TranscriptResultStream.
//
// The reader's Close method must allow multiple concurrent calls.
//
// These events are:
//
//   - TranscriptEvent
//   - TranscriptResultStreamUnknownEvent
type TranscriptResultStreamReader interface {
	// Returns a channel of events as they are read from the event stream.
	Events() <-chan TranscriptResultStreamEvent

	// Close will stop the reader reading events from the stream.
	Close() error

	// Returns any error that has occurred while reading from the event stream.
	Err() error
}

type readTranscriptResultStream struct {
	eventReader *eventstreamapi.EventReader
	stream      chan TranscriptResultStreamEvent
	err         *eventstreamapi.OnceError

	done      chan struct{}
	closeOnce sync.Once
}

func newReadTranscriptResultStream(eventReader *eventstreamapi.EventReader) *readTranscriptResultStream {
	r := &readTranscriptResultStream{
		eventReader: eventReader,
		stream:      make(chan TranscriptResultStreamEvent),
		done:        make(chan struct{}),
		err:         eventstreamapi.NewOnceError(),
	}
	go r.readEventStream()

	return r
}

// Close will close the underlying event stream reader.
func (r *readTranscriptResultStream) Close() error {
	r.closeOnce.Do(r.safeClose)
	return r.Err()
}

func (r *readTranscriptResultStream) ErrorSet() <-chan struct{} {
	return r.err.ErrorSet()
}

func (r *readTranscriptResultStream) Closed() <-chan struct{} {
	return r.done
}

func (r *readTranscriptResultStream) safeClose() {
	close(r.done)
}

func (r *readTranscriptResultStream) Err() error {
	return r.err.Err()
}

func (r *readTranscriptResultStream) Events() <-chan TranscriptResultStreamEvent {
	return r.stream
}

func (r *readTranscriptResultStream) readEventStream() {
	defer r.Close()
	defer close(r.stream)

	for {
		event, err := r.eventReader.ReadEvent()
		if err != nil {
			if err == io.EOF {
				return
			}
			select {
			case <-r.done:
				// If closed already ignore the error
				return
			default:
			}
			if _, ok := err.(*eventstreamapi.UnknownMessageTypeError); ok {
				continue
			}
			r.err.SetError(err)
			return
		}

		select {
		case r.stream <- event.(TranscriptResultStreamEvent):
		case <-r.done:
			return
		}
	}
}

type unmarshalerForTranscriptResultStreamEvent struct {
	metadata protocol.ResponseMetadata
}

func (u unmarshalerForTranscriptResultStreamEvent) UnmarshalerForEventName(eventType string) (eventstreamapi.Unmarshaler, error) {
	switch eventType {
	case "TranscriptEvent":
		return &TranscriptEvent{}, nil
	case "BadRequestException":
		return newErrorBadRequestException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "ConflictException":
		return newErrorConflictException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "InternalFailureException":
		return newErrorInternalFailureException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "LimitExceededException":
		return newErrorLimitExceededException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "ServiceUnavailableException":
		return newErrorServiceUnavailableException(u.metadata).(eventstreamapi.Unmarshaler), nil
	default:
		return &TranscriptResultStreamUnknownEvent{Type: eventType}, nil
	}
}

// TranscriptResultStreamUnknownEvent provides a failsafe event for the
// TranscriptResultStream group of events when an unknown event is received.
type TranscriptResultStreamUnknownEvent struct {
	Type    string
	Message eventstream.Message
}

// The TranscriptResultStreamUnknownEvent is and event in the TranscriptResultStream
// group of events.
func (s *TranscriptResultStreamUnknownEvent) eventTranscriptResultStream() {}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (e *TranscriptResultStreamUnknownEvent) MarshalEvent(pm protocol.PayloadMarshaler) (
	msg eventstream.Message, err error,
) {
	return e.Message.Clone(), nil
}

// UnmarshalEvent unmarshals the EventStream Message into the TranscriptResultStream value.
// This method is only used internally within the SDK's EventStream handling.
func (e *TranscriptResultStreamUnknownEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	e.Message = msg.Clone()
	return nil
}

// Contains set of transcription results from one or more audio segments, along
// with additional information about the parameters included in your request.
// For example, channel definitions, partial result stabilization, sentiment,
// and issue detection.
type UtteranceEvent struct {
	_ struct{} `type:"structure"`

	// The time, in milliseconds, from the beginning of the audio stream to the
	// start of the UtteranceEvent.
	BeginOffsetMillis *int64 `type:"long"`

	// The time, in milliseconds, from the beginning of the audio stream to the
	// start of the UtteranceEvent.
	EndOffsetMillis *int64 `type:"long"`

	// Contains entities identified as personally identifiable information (PII)
	// in your transcription output.
	Entities []*CallAnalyticsEntity `type:"list"`

	// Indicates whether the segment in the UtteranceEvent is complete (FALSE) or
	// partial (TRUE).
	IsPartial *bool `type:"boolean"`

	// Provides the issue that was detected in the specified segment.
	IssuesDetected []*IssueDetected `type:"list"`

	// Contains words, phrases, or punctuation marks that are associated with the
	// specified UtteranceEvent.
	Items []*CallAnalyticsItem `type:"list"`

	// Provides the role of the speaker for each audio channel, either CUSTOMER
	// or AGENT.
	ParticipantRole *string `type:"string" enum:"ParticipantRole"`

	// Provides the sentiment that was detected in the specified segment.
	Sentiment *string `type:"string" enum:"Sentiment"`

	// Contains transcribed text.
	Transcript *string `type:"string"`

	// The unique identifier that is associated with the specified UtteranceEvent.
	UtteranceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UtteranceEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UtteranceEvent) GoString() string {
	return s.String()
}

// SetBeginOffsetMillis sets the BeginOffsetMillis field's value.
func (s *UtteranceEvent) SetBeginOffsetMillis(v int64) *UtteranceEvent {
	s.BeginOffsetMillis = &v
	return s
}

// SetEndOffsetMillis sets the EndOffsetMillis field's value.
func (s *UtteranceEvent) SetEndOffsetMillis(v int64) *UtteranceEvent {
	s.EndOffsetMillis = &v
	return s
}

// SetEntities sets the Entities field's value.
func (s *UtteranceEvent) SetEntities(v []*CallAnalyticsEntity) *UtteranceEvent {
	s.Entities = v
	return s
}

// SetIsPartial sets the IsPartial field's value.
func (s *UtteranceEvent) SetIsPartial(v bool) *UtteranceEvent {
	s.IsPartial = &v
	return s
}

// SetIssuesDetected sets the IssuesDetected field's value.
func (s *UtteranceEvent) SetIssuesDetected(v []*IssueDetected) *UtteranceEvent {
	s.IssuesDetected = v
	return s
}

// SetItems sets the Items field's value.
func (s *UtteranceEvent) SetItems(v []*CallAnalyticsItem) *UtteranceEvent {
	s.Items = v
	return s
}

// SetParticipantRole sets the ParticipantRole field's value.
func (s *UtteranceEvent) SetParticipantRole(v string) *UtteranceEvent {
	s.ParticipantRole = &v
	return s
}

// SetSentiment sets the Sentiment field's value.
func (s *UtteranceEvent) SetSentiment(v string) *UtteranceEvent {
	s.Sentiment = &v
	return s
}

// SetTranscript sets the Transcript field's value.
func (s *UtteranceEvent) SetTranscript(v string) *UtteranceEvent {
	s.Transcript = &v
	return s
}

// SetUtteranceId sets the UtteranceId field's value.
func (s *UtteranceEvent) SetUtteranceId(v string) *UtteranceEvent {
	s.UtteranceId = &v
	return s
}

// The UtteranceEvent is and event in the CallAnalyticsTranscriptResultStream group of events.
func (s *UtteranceEvent) eventCallAnalyticsTranscriptResultStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the UtteranceEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *UtteranceEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *UtteranceEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

const (
	// CallAnalyticsLanguageCodeEnUs is a CallAnalyticsLanguageCode enum value
	CallAnalyticsLanguageCodeEnUs = "en-US"

	// CallAnalyticsLanguageCodeEnGb is a CallAnalyticsLanguageCode enum value
	CallAnalyticsLanguageCodeEnGb = "en-GB"

	// CallAnalyticsLanguageCodeEsUs is a CallAnalyticsLanguageCode enum value
	CallAnalyticsLanguageCodeEsUs = "es-US"

	// CallAnalyticsLanguageCodeFrCa is a CallAnalyticsLanguageCode enum value
	CallAnalyticsLanguageCodeFrCa = "fr-CA"

	// CallAnalyticsLanguageCodeFrFr is a CallAnalyticsLanguageCode enum value
	CallAnalyticsLanguageCodeFrFr = "fr-FR"

	// CallAnalyticsLanguageCodeEnAu is a CallAnalyticsLanguageCode enum value
	CallAnalyticsLanguageCodeEnAu = "en-AU"

	// CallAnalyticsLanguageCodeItIt is a CallAnalyticsLanguageCode enum value
	CallAnalyticsLanguageCodeItIt = "it-IT"

	// CallAnalyticsLanguageCodeDeDe is a CallAnalyticsLanguageCode enum value
	CallAnalyticsLanguageCodeDeDe = "de-DE"

	// CallAnalyticsLanguageCodePtBr is a CallAnalyticsLanguageCode enum value
	CallAnalyticsLanguageCodePtBr = "pt-BR"
)

// CallAnalyticsLanguageCode_Values returns all elements of the CallAnalyticsLanguageCode enum
func CallAnalyticsLanguageCode_Values() []string {
	return []string{
		CallAnalyticsLanguageCodeEnUs,
		CallAnalyticsLanguageCodeEnGb,
		CallAnalyticsLanguageCodeEsUs,
		CallAnalyticsLanguageCodeFrCa,
		CallAnalyticsLanguageCodeFrFr,
		CallAnalyticsLanguageCodeEnAu,
		CallAnalyticsLanguageCodeItIt,
		CallAnalyticsLanguageCodeDeDe,
		CallAnalyticsLanguageCodePtBr,
	}
}

const (
	// ContentIdentificationTypePii is a ContentIdentificationType enum value
	ContentIdentificationTypePii = "PII"
)

// ContentIdentificationType_Values returns all elements of the ContentIdentificationType enum
func ContentIdentificationType_Values() []string {
	return []string{
		ContentIdentificationTypePii,
	}
}

const (
	// ContentRedactionOutputRedacted is a ContentRedactionOutput_ enum value
	ContentRedactionOutputRedacted = "redacted"

	// ContentRedactionOutputRedactedAndUnredacted is a ContentRedactionOutput_ enum value
	ContentRedactionOutputRedactedAndUnredacted = "redacted_and_unredacted"
)

// ContentRedactionOutput__Values returns all elements of the ContentRedactionOutput_ enum
func ContentRedactionOutput__Values() []string {
	return []string{
		ContentRedactionOutputRedacted,
		ContentRedactionOutputRedactedAndUnredacted,
	}
}

const (
	// ContentRedactionTypePii is a ContentRedactionType enum value
	ContentRedactionTypePii = "PII"
)

// ContentRedactionType_Values returns all elements of the ContentRedactionType enum
func ContentRedactionType_Values() []string {
	return []string{
		ContentRedactionTypePii,
	}
}

const (
	// ItemTypePronunciation is a ItemType enum value
	ItemTypePronunciation = "pronunciation"

	// ItemTypePunctuation is a ItemType enum value
	ItemTypePunctuation = "punctuation"
)

// ItemType_Values returns all elements of the ItemType enum
func ItemType_Values() []string {
	return []string{
		ItemTypePronunciation,
		ItemTypePunctuation,
	}
}

const (
	// LanguageCodeEnUs is a LanguageCode enum value
	LanguageCodeEnUs = "en-US"

	// LanguageCodeEnGb is a LanguageCode enum value
	LanguageCodeEnGb = "en-GB"

	// LanguageCodeEsUs is a LanguageCode enum value
	LanguageCodeEsUs = "es-US"

	// LanguageCodeFrCa is a LanguageCode enum value
	LanguageCodeFrCa = "fr-CA"

	// LanguageCodeFrFr is a LanguageCode enum value
	LanguageCodeFrFr = "fr-FR"

	// LanguageCodeEnAu is a LanguageCode enum value
	LanguageCodeEnAu = "en-AU"

	// LanguageCodeItIt is a LanguageCode enum value
	LanguageCodeItIt = "it-IT"

	// LanguageCodeDeDe is a LanguageCode enum value
	LanguageCodeDeDe = "de-DE"

	// LanguageCodePtBr is a LanguageCode enum value
	LanguageCodePtBr = "pt-BR"

	// LanguageCodeJaJp is a LanguageCode enum value
	LanguageCodeJaJp = "ja-JP"

	// LanguageCodeKoKr is a LanguageCode enum value
	LanguageCodeKoKr = "ko-KR"

	// LanguageCodeZhCn is a LanguageCode enum value
	LanguageCodeZhCn = "zh-CN"

	// LanguageCodeHiIn is a LanguageCode enum value
	LanguageCodeHiIn = "hi-IN"

	// LanguageCodeThTh is a LanguageCode enum value
	LanguageCodeThTh = "th-TH"
)

// LanguageCode_Values returns all elements of the LanguageCode enum
func LanguageCode_Values() []string {
	return []string{
		LanguageCodeEnUs,
		LanguageCodeEnGb,
		LanguageCodeEsUs,
		LanguageCodeFrCa,
		LanguageCodeFrFr,
		LanguageCodeEnAu,
		LanguageCodeItIt,
		LanguageCodeDeDe,
		LanguageCodePtBr,
		LanguageCodeJaJp,
		LanguageCodeKoKr,
		LanguageCodeZhCn,
		LanguageCodeHiIn,
		LanguageCodeThTh,
	}
}

const (
	// MediaEncodingPcm is a MediaEncoding enum value
	MediaEncodingPcm = "pcm"

	// MediaEncodingOggOpus is a MediaEncoding enum value
	MediaEncodingOggOpus = "ogg-opus"

	// MediaEncodingFlac is a MediaEncoding enum value
	MediaEncodingFlac = "flac"
)

// MediaEncoding_Values returns all elements of the MediaEncoding enum
func MediaEncoding_Values() []string {
	return []string{
		MediaEncodingPcm,
		MediaEncodingOggOpus,
		MediaEncodingFlac,
	}
}

const (
	// MedicalContentIdentificationTypePhi is a MedicalContentIdentificationType enum value
	MedicalContentIdentificationTypePhi = "PHI"
)

// MedicalContentIdentificationType_Values returns all elements of the MedicalContentIdentificationType enum
func MedicalContentIdentificationType_Values() []string {
	return []string{
		MedicalContentIdentificationTypePhi,
	}
}

const (
	// PartialResultsStabilityHigh is a PartialResultsStability enum value
	PartialResultsStabilityHigh = "high"

	// PartialResultsStabilityMedium is a PartialResultsStability enum value
	PartialResultsStabilityMedium = "medium"

	// PartialResultsStabilityLow is a PartialResultsStability enum value
	PartialResultsStabilityLow = "low"
)

// PartialResultsStability_Values returns all elements of the PartialResultsStability enum
func PartialResultsStability_Values() []string {
	return []string{
		PartialResultsStabilityHigh,
		PartialResultsStabilityMedium,
		PartialResultsStabilityLow,
	}
}

const (
	// ParticipantRoleAgent is a ParticipantRole enum value
	ParticipantRoleAgent = "AGENT"

	// ParticipantRoleCustomer is a ParticipantRole enum value
	ParticipantRoleCustomer = "CUSTOMER"
)

// ParticipantRole_Values returns all elements of the ParticipantRole enum
func ParticipantRole_Values() []string {
	return []string{
		ParticipantRoleAgent,
		ParticipantRoleCustomer,
	}
}

const (
	// SentimentPositive is a Sentiment enum value
	SentimentPositive = "POSITIVE"

	// SentimentNegative is a Sentiment enum value
	SentimentNegative = "NEGATIVE"

	// SentimentMixed is a Sentiment enum value
	SentimentMixed = "MIXED"

	// SentimentNeutral is a Sentiment enum value
	SentimentNeutral = "NEUTRAL"
)

// Sentiment_Values returns all elements of the Sentiment enum
func Sentiment_Values() []string {
	return []string{
		SentimentPositive,
		SentimentNegative,
		SentimentMixed,
		SentimentNeutral,
	}
}

const (
	// SpecialtyPrimarycare is a Specialty enum value
	SpecialtyPrimarycare = "PRIMARYCARE"

	// SpecialtyCardiology is a Specialty enum value
	SpecialtyCardiology = "CARDIOLOGY"

	// SpecialtyNeurology is a Specialty enum value
	SpecialtyNeurology = "NEUROLOGY"

	// SpecialtyOncology is a Specialty enum value
	SpecialtyOncology = "ONCOLOGY"

	// SpecialtyRadiology is a Specialty enum value
	SpecialtyRadiology = "RADIOLOGY"

	// SpecialtyUrology is a Specialty enum value
	SpecialtyUrology = "UROLOGY"
)

// Specialty_Values returns all elements of the Specialty enum
func Specialty_Values() []string {
	return []string{
		SpecialtyPrimarycare,
		SpecialtyCardiology,
		SpecialtyNeurology,
		SpecialtyOncology,
		SpecialtyRadiology,
		SpecialtyUrology,
	}
}

const (
	// TypeConversation is a Type enum value
	TypeConversation = "CONVERSATION"

	// TypeDictation is a Type enum value
	TypeDictation = "DICTATION"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypeConversation,
		TypeDictation,
	}
}

const (
	// VocabularyFilterMethodRemove is a VocabularyFilterMethod enum value
	VocabularyFilterMethodRemove = "remove"

	// VocabularyFilterMethodMask is a VocabularyFilterMethod enum value
	VocabularyFilterMethodMask = "mask"

	// VocabularyFilterMethodTag is a VocabularyFilterMethod enum value
	VocabularyFilterMethodTag = "tag"
)

// VocabularyFilterMethod_Values returns all elements of the VocabularyFilterMethod enum
func VocabularyFilterMethod_Values() []string {
	return []string{
		VocabularyFilterMethodRemove,
		VocabularyFilterMethodMask,
		VocabularyFilterMethodTag,
	}
}
