// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package costoptimizationhub

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opGetPreferences = "GetPreferences"

// GetPreferencesRequest generates a "aws/request.Request" representing the
// client's request for the GetPreferences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPreferences for more information on using the GetPreferences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPreferencesRequest method.
//	req, resp := client.GetPreferencesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/GetPreferences
func (c *CostOptimizationHub) GetPreferencesRequest(input *GetPreferencesInput) (req *request.Request, output *GetPreferencesOutput) {
	op := &request.Operation{
		Name:       opGetPreferences,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPreferencesInput{}
	}

	output = &GetPreferencesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPreferences API operation for Cost Optimization Hub.
//
// Returns a set of preferences for an account in order to add account-specific
// preferences into the service. These preferences impact how the savings associated
// with recommendations are presented—estimated savings after discounts or
// estimated savings before discounts, for example.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Cost Optimization Hub's
// API operation GetPreferences for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - AccessDeniedException
//     You are not authorized to use this operation with the given parameters.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/GetPreferences
func (c *CostOptimizationHub) GetPreferences(input *GetPreferencesInput) (*GetPreferencesOutput, error) {
	req, out := c.GetPreferencesRequest(input)
	return out, req.Send()
}

// GetPreferencesWithContext is the same as GetPreferences with the addition of
// the ability to pass a context and additional request options.
//
// See GetPreferences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostOptimizationHub) GetPreferencesWithContext(ctx aws.Context, input *GetPreferencesInput, opts ...request.Option) (*GetPreferencesOutput, error) {
	req, out := c.GetPreferencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecommendation = "GetRecommendation"

// GetRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the GetRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecommendation for more information on using the GetRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRecommendationRequest method.
//	req, resp := client.GetRecommendationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/GetRecommendation
func (c *CostOptimizationHub) GetRecommendationRequest(input *GetRecommendationInput) (req *request.Request, output *GetRecommendationOutput) {
	op := &request.Operation{
		Name:       opGetRecommendation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRecommendationInput{}
	}

	output = &GetRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecommendation API operation for Cost Optimization Hub.
//
// Returns both the current and recommended resource configuration and the estimated
// cost impact for a recommendation.
//
// The recommendationId is only valid for up to a maximum of 24 hours as recommendations
// are refreshed daily. To retrieve the recommendationId, use the ListRecommendations
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Cost Optimization Hub's
// API operation GetRecommendation for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - AccessDeniedException
//     You are not authorized to use this operation with the given parameters.
//
//   - ResourceNotFoundException
//     The specified Amazon Resource Name (ARN) in the request doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/GetRecommendation
func (c *CostOptimizationHub) GetRecommendation(input *GetRecommendationInput) (*GetRecommendationOutput, error) {
	req, out := c.GetRecommendationRequest(input)
	return out, req.Send()
}

// GetRecommendationWithContext is the same as GetRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostOptimizationHub) GetRecommendationWithContext(ctx aws.Context, input *GetRecommendationInput, opts ...request.Option) (*GetRecommendationOutput, error) {
	req, out := c.GetRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEnrollmentStatuses = "ListEnrollmentStatuses"

// ListEnrollmentStatusesRequest generates a "aws/request.Request" representing the
// client's request for the ListEnrollmentStatuses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnrollmentStatuses for more information on using the ListEnrollmentStatuses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnrollmentStatusesRequest method.
//	req, resp := client.ListEnrollmentStatusesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListEnrollmentStatuses
func (c *CostOptimizationHub) ListEnrollmentStatusesRequest(input *ListEnrollmentStatusesInput) (req *request.Request, output *ListEnrollmentStatusesOutput) {
	op := &request.Operation{
		Name:       opListEnrollmentStatuses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnrollmentStatusesInput{}
	}

	output = &ListEnrollmentStatusesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnrollmentStatuses API operation for Cost Optimization Hub.
//
// Retrieves the enrollment status for an account. It can also return the list
// of accounts that are enrolled under the organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Cost Optimization Hub's
// API operation ListEnrollmentStatuses for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - AccessDeniedException
//     You are not authorized to use this operation with the given parameters.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListEnrollmentStatuses
func (c *CostOptimizationHub) ListEnrollmentStatuses(input *ListEnrollmentStatusesInput) (*ListEnrollmentStatusesOutput, error) {
	req, out := c.ListEnrollmentStatusesRequest(input)
	return out, req.Send()
}

// ListEnrollmentStatusesWithContext is the same as ListEnrollmentStatuses with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnrollmentStatuses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostOptimizationHub) ListEnrollmentStatusesWithContext(ctx aws.Context, input *ListEnrollmentStatusesInput, opts ...request.Option) (*ListEnrollmentStatusesOutput, error) {
	req, out := c.ListEnrollmentStatusesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnrollmentStatusesPages iterates over the pages of a ListEnrollmentStatuses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnrollmentStatuses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEnrollmentStatuses operation.
//	pageNum := 0
//	err := client.ListEnrollmentStatusesPages(params,
//	    func(page *costoptimizationhub.ListEnrollmentStatusesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CostOptimizationHub) ListEnrollmentStatusesPages(input *ListEnrollmentStatusesInput, fn func(*ListEnrollmentStatusesOutput, bool) bool) error {
	return c.ListEnrollmentStatusesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnrollmentStatusesPagesWithContext same as ListEnrollmentStatusesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostOptimizationHub) ListEnrollmentStatusesPagesWithContext(ctx aws.Context, input *ListEnrollmentStatusesInput, fn func(*ListEnrollmentStatusesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnrollmentStatusesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnrollmentStatusesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnrollmentStatusesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecommendationSummaries = "ListRecommendationSummaries"

// ListRecommendationSummariesRequest generates a "aws/request.Request" representing the
// client's request for the ListRecommendationSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecommendationSummaries for more information on using the ListRecommendationSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRecommendationSummariesRequest method.
//	req, resp := client.ListRecommendationSummariesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListRecommendationSummaries
func (c *CostOptimizationHub) ListRecommendationSummariesRequest(input *ListRecommendationSummariesInput) (req *request.Request, output *ListRecommendationSummariesOutput) {
	op := &request.Operation{
		Name:       opListRecommendationSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecommendationSummariesInput{}
	}

	output = &ListRecommendationSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecommendationSummaries API operation for Cost Optimization Hub.
//
// Returns a concise representation of savings estimates for resources. Also
// returns de-duped savings across different types of recommendations.
//
// The following filters are not supported for this API: recommendationIds,
// resourceArns, and resourceIds.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Cost Optimization Hub's
// API operation ListRecommendationSummaries for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - AccessDeniedException
//     You are not authorized to use this operation with the given parameters.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListRecommendationSummaries
func (c *CostOptimizationHub) ListRecommendationSummaries(input *ListRecommendationSummariesInput) (*ListRecommendationSummariesOutput, error) {
	req, out := c.ListRecommendationSummariesRequest(input)
	return out, req.Send()
}

// ListRecommendationSummariesWithContext is the same as ListRecommendationSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecommendationSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostOptimizationHub) ListRecommendationSummariesWithContext(ctx aws.Context, input *ListRecommendationSummariesInput, opts ...request.Option) (*ListRecommendationSummariesOutput, error) {
	req, out := c.ListRecommendationSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecommendationSummariesPages iterates over the pages of a ListRecommendationSummaries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecommendationSummaries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRecommendationSummaries operation.
//	pageNum := 0
//	err := client.ListRecommendationSummariesPages(params,
//	    func(page *costoptimizationhub.ListRecommendationSummariesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CostOptimizationHub) ListRecommendationSummariesPages(input *ListRecommendationSummariesInput, fn func(*ListRecommendationSummariesOutput, bool) bool) error {
	return c.ListRecommendationSummariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecommendationSummariesPagesWithContext same as ListRecommendationSummariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostOptimizationHub) ListRecommendationSummariesPagesWithContext(ctx aws.Context, input *ListRecommendationSummariesInput, fn func(*ListRecommendationSummariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecommendationSummariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecommendationSummariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecommendationSummariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecommendations = "ListRecommendations"

// ListRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the ListRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecommendations for more information on using the ListRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRecommendationsRequest method.
//	req, resp := client.ListRecommendationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListRecommendations
func (c *CostOptimizationHub) ListRecommendationsRequest(input *ListRecommendationsInput) (req *request.Request, output *ListRecommendationsOutput) {
	op := &request.Operation{
		Name:       opListRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecommendationsInput{}
	}

	output = &ListRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecommendations API operation for Cost Optimization Hub.
//
// Returns a list of recommendations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Cost Optimization Hub's
// API operation ListRecommendations for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - AccessDeniedException
//     You are not authorized to use this operation with the given parameters.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListRecommendations
func (c *CostOptimizationHub) ListRecommendations(input *ListRecommendationsInput) (*ListRecommendationsOutput, error) {
	req, out := c.ListRecommendationsRequest(input)
	return out, req.Send()
}

// ListRecommendationsWithContext is the same as ListRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostOptimizationHub) ListRecommendationsWithContext(ctx aws.Context, input *ListRecommendationsInput, opts ...request.Option) (*ListRecommendationsOutput, error) {
	req, out := c.ListRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecommendationsPages iterates over the pages of a ListRecommendations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecommendations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRecommendations operation.
//	pageNum := 0
//	err := client.ListRecommendationsPages(params,
//	    func(page *costoptimizationhub.ListRecommendationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CostOptimizationHub) ListRecommendationsPages(input *ListRecommendationsInput, fn func(*ListRecommendationsOutput, bool) bool) error {
	return c.ListRecommendationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecommendationsPagesWithContext same as ListRecommendationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostOptimizationHub) ListRecommendationsPagesWithContext(ctx aws.Context, input *ListRecommendationsInput, fn func(*ListRecommendationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecommendationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecommendationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecommendationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateEnrollmentStatus = "UpdateEnrollmentStatus"

// UpdateEnrollmentStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnrollmentStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnrollmentStatus for more information on using the UpdateEnrollmentStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEnrollmentStatusRequest method.
//	req, resp := client.UpdateEnrollmentStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/UpdateEnrollmentStatus
func (c *CostOptimizationHub) UpdateEnrollmentStatusRequest(input *UpdateEnrollmentStatusInput) (req *request.Request, output *UpdateEnrollmentStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateEnrollmentStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEnrollmentStatusInput{}
	}

	output = &UpdateEnrollmentStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEnrollmentStatus API operation for Cost Optimization Hub.
//
// Updates the enrollment (opt in and opt out) status of an account to the Cost
// Optimization Hub service.
//
// If the account is a management account of an organization, this action can
// also be used to enroll member accounts of the organization.
//
// You must have the appropriate permissions to opt in to Cost Optimization
// Hub and to view its recommendations. When you opt in, Cost Optimization Hub
// automatically creates a service-linked role in your account to access its
// data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Cost Optimization Hub's
// API operation UpdateEnrollmentStatus for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - AccessDeniedException
//     You are not authorized to use this operation with the given parameters.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/UpdateEnrollmentStatus
func (c *CostOptimizationHub) UpdateEnrollmentStatus(input *UpdateEnrollmentStatusInput) (*UpdateEnrollmentStatusOutput, error) {
	req, out := c.UpdateEnrollmentStatusRequest(input)
	return out, req.Send()
}

// UpdateEnrollmentStatusWithContext is the same as UpdateEnrollmentStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnrollmentStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostOptimizationHub) UpdateEnrollmentStatusWithContext(ctx aws.Context, input *UpdateEnrollmentStatusInput, opts ...request.Option) (*UpdateEnrollmentStatusOutput, error) {
	req, out := c.UpdateEnrollmentStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePreferences = "UpdatePreferences"

// UpdatePreferencesRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePreferences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePreferences for more information on using the UpdatePreferences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePreferencesRequest method.
//	req, resp := client.UpdatePreferencesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/UpdatePreferences
func (c *CostOptimizationHub) UpdatePreferencesRequest(input *UpdatePreferencesInput) (req *request.Request, output *UpdatePreferencesOutput) {
	op := &request.Operation{
		Name:       opUpdatePreferences,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePreferencesInput{}
	}

	output = &UpdatePreferencesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePreferences API operation for Cost Optimization Hub.
//
// Updates a set of preferences for an account in order to add account-specific
// preferences into the service. These preferences impact how the savings associated
// with recommendations are presented.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Cost Optimization Hub's
// API operation UpdatePreferences for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - AccessDeniedException
//     You are not authorized to use this operation with the given parameters.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/UpdatePreferences
func (c *CostOptimizationHub) UpdatePreferences(input *UpdatePreferencesInput) (*UpdatePreferencesOutput, error) {
	req, out := c.UpdatePreferencesRequest(input)
	return out, req.Send()
}

// UpdatePreferencesWithContext is the same as UpdatePreferences with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePreferences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostOptimizationHub) UpdatePreferencesWithContext(ctx aws.Context, input *UpdatePreferencesInput, opts ...request.Option) (*UpdatePreferencesOutput, error) {
	req, out := c.UpdatePreferencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You are not authorized to use this operation with the given parameters.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the enrollment status of an organization's member accounts in Cost
// Optimization Hub.
type AccountEnrollmentStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID.
	AccountId *string `locationName:"accountId" type:"string"`

	// The time when the account enrollment status was created.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The time when the account enrollment status was last updated.
	LastUpdatedTimestamp *time.Time `locationName:"lastUpdatedTimestamp" type:"timestamp"`

	// The account enrollment status.
	Status *string `locationName:"status" type:"string" enum:"EnrollmentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountEnrollmentStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountEnrollmentStatus) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AccountEnrollmentStatus) SetAccountId(v string) *AccountEnrollmentStatus {
	s.AccountId = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *AccountEnrollmentStatus) SetCreatedTimestamp(v time.Time) *AccountEnrollmentStatus {
	s.CreatedTimestamp = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *AccountEnrollmentStatus) SetLastUpdatedTimestamp(v time.Time) *AccountEnrollmentStatus {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccountEnrollmentStatus) SetStatus(v string) *AccountEnrollmentStatus {
	s.Status = &v
	return s
}

// Describes the Amazon Elastic Block Store performance configuration of the
// current and recommended resource configuration for a recommendation.
type BlockStoragePerformanceConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of I/O operations per second.
	Iops *float64 `locationName:"iops" type:"double"`

	// The throughput that the volume supports.
	Throughput *float64 `locationName:"throughput" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlockStoragePerformanceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlockStoragePerformanceConfiguration) GoString() string {
	return s.String()
}

// SetIops sets the Iops field's value.
func (s *BlockStoragePerformanceConfiguration) SetIops(v float64) *BlockStoragePerformanceConfiguration {
	s.Iops = &v
	return s
}

// SetThroughput sets the Throughput field's value.
func (s *BlockStoragePerformanceConfiguration) SetThroughput(v float64) *BlockStoragePerformanceConfiguration {
	s.Throughput = &v
	return s
}

// Describes the performance configuration for compute services such as Amazon
// EC2, Lambda, and ECS.
type ComputeConfiguration struct {
	_ struct{} `type:"structure"`

	// The architecture of the resource.
	Architecture *string `locationName:"architecture" type:"string"`

	// The memory size of the resource.
	MemorySizeInMB *int64 `locationName:"memorySizeInMB" type:"integer"`

	// The platform of the resource. The platform is the specific combination of
	// operating system, license model, and software on an instance.
	Platform *string `locationName:"platform" type:"string"`

	// The number of vCPU cores in the resource.
	VCpu *float64 `locationName:"vCpu" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeConfiguration) GoString() string {
	return s.String()
}

// SetArchitecture sets the Architecture field's value.
func (s *ComputeConfiguration) SetArchitecture(v string) *ComputeConfiguration {
	s.Architecture = &v
	return s
}

// SetMemorySizeInMB sets the MemorySizeInMB field's value.
func (s *ComputeConfiguration) SetMemorySizeInMB(v int64) *ComputeConfiguration {
	s.MemorySizeInMB = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ComputeConfiguration) SetPlatform(v string) *ComputeConfiguration {
	s.Platform = &v
	return s
}

// SetVCpu sets the VCpu field's value.
func (s *ComputeConfiguration) SetVCpu(v float64) *ComputeConfiguration {
	s.VCpu = &v
	return s
}

// The Compute Savings Plans recommendation details.
type ComputeSavingsPlans struct {
	_ struct{} `type:"structure"`

	// Configuration details of the Compute Savings Plans to purchase.
	Configuration *ComputeSavingsPlansConfiguration `locationName:"configuration" type:"structure"`

	// Cost impact of the Savings Plans purchase recommendation.
	CostCalculation *SavingsPlansCostCalculation `locationName:"costCalculation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeSavingsPlans) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeSavingsPlans) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *ComputeSavingsPlans) SetConfiguration(v *ComputeSavingsPlansConfiguration) *ComputeSavingsPlans {
	s.Configuration = v
	return s
}

// SetCostCalculation sets the CostCalculation field's value.
func (s *ComputeSavingsPlans) SetCostCalculation(v *SavingsPlansCostCalculation) *ComputeSavingsPlans {
	s.CostCalculation = v
	return s
}

// The Compute Savings Plans configuration used for recommendations.
type ComputeSavingsPlansConfiguration struct {
	_ struct{} `type:"structure"`

	// The account scope that you want your recommendations for. Amazon Web Services
	// calculates recommendations including the management account and member accounts
	// if the value is set to PAYER. If the value is LINKED, recommendations are
	// calculated for individual member accounts only.
	AccountScope *string `locationName:"accountScope" type:"string"`

	// The hourly commitment for the Savings Plans type.
	HourlyCommitment *string `locationName:"hourlyCommitment" type:"string"`

	// The payment option for the commitment.
	PaymentOption *string `locationName:"paymentOption" type:"string"`

	// The Savings Plans recommendation term in years.
	Term *string `locationName:"term" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeSavingsPlansConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeSavingsPlansConfiguration) GoString() string {
	return s.String()
}

// SetAccountScope sets the AccountScope field's value.
func (s *ComputeSavingsPlansConfiguration) SetAccountScope(v string) *ComputeSavingsPlansConfiguration {
	s.AccountScope = &v
	return s
}

// SetHourlyCommitment sets the HourlyCommitment field's value.
func (s *ComputeSavingsPlansConfiguration) SetHourlyCommitment(v string) *ComputeSavingsPlansConfiguration {
	s.HourlyCommitment = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *ComputeSavingsPlansConfiguration) SetPaymentOption(v string) *ComputeSavingsPlansConfiguration {
	s.PaymentOption = &v
	return s
}

// SetTerm sets the Term field's value.
func (s *ComputeSavingsPlansConfiguration) SetTerm(v string) *ComputeSavingsPlansConfiguration {
	s.Term = &v
	return s
}

// Describes the Amazon Elastic Block Store volume configuration of the current
// and recommended resource configuration for a recommendation.
type EbsVolume struct {
	_ struct{} `type:"structure"`

	// The Amazon Elastic Block Store volume configuration used for recommendations.
	Configuration *EbsVolumeConfiguration `locationName:"configuration" type:"structure"`

	// Cost impact of the recommendation.
	CostCalculation *ResourceCostCalculation `locationName:"costCalculation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EbsVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EbsVolume) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *EbsVolume) SetConfiguration(v *EbsVolumeConfiguration) *EbsVolume {
	s.Configuration = v
	return s
}

// SetCostCalculation sets the CostCalculation field's value.
func (s *EbsVolume) SetCostCalculation(v *ResourceCostCalculation) *EbsVolume {
	s.CostCalculation = v
	return s
}

// The Amazon Elastic Block Store volume configuration used for recommendations.
type EbsVolumeConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Elastic Block Store attachment state.
	AttachmentState *string `locationName:"attachmentState" type:"string"`

	// The Amazon Elastic Block Store performance configuration.
	Performance *BlockStoragePerformanceConfiguration `locationName:"performance" type:"structure"`

	// The disk storage of the Amazon Elastic Block Store volume.
	Storage *StorageConfiguration `locationName:"storage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EbsVolumeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EbsVolumeConfiguration) GoString() string {
	return s.String()
}

// SetAttachmentState sets the AttachmentState field's value.
func (s *EbsVolumeConfiguration) SetAttachmentState(v string) *EbsVolumeConfiguration {
	s.AttachmentState = &v
	return s
}

// SetPerformance sets the Performance field's value.
func (s *EbsVolumeConfiguration) SetPerformance(v *BlockStoragePerformanceConfiguration) *EbsVolumeConfiguration {
	s.Performance = v
	return s
}

// SetStorage sets the Storage field's value.
func (s *EbsVolumeConfiguration) SetStorage(v *StorageConfiguration) *EbsVolumeConfiguration {
	s.Storage = v
	return s
}

// The EC2 Auto Scaling group recommendation details.
type Ec2AutoScalingGroup struct {
	_ struct{} `type:"structure"`

	// The EC2 Auto Scaling group configuration used for recommendations.
	Configuration *Ec2AutoScalingGroupConfiguration `locationName:"configuration" type:"structure"`

	// Cost impact of the recommendation.
	CostCalculation *ResourceCostCalculation `locationName:"costCalculation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2AutoScalingGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2AutoScalingGroup) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *Ec2AutoScalingGroup) SetConfiguration(v *Ec2AutoScalingGroupConfiguration) *Ec2AutoScalingGroup {
	s.Configuration = v
	return s
}

// SetCostCalculation sets the CostCalculation field's value.
func (s *Ec2AutoScalingGroup) SetCostCalculation(v *ResourceCostCalculation) *Ec2AutoScalingGroup {
	s.CostCalculation = v
	return s
}

// The EC2 auto scaling group configuration used for recommendations.
type Ec2AutoScalingGroupConfiguration struct {
	_ struct{} `type:"structure"`

	// Details about the instance.
	Instance *InstanceConfiguration `locationName:"instance" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2AutoScalingGroupConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2AutoScalingGroupConfiguration) GoString() string {
	return s.String()
}

// SetInstance sets the Instance field's value.
func (s *Ec2AutoScalingGroupConfiguration) SetInstance(v *InstanceConfiguration) *Ec2AutoScalingGroupConfiguration {
	s.Instance = v
	return s
}

// Describes the EC2 instance configuration of the current and recommended resource
// configuration for a recommendation.
type Ec2Instance struct {
	_ struct{} `type:"structure"`

	// The EC2 instance configuration used for recommendations.
	Configuration *Ec2InstanceConfiguration `locationName:"configuration" type:"structure"`

	// Cost impact of the recommendation.
	CostCalculation *ResourceCostCalculation `locationName:"costCalculation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2Instance) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *Ec2Instance) SetConfiguration(v *Ec2InstanceConfiguration) *Ec2Instance {
	s.Configuration = v
	return s
}

// SetCostCalculation sets the CostCalculation field's value.
func (s *Ec2Instance) SetCostCalculation(v *ResourceCostCalculation) *Ec2Instance {
	s.CostCalculation = v
	return s
}

// The EC2 instance configuration used for recommendations.
type Ec2InstanceConfiguration struct {
	_ struct{} `type:"structure"`

	// Details about the instance.
	Instance *InstanceConfiguration `locationName:"instance" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2InstanceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2InstanceConfiguration) GoString() string {
	return s.String()
}

// SetInstance sets the Instance field's value.
func (s *Ec2InstanceConfiguration) SetInstance(v *InstanceConfiguration) *Ec2InstanceConfiguration {
	s.Instance = v
	return s
}

// The EC2 instance Savings Plans recommendation details.
type Ec2InstanceSavingsPlans struct {
	_ struct{} `type:"structure"`

	// The EC2 instance Savings Plans configuration used for recommendations.
	Configuration *Ec2InstanceSavingsPlansConfiguration `locationName:"configuration" type:"structure"`

	// Cost impact of the Savings Plans purchase recommendation.
	CostCalculation *SavingsPlansCostCalculation `locationName:"costCalculation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2InstanceSavingsPlans) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2InstanceSavingsPlans) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *Ec2InstanceSavingsPlans) SetConfiguration(v *Ec2InstanceSavingsPlansConfiguration) *Ec2InstanceSavingsPlans {
	s.Configuration = v
	return s
}

// SetCostCalculation sets the CostCalculation field's value.
func (s *Ec2InstanceSavingsPlans) SetCostCalculation(v *SavingsPlansCostCalculation) *Ec2InstanceSavingsPlans {
	s.CostCalculation = v
	return s
}

// The EC2 instance Savings Plans configuration used for recommendations.
type Ec2InstanceSavingsPlansConfiguration struct {
	_ struct{} `type:"structure"`

	// The account scope that you want your recommendations for.
	AccountScope *string `locationName:"accountScope" type:"string"`

	// The hourly commitment for the Savings Plans type.
	HourlyCommitment *string `locationName:"hourlyCommitment" type:"string"`

	// The instance family of the recommended Savings Plan.
	InstanceFamily *string `locationName:"instanceFamily" type:"string"`

	// The payment option for the commitment.
	PaymentOption *string `locationName:"paymentOption" type:"string"`

	// The Amazon Web Services Region of the commitment.
	SavingsPlansRegion *string `locationName:"savingsPlansRegion" type:"string"`

	// The Savings Plans recommendation term in years.
	Term *string `locationName:"term" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2InstanceSavingsPlansConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2InstanceSavingsPlansConfiguration) GoString() string {
	return s.String()
}

// SetAccountScope sets the AccountScope field's value.
func (s *Ec2InstanceSavingsPlansConfiguration) SetAccountScope(v string) *Ec2InstanceSavingsPlansConfiguration {
	s.AccountScope = &v
	return s
}

// SetHourlyCommitment sets the HourlyCommitment field's value.
func (s *Ec2InstanceSavingsPlansConfiguration) SetHourlyCommitment(v string) *Ec2InstanceSavingsPlansConfiguration {
	s.HourlyCommitment = &v
	return s
}

// SetInstanceFamily sets the InstanceFamily field's value.
func (s *Ec2InstanceSavingsPlansConfiguration) SetInstanceFamily(v string) *Ec2InstanceSavingsPlansConfiguration {
	s.InstanceFamily = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *Ec2InstanceSavingsPlansConfiguration) SetPaymentOption(v string) *Ec2InstanceSavingsPlansConfiguration {
	s.PaymentOption = &v
	return s
}

// SetSavingsPlansRegion sets the SavingsPlansRegion field's value.
func (s *Ec2InstanceSavingsPlansConfiguration) SetSavingsPlansRegion(v string) *Ec2InstanceSavingsPlansConfiguration {
	s.SavingsPlansRegion = &v
	return s
}

// SetTerm sets the Term field's value.
func (s *Ec2InstanceSavingsPlansConfiguration) SetTerm(v string) *Ec2InstanceSavingsPlansConfiguration {
	s.Term = &v
	return s
}

// The EC2 reserved instances recommendation details.
type Ec2ReservedInstances struct {
	_ struct{} `type:"structure"`

	// The EC2 reserved instances configuration used for recommendations.
	Configuration *Ec2ReservedInstancesConfiguration `locationName:"configuration" type:"structure"`

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation `locationName:"costCalculation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2ReservedInstances) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2ReservedInstances) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *Ec2ReservedInstances) SetConfiguration(v *Ec2ReservedInstancesConfiguration) *Ec2ReservedInstances {
	s.Configuration = v
	return s
}

// SetCostCalculation sets the CostCalculation field's value.
func (s *Ec2ReservedInstances) SetCostCalculation(v *ReservedInstancesCostCalculation) *Ec2ReservedInstances {
	s.CostCalculation = v
	return s
}

// The EC2 reserved instances configuration used for recommendations.
type Ec2ReservedInstancesConfiguration struct {
	_ struct{} `type:"structure"`

	// The account scope that you want your recommendations for.
	AccountScope *string `locationName:"accountScope" type:"string"`

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *string `locationName:"currentGeneration" type:"string"`

	// The instance family of the recommended reservation.
	InstanceFamily *string `locationName:"instanceFamily" type:"string"`

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// How much purchasing reserved instances costs you on a monthly basis.
	MonthlyRecurringCost *string `locationName:"monthlyRecurringCost" type:"string"`

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	NormalizedUnitsToPurchase *string `locationName:"normalizedUnitsToPurchase" type:"string"`

	// The number of instances that Amazon Web Services recommends that you purchase.
	NumberOfInstancesToPurchase *string `locationName:"numberOfInstancesToPurchase" type:"string"`

	// Indicates whether the recommendation is for standard or convertible reservations.
	OfferingClass *string `locationName:"offeringClass" type:"string"`

	// The payment option for the commitment.
	PaymentOption *string `locationName:"paymentOption" type:"string"`

	// The platform of the recommended reservation. The platform is the specific
	// combination of operating system, license model, and software on an instance.
	Platform *string `locationName:"platform" type:"string"`

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string `locationName:"reservedInstancesRegion" type:"string"`

	// The service that you want your recommendations for.
	Service *string `locationName:"service" type:"string"`

	// Determines whether the recommendation is size flexible.
	SizeFlexEligible *bool `locationName:"sizeFlexEligible" type:"boolean"`

	// Determines whether the recommended reservation is dedicated or shared.
	Tenancy *string `locationName:"tenancy" type:"string"`

	// The reserved instances recommendation term in years.
	Term *string `locationName:"term" type:"string"`

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string `locationName:"upfrontCost" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2ReservedInstancesConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2ReservedInstancesConfiguration) GoString() string {
	return s.String()
}

// SetAccountScope sets the AccountScope field's value.
func (s *Ec2ReservedInstancesConfiguration) SetAccountScope(v string) *Ec2ReservedInstancesConfiguration {
	s.AccountScope = &v
	return s
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *Ec2ReservedInstancesConfiguration) SetCurrentGeneration(v string) *Ec2ReservedInstancesConfiguration {
	s.CurrentGeneration = &v
	return s
}

// SetInstanceFamily sets the InstanceFamily field's value.
func (s *Ec2ReservedInstancesConfiguration) SetInstanceFamily(v string) *Ec2ReservedInstancesConfiguration {
	s.InstanceFamily = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *Ec2ReservedInstancesConfiguration) SetInstanceType(v string) *Ec2ReservedInstancesConfiguration {
	s.InstanceType = &v
	return s
}

// SetMonthlyRecurringCost sets the MonthlyRecurringCost field's value.
func (s *Ec2ReservedInstancesConfiguration) SetMonthlyRecurringCost(v string) *Ec2ReservedInstancesConfiguration {
	s.MonthlyRecurringCost = &v
	return s
}

// SetNormalizedUnitsToPurchase sets the NormalizedUnitsToPurchase field's value.
func (s *Ec2ReservedInstancesConfiguration) SetNormalizedUnitsToPurchase(v string) *Ec2ReservedInstancesConfiguration {
	s.NormalizedUnitsToPurchase = &v
	return s
}

// SetNumberOfInstancesToPurchase sets the NumberOfInstancesToPurchase field's value.
func (s *Ec2ReservedInstancesConfiguration) SetNumberOfInstancesToPurchase(v string) *Ec2ReservedInstancesConfiguration {
	s.NumberOfInstancesToPurchase = &v
	return s
}

// SetOfferingClass sets the OfferingClass field's value.
func (s *Ec2ReservedInstancesConfiguration) SetOfferingClass(v string) *Ec2ReservedInstancesConfiguration {
	s.OfferingClass = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *Ec2ReservedInstancesConfiguration) SetPaymentOption(v string) *Ec2ReservedInstancesConfiguration {
	s.PaymentOption = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Ec2ReservedInstancesConfiguration) SetPlatform(v string) *Ec2ReservedInstancesConfiguration {
	s.Platform = &v
	return s
}

// SetReservedInstancesRegion sets the ReservedInstancesRegion field's value.
func (s *Ec2ReservedInstancesConfiguration) SetReservedInstancesRegion(v string) *Ec2ReservedInstancesConfiguration {
	s.ReservedInstancesRegion = &v
	return s
}

// SetService sets the Service field's value.
func (s *Ec2ReservedInstancesConfiguration) SetService(v string) *Ec2ReservedInstancesConfiguration {
	s.Service = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *Ec2ReservedInstancesConfiguration) SetSizeFlexEligible(v bool) *Ec2ReservedInstancesConfiguration {
	s.SizeFlexEligible = &v
	return s
}

// SetTenancy sets the Tenancy field's value.
func (s *Ec2ReservedInstancesConfiguration) SetTenancy(v string) *Ec2ReservedInstancesConfiguration {
	s.Tenancy = &v
	return s
}

// SetTerm sets the Term field's value.
func (s *Ec2ReservedInstancesConfiguration) SetTerm(v string) *Ec2ReservedInstancesConfiguration {
	s.Term = &v
	return s
}

// SetUpfrontCost sets the UpfrontCost field's value.
func (s *Ec2ReservedInstancesConfiguration) SetUpfrontCost(v string) *Ec2ReservedInstancesConfiguration {
	s.UpfrontCost = &v
	return s
}

// The ECS service recommendation details.
type EcsService struct {
	_ struct{} `type:"structure"`

	// The ECS service configuration used for recommendations.
	Configuration *EcsServiceConfiguration `locationName:"configuration" type:"structure"`

	// Cost impact of the recommendation.
	CostCalculation *ResourceCostCalculation `locationName:"costCalculation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsService) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsService) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *EcsService) SetConfiguration(v *EcsServiceConfiguration) *EcsService {
	s.Configuration = v
	return s
}

// SetCostCalculation sets the CostCalculation field's value.
func (s *EcsService) SetCostCalculation(v *ResourceCostCalculation) *EcsService {
	s.CostCalculation = v
	return s
}

// The ECS service configuration used for recommendations.
type EcsServiceConfiguration struct {
	_ struct{} `type:"structure"`

	// Details about the compute configuration.
	Compute *ComputeConfiguration `locationName:"compute" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsServiceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsServiceConfiguration) GoString() string {
	return s.String()
}

// SetCompute sets the Compute field's value.
func (s *EcsServiceConfiguration) SetCompute(v *ComputeConfiguration) *EcsServiceConfiguration {
	s.Compute = v
	return s
}

// The ElastiCache reserved instances recommendation details.
type ElastiCacheReservedInstances struct {
	_ struct{} `type:"structure"`

	// The ElastiCache reserved instances configuration used for recommendations.
	Configuration *ElastiCacheReservedInstancesConfiguration `locationName:"configuration" type:"structure"`

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation `locationName:"costCalculation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElastiCacheReservedInstances) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElastiCacheReservedInstances) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *ElastiCacheReservedInstances) SetConfiguration(v *ElastiCacheReservedInstancesConfiguration) *ElastiCacheReservedInstances {
	s.Configuration = v
	return s
}

// SetCostCalculation sets the CostCalculation field's value.
func (s *ElastiCacheReservedInstances) SetCostCalculation(v *ReservedInstancesCostCalculation) *ElastiCacheReservedInstances {
	s.CostCalculation = v
	return s
}

// The ElastiCache reserved instances configuration used for recommendations.
type ElastiCacheReservedInstancesConfiguration struct {
	_ struct{} `type:"structure"`

	// The account scope that you want your recommendations for.
	AccountScope *string `locationName:"accountScope" type:"string"`

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *string `locationName:"currentGeneration" type:"string"`

	// The instance family of the recommended reservation.
	InstanceFamily *string `locationName:"instanceFamily" type:"string"`

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// How much purchasing reserved instances costs you on a monthly basis.
	MonthlyRecurringCost *string `locationName:"monthlyRecurringCost" type:"string"`

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	NormalizedUnitsToPurchase *string `locationName:"normalizedUnitsToPurchase" type:"string"`

	// The number of instances that Amazon Web Services recommends that you purchase.
	NumberOfInstancesToPurchase *string `locationName:"numberOfInstancesToPurchase" type:"string"`

	// The payment option for the commitment.
	PaymentOption *string `locationName:"paymentOption" type:"string"`

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string `locationName:"reservedInstancesRegion" type:"string"`

	// The service that you want your recommendations for.
	Service *string `locationName:"service" type:"string"`

	// Determines whether the recommendation is size flexible.
	SizeFlexEligible *bool `locationName:"sizeFlexEligible" type:"boolean"`

	// The reserved instances recommendation term in years.
	Term *string `locationName:"term" type:"string"`

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string `locationName:"upfrontCost" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElastiCacheReservedInstancesConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElastiCacheReservedInstancesConfiguration) GoString() string {
	return s.String()
}

// SetAccountScope sets the AccountScope field's value.
func (s *ElastiCacheReservedInstancesConfiguration) SetAccountScope(v string) *ElastiCacheReservedInstancesConfiguration {
	s.AccountScope = &v
	return s
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *ElastiCacheReservedInstancesConfiguration) SetCurrentGeneration(v string) *ElastiCacheReservedInstancesConfiguration {
	s.CurrentGeneration = &v
	return s
}

// SetInstanceFamily sets the InstanceFamily field's value.
func (s *ElastiCacheReservedInstancesConfiguration) SetInstanceFamily(v string) *ElastiCacheReservedInstancesConfiguration {
	s.InstanceFamily = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ElastiCacheReservedInstancesConfiguration) SetInstanceType(v string) *ElastiCacheReservedInstancesConfiguration {
	s.InstanceType = &v
	return s
}

// SetMonthlyRecurringCost sets the MonthlyRecurringCost field's value.
func (s *ElastiCacheReservedInstancesConfiguration) SetMonthlyRecurringCost(v string) *ElastiCacheReservedInstancesConfiguration {
	s.MonthlyRecurringCost = &v
	return s
}

// SetNormalizedUnitsToPurchase sets the NormalizedUnitsToPurchase field's value.
func (s *ElastiCacheReservedInstancesConfiguration) SetNormalizedUnitsToPurchase(v string) *ElastiCacheReservedInstancesConfiguration {
	s.NormalizedUnitsToPurchase = &v
	return s
}

// SetNumberOfInstancesToPurchase sets the NumberOfInstancesToPurchase field's value.
func (s *ElastiCacheReservedInstancesConfiguration) SetNumberOfInstancesToPurchase(v string) *ElastiCacheReservedInstancesConfiguration {
	s.NumberOfInstancesToPurchase = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *ElastiCacheReservedInstancesConfiguration) SetPaymentOption(v string) *ElastiCacheReservedInstancesConfiguration {
	s.PaymentOption = &v
	return s
}

// SetReservedInstancesRegion sets the ReservedInstancesRegion field's value.
func (s *ElastiCacheReservedInstancesConfiguration) SetReservedInstancesRegion(v string) *ElastiCacheReservedInstancesConfiguration {
	s.ReservedInstancesRegion = &v
	return s
}

// SetService sets the Service field's value.
func (s *ElastiCacheReservedInstancesConfiguration) SetService(v string) *ElastiCacheReservedInstancesConfiguration {
	s.Service = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *ElastiCacheReservedInstancesConfiguration) SetSizeFlexEligible(v bool) *ElastiCacheReservedInstancesConfiguration {
	s.SizeFlexEligible = &v
	return s
}

// SetTerm sets the Term field's value.
func (s *ElastiCacheReservedInstancesConfiguration) SetTerm(v string) *ElastiCacheReservedInstancesConfiguration {
	s.Term = &v
	return s
}

// SetUpfrontCost sets the UpfrontCost field's value.
func (s *ElastiCacheReservedInstancesConfiguration) SetUpfrontCost(v string) *ElastiCacheReservedInstancesConfiguration {
	s.UpfrontCost = &v
	return s
}

// Estimated discount details of the current and recommended resource configuration
// for a recommendation.
type EstimatedDiscounts struct {
	_ struct{} `type:"structure"`

	// Estimated other discounts include all discounts that are not itemized. Itemized
	// discounts include reservedInstanceDiscount and savingsPlansDiscount.
	OtherDiscount *float64 `locationName:"otherDiscount" type:"double"`

	// Estimated reserved instance discounts.
	ReservedInstancesDiscount *float64 `locationName:"reservedInstancesDiscount" type:"double"`

	// Estimated Savings Plans discounts.
	SavingsPlansDiscount *float64 `locationName:"savingsPlansDiscount" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EstimatedDiscounts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EstimatedDiscounts) GoString() string {
	return s.String()
}

// SetOtherDiscount sets the OtherDiscount field's value.
func (s *EstimatedDiscounts) SetOtherDiscount(v float64) *EstimatedDiscounts {
	s.OtherDiscount = &v
	return s
}

// SetReservedInstancesDiscount sets the ReservedInstancesDiscount field's value.
func (s *EstimatedDiscounts) SetReservedInstancesDiscount(v float64) *EstimatedDiscounts {
	s.ReservedInstancesDiscount = &v
	return s
}

// SetSavingsPlansDiscount sets the SavingsPlansDiscount field's value.
func (s *EstimatedDiscounts) SetSavingsPlansDiscount(v float64) *EstimatedDiscounts {
	s.SavingsPlansDiscount = &v
	return s
}

// Describes a filter that returns a more specific list of recommendations.
// Filters recommendations by different dimensions.
type Filter struct {
	_ struct{} `type:"structure"`

	// The account that the recommendation is for.
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list"`

	// The type of action you can take by adopting the recommendation.
	ActionTypes []*string `locationName:"actionTypes" min:"1" type:"list" enum:"ActionType"`

	// The effort required to implement the recommendation.
	ImplementationEfforts []*string `locationName:"implementationEfforts" min:"1" type:"list" enum:"ImplementationEffort"`

	// The IDs for the recommendations.
	RecommendationIds []*string `locationName:"recommendationIds" min:"1" type:"list"`

	// The Amazon Web Services Region of the resource.
	Regions []*string `locationName:"regions" min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the recommendation.
	ResourceArns []*string `locationName:"resourceArns" min:"1" type:"list"`

	// The resource ID of the recommendation.
	ResourceIds []*string `locationName:"resourceIds" min:"1" type:"list"`

	// The resource type of the recommendation.
	ResourceTypes []*string `locationName:"resourceTypes" min:"1" type:"list" enum:"ResourceType"`

	// Whether or not implementing the recommendation requires a restart.
	RestartNeeded *bool `locationName:"restartNeeded" type:"boolean"`

	// Whether or not implementing the recommendation can be rolled back.
	RollbackPossible *bool `locationName:"rollbackPossible" type:"boolean"`

	// A list of tags assigned to the recommendation.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.ActionTypes != nil && len(s.ActionTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionTypes", 1))
	}
	if s.ImplementationEfforts != nil && len(s.ImplementationEfforts) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImplementationEfforts", 1))
	}
	if s.RecommendationIds != nil && len(s.RecommendationIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecommendationIds", 1))
	}
	if s.Regions != nil && len(s.Regions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Regions", 1))
	}
	if s.ResourceArns != nil && len(s.ResourceArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArns", 1))
	}
	if s.ResourceIds != nil && len(s.ResourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIds", 1))
	}
	if s.ResourceTypes != nil && len(s.ResourceTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceTypes", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *Filter) SetAccountIds(v []*string) *Filter {
	s.AccountIds = v
	return s
}

// SetActionTypes sets the ActionTypes field's value.
func (s *Filter) SetActionTypes(v []*string) *Filter {
	s.ActionTypes = v
	return s
}

// SetImplementationEfforts sets the ImplementationEfforts field's value.
func (s *Filter) SetImplementationEfforts(v []*string) *Filter {
	s.ImplementationEfforts = v
	return s
}

// SetRecommendationIds sets the RecommendationIds field's value.
func (s *Filter) SetRecommendationIds(v []*string) *Filter {
	s.RecommendationIds = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *Filter) SetRegions(v []*string) *Filter {
	s.Regions = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *Filter) SetResourceArns(v []*string) *Filter {
	s.ResourceArns = v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *Filter) SetResourceIds(v []*string) *Filter {
	s.ResourceIds = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *Filter) SetResourceTypes(v []*string) *Filter {
	s.ResourceTypes = v
	return s
}

// SetRestartNeeded sets the RestartNeeded field's value.
func (s *Filter) SetRestartNeeded(v bool) *Filter {
	s.RestartNeeded = &v
	return s
}

// SetRollbackPossible sets the RollbackPossible field's value.
func (s *Filter) SetRollbackPossible(v bool) *Filter {
	s.RollbackPossible = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Filter) SetTags(v []*Tag) *Filter {
	s.Tags = v
	return s
}

type GetPreferencesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPreferencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPreferencesInput) GoString() string {
	return s.String()
}

type GetPreferencesOutput struct {
	_ struct{} `type:"structure"`

	// Retrieves the status of the "member account discount visibility" preference.
	MemberAccountDiscountVisibility *string `locationName:"memberAccountDiscountVisibility" type:"string" enum:"MemberAccountDiscountVisibility"`

	// Retrieves the status of the "savings estimation mode" preference.
	SavingsEstimationMode *string `locationName:"savingsEstimationMode" type:"string" enum:"SavingsEstimationMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPreferencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPreferencesOutput) GoString() string {
	return s.String()
}

// SetMemberAccountDiscountVisibility sets the MemberAccountDiscountVisibility field's value.
func (s *GetPreferencesOutput) SetMemberAccountDiscountVisibility(v string) *GetPreferencesOutput {
	s.MemberAccountDiscountVisibility = &v
	return s
}

// SetSavingsEstimationMode sets the SavingsEstimationMode field's value.
func (s *GetPreferencesOutput) SetSavingsEstimationMode(v string) *GetPreferencesOutput {
	s.SavingsEstimationMode = &v
	return s
}

type GetRecommendationInput struct {
	_ struct{} `type:"structure"`

	// The ID for the recommendation.
	//
	// RecommendationId is a required field
	RecommendationId *string `locationName:"recommendationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecommendationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRecommendationInput"}
	if s.RecommendationId == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommendationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *GetRecommendationInput) SetRecommendationId(v string) *GetRecommendationInput {
	s.RecommendationId = &v
	return s
}

type GetRecommendationOutput struct {
	_ struct{} `type:"structure"`

	// The account that the recommendation is for.
	AccountId *string `locationName:"accountId" type:"string"`

	// The type of action you can take by adopting the recommendation.
	ActionType *string `locationName:"actionType" type:"string" enum:"ActionType"`

	// The lookback period used to calculate cost impact for a recommendation.
	CostCalculationLookbackPeriodInDays *int64 `locationName:"costCalculationLookbackPeriodInDays" type:"integer"`

	// The currency code used for the recommendation.
	CurrencyCode *string `locationName:"currencyCode" type:"string"`

	// The details for the resource.
	CurrentResourceDetails *ResourceDetails `locationName:"currentResourceDetails" type:"structure"`

	// The type of resource.
	CurrentResourceType *string `locationName:"currentResourceType" type:"string" enum:"ResourceType"`

	// The estimated monthly cost of the recommendation.
	EstimatedMonthlyCost *float64 `locationName:"estimatedMonthlyCost" type:"double"`

	// The estimated monthly savings amount for the recommendation.
	EstimatedMonthlySavings *float64 `locationName:"estimatedMonthlySavings" type:"double"`

	// The estimated savings amount over the lookback period used to calculate cost
	// impact for a recommendation.
	EstimatedSavingsOverCostCalculationLookbackPeriod *float64 `locationName:"estimatedSavingsOverCostCalculationLookbackPeriod" type:"double"`

	// The estimated savings percentage relative to the total cost over the cost
	// calculation lookback period.
	EstimatedSavingsPercentage *float64 `locationName:"estimatedSavingsPercentage" type:"double"`

	// The effort required to implement the recommendation.
	ImplementationEffort *string `locationName:"implementationEffort" type:"string" enum:"ImplementationEffort"`

	// The time when the recommendation was last generated.
	LastRefreshTimestamp *time.Time `locationName:"lastRefreshTimestamp" type:"timestamp"`

	// The ID for the recommendation.
	RecommendationId *string `locationName:"recommendationId" type:"string"`

	// The lookback period that's used to generate the recommendation.
	RecommendationLookbackPeriodInDays *int64 `locationName:"recommendationLookbackPeriodInDays" type:"integer"`

	// The details about the recommended resource.
	RecommendedResourceDetails *ResourceDetails `locationName:"recommendedResourceDetails" type:"structure"`

	// The resource type of the recommendation.
	RecommendedResourceType *string `locationName:"recommendedResourceType" type:"string" enum:"ResourceType"`

	// The Amazon Web Services Region of the resource.
	Region *string `locationName:"region" type:"string"`

	// The Amazon Resource Name (ARN) of the resource.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// The unique identifier for the resource. This is the same as the Amazon Resource
	// Name (ARN), if available.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// Whether or not implementing the recommendation requires a restart.
	RestartNeeded *bool `locationName:"restartNeeded" type:"boolean"`

	// Whether or not implementing the recommendation can be rolled back.
	RollbackPossible *bool `locationName:"rollbackPossible" type:"boolean"`

	// The source of the recommendation.
	Source *string `locationName:"source" type:"string" enum:"Source"`

	// A list of tags associated with the resource for which the recommendation
	// exists.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationOutput) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *GetRecommendationOutput) SetAccountId(v string) *GetRecommendationOutput {
	s.AccountId = &v
	return s
}

// SetActionType sets the ActionType field's value.
func (s *GetRecommendationOutput) SetActionType(v string) *GetRecommendationOutput {
	s.ActionType = &v
	return s
}

// SetCostCalculationLookbackPeriodInDays sets the CostCalculationLookbackPeriodInDays field's value.
func (s *GetRecommendationOutput) SetCostCalculationLookbackPeriodInDays(v int64) *GetRecommendationOutput {
	s.CostCalculationLookbackPeriodInDays = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *GetRecommendationOutput) SetCurrencyCode(v string) *GetRecommendationOutput {
	s.CurrencyCode = &v
	return s
}

// SetCurrentResourceDetails sets the CurrentResourceDetails field's value.
func (s *GetRecommendationOutput) SetCurrentResourceDetails(v *ResourceDetails) *GetRecommendationOutput {
	s.CurrentResourceDetails = v
	return s
}

// SetCurrentResourceType sets the CurrentResourceType field's value.
func (s *GetRecommendationOutput) SetCurrentResourceType(v string) *GetRecommendationOutput {
	s.CurrentResourceType = &v
	return s
}

// SetEstimatedMonthlyCost sets the EstimatedMonthlyCost field's value.
func (s *GetRecommendationOutput) SetEstimatedMonthlyCost(v float64) *GetRecommendationOutput {
	s.EstimatedMonthlyCost = &v
	return s
}

// SetEstimatedMonthlySavings sets the EstimatedMonthlySavings field's value.
func (s *GetRecommendationOutput) SetEstimatedMonthlySavings(v float64) *GetRecommendationOutput {
	s.EstimatedMonthlySavings = &v
	return s
}

// SetEstimatedSavingsOverCostCalculationLookbackPeriod sets the EstimatedSavingsOverCostCalculationLookbackPeriod field's value.
func (s *GetRecommendationOutput) SetEstimatedSavingsOverCostCalculationLookbackPeriod(v float64) *GetRecommendationOutput {
	s.EstimatedSavingsOverCostCalculationLookbackPeriod = &v
	return s
}

// SetEstimatedSavingsPercentage sets the EstimatedSavingsPercentage field's value.
func (s *GetRecommendationOutput) SetEstimatedSavingsPercentage(v float64) *GetRecommendationOutput {
	s.EstimatedSavingsPercentage = &v
	return s
}

// SetImplementationEffort sets the ImplementationEffort field's value.
func (s *GetRecommendationOutput) SetImplementationEffort(v string) *GetRecommendationOutput {
	s.ImplementationEffort = &v
	return s
}

// SetLastRefreshTimestamp sets the LastRefreshTimestamp field's value.
func (s *GetRecommendationOutput) SetLastRefreshTimestamp(v time.Time) *GetRecommendationOutput {
	s.LastRefreshTimestamp = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *GetRecommendationOutput) SetRecommendationId(v string) *GetRecommendationOutput {
	s.RecommendationId = &v
	return s
}

// SetRecommendationLookbackPeriodInDays sets the RecommendationLookbackPeriodInDays field's value.
func (s *GetRecommendationOutput) SetRecommendationLookbackPeriodInDays(v int64) *GetRecommendationOutput {
	s.RecommendationLookbackPeriodInDays = &v
	return s
}

// SetRecommendedResourceDetails sets the RecommendedResourceDetails field's value.
func (s *GetRecommendationOutput) SetRecommendedResourceDetails(v *ResourceDetails) *GetRecommendationOutput {
	s.RecommendedResourceDetails = v
	return s
}

// SetRecommendedResourceType sets the RecommendedResourceType field's value.
func (s *GetRecommendationOutput) SetRecommendedResourceType(v string) *GetRecommendationOutput {
	s.RecommendedResourceType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *GetRecommendationOutput) SetRegion(v string) *GetRecommendationOutput {
	s.Region = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetRecommendationOutput) SetResourceArn(v string) *GetRecommendationOutput {
	s.ResourceArn = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *GetRecommendationOutput) SetResourceId(v string) *GetRecommendationOutput {
	s.ResourceId = &v
	return s
}

// SetRestartNeeded sets the RestartNeeded field's value.
func (s *GetRecommendationOutput) SetRestartNeeded(v bool) *GetRecommendationOutput {
	s.RestartNeeded = &v
	return s
}

// SetRollbackPossible sets the RollbackPossible field's value.
func (s *GetRecommendationOutput) SetRollbackPossible(v bool) *GetRecommendationOutput {
	s.RollbackPossible = &v
	return s
}

// SetSource sets the Source field's value.
func (s *GetRecommendationOutput) SetSource(v string) *GetRecommendationOutput {
	s.Source = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetRecommendationOutput) SetTags(v []*Tag) *GetRecommendationOutput {
	s.Tags = v
	return s
}

// The Instance configuration used for recommendations.
type InstanceConfiguration struct {
	_ struct{} `type:"structure"`

	// Details about the type.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceConfiguration) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *InstanceConfiguration) SetType(v string) *InstanceConfiguration {
	s.Type = &v
	return s
}

// An error on the server occurred during the processing of your request. Try
// again later.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Lambda function recommendation details.
type LambdaFunction struct {
	_ struct{} `type:"structure"`

	// The Lambda function configuration used for recommendations.
	Configuration *LambdaFunctionConfiguration `locationName:"configuration" type:"structure"`

	// Cost impact of the recommendation.
	CostCalculation *ResourceCostCalculation `locationName:"costCalculation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaFunction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaFunction) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *LambdaFunction) SetConfiguration(v *LambdaFunctionConfiguration) *LambdaFunction {
	s.Configuration = v
	return s
}

// SetCostCalculation sets the CostCalculation field's value.
func (s *LambdaFunction) SetCostCalculation(v *ResourceCostCalculation) *LambdaFunction {
	s.CostCalculation = v
	return s
}

// The Lambda function configuration used for recommendations.
type LambdaFunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// Details about the compute configuration.
	Compute *ComputeConfiguration `locationName:"compute" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaFunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaFunctionConfiguration) GoString() string {
	return s.String()
}

// SetCompute sets the Compute field's value.
func (s *LambdaFunctionConfiguration) SetCompute(v *ComputeConfiguration) *LambdaFunctionConfiguration {
	s.Compute = v
	return s
}

type ListEnrollmentStatusesInput struct {
	_ struct{} `type:"structure"`

	// The enrollment status of a specific account ID in the organization.
	AccountId *string `locationName:"accountId" type:"string"`

	// Indicates whether to return the enrollment status for the organization.
	IncludeOrganizationInfo *bool `locationName:"includeOrganizationInfo" type:"boolean"`

	// The maximum number of objects that are returned for the request.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnrollmentStatusesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnrollmentStatusesInput) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ListEnrollmentStatusesInput) SetAccountId(v string) *ListEnrollmentStatusesInput {
	s.AccountId = &v
	return s
}

// SetIncludeOrganizationInfo sets the IncludeOrganizationInfo field's value.
func (s *ListEnrollmentStatusesInput) SetIncludeOrganizationInfo(v bool) *ListEnrollmentStatusesInput {
	s.IncludeOrganizationInfo = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEnrollmentStatusesInput) SetMaxResults(v int64) *ListEnrollmentStatusesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnrollmentStatusesInput) SetNextToken(v string) *ListEnrollmentStatusesInput {
	s.NextToken = &v
	return s
}

type ListEnrollmentStatusesOutput struct {
	_ struct{} `type:"structure"`

	// The account enrollment statuses.
	Items []*AccountEnrollmentStatus `locationName:"items" type:"list"`

	// The token to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnrollmentStatusesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnrollmentStatusesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListEnrollmentStatusesOutput) SetItems(v []*AccountEnrollmentStatus) *ListEnrollmentStatusesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnrollmentStatusesOutput) SetNextToken(v string) *ListEnrollmentStatusesOutput {
	s.NextToken = &v
	return s
}

type ListRecommendationSummariesInput struct {
	_ struct{} `type:"structure"`

	// Describes a filter that returns a more specific list of recommendations.
	// Filters recommendations by different dimensions.
	Filter *Filter `locationName:"filter" type:"structure"`

	// The grouping of recommendations by a dimension.
	//
	// GroupBy is a required field
	GroupBy *string `locationName:"groupBy" type:"string" required:"true"`

	// The maximum number of recommendations that are returned for the request.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationSummariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecommendationSummariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecommendationSummariesInput"}
	if s.GroupBy == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupBy"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListRecommendationSummariesInput) SetFilter(v *Filter) *ListRecommendationSummariesInput {
	s.Filter = v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *ListRecommendationSummariesInput) SetGroupBy(v string) *ListRecommendationSummariesInput {
	s.GroupBy = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecommendationSummariesInput) SetMaxResults(v int64) *ListRecommendationSummariesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationSummariesInput) SetNextToken(v string) *ListRecommendationSummariesInput {
	s.NextToken = &v
	return s
}

type ListRecommendationSummariesOutput struct {
	_ struct{} `type:"structure"`

	// The currency code used for the recommendation.
	CurrencyCode *string `locationName:"currencyCode" type:"string"`

	// The total overall savings for the aggregated view.
	EstimatedTotalDedupedSavings *float64 `locationName:"estimatedTotalDedupedSavings" type:"double"`

	// The dimension used to group the recommendations by.
	GroupBy *string `locationName:"groupBy" type:"string"`

	// List of all savings recommendations.
	Items []*RecommendationSummary `locationName:"items" type:"list"`

	// The token to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationSummariesOutput) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ListRecommendationSummariesOutput) SetCurrencyCode(v string) *ListRecommendationSummariesOutput {
	s.CurrencyCode = &v
	return s
}

// SetEstimatedTotalDedupedSavings sets the EstimatedTotalDedupedSavings field's value.
func (s *ListRecommendationSummariesOutput) SetEstimatedTotalDedupedSavings(v float64) *ListRecommendationSummariesOutput {
	s.EstimatedTotalDedupedSavings = &v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *ListRecommendationSummariesOutput) SetGroupBy(v string) *ListRecommendationSummariesOutput {
	s.GroupBy = &v
	return s
}

// SetItems sets the Items field's value.
func (s *ListRecommendationSummariesOutput) SetItems(v []*RecommendationSummary) *ListRecommendationSummariesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationSummariesOutput) SetNextToken(v string) *ListRecommendationSummariesOutput {
	s.NextToken = &v
	return s
}

type ListRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The constraints that you want all returned recommendations to match.
	Filter *Filter `locationName:"filter" type:"structure"`

	// List of all recommendations for a resource, or a single recommendation if
	// de-duped by resourceId.
	IncludeAllRecommendations *bool `locationName:"includeAllRecommendations" type:"boolean"`

	// The maximum number of recommendations that are returned for the request.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ordering of recommendations by a dimension.
	OrderBy *OrderBy `locationName:"orderBy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecommendationsInput"}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListRecommendationsInput) SetFilter(v *Filter) *ListRecommendationsInput {
	s.Filter = v
	return s
}

// SetIncludeAllRecommendations sets the IncludeAllRecommendations field's value.
func (s *ListRecommendationsInput) SetIncludeAllRecommendations(v bool) *ListRecommendationsInput {
	s.IncludeAllRecommendations = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecommendationsInput) SetMaxResults(v int64) *ListRecommendationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationsInput) SetNextToken(v string) *ListRecommendationsInput {
	s.NextToken = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *ListRecommendationsInput) SetOrderBy(v *OrderBy) *ListRecommendationsInput {
	s.OrderBy = v
	return s
}

type ListRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// List of all savings recommendations.
	Items []*Recommendation `locationName:"items" type:"list"`

	// The token to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListRecommendationsOutput) SetItems(v []*Recommendation) *ListRecommendationsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationsOutput) SetNextToken(v string) *ListRecommendationsOutput {
	s.NextToken = &v
	return s
}

// The OpenSearch reserved instances recommendation details.
type OpenSearchReservedInstances struct {
	_ struct{} `type:"structure"`

	// The OpenSearch reserved instances configuration used for recommendations.
	Configuration *OpenSearchReservedInstancesConfiguration `locationName:"configuration" type:"structure"`

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation `locationName:"costCalculation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenSearchReservedInstances) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenSearchReservedInstances) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *OpenSearchReservedInstances) SetConfiguration(v *OpenSearchReservedInstancesConfiguration) *OpenSearchReservedInstances {
	s.Configuration = v
	return s
}

// SetCostCalculation sets the CostCalculation field's value.
func (s *OpenSearchReservedInstances) SetCostCalculation(v *ReservedInstancesCostCalculation) *OpenSearchReservedInstances {
	s.CostCalculation = v
	return s
}

// The OpenSearch reserved instances configuration used for recommendations.
type OpenSearchReservedInstancesConfiguration struct {
	_ struct{} `type:"structure"`

	// The account scope that you want your recommendations for.
	AccountScope *string `locationName:"accountScope" type:"string"`

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *string `locationName:"currentGeneration" type:"string"`

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// How much purchasing reserved instances costs you on a monthly basis.
	MonthlyRecurringCost *string `locationName:"monthlyRecurringCost" type:"string"`

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	NormalizedUnitsToPurchase *string `locationName:"normalizedUnitsToPurchase" type:"string"`

	// The number of instances that Amazon Web Services recommends that you purchase.
	NumberOfInstancesToPurchase *string `locationName:"numberOfInstancesToPurchase" type:"string"`

	// The payment option for the commitment.
	PaymentOption *string `locationName:"paymentOption" type:"string"`

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string `locationName:"reservedInstancesRegion" type:"string"`

	// The service that you want your recommendations for.
	Service *string `locationName:"service" type:"string"`

	// Determines whether the recommendation is size flexible.
	SizeFlexEligible *bool `locationName:"sizeFlexEligible" type:"boolean"`

	// The reserved instances recommendation term in years.
	Term *string `locationName:"term" type:"string"`

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string `locationName:"upfrontCost" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenSearchReservedInstancesConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenSearchReservedInstancesConfiguration) GoString() string {
	return s.String()
}

// SetAccountScope sets the AccountScope field's value.
func (s *OpenSearchReservedInstancesConfiguration) SetAccountScope(v string) *OpenSearchReservedInstancesConfiguration {
	s.AccountScope = &v
	return s
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *OpenSearchReservedInstancesConfiguration) SetCurrentGeneration(v string) *OpenSearchReservedInstancesConfiguration {
	s.CurrentGeneration = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *OpenSearchReservedInstancesConfiguration) SetInstanceType(v string) *OpenSearchReservedInstancesConfiguration {
	s.InstanceType = &v
	return s
}

// SetMonthlyRecurringCost sets the MonthlyRecurringCost field's value.
func (s *OpenSearchReservedInstancesConfiguration) SetMonthlyRecurringCost(v string) *OpenSearchReservedInstancesConfiguration {
	s.MonthlyRecurringCost = &v
	return s
}

// SetNormalizedUnitsToPurchase sets the NormalizedUnitsToPurchase field's value.
func (s *OpenSearchReservedInstancesConfiguration) SetNormalizedUnitsToPurchase(v string) *OpenSearchReservedInstancesConfiguration {
	s.NormalizedUnitsToPurchase = &v
	return s
}

// SetNumberOfInstancesToPurchase sets the NumberOfInstancesToPurchase field's value.
func (s *OpenSearchReservedInstancesConfiguration) SetNumberOfInstancesToPurchase(v string) *OpenSearchReservedInstancesConfiguration {
	s.NumberOfInstancesToPurchase = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *OpenSearchReservedInstancesConfiguration) SetPaymentOption(v string) *OpenSearchReservedInstancesConfiguration {
	s.PaymentOption = &v
	return s
}

// SetReservedInstancesRegion sets the ReservedInstancesRegion field's value.
func (s *OpenSearchReservedInstancesConfiguration) SetReservedInstancesRegion(v string) *OpenSearchReservedInstancesConfiguration {
	s.ReservedInstancesRegion = &v
	return s
}

// SetService sets the Service field's value.
func (s *OpenSearchReservedInstancesConfiguration) SetService(v string) *OpenSearchReservedInstancesConfiguration {
	s.Service = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *OpenSearchReservedInstancesConfiguration) SetSizeFlexEligible(v bool) *OpenSearchReservedInstancesConfiguration {
	s.SizeFlexEligible = &v
	return s
}

// SetTerm sets the Term field's value.
func (s *OpenSearchReservedInstancesConfiguration) SetTerm(v string) *OpenSearchReservedInstancesConfiguration {
	s.Term = &v
	return s
}

// SetUpfrontCost sets the UpfrontCost field's value.
func (s *OpenSearchReservedInstancesConfiguration) SetUpfrontCost(v string) *OpenSearchReservedInstancesConfiguration {
	s.UpfrontCost = &v
	return s
}

// Defines how rows will be sorted in the response.
type OrderBy struct {
	_ struct{} `type:"structure"`

	// Sorts by dimension values.
	Dimension *string `locationName:"dimension" type:"string"`

	// The order that's used to sort the data.
	Order *string `locationName:"order" type:"string" enum:"Order"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrderBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrderBy) GoString() string {
	return s.String()
}

// SetDimension sets the Dimension field's value.
func (s *OrderBy) SetDimension(v string) *OrderBy {
	s.Dimension = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *OrderBy) SetOrder(v string) *OrderBy {
	s.Order = &v
	return s
}

// The RDS reserved instances recommendation details.
type RdsReservedInstances struct {
	_ struct{} `type:"structure"`

	// The RDS reserved instances configuration used for recommendations.
	Configuration *RdsReservedInstancesConfiguration `locationName:"configuration" type:"structure"`

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation `locationName:"costCalculation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RdsReservedInstances) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RdsReservedInstances) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *RdsReservedInstances) SetConfiguration(v *RdsReservedInstancesConfiguration) *RdsReservedInstances {
	s.Configuration = v
	return s
}

// SetCostCalculation sets the CostCalculation field's value.
func (s *RdsReservedInstances) SetCostCalculation(v *ReservedInstancesCostCalculation) *RdsReservedInstances {
	s.CostCalculation = v
	return s
}

// The RDS reserved instances configuration used for recommendations.
type RdsReservedInstancesConfiguration struct {
	_ struct{} `type:"structure"`

	// The account scope that you want your recommendations for.
	AccountScope *string `locationName:"accountScope" type:"string"`

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *string `locationName:"currentGeneration" type:"string"`

	// The database edition that the recommended reservation supports.
	DatabaseEdition *string `locationName:"databaseEdition" type:"string"`

	// The database engine that the recommended reservation supports.
	DatabaseEngine *string `locationName:"databaseEngine" type:"string"`

	// Determines whether the recommendation is for a reservation in a single Availability
	// Zone or a reservation with a backup in a second Availability Zone.
	DeploymentOption *string `locationName:"deploymentOption" type:"string"`

	// The instance family of the recommended reservation.
	InstanceFamily *string `locationName:"instanceFamily" type:"string"`

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The license model that the recommended reservation supports.
	LicenseModel *string `locationName:"licenseModel" type:"string"`

	// How much purchasing this instance costs you on a monthly basis.
	MonthlyRecurringCost *string `locationName:"monthlyRecurringCost" type:"string"`

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	NormalizedUnitsToPurchase *string `locationName:"normalizedUnitsToPurchase" type:"string"`

	// The number of instances that Amazon Web Services recommends that you purchase.
	NumberOfInstancesToPurchase *string `locationName:"numberOfInstancesToPurchase" type:"string"`

	// The payment option for the commitment.
	PaymentOption *string `locationName:"paymentOption" type:"string"`

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string `locationName:"reservedInstancesRegion" type:"string"`

	// The service that you want your recommendations for.
	Service *string `locationName:"service" type:"string"`

	// Determines whether the recommendation is size flexible.
	SizeFlexEligible *bool `locationName:"sizeFlexEligible" type:"boolean"`

	// The reserved instances recommendation term in years.
	Term *string `locationName:"term" type:"string"`

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string `locationName:"upfrontCost" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RdsReservedInstancesConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RdsReservedInstancesConfiguration) GoString() string {
	return s.String()
}

// SetAccountScope sets the AccountScope field's value.
func (s *RdsReservedInstancesConfiguration) SetAccountScope(v string) *RdsReservedInstancesConfiguration {
	s.AccountScope = &v
	return s
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *RdsReservedInstancesConfiguration) SetCurrentGeneration(v string) *RdsReservedInstancesConfiguration {
	s.CurrentGeneration = &v
	return s
}

// SetDatabaseEdition sets the DatabaseEdition field's value.
func (s *RdsReservedInstancesConfiguration) SetDatabaseEdition(v string) *RdsReservedInstancesConfiguration {
	s.DatabaseEdition = &v
	return s
}

// SetDatabaseEngine sets the DatabaseEngine field's value.
func (s *RdsReservedInstancesConfiguration) SetDatabaseEngine(v string) *RdsReservedInstancesConfiguration {
	s.DatabaseEngine = &v
	return s
}

// SetDeploymentOption sets the DeploymentOption field's value.
func (s *RdsReservedInstancesConfiguration) SetDeploymentOption(v string) *RdsReservedInstancesConfiguration {
	s.DeploymentOption = &v
	return s
}

// SetInstanceFamily sets the InstanceFamily field's value.
func (s *RdsReservedInstancesConfiguration) SetInstanceFamily(v string) *RdsReservedInstancesConfiguration {
	s.InstanceFamily = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *RdsReservedInstancesConfiguration) SetInstanceType(v string) *RdsReservedInstancesConfiguration {
	s.InstanceType = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *RdsReservedInstancesConfiguration) SetLicenseModel(v string) *RdsReservedInstancesConfiguration {
	s.LicenseModel = &v
	return s
}

// SetMonthlyRecurringCost sets the MonthlyRecurringCost field's value.
func (s *RdsReservedInstancesConfiguration) SetMonthlyRecurringCost(v string) *RdsReservedInstancesConfiguration {
	s.MonthlyRecurringCost = &v
	return s
}

// SetNormalizedUnitsToPurchase sets the NormalizedUnitsToPurchase field's value.
func (s *RdsReservedInstancesConfiguration) SetNormalizedUnitsToPurchase(v string) *RdsReservedInstancesConfiguration {
	s.NormalizedUnitsToPurchase = &v
	return s
}

// SetNumberOfInstancesToPurchase sets the NumberOfInstancesToPurchase field's value.
func (s *RdsReservedInstancesConfiguration) SetNumberOfInstancesToPurchase(v string) *RdsReservedInstancesConfiguration {
	s.NumberOfInstancesToPurchase = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *RdsReservedInstancesConfiguration) SetPaymentOption(v string) *RdsReservedInstancesConfiguration {
	s.PaymentOption = &v
	return s
}

// SetReservedInstancesRegion sets the ReservedInstancesRegion field's value.
func (s *RdsReservedInstancesConfiguration) SetReservedInstancesRegion(v string) *RdsReservedInstancesConfiguration {
	s.ReservedInstancesRegion = &v
	return s
}

// SetService sets the Service field's value.
func (s *RdsReservedInstancesConfiguration) SetService(v string) *RdsReservedInstancesConfiguration {
	s.Service = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *RdsReservedInstancesConfiguration) SetSizeFlexEligible(v bool) *RdsReservedInstancesConfiguration {
	s.SizeFlexEligible = &v
	return s
}

// SetTerm sets the Term field's value.
func (s *RdsReservedInstancesConfiguration) SetTerm(v string) *RdsReservedInstancesConfiguration {
	s.Term = &v
	return s
}

// SetUpfrontCost sets the UpfrontCost field's value.
func (s *RdsReservedInstancesConfiguration) SetUpfrontCost(v string) *RdsReservedInstancesConfiguration {
	s.UpfrontCost = &v
	return s
}

// Describes a recommendation.
type Recommendation struct {
	_ struct{} `type:"structure"`

	// The account that the recommendation is for.
	AccountId *string `locationName:"accountId" type:"string"`

	// The type of tasks that can be carried out by this action.
	ActionType *string `locationName:"actionType" type:"string"`

	// The currency code used for the recommendation.
	CurrencyCode *string `locationName:"currencyCode" type:"string"`

	// Describes the current resource.
	CurrentResourceSummary *string `locationName:"currentResourceSummary" type:"string"`

	// The current resource type.
	CurrentResourceType *string `locationName:"currentResourceType" type:"string"`

	// The estimated monthly cost for the recommendation.
	EstimatedMonthlyCost *float64 `locationName:"estimatedMonthlyCost" type:"double"`

	// The estimated monthly savings amount for the recommendation.
	EstimatedMonthlySavings *float64 `locationName:"estimatedMonthlySavings" type:"double"`

	// The estimated savings percentage relative to the total cost over the cost
	// calculation lookback period.
	EstimatedSavingsPercentage *float64 `locationName:"estimatedSavingsPercentage" type:"double"`

	// The effort required to implement the recommendation.
	ImplementationEffort *string `locationName:"implementationEffort" type:"string"`

	// The time when the recommendation was last generated.
	LastRefreshTimestamp *time.Time `locationName:"lastRefreshTimestamp" type:"timestamp"`

	// The ID for the recommendation.
	RecommendationId *string `locationName:"recommendationId" type:"string"`

	// The lookback period that's used to generate the recommendation.
	RecommendationLookbackPeriodInDays *int64 `locationName:"recommendationLookbackPeriodInDays" type:"integer"`

	// Describes the recommended resource.
	RecommendedResourceSummary *string `locationName:"recommendedResourceSummary" type:"string"`

	// The recommended resource type.
	RecommendedResourceType *string `locationName:"recommendedResourceType" type:"string"`

	// The Amazon Web Services Region of the resource.
	Region *string `locationName:"region" type:"string"`

	// The Amazon Resource Name (ARN) for the recommendation.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// The resource ID for the recommendation.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// Whether or not implementing the recommendation requires a restart.
	RestartNeeded *bool `locationName:"restartNeeded" type:"boolean"`

	// Whether or not implementing the recommendation can be rolled back.
	RollbackPossible *bool `locationName:"rollbackPossible" type:"boolean"`

	// The source of the recommendation.
	Source *string `locationName:"source" type:"string" enum:"Source"`

	// A list of tags assigned to the recommendation.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommendation) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Recommendation) SetAccountId(v string) *Recommendation {
	s.AccountId = &v
	return s
}

// SetActionType sets the ActionType field's value.
func (s *Recommendation) SetActionType(v string) *Recommendation {
	s.ActionType = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *Recommendation) SetCurrencyCode(v string) *Recommendation {
	s.CurrencyCode = &v
	return s
}

// SetCurrentResourceSummary sets the CurrentResourceSummary field's value.
func (s *Recommendation) SetCurrentResourceSummary(v string) *Recommendation {
	s.CurrentResourceSummary = &v
	return s
}

// SetCurrentResourceType sets the CurrentResourceType field's value.
func (s *Recommendation) SetCurrentResourceType(v string) *Recommendation {
	s.CurrentResourceType = &v
	return s
}

// SetEstimatedMonthlyCost sets the EstimatedMonthlyCost field's value.
func (s *Recommendation) SetEstimatedMonthlyCost(v float64) *Recommendation {
	s.EstimatedMonthlyCost = &v
	return s
}

// SetEstimatedMonthlySavings sets the EstimatedMonthlySavings field's value.
func (s *Recommendation) SetEstimatedMonthlySavings(v float64) *Recommendation {
	s.EstimatedMonthlySavings = &v
	return s
}

// SetEstimatedSavingsPercentage sets the EstimatedSavingsPercentage field's value.
func (s *Recommendation) SetEstimatedSavingsPercentage(v float64) *Recommendation {
	s.EstimatedSavingsPercentage = &v
	return s
}

// SetImplementationEffort sets the ImplementationEffort field's value.
func (s *Recommendation) SetImplementationEffort(v string) *Recommendation {
	s.ImplementationEffort = &v
	return s
}

// SetLastRefreshTimestamp sets the LastRefreshTimestamp field's value.
func (s *Recommendation) SetLastRefreshTimestamp(v time.Time) *Recommendation {
	s.LastRefreshTimestamp = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *Recommendation) SetRecommendationId(v string) *Recommendation {
	s.RecommendationId = &v
	return s
}

// SetRecommendationLookbackPeriodInDays sets the RecommendationLookbackPeriodInDays field's value.
func (s *Recommendation) SetRecommendationLookbackPeriodInDays(v int64) *Recommendation {
	s.RecommendationLookbackPeriodInDays = &v
	return s
}

// SetRecommendedResourceSummary sets the RecommendedResourceSummary field's value.
func (s *Recommendation) SetRecommendedResourceSummary(v string) *Recommendation {
	s.RecommendedResourceSummary = &v
	return s
}

// SetRecommendedResourceType sets the RecommendedResourceType field's value.
func (s *Recommendation) SetRecommendedResourceType(v string) *Recommendation {
	s.RecommendedResourceType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Recommendation) SetRegion(v string) *Recommendation {
	s.Region = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *Recommendation) SetResourceArn(v string) *Recommendation {
	s.ResourceArn = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *Recommendation) SetResourceId(v string) *Recommendation {
	s.ResourceId = &v
	return s
}

// SetRestartNeeded sets the RestartNeeded field's value.
func (s *Recommendation) SetRestartNeeded(v bool) *Recommendation {
	s.RestartNeeded = &v
	return s
}

// SetRollbackPossible sets the RollbackPossible field's value.
func (s *Recommendation) SetRollbackPossible(v bool) *Recommendation {
	s.RollbackPossible = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Recommendation) SetSource(v string) *Recommendation {
	s.Source = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Recommendation) SetTags(v []*Tag) *Recommendation {
	s.Tags = v
	return s
}

// The summary of rightsizing recommendations, including de-duped savings from
// all types of recommendations.
type RecommendationSummary struct {
	_ struct{} `type:"structure"`

	// The estimated total savings resulting from modifications, on a monthly basis.
	EstimatedMonthlySavings *float64 `locationName:"estimatedMonthlySavings" type:"double"`

	// The grouping of recommendations.
	Group *string `locationName:"group" type:"string"`

	// The total number of instance recommendations.
	RecommendationCount *int64 `locationName:"recommendationCount" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationSummary) GoString() string {
	return s.String()
}

// SetEstimatedMonthlySavings sets the EstimatedMonthlySavings field's value.
func (s *RecommendationSummary) SetEstimatedMonthlySavings(v float64) *RecommendationSummary {
	s.EstimatedMonthlySavings = &v
	return s
}

// SetGroup sets the Group field's value.
func (s *RecommendationSummary) SetGroup(v string) *RecommendationSummary {
	s.Group = &v
	return s
}

// SetRecommendationCount sets the RecommendationCount field's value.
func (s *RecommendationSummary) SetRecommendationCount(v int64) *RecommendationSummary {
	s.RecommendationCount = &v
	return s
}

// The Redshift reserved instances recommendation details.
type RedshiftReservedInstances struct {
	_ struct{} `type:"structure"`

	// The Redshift reserved instances configuration used for recommendations.
	Configuration *RedshiftReservedInstancesConfiguration `locationName:"configuration" type:"structure"`

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation `locationName:"costCalculation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftReservedInstances) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftReservedInstances) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *RedshiftReservedInstances) SetConfiguration(v *RedshiftReservedInstancesConfiguration) *RedshiftReservedInstances {
	s.Configuration = v
	return s
}

// SetCostCalculation sets the CostCalculation field's value.
func (s *RedshiftReservedInstances) SetCostCalculation(v *ReservedInstancesCostCalculation) *RedshiftReservedInstances {
	s.CostCalculation = v
	return s
}

// The Redshift reserved instances configuration used for recommendations.
type RedshiftReservedInstancesConfiguration struct {
	_ struct{} `type:"structure"`

	// The account scope that you want your recommendations for.
	AccountScope *string `locationName:"accountScope" type:"string"`

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *string `locationName:"currentGeneration" type:"string"`

	// The instance family of the recommended reservation.
	InstanceFamily *string `locationName:"instanceFamily" type:"string"`

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// How much purchasing reserved instances costs you on a monthly basis.
	MonthlyRecurringCost *string `locationName:"monthlyRecurringCost" type:"string"`

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	NormalizedUnitsToPurchase *string `locationName:"normalizedUnitsToPurchase" type:"string"`

	// The number of instances that Amazon Web Services recommends that you purchase.
	NumberOfInstancesToPurchase *string `locationName:"numberOfInstancesToPurchase" type:"string"`

	// The payment option for the commitment.
	PaymentOption *string `locationName:"paymentOption" type:"string"`

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string `locationName:"reservedInstancesRegion" type:"string"`

	// The service that you want your recommendations for.
	Service *string `locationName:"service" type:"string"`

	// Determines whether the recommendation is size flexible.
	SizeFlexEligible *bool `locationName:"sizeFlexEligible" type:"boolean"`

	// The reserved instances recommendation term in years.
	Term *string `locationName:"term" type:"string"`

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string `locationName:"upfrontCost" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftReservedInstancesConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftReservedInstancesConfiguration) GoString() string {
	return s.String()
}

// SetAccountScope sets the AccountScope field's value.
func (s *RedshiftReservedInstancesConfiguration) SetAccountScope(v string) *RedshiftReservedInstancesConfiguration {
	s.AccountScope = &v
	return s
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *RedshiftReservedInstancesConfiguration) SetCurrentGeneration(v string) *RedshiftReservedInstancesConfiguration {
	s.CurrentGeneration = &v
	return s
}

// SetInstanceFamily sets the InstanceFamily field's value.
func (s *RedshiftReservedInstancesConfiguration) SetInstanceFamily(v string) *RedshiftReservedInstancesConfiguration {
	s.InstanceFamily = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *RedshiftReservedInstancesConfiguration) SetInstanceType(v string) *RedshiftReservedInstancesConfiguration {
	s.InstanceType = &v
	return s
}

// SetMonthlyRecurringCost sets the MonthlyRecurringCost field's value.
func (s *RedshiftReservedInstancesConfiguration) SetMonthlyRecurringCost(v string) *RedshiftReservedInstancesConfiguration {
	s.MonthlyRecurringCost = &v
	return s
}

// SetNormalizedUnitsToPurchase sets the NormalizedUnitsToPurchase field's value.
func (s *RedshiftReservedInstancesConfiguration) SetNormalizedUnitsToPurchase(v string) *RedshiftReservedInstancesConfiguration {
	s.NormalizedUnitsToPurchase = &v
	return s
}

// SetNumberOfInstancesToPurchase sets the NumberOfInstancesToPurchase field's value.
func (s *RedshiftReservedInstancesConfiguration) SetNumberOfInstancesToPurchase(v string) *RedshiftReservedInstancesConfiguration {
	s.NumberOfInstancesToPurchase = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *RedshiftReservedInstancesConfiguration) SetPaymentOption(v string) *RedshiftReservedInstancesConfiguration {
	s.PaymentOption = &v
	return s
}

// SetReservedInstancesRegion sets the ReservedInstancesRegion field's value.
func (s *RedshiftReservedInstancesConfiguration) SetReservedInstancesRegion(v string) *RedshiftReservedInstancesConfiguration {
	s.ReservedInstancesRegion = &v
	return s
}

// SetService sets the Service field's value.
func (s *RedshiftReservedInstancesConfiguration) SetService(v string) *RedshiftReservedInstancesConfiguration {
	s.Service = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *RedshiftReservedInstancesConfiguration) SetSizeFlexEligible(v bool) *RedshiftReservedInstancesConfiguration {
	s.SizeFlexEligible = &v
	return s
}

// SetTerm sets the Term field's value.
func (s *RedshiftReservedInstancesConfiguration) SetTerm(v string) *RedshiftReservedInstancesConfiguration {
	s.Term = &v
	return s
}

// SetUpfrontCost sets the UpfrontCost field's value.
func (s *RedshiftReservedInstancesConfiguration) SetUpfrontCost(v string) *RedshiftReservedInstancesConfiguration {
	s.UpfrontCost = &v
	return s
}

// Cost impact of the purchase recommendation.
type ReservedInstancesCostCalculation struct {
	_ struct{} `type:"structure"`

	// Pricing details of the purchase recommendation.
	Pricing *ReservedInstancesPricing `locationName:"pricing" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservedInstancesCostCalculation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservedInstancesCostCalculation) GoString() string {
	return s.String()
}

// SetPricing sets the Pricing field's value.
func (s *ReservedInstancesCostCalculation) SetPricing(v *ReservedInstancesPricing) *ReservedInstancesCostCalculation {
	s.Pricing = v
	return s
}

// Pricing details for your recommended reserved instance.
type ReservedInstancesPricing struct {
	_ struct{} `type:"structure"`

	// The estimated cost of your recurring monthly fees for the recommended reserved
	// instance across the month.
	EstimatedMonthlyAmortizedReservationCost *float64 `locationName:"estimatedMonthlyAmortizedReservationCost" type:"double"`

	// The remaining On-Demand cost estimated to not be covered by the recommended
	// reserved instance, over the length of the lookback period.
	EstimatedOnDemandCost *float64 `locationName:"estimatedOnDemandCost" type:"double"`

	// The cost of paying for the recommended reserved instance monthly.
	MonthlyReservationEligibleCost *float64 `locationName:"monthlyReservationEligibleCost" type:"double"`

	// The savings percentage relative to the total On-Demand costs that are associated
	// with this instance.
	SavingsPercentage *float64 `locationName:"savingsPercentage" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservedInstancesPricing) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservedInstancesPricing) GoString() string {
	return s.String()
}

// SetEstimatedMonthlyAmortizedReservationCost sets the EstimatedMonthlyAmortizedReservationCost field's value.
func (s *ReservedInstancesPricing) SetEstimatedMonthlyAmortizedReservationCost(v float64) *ReservedInstancesPricing {
	s.EstimatedMonthlyAmortizedReservationCost = &v
	return s
}

// SetEstimatedOnDemandCost sets the EstimatedOnDemandCost field's value.
func (s *ReservedInstancesPricing) SetEstimatedOnDemandCost(v float64) *ReservedInstancesPricing {
	s.EstimatedOnDemandCost = &v
	return s
}

// SetMonthlyReservationEligibleCost sets the MonthlyReservationEligibleCost field's value.
func (s *ReservedInstancesPricing) SetMonthlyReservationEligibleCost(v float64) *ReservedInstancesPricing {
	s.MonthlyReservationEligibleCost = &v
	return s
}

// SetSavingsPercentage sets the SavingsPercentage field's value.
func (s *ReservedInstancesPricing) SetSavingsPercentage(v float64) *ReservedInstancesPricing {
	s.SavingsPercentage = &v
	return s
}

// Cost impact of the resource recommendation.
type ResourceCostCalculation struct {
	_ struct{} `type:"structure"`

	// Pricing details of the resource recommendation.
	Pricing *ResourcePricing `locationName:"pricing" type:"structure"`

	// Usage details of the resource recommendation.
	Usages []*Usage `locationName:"usages" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceCostCalculation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceCostCalculation) GoString() string {
	return s.String()
}

// SetPricing sets the Pricing field's value.
func (s *ResourceCostCalculation) SetPricing(v *ResourcePricing) *ResourceCostCalculation {
	s.Pricing = v
	return s
}

// SetUsages sets the Usages field's value.
func (s *ResourceCostCalculation) SetUsages(v []*Usage) *ResourceCostCalculation {
	s.Usages = v
	return s
}

// Contains detailed information about the specified resource.
type ResourceDetails struct {
	_ struct{} `type:"structure"`

	// The Compute Savings Plans recommendation details.
	ComputeSavingsPlans *ComputeSavingsPlans `locationName:"computeSavingsPlans" type:"structure"`

	// The Amazon Elastic Block Store volume recommendation details.
	EbsVolume *EbsVolume `locationName:"ebsVolume" type:"structure"`

	// The EC2 Auto Scaling group recommendation details.
	Ec2AutoScalingGroup *Ec2AutoScalingGroup `locationName:"ec2AutoScalingGroup" type:"structure"`

	// The EC2 instance recommendation details.
	Ec2Instance *Ec2Instance `locationName:"ec2Instance" type:"structure"`

	// The EC2 instance Savings Plans recommendation details.
	Ec2InstanceSavingsPlans *Ec2InstanceSavingsPlans `locationName:"ec2InstanceSavingsPlans" type:"structure"`

	// The EC2 reserved instances recommendation details.
	Ec2ReservedInstances *Ec2ReservedInstances `locationName:"ec2ReservedInstances" type:"structure"`

	// The ECS service recommendation details.
	EcsService *EcsService `locationName:"ecsService" type:"structure"`

	// The ElastiCache reserved instances recommendation details.
	ElastiCacheReservedInstances *ElastiCacheReservedInstances `locationName:"elastiCacheReservedInstances" type:"structure"`

	// The Lambda function recommendation details.
	LambdaFunction *LambdaFunction `locationName:"lambdaFunction" type:"structure"`

	// The OpenSearch reserved instances recommendation details.
	OpenSearchReservedInstances *OpenSearchReservedInstances `locationName:"openSearchReservedInstances" type:"structure"`

	// The RDS reserved instances recommendation details.
	RdsReservedInstances *RdsReservedInstances `locationName:"rdsReservedInstances" type:"structure"`

	// The Redshift reserved instances recommendation details.
	RedshiftReservedInstances *RedshiftReservedInstances `locationName:"redshiftReservedInstances" type:"structure"`

	// The SageMaker Savings Plans recommendation details.
	SageMakerSavingsPlans *SageMakerSavingsPlans `locationName:"sageMakerSavingsPlans" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDetails) GoString() string {
	return s.String()
}

// SetComputeSavingsPlans sets the ComputeSavingsPlans field's value.
func (s *ResourceDetails) SetComputeSavingsPlans(v *ComputeSavingsPlans) *ResourceDetails {
	s.ComputeSavingsPlans = v
	return s
}

// SetEbsVolume sets the EbsVolume field's value.
func (s *ResourceDetails) SetEbsVolume(v *EbsVolume) *ResourceDetails {
	s.EbsVolume = v
	return s
}

// SetEc2AutoScalingGroup sets the Ec2AutoScalingGroup field's value.
func (s *ResourceDetails) SetEc2AutoScalingGroup(v *Ec2AutoScalingGroup) *ResourceDetails {
	s.Ec2AutoScalingGroup = v
	return s
}

// SetEc2Instance sets the Ec2Instance field's value.
func (s *ResourceDetails) SetEc2Instance(v *Ec2Instance) *ResourceDetails {
	s.Ec2Instance = v
	return s
}

// SetEc2InstanceSavingsPlans sets the Ec2InstanceSavingsPlans field's value.
func (s *ResourceDetails) SetEc2InstanceSavingsPlans(v *Ec2InstanceSavingsPlans) *ResourceDetails {
	s.Ec2InstanceSavingsPlans = v
	return s
}

// SetEc2ReservedInstances sets the Ec2ReservedInstances field's value.
func (s *ResourceDetails) SetEc2ReservedInstances(v *Ec2ReservedInstances) *ResourceDetails {
	s.Ec2ReservedInstances = v
	return s
}

// SetEcsService sets the EcsService field's value.
func (s *ResourceDetails) SetEcsService(v *EcsService) *ResourceDetails {
	s.EcsService = v
	return s
}

// SetElastiCacheReservedInstances sets the ElastiCacheReservedInstances field's value.
func (s *ResourceDetails) SetElastiCacheReservedInstances(v *ElastiCacheReservedInstances) *ResourceDetails {
	s.ElastiCacheReservedInstances = v
	return s
}

// SetLambdaFunction sets the LambdaFunction field's value.
func (s *ResourceDetails) SetLambdaFunction(v *LambdaFunction) *ResourceDetails {
	s.LambdaFunction = v
	return s
}

// SetOpenSearchReservedInstances sets the OpenSearchReservedInstances field's value.
func (s *ResourceDetails) SetOpenSearchReservedInstances(v *OpenSearchReservedInstances) *ResourceDetails {
	s.OpenSearchReservedInstances = v
	return s
}

// SetRdsReservedInstances sets the RdsReservedInstances field's value.
func (s *ResourceDetails) SetRdsReservedInstances(v *RdsReservedInstances) *ResourceDetails {
	s.RdsReservedInstances = v
	return s
}

// SetRedshiftReservedInstances sets the RedshiftReservedInstances field's value.
func (s *ResourceDetails) SetRedshiftReservedInstances(v *RedshiftReservedInstances) *ResourceDetails {
	s.RedshiftReservedInstances = v
	return s
}

// SetSageMakerSavingsPlans sets the SageMakerSavingsPlans field's value.
func (s *ResourceDetails) SetSageMakerSavingsPlans(v *SageMakerSavingsPlans) *ResourceDetails {
	s.SageMakerSavingsPlans = v
	return s
}

// The specified Amazon Resource Name (ARN) in the request doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The identifier of the resource that was not found.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains pricing information about the specified resource.
type ResourcePricing struct {
	_ struct{} `type:"structure"`

	// The savings estimate incorporating all discounts with Amazon Web Services,
	// such as Reserved Instances and Savings Plans.
	EstimatedCostAfterDiscounts *float64 `locationName:"estimatedCostAfterDiscounts" type:"double"`

	// The savings estimate using Amazon Web Services public pricing without incorporating
	// any discounts.
	EstimatedCostBeforeDiscounts *float64 `locationName:"estimatedCostBeforeDiscounts" type:"double"`

	// The estimated discounts for a recommendation.
	EstimatedDiscounts *EstimatedDiscounts `locationName:"estimatedDiscounts" type:"structure"`

	// The estimated net unused amortized commitment for the recommendation.
	EstimatedNetUnusedAmortizedCommitments *float64 `locationName:"estimatedNetUnusedAmortizedCommitments" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourcePricing) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourcePricing) GoString() string {
	return s.String()
}

// SetEstimatedCostAfterDiscounts sets the EstimatedCostAfterDiscounts field's value.
func (s *ResourcePricing) SetEstimatedCostAfterDiscounts(v float64) *ResourcePricing {
	s.EstimatedCostAfterDiscounts = &v
	return s
}

// SetEstimatedCostBeforeDiscounts sets the EstimatedCostBeforeDiscounts field's value.
func (s *ResourcePricing) SetEstimatedCostBeforeDiscounts(v float64) *ResourcePricing {
	s.EstimatedCostBeforeDiscounts = &v
	return s
}

// SetEstimatedDiscounts sets the EstimatedDiscounts field's value.
func (s *ResourcePricing) SetEstimatedDiscounts(v *EstimatedDiscounts) *ResourcePricing {
	s.EstimatedDiscounts = v
	return s
}

// SetEstimatedNetUnusedAmortizedCommitments sets the EstimatedNetUnusedAmortizedCommitments field's value.
func (s *ResourcePricing) SetEstimatedNetUnusedAmortizedCommitments(v float64) *ResourcePricing {
	s.EstimatedNetUnusedAmortizedCommitments = &v
	return s
}

// The SageMaker Savings Plans recommendation details.
type SageMakerSavingsPlans struct {
	_ struct{} `type:"structure"`

	// The SageMaker Savings Plans configuration used for recommendations.
	Configuration *SageMakerSavingsPlansConfiguration `locationName:"configuration" type:"structure"`

	// Cost impact of the Savings Plans purchase recommendation.
	CostCalculation *SavingsPlansCostCalculation `locationName:"costCalculation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SageMakerSavingsPlans) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SageMakerSavingsPlans) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *SageMakerSavingsPlans) SetConfiguration(v *SageMakerSavingsPlansConfiguration) *SageMakerSavingsPlans {
	s.Configuration = v
	return s
}

// SetCostCalculation sets the CostCalculation field's value.
func (s *SageMakerSavingsPlans) SetCostCalculation(v *SavingsPlansCostCalculation) *SageMakerSavingsPlans {
	s.CostCalculation = v
	return s
}

// The SageMaker Savings Plans configuration used for recommendations.
type SageMakerSavingsPlansConfiguration struct {
	_ struct{} `type:"structure"`

	// The account scope that you want your recommendations for.
	AccountScope *string `locationName:"accountScope" type:"string"`

	// The hourly commitment for the Savings Plans type.
	HourlyCommitment *string `locationName:"hourlyCommitment" type:"string"`

	// The payment option for the commitment.
	PaymentOption *string `locationName:"paymentOption" type:"string"`

	// The Savings Plans recommendation term in years.
	Term *string `locationName:"term" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SageMakerSavingsPlansConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SageMakerSavingsPlansConfiguration) GoString() string {
	return s.String()
}

// SetAccountScope sets the AccountScope field's value.
func (s *SageMakerSavingsPlansConfiguration) SetAccountScope(v string) *SageMakerSavingsPlansConfiguration {
	s.AccountScope = &v
	return s
}

// SetHourlyCommitment sets the HourlyCommitment field's value.
func (s *SageMakerSavingsPlansConfiguration) SetHourlyCommitment(v string) *SageMakerSavingsPlansConfiguration {
	s.HourlyCommitment = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *SageMakerSavingsPlansConfiguration) SetPaymentOption(v string) *SageMakerSavingsPlansConfiguration {
	s.PaymentOption = &v
	return s
}

// SetTerm sets the Term field's value.
func (s *SageMakerSavingsPlansConfiguration) SetTerm(v string) *SageMakerSavingsPlansConfiguration {
	s.Term = &v
	return s
}

// Cost impact of the purchase recommendation.
type SavingsPlansCostCalculation struct {
	_ struct{} `type:"structure"`

	// Pricing details of the purchase recommendation.
	Pricing *SavingsPlansPricing `locationName:"pricing" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansCostCalculation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansCostCalculation) GoString() string {
	return s.String()
}

// SetPricing sets the Pricing field's value.
func (s *SavingsPlansCostCalculation) SetPricing(v *SavingsPlansPricing) *SavingsPlansCostCalculation {
	s.Pricing = v
	return s
}

// Pricing information about a Savings Plan.
type SavingsPlansPricing struct {
	_ struct{} `type:"structure"`

	// Estimated monthly commitment for the Savings Plan.
	EstimatedMonthlyCommitment *float64 `locationName:"estimatedMonthlyCommitment" type:"double"`

	// Estimated On-Demand cost you will pay after buying the Savings Plan.
	EstimatedOnDemandCost *float64 `locationName:"estimatedOnDemandCost" type:"double"`

	// The cost of paying for the recommended Savings Plan monthly.
	MonthlySavingsPlansEligibleCost *float64 `locationName:"monthlySavingsPlansEligibleCost" type:"double"`

	// Estimated savings as a percentage of your overall costs after buying the
	// Savings Plan.
	SavingsPercentage *float64 `locationName:"savingsPercentage" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansPricing) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansPricing) GoString() string {
	return s.String()
}

// SetEstimatedMonthlyCommitment sets the EstimatedMonthlyCommitment field's value.
func (s *SavingsPlansPricing) SetEstimatedMonthlyCommitment(v float64) *SavingsPlansPricing {
	s.EstimatedMonthlyCommitment = &v
	return s
}

// SetEstimatedOnDemandCost sets the EstimatedOnDemandCost field's value.
func (s *SavingsPlansPricing) SetEstimatedOnDemandCost(v float64) *SavingsPlansPricing {
	s.EstimatedOnDemandCost = &v
	return s
}

// SetMonthlySavingsPlansEligibleCost sets the MonthlySavingsPlansEligibleCost field's value.
func (s *SavingsPlansPricing) SetMonthlySavingsPlansEligibleCost(v float64) *SavingsPlansPricing {
	s.MonthlySavingsPlansEligibleCost = &v
	return s
}

// SetSavingsPercentage sets the SavingsPercentage field's value.
func (s *SavingsPlansPricing) SetSavingsPercentage(v float64) *SavingsPlansPricing {
	s.SavingsPercentage = &v
	return s
}

// The storage configuration used for recommendations.
type StorageConfiguration struct {
	_ struct{} `type:"structure"`

	// The storage volume.
	SizeInGb *float64 `locationName:"sizeInGb" type:"double"`

	// The storage type.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageConfiguration) GoString() string {
	return s.String()
}

// SetSizeInGb sets the SizeInGb field's value.
func (s *StorageConfiguration) SetSizeInGb(v float64) *StorageConfiguration {
	s.SizeInGb = &v
	return s
}

// SetType sets the Type field's value.
func (s *StorageConfiguration) SetType(v string) *StorageConfiguration {
	s.Type = &v
	return s
}

// The tag structure that contains a tag key and value.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key that's associated with the tag.
	Key *string `locationName:"key" type:"string"`

	// The value that's associated with the tag.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateEnrollmentStatusInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether to enroll member accounts of the organization if the account
	// is the management account.
	IncludeMemberAccounts *bool `locationName:"includeMemberAccounts" type:"boolean"`

	// Sets the account status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"EnrollmentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnrollmentStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnrollmentStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnrollmentStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEnrollmentStatusInput"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeMemberAccounts sets the IncludeMemberAccounts field's value.
func (s *UpdateEnrollmentStatusInput) SetIncludeMemberAccounts(v bool) *UpdateEnrollmentStatusInput {
	s.IncludeMemberAccounts = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateEnrollmentStatusInput) SetStatus(v string) *UpdateEnrollmentStatusInput {
	s.Status = &v
	return s
}

type UpdateEnrollmentStatusOutput struct {
	_ struct{} `type:"structure"`

	// The enrollment status of the account.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnrollmentStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnrollmentStatusOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *UpdateEnrollmentStatusOutput) SetStatus(v string) *UpdateEnrollmentStatusOutput {
	s.Status = &v
	return s
}

type UpdatePreferencesInput struct {
	_ struct{} `type:"structure"`

	// Sets the "member account discount visibility" preference.
	MemberAccountDiscountVisibility *string `locationName:"memberAccountDiscountVisibility" type:"string" enum:"MemberAccountDiscountVisibility"`

	// Sets the "savings estimation mode" preference.
	SavingsEstimationMode *string `locationName:"savingsEstimationMode" type:"string" enum:"SavingsEstimationMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePreferencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePreferencesInput) GoString() string {
	return s.String()
}

// SetMemberAccountDiscountVisibility sets the MemberAccountDiscountVisibility field's value.
func (s *UpdatePreferencesInput) SetMemberAccountDiscountVisibility(v string) *UpdatePreferencesInput {
	s.MemberAccountDiscountVisibility = &v
	return s
}

// SetSavingsEstimationMode sets the SavingsEstimationMode field's value.
func (s *UpdatePreferencesInput) SetSavingsEstimationMode(v string) *UpdatePreferencesInput {
	s.SavingsEstimationMode = &v
	return s
}

type UpdatePreferencesOutput struct {
	_ struct{} `type:"structure"`

	// Shows the status of the "member account discount visibility" preference.
	MemberAccountDiscountVisibility *string `locationName:"memberAccountDiscountVisibility" type:"string" enum:"MemberAccountDiscountVisibility"`

	// Shows the status of the "savings estimation mode" preference.
	SavingsEstimationMode *string `locationName:"savingsEstimationMode" type:"string" enum:"SavingsEstimationMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePreferencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePreferencesOutput) GoString() string {
	return s.String()
}

// SetMemberAccountDiscountVisibility sets the MemberAccountDiscountVisibility field's value.
func (s *UpdatePreferencesOutput) SetMemberAccountDiscountVisibility(v string) *UpdatePreferencesOutput {
	s.MemberAccountDiscountVisibility = &v
	return s
}

// SetSavingsEstimationMode sets the SavingsEstimationMode field's value.
func (s *UpdatePreferencesOutput) SetSavingsEstimationMode(v string) *UpdatePreferencesOutput {
	s.SavingsEstimationMode = &v
	return s
}

// Details about the usage.
type Usage struct {
	_ struct{} `type:"structure"`

	// The operation value.
	Operation *string `locationName:"operation" type:"string"`

	// The product code.
	ProductCode *string `locationName:"productCode" type:"string"`

	// The usage unit.
	Unit *string `locationName:"unit" type:"string"`

	// The usage amount.
	UsageAmount *float64 `locationName:"usageAmount" type:"double"`

	// The usage type.
	UsageType *string `locationName:"usageType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Usage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Usage) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *Usage) SetOperation(v string) *Usage {
	s.Operation = &v
	return s
}

// SetProductCode sets the ProductCode field's value.
func (s *Usage) SetProductCode(v string) *Usage {
	s.ProductCode = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *Usage) SetUnit(v string) *Usage {
	s.Unit = &v
	return s
}

// SetUsageAmount sets the UsageAmount field's value.
func (s *Usage) SetUsageAmount(v float64) *Usage {
	s.UsageAmount = &v
	return s
}

// SetUsageType sets the UsageType field's value.
func (s *Usage) SetUsageType(v string) *Usage {
	s.UsageType = &v
	return s
}

// The input fails to satisfy the constraints specified by an Amazon Web Services
// service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The list of fields that are invalid.
	Fields []*ValidationExceptionDetail `locationName:"fields" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason for the validation exception.
	Reason *string `locationName:"reason" type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input failed to meet the constraints specified by the Amazon Web Services
// service in a specified field.
type ValidationExceptionDetail struct {
	_ struct{} `type:"structure"`

	// The field name where the invalid entry was detected.
	//
	// FieldName is a required field
	FieldName *string `locationName:"fieldName" type:"string" required:"true"`

	// A message with the reason for the validation exception error.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionDetail) GoString() string {
	return s.String()
}

// SetFieldName sets the FieldName field's value.
func (s *ValidationExceptionDetail) SetFieldName(v string) *ValidationExceptionDetail {
	s.FieldName = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionDetail) SetMessage(v string) *ValidationExceptionDetail {
	s.Message = &v
	return s
}

const (
	// ActionTypeRightsize is a ActionType enum value
	ActionTypeRightsize = "Rightsize"

	// ActionTypeStop is a ActionType enum value
	ActionTypeStop = "Stop"

	// ActionTypeUpgrade is a ActionType enum value
	ActionTypeUpgrade = "Upgrade"

	// ActionTypePurchaseSavingsPlans is a ActionType enum value
	ActionTypePurchaseSavingsPlans = "PurchaseSavingsPlans"

	// ActionTypePurchaseReservedInstances is a ActionType enum value
	ActionTypePurchaseReservedInstances = "PurchaseReservedInstances"

	// ActionTypeMigrateToGraviton is a ActionType enum value
	ActionTypeMigrateToGraviton = "MigrateToGraviton"
)

// ActionType_Values returns all elements of the ActionType enum
func ActionType_Values() []string {
	return []string{
		ActionTypeRightsize,
		ActionTypeStop,
		ActionTypeUpgrade,
		ActionTypePurchaseSavingsPlans,
		ActionTypePurchaseReservedInstances,
		ActionTypeMigrateToGraviton,
	}
}

const (
	// EnrollmentStatusActive is a EnrollmentStatus enum value
	EnrollmentStatusActive = "Active"

	// EnrollmentStatusInactive is a EnrollmentStatus enum value
	EnrollmentStatusInactive = "Inactive"
)

// EnrollmentStatus_Values returns all elements of the EnrollmentStatus enum
func EnrollmentStatus_Values() []string {
	return []string{
		EnrollmentStatusActive,
		EnrollmentStatusInactive,
	}
}

const (
	// ImplementationEffortVeryLow is a ImplementationEffort enum value
	ImplementationEffortVeryLow = "VeryLow"

	// ImplementationEffortLow is a ImplementationEffort enum value
	ImplementationEffortLow = "Low"

	// ImplementationEffortMedium is a ImplementationEffort enum value
	ImplementationEffortMedium = "Medium"

	// ImplementationEffortHigh is a ImplementationEffort enum value
	ImplementationEffortHigh = "High"

	// ImplementationEffortVeryHigh is a ImplementationEffort enum value
	ImplementationEffortVeryHigh = "VeryHigh"
)

// ImplementationEffort_Values returns all elements of the ImplementationEffort enum
func ImplementationEffort_Values() []string {
	return []string{
		ImplementationEffortVeryLow,
		ImplementationEffortLow,
		ImplementationEffortMedium,
		ImplementationEffortHigh,
		ImplementationEffortVeryHigh,
	}
}

const (
	// MemberAccountDiscountVisibilityAll is a MemberAccountDiscountVisibility enum value
	MemberAccountDiscountVisibilityAll = "All"

	// MemberAccountDiscountVisibilityNone is a MemberAccountDiscountVisibility enum value
	MemberAccountDiscountVisibilityNone = "None"
)

// MemberAccountDiscountVisibility_Values returns all elements of the MemberAccountDiscountVisibility enum
func MemberAccountDiscountVisibility_Values() []string {
	return []string{
		MemberAccountDiscountVisibilityAll,
		MemberAccountDiscountVisibilityNone,
	}
}

const (
	// OrderAsc is a Order enum value
	OrderAsc = "Asc"

	// OrderDesc is a Order enum value
	OrderDesc = "Desc"
)

// Order_Values returns all elements of the Order enum
func Order_Values() []string {
	return []string{
		OrderAsc,
		OrderDesc,
	}
}

const (
	// ResourceTypeEc2instance is a ResourceType enum value
	ResourceTypeEc2instance = "Ec2Instance"

	// ResourceTypeLambdaFunction is a ResourceType enum value
	ResourceTypeLambdaFunction = "LambdaFunction"

	// ResourceTypeEbsVolume is a ResourceType enum value
	ResourceTypeEbsVolume = "EbsVolume"

	// ResourceTypeEcsService is a ResourceType enum value
	ResourceTypeEcsService = "EcsService"

	// ResourceTypeEc2autoScalingGroup is a ResourceType enum value
	ResourceTypeEc2autoScalingGroup = "Ec2AutoScalingGroup"

	// ResourceTypeEc2instanceSavingsPlans is a ResourceType enum value
	ResourceTypeEc2instanceSavingsPlans = "Ec2InstanceSavingsPlans"

	// ResourceTypeComputeSavingsPlans is a ResourceType enum value
	ResourceTypeComputeSavingsPlans = "ComputeSavingsPlans"

	// ResourceTypeSageMakerSavingsPlans is a ResourceType enum value
	ResourceTypeSageMakerSavingsPlans = "SageMakerSavingsPlans"

	// ResourceTypeEc2reservedInstances is a ResourceType enum value
	ResourceTypeEc2reservedInstances = "Ec2ReservedInstances"

	// ResourceTypeRdsReservedInstances is a ResourceType enum value
	ResourceTypeRdsReservedInstances = "RdsReservedInstances"

	// ResourceTypeOpenSearchReservedInstances is a ResourceType enum value
	ResourceTypeOpenSearchReservedInstances = "OpenSearchReservedInstances"

	// ResourceTypeRedshiftReservedInstances is a ResourceType enum value
	ResourceTypeRedshiftReservedInstances = "RedshiftReservedInstances"

	// ResourceTypeElastiCacheReservedInstances is a ResourceType enum value
	ResourceTypeElastiCacheReservedInstances = "ElastiCacheReservedInstances"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeEc2instance,
		ResourceTypeLambdaFunction,
		ResourceTypeEbsVolume,
		ResourceTypeEcsService,
		ResourceTypeEc2autoScalingGroup,
		ResourceTypeEc2instanceSavingsPlans,
		ResourceTypeComputeSavingsPlans,
		ResourceTypeSageMakerSavingsPlans,
		ResourceTypeEc2reservedInstances,
		ResourceTypeRdsReservedInstances,
		ResourceTypeOpenSearchReservedInstances,
		ResourceTypeRedshiftReservedInstances,
		ResourceTypeElastiCacheReservedInstances,
	}
}

const (
	// SavingsEstimationModeBeforeDiscounts is a SavingsEstimationMode enum value
	SavingsEstimationModeBeforeDiscounts = "BeforeDiscounts"

	// SavingsEstimationModeAfterDiscounts is a SavingsEstimationMode enum value
	SavingsEstimationModeAfterDiscounts = "AfterDiscounts"
)

// SavingsEstimationMode_Values returns all elements of the SavingsEstimationMode enum
func SavingsEstimationMode_Values() []string {
	return []string{
		SavingsEstimationModeBeforeDiscounts,
		SavingsEstimationModeAfterDiscounts,
	}
}

const (
	// SourceComputeOptimizer is a Source enum value
	SourceComputeOptimizer = "ComputeOptimizer"

	// SourceCostExplorer is a Source enum value
	SourceCostExplorer = "CostExplorer"
)

// Source_Values returns all elements of the Source enum
func Source_Values() []string {
	return []string{
		SourceComputeOptimizer,
		SourceCostExplorer,
	}
}

const (
	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "Other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
