// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appintegrationsservice_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/appintegrationsservice"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To create an application
// The following creates an application named My Application with access url https://example.com.
func ExampleAppIntegrationsService_CreateApplication_shared00() {
	svc := appintegrationsservice.New(session.New())
	input := &appintegrationsservice.CreateApplicationInput{
		ApplicationSourceConfig: &appintegrationsservice.ApplicationSourceConfig{
			ExternalUrlConfig: &appintegrationsservice.ExternalUrlConfig{
				AccessUrl: aws.String("https://example.com"),
			},
		},
		Description: aws.String("My first application."),
		Name:        aws.String("My Application"),
		Namespace:   aws.String("myapplication"),
	}

	result, err := svc.CreateApplication(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appintegrationsservice.ErrCodeInternalServiceError:
				fmt.Println(appintegrationsservice.ErrCodeInternalServiceError, aerr.Error())
			case appintegrationsservice.ErrCodeResourceQuotaExceededException:
				fmt.Println(appintegrationsservice.ErrCodeResourceQuotaExceededException, aerr.Error())
			case appintegrationsservice.ErrCodeDuplicateResourceException:
				fmt.Println(appintegrationsservice.ErrCodeDuplicateResourceException, aerr.Error())
			case appintegrationsservice.ErrCodeThrottlingException:
				fmt.Println(appintegrationsservice.ErrCodeThrottlingException, aerr.Error())
			case appintegrationsservice.ErrCodeInvalidRequestException:
				fmt.Println(appintegrationsservice.ErrCodeInvalidRequestException, aerr.Error())
			case appintegrationsservice.ErrCodeAccessDeniedException:
				fmt.Println(appintegrationsservice.ErrCodeAccessDeniedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get an application
// The following retrives an application.
func ExampleAppIntegrationsService_GetApplication_shared00() {
	svc := appintegrationsservice.New(session.New())
	input := &appintegrationsservice.GetApplicationInput{
		Arn: aws.String("arn:aws:app-integrations:us-west-2:0123456789012:application/98542c53-e8ac-4570-9c85-c6552c8d9c5e"),
	}

	result, err := svc.GetApplication(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appintegrationsservice.ErrCodeInternalServiceError:
				fmt.Println(appintegrationsservice.ErrCodeInternalServiceError, aerr.Error())
			case appintegrationsservice.ErrCodeThrottlingException:
				fmt.Println(appintegrationsservice.ErrCodeThrottlingException, aerr.Error())
			case appintegrationsservice.ErrCodeResourceNotFoundException:
				fmt.Println(appintegrationsservice.ErrCodeResourceNotFoundException, aerr.Error())
			case appintegrationsservice.ErrCodeInvalidRequestException:
				fmt.Println(appintegrationsservice.ErrCodeInvalidRequestException, aerr.Error())
			case appintegrationsservice.ErrCodeAccessDeniedException:
				fmt.Println(appintegrationsservice.ErrCodeAccessDeniedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list applications in the account
// The following lists application summary in the account.
func ExampleAppIntegrationsService_ListApplications_shared00() {
	svc := appintegrationsservice.New(session.New())
	input := &appintegrationsservice.ListApplicationsInput{
		MaxResults: aws.Int64(1),
	}

	result, err := svc.ListApplications(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appintegrationsservice.ErrCodeInternalServiceError:
				fmt.Println(appintegrationsservice.ErrCodeInternalServiceError, aerr.Error())
			case appintegrationsservice.ErrCodeThrottlingException:
				fmt.Println(appintegrationsservice.ErrCodeThrottlingException, aerr.Error())
			case appintegrationsservice.ErrCodeInvalidRequestException:
				fmt.Println(appintegrationsservice.ErrCodeInvalidRequestException, aerr.Error())
			case appintegrationsservice.ErrCodeAccessDeniedException:
				fmt.Println(appintegrationsservice.ErrCodeAccessDeniedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update an application
// The following updates an existing application named with a new name.
func ExampleAppIntegrationsService_UpdateApplication_shared00() {
	svc := appintegrationsservice.New(session.New())
	input := &appintegrationsservice.UpdateApplicationInput{
		Arn:  aws.String("arn:aws:app-integrations:us-west-2:0123456789012:application/98542c53-e8ac-4570-9c85-c6552c8d9c5e"),
		Name: aws.String("My New Application Name"),
	}

	result, err := svc.UpdateApplication(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appintegrationsservice.ErrCodeInternalServiceError:
				fmt.Println(appintegrationsservice.ErrCodeInternalServiceError, aerr.Error())
			case appintegrationsservice.ErrCodeThrottlingException:
				fmt.Println(appintegrationsservice.ErrCodeThrottlingException, aerr.Error())
			case appintegrationsservice.ErrCodeResourceNotFoundException:
				fmt.Println(appintegrationsservice.ErrCodeResourceNotFoundException, aerr.Error())
			case appintegrationsservice.ErrCodeInvalidRequestException:
				fmt.Println(appintegrationsservice.ErrCodeInvalidRequestException, aerr.Error())
			case appintegrationsservice.ErrCodeAccessDeniedException:
				fmt.Println(appintegrationsservice.ErrCodeAccessDeniedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
